/* accounts-editor.c generated by valac 0.56.3, the Vala compiler
 * generated from accounts-editor.vala, do not modify */

/*
 * Copyright 2018-2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gdk/gdk.h>
#include "geary-engine.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define ACCOUNTS_TYPE_EDITOR_LIST_PANE (accounts_editor_list_pane_get_type ())
#define ACCOUNTS_EDITOR_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_EDITOR_LIST_PANE, AccountsEditorListPane))
#define ACCOUNTS_EDITOR_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ACCOUNTS_TYPE_EDITOR_LIST_PANE, AccountsEditorListPaneClass))
#define ACCOUNTS_IS_EDITOR_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_EDITOR_LIST_PANE))
#define ACCOUNTS_IS_EDITOR_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ACCOUNTS_TYPE_EDITOR_LIST_PANE))
#define ACCOUNTS_EDITOR_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ACCOUNTS_TYPE_EDITOR_LIST_PANE, AccountsEditorListPaneClass))

typedef struct _AccountsEditorListPane AccountsEditorListPane;
typedef struct _AccountsEditorListPaneClass AccountsEditorListPaneClass;

#define ACCOUNTS_TYPE_EDITOR_PANE (accounts_editor_pane_get_type ())
#define ACCOUNTS_EDITOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPane))
#define ACCOUNTS_IS_EDITOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_EDITOR_PANE))
#define ACCOUNTS_EDITOR_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPaneIface))

typedef struct _AccountsEditorPane AccountsEditorPane;
typedef struct _AccountsEditorPaneIface AccountsEditorPaneIface;
enum  {
	ACCOUNTS_EDITOR_0_PROPERTY,
	ACCOUNTS_EDITOR_APPLICATION_PROPERTY,
	ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY,
	ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY,
	ACCOUNTS_EDITOR_NUM_PROPERTIES
};
static GParamSpec* accounts_editor_properties[ACCOUNTS_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AccountsEditorPromptPinCertificateData AccountsEditorPromptPinCertificateData;

#define ACCOUNTS_TYPE_COMMAND_PANE (accounts_command_pane_get_type ())
#define ACCOUNTS_COMMAND_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_COMMAND_PANE, AccountsCommandPane))
#define ACCOUNTS_IS_COMMAND_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_COMMAND_PANE))
#define ACCOUNTS_COMMAND_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ACCOUNTS_TYPE_COMMAND_PANE, AccountsCommandPaneIface))

typedef struct _AccountsCommandPane AccountsCommandPane;
typedef struct _AccountsCommandPaneIface AccountsCommandPaneIface;
typedef struct _Block39Data Block39Data;

#define ACCOUNTS_TYPE_ACCOUNT_PANE (accounts_account_pane_get_type ())
#define ACCOUNTS_ACCOUNT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACCOUNTS_TYPE_ACCOUNT_PANE, AccountsAccountPane))
#define ACCOUNTS_IS_ACCOUNT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACCOUNTS_TYPE_ACCOUNT_PANE))
#define ACCOUNTS_ACCOUNT_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ACCOUNTS_TYPE_ACCOUNT_PANE, AccountsAccountPaneIface))

typedef struct _AccountsAccountPane AccountsAccountPane;
typedef struct _AccountsAccountPaneIface AccountsAccountPaneIface;

struct _AccountsEditorPaneIface {
	GTypeInterface parent_iface;
	AccountsEditor* (*get_editor) (AccountsEditorPane* self);
	void (*set_editor) (AccountsEditorPane* self, AccountsEditor* value);
	GtkWidget* (*get_initial_widget) (AccountsEditorPane* self);
	gboolean (*get_is_operation_running) (AccountsEditorPane* self);
	void (*set_is_operation_running) (AccountsEditorPane* self, gboolean value);
	GCancellable* (*get_op_cancellable) (AccountsEditorPane* self);
	void (*set_op_cancellable) (AccountsEditorPane* self, GCancellable* value);
	GtkHeaderBar* (*get_header) (AccountsEditorPane* self);
};

struct _AccountsEditorPrivate {
	AccountsManager* _accounts;
	ApplicationCertificateManager* _certificates;
	GSimpleActionGroup* edit_actions;
	GtkOverlay* notifications_pane;
	GtkStack* editor_panes;
	AccountsEditorListPane* editor_list_pane;
	GeeLinkedList* editor_pane_stack;
};

struct _AccountsEditorPromptPinCertificateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountsEditor* self;
	GearyAccountInformation* account;
	GearyServiceInformation* service;
	GearyEndpoint* endpoint;
	GCancellable* cancellable;
	ApplicationCertificateManager* _tmp0_;
	GError* err;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _vala1_err;
	ComponentsInAppNotification* _tmp3_;
	ComponentsInAppNotification* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _vala2_err;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _inner_error0_;
};

struct _AccountsCommandPaneIface {
	GTypeInterface parent_iface;
	ApplicationCommandStack* (*get_commands) (AccountsCommandPane* self);
	void (*set_commands) (AccountsCommandPane* self, ApplicationCommandStack* value);
	void (*undo) (AccountsCommandPane* self);
	void (*redo) (AccountsCommandPane* self);
	void (*command_executed) (AccountsCommandPane* self);
};

struct _Block39Data {
	int _ref_count_;
	AccountsEditor* self;
	AccountsEditorPane* visible;
};

struct _AccountsAccountPaneIface {
	GTypeInterface parent_iface;
	GearyAccountInformation* (*get_account) (AccountsAccountPane* self);
	void (*set_account) (AccountsAccountPane* self, GearyAccountInformation* value);
};

static gint AccountsEditor_private_offset;
static gpointer accounts_editor_parent_class = NULL;

VALA_EXTERN GType accounts_editor_list_pane_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType accounts_editor_pane_get_type (void) G_GNUC_CONST ;
static void accounts_editor_on_redo (AccountsEditor* self);
static void _accounts_editor_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void accounts_editor_on_undo (AccountsEditor* self);
static void _accounts_editor_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN void accounts_editor_seperator_headers (GtkListBoxRow* row,
                                        GtkListBoxRow* first);
VALA_EXTERN AccountsManager* accounts_editor_get_accounts (AccountsEditor* self);
static void accounts_editor_set_accounts (AccountsEditor* self,
                                   AccountsManager* value);
VALA_EXTERN ApplicationCertificateManager* accounts_editor_get_certificates (AccountsEditor* self);
static void accounts_editor_set_certificates (AccountsEditor* self,
                                       ApplicationCertificateManager* value);
VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
VALA_EXTERN AccountsManager* application_controller_get_account_manager (ApplicationController* self);
VALA_EXTERN ApplicationCertificateManager* application_controller_get_certificate_manager (ApplicationController* self);
VALA_EXTERN AccountsEditorListPane* accounts_editor_list_pane_new (AccountsEditor* editor);
VALA_EXTERN AccountsEditorListPane* accounts_editor_list_pane_construct (GType object_type,
                                                             AccountsEditor* editor);
VALA_EXTERN void accounts_editor_push (AccountsEditor* self,
                           AccountsEditorPane* pane);
VALA_EXTERN void accounts_editor_update_command_actions (AccountsEditor* self);
static gboolean accounts_editor_real_key_press_event (GtkWidget* base,
                                               GdkEventKey* event);
static inline AccountsEditorPane* accounts_editor_get_current_pane (AccountsEditor* self);
VALA_EXTERN gboolean accounts_editor_pane_get_is_operation_running (AccountsEditorPane* self);
VALA_EXTERN void accounts_editor_pane_cancel_operation (AccountsEditorPane* self);
VALA_EXTERN void accounts_editor_pop (AccountsEditor* self);
VALA_EXTERN void accounts_editor_add_notification (AccountsEditor* self,
                                       ComponentsInAppNotification* notification);
static void accounts_editor_prompt_pin_certificate_data_free (gpointer _data);
VALA_EXTERN void accounts_editor_prompt_pin_certificate (AccountsEditor* self,
                                             GearyAccountInformation* account,
                                             GearyServiceInformation* service,
                                             GearyEndpoint* endpoint,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void accounts_editor_prompt_pin_certificate_finish (AccountsEditor* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static gboolean accounts_editor_prompt_pin_certificate_co (AccountsEditorPromptPinCertificateData* _data_);
static void accounts_editor_prompt_pin_certificate_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN void accounts_editor_remove_account (AccountsEditor* self,
                                     GearyAccountInformation* account);
VALA_EXTERN void accounts_editor_list_pane_remove_account (AccountsEditorListPane* self,
                                               GearyAccountInformation* account);
VALA_EXTERN GType accounts_command_pane_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationCommandStack* accounts_command_pane_get_commands (AccountsCommandPane* self);
static inline GSimpleAction* accounts_editor_get_action (AccountsEditor* self,
                                           const gchar* name);
VALA_EXTERN void accounts_command_pane_undo (AccountsCommandPane* self);
VALA_EXTERN void accounts_command_pane_redo (AccountsCommandPane* self);
static void accounts_editor_on_pane_changed (AccountsEditor* self);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static gboolean ___lambda100_ (Block39Data* _data39_);
VALA_EXTERN GtkWidget* accounts_editor_pane_get_initial_widget (AccountsEditorPane* self);
static gboolean ____lambda100__gsource_func (gpointer self);
VALA_EXTERN GtkHeaderBar* accounts_editor_pane_get_header (AccountsEditorPane* self);
static void _accounts_editor_on_pane_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void accounts_editor_finalize (GObject * obj);
static GType accounts_editor_get_type_once (void);
static void _vala_accounts_editor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_accounts_editor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
VALA_EXTERN AccountsEditor* accounts_editor_pane_get_editor (AccountsEditorPane* self);
VALA_EXTERN void accounts_editor_pane_set_editor (AccountsEditorPane* self,
                                      AccountsEditor* value);
VALA_EXTERN void accounts_editor_pane_set_is_operation_running (AccountsEditorPane* self,
                                                    gboolean value);
VALA_EXTERN GCancellable* accounts_editor_pane_get_op_cancellable (AccountsEditorPane* self);
VALA_EXTERN void accounts_editor_pane_set_op_cancellable (AccountsEditorPane* self,
                                              GCancellable* value);
static GType accounts_editor_pane_get_type_once (void);
VALA_EXTERN GType accounts_account_pane_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyAccountInformation* accounts_account_pane_get_account (AccountsAccountPane* self);
VALA_EXTERN void accounts_account_pane_set_account (AccountsAccountPane* self,
                                        GearyAccountInformation* value);
VALA_EXTERN void accounts_account_pane_connect_account_signals (AccountsAccountPane* self);
static void accounts_account_pane_on_account_changed (AccountsAccountPane* self);
static void _accounts_account_pane_on_account_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                                  gpointer self);
static inline void accounts_account_pane_update_header (AccountsAccountPane* self);
VALA_EXTERN void accounts_account_pane_disconnect_account_signals (AccountsAccountPane* self);
static void accounts_account_pane_account_changed (AccountsAccountPane* self);
static GType accounts_account_pane_get_type_once (void);
VALA_EXTERN void accounts_command_pane_set_commands (AccountsCommandPane* self,
                                         ApplicationCommandStack* value);
static void accounts_command_pane_real_undo (AccountsCommandPane* self);
static void accounts_command_pane_real_redo (AccountsCommandPane* self);
VALA_EXTERN void accounts_command_pane_connect_command_signals (AccountsCommandPane* self);
static void accounts_command_pane_on_command (AccountsCommandPane* self);
static void _accounts_command_pane_on_command_application_command_stack_executed (ApplicationCommandStack* _sender,
                                                                           ApplicationCommand* command,
                                                                           gpointer self);
static void _accounts_command_pane_on_command_application_command_stack_undone (ApplicationCommandStack* _sender,
                                                                         ApplicationCommand* command,
                                                                         gpointer self);
static void _accounts_command_pane_on_command_application_command_stack_redone (ApplicationCommandStack* _sender,
                                                                         ApplicationCommand* command,
                                                                         gpointer self);
VALA_EXTERN void accounts_command_pane_disconnect_command_signals (AccountsCommandPane* self);
VALA_EXTERN void accounts_command_pane_command_executed (AccountsCommandPane* self);
static void accounts_command_pane_real_command_executed (AccountsCommandPane* self);
static GType accounts_command_pane_get_type_once (void);

static const GActionEntry ACCOUNTS_EDITOR_EDIT_ACTIONS[2] = {{ACTION_EDIT_REDO, _accounts_editor_on_redo_gsimple_action_activate_callback}, {ACTION_EDIT_UNDO, _accounts_editor_on_undo_gsimple_action_activate_callback}};

static inline gpointer
accounts_editor_get_instance_private (AccountsEditor* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsEditor_private_offset);
}

static void
_accounts_editor_on_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	accounts_editor_on_redo ((AccountsEditor*) self);
}

static void
_accounts_editor_on_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	accounts_editor_on_undo ((AccountsEditor*) self);
}

void
accounts_editor_seperator_headers (GtkListBoxRow* row,
                                   GtkListBoxRow* first)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (row, gtk_list_box_row_get_type ()));
	g_return_if_fail ((first == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (first, gtk_list_box_row_get_type ()));
	if (first == NULL) {
		gtk_list_box_row_set_header (row, NULL);
	} else {
		GtkWidget* _tmp0_;
		_tmp0_ = gtk_list_box_row_get_header (row);
		if (_tmp0_ == NULL) {
			GtkSeparator* _tmp1_;
			GtkSeparator* _tmp2_;
			_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			g_object_ref_sink (_tmp1_);
			_tmp2_ = _tmp1_;
			gtk_list_box_row_set_header (row, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (_tmp2_);
		}
	}
}

ApplicationClient*
accounts_editor_get_application (AccountsEditor* self)
{
	ApplicationClient* result;
	GtkApplication* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR (self), NULL);
	_tmp0_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_window_get_type (), GtkWindow));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, APPLICATION_TYPE_CLIENT, ApplicationClient);
	return result;
}

void
accounts_editor_set_application (AccountsEditor* self,
                                 ApplicationClient* value)
{
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (value, gtk_application_get_type (), GtkApplication));
	g_object_notify_by_pspec ((GObject *) self, accounts_editor_properties[ACCOUNTS_EDITOR_APPLICATION_PROPERTY]);
}

AccountsManager*
accounts_editor_get_accounts (AccountsEditor* self)
{
	AccountsManager* result;
	AccountsManager* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR (self), NULL);
	_tmp0_ = self->priv->_accounts;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
accounts_editor_set_accounts (AccountsEditor* self,
                              AccountsManager* value)
{
	AccountsManager* old_value;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	old_value = accounts_editor_get_accounts (self);
	if (old_value != value) {
		AccountsManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_accounts);
		self->priv->_accounts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, accounts_editor_properties[ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY]);
	}
}

ApplicationCertificateManager*
accounts_editor_get_certificates (AccountsEditor* self)
{
	ApplicationCertificateManager* result;
	ApplicationCertificateManager* _tmp0_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR (self), NULL);
	_tmp0_ = self->priv->_certificates;
	result = _tmp0_;
	return result;
}

static void
accounts_editor_set_certificates (AccountsEditor* self,
                                  ApplicationCertificateManager* value)
{
	ApplicationCertificateManager* old_value;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	old_value = accounts_editor_get_certificates (self);
	if (old_value != value) {
		ApplicationCertificateManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_certificates);
		self->priv->_certificates = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, accounts_editor_properties[ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY]);
	}
}

AccountsEditor*
accounts_editor_construct (GType object_type,
                           ApplicationClient* application,
                           GtkWindow* parent)
{
	AccountsEditor * self = NULL;
	ApplicationController* _tmp0_;
	ApplicationController* _tmp1_;
	AccountsManager* _tmp2_;
	AccountsManager* _tmp3_;
	ApplicationController* _tmp4_;
	ApplicationController* _tmp5_;
	ApplicationCertificateManager* _tmp6_;
	ApplicationCertificateManager* _tmp7_;
	GtkBox* _tmp8_;
	ApplicationController* _tmp9_;
	ApplicationController* _tmp10_;
	AccountsManager* _tmp11_;
	AccountsManager* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GSimpleActionGroup* _tmp14_;
	AccountsEditorListPane* _tmp15_;
	AccountsEditorListPane* _tmp16_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (application), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), NULL);
	self = (AccountsEditor*) g_object_new (object_type, NULL);
	accounts_editor_set_application (self, application);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), parent);
	gtk_window_set_icon_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), APPLICATION_CLIENT_APP_ID);
	_tmp0_ = application_client_get_controller (application);
	_tmp1_ = _tmp0_;
	_tmp2_ = application_controller_get_account_manager (_tmp1_);
	_tmp3_ = _tmp2_;
	accounts_editor_set_accounts (self, _tmp3_);
	_tmp4_ = application_client_get_controller (application);
	_tmp5_ = _tmp4_;
	_tmp6_ = application_controller_get_certificate_manager (_tmp5_);
	_tmp7_ = _tmp6_;
	accounts_editor_set_certificates (self, _tmp7_);
	_tmp8_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp9_ = application_client_get_controller (application);
	_tmp10_ = _tmp9_;
	_tmp11_ = application_controller_get_account_manager (_tmp10_);
	_tmp12_ = _tmp11_;
	accounts_editor_set_accounts (self, _tmp12_);
	_tmp13_ = self->priv->edit_actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_action_map_get_type (), GActionMap), ACCOUNTS_EDITOR_EDIT_ACTIONS, (gint) G_N_ELEMENTS (ACCOUNTS_EDITOR_EDIT_ACTIONS), self);
	_tmp14_ = self->priv->edit_actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), ACTION_EDIT_GROUP_NAME, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_action_group_get_type (), GActionGroup));
	_tmp15_ = accounts_editor_list_pane_new (self);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->editor_list_pane);
	self->priv->editor_list_pane = _tmp15_;
	_tmp16_ = self->priv->editor_list_pane;
	accounts_editor_push (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPane));
	accounts_editor_update_command_actions (self);
	return self;
}

AccountsEditor*
accounts_editor_new (ApplicationClient* application,
                     GtkWindow* parent)
{
	return accounts_editor_construct (ACCOUNTS_TYPE_EDITOR, application, parent);
}

static gboolean
accounts_editor_real_key_press_event (GtkWidget* base,
                                      GdkEventKey* event)
{
	AccountsEditor * self;
	gboolean ret = FALSE;
	AccountsEditorPane* current_pane = NULL;
	AccountsEditorPane* _tmp0_;
	gboolean _tmp1_ = FALSE;
	AccountsEditorPane* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, ACCOUNTS_TYPE_EDITOR, AccountsEditor);
	g_return_val_if_fail (event != NULL, FALSE);
	ret = GDK_EVENT_PROPAGATE;
	_tmp0_ = accounts_editor_get_current_pane (self);
	current_pane = _tmp0_;
	_tmp2_ = current_pane;
	if (_tmp2_ != NULL) {
		AccountsEditorPane* _tmp3_;
		AccountsEditorListPane* _tmp4_;
		_tmp3_ = current_pane;
		_tmp4_ = self->priv->editor_list_pane;
		_tmp1_ = _tmp3_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPane);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkModifierType state = 0U;
		gboolean is_ltr = FALSE;
		state = event->state & gtk_accelerator_get_default_mod_mask ();
		is_ltr = gtk_widget_get_direction (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) == GTK_TEXT_DIR_LTR;
		switch (event->keyval) {
			case GDK_KEY_Escape:
			{
				AccountsEditorPane* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = current_pane;
				_tmp6_ = accounts_editor_pane_get_is_operation_running (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_) {
					AccountsEditorPane* _tmp8_;
					_tmp8_ = current_pane;
					accounts_editor_pane_cancel_operation (_tmp8_);
				} else {
					accounts_editor_pop (self);
				}
				ret = GDK_EVENT_STOP;
				break;
			}
			case GDK_KEY_Back:
			{
				AccountsEditorPane* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = current_pane;
				_tmp10_ = accounts_editor_pane_get_is_operation_running (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					accounts_editor_pop (self);
					ret = GDK_EVENT_STOP;
				}
				break;
			}
			case GDK_KEY_Left:
			{
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				AccountsEditorPane* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = current_pane;
				_tmp15_ = accounts_editor_pane_get_is_operation_running (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					_tmp13_ = state == GDK_MOD1_MASK;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_tmp12_ = is_ltr;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					accounts_editor_pop (self);
					ret = GDK_EVENT_STOP;
				}
				break;
			}
			case GDK_KEY_Right:
			{
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				AccountsEditorPane* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = current_pane;
				_tmp20_ = accounts_editor_pane_get_is_operation_running (_tmp19_);
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					_tmp18_ = state == GDK_MOD1_MASK;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					_tmp17_ = !is_ltr;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					accounts_editor_pop (self);
					ret = GDK_EVENT_STOP;
				}
				break;
			}
			default:
			break;
		}
	}
	if (ret != GDK_EVENT_STOP) {
		ret = GTK_WIDGET_CLASS (accounts_editor_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget), event);
	}
	result = ret;
	_g_object_unref0 (current_pane);
	return result;
}

/**
     * Adds and shows a new pane in the editor.
     */
void
accounts_editor_push (AccountsEditor* self,
                      AccountsEditorPane* pane)
{
	AccountsEditorPane* current = NULL;
	AccountsEditorPane* _tmp0_;
	gint target_length = 0;
	GeeLinkedList* _tmp1_;
	AccountsEditorPane* _tmp2_;
	GeeLinkedList* _tmp10_;
	GtkStack* _tmp11_;
	GtkStack* _tmp12_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	g_return_if_fail (ACCOUNTS_IS_EDITOR_PANE (pane));
	_tmp0_ = accounts_editor_get_current_pane (self);
	current = _tmp0_;
	_tmp1_ = self->priv->editor_pane_stack;
	_tmp2_ = current;
	target_length = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp2_) + 1;
	while (TRUE) {
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		AccountsEditorPane* old = NULL;
		GeeLinkedList* _tmp6_;
		gpointer _tmp7_;
		GtkStack* _tmp8_;
		AccountsEditorPane* _tmp9_;
		_tmp3_ = self->priv->editor_pane_stack;
		_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp5_ = _tmp4_;
		if (!(target_length < _tmp5_)) {
			break;
		}
		_tmp6_ = self->priv->editor_pane_stack;
		_tmp7_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), target_length);
		old = (AccountsEditorPane*) _tmp7_;
		_tmp8_ = self->priv->editor_panes;
		_tmp9_ = old;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (old);
	}
	_tmp10_ = self->priv->editor_pane_stack;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), pane);
	_tmp11_ = self->priv->editor_panes;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (pane, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = self->priv->editor_panes;
	gtk_stack_set_visible_child (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (pane, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (current);
}

/**
     * Removes the current pane from the editor, showing the last one.
     */
void
accounts_editor_pop (AccountsEditor* self)
{
	AccountsEditorPane* current = NULL;
	AccountsEditorPane* _tmp0_;
	gint prev_index = 0;
	GeeLinkedList* _tmp1_;
	AccountsEditorPane* prev = NULL;
	GeeLinkedList* _tmp2_;
	gpointer _tmp3_;
	GtkStack* _tmp4_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	_tmp0_ = accounts_editor_get_current_pane (self);
	current = _tmp0_;
	_tmp1_ = self->priv->editor_pane_stack;
	prev_index = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), current) - 1;
	_tmp2_ = self->priv->editor_pane_stack;
	_tmp3_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), prev_index);
	prev = (AccountsEditorPane*) _tmp3_;
	_tmp4_ = self->priv->editor_panes;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (prev, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (prev);
	_g_object_unref0 (current);
}

/** Displays an in-app notification in the dialog. */
void
accounts_editor_add_notification (AccountsEditor* self,
                                  ComponentsInAppNotification* notification)
{
	GtkOverlay* _tmp0_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	g_return_if_fail (COMPONENTS_IS_IN_APP_NOTIFICATION (notification));
	_tmp0_ = self->priv->notifications_pane;
	gtk_overlay_add_overlay (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (notification, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (notification, gtk_widget_get_type (), GtkWidget));
}

static void
accounts_editor_prompt_pin_certificate_data_free (gpointer _data)
{
	AccountsEditorPromptPinCertificateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->service);
	_g_object_unref0 (_data_->endpoint);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountsEditorPromptPinCertificateData, _data_);
}

void
accounts_editor_prompt_pin_certificate (AccountsEditor* self,
                                        GearyAccountInformation* account,
                                        GearyServiceInformation* service,
                                        GearyEndpoint* endpoint,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	AccountsEditorPromptPinCertificateData* _data_;
	AccountsEditor* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GearyEndpoint* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (service, GEARY_TYPE_SERVICE_INFORMATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (endpoint, GEARY_TYPE_ENDPOINT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (AccountsEditorPromptPinCertificateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, accounts_editor_prompt_pin_certificate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = _g_object_ref0 (endpoint);
	_g_object_unref0 (_data_->endpoint);
	_data_->endpoint = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	accounts_editor_prompt_pin_certificate_co (_data_);
}

void
accounts_editor_prompt_pin_certificate_finish (AccountsEditor* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	AccountsEditorPromptPinCertificateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Prompts for pinning a certificate using the certificate manager.
     *
     * This provides a thing wrapper around {@link
     * Application.CertificateManager.prompt_pin_certificate} that
     * uses the account editor as the dialog parent.
     */
static void
accounts_editor_prompt_pin_certificate_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	AccountsEditorPromptPinCertificateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	accounts_editor_prompt_pin_certificate_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
accounts_editor_prompt_pin_certificate_co (AccountsEditorPromptPinCertificateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_certificates;
		_data_->_state_ = 1;
		application_certificate_manager_prompt_pin_certificate (_data_->_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_window_get_type (), GtkWindow), _data_->account, _data_->service, _data_->endpoint, TRUE, _data_->cancellable, accounts_editor_prompt_pin_certificate_ready, _data_);
		return FALSE;
		_state_1:
		application_certificate_manager_prompt_pin_certificate_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, APPLICATION_CERTIFICATE_MANAGER_ERROR, APPLICATION_CERTIFICATE_MANAGER_ERROR_UNTRUSTED)) {
				goto __catch0_application_certificate_manager_error_untrusted;
			}
			if (g_error_matches (_data_->_inner_error0_, APPLICATION_CERTIFICATE_MANAGER_ERROR, APPLICATION_CERTIFICATE_MANAGER_ERROR_STORE_FAILED)) {
				goto __catch0_application_certificate_manager_error_store_failed;
			}
			if (_data_->_inner_error0_->domain == APPLICATION_CERTIFICATE_MANAGER_ERROR) {
				goto __catch0_application_certificate_manager_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_application_certificate_manager_error_untrusted:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->err;
		_data_->_tmp2_ = _g_error_copy0 (_data_->_tmp1_);
		_data_->_inner_error0_ = _data_->_tmp2_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	goto __finally0;
	__catch0_application_certificate_manager_error_store_failed:
	{
		_data_->_vala1_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = components_in_app_notification_new (_ ("Failed to store certificate"), COMPONENTS_IN_APP_NOTIFICATION_DEFAULT_DURATION);
		g_object_ref_sink (_data_->_tmp3_);
		_data_->_tmp4_ = _data_->_tmp3_;
		accounts_editor_add_notification (_data_->self, _data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_tmp5_ = _data_->_vala1_err;
		_data_->_tmp6_ = _g_error_copy0 (_data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		_g_error_free0 (_data_->_vala1_err);
		goto __finally0;
	}
	goto __finally0;
	__catch0_application_certificate_manager_error:
	{
		_data_->_vala2_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->_vala2_err;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_debug ("accounts-editor.vala:213: Unexpected error pinning cert: %s", _data_->_tmp8_);
		_data_->_tmp9_ = _data_->_vala2_err;
		_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
		_data_->_inner_error0_ = _data_->_tmp10_;
		_g_error_free0 (_data_->_vala2_err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == APPLICATION_CERTIFICATE_MANAGER_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Removes an account from the editor. */
void
accounts_editor_remove_account (AccountsEditor* self,
                                GearyAccountInformation* account)
{
	GtkStack* _tmp0_;
	AccountsEditorListPane* _tmp1_;
	AccountsEditorListPane* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	_tmp0_ = self->priv->editor_panes;
	_tmp1_ = self->priv->editor_list_pane;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->editor_list_pane;
	accounts_editor_list_pane_remove_account (_tmp2_, account);
}

/** Updates the state of the editor's undo and redo actions. */
void
accounts_editor_update_command_actions (AccountsEditor* self)
{
	gboolean can_undo = FALSE;
	gboolean can_redo = FALSE;
	AccountsCommandPane* pane = NULL;
	AccountsEditorPane* _tmp0_;
	AccountsCommandPane* _tmp1_;
	AccountsCommandPane* _tmp2_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	can_undo = FALSE;
	can_redo = FALSE;
	_tmp0_ = accounts_editor_get_current_pane (self);
	_tmp1_ = ACCOUNTS_IS_COMMAND_PANE (_tmp0_) ? ((AccountsCommandPane*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	pane = _tmp1_;
	_tmp2_ = pane;
	if (_tmp2_ != NULL) {
		AccountsCommandPane* _tmp3_;
		ApplicationCommandStack* _tmp4_;
		ApplicationCommandStack* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		AccountsCommandPane* _tmp8_;
		ApplicationCommandStack* _tmp9_;
		ApplicationCommandStack* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp3_ = pane;
		_tmp4_ = accounts_command_pane_get_commands (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = application_command_stack_get_can_undo (_tmp5_);
		_tmp7_ = _tmp6_;
		can_undo = _tmp7_;
		_tmp8_ = pane;
		_tmp9_ = accounts_command_pane_get_commands (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = application_command_stack_get_can_redo (_tmp10_);
		_tmp12_ = _tmp11_;
		can_redo = _tmp12_;
	}
	_tmp13_ = accounts_editor_get_action (self, ACTION_EDIT_UNDO);
	_tmp14_ = _tmp13_;
	g_simple_action_set_enabled (_tmp14_, can_undo);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = accounts_editor_get_action (self, ACTION_EDIT_REDO);
	_tmp16_ = _tmp15_;
	g_simple_action_set_enabled (_tmp16_, can_redo);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (pane);
}

static inline AccountsEditorPane*
accounts_editor_get_current_pane (AccountsEditor* self)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	AccountsEditorPane* _tmp2_;
	AccountsEditorPane* result;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR (self), NULL);
	_tmp0_ = self->priv->editor_panes;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _g_object_ref0 (ACCOUNTS_IS_EDITOR_PANE (_tmp1_) ? ((AccountsEditorPane*) _tmp1_) : NULL);
	result = _tmp2_;
	return result;
}

static inline GSimpleAction*
accounts_editor_get_action (AccountsEditor* self,
                            const gchar* name)
{
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* result;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->edit_actions;
	_tmp1_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_action_map_get_type (), GActionMap), name);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp2_;
	return result;
}

static void
accounts_editor_on_undo (AccountsEditor* self)
{
	AccountsCommandPane* pane = NULL;
	AccountsEditorPane* _tmp0_;
	AccountsCommandPane* _tmp1_;
	AccountsCommandPane* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	_tmp0_ = accounts_editor_get_current_pane (self);
	_tmp1_ = ACCOUNTS_IS_COMMAND_PANE (_tmp0_) ? ((AccountsCommandPane*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	pane = _tmp1_;
	_tmp2_ = pane;
	if (_tmp2_ != NULL) {
		AccountsCommandPane* _tmp3_;
		_tmp3_ = pane;
		accounts_command_pane_undo (_tmp3_);
	}
	_g_object_unref0 (pane);
}

static void
accounts_editor_on_redo (AccountsEditor* self)
{
	AccountsCommandPane* pane = NULL;
	AccountsEditorPane* _tmp0_;
	AccountsCommandPane* _tmp1_;
	AccountsCommandPane* _tmp2_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	_tmp0_ = accounts_editor_get_current_pane (self);
	_tmp1_ = ACCOUNTS_IS_COMMAND_PANE (_tmp0_) ? ((AccountsCommandPane*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	pane = _tmp1_;
	_tmp2_ = pane;
	if (_tmp2_ != NULL) {
		AccountsCommandPane* _tmp3_;
		_tmp3_ = pane;
		accounts_command_pane_redo (_tmp3_);
	}
	_g_object_unref0 (pane);
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		AccountsEditor* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->visible);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static gboolean
___lambda100_ (Block39Data* _data39_)
{
	AccountsEditor* self;
	AccountsEditorPane* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean result;
	self = _data39_->self;
	_tmp0_ = _data39_->visible;
	_tmp1_ = accounts_editor_pane_get_initial_widget (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_grab_focus (_tmp2_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda100__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda100_ (self);
	return result;
}

static void
accounts_editor_on_pane_changed (AccountsEditor* self)
{
	Block39Data* _data39_;
	AccountsEditorPane* _tmp0_;
	GtkWidget* header = NULL;
	AccountsEditorPane* _tmp1_;
	GtkWidget* _tmp4_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR (self));
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = accounts_editor_get_current_pane (self);
	_data39_->visible = _tmp0_;
	header = NULL;
	_tmp1_ = _data39_->visible;
	if (_tmp1_ != NULL) {
		AccountsEditorPane* _tmp2_;
		GtkHeaderBar* _tmp3_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda100__gsource_func, block39_data_ref (_data39_), block39_data_unref);
		_tmp2_ = _data39_->visible;
		_tmp3_ = accounts_editor_pane_get_header (_tmp2_);
		_g_object_unref0 (header);
		header = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	}
	_tmp4_ = header;
	gtk_window_set_titlebar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp4_);
	accounts_editor_update_command_actions (self);
	_g_object_unref0 (header);
	block39_data_unref (_data39_);
	_data39_ = NULL;
}

static void
_accounts_editor_on_pane_changed_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	accounts_editor_on_pane_changed ((AccountsEditor*) self);
}

static void
accounts_editor_class_init (AccountsEditorClass * klass,
                            gpointer klass_data)
{
	accounts_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AccountsEditor_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) accounts_editor_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_accounts_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_accounts_editor_set_property;
	G_OBJECT_CLASS (klass)->finalize = accounts_editor_finalize;
	/** Returns the editor's associated client application instance. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_EDITOR_APPLICATION_PROPERTY, accounts_editor_properties[ACCOUNTS_EDITOR_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", APPLICATION_TYPE_CLIENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY, accounts_editor_properties[ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY] = g_param_spec_object ("accounts", "accounts", "accounts", ACCOUNTS_TYPE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY, accounts_editor_properties[ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY] = g_param_spec_object ("certificates", "certificates", "certificates", APPLICATION_TYPE_CERTIFICATE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/accounts_editor.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notifications_pane", FALSE, AccountsEditor_private_offset + G_STRUCT_OFFSET (AccountsEditorPrivate, notifications_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "editor_panes", FALSE, AccountsEditor_private_offset + G_STRUCT_OFFSET (AccountsEditorPrivate, editor_panes));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_pane_changed", G_CALLBACK(_accounts_editor_on_pane_changed_g_object_notify));
}

static void
accounts_editor_instance_init (AccountsEditor * self,
                               gpointer klass)
{
	GSimpleActionGroup* _tmp0_;
	GeeLinkedList* _tmp1_;
	self->priv = accounts_editor_get_instance_private (self);
	_tmp0_ = g_simple_action_group_new ();
	self->priv->edit_actions = _tmp0_;
	_tmp1_ = gee_linked_list_new (ACCOUNTS_TYPE_EDITOR_PANE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->editor_pane_stack = _tmp1_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
accounts_editor_finalize (GObject * obj)
{
	AccountsEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACCOUNTS_TYPE_EDITOR, AccountsEditor);
	_g_object_unref0 (self->priv->_accounts);
	_g_object_unref0 (self->priv->_certificates);
	_g_object_unref0 (self->priv->edit_actions);
	_g_object_unref0 (self->priv->editor_list_pane);
	_g_object_unref0 (self->priv->editor_pane_stack);
	G_OBJECT_CLASS (accounts_editor_parent_class)->finalize (obj);
}

/**
 * The main account editor window.
 *
 * The editor is a dialog window that manages a stack of {@link
 * EditorPane} instances. Each pane handles a specific task (listing
 * accounts, adding a new account, editing an existing one, etc.). The
 * editor displaying panes as needed, and provides some common command
 * management, account management and other common code for the panes.
 */
static GType
accounts_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsEditor), 0, (GInstanceInitFunc) accounts_editor_instance_init, NULL };
	GType accounts_editor_type_id;
	accounts_editor_type_id = g_type_register_static (gtk_dialog_get_type (), "AccountsEditor", &g_define_type_info, 0);
	AccountsEditor_private_offset = g_type_add_instance_private (accounts_editor_type_id, sizeof (AccountsEditorPrivate));
	return accounts_editor_type_id;
}

GType
accounts_editor_get_type (void)
{
	static volatile gsize accounts_editor_type_id__once = 0;
	if (g_once_init_enter (&accounts_editor_type_id__once)) {
		GType accounts_editor_type_id;
		accounts_editor_type_id = accounts_editor_get_type_once ();
		g_once_init_leave (&accounts_editor_type_id__once, accounts_editor_type_id);
	}
	return accounts_editor_type_id__once;
}

static void
_vala_accounts_editor_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	AccountsEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACCOUNTS_TYPE_EDITOR, AccountsEditor);
	switch (property_id) {
		case ACCOUNTS_EDITOR_APPLICATION_PROPERTY:
		g_value_set_object (value, accounts_editor_get_application (self));
		break;
		case ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY:
		g_value_set_object (value, accounts_editor_get_accounts (self));
		break;
		case ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY:
		g_value_set_object (value, accounts_editor_get_certificates (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_accounts_editor_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	AccountsEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ACCOUNTS_TYPE_EDITOR, AccountsEditor);
	switch (property_id) {
		case ACCOUNTS_EDITOR_APPLICATION_PROPERTY:
		accounts_editor_set_application (self, g_value_get_object (value));
		break;
		case ACCOUNTS_EDITOR_ACCOUNTS_PROPERTY:
		accounts_editor_set_accounts (self, g_value_get_object (value));
		break;
		case ACCOUNTS_EDITOR_CERTIFICATES_PROPERTY:
		accounts_editor_set_certificates (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

AccountsEditor*
accounts_editor_pane_get_editor (AccountsEditorPane* self)
{
	AccountsEditorPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR_PANE (self), NULL);
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->get_editor) {
		return _iface_->get_editor (self);
	}
	return NULL;
}

void
accounts_editor_pane_set_editor (AccountsEditorPane* self,
                                 AccountsEditor* value)
{
	AccountsEditorPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR_PANE (self));
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->set_editor) {
		_iface_->set_editor (self, value);
	}
}

GtkWidget*
accounts_editor_pane_get_initial_widget (AccountsEditorPane* self)
{
	AccountsEditorPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR_PANE (self), NULL);
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->get_initial_widget) {
		return _iface_->get_initial_widget (self);
	}
	return NULL;
}

gboolean
accounts_editor_pane_get_is_operation_running (AccountsEditorPane* self)
{
	AccountsEditorPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR_PANE (self), FALSE);
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->get_is_operation_running) {
		return _iface_->get_is_operation_running (self);
	}
	return FALSE;
}

void
accounts_editor_pane_set_is_operation_running (AccountsEditorPane* self,
                                               gboolean value)
{
	AccountsEditorPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR_PANE (self));
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->set_is_operation_running) {
		_iface_->set_is_operation_running (self, value);
	}
}

GCancellable*
accounts_editor_pane_get_op_cancellable (AccountsEditorPane* self)
{
	AccountsEditorPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR_PANE (self), NULL);
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->get_op_cancellable) {
		return _iface_->get_op_cancellable (self);
	}
	return NULL;
}

void
accounts_editor_pane_set_op_cancellable (AccountsEditorPane* self,
                                         GCancellable* value)
{
	AccountsEditorPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_EDITOR_PANE (self));
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->set_op_cancellable) {
		_iface_->set_op_cancellable (self, value);
	}
}

/** The GTK header bar to display for this pane. */
GtkHeaderBar*
accounts_editor_pane_get_header (AccountsEditorPane* self)
{
	AccountsEditorPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_EDITOR_PANE (self), NULL);
	_iface_ = ACCOUNTS_EDITOR_PANE_GET_INTERFACE (self);
	if (_iface_->get_header) {
		return _iface_->get_header (self);
	}
	return NULL;
}

/**
     * Cancels this pane's current operation, any.
     *
     * Sets {@link is_operation_running} to false and if {@link
     * op_cancellable} is not null, it is cancelled and replaced with
     * a new instance.
     */
void
accounts_editor_pane_cancel_operation (AccountsEditorPane* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	accounts_editor_pane_set_is_operation_running (self, FALSE);
	_tmp0_ = accounts_editor_pane_get_op_cancellable (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		GCancellable* _tmp5_;
		_tmp2_ = accounts_editor_pane_get_op_cancellable (self);
		_tmp3_ = _tmp2_;
		g_cancellable_cancel (_tmp3_);
		_tmp4_ = g_cancellable_new ();
		_tmp5_ = _tmp4_;
		accounts_editor_pane_set_op_cancellable (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}

static void
accounts_editor_pane_default_init (AccountsEditorPaneIface * iface,
                                   gpointer iface_data)
{
	/** The editor displaying this pane. */
	g_object_interface_install_property (iface, g_param_spec_object ("editor", "editor", "editor", ACCOUNTS_TYPE_EDITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The editor displaying this pane. */
	g_object_interface_install_property (iface, g_param_spec_object ("initial-widget", "initial-widget", "initial-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if a long running operation is being executed.
	     *
	     * @see cancel_operation
	     */
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-operation-running", "is-operation-running", "is-operation-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Long running operation cancellable.
	     *
	     * This cancellable must be passed to any long-running operations
	     * involving I/O. If not null and operation is cancelled, the
	     * value should be cancelled and replaced with a new instance.
	     *
	     * @see cancel_operation
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("op-cancellable", "op-cancellable", "op-cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * Base interface for panes that can be shown by the accounts editor.
 */
static GType
accounts_editor_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsEditorPaneIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_editor_pane_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType accounts_editor_pane_type_id;
	accounts_editor_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsEditorPane", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_editor_pane_type_id, gtk_grid_get_type ());
	return accounts_editor_pane_type_id;
}

GType
accounts_editor_pane_get_type (void)
{
	static volatile gsize accounts_editor_pane_type_id__once = 0;
	if (g_once_init_enter (&accounts_editor_pane_type_id__once)) {
		GType accounts_editor_pane_type_id;
		accounts_editor_pane_type_id = accounts_editor_pane_get_type_once ();
		g_once_init_leave (&accounts_editor_pane_type_id__once, accounts_editor_pane_type_id);
	}
	return accounts_editor_pane_type_id__once;
}

GearyAccountInformation*
accounts_account_pane_get_account (AccountsAccountPane* self)
{
	AccountsAccountPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_ACCOUNT_PANE (self), NULL);
	_iface_ = ACCOUNTS_ACCOUNT_PANE_GET_INTERFACE (self);
	if (_iface_->get_account) {
		return _iface_->get_account (self);
	}
	return NULL;
}

void
accounts_account_pane_set_account (AccountsAccountPane* self,
                                   GearyAccountInformation* value)
{
	AccountsAccountPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_ACCOUNT_PANE (self));
	_iface_ = ACCOUNTS_ACCOUNT_PANE_GET_INTERFACE (self);
	if (_iface_->set_account) {
		_iface_->set_account (self, value);
	}
}

/**
     * Connects to account signals.
     *
     * Implementing classes should call this in their constructor.
     */
static void
_accounts_account_pane_on_account_changed_geary_account_information_changed (GearyAccountInformation* _sender,
                                                                             gpointer self)
{
	accounts_account_pane_on_account_changed ((AccountsAccountPane*) self);
}

void
accounts_account_pane_connect_account_signals (AccountsAccountPane* self)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	_tmp0_ = accounts_account_pane_get_account (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _accounts_account_pane_on_account_changed_geary_account_information_changed, self, 0);
	accounts_account_pane_update_header (self);
}

/**
     * Disconnects from account signals.
     *
     * Implementing classes should call this in their destructor.
     */
void
accounts_account_pane_disconnect_account_signals (AccountsAccountPane* self)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	guint _tmp2_;
	_tmp0_ = accounts_account_pane_get_account (self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("changed", GEARY_TYPE_ACCOUNT_INFORMATION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _accounts_account_pane_on_account_changed_geary_account_information_changed, self);
}

/**
     * Called when an account has changed.
     *
     * By default, updates the editor's header subtitle.
     */
static void
accounts_account_pane_account_changed (AccountsAccountPane* self)
{
	accounts_account_pane_update_header (self);
}

static inline void
accounts_account_pane_update_header (AccountsAccountPane* self)
{
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GearyAccountInformation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = accounts_editor_pane_get_header (G_TYPE_CHECK_INSTANCE_CAST (self, ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPane));
	_tmp1_ = _tmp0_;
	_tmp2_ = accounts_account_pane_get_account (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_account_information_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_header_bar_set_subtitle (_tmp1_, _tmp5_);
	_g_object_unref0 (_tmp1_);
}

static void
accounts_account_pane_on_account_changed (AccountsAccountPane* self)
{
	accounts_account_pane_account_changed (self);
}

static void
accounts_account_pane_default_init (AccountsAccountPaneIface * iface,
                                    gpointer iface_data)
{
	/** Account being displayed by this pane. */
	g_object_interface_install_property (iface, g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
 * Interface for editor panes that display a specific account.
 */
static GType
accounts_account_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsAccountPaneIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_account_pane_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType accounts_account_pane_type_id;
	accounts_account_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsAccountPane", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_account_pane_type_id, ACCOUNTS_TYPE_EDITOR_PANE);
	return accounts_account_pane_type_id;
}

GType
accounts_account_pane_get_type (void)
{
	static volatile gsize accounts_account_pane_type_id__once = 0;
	if (g_once_init_enter (&accounts_account_pane_type_id__once)) {
		GType accounts_account_pane_type_id;
		accounts_account_pane_type_id = accounts_account_pane_get_type_once ();
		g_once_init_leave (&accounts_account_pane_type_id__once, accounts_account_pane_type_id);
	}
	return accounts_account_pane_type_id__once;
}

ApplicationCommandStack*
accounts_command_pane_get_commands (AccountsCommandPane* self)
{
	AccountsCommandPaneIface* _iface_;
	g_return_val_if_fail (ACCOUNTS_IS_COMMAND_PANE (self), NULL);
	_iface_ = ACCOUNTS_COMMAND_PANE_GET_INTERFACE (self);
	if (_iface_->get_commands) {
		return _iface_->get_commands (self);
	}
	return NULL;
}

void
accounts_command_pane_set_commands (AccountsCommandPane* self,
                                    ApplicationCommandStack* value)
{
	AccountsCommandPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_COMMAND_PANE (self));
	_iface_ = ACCOUNTS_COMMAND_PANE_GET_INTERFACE (self);
	if (_iface_->set_commands) {
		_iface_->set_commands (self, value);
	}
}

/** Un-does the last user action, if enabled. */
static void
accounts_command_pane_real_undo (AccountsCommandPane* self)
{
	ApplicationCommandStack* _tmp0_;
	ApplicationCommandStack* _tmp1_;
	_tmp0_ = accounts_command_pane_get_commands (self);
	_tmp1_ = _tmp0_;
	application_command_stack_undo (_tmp1_, NULL, NULL, NULL);
}

void
accounts_command_pane_undo (AccountsCommandPane* self)
{
	AccountsCommandPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_COMMAND_PANE (self));
	_iface_ = ACCOUNTS_COMMAND_PANE_GET_INTERFACE (self);
	if (_iface_->undo) {
		_iface_->undo (self);
	}
}

/** Re-does the last user action, if enabled. */
static void
accounts_command_pane_real_redo (AccountsCommandPane* self)
{
	ApplicationCommandStack* _tmp0_;
	ApplicationCommandStack* _tmp1_;
	_tmp0_ = accounts_command_pane_get_commands (self);
	_tmp1_ = _tmp0_;
	application_command_stack_redo (_tmp1_, NULL, NULL, NULL);
}

void
accounts_command_pane_redo (AccountsCommandPane* self)
{
	AccountsCommandPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_COMMAND_PANE (self));
	_iface_ = ACCOUNTS_COMMAND_PANE_GET_INTERFACE (self);
	if (_iface_->redo) {
		_iface_->redo (self);
	}
}

/**
     * Connects to command stack signals.
     *
     * Implementing classes should call this in their constructor.
     */
static void
_accounts_command_pane_on_command_application_command_stack_executed (ApplicationCommandStack* _sender,
                                                                      ApplicationCommand* command,
                                                                      gpointer self)
{
	accounts_command_pane_on_command ((AccountsCommandPane*) self);
}

static void
_accounts_command_pane_on_command_application_command_stack_undone (ApplicationCommandStack* _sender,
                                                                    ApplicationCommand* command,
                                                                    gpointer self)
{
	accounts_command_pane_on_command ((AccountsCommandPane*) self);
}

static void
_accounts_command_pane_on_command_application_command_stack_redone (ApplicationCommandStack* _sender,
                                                                    ApplicationCommand* command,
                                                                    gpointer self)
{
	accounts_command_pane_on_command ((AccountsCommandPane*) self);
}

void
accounts_command_pane_connect_command_signals (AccountsCommandPane* self)
{
	ApplicationCommandStack* _tmp0_;
	ApplicationCommandStack* _tmp1_;
	ApplicationCommandStack* _tmp2_;
	ApplicationCommandStack* _tmp3_;
	ApplicationCommandStack* _tmp4_;
	ApplicationCommandStack* _tmp5_;
	_tmp0_ = accounts_command_pane_get_commands (self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "executed", (GCallback) _accounts_command_pane_on_command_application_command_stack_executed, self, 0);
	_tmp2_ = accounts_command_pane_get_commands (self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "undone", (GCallback) _accounts_command_pane_on_command_application_command_stack_undone, self, 0);
	_tmp4_ = accounts_command_pane_get_commands (self);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "redone", (GCallback) _accounts_command_pane_on_command_application_command_stack_redone, self, 0);
}

/**
     * Disconnects from command stack signals.
     *
     * Implementing classes should call this in their destructor.
     */
void
accounts_command_pane_disconnect_command_signals (AccountsCommandPane* self)
{
	ApplicationCommandStack* _tmp0_;
	ApplicationCommandStack* _tmp1_;
	guint _tmp2_;
	ApplicationCommandStack* _tmp3_;
	ApplicationCommandStack* _tmp4_;
	guint _tmp5_;
	ApplicationCommandStack* _tmp6_;
	ApplicationCommandStack* _tmp7_;
	guint _tmp8_;
	_tmp0_ = accounts_command_pane_get_commands (self);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("executed", APPLICATION_TYPE_COMMAND_STACK, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _accounts_command_pane_on_command_application_command_stack_executed, self);
	_tmp3_ = accounts_command_pane_get_commands (self);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("undone", APPLICATION_TYPE_COMMAND_STACK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _accounts_command_pane_on_command_application_command_stack_undone, self);
	_tmp6_ = accounts_command_pane_get_commands (self);
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("redone", APPLICATION_TYPE_COMMAND_STACK, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _accounts_command_pane_on_command_application_command_stack_redone, self);
}

/**
     * Called when a command is executed, undone or redone.
     *
     * By default, calls {@link Accounts.Editor.update_command_actions}.
     */
static void
accounts_command_pane_real_command_executed (AccountsCommandPane* self)
{
	AccountsEditor* _tmp0_;
	AccountsEditor* _tmp1_;
	_tmp0_ = accounts_editor_pane_get_editor (G_TYPE_CHECK_INSTANCE_CAST (self, ACCOUNTS_TYPE_EDITOR_PANE, AccountsEditorPane));
	_tmp1_ = _tmp0_;
	accounts_editor_update_command_actions (_tmp1_);
}

void
accounts_command_pane_command_executed (AccountsCommandPane* self)
{
	AccountsCommandPaneIface* _iface_;
	g_return_if_fail (ACCOUNTS_IS_COMMAND_PANE (self));
	_iface_ = ACCOUNTS_COMMAND_PANE_GET_INTERFACE (self);
	if (_iface_->command_executed) {
		_iface_->command_executed (self);
	}
}

static void
accounts_command_pane_on_command (AccountsCommandPane* self)
{
	accounts_command_pane_command_executed (self);
}

static void
accounts_command_pane_default_init (AccountsCommandPaneIface * iface,
                                    gpointer iface_data)
{
	/** Stack for the user's commands. */
	g_object_interface_install_property (iface, g_param_spec_object ("commands", "commands", "commands", APPLICATION_TYPE_COMMAND_STACK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->undo = accounts_command_pane_real_undo;
	iface->redo = accounts_command_pane_real_redo;
	iface->command_executed = accounts_command_pane_real_command_executed;
}

/**
 * Interface for editor panes that support undoing/redoing user actions.
 */
static GType
accounts_command_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsCommandPaneIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_command_pane_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType accounts_command_pane_type_id;
	accounts_command_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountsCommandPane", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (accounts_command_pane_type_id, ACCOUNTS_TYPE_EDITOR_PANE);
	return accounts_command_pane_type_id;
}

GType
accounts_command_pane_get_type (void)
{
	static volatile gsize accounts_command_pane_type_id__once = 0;
	if (g_once_init_enter (&accounts_command_pane_type_id__once)) {
		GType accounts_command_pane_type_id;
		accounts_command_pane_type_id = accounts_command_pane_get_type_once ();
		g_once_init_leave (&accounts_command_pane_type_id__once, accounts_command_pane_type_id);
	}
	return accounts_command_pane_type_id__once;
}

