/* icon-factory.c generated by valac 0.56.3, the Vala compiler
 * generated from icon-factory.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Singleton class to hold icons.*/

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define _icon_factory_unref0(var) ((var == NULL) ? NULL : (var = (icon_factory_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecIconFactory ParamSpecIconFactory;

struct _IconFactoryPrivate {
	GtkIconTheme* _icon_theme;
	GFile* icons_dir;
};

struct _ParamSpecIconFactory {
	GParamSpec parent_instance;
};

static gint IconFactory_private_offset;
static gpointer icon_factory_parent_class = NULL;
static IconFactory* icon_factory__instance;
static IconFactory* icon_factory__instance = NULL;

static void icon_factory_set_instance (IconFactory* value);
static IconFactory* icon_factory_new (GFile* resource_directory);
static IconFactory* icon_factory_construct (GType object_type,
                                     GFile* resource_directory);
static GtkIconTheme* icon_factory_get_icon_theme (IconFactory* self);
static void icon_factory_set_icon_theme (IconFactory* self,
                                  GtkIconTheme* value);
static gint icon_factory_icon_size_to_pixels (IconFactory* self,
                                       GtkIconSize icon_size);
static GdkPixbuf* icon_factory_get_missing_icon (IconFactory* self,
                                          gint size,
                                          GtkIconLookupFlags flags);
static GdkPixbuf* icon_factory_aspect_scale_down_pixbuf (IconFactory* self,
                                                  GdkPixbuf* pixbuf,
                                                  gint size);
static void icon_factory_finalize (IconFactory * obj);
static GType icon_factory_get_type_once (void);

static inline gpointer
icon_factory_get_instance_private (IconFactory* self)
{
	return G_STRUCT_MEMBER_P (self, IconFactory_private_offset);
}

IconFactory*
icon_factory_get_instance (void)
{
	IconFactory* result;
	IconFactory* _tmp0_;
	_tmp0_ = icon_factory__instance;
	result = _tmp0_;
	return result;
}

static gpointer
_icon_factory_ref0 (gpointer self)
{
	return self ? icon_factory_ref (self) : NULL;
}

static void
icon_factory_set_instance (IconFactory* value)
{
	IconFactory* _tmp0_;
	_tmp0_ = _icon_factory_ref0 (value);
	_icon_factory_unref0 (icon_factory__instance);
	icon_factory__instance = _tmp0_;
}

void
icon_factory_init (GFile* resource_directory)
{
	IconFactory* _tmp0_;
	IconFactory* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (resource_directory, g_file_get_type ()));
	_tmp0_ = icon_factory_new (resource_directory);
	_tmp1_ = _tmp0_;
	icon_factory_set_instance (_tmp1_);
	_icon_factory_unref0 (_tmp1_);
}

static GtkIconTheme*
icon_factory_get_icon_theme (IconFactory* self)
{
	GtkIconTheme* result;
	GtkIconTheme* _tmp0_;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	_tmp0_ = self->priv->_icon_theme;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
icon_factory_set_icon_theme (IconFactory* self,
                             GtkIconTheme* value)
{
	GtkIconTheme* _tmp0_;
	g_return_if_fail (IS_ICON_FACTORY (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon_theme);
	self->priv->_icon_theme = _tmp0_;
}

static IconFactory*
icon_factory_construct (GType object_type,
                        GFile* resource_directory)
{
	IconFactory* self = NULL;
	GFile* _tmp0_;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (resource_directory, g_file_get_type ()), NULL);
	self = (IconFactory*) g_type_create_instance (object_type);
	_tmp0_ = g_file_get_child (resource_directory, "icons");
	_g_object_unref0 (self->priv->icons_dir);
	self->priv->icons_dir = _tmp0_;
	_tmp1_ = gtk_icon_theme_get_default ();
	icon_factory_set_icon_theme (self, _tmp1_);
	_tmp2_ = self->priv->_icon_theme;
	_tmp3_ = self->priv->icons_dir;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_icon_theme_append_search_path (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	return self;
}

static IconFactory*
icon_factory_new (GFile* resource_directory)
{
	return icon_factory_construct (TYPE_ICON_FACTORY, resource_directory);
}

static gint
icon_factory_icon_size_to_pixels (IconFactory* self,
                                  GtkIconSize icon_size)
{
	gint result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), 0);
	switch (icon_size) {
		case ICON_FACTORY_ICON_SIDEBAR:
		{
			result = 16;
			return result;
		}
		default:
		case ICON_FACTORY_ICON_TOOLBAR:
		{
			result = 24;
			return result;
		}
	}
}

GIcon*
icon_factory_get_theme_icon (IconFactory* self,
                             const gchar* name)
{
	GThemedIcon* _tmp0_;
	GIcon* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (name);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_icon_get_type (), GIcon);
	return result;
}

GIcon*
icon_factory_get_custom_icon (IconFactory* self,
                              const gchar* name,
                              GtkIconSize size)
{
	gint pixels = 0;
	GFile* icon_file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp14_;
	GFileIcon* _tmp15_;
	GIcon* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	pixels = icon_factory_icon_size_to_pixels (self, size);
	_tmp0_ = self->priv->icons_dir;
	_tmp1_ = g_strdup_printf ("%dx%d", pixels, pixels);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s.svg", name);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_child (_tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
	icon_file = _tmp8_;
	_tmp9_ = icon_file;
	if (!g_file_query_exists (_tmp9_, NULL)) {
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		_tmp10_ = self->priv->icons_dir;
		_tmp11_ = g_strdup_printf ("%s.svg", name);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_child (_tmp10_, _tmp12_);
		_g_object_unref0 (icon_file);
		icon_file = _tmp13_;
		_g_free0 (_tmp12_);
	}
	_tmp14_ = icon_file;
	_tmp15_ = (GFileIcon*) g_file_icon_new (_tmp14_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_icon_get_type (), GIcon);
	_g_object_unref0 (icon_file);
	return result;
}

static GdkPixbuf*
icon_factory_get_missing_icon (IconFactory* self,
                               gint size,
                               GtkIconLookupFlags flags)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp1_ = self->priv->_icon_theme;
		_tmp2_ = gtk_icon_theme_load_icon (_tmp1_, "image-missing", size, flags, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("icon-factory.vala:69: Couldn't load image-missing icon: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

GtkIconInfo*
icon_factory_lookup_icon (IconFactory* self,
                          const gchar* icon_name,
                          gint size,
                          GtkIconLookupFlags flags)
{
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	GtkIconInfo* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme;
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, icon_name, size, flags);
	icon_info = _tmp1_;
	_tmp2_ = icon_info;
	if (_tmp2_ == NULL) {
		GtkIconTheme* _tmp3_;
		GtkIconInfo* _tmp4_;
		_tmp3_ = self->priv->_icon_theme;
		_tmp4_ = gtk_icon_theme_lookup_icon (_tmp3_, "text-x-generic-symbolic", size, flags);
		_g_object_unref0 (icon_info);
		icon_info = _tmp4_;
	}
	result = icon_info;
	return result;
}

static GdkPixbuf*
icon_factory_aspect_scale_down_pixbuf (IconFactory* self,
                                       GdkPixbuf* pixbuf,
                                       gint size)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint scaled_width = 0;
	gint scaled_height = 0;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	_tmp1_ = gdk_pixbuf_get_width (pixbuf);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= size) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gdk_pixbuf_get_height (pixbuf);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ <= size;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkPixbuf* _tmp5_;
		_tmp5_ = _g_object_ref0 (pixbuf);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = gdk_pixbuf_get_width (pixbuf);
	_tmp7_ = _tmp6_;
	_tmp8_ = gdk_pixbuf_get_height (pixbuf);
	_tmp9_ = _tmp8_;
	if (_tmp7_ >= _tmp9_) {
		gdouble aspect = 0.0;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp10_ = gdk_pixbuf_get_width (pixbuf);
		_tmp11_ = _tmp10_;
		aspect = ((gdouble) size) / ((gdouble) _tmp11_);
		scaled_width = size;
		_tmp12_ = gdk_pixbuf_get_height (pixbuf);
		_tmp13_ = _tmp12_;
		scaled_height = (gint) round (((gdouble) _tmp13_) * aspect);
	} else {
		gdouble aspect = 0.0;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = gdk_pixbuf_get_height (pixbuf);
		_tmp15_ = _tmp14_;
		aspect = ((gdouble) size) / ((gdouble) _tmp15_);
		_tmp16_ = gdk_pixbuf_get_width (pixbuf);
		_tmp17_ = _tmp16_;
		scaled_width = (gint) round (((gdouble) _tmp17_) * aspect);
		scaled_height = size;
	}
	_tmp18_ = gdk_pixbuf_scale_simple (pixbuf, scaled_width, scaled_height, GDK_INTERP_BILINEAR);
	result = _tmp18_;
	return result;
}

GdkPixbuf*
icon_factory_load_symbolic (IconFactory* self,
                            const gchar* icon_name,
                            gint size,
                            GtkStyleContext* style,
                            GtkIconLookupFlags flags)
{
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	GdkPixbuf* _tmp9_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (style, gtk_style_context_get_type ()), NULL);
	_tmp0_ = self->priv->_icon_theme;
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, icon_name, size, flags);
	icon_info = _tmp1_;
	_tmp2_ = icon_info;
	if (_tmp2_ != NULL) {
		{
			GdkPixbuf* _tmp3_ = NULL;
			GtkIconInfo* _tmp4_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			_tmp4_ = icon_info;
			_tmp5_ = gtk_icon_info_load_symbolic_for_context (_tmp4_, style, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = icon_factory_aspect_scale_down_pixbuf (self, _tmp3_, size);
			result = _tmp6_;
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (icon_info);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_message ("icon-factory.vala:113: Couldn't load icon: %s", _tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (icon_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = icon_factory_get_missing_icon (self, size, flags);
	result = _tmp9_;
	_g_object_unref0 (icon_info);
	return result;
}

/**
     * Loads a symbolic icon into a pixbuf, where the color-key has been switched to the provided
     * color.
     */
GdkPixbuf*
icon_factory_load_symbolic_colored (IconFactory* self,
                                    const gchar* icon_name,
                                    gint size,
                                    GdkRGBA* color,
                                    GtkIconLookupFlags flags)
{
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	GdkPixbuf* _tmp10_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_ICON_FACTORY (self), NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme;
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, icon_name, size, flags);
	icon_info = _tmp1_;
	_tmp2_ = icon_info;
	if (_tmp2_ != NULL) {
		{
			GdkPixbuf* _tmp3_ = NULL;
			GtkIconInfo* _tmp4_;
			GdkRGBA _tmp5_;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			_tmp4_ = icon_info;
			_tmp5_ = *color;
			_tmp6_ = gtk_icon_info_load_symbolic (_tmp4_, &_tmp5_, NULL, NULL, NULL, NULL, &_inner_error0_);
			_tmp3_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = icon_factory_aspect_scale_down_pixbuf (self, _tmp3_, size);
			result = _tmp7_;
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (icon_info);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("icon-factory.vala:134: Couldn't load icon: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (icon_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = icon_factory_get_missing_icon (self, size, flags);
	result = _tmp10_;
	_g_object_unref0 (icon_info);
	return result;
}

static void
value_icon_factory_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_icon_factory_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		icon_factory_unref (value->data[0].v_pointer);
	}
}

static void
value_icon_factory_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = icon_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_icon_factory_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_icon_factory_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		IconFactory * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = icon_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_icon_factory_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	IconFactory ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = icon_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_icon_factory (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecIconFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ICON_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_icon_factory (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_FACTORY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_icon_factory (GValue* value,
                        gpointer v_object)
{
	IconFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		icon_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		icon_factory_unref (old);
	}
}

void
value_take_icon_factory (GValue* value,
                         gpointer v_object)
{
	IconFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		icon_factory_unref (old);
	}
}

static void
icon_factory_class_init (IconFactoryClass * klass,
                         gpointer klass_data)
{
	icon_factory_parent_class = g_type_class_peek_parent (klass);
	((IconFactoryClass *) klass)->finalize = icon_factory_finalize;
	g_type_class_adjust_private_offset (klass, &IconFactory_private_offset);
}

static void
icon_factory_instance_init (IconFactory * self,
                            gpointer klass)
{
	self->priv = icon_factory_get_instance_private (self);
	self->ref_count = 1;
}

static void
icon_factory_finalize (IconFactory * obj)
{
	IconFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_FACTORY, IconFactory);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_icon_theme);
	_g_object_unref0 (self->priv->icons_dir);
}

static GType
icon_factory_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_icon_factory_init, value_icon_factory_free_value, value_icon_factory_copy_value, value_icon_factory_peek_pointer, "p", value_icon_factory_collect_value, "p", value_icon_factory_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IconFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconFactory), 0, (GInstanceInitFunc) icon_factory_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType icon_factory_type_id;
	icon_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IconFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IconFactory_private_offset = g_type_add_instance_private (icon_factory_type_id, sizeof (IconFactoryPrivate));
	return icon_factory_type_id;
}

GType
icon_factory_get_type (void)
{
	static volatile gsize icon_factory_type_id__once = 0;
	if (g_once_init_enter (&icon_factory_type_id__once)) {
		GType icon_factory_type_id;
		icon_factory_type_id = icon_factory_get_type_once ();
		g_once_init_leave (&icon_factory_type_id__once, icon_factory_type_id);
	}
	return icon_factory_type_id__once;
}

gpointer
icon_factory_ref (gpointer instance)
{
	IconFactory * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
icon_factory_unref (gpointer instance)
{
	IconFactory * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ICON_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

