/* app-draft-manager.c generated by valac 0.56.3, the Vala compiler
 * generated from app-draft-manager.vala, do not modify */

/*
 * Copyright 2016 © Software Freedom Conservancy Inc.
 * Copyright 2020 © Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

#define GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION (geary_app_draft_manager_operation_get_type ())
#define GEARY_APP_DRAFT_MANAGER_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, GearyAppDraftManagerOperation))
#define GEARY_APP_DRAFT_MANAGER_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, GearyAppDraftManagerOperationClass))
#define GEARY_APP_DRAFT_MANAGER_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION))
#define GEARY_APP_DRAFT_MANAGER_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION))
#define GEARY_APP_DRAFT_MANAGER_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, GearyAppDraftManagerOperationClass))

typedef struct _GearyAppDraftManagerOperation GearyAppDraftManagerOperation;
typedef struct _GearyAppDraftManagerOperationClass GearyAppDraftManagerOperationClass;
enum  {
	GEARY_APP_DRAFT_MANAGER_0_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_NUM_PROPERTIES];
typedef enum  {
	GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH,
	GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_CLOSE
} GearyAppDraftManagerOperationType;

#define GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION_TYPE (geary_app_draft_manager_operation_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;
typedef struct _GearyAppDraftManagerNewData GearyAppDraftManagerNewData;
typedef struct _GearyAppDraftManagerCloseAsyncData GearyAppDraftManagerCloseAsyncData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GearyAppDraftManagerUpdateData GearyAppDraftManagerUpdateData;
typedef struct _GearyAppDraftManagerDiscardData GearyAppDraftManagerDiscardData;
typedef struct _GearyAppDraftManagerOperationPrivate GearyAppDraftManagerOperationPrivate;
typedef struct _GearyAppDraftManagerOperationLoopAsyncData GearyAppDraftManagerOperationLoopAsyncData;
typedef struct _GearyAppDraftManagerOperationLoopIterationAsyncData GearyAppDraftManagerOperationLoopIterationAsyncData;
enum  {
	GEARY_APP_DRAFT_MANAGER_OPERATION_0_PROPERTY,
	GEARY_APP_DRAFT_MANAGER_OPERATION_NUM_PROPERTIES
};
static GParamSpec* geary_app_draft_manager_operation_properties[GEARY_APP_DRAFT_MANAGER_OPERATION_NUM_PROPERTIES];
enum  {
	GEARY_APP_DRAFT_MANAGER_STORED_SIGNAL,
	GEARY_APP_DRAFT_MANAGER_DISCARDED_SIGNAL,
	GEARY_APP_DRAFT_MANAGER_DROPPED_SIGNAL,
	GEARY_APP_DRAFT_MANAGER_DRAFT_FAILED_SIGNAL,
	GEARY_APP_DRAFT_MANAGER_FATAL_SIGNAL,
	GEARY_APP_DRAFT_MANAGER_NUM_SIGNALS
};
static guint geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyAppDraftManagerPrivate {
	gboolean _is_open;
	GearyAppDraftManagerDraftState _draft_state;
	GearyEmailIdentifier* _current_draft_id;
	gint _versions_saved;
	gint _versions_dropped;
	GearyAccount* account;
	GearyEmailFlags* flags;
	GearyFolder* drafts_folder;
	GearyFolderSupportCreate* create_support;
	GearyFolderSupportRemove* remove_support;
	GearyNonblockingQueue* mailbox;
	GError* fatal_err;
};

struct _GearyAppDraftManagerNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	GearyAppDraftManager* self;
	GearyAccount* account;
	GearyFolder* save_to;
	GearyEmailFlags* flags;
	GearyEmailIdentifier* initial_draft_id;
	GCancellable* cancellable;
	GearyAccount* _tmp0_;
	GearyFolder* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GearyEmailIdentifier* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GearyFolder* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GearyFolderSupportCreate* _tmp12_;
	GearyFolderSupportRemove* _tmp13_;
	GearyFolder* _tmp14_;
	GearyFolder* _tmp15_;
	GearyImapEngineMinimalFolder* engine;
	GearyFolder* _tmp16_;
	GearyImapEngineMinimalFolder* _tmp17_;
	GearyImapEngineMinimalFolder* _tmp18_;
	GearyImapEngineMinimalFolder* _tmp19_;
	GearyImapFolderSession* _tmp20_;
	GearyImapFolderSession* _tmp21_;
	GearyFolder* _tmp22_;
	GearyFolderProperties* _tmp23_;
	GearyFolderProperties* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GearyFolder* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GearyFolder* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GError* _tmp33_;
	GError* _tmp34_;
	GError* _inner_error0_;
};

struct _GearyAppDraftManagerCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppDraftManager* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GearyFolder* _tmp2_;
	GError* _tmp3_;
	GearyNonblockingSemaphore* semaphore;
	GearyNonblockingSemaphore* _tmp4_;
	GearyNonblockingQueue* _tmp5_;
	GearyNonblockingSemaphore* _tmp6_;
	GearyAppDraftManagerOperation* _tmp7_;
	GearyAppDraftManagerOperation* _tmp8_;
	GearyNonblockingSemaphore* _tmp9_;
	GError* err;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GearyFolder* _tmp13_;
	guint _tmp14_;
	GearyFolder* _tmp15_;
	GError* _inner_error0_;
};

struct _GearyAppDraftManagerUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppDraftManager* self;
	GearyRFC822Message* draft;
	GDateTime* date_received;
	GCancellable* cancellable;
	GearyEmailFlags* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	GearyNonblockingSemaphore* _tmp2_;
	GError* _inner_error0_;
};

struct _GearyAppDraftManagerDiscardData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppDraftManager* self;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyAppDraftManagerOperation {
	GearyBaseObject parent_instance;
	GearyAppDraftManagerOperationType op_type;
	GearyRFC822Message* draft;
	GearyEmailFlags* flags;
	GDateTime* date_received;
	GearyNonblockingSemaphore* semaphore;
	GearyAppDraftManagerOperationPrivate * priv;
};

struct _GearyAppDraftManagerOperationClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyAppDraftManagerOperationLoopAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppDraftManager* self;
	gboolean _tmp0_;
	GError* _tmp1_;
	GearyAppDraftManagerOperation* op;
	GearyAppDraftManagerOperation* _tmp2_;
	GearyNonblockingQueue* _tmp3_;
	gpointer _tmp4_;
	GearyAppDraftManagerOperation* _tmp5_;
	GError* err;
	GError* _tmp6_;
	gboolean continue_loop;
	GearyAppDraftManagerOperation* _tmp7_;
	GearyAppDraftManagerOperation* _tmp8_;
	GearyNonblockingSemaphore* _tmp9_;
	GearyAppDraftManagerOperation* _tmp10_;
	GearyNonblockingSemaphore* _tmp11_;
	GError* _inner_error0_;
};

struct _GearyAppDraftManagerOperationLoopIterationAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAppDraftManager* self;
	GearyAppDraftManagerOperation* op;
	gboolean result;
	gboolean _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GearyRFC822Message* _tmp7_;
	GearyEmailIdentifier* old_id;
	GearyEmailIdentifier* _tmp8_;
	GearyEmailIdentifier* _tmp9_;
	GearyEmailIdentifier* _tmp10_;
	GearyFolderSupportCreate* _tmp11_;
	GearyRFC822Message* _tmp12_;
	GearyEmailFlags* _tmp13_;
	GDateTime* _tmp14_;
	GearyEmailIdentifier* _tmp15_;
	GearyEmailIdentifier* _tmp16_;
	GearyFolderSupportRemove* _tmp17_;
	GearyEmailIdentifier* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GearyRFC822Message* _tmp21_;
	GError* err;
	GearyRFC822Message* _tmp22_;
	GError* _tmp23_;
	GearyEmailIdentifier* _tmp24_;
	GearyFolderSupportRemove* _tmp25_;
	GearyEmailIdentifier* _tmp26_;
	GeeCollection* _tmp27_;
	GeeCollection* _tmp28_;
	GError* _vala1_err;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GearyEmailIdentifier* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GError* _inner_error0_;
};

static gint GearyAppDraftManager_private_offset;
static gpointer geary_app_draft_manager_parent_class = NULL;
static gpointer geary_app_draft_manager_operation_parent_class = NULL;

static GType geary_app_draft_manager_operation_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType geary_app_draft_manager_operation_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void geary_app_draft_manager_set_is_open (GearyAppDraftManager* self,
                                          gboolean value);
static void geary_app_draft_manager_set_draft_state (GearyAppDraftManager* self,
                                              GearyAppDraftManagerDraftState value);
static void geary_app_draft_manager_set_current_draft_id (GearyAppDraftManager* self,
                                                   GearyEmailIdentifier* value);
static void geary_app_draft_manager_set_versions_saved (GearyAppDraftManager* self,
                                                 gint value);
static void geary_app_draft_manager_set_versions_dropped (GearyAppDraftManager* self,
                                                   gint value);
static void geary_app_draft_manager_real_draft_failed (GearyAppDraftManager* self,
                                                GearyRFC822Message* draft,
                                                GError* err);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void geary_app_draft_manager_real_fatal (GearyAppDraftManager* self,
                                         GError* err);
static void geary_app_draft_manager_real_notify_stored (GearyAppDraftManager* self,
                                                 GearyRFC822Message* draft);
static void geary_app_draft_manager_real_notify_discarded (GearyAppDraftManager* self);
static void geary_app_draft_manager_construct_data_free (gpointer _data);
static gboolean geary_app_draft_manager_construct_co (GearyAppDraftManagerNewData* _data_);
static void geary_app_draft_manager_on_folder_closed (GearyAppDraftManager* self,
                                               GearyFolderCloseReason reason);
static void _geary_app_draft_manager_on_folder_closed_geary_folder_closed (GearyFolder* _sender,
                                                                    GearyFolderCloseReason reason,
                                                                    gpointer self);
static void geary_app_draft_manager_new_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_minimal_folder_claim_remote_session (GearyImapEngineMinimalFolder* self,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapFolderSession* geary_imap_engine_minimal_folder_claim_remote_session_finish (GearyImapEngineMinimalFolder* self,
                                                                                      GAsyncResult* _res_,
                                                                                      GError** error);
static void geary_app_draft_manager_operation_loop_async (GearyAppDraftManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void geary_app_draft_manager_operation_loop_finish (GearyAppDraftManager* self,
                                                    GAsyncResult* _res_);
static void geary_app_draft_manager_close_async_data_free (gpointer _data);
static gboolean geary_app_draft_manager_close_async_co (GearyAppDraftManagerCloseAsyncData* _data_);
static GearyAppDraftManagerOperation* geary_app_draft_manager_operation_new (GearyAppDraftManagerOperationType op_type,
                                                                      GearyRFC822Message* draft,
                                                                      GearyEmailFlags* flags,
                                                                      GDateTime* date_received,
                                                                      GearyNonblockingSemaphore* semaphore);
static GearyAppDraftManagerOperation* geary_app_draft_manager_operation_construct (GType object_type,
                                                                            GearyAppDraftManagerOperationType op_type,
                                                                            GearyRFC822Message* draft,
                                                                            GearyEmailFlags* flags,
                                                                            GDateTime* date_received,
                                                                            GearyNonblockingSemaphore* semaphore);
static void geary_app_draft_manager_close_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void geary_app_draft_manager_check_open (GearyAppDraftManager* self,
                                         GError** error);
static void geary_app_draft_manager_update_data_free (gpointer _data);
static gboolean geary_app_draft_manager_update_co (GearyAppDraftManagerUpdateData* _data_);
static GearyNonblockingSemaphore* geary_app_draft_manager_submit_push (GearyAppDraftManager* self,
                                                                GearyRFC822Message* draft,
                                                                GearyEmailFlags* flags,
                                                                GDateTime* date_received);
static void geary_app_draft_manager_update_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void geary_app_draft_manager_discard_data_free (gpointer _data);
static gboolean geary_app_draft_manager_discard_co (GearyAppDraftManagerDiscardData* _data_);
static void geary_app_draft_manager_discard_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gboolean __lambda174_ (GearyAppDraftManager* self,
                       GearyAppDraftManagerOperation* op);
static gboolean ___lambda174__gee_predicate (gconstpointer g,
                                      gpointer self);
static void geary_app_draft_manager_operation_loop_async_data_free (gpointer _data);
static gboolean geary_app_draft_manager_operation_loop_async_co (GearyAppDraftManagerOperationLoopAsyncData* _data_);
static void geary_app_draft_manager_operation_loop_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_app_draft_manager_operation_loop_iteration_async (GearyAppDraftManager* self,
                                                             GearyAppDraftManagerOperation* op,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean geary_app_draft_manager_operation_loop_iteration_finish (GearyAppDraftManager* self,
                                                                  GAsyncResult* _res_);
static void geary_app_draft_manager_operation_loop_iteration_async_data_free (gpointer _data);
static gboolean geary_app_draft_manager_operation_loop_iteration_async_co (GearyAppDraftManagerOperationLoopIterationAsyncData* _data_);
static void geary_app_draft_manager_operation_loop_iteration_async_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void geary_app_draft_manager_operation_finalize (GObject * obj);
static GType geary_app_draft_manager_operation_get_type_once (void);
static void geary_app_draft_manager_finalize (GObject * obj);
static GType geary_app_draft_manager_get_type_once (void);
static void _vala_geary_app_draft_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_app_draft_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
geary_app_draft_manager_get_instance_private (GearyAppDraftManager* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppDraftManager_private_offset);
}

/**
     * Current saved state of the draft.
     */
 G_GNUC_NO_INLINE static GType
geary_app_draft_manager_draft_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_NOT_STORED, "GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_NOT_STORED", "not-stored"}, {GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORING, "GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORING", "storing"}, {GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORED, "GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORED", "stored"}, {GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_ERROR, "GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_ERROR", "error"}, {0, NULL, NULL}};
	GType geary_app_draft_manager_draft_state_type_id;
	geary_app_draft_manager_draft_state_type_id = g_enum_register_static ("GearyAppDraftManagerDraftState", values);
	return geary_app_draft_manager_draft_state_type_id;
}

GType
geary_app_draft_manager_draft_state_get_type (void)
{
	static gsize geary_app_draft_manager_draft_state_type_id__once = 0;
	if (g_once_init_enter (&geary_app_draft_manager_draft_state_type_id__once)) {
		GType geary_app_draft_manager_draft_state_type_id;
		geary_app_draft_manager_draft_state_type_id = geary_app_draft_manager_draft_state_get_type_once ();
		g_once_init_leave (&geary_app_draft_manager_draft_state_type_id__once, geary_app_draft_manager_draft_state_type_id);
	}
	return geary_app_draft_manager_draft_state_type_id__once;
}

 G_GNUC_NO_INLINE static GType
geary_app_draft_manager_operation_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH, "GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH", "push"}, {GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_CLOSE, "GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_CLOSE", "close"}, {0, NULL, NULL}};
	GType geary_app_draft_manager_operation_type_type_id;
	geary_app_draft_manager_operation_type_type_id = g_enum_register_static ("GearyAppDraftManagerOperationType", values);
	return geary_app_draft_manager_operation_type_type_id;
}

static GType
geary_app_draft_manager_operation_type_get_type (void)
{
	static gsize geary_app_draft_manager_operation_type_type_id__once = 0;
	if (g_once_init_enter (&geary_app_draft_manager_operation_type_type_id__once)) {
		GType geary_app_draft_manager_operation_type_type_id;
		geary_app_draft_manager_operation_type_type_id = geary_app_draft_manager_operation_type_get_type_once ();
		g_once_init_leave (&geary_app_draft_manager_operation_type_type_id__once, geary_app_draft_manager_operation_type_type_id);
	}
	return geary_app_draft_manager_operation_type_type_id__once;
}

gboolean
geary_app_draft_manager_get_is_open (GearyAppDraftManager* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), FALSE);
	result = self->priv->_is_open;
	return result;
}

static void
geary_app_draft_manager_set_is_open (GearyAppDraftManager* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	old_value = geary_app_draft_manager_get_is_open (self);
	if (old_value != value) {
		self->priv->_is_open = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY]);
	}
}

GearyAppDraftManagerDraftState
geary_app_draft_manager_get_draft_state (GearyAppDraftManager* self)
{
	GearyAppDraftManagerDraftState result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), 0);
	result = self->priv->_draft_state;
	return result;
}

static void
geary_app_draft_manager_set_draft_state (GearyAppDraftManager* self,
                                         GearyAppDraftManagerDraftState value)
{
	GearyAppDraftManagerDraftState old_value;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	old_value = geary_app_draft_manager_get_draft_state (self);
	if (old_value != value) {
		self->priv->_draft_state = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY]);
	}
}

GearyEmailIdentifier*
geary_app_draft_manager_get_current_draft_id (GearyAppDraftManager* self)
{
	GearyEmailIdentifier* result;
	GearyEmailIdentifier* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), NULL);
	_tmp0_ = self->priv->_current_draft_id;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_app_draft_manager_set_current_draft_id (GearyAppDraftManager* self,
                                              GearyEmailIdentifier* value)
{
	GearyEmailIdentifier* old_value;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	old_value = geary_app_draft_manager_get_current_draft_id (self);
	if (old_value != value) {
		GearyEmailIdentifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_draft_id);
		self->priv->_current_draft_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY]);
	}
}

gint
geary_app_draft_manager_get_versions_saved (GearyAppDraftManager* self)
{
	gint result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), 0);
	result = self->priv->_versions_saved;
	return result;
}

static void
geary_app_draft_manager_set_versions_saved (GearyAppDraftManager* self,
                                            gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	old_value = geary_app_draft_manager_get_versions_saved (self);
	if (old_value != value) {
		self->priv->_versions_saved = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY]);
	}
}

gint
geary_app_draft_manager_get_versions_dropped (GearyAppDraftManager* self)
{
	gint result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), 0);
	result = self->priv->_versions_dropped;
	return result;
}

static void
geary_app_draft_manager_set_versions_dropped (GearyAppDraftManager* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	old_value = geary_app_draft_manager_get_versions_dropped (self);
	if (old_value != value) {
		self->priv->_versions_dropped = value;
		g_object_notify_by_pspec ((GObject *) self, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY]);
	}
}

static void
geary_app_draft_manager_real_draft_failed (GearyAppDraftManager* self,
                                           GearyRFC822Message* draft,
                                           GError* err)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (draft));
	g_return_if_fail (err != NULL);
	_tmp0_ = geary_app_draft_manager_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = err->message;
	g_debug ("app-draft-manager.vala:153: %s: Unable to create draft: %s", _tmp1_, _tmp2_);
	_g_free0 (_tmp1_);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
geary_app_draft_manager_real_fatal (GearyAppDraftManager* self,
                                    GError* err)
{
	GError* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (err != NULL);
	_tmp0_ = _g_error_copy0 (err);
	_g_error_free0 (self->priv->fatal_err);
	self->priv->fatal_err = _tmp0_;
	_tmp1_ = geary_app_draft_manager_to_string (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = err->message;
	g_debug ("app-draft-manager.vala:164: %s: Irrecoverable failure: %s", _tmp2_, _tmp3_);
	_g_free0 (_tmp2_);
}

static void
geary_app_draft_manager_real_notify_stored (GearyAppDraftManager* self,
                                            GearyRFC822Message* draft)
{
	gint _tmp0_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (draft));
	_tmp0_ = self->priv->_versions_saved;
	geary_app_draft_manager_set_versions_saved (self, _tmp0_ + 1);
	g_signal_emit (self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_STORED_SIGNAL], 0, draft);
}

void
geary_app_draft_manager_notify_stored (GearyAppDraftManager* self,
                                       GearyRFC822Message* draft)
{
	GearyAppDraftManagerClass* _klass_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	_klass_ = GEARY_APP_DRAFT_MANAGER_GET_CLASS (self);
	if (_klass_->notify_stored) {
		_klass_->notify_stored (self, draft);
	}
}

static void
geary_app_draft_manager_real_notify_discarded (GearyAppDraftManager* self)
{
	geary_app_draft_manager_set_versions_saved (self, 0);
	g_signal_emit (self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DISCARDED_SIGNAL], 0);
}

void
geary_app_draft_manager_notify_discarded (GearyAppDraftManager* self)
{
	GearyAppDraftManagerClass* _klass_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	_klass_ = GEARY_APP_DRAFT_MANAGER_GET_CLASS (self);
	if (_klass_->notify_discarded) {
		_klass_->notify_discarded (self);
	}
}

static void
geary_app_draft_manager_construct_data_free (gpointer _data)
{
	GearyAppDraftManagerNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->save_to);
	_g_object_unref0 (_data_->flags);
	_g_object_unref0 (_data_->initial_draft_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerNewData, _data_);
}

void
geary_app_draft_manager_construct (GType object_type,
                                   GearyAccount* account,
                                   GearyFolder* save_to,
                                   GearyEmailFlags* flags,
                                   GearyEmailIdentifier* initial_draft_id,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GearyAppDraftManagerNewData* _data_;
	GearyAccount* _tmp0_;
	GearyFolder* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GearyEmailIdentifier* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (GEARY_IS_ACCOUNT (account));
	g_return_if_fail (GEARY_IS_FOLDER (save_to));
	g_return_if_fail (GEARY_IS_EMAIL_FLAGS (flags));
	g_return_if_fail ((initial_draft_id == NULL) || GEARY_IS_EMAIL_IDENTIFIER (initial_draft_id));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppDraftManagerNewData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp0_;
	_tmp1_ = _g_object_ref0 (save_to);
	_g_object_unref0 (_data_->save_to);
	_data_->save_to = _tmp1_;
	_tmp2_ = _g_object_ref0 (flags);
	_g_object_unref0 (_data_->flags);
	_data_->flags = _tmp2_;
	_tmp3_ = _g_object_ref0 (initial_draft_id);
	_g_object_unref0 (_data_->initial_draft_id);
	_data_->initial_draft_id = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	geary_app_draft_manager_construct_co (_data_);
}

GearyAppDraftManager*
geary_app_draft_manager_construct_finish (GAsyncResult* _res_,
                                          GError** error)
{
	GearyAppDraftManager* result;
	GearyAppDraftManagerNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

/**
     * Open the {@link DraftManager} and prepare it for handling composed messages.
     *
     * An initial draft EmailIdentifier may be supplied indicating the starting draft (when editing,
     * not creating a new draft).  No checking is performed to ensure this EmailIdentifier is valid
     * for the drafts folder, nor is it downloaded by DraftManager.  In essence, this email is
     * deleted by the manager when the first {@link update} occurs or the draft is
     * {@link discard}ed.
     *
     * If an initial_draft is supplied, {@link draft_state} will be set to {@link DraftState.STORED}.
     *
     * Other method calls should not be invoked until this completes successfully.
     *
     * @see is_open
     */
static void
_geary_app_draft_manager_on_folder_closed_geary_folder_closed (GearyFolder* _sender,
                                                               GearyFolderCloseReason reason,
                                                               gpointer self)
{
	geary_app_draft_manager_on_folder_closed ((GearyAppDraftManager*) self, reason);
}

static void
geary_app_draft_manager_new_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GearyAppDraftManagerNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_construct_co (_data_);
}

static gboolean
geary_app_draft_manager_construct_co (GearyAppDraftManagerNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (GearyAppDraftManager*) geary_base_object_construct (_data_->object_type);
	_data_->_tmp0_ = _g_object_ref0 (_data_->account);
	_g_object_unref0 (_data_->self->priv->account);
	_data_->self->priv->account = _data_->_tmp0_;
	_data_->_tmp1_ = _g_object_ref0 (_data_->save_to);
	_g_object_unref0 (_data_->self->priv->drafts_folder);
	_data_->self->priv->drafts_folder = _data_->_tmp1_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->flags);
	_g_object_unref0 (_data_->self->priv->flags);
	_data_->self->priv->flags = _data_->_tmp2_;
	geary_app_draft_manager_set_current_draft_id (_data_->self, _data_->initial_draft_id);
	_data_->_tmp3_ = _data_->self->priv->_current_draft_id;
	if (_data_->_tmp3_ != NULL) {
		geary_app_draft_manager_set_draft_state (_data_->self, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORED);
	}
	if (GEARY_FOLDER_SUPPORT_IS_CREATE (_data_->save_to)) {
		_data_->_tmp4_ = GEARY_FOLDER_SUPPORT_IS_REMOVE (_data_->save_to);
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (!_data_->_tmp4_) {
		_data_->_tmp5_ = geary_app_draft_manager_to_string (_data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->self->priv->drafts_folder;
		_data_->_tmp8_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "%s: Drafts folder %s does not support create and remove", _data_->_tmp6_, _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_g_free0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp11_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->save_to, GEARY_FOLDER_SUPPORT_TYPE_CREATE, GearyFolderSupportCreate));
	_g_object_unref0 (_data_->self->priv->create_support);
	_data_->self->priv->create_support = _data_->_tmp12_;
	_data_->_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->save_to, GEARY_FOLDER_SUPPORT_TYPE_REMOVE, GearyFolderSupportRemove));
	_g_object_unref0 (_data_->self->priv->remove_support);
	_data_->self->priv->remove_support = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->self->priv->drafts_folder;
	g_signal_connect_object (_data_->_tmp14_, "closed", (GCallback) _geary_app_draft_manager_on_folder_closed_geary_folder_closed, _data_->self, 0);
	_data_->_tmp15_ = _data_->self->priv->drafts_folder;
	_data_->_state_ = 1;
	geary_folder_open_async (_data_->_tmp15_, GEARY_FOLDER_OPEN_FLAGS_NO_DELAY, _data_->cancellable, geary_app_draft_manager_new_ready, _data_);
	return FALSE;
	_state_1:
	geary_folder_open_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->self->priv->drafts_folder;
	_data_->_tmp17_ = _g_object_ref0 (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (_data_->_tmp16_) ? ((GearyImapEngineMinimalFolder*) _data_->_tmp16_) : NULL);
	_data_->engine = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->engine;
	if (_data_->_tmp18_ != NULL) {
		_data_->_tmp19_ = _data_->engine;
		_data_->_state_ = 2;
		geary_imap_engine_minimal_folder_claim_remote_session (_data_->_tmp19_, _data_->cancellable, geary_app_draft_manager_new_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp20_ = geary_imap_engine_minimal_folder_claim_remote_session_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_g_object_unref0 (_data_->_tmp21_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->engine);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp22_ = _data_->self->priv->drafts_folder;
	_data_->_tmp23_ = geary_folder_get_properties (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = geary_folder_properties_get_create_never_returns_id (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (_data_->_tmp26_) {
		{
			_data_->_tmp27_ = _data_->self->priv->drafts_folder;
			_data_->_state_ = 3;
			geary_folder_close_async (_data_->_tmp27_, NULL, geary_app_draft_manager_new_ready, _data_);
			return FALSE;
			_state_3:
			geary_folder_close_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->engine);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp28_ = geary_app_draft_manager_to_string (_data_->self);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = _data_->self->priv->drafts_folder;
		_data_->_tmp31_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "%s: Drafts folder %s does not return created mail ID", _data_->_tmp29_, _data_->_tmp32_);
		_data_->_tmp34_ = _data_->_tmp33_;
		_g_free0 (_data_->_tmp32_);
		_g_free0 (_data_->_tmp29_);
		_data_->_inner_error0_ = _data_->_tmp34_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->engine);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_app_draft_manager_operation_loop_async (_data_->self, NULL, NULL);
	_g_object_unref0 (_data_->engine);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_app_draft_manager_new (GearyAccount* account,
                             GearyFolder* save_to,
                             GearyEmailFlags* flags,
                             GearyEmailIdentifier* initial_draft_id,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	geary_app_draft_manager_construct (GEARY_APP_TYPE_DRAFT_MANAGER, account, save_to, flags, initial_draft_id, cancellable, _callback_, _user_data_);
}

GearyAppDraftManager*
geary_app_draft_manager_new_finish (GAsyncResult* _res_,
                                    GError** error)
{
	return geary_app_draft_manager_construct_finish (_res_, error);
}

static void
geary_app_draft_manager_on_folder_closed (GearyAppDraftManager* self,
                                          GearyFolderCloseReason reason)
{
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	if (reason == GEARY_FOLDER_CLOSE_REASON_FOLDER_CLOSED) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp0_ = geary_app_draft_manager_to_string (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_enum_to_string (GEARY_FOLDER_TYPE_CLOSE_REASON, reason);
		_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_SERVER_UNAVAILABLE, "%s: Unexpected drafts folder closed (%s)", _tmp1_, _tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_emit (self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_FATAL_SIGNAL], 0, _tmp4_);
		_g_error_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
	}
}

static void
geary_app_draft_manager_close_async_data_free (gpointer _data)
{
	GearyAppDraftManagerCloseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerCloseAsyncData, _data_);
}

void
geary_app_draft_manager_close_async (GearyAppDraftManager* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyAppDraftManagerCloseAsyncData* _data_;
	GearyAppDraftManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppDraftManagerCloseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_close_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_app_draft_manager_close_async_co (_data_);
}

void
geary_app_draft_manager_close_finish (GearyAppDraftManager* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GearyAppDraftManagerCloseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Flush pending operations and close the {@link DraftManager}.
     *
     * Once closed, the object cannot be opened again.  Create a new object in that case.
     *
     * @see is_open
     */
static void
geary_app_draft_manager_close_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GearyAppDraftManagerCloseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_close_async_co (_data_);
}

static gboolean
geary_app_draft_manager_close_async_co (GearyAppDraftManagerCloseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_is_open;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->drafts_folder;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_app_draft_manager_set_is_open (_data_->self, FALSE);
	_data_->_tmp3_ = _data_->self->priv->fatal_err;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = geary_nonblocking_semaphore_new (_data_->cancellable);
		_data_->semaphore = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->priv->mailbox;
		_data_->_tmp6_ = _data_->semaphore;
		_data_->_tmp7_ = geary_app_draft_manager_operation_new (GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_CLOSE, NULL, NULL, NULL, _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		geary_nonblocking_queue_send (_data_->_tmp5_, _data_->_tmp8_);
		_g_object_unref0 (_data_->_tmp8_);
		{
			_data_->_tmp9_ = _data_->semaphore;
			_data_->_state_ = 1;
			geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_app_draft_manager_close_async_ready, _data_);
			return FALSE;
			_state_1:
			geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->err;
			if (g_error_matches (_data_->_tmp10_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp11_ = _data_->err;
				_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
				_data_->_inner_error0_ = _data_->_tmp12_;
				_g_error_free0 (_data_->err);
				goto __finally0;
			}
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->semaphore);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->semaphore);
	}
	_data_->_tmp13_ = _data_->self->priv->drafts_folder;
	g_signal_parse_name ("closed", GEARY_TYPE_FOLDER, &_data_->_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp14_, 0, NULL, (GCallback) _geary_app_draft_manager_on_folder_closed_geary_folder_closed, _data_->self);
	_data_->_tmp15_ = _data_->self->priv->drafts_folder;
	_data_->_state_ = 2;
	geary_folder_close_async (_data_->_tmp15_, _data_->cancellable, geary_app_draft_manager_close_async_ready, _data_);
	return FALSE;
	_state_2:
	geary_folder_close_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_draft_manager_check_open (GearyAppDraftManager* self,
                                    GError** error)
{
	gboolean _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	_tmp0_ = self->priv->_is_open;
	if (!_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_app_draft_manager_to_string (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_OPEN_REQUIRED, "%s is not open", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_app_draft_manager_update_data_free (gpointer _data)
{
	GearyAppDraftManagerUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->draft);
	_g_date_time_unref0 (_data_->date_received);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerUpdateData, _data_);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
geary_app_draft_manager_update (GearyAppDraftManager* self,
                                GearyRFC822Message* draft,
                                GDateTime* date_received,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearyAppDraftManagerUpdateData* _data_;
	GearyAppDraftManager* _tmp0_;
	GearyRFC822Message* _tmp1_;
	GDateTime* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (draft));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppDraftManagerUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (draft);
	_g_object_unref0 (_data_->draft);
	_data_->draft = _tmp1_;
	_tmp2_ = _g_date_time_ref0 (date_received);
	_g_date_time_unref0 (_data_->date_received);
	_data_->date_received = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_app_draft_manager_update_co (_data_);
}

void
geary_app_draft_manager_update_finish (GearyAppDraftManager* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GearyAppDraftManagerUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Save draft on the server, potentially replacing (deleting) an already-existing version.
     *
     * See {@link FolderSupport.Create.create_email_async} for more information on the flags and
     * date_received arguments.
     */
static void
geary_app_draft_manager_update_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearyAppDraftManagerUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_update_co (_data_);
}

static gboolean
geary_app_draft_manager_update_co (GearyAppDraftManagerUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_app_draft_manager_check_open (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->flags;
	_data_->_tmp1_ = geary_app_draft_manager_submit_push (_data_->self, _data_->draft, _data_->_tmp0_, _data_->date_received);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_app_draft_manager_update_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp2_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_draft_manager_discard_data_free (gpointer _data)
{
	GearyAppDraftManagerDiscardData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerDiscardData, _data_);
}

void
geary_app_draft_manager_discard (GearyAppDraftManager* self,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GearyAppDraftManagerDiscardData* _data_;
	GearyAppDraftManager* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAppDraftManagerDiscardData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_discard_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_app_draft_manager_discard_co (_data_);
}

void
geary_app_draft_manager_discard_finish (GearyAppDraftManager* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearyAppDraftManagerDiscardData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Delete all versions of the composed email from the server.
     *
     * This is appropriate both for the user cancelling (discarding) a composed message or if the
     * user sends it.
     *
     * Note: Replaced drafts are deleted, but on some services (i.e. Gmail) those deleted messages
     * are actually moved to the Trash.  This call does not currently solve that problem.
     */
static void
geary_app_draft_manager_discard_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GearyAppDraftManagerDiscardData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_discard_co (_data_);
}

static gboolean
geary_app_draft_manager_discard_co (GearyAppDraftManagerDiscardData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_app_draft_manager_check_open (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_app_draft_manager_submit_push (_data_->self, NULL, NULL, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_app_draft_manager_discard_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda174_ (GearyAppDraftManager* self,
              GearyAppDraftManagerOperation* op)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail ((op == NULL) || GEARY_APP_DRAFT_MANAGER_IS_OPERATION (op), FALSE);
	if (op->op_type == GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH) {
		GearyRFC822Message* _tmp1_;
		_tmp1_ = op->draft;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_;
		GearyRFC822Message* _tmp3_;
		_tmp2_ = self->priv->_versions_dropped;
		geary_app_draft_manager_set_versions_dropped (self, _tmp2_ + 1);
		_tmp3_ = op->draft;
		g_signal_emit (self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DROPPED_SIGNAL], 0, _tmp3_);
	}
	result = op->op_type == GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH;
	return result;
}

static gboolean
___lambda174__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda174_ ((GearyAppDraftManager*) self, (GearyAppDraftManagerOperation*) g);
	return result;
}

static GearyNonblockingSemaphore*
geary_app_draft_manager_submit_push (GearyAppDraftManager* self,
                                     GearyRFC822Message* draft,
                                     GearyEmailFlags* flags,
                                     GDateTime* date_received)
{
	GearyNonblockingQueue* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GearyNonblockingSemaphore* semaphore = NULL;
	GearyNonblockingSemaphore* _tmp3_;
	GearyNonblockingQueue* _tmp4_;
	GearyAppDraftManagerOperation* _tmp5_;
	GearyAppDraftManagerOperation* _tmp6_;
	GearyNonblockingSemaphore* result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), NULL);
	g_return_val_if_fail ((draft == NULL) || GEARY_RF_C822_IS_MESSAGE (draft), NULL);
	g_return_val_if_fail ((flags == NULL) || GEARY_IS_EMAIL_FLAGS (flags), NULL);
	_tmp0_ = self->priv->mailbox;
	_tmp1_ = geary_nonblocking_queue_revoke_matching (_tmp0_, ___lambda174__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = geary_nonblocking_semaphore_new (NULL);
	semaphore = _tmp3_;
	_tmp4_ = self->priv->mailbox;
	_tmp5_ = geary_app_draft_manager_operation_new (GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH, draft, flags, date_received, semaphore);
	_tmp6_ = _tmp5_;
	geary_nonblocking_queue_send (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	result = semaphore;
	return result;
}

static void
geary_app_draft_manager_operation_loop_async_data_free (gpointer _data)
{
	GearyAppDraftManagerOperationLoopAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerOperationLoopAsyncData, _data_);
}

static void
geary_app_draft_manager_operation_loop_async (GearyAppDraftManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyAppDraftManagerOperationLoopAsyncData* _data_;
	GearyAppDraftManager* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	_data_ = g_slice_new0 (GearyAppDraftManagerOperationLoopAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_operation_loop_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_app_draft_manager_operation_loop_async_co (_data_);
}

static void
geary_app_draft_manager_operation_loop_finish (GearyAppDraftManager* self,
                                               GAsyncResult* _res_)
{
	GearyAppDraftManagerOperationLoopAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_app_draft_manager_operation_loop_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearyAppDraftManagerOperationLoopAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_operation_loop_async_co (_data_);
}

static gboolean
geary_app_draft_manager_operation_loop_async_co (GearyAppDraftManagerOperationLoopAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp0_) {
			}
			_data_->_tmp0_ = FALSE;
			_data_->_tmp1_ = _data_->self->priv->fatal_err;
			if (_data_->_tmp1_ != NULL) {
				break;
			}
			{
				_data_->_tmp3_ = _data_->self->priv->mailbox;
				_data_->_state_ = 1;
				geary_nonblocking_queue_receive (_data_->_tmp3_, NULL, geary_app_draft_manager_operation_loop_async_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp4_ = geary_nonblocking_queue_receive_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp2_ = (GearyAppDraftManagerOperation*) _data_->_tmp4_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp5_ = _data_->_tmp2_;
				_data_->_tmp2_ = NULL;
				_g_object_unref0 (_data_->op);
				_data_->op = _data_->_tmp5_;
				_g_object_unref0 (_data_->_tmp2_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp6_ = _data_->err;
				g_signal_emit (_data_->self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_FATAL_SIGNAL], 0, _data_->_tmp6_);
				_g_error_free0 (_data_->err);
				_g_object_unref0 (_data_->op);
				break;
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->op);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp7_ = _data_->op;
			_data_->_state_ = 2;
			geary_app_draft_manager_operation_loop_iteration_async (_data_->self, _data_->_tmp7_, geary_app_draft_manager_operation_loop_async_ready, _data_);
			return FALSE;
			_state_2:
			_data_->continue_loop = geary_app_draft_manager_operation_loop_iteration_finish (_data_->self, _data_->_res_);
			_data_->_tmp8_ = _data_->op;
			_data_->_tmp9_ = _data_->_tmp8_->semaphore;
			if (_data_->_tmp9_ != NULL) {
				_data_->_tmp10_ = _data_->op;
				_data_->_tmp11_ = _data_->_tmp10_->semaphore;
				geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
			}
			if (!_data_->continue_loop) {
				_g_object_unref0 (_data_->op);
				break;
			}
			_g_object_unref0 (_data_->op);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_app_draft_manager_operation_loop_iteration_async_data_free (gpointer _data)
{
	GearyAppDraftManagerOperationLoopIterationAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->op);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAppDraftManagerOperationLoopIterationAsyncData, _data_);
}

static void
geary_app_draft_manager_operation_loop_iteration_async (GearyAppDraftManager* self,
                                                        GearyAppDraftManagerOperation* op,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyAppDraftManagerOperationLoopIterationAsyncData* _data_;
	GearyAppDraftManager* _tmp0_;
	GearyAppDraftManagerOperation* _tmp1_;
	g_return_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self));
	g_return_if_fail (GEARY_APP_DRAFT_MANAGER_IS_OPERATION (op));
	_data_ = g_slice_new0 (GearyAppDraftManagerOperationLoopIterationAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_app_draft_manager_operation_loop_iteration_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (op);
	_g_object_unref0 (_data_->op);
	_data_->op = _tmp1_;
	geary_app_draft_manager_operation_loop_iteration_async_co (_data_);
}

static gboolean
geary_app_draft_manager_operation_loop_iteration_finish (GearyAppDraftManager* self,
                                                         GAsyncResult* _res_)
{
	gboolean result;
	GearyAppDraftManagerOperationLoopIterationAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
geary_app_draft_manager_operation_loop_iteration_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GearyAppDraftManagerOperationLoopIterationAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_app_draft_manager_operation_loop_iteration_async_co (_data_);
}

static gboolean
geary_app_draft_manager_operation_loop_iteration_async_co (GearyAppDraftManagerOperationLoopIterationAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->op->op_type == GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_CLOSE) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->drafts_folder;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->drafts_folder;
		_data_->_tmp0_ = geary_folder_get_open_state (_data_->_tmp2_) == GEARY_FOLDER_OPEN_STATE_CLOSED;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp3_ = geary_app_draft_manager_to_string (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_SERVER_UNAVAILABLE, "%s: premature drafts folder close", _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_signal_emit (_data_->self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_FATAL_SIGNAL], 0, _data_->_tmp6_);
		_g_error_free0 (_data_->_tmp6_);
		_g_free0 (_data_->_tmp4_);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_vala_assert (_data_->op->op_type == GEARY_APP_DRAFT_MANAGER_OPERATION_TYPE_PUSH, "op.op_type == OperationType.PUSH");
	geary_app_draft_manager_set_draft_state (_data_->self, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORING);
	_data_->_tmp7_ = _data_->op->draft;
	if (_data_->_tmp7_ != NULL) {
		{
			_data_->_tmp8_ = _data_->self->priv->_current_draft_id;
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
			_data_->old_id = _data_->_tmp9_;
			_data_->_tmp11_ = _data_->self->priv->create_support;
			_data_->_tmp12_ = _data_->op->draft;
			_data_->_tmp13_ = _data_->op->flags;
			_data_->_tmp14_ = _data_->op->date_received;
			_data_->_state_ = 1;
			geary_folder_support_create_create_email_async (_data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_, NULL, geary_app_draft_manager_operation_loop_iteration_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp15_ = geary_folder_support_create_create_email_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp10_ = _data_->_tmp15_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->old_id);
				goto __catch0_g_error;
			}
			geary_app_draft_manager_set_current_draft_id (_data_->self, _data_->_tmp10_);
			_data_->_tmp16_ = _data_->old_id;
			if (_data_->_tmp16_ != NULL) {
				_data_->_tmp17_ = _data_->self->priv->remove_support;
				_data_->_tmp18_ = _data_->old_id;
				_data_->_tmp19_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_state_ = 2;
				geary_folder_support_remove_remove_email_async (_data_->_tmp17_, _data_->_tmp20_, NULL, geary_app_draft_manager_operation_loop_iteration_async_ready, _data_);
				return FALSE;
				_state_2:
				geary_folder_support_remove_remove_email_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
				_g_object_unref0 (_data_->_tmp20_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->_tmp10_);
					_g_object_unref0 (_data_->old_id);
					goto __catch0_g_error;
				}
			}
			geary_app_draft_manager_set_draft_state (_data_->self, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_STORED);
			_data_->_tmp21_ = _data_->op->draft;
			geary_app_draft_manager_notify_stored (_data_->self, _data_->_tmp21_);
			_g_object_unref0 (_data_->_tmp10_);
			_g_object_unref0 (_data_->old_id);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			geary_app_draft_manager_set_draft_state (_data_->self, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_ERROR);
			_data_->_tmp22_ = _data_->op->draft;
			_data_->_tmp23_ = _data_->err;
			g_signal_emit (_data_->self, geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DRAFT_FAILED_SIGNAL], 0, _data_->_tmp22_, _data_->_tmp23_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		geary_app_draft_manager_set_draft_state (_data_->self, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_NOT_STORED);
		_data_->_tmp24_ = _data_->self->priv->_current_draft_id;
		if (_data_->_tmp24_ != NULL) {
			{
				_data_->_tmp25_ = _data_->self->priv->remove_support;
				_data_->_tmp26_ = _data_->self->priv->_current_draft_id;
				_data_->_tmp27_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp26_);
				_data_->_tmp28_ = _data_->_tmp27_;
				_data_->_state_ = 3;
				geary_folder_support_remove_remove_email_async (_data_->_tmp25_, _data_->_tmp28_, NULL, geary_app_draft_manager_operation_loop_iteration_async_ready, _data_);
				return FALSE;
				_state_3:
				geary_folder_support_remove_remove_email_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error0_);
				_g_object_unref0 (_data_->_tmp28_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				geary_app_draft_manager_notify_discarded (_data_->self);
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp29_ = geary_app_draft_manager_to_string (_data_->self);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = _data_->self->priv->_current_draft_id;
				_data_->_tmp32_ = geary_email_identifier_to_string (_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = _data_->_vala1_err;
				_data_->_tmp35_ = _data_->_tmp34_->message;
				g_warning ("app-draft-manager.vala:434: %s: Unable to remove existing draft %s: %s", _data_->_tmp30_, _data_->_tmp33_, _data_->_tmp35_);
				_g_free0 (_data_->_tmp33_);
				_g_free0 (_data_->_tmp30_);
				_g_error_free0 (_data_->_vala1_err);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
geary_app_draft_manager_to_string (GearyAppDraftManager* self)
{
	GearyAccount* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (GEARY_APP_IS_DRAFT_MANAGER (self), NULL);
	_tmp0_ = self->priv->account;
	_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s DraftManager", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static GearyAppDraftManagerOperation*
geary_app_draft_manager_operation_construct (GType object_type,
                                             GearyAppDraftManagerOperationType op_type,
                                             GearyRFC822Message* draft,
                                             GearyEmailFlags* flags,
                                             GDateTime* date_received,
                                             GearyNonblockingSemaphore* semaphore)
{
	GearyAppDraftManagerOperation * self = NULL;
	GearyRFC822Message* _tmp0_;
	GearyEmailFlags* _tmp1_;
	GDateTime* _tmp2_;
	GearyNonblockingSemaphore* _tmp3_;
	g_return_val_if_fail ((draft == NULL) || GEARY_RF_C822_IS_MESSAGE (draft), NULL);
	g_return_val_if_fail ((flags == NULL) || GEARY_IS_EMAIL_FLAGS (flags), NULL);
	g_return_val_if_fail ((semaphore == NULL) || GEARY_NONBLOCKING_IS_SEMAPHORE (semaphore), NULL);
	self = (GearyAppDraftManagerOperation*) geary_base_object_construct (object_type);
	self->op_type = op_type;
	_tmp0_ = _g_object_ref0 (draft);
	_g_object_unref0 (self->draft);
	self->draft = _tmp0_;
	_tmp1_ = _g_object_ref0 (flags);
	_g_object_unref0 (self->flags);
	self->flags = _tmp1_;
	_tmp2_ = _g_date_time_ref0 (date_received);
	_g_date_time_unref0 (self->date_received);
	self->date_received = _tmp2_;
	_tmp3_ = _g_object_ref0 (semaphore);
	_g_object_unref0 (self->semaphore);
	self->semaphore = _tmp3_;
	return self;
}

static GearyAppDraftManagerOperation*
geary_app_draft_manager_operation_new (GearyAppDraftManagerOperationType op_type,
                                       GearyRFC822Message* draft,
                                       GearyEmailFlags* flags,
                                       GDateTime* date_received,
                                       GearyNonblockingSemaphore* semaphore)
{
	return geary_app_draft_manager_operation_construct (GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, op_type, draft, flags, date_received, semaphore);
}

static void
geary_app_draft_manager_operation_class_init (GearyAppDraftManagerOperationClass * klass,
                                              gpointer klass_data)
{
	geary_app_draft_manager_operation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = geary_app_draft_manager_operation_finalize;
}

static void
geary_app_draft_manager_operation_instance_init (GearyAppDraftManagerOperation * self,
                                                 gpointer klass)
{
}

static void
geary_app_draft_manager_operation_finalize (GObject * obj)
{
	GearyAppDraftManagerOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, GearyAppDraftManagerOperation);
	_g_object_unref0 (self->draft);
	_g_object_unref0 (self->flags);
	_g_date_time_unref0 (self->date_received);
	_g_object_unref0 (self->semaphore);
	G_OBJECT_CLASS (geary_app_draft_manager_operation_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_app_draft_manager_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppDraftManagerOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_draft_manager_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppDraftManagerOperation), 0, (GInstanceInitFunc) geary_app_draft_manager_operation_instance_init, NULL };
	GType geary_app_draft_manager_operation_type_id;
	geary_app_draft_manager_operation_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppDraftManagerOperation", &g_define_type_info, 0);
	return geary_app_draft_manager_operation_type_id;
}

static GType
geary_app_draft_manager_operation_get_type (void)
{
	static gsize geary_app_draft_manager_operation_type_id__once = 0;
	if (g_once_init_enter (&geary_app_draft_manager_operation_type_id__once)) {
		GType geary_app_draft_manager_operation_type_id;
		geary_app_draft_manager_operation_type_id = geary_app_draft_manager_operation_get_type_once ();
		g_once_init_leave (&geary_app_draft_manager_operation_type_id__once, geary_app_draft_manager_operation_type_id);
	}
	return geary_app_draft_manager_operation_type_id__once;
}

static void
geary_app_draft_manager_class_init (GearyAppDraftManagerClass * klass,
                                    gpointer klass_data)
{
	geary_app_draft_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppDraftManager_private_offset);
	((GearyAppDraftManagerClass *) klass)->notify_stored = (void (*) (GearyAppDraftManager*, GearyRFC822Message*)) geary_app_draft_manager_real_notify_stored;
	((GearyAppDraftManagerClass *) klass)->notify_discarded = (void (*) (GearyAppDraftManager*)) geary_app_draft_manager_real_notify_discarded;
	((GearyAppDraftManagerClass *) klass)->draft_failed = geary_app_draft_manager_real_draft_failed;
	((GearyAppDraftManagerClass *) klass)->fatal = geary_app_draft_manager_real_fatal;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_draft_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_draft_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_draft_manager_finalize;
	/**
	     * Indicates the {@link DraftManager} is open and ready for service.
	     *
	     * The object is considered "open" from when it has been
	     * constructed until {@link close_async} is called.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY] = g_param_spec_boolean ("is-open", "is-open", "is-open", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The current saved state of the draft.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY] = g_param_spec_enum ("draft-state", "draft-state", "draft-state", GEARY_APP_DRAFT_MANAGER_TYPE_DRAFT_STATE, GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_NOT_STORED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The {@link Geary.EmailIdentifier} of the last saved draft.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY] = g_param_spec_object ("current-draft-id", "current-draft-id", "current-draft-id", GEARY_TYPE_EMAIL_IDENTIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The version number of the most recently saved draft.
	     *
	     * Even if an initial draft is supplied, this always starts at zero.
	     * It merely represents the number of times a draft was successfully saved.
	     *
	     * A {@link discard} operation will reset this counter to zero.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY] = g_param_spec_int ("versions-saved", "versions-saved", "versions-saved", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The number of drafts dropped as new ones are added to the queue.
	     *
	     * @see dropped
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY, geary_app_draft_manager_properties[GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY] = g_param_spec_int ("versions-dropped", "versions-dropped", "versions-dropped", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when a draft is successfully saved.
	     */
	geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_STORED_SIGNAL] = g_signal_new ("stored", GEARY_APP_TYPE_DRAFT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_RF_C822_TYPE_MESSAGE);
	/**
	     * Fired when a draft is discarded.
	     */
	geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DISCARDED_SIGNAL] = g_signal_new ("discarded", GEARY_APP_TYPE_DRAFT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Fired when a draft is dropped.
	     *
	     * This occurs when a draft is scheduled for {@link update} while another draft is queued
	     * to be pushed to the server.  The queued draft is dropped in favor of the new one.
	     */
	geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DROPPED_SIGNAL] = g_signal_new ("dropped", GEARY_APP_TYPE_DRAFT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_RF_C822_TYPE_MESSAGE);
	/**
	     * Fired when unable to save a draft but the {@link DraftManager} remains open.
	     *
	     * Due to unpredictability of errors being reported, it's possible this signal will fire after
	     * {@link fatal}.  It should not be assumed this signal firing means DraftManager is still
	     * operational, but if fatal fires, it definitely is not operational.
	     */
	geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_DRAFT_FAILED_SIGNAL] = g_signal_new ("draft-failed", GEARY_APP_TYPE_DRAFT_MANAGER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyAppDraftManagerClass, draft_failed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, GEARY_RF_C822_TYPE_MESSAGE, G_TYPE_POINTER);
	/**
	     * Fired if an unrecoverable error occurs while processing drafts.
	     *
	     * The {@link DraftManager} will be unable to process future drafts.
	     */
	geary_app_draft_manager_signals[GEARY_APP_DRAFT_MANAGER_FATAL_SIGNAL] = g_signal_new ("fatal", GEARY_APP_TYPE_DRAFT_MANAGER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearyAppDraftManagerClass, fatal), NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
geary_app_draft_manager_instance_init (GearyAppDraftManager * self,
                                       gpointer klass)
{
	GearyNonblockingQueue* _tmp0_;
	self->priv = geary_app_draft_manager_get_instance_private (self);
	self->priv->_is_open = TRUE;
	self->priv->_draft_state = GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_NOT_STORED;
	self->priv->_current_draft_id = NULL;
	self->priv->_versions_saved = 0;
	self->priv->_versions_dropped = 0;
	self->priv->flags = NULL;
	_tmp0_ = geary_nonblocking_queue_new_fifo (GEARY_APP_DRAFT_MANAGER_TYPE_OPERATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->mailbox = _tmp0_;
	self->priv->fatal_err = NULL;
}

static void
geary_app_draft_manager_finalize (GObject * obj)
{
	GearyAppDraftManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_DRAFT_MANAGER, GearyAppDraftManager);
	_g_object_unref0 (self->priv->_current_draft_id);
	_g_object_unref0 (self->priv->account);
	_g_object_unref0 (self->priv->flags);
	_g_object_unref0 (self->priv->drafts_folder);
	_g_object_unref0 (self->priv->create_support);
	_g_object_unref0 (self->priv->remove_support);
	_g_object_unref0 (self->priv->mailbox);
	_g_error_free0 (self->priv->fatal_err);
	G_OBJECT_CLASS (geary_app_draft_manager_parent_class)->finalize (obj);
}

/**
 * Manage saving, replacing, and deleting an email being edited.
 *
 * Each composer should create a single DraftManager object for the
 * lifetime of the compose session.  The DraftManager interface offers
 * "fire-and-forget" nonblocking methods for the composer to schedule
 * remote operations without worrying about synchronization, operation
 * ordering, error-handling, and so forth.
 *
 * If successive drafts are submitted for storage, drafts waiting in
 * the queue (i.e. not yet sent to the server) are dropped without
 * further consideration.  This prevents needless I/O with the server
 * saving drafts that are only to be replaced by later versions.
 *
 * Important: This object should be used ''per'' composed email and
 * not to manage multiple emails being composed to the same {@link
 * Account}.  DraftManager's internal state is solely for managing the
 * lifecycle of a single email being composed by the user.
 */
 G_GNUC_NO_INLINE static GType
geary_app_draft_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppDraftManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_draft_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppDraftManager), 0, (GInstanceInitFunc) geary_app_draft_manager_instance_init, NULL };
	GType geary_app_draft_manager_type_id;
	geary_app_draft_manager_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppDraftManager", &g_define_type_info, 0);
	GearyAppDraftManager_private_offset = g_type_add_instance_private (geary_app_draft_manager_type_id, sizeof (GearyAppDraftManagerPrivate));
	return geary_app_draft_manager_type_id;
}

GType
geary_app_draft_manager_get_type (void)
{
	static gsize geary_app_draft_manager_type_id__once = 0;
	if (g_once_init_enter (&geary_app_draft_manager_type_id__once)) {
		GType geary_app_draft_manager_type_id;
		geary_app_draft_manager_type_id = geary_app_draft_manager_get_type_once ();
		g_once_init_leave (&geary_app_draft_manager_type_id__once, geary_app_draft_manager_type_id);
	}
	return geary_app_draft_manager_type_id__once;
}

static void
_vala_geary_app_draft_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyAppDraftManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_DRAFT_MANAGER, GearyAppDraftManager);
	switch (property_id) {
		case GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY:
		g_value_set_boolean (value, geary_app_draft_manager_get_is_open (self));
		break;
		case GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY:
		g_value_set_enum (value, geary_app_draft_manager_get_draft_state (self));
		break;
		case GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY:
		g_value_set_object (value, geary_app_draft_manager_get_current_draft_id (self));
		break;
		case GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY:
		g_value_set_int (value, geary_app_draft_manager_get_versions_saved (self));
		break;
		case GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY:
		g_value_set_int (value, geary_app_draft_manager_get_versions_dropped (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_draft_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyAppDraftManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_DRAFT_MANAGER, GearyAppDraftManager);
	switch (property_id) {
		case GEARY_APP_DRAFT_MANAGER_IS_OPEN_PROPERTY:
		geary_app_draft_manager_set_is_open (self, g_value_get_boolean (value));
		break;
		case GEARY_APP_DRAFT_MANAGER_DRAFT_STATE_PROPERTY:
		geary_app_draft_manager_set_draft_state (self, g_value_get_enum (value));
		break;
		case GEARY_APP_DRAFT_MANAGER_CURRENT_DRAFT_ID_PROPERTY:
		geary_app_draft_manager_set_current_draft_id (self, g_value_get_object (value));
		break;
		case GEARY_APP_DRAFT_MANAGER_VERSIONS_SAVED_PROPERTY:
		geary_app_draft_manager_set_versions_saved (self, g_value_get_int (value));
		break;
		case GEARY_APP_DRAFT_MANAGER_VERSIONS_DROPPED_PROPERTY:
		geary_app_draft_manager_set_versions_dropped (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

