/* imap-engine-email-prefetcher.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine-email-prefetcher.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_DELAY_SEC 1
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FIELDS GEARY_EMAIL_FIELD_PROPERTIES
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FLAGS (GEARY_IMAP_DB_FOLDER_LIST_FLAGS_ONLY_INCOMPLETE | GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK)
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_FIELDS GEARY_EMAIL_FIELD_ALL
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_CHUNK_BYTES (512 * 1024)

#define GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER (geary_imap_engine_email_prefetcher_get_type ())
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcher))
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcherClass))
#define GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER))
#define GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER))
#define GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcherClass))

typedef struct _GearyImapEngineEmailPrefetcher GearyImapEngineEmailPrefetcher;
typedef struct _GearyImapEngineEmailPrefetcherClass GearyImapEngineEmailPrefetcherClass;
typedef struct _GearyImapEngineEmailPrefetcherPrivate GearyImapEngineEmailPrefetcherPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_0_PROPERTY,
	GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY,
	GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_email_prefetcher_properties[GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_NUM_PROPERTIES];
typedef enum  {
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE = 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK = 1 << 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE = 1 << 1,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDING_ID = 1 << 2,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST = 1 << 3,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_ONLY_INCOMPLETE = 1 << 4
} GearyImapDBFolderListFlags;

#define GEARY_IMAP_DB_FOLDER_TYPE_LIST_FLAGS (geary_imap_db_folder_list_flags_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData;
typedef struct _GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData;
typedef struct _GearyImapEngineEmailPrefetcherDoPrefetchAsyncData GearyImapEngineEmailPrefetcherDoPrefetchAsyncData;
typedef struct _GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData;
typedef struct _GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData;

struct _GearyImapEngineEmailPrefetcher {
	GearyBaseObject parent_instance;
	GearyImapEngineEmailPrefetcherPrivate * priv;
};

struct _GearyImapEngineEmailPrefetcherClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyImapEngineEmailPrefetcherPrivate {
	GearyNonblockingCountingSemaphore* _active_sem;
	GearyImapEngineMinimalFolder* folder;
	GearyNonblockingMutex* mutex;
	GeeTreeSet* prefetch_emails;
	GearyTimeoutManager* prefetch_timer;
	GCancellable* cancellable;
};

struct _GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmailPrefetcher* self;
	GeeList* list;
	GeeList* _tmp0_;
	GearyImapEngineMinimalFolder* _tmp1_;
	GearyImapDBFolder* _tmp2_;
	GearyImapDBFolder* _tmp3_;
	GCancellable* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GError* err;
	GearyImapEngineMinimalFolder* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GearyImapEngineMinimalFolder* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GeeList* _tmp20_;
	GearyNonblockingCountingSemaphore* _tmp21_;
	GError* _inner_error0_;
};

struct _GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmailPrefetcher* self;
	GeeCollection* ids;
	GeeList* list;
	GeeList* _tmp0_;
	GearyImapEngineMinimalFolder* _tmp1_;
	GearyImapDBFolder* _tmp2_;
	GearyImapDBFolder* _tmp3_;
	GCancellable* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	GError* err;
	GearyImapEngineMinimalFolder* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GearyImapEngineMinimalFolder* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GeeList* _tmp20_;
	GearyNonblockingCountingSemaphore* _tmp21_;
	GError* _inner_error0_;
};

struct _GearyImapEngineEmailPrefetcherDoPrefetchAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmailPrefetcher* self;
	gint token;
	gint _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GCancellable* _tmp2_;
	GError* err;
	GError* _tmp3_;
	GearyImapEngineMinimalFolder* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GearyNonblockingCountingSemaphore* _tmp9_;
	GearyNonblockingMutex* _tmp10_;
	GError* release_err;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmailPrefetcher* self;
	GeeTreeSet* emails;
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp1_;
	GeeTreeSet* _tmp2_;
	GeeTreeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GearyImapEngineMinimalFolder* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeTreeSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeHashSet* chunk;
	GeeHashSet* _tmp12_;
	GeeHashSet* blanks;
	GeeHashSet* _tmp13_;
	gint64 chunk_bytes;
	gint count;
	GeeTreeSet* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GearyEmail* email;
	GeeTreeSet* _tmp17_;
	gpointer _tmp18_;
	GearyEmail* _tmp19_;
	GearyEmailProperties* _tmp20_;
	GearyEmailProperties* _tmp21_;
	GeeTreeSet* _tmp22_;
	GearyEmail* _tmp23_;
	GeeHashSet* _tmp24_;
	GearyEmail* _tmp25_;
	GearyEmailIdentifier* _tmp26_;
	GearyEmailIdentifier* _tmp27_;
	gboolean _tmp28_;
	GearyEmail* _tmp29_;
	GearyEmailProperties* _tmp30_;
	GearyEmailProperties* _tmp31_;
	gint64 _tmp32_;
	gint64 _tmp33_;
	GeeHashSet* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	GeeTreeSet* _tmp37_;
	GearyEmail* _tmp38_;
	GeeHashSet* _tmp39_;
	GearyEmail* _tmp40_;
	GearyEmailIdentifier* _tmp41_;
	GearyEmailIdentifier* _tmp42_;
	GearyEmail* _tmp43_;
	GearyEmailProperties* _tmp44_;
	GearyEmailProperties* _tmp45_;
	gint64 _tmp46_;
	gint64 _tmp47_;
	gint _tmp48_;
	gboolean keep_going;
	GeeHashSet* _tmp49_;
	GeeHashSet* _tmp50_;
	GeeHashSet* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	GeeHashSet* _tmp54_;
	GeeIterator* _id_it;
	GeeHashSet* _tmp55_;
	GeeIterator* _tmp56_;
	GeeIterator* _tmp57_;
	GearyEmailIdentifier* id;
	GeeIterator* _tmp58_;
	gpointer _tmp59_;
	GearyEmailIdentifier* _tmp60_;
	GeeCollection* _tmp61_;
	GeeCollection* _tmp62_;
	GearyImapEngineMinimalFolder* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
};

struct _GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineEmailPrefetcher* self;
	GeeCollection* ids;
	gint64 chunk_bytes;
	gboolean result;
	GearyImapEngineMinimalFolder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GearyImapEngineMinimalFolder* _tmp7_;
	GCancellable* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	GError* err;
	gboolean _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GearyImapEngineMinimalFolder* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_;
};

static gint GearyImapEngineEmailPrefetcher_private_offset;
static gpointer geary_imap_engine_email_prefetcher_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_email_prefetcher_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_folder_list_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyNonblockingCountingSemaphore* geary_imap_engine_email_prefetcher_get_active_sem (GearyImapEngineEmailPrefetcher* self);
static void geary_imap_engine_email_prefetcher_set_active_sem (GearyImapEngineEmailPrefetcher* self,
                                                        GearyNonblockingCountingSemaphore* value);
static gint _geary_email_compare_recv_date_descending_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
VALA_EXTERN GearyImapEngineEmailPrefetcher* geary_imap_engine_email_prefetcher_new (GearyImapEngineMinimalFolder* folder,
                                                                        gint start_delay_sec);
VALA_EXTERN GearyImapEngineEmailPrefetcher* geary_imap_engine_email_prefetcher_construct (GType object_type,
                                                                              GearyImapEngineMinimalFolder* folder,
                                                                              gint start_delay_sec);
static void __lambda109_ (GearyImapEngineEmailPrefetcher* self);
static void geary_imap_engine_email_prefetcher_do_prefetch_async (GearyImapEngineEmailPrefetcher* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_finish (GearyImapEngineEmailPrefetcher* self,
                                                            GAsyncResult* _res_);
static void ___lambda109__geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                       gpointer self);
VALA_EXTERN void geary_imap_engine_email_prefetcher_open (GearyImapEngineEmailPrefetcher* self);
static void geary_imap_engine_email_prefetcher_on_local_expansion (GearyImapEngineEmailPrefetcher* self,
                                                            GeeCollection* ids);
static void _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_appended (GearyFolder* _sender,
                                                                                                 GeeCollection* ids,
                                                                                                 gpointer self);
static void _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_inserted (GearyFolder* _sender,
                                                                                                 GeeCollection* ids,
                                                                                                 gpointer self);
static void geary_imap_engine_email_prefetcher_do_prepare_all_local_async (GearyImapEngineEmailPrefetcher* self,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prepare_all_local_finish (GearyImapEngineEmailPrefetcher* self,
                                                                     GAsyncResult* _res_);
VALA_EXTERN void geary_imap_engine_email_prefetcher_close (GearyImapEngineEmailPrefetcher* self);
static void geary_imap_engine_email_prefetcher_do_prepare_new_async (GearyImapEngineEmailPrefetcher* self,
                                                              GeeCollection* ids,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prepare_new_finish (GearyImapEngineEmailPrefetcher* self,
                                                               GAsyncResult* _res_);
static void geary_imap_engine_email_prefetcher_schedule_prefetch (GearyImapEngineEmailPrefetcher* self,
                                                           GeeCollection* emails);
static void geary_imap_engine_email_prefetcher_do_prepare_all_local_async_data_free (gpointer _data);
static gboolean geary_imap_engine_email_prefetcher_do_prepare_all_local_async_co (GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_list_email_by_id_async (GearyImapDBFolder* self,
                                                  GearyImapDBEmailIdentifier* initial_id,
                                                  gint count,
                                                  GearyEmailField required_fields,
                                                  GearyImapDBFolderListFlags flags,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN GeeList* geary_imap_db_folder_list_email_by_id_finish (GearyImapDBFolder* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void geary_imap_engine_email_prefetcher_do_prepare_all_local_async_ready (GObject* source_object,
                                                                          GAsyncResult* _res_,
                                                                          gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prepare_new_async_data_free (gpointer _data);
static gboolean geary_imap_engine_email_prefetcher_do_prepare_new_async_co (GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_);
VALA_EXTERN void geary_imap_db_folder_list_email_by_sparse_id_async (GearyImapDBFolder* self,
                                                         GeeCollection* ids,
                                                         GearyEmailField required_fields,
                                                         GearyImapDBFolderListFlags flags,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN GeeList* geary_imap_db_folder_list_email_by_sparse_id_finish (GearyImapDBFolder* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void geary_imap_engine_email_prefetcher_do_prepare_new_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_async_data_free (gpointer _data);
static gboolean geary_imap_engine_email_prefetcher_do_prefetch_async_co (GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_async_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_batch_async (GearyImapEngineEmailPrefetcher* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_batch_finish (GearyImapEngineEmailPrefetcher* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void geary_imap_engine_email_prefetcher_do_prefetch_batch_async_data_free (gpointer _data);
static gboolean geary_imap_engine_email_prefetcher_do_prefetch_batch_async_co (GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_email_async (GearyImapEngineEmailPrefetcher* self,
                                                                 GeeCollection* ids,
                                                                 gint64 chunk_bytes,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean geary_imap_engine_email_prefetcher_do_prefetch_email_finish (GearyImapEngineEmailPrefetcher* self,
                                                                      GAsyncResult* _res_);
static void geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_email_async_data_free (gpointer _data);
static gboolean geary_imap_engine_email_prefetcher_do_prefetch_email_async_co (GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_);
static void geary_imap_engine_email_prefetcher_do_prefetch_email_async_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void geary_imap_engine_email_prefetcher_finalize (GObject * obj);
static GType geary_imap_engine_email_prefetcher_get_type_once (void);
static void _vala_geary_imap_engine_email_prefetcher_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_imap_engine_email_prefetcher_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
geary_imap_engine_email_prefetcher_get_instance_private (GearyImapEngineEmailPrefetcher* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineEmailPrefetcher_private_offset);
}

GearyNonblockingCountingSemaphore*
geary_imap_engine_email_prefetcher_get_active_sem (GearyImapEngineEmailPrefetcher* self)
{
	GearyNonblockingCountingSemaphore* result;
	GearyNonblockingCountingSemaphore* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self), NULL);
	_tmp0_ = self->priv->_active_sem;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_engine_email_prefetcher_set_active_sem (GearyImapEngineEmailPrefetcher* self,
                                                   GearyNonblockingCountingSemaphore* value)
{
	GearyNonblockingCountingSemaphore* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	old_value = geary_imap_engine_email_prefetcher_get_active_sem (self);
	if (old_value != value) {
		GearyNonblockingCountingSemaphore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active_sem);
		self->priv->_active_sem = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_email_prefetcher_properties[GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY]);
	}
}

static gint
_geary_email_compare_recv_date_descending_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = geary_email_compare_recv_date_descending ((GearyEmail*) a, (GearyEmail*) b);
	return result;
}

static void
__lambda109_ (GearyImapEngineEmailPrefetcher* self)
{
	geary_imap_engine_email_prefetcher_do_prefetch_async (self, NULL, NULL);
}

static void
___lambda109__geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                  gpointer self)
{
	__lambda109_ ((GearyImapEngineEmailPrefetcher*) self);
}

GearyImapEngineEmailPrefetcher*
geary_imap_engine_email_prefetcher_construct (GType object_type,
                                              GearyImapEngineMinimalFolder* folder,
                                              gint start_delay_sec)
{
	GearyImapEngineEmailPrefetcher * self = NULL;
	GearyTimeoutManager* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (folder), NULL);
	self = (GearyImapEngineEmailPrefetcher*) geary_base_object_construct (object_type);
	self->priv->folder = folder;
	if (start_delay_sec <= 0) {
		start_delay_sec = GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_DELAY_SEC;
	}
	_tmp0_ = geary_timeout_manager_new_seconds ((guint) start_delay_sec, ___lambda109__geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->prefetch_timer);
	self->priv->prefetch_timer = _tmp0_;
	return self;
}

GearyImapEngineEmailPrefetcher*
geary_imap_engine_email_prefetcher_new (GearyImapEngineMinimalFolder* folder,
                                        gint start_delay_sec)
{
	return geary_imap_engine_email_prefetcher_construct (GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, folder, start_delay_sec);
}

static void
_geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_appended (GearyFolder* _sender,
                                                                                            GeeCollection* ids,
                                                                                            gpointer self)
{
	geary_imap_engine_email_prefetcher_on_local_expansion ((GearyImapEngineEmailPrefetcher*) self, ids);
}

static void
_geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_inserted (GearyFolder* _sender,
                                                                                            GeeCollection* ids,
                                                                                            gpointer self)
{
	geary_imap_engine_email_prefetcher_on_local_expansion ((GearyImapEngineEmailPrefetcher*) self, ids);
}

void
geary_imap_engine_email_prefetcher_open (GearyImapEngineEmailPrefetcher* self)
{
	GCancellable* _tmp0_;
	GearyImapEngineMinimalFolder* _tmp1_;
	GearyImapEngineMinimalFolder* _tmp2_;
	GearyNonblockingCountingSemaphore* _tmp3_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = self->priv->folder;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_FOLDER, GearyFolder), "email-locally-appended", (GCallback) _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_appended, self, 0);
	_tmp2_ = self->priv->folder;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_TYPE_FOLDER, GearyFolder), "email-locally-inserted", (GCallback) _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_inserted, self, 0);
	_tmp3_ = self->priv->_active_sem;
	geary_nonblocking_counting_semaphore_acquire (_tmp3_);
	geary_imap_engine_email_prefetcher_do_prepare_all_local_async (self, NULL, NULL);
}

void
geary_imap_engine_email_prefetcher_close (GearyImapEngineEmailPrefetcher* self)
{
	GCancellable* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GearyImapEngineMinimalFolder* _tmp6_;
	guint _tmp7_;
	GearyImapEngineMinimalFolder* _tmp8_;
	guint _tmp9_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->prefetch_timer;
	_tmp2_ = geary_timeout_manager_get_is_running (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GearyTimeoutManager* _tmp4_;
		GearyNonblockingCountingSemaphore* _tmp5_;
		_tmp4_ = self->priv->prefetch_timer;
		geary_timeout_manager_reset (_tmp4_);
		_tmp5_ = self->priv->_active_sem;
		geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	}
	_tmp6_ = self->priv->folder;
	g_signal_parse_name ("email-locally-appended", GEARY_TYPE_FOLDER, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_TYPE_FOLDER, GearyFolder), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_appended, self);
	_tmp8_ = self->priv->folder;
	g_signal_parse_name ("email-locally-inserted", GEARY_TYPE_FOLDER, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEARY_TYPE_FOLDER, GearyFolder), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _geary_imap_engine_email_prefetcher_on_local_expansion_geary_folder_email_locally_inserted, self);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
}

static void
geary_imap_engine_email_prefetcher_on_local_expansion (GearyImapEngineEmailPrefetcher* self,
                                                       GeeCollection* ids)
{
	GearyNonblockingCountingSemaphore* _tmp0_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->_active_sem;
	geary_nonblocking_counting_semaphore_acquire (_tmp0_);
	geary_imap_engine_email_prefetcher_do_prepare_new_async (self, ids, NULL, NULL);
}

static void
geary_imap_engine_email_prefetcher_schedule_prefetch (GearyImapEngineEmailPrefetcher* self,
                                                      GeeCollection* emails)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	g_return_if_fail ((emails == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	if (emails != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_collection_get_size (emails);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeTreeSet* _tmp3_;
		GearyTimeoutManager* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GearyTimeoutManager* _tmp8_;
		_tmp3_ = self->priv->prefetch_emails;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), emails);
		_tmp4_ = self->priv->prefetch_timer;
		_tmp5_ = geary_timeout_manager_get_is_running (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!_tmp6_) {
			GearyNonblockingCountingSemaphore* _tmp7_;
			_tmp7_ = self->priv->_active_sem;
			geary_nonblocking_counting_semaphore_acquire (_tmp7_);
		}
		_tmp8_ = self->priv->prefetch_timer;
		geary_timeout_manager_start (_tmp8_);
	}
}

static void
geary_imap_engine_email_prefetcher_do_prepare_all_local_async_data_free (gpointer _data)
{
	GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData, _data_);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_all_local_async (GearyImapEngineEmailPrefetcher* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_;
	GearyImapEngineEmailPrefetcher* _tmp0_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	_data_ = g_slice_new0 (GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_email_prefetcher_do_prepare_all_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_email_prefetcher_do_prepare_all_local_async_co (_data_);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_all_local_finish (GearyImapEngineEmailPrefetcher* self,
                                                                GAsyncResult* _res_)
{
	GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_all_local_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_email_prefetcher_do_prepare_all_local_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prepare_all_local_async_co (GearyImapEngineEmailPrefetcherDoPrepareAllLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->list = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->folder;
		_data_->_tmp2_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_imap_db_folder_list_email_by_id_async (_data_->_tmp3_, NULL, G_MAXINT, GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FIELDS, GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FLAGS, _data_->_tmp4_, geary_imap_engine_email_prefetcher_do_prepare_all_local_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = geary_imap_db_folder_list_email_by_id_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->list);
		_data_->list = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->folder;
		_data_->_tmp8_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("imap-engine-email-prefetcher.vala:110: %s: Error listing email on open" \
": %s", _data_->_tmp9_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->list;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->list;
		_data_->_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = _data_->_tmp16_;
	} else {
		_data_->_tmp12_ = 0;
	}
	_data_->_tmp17_ = _data_->self->priv->folder;
	_data_->_tmp18_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp19_ = _data_->_tmp18_;
	g_debug ("imap-engine-email-prefetcher.vala:114: %s: Scheduling %d messages on o" \
"pen for prefetching", _data_->_tmp19_, _data_->_tmp12_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp20_ = _data_->list;
	geary_imap_engine_email_prefetcher_schedule_prefetch (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp21_ = _data_->self->priv->_active_sem;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	_g_object_unref0 (_data_->list);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_email_prefetcher_do_prepare_new_async_data_free (gpointer _data)
{
	GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData, _data_);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_new_async (GearyImapEngineEmailPrefetcher* self,
                                                         GeeCollection* ids,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_;
	GearyImapEngineEmailPrefetcher* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_email_prefetcher_do_prepare_new_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ids);
	_g_object_unref0 (_data_->ids);
	_data_->ids = _tmp1_;
	geary_imap_engine_email_prefetcher_do_prepare_new_async_co (_data_);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_new_finish (GearyImapEngineEmailPrefetcher* self,
                                                          GAsyncResult* _res_)
{
	GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_engine_email_prefetcher_do_prepare_new_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_email_prefetcher_do_prepare_new_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prepare_new_async_co (GearyImapEngineEmailPrefetcherDoPrepareNewAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->list = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->folder;
		_data_->_tmp2_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_imap_db_folder_list_email_by_sparse_id_async (_data_->_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_data_->ids, GEE_TYPE_COLLECTION, GeeCollection), GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FIELDS, GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREPARE_FLAGS, _data_->_tmp4_, geary_imap_engine_email_prefetcher_do_prepare_new_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = geary_imap_db_folder_list_email_by_sparse_id_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->list);
		_data_->list = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->folder;
		_data_->_tmp8_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_warning ("imap-engine-email-prefetcher.vala:132: %s: Error listing email on open" \
": %s", _data_->_tmp9_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->list;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->list;
		_data_->_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = _data_->_tmp16_;
	} else {
		_data_->_tmp12_ = 0;
	}
	_data_->_tmp17_ = _data_->self->priv->folder;
	_data_->_tmp18_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp19_ = _data_->_tmp18_;
	g_debug ("imap-engine-email-prefetcher.vala:136: %s: Scheduling %d new emails fo" \
"r prefetching", _data_->_tmp19_, _data_->_tmp12_);
	_g_free0 (_data_->_tmp19_);
	_data_->_tmp20_ = _data_->list;
	geary_imap_engine_email_prefetcher_schedule_prefetch (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp21_ = _data_->self->priv->_active_sem;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	_g_object_unref0 (_data_->list);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_async_data_free (gpointer _data)
{
	GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmailPrefetcherDoPrefetchAsyncData, _data_);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_async (GearyImapEngineEmailPrefetcher* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_;
	GearyImapEngineEmailPrefetcher* _tmp0_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	_data_ = g_slice_new0 (GearyImapEngineEmailPrefetcherDoPrefetchAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_email_prefetcher_do_prefetch_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_email_prefetcher_do_prefetch_async_co (_data_);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_finish (GearyImapEngineEmailPrefetcher* self,
                                                       GAsyncResult* _res_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_email_prefetcher_do_prefetch_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prefetch_async_co (GearyImapEngineEmailPrefetcherDoPrefetchAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->token = GEARY_NONBLOCKING_MUTEX_INVALID_TOKEN;
	{
		_data_->_tmp1_ = _data_->self->priv->mutex;
		_data_->_tmp2_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_nonblocking_mutex_claim_async (_data_->_tmp1_, _data_->_tmp2_, geary_imap_engine_email_prefetcher_do_prefetch_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = geary_nonblocking_mutex_claim_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->token = _data_->_tmp0_;
		_data_->_state_ = 2;
		geary_imap_engine_email_prefetcher_do_prefetch_batch_async (_data_->self, geary_imap_engine_email_prefetcher_do_prefetch_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_imap_engine_email_prefetcher_do_prefetch_batch_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->err;
		if (!g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp4_ = _data_->self->priv->folder;
			_data_->_tmp5_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = _data_->err;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_debug ("imap-engine-email-prefetcher.vala:149: Error while prefetching emails " \
"for %s: %s", _data_->_tmp6_, _data_->_tmp8_);
			_g_free0 (_data_->_tmp6_);
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->self->priv->_active_sem;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	if (_data_->token != GEARY_NONBLOCKING_MUTEX_INVALID_TOKEN) {
		{
			_data_->_tmp10_ = _data_->self->priv->mutex;
			geary_nonblocking_mutex_release (_data_->_tmp10_, &_data_->token, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->release_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp11_ = _data_->release_err;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			g_debug ("imap-engine-email-prefetcher.vala:159: Unable to release email prefetc" \
"her mutex: %s", _data_->_tmp12_);
			_g_error_free0 (_data_->release_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_batch_async_data_free (gpointer _data)
{
	GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData, _data_);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_batch_async (GearyImapEngineEmailPrefetcher* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_;
	GearyImapEngineEmailPrefetcher* _tmp0_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	_data_ = g_slice_new0 (GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_email_prefetcher_do_prefetch_batch_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_email_prefetcher_do_prefetch_batch_async_co (_data_);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_batch_finish (GearyImapEngineEmailPrefetcher* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_email_prefetcher_do_prefetch_batch_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prefetch_batch_async_co (GearyImapEngineEmailPrefetcherDoPrefetchBatchAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->prefetch_emails;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->emails = _data_->_tmp1_;
	_data_->_tmp2_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_recv_date_descending_gcompare_data_func, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->prefetch_emails);
	_data_->self->priv->prefetch_emails = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->emails;
	_data_->_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == 0) {
		_g_object_unref0 (_data_->emails);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->folder;
	_data_->_tmp7_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->emails;
	_data_->_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp11_ = _data_->_tmp10_;
	g_debug ("imap-engine-email-prefetcher.vala:172: do_prefetch_batch_async %s star" \
"t_total=%d", _data_->_tmp8_, _data_->_tmp11_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp12_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->chunk = _data_->_tmp12_;
	_data_->_tmp13_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->blanks = _data_->_tmp13_;
	_data_->chunk_bytes = (gint64) 0;
	_data_->count = 0;
	while (TRUE) {
		_data_->_tmp14_ = _data_->emails;
		_data_->_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_tmp16_ = _data_->_tmp15_;
		if (!(_data_->_tmp16_ > 0)) {
			break;
		}
		_data_->_tmp17_ = _data_->emails;
		_data_->_tmp18_ = gee_abstract_sorted_set_first (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_ABSTRACT_SORTED_SET, GeeAbstractSortedSet));
		_data_->email = (GearyEmail*) _data_->_tmp18_;
		_data_->_tmp19_ = _data_->email;
		_data_->_tmp20_ = geary_email_get_properties (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		if (_data_->_tmp21_ == NULL) {
			_data_->_tmp22_ = _data_->emails;
			_data_->_tmp23_ = _data_->email;
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp23_);
			_data_->_tmp24_ = _data_->blanks;
			_data_->_tmp25_ = _data_->email;
			_data_->_tmp26_ = geary_email_get_id (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp27_);
		} else {
			_data_->_tmp29_ = _data_->email;
			_data_->_tmp30_ = geary_email_get_properties (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = geary_email_properties_get_total_bytes (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			if (_data_->_tmp33_ < ((gint64) GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_CHUNK_BYTES)) {
				_data_->_tmp28_ = TRUE;
			} else {
				_data_->_tmp34_ = _data_->chunk;
				_data_->_tmp35_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_data_->_tmp36_ = _data_->_tmp35_;
				_data_->_tmp28_ = _data_->_tmp36_ == 0;
			}
			if (_data_->_tmp28_) {
				_data_->_tmp37_ = _data_->emails;
				_data_->_tmp38_ = _data_->email;
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp38_);
				_data_->_tmp39_ = _data_->chunk;
				_data_->_tmp40_ = _data_->email;
				_data_->_tmp41_ = geary_email_get_id (_data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp42_);
				_data_->_tmp43_ = _data_->email;
				_data_->_tmp44_ = geary_email_get_properties (_data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				_data_->_tmp46_ = geary_email_properties_get_total_bytes (_data_->_tmp45_);
				_data_->_tmp47_ = _data_->_tmp46_;
				_data_->chunk_bytes += _data_->_tmp47_;
				_data_->_tmp48_ = _data_->count;
				_data_->count = _data_->_tmp48_ + 1;
				if (_data_->chunk_bytes < ((gint64) GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_CHUNK_BYTES)) {
					_g_object_unref0 (_data_->email);
					continue;
				}
			}
		}
		_data_->_tmp49_ = _data_->chunk;
		_data_->_state_ = 1;
		geary_imap_engine_email_prefetcher_do_prefetch_email_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), _data_->chunk_bytes, geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->keep_going = geary_imap_engine_email_prefetcher_do_prefetch_email_finish (_data_->self, _data_->_res_);
		_data_->_tmp50_ = _data_->chunk;
		gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp50_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->chunk_bytes = (gint64) 0;
		if (!_data_->keep_going) {
			_g_object_unref0 (_data_->email);
			break;
		}
		_data_->_state_ = 2;
		geary_scheduler_sleep_ms_async ((guint) 200, geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_scheduler_sleep_ms_finish (_data_->_res_);
		_g_object_unref0 (_data_->email);
	}
	_data_->_tmp51_ = _data_->chunk;
	_data_->_tmp52_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp51_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_data_->_tmp53_ = _data_->_tmp52_;
	if (_data_->_tmp53_ > 0) {
		_data_->_tmp54_ = _data_->chunk;
		_data_->_state_ = 3;
		geary_imap_engine_email_prefetcher_do_prefetch_email_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, GEE_TYPE_COLLECTION, GeeCollection), _data_->chunk_bytes, geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready, _data_);
		return FALSE;
		_state_3:
		geary_imap_engine_email_prefetcher_do_prefetch_email_finish (_data_->self, _data_->_res_);
	}
	{
		_data_->_tmp55_ = _data_->blanks;
		_data_->_tmp56_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp55_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_data_->_id_it = _data_->_tmp56_;
		while (TRUE) {
			_data_->_tmp57_ = _data_->_id_it;
			if (!gee_iterator_next (_data_->_tmp57_)) {
				break;
			}
			_data_->_tmp58_ = _data_->_id_it;
			_data_->_tmp59_ = gee_iterator_get (_data_->_tmp58_);
			_data_->id = (GearyEmailIdentifier*) _data_->_tmp59_;
			_data_->_tmp60_ = _data_->id;
			_data_->_tmp61_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp60_);
			_data_->_tmp62_ = _data_->_tmp61_;
			_data_->_state_ = 4;
			geary_imap_engine_email_prefetcher_do_prefetch_email_async (_data_->self, _data_->_tmp62_, (gint64) -1, geary_imap_engine_email_prefetcher_do_prefetch_batch_async_ready, _data_);
			return FALSE;
			_state_4:
			geary_imap_engine_email_prefetcher_do_prefetch_email_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->_tmp62_);
			_g_object_unref0 (_data_->id);
		}
		_g_object_unref0 (_data_->_id_it);
	}
	_data_->_tmp63_ = _data_->self->priv->folder;
	_data_->_tmp64_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp63_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp65_ = _data_->_tmp64_;
	g_debug ("imap-engine-email-prefetcher.vala:238: finished do_prefetch_batch_asyn" \
"c %s end_total=%d", _data_->_tmp65_, _data_->count);
	_g_free0 (_data_->_tmp65_);
	_g_object_unref0 (_data_->blanks);
	_g_object_unref0 (_data_->chunk);
	_g_object_unref0 (_data_->emails);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_email_async_data_free (gpointer _data)
{
	GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData, _data_);
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_email_async (GearyImapEngineEmailPrefetcher* self,
                                                            GeeCollection* ids,
                                                            gint64 chunk_bytes,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_;
	GearyImapEngineEmailPrefetcher* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_EMAIL_PREFETCHER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_email_prefetcher_do_prefetch_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (ids);
	_g_object_unref0 (_data_->ids);
	_data_->ids = _tmp1_;
	_data_->chunk_bytes = chunk_bytes;
	geary_imap_engine_email_prefetcher_do_prefetch_email_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prefetch_email_finish (GearyImapEngineEmailPrefetcher* self,
                                                             GAsyncResult* _res_)
{
	gboolean result;
	GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
geary_imap_engine_email_prefetcher_do_prefetch_email_async_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_email_prefetcher_do_prefetch_email_async_co (_data_);
}

static gboolean
geary_imap_engine_email_prefetcher_do_prefetch_email_async_co (GearyImapEngineEmailPrefetcherDoPrefetchEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->folder;
	_data_->_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gee_collection_get_size (_data_->ids);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->chunk_bytes);
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("imap-engine-email-prefetcher.vala:243: do_prefetch_email_async: %s pre" \
"fetching %d emails (%sb)", _data_->_tmp2_, _data_->_tmp4_, _data_->_tmp6_);
	_g_free0 (_data_->_tmp6_);
	_g_free0 (_data_->_tmp2_);
	{
		_data_->_tmp7_ = _data_->self->priv->folder;
		_data_->_tmp8_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_folder_list_email_by_sparse_id_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_TYPE_FOLDER, GearyFolder), _data_->ids, GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_PREFETCH_FIELDS, GEARY_FOLDER_LIST_FLAGS_NONE, _data_->_tmp8_, geary_imap_engine_email_prefetcher_do_prefetch_email_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = geary_folder_list_email_by_sparse_id_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp10_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->err;
		if (!g_error_matches (_data_->_tmp12_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp13_ = _data_->err;
			_data_->_tmp11_ = !g_error_matches (_data_->_tmp13_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_OPEN_REQUIRED);
		} else {
			_data_->_tmp11_ = FALSE;
		}
		if (_data_->_tmp11_) {
			_data_->_tmp14_ = gee_collection_get_size (_data_->ids);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->self->priv->folder;
			_data_->_tmp17_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->err;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_debug ("imap-engine-email-prefetcher.vala:251: Error prefetching %d emails for" \
" %s: %s", _data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
		} else {
			_data_->result = FALSE;
			_g_error_free0 (_data_->err);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_email_prefetcher_class_init (GearyImapEngineEmailPrefetcherClass * klass,
                                               gpointer klass_data)
{
	geary_imap_engine_email_prefetcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineEmailPrefetcher_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_engine_email_prefetcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_engine_email_prefetcher_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_email_prefetcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY, geary_imap_engine_email_prefetcher_properties[GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY] = g_param_spec_object ("active-sem", "active-sem", "active-sem", GEARY_NONBLOCKING_TYPE_COUNTING_SEMAPHORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_engine_email_prefetcher_instance_init (GearyImapEngineEmailPrefetcher * self,
                                                  gpointer klass)
{
	GearyNonblockingCountingSemaphore* _tmp0_;
	GearyNonblockingMutex* _tmp1_;
	GeeTreeSet* _tmp2_;
	self->priv = geary_imap_engine_email_prefetcher_get_instance_private (self);
	_tmp0_ = geary_nonblocking_counting_semaphore_new (NULL);
	self->priv->_active_sem = _tmp0_;
	_tmp1_ = geary_nonblocking_mutex_new ();
	self->priv->mutex = _tmp1_;
	_tmp2_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_recv_date_descending_gcompare_data_func, NULL, NULL);
	self->priv->prefetch_emails = _tmp2_;
	self->priv->cancellable = NULL;
}

static void
geary_imap_engine_email_prefetcher_finalize (GObject * obj)
{
	GearyImapEngineEmailPrefetcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcher);
	_g_object_unref0 (self->priv->_active_sem);
	_g_object_unref0 (self->priv->mutex);
	_g_object_unref0 (self->priv->prefetch_emails);
	_g_object_unref0 (self->priv->prefetch_timer);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (geary_imap_engine_email_prefetcher_parent_class)->finalize (obj);
}

/**
 * Ensures all email in a folder's vector has been downloaded.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_engine_email_prefetcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineEmailPrefetcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_email_prefetcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineEmailPrefetcher), 0, (GInstanceInitFunc) geary_imap_engine_email_prefetcher_instance_init, NULL };
	GType geary_imap_engine_email_prefetcher_type_id;
	geary_imap_engine_email_prefetcher_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapEngineEmailPrefetcher", &g_define_type_info, 0);
	GearyImapEngineEmailPrefetcher_private_offset = g_type_add_instance_private (geary_imap_engine_email_prefetcher_type_id, sizeof (GearyImapEngineEmailPrefetcherPrivate));
	return geary_imap_engine_email_prefetcher_type_id;
}

GType
geary_imap_engine_email_prefetcher_get_type (void)
{
	static gsize geary_imap_engine_email_prefetcher_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_email_prefetcher_type_id__once)) {
		GType geary_imap_engine_email_prefetcher_type_id;
		geary_imap_engine_email_prefetcher_type_id = geary_imap_engine_email_prefetcher_get_type_once ();
		g_once_init_leave (&geary_imap_engine_email_prefetcher_type_id__once, geary_imap_engine_email_prefetcher_type_id);
	}
	return geary_imap_engine_email_prefetcher_type_id__once;
}

static void
_vala_geary_imap_engine_email_prefetcher_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineEmailPrefetcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcher);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY:
		g_value_set_object (value, geary_imap_engine_email_prefetcher_get_active_sem (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_engine_email_prefetcher_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearyImapEngineEmailPrefetcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_EMAIL_PREFETCHER, GearyImapEngineEmailPrefetcher);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_EMAIL_PREFETCHER_ACTIVE_SEM_PROPERTY:
		geary_imap_engine_email_prefetcher_set_active_sem (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

