/* imap-search-criterion.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-search-criterion.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_SEARCH_CRITERION_0_PROPERTY,
	GEARY_IMAP_SEARCH_CRITERION_NUM_PROPERTIES
};
static GParamSpec* geary_imap_search_criterion_properties[GEARY_IMAP_SEARCH_CRITERION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapSearchCriterionPrivate {
	GeeList* parameters;
};

static gint GearyImapSearchCriterion_private_offset;
static gpointer geary_imap_search_criterion_parent_class = NULL;

static GearyImapParameter* geary_imap_search_criterion_prep_name (const gchar* name);
static void geary_imap_search_criterion_finalize (GObject * obj);
static GType geary_imap_search_criterion_get_type_once (void);

static inline gpointer
geary_imap_search_criterion_get_instance_private (GearyImapSearchCriterion* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapSearchCriterion_private_offset);
}

/**
     * Create a single simple criterion for the {@link SearchCommand}.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_construct (GType object_type,
                                       GearyImapParameter* parameter)
{
	GearyImapSearchCriterion * self = NULL;
	g_return_val_if_fail ((parameter == NULL) || GEARY_IMAP_IS_PARAMETER (parameter), NULL);
	self = (GearyImapSearchCriterion*) geary_base_object_construct (object_type);
	if (parameter != NULL) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->parameters;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), parameter);
	}
	return self;
}

GearyImapSearchCriterion*
geary_imap_search_criterion_new (GearyImapParameter* parameter)
{
	return geary_imap_search_criterion_construct (GEARY_IMAP_TYPE_SEARCH_CRITERION, parameter);
}

/**
     * Creates a simple search criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_construct_simple (GType object_type,
                                              const gchar* name)
{
	GearyImapSearchCriterion * self = NULL;
	GeeList* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyImapSearchCriterion*) geary_base_object_construct (object_type);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = geary_imap_search_criterion_prep_name (name);
	_tmp2_ = _tmp1_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp2_);
	_g_object_unref0 (_tmp2_);
	return self;
}

GearyImapSearchCriterion*
geary_imap_search_criterion_new_simple (const gchar* name)
{
	return geary_imap_search_criterion_construct_simple (GEARY_IMAP_TYPE_SEARCH_CRITERION, name);
}

/**
     * Create a single criterion with a simple name and custom value.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_construct_parameter_value (GType object_type,
                                                       const gchar* name,
                                                       GearyImapParameter* value)
{
	GearyImapSearchCriterion * self = NULL;
	GeeList* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	GeeList* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_PARAMETER (value), NULL);
	self = (GearyImapSearchCriterion*) geary_base_object_construct (object_type);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = geary_imap_search_criterion_prep_name (name);
	_tmp2_ = _tmp1_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->parameters;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), value);
	return self;
}

GearyImapSearchCriterion*
geary_imap_search_criterion_new_parameter_value (const gchar* name,
                                                 GearyImapParameter* value)
{
	return geary_imap_search_criterion_construct_parameter_value (GEARY_IMAP_TYPE_SEARCH_CRITERION, name, value);
}

/**
     * Create a single criterion with a simple name and custom value.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_construct_string_value (GType object_type,
                                                    const gchar* name,
                                                    const gchar* value)
{
	GearyImapSearchCriterion * self = NULL;
	GeeList* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	GeeList* _tmp3_;
	GearyImapParameter* _tmp4_;
	GearyImapParameter* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (GearyImapSearchCriterion*) geary_base_object_construct (object_type);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = geary_imap_search_criterion_prep_name (name);
	_tmp2_ = _tmp1_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->parameters;
	_tmp4_ = geary_imap_parameter_get_for_string (value);
	_tmp5_ = _tmp4_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _tmp5_);
	_g_object_unref0 (_tmp5_);
	return self;
}

GearyImapSearchCriterion*
geary_imap_search_criterion_new_string_value (const gchar* name,
                                              const gchar* value)
{
	return geary_imap_search_criterion_construct_string_value (GEARY_IMAP_TYPE_SEARCH_CRITERION, name, value);
}

static GearyImapParameter*
geary_imap_search_criterion_prep_name (const gchar* name)
{
	GearyImapParameter* namep = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapParameter* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = geary_imap_string_parameter_try_get_best_for (name);
	namep = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
	_tmp1_ = namep;
	if (_tmp1_ == NULL) {
		GearyMemoryStringBuffer* _tmp2_;
		GearyMemoryStringBuffer* _tmp3_;
		GearyImapLiteralParameter* _tmp4_;
		g_warning ("imap-search-criterion.vala:54: Using a search name that requires a lit" \
"eral parameter: %s", name);
		_tmp2_ = geary_memory_string_buffer_new (name);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_imap_literal_parameter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (namep);
		namep = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
		_g_object_unref0 (_tmp3_);
	}
	result = namep;
	return result;
}

/**
     * The IMAP SEARCH ALL criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_all (void)
{
	GearyImapSearchCriterion* _tmp0_;
	GearyImapSearchCriterion* result;
	_tmp0_ = geary_imap_search_criterion_new_simple ("all");
	result = _tmp0_;
	return result;
}

/**
     * The IMAP SEARCH OR criterion, which operates on other {@link SearchCriterion}.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_or (GearyImapSearchCriterion* a,
                                GearyImapSearchCriterion* b)
{
	GearyImapSearchCriterion* criterion = NULL;
	GearyImapSearchCriterion* _tmp0_;
	GeeList* _tmp1_;
	GearyImapParameter* _tmp2_;
	GearyImapParameter* _tmp3_;
	GeeList* _tmp4_;
	GearyImapParameter* _tmp5_;
	GearyImapParameter* _tmp6_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (a), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (b), NULL);
	_tmp0_ = geary_imap_search_criterion_new_simple ("or");
	criterion = _tmp0_;
	_tmp1_ = criterion->priv->parameters;
	_tmp2_ = geary_imap_search_criterion_to_list_parameter (a);
	_tmp3_ = _tmp2_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = criterion->priv->parameters;
	_tmp5_ = geary_imap_search_criterion_to_list_parameter (b);
	_tmp6_ = _tmp5_;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), _tmp6_);
	_g_object_unref0 (_tmp6_);
	result = criterion;
	return result;
}

/**
     * The IMAP SEARCH NOT criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_not (GearyImapSearchCriterion* a)
{
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (a), NULL);
	_tmp0_ = geary_imap_search_criterion_to_list_parameter (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("not", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * The IMAP SEARCH NEW criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_new_messages (void)
{
	GearyImapSearchCriterion* _tmp0_;
	GearyImapSearchCriterion* result;
	_tmp0_ = geary_imap_search_criterion_new_simple ("new");
	result = _tmp0_;
	return result;
}

/**
     * The IMAP SEARCH OLD criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_old_messages (void)
{
	GearyImapSearchCriterion* _tmp0_;
	GearyImapSearchCriterion* result;
	_tmp0_ = geary_imap_search_criterion_new_simple ("old");
	result = _tmp0_;
	return result;
}

/**
     * The IMAP SEARCH KEYWORD criterion, or if the {@link MessageFlag} has a macro, that value.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_has_flag (GearyImapMessageFlag* flag,
                                      GError** error)
{
	gchar* keyword = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GearyImapStringParameter* _tmp4_ = NULL;
	GearyImapStringParameter* _tmp5_;
	GearyImapSearchCriterion* _tmp6_;
	GError* _inner_error0_ = NULL;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_FLAG (flag), NULL);
	_tmp0_ = geary_imap_message_flag_get_search_keyword (flag, TRUE);
	keyword = _tmp0_;
	_tmp1_ = keyword;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GearyImapSearchCriterion* _tmp3_;
		_tmp2_ = keyword;
		_tmp3_ = geary_imap_search_criterion_new_simple (_tmp2_);
		result = _tmp3_;
		_g_free0 (keyword);
		return result;
	}
	_tmp5_ = geary_imap_flag_to_parameter (G_TYPE_CHECK_INSTANCE_CAST (flag, GEARY_IMAP_TYPE_FLAG, GearyImapFlag), &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (keyword);
			return NULL;
		} else {
			_g_free0 (keyword);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_search_criterion_new_parameter_value ("keyword", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	result = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_free0 (keyword);
	return result;
}

/**
     * The IMAP SEARCH UNKEYWORD criterion, or if the {@link MessageFlag} has a macro, that value.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_has_not_flag (GearyImapMessageFlag* flag,
                                          GError** error)
{
	gchar* keyword = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GearyImapStringParameter* _tmp4_ = NULL;
	GearyImapStringParameter* _tmp5_;
	GearyImapSearchCriterion* _tmp6_;
	GError* _inner_error0_ = NULL;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_FLAG (flag), NULL);
	_tmp0_ = geary_imap_message_flag_get_search_keyword (flag, FALSE);
	keyword = _tmp0_;
	_tmp1_ = keyword;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GearyImapSearchCriterion* _tmp3_;
		_tmp2_ = keyword;
		_tmp3_ = geary_imap_search_criterion_new_simple (_tmp2_);
		result = _tmp3_;
		_g_free0 (keyword);
		return result;
	}
	_tmp5_ = geary_imap_flag_to_parameter (G_TYPE_CHECK_INSTANCE_CAST (flag, GEARY_IMAP_TYPE_FLAG, GearyImapFlag), &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (keyword);
			return NULL;
		} else {
			_g_free0 (keyword);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_search_criterion_new_parameter_value ("unkeyword", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	result = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_free0 (keyword);
	return result;
}

/**
     * The IMAP SEARCH BEFORE criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_before_internaldate (GearyImapInternalDate* internaldate)
{
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (internaldate), NULL);
	_tmp0_ = geary_imap_internal_date_to_search_parameter (internaldate);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("before", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * The IMAP SEARCH ON criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_on_internaldate (GearyImapInternalDate* internaldate)
{
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (internaldate), NULL);
	_tmp0_ = geary_imap_internal_date_to_search_parameter (internaldate);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("on", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * The IMAP SEARCH SINCE criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_since_internaldate (GearyImapInternalDate* internaldate)
{
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_INTERNAL_DATE (internaldate), NULL);
	_tmp0_ = geary_imap_internal_date_to_search_parameter (internaldate);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("since", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * The IMAP SEARCH BODY criterion, which searches the body for the string.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_body (const gchar* value)
{
	GearyImapSearchCriterion* _tmp0_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_imap_search_criterion_new_string_value ("body", value);
	result = _tmp0_;
	return result;
}

/**
     * The IMAP SEARCH TEXT criterion, which searches the header and body for the string.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_text (const gchar* value)
{
	GearyImapSearchCriterion* _tmp0_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = geary_imap_search_criterion_new_string_value ("text", value);
	result = _tmp0_;
	return result;
}

/**
     * The IMAP SEARCH SMALLER criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_smaller (guint32 value)
{
	GearyImapNumberParameter* _tmp0_;
	GearyImapNumberParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	_tmp0_ = geary_imap_number_parameter_new_uint32 (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("smaller", G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * The IMAP SEARCH LARGER criterion.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_larger (guint32 value)
{
	GearyImapNumberParameter* _tmp0_;
	GearyImapNumberParameter* _tmp1_;
	GearyImapSearchCriterion* _tmp2_;
	GearyImapSearchCriterion* _tmp3_;
	GearyImapSearchCriterion* result;
	_tmp0_ = geary_imap_number_parameter_new_uint32 (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_search_criterion_new_parameter_value ("larger", G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Specifies messages (by sequence number or UID) to limit the IMAP SEARCH to.
     */
GearyImapSearchCriterion*
geary_imap_search_criterion_message_set (GearyImapMessageSet* msg_set)
{
	GearyImapSearchCriterion* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GearyImapSearchCriterion* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (msg_set), NULL);
	_tmp1_ = geary_imap_message_set_get_is_uid (msg_set);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GearyImapParameter* _tmp3_;
		GearyImapParameter* _tmp4_;
		GearyImapSearchCriterion* _tmp5_;
		_tmp3_ = geary_imap_message_set_to_parameter (msg_set);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_search_criterion_new_parameter_value ("uid", _tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GearyImapParameter* _tmp6_;
		GearyImapParameter* _tmp7_;
		GearyImapSearchCriterion* _tmp8_;
		_tmp6_ = geary_imap_message_set_to_parameter (msg_set);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_imap_search_criterion_new (_tmp7_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the {@link SearchCriterion} as one or more IMAP {@link Parameter}s.
     *
     * Although each set of multiple parameters could be a list, the "usual" way of specifying
     * SEARCH arguments is without parentheses, and this strives to emulate that programmatically.
     *
     * The Parameters should be included in the {@link Command} in exactly the order returned.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
geary_imap_search_criterion_to_parameters (GearyImapSearchCriterion* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (self), NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * Return {@link Parameter}s as a {@link ListParameter} if multiple, a single Parameter
     * otherwise.
     */
GearyImapParameter*
geary_imap_search_criterion_to_list_parameter (GearyImapSearchCriterion* self)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GearyImapListParameter* listp = NULL;
	GearyImapListParameter* _tmp5_;
	GearyImapListParameter* _tmp6_;
	GeeList* _tmp7_;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (self), NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1) {
		GeeList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->priv->parameters;
		_tmp4_ = gee_list_get (_tmp3_, 0);
		result = (GearyImapParameter*) _tmp4_;
		return result;
	}
	_tmp5_ = geary_imap_list_parameter_new ();
	listp = _tmp5_;
	_tmp6_ = listp;
	_tmp7_ = self->priv->parameters;
	geary_imap_list_parameter_add_all (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (listp, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
	return result;
}

gchar*
geary_imap_search_criterion_to_string (GearyImapSearchCriterion* self)
{
	GearyImapParameter* _tmp0_;
	GearyImapParameter* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEARCH_CRITERION (self), NULL);
	_tmp0_ = geary_imap_search_criterion_to_list_parameter (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_parameter_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
geary_imap_search_criterion_class_init (GearyImapSearchCriterionClass * klass,
                                        gpointer klass_data)
{
	geary_imap_search_criterion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapSearchCriterion_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_imap_search_criterion_finalize;
}

static void
geary_imap_search_criterion_instance_init (GearyImapSearchCriterion * self,
                                           gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = geary_imap_search_criterion_get_instance_private (self);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_PARAMETER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->parameters = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
geary_imap_search_criterion_finalize (GObject * obj)
{
	GearyImapSearchCriterion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_SEARCH_CRITERION, GearyImapSearchCriterion);
	_g_object_unref0 (self->priv->parameters);
	G_OBJECT_CLASS (geary_imap_search_criterion_parent_class)->finalize (obj);
}

/**
 * A representation of a single IMAP SEARCH criteria.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.4.4]]
 *
 * The current implementation does not support searching by sent date or arbitrary header values.
 *
 * @see SearchCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_search_criterion_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapSearchCriterionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_search_criterion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapSearchCriterion), 0, (GInstanceInitFunc) geary_imap_search_criterion_instance_init, NULL };
	GType geary_imap_search_criterion_type_id;
	geary_imap_search_criterion_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapSearchCriterion", &g_define_type_info, 0);
	GearyImapSearchCriterion_private_offset = g_type_add_instance_private (geary_imap_search_criterion_type_id, sizeof (GearyImapSearchCriterionPrivate));
	return geary_imap_search_criterion_type_id;
}

GType
geary_imap_search_criterion_get_type (void)
{
	static gsize geary_imap_search_criterion_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_search_criterion_type_id__once)) {
		GType geary_imap_search_criterion_type_id;
		geary_imap_search_criterion_type_id = geary_imap_search_criterion_get_type_once ();
		g_once_init_leave (&geary_imap_search_criterion_type_id__once, geary_imap_search_criterion_type_id);
	}
	return geary_imap_search_criterion_type_id__once;
}

