/* rfc822-mailbox-address.c generated by valac 0.56.3, the Vala compiler
 * generated from rfc822-mailbox-address.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gmime/gmime.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_RF_C822_MAILBOX_ADDRESS_0_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY,
	GEARY_RF_C822_MAILBOX_ADDRESS_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GMimeFormatOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeFormatOptions_free (var), NULL)))

struct _GearyRFC822MailboxAddressPrivate {
	gchar* _name;
	gchar* _source_route;
	gchar* _mailbox;
	gchar* _domain;
	gchar* _address;
};

static gint GearyRFC822MailboxAddress_private_offset;
static gpointer geary_rf_c822_mailbox_address_parent_class = NULL;
static GRegex* geary_rf_c822_mailbox_address_email_regex;
static GRegex* geary_rf_c822_mailbox_address_email_regex = NULL;
static gunichar* geary_rf_c822_mailbox_address_ATEXT;
static gint geary_rf_c822_mailbox_address_ATEXT_length1;
static gunichar* geary_rf_c822_mailbox_address_ATEXT = NULL;
static gint geary_rf_c822_mailbox_address_ATEXT_length1 = 0;
static gint _geary_rf_c822_mailbox_address_ATEXT_size_ = 0;
static GearyMessageDataSearchableMessageDataIface * geary_rf_c822_mailbox_address_geary_message_data_searchable_message_data_parent_iface = NULL;
static GeeHashableIface * geary_rf_c822_mailbox_address_gee_hashable_parent_iface = NULL;
static GearyRFC822DecodedMessageDataIface * geary_rf_c822_mailbox_address_geary_rf_c822_decoded_message_data_parent_iface = NULL;

static gchar* geary_rf_c822_mailbox_address_decode_name (const gchar* name);
static gchar* geary_rf_c822_mailbox_address_prepare_header_text_part (const gchar* part);
static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
static gchar* geary_rf_c822_mailbox_address_decode_address_part (const gchar* mailbox);
static gboolean geary_rf_c822_mailbox_address_display_name_needs_quoting (const gchar* name);
static gboolean geary_rf_c822_mailbox_address_local_part_needs_quoting (const gchar* local_part);
static gboolean _vala_unichar_array_contains (gunichar * stack,
                                       gssize stack_length,
                                       const gunichar needle);
static gchar* geary_rf_c822_mailbox_address_quote_string (const gchar* needs_quoting);
static void geary_rf_c822_mailbox_address_set_name (GearyRFC822MailboxAddress* self,
                                             const gchar* value);
static void geary_rf_c822_mailbox_address_set_source_route (GearyRFC822MailboxAddress* self,
                                                     const gchar* value);
static void geary_rf_c822_mailbox_address_set_mailbox (GearyRFC822MailboxAddress* self,
                                                const gchar* value);
static void geary_rf_c822_mailbox_address_set_domain (GearyRFC822MailboxAddress* self,
                                               const gchar* value);
static void geary_rf_c822_mailbox_address_set_address (GearyRFC822MailboxAddress* self,
                                                const gchar* value);
static gchar* geary_rf_c822_mailbox_address_real_to_rfc822_string (GearyRFC822DecodedMessageData* base);
static void _vala_GMimeFormatOptions_free (GMimeFormatOptions* self);
static gchar* geary_rf_c822_mailbox_address_real_to_searchable_string (GearyMessageDataSearchableMessageData* base);
static guint geary_rf_c822_mailbox_address_real_hash (GeeHashable* base);
static gboolean geary_rf_c822_mailbox_address_real_equal_to (GeeHashable* base,
                                                      GearyRFC822MailboxAddress* other);
static gchar* geary_rf_c822_mailbox_address_real_to_string (GearyMessageDataAbstractMessageData* base);
static void geary_rf_c822_mailbox_address_finalize (GObject * obj);
static GType geary_rf_c822_mailbox_address_get_type_once (void);
static void _vala_geary_rf_c822_mailbox_address_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_geary_rf_c822_mailbox_address_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
geary_rf_c822_mailbox_address_get_instance_private (GearyRFC822MailboxAddress* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822MailboxAddress_private_offset);
}

/** Determines if a string contains a valid RFC822 mailbox address. */
gboolean
geary_rf_c822_mailbox_address_is_valid_address (const gchar* address)
{
	GRegex* _tmp0_;
	GRegex* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = geary_rf_c822_mailbox_address_email_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("[A-Z0-9._%+-]+@((?:[A-Z0-9-]+\\.)+[A-Z]{2}|localhost)", G_REGEX_CASELESS, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (geary_rf_c822_mailbox_address_email_regex);
			geary_rf_c822_mailbox_address_email_regex = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("rfc822-mailbox-address.vala:43: Regex error validating email address: " \
"%s", _tmp6_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	_tmp8_ = geary_rf_c822_mailbox_address_email_regex;
	result = g_regex_match (_tmp8_, address, 0, NULL);
	return result;
}

static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

static gchar*
geary_rf_c822_mailbox_address_decode_name (const gchar* name)
{
	GMimeParserOptions* _tmp0_;
	GMimeParserOptions* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = geary_rf_c822_get_parser_options ();
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_rf_c822_mailbox_address_prepare_header_text_part (name);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mime_utils_header_decode_phrase (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	__vala_GMimeParserOptions_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static gchar*
geary_rf_c822_mailbox_address_decode_address_part (const gchar* mailbox)
{
	GMimeParserOptions* _tmp0_;
	GMimeParserOptions* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (mailbox != NULL, NULL);
	_tmp0_ = geary_rf_c822_get_parser_options ();
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_rf_c822_mailbox_address_prepare_header_text_part (mailbox);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mime_utils_header_decode_text (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	__vala_GMimeParserOptions_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
geary_rf_c822_mailbox_address_display_name_needs_quoting (const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = string_index_of (name, ",", 0) != -1;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
_vala_unichar_array_contains (gunichar * stack,
                              gssize stack_length,
                              const gunichar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
geary_rf_c822_mailbox_address_local_part_needs_quoting (const gchar* local_part)
{
	gboolean needs_quote = FALSE;
	gboolean is_dot = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean result;
	g_return_val_if_fail (local_part != NULL, FALSE);
	needs_quote = FALSE;
	is_dot = FALSE;
	if (!geary_string_is_empty (local_part)) {
		gint index = 0;
		index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar ch = 0U;
				gunichar _tmp1_ = 0U;
				gboolean _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp2_ = string_get_next_char (local_part, &index, &_tmp1_);
				ch = _tmp1_;
				if (!_tmp2_) {
					break;
				}
				is_dot = ch == ((gunichar) '.');
				if (ch >= ((gunichar) 0x61)) {
					_tmp10_ = ch <= ((gunichar) 0x7A);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (ch >= ((gunichar) 0x41)) {
						_tmp11_ = ch <= ((gunichar) 0x5A);
					} else {
						_tmp11_ = FALSE;
					}
					_tmp9_ = _tmp11_;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp12_ = FALSE;
					if (ch >= ((gunichar) 0x30)) {
						_tmp12_ = ch <= ((gunichar) 0x39);
					} else {
						_tmp12_ = FALSE;
					}
					_tmp8_ = _tmp12_;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					gboolean _tmp13_ = FALSE;
					if (ch >= ((gunichar) 0x80)) {
						_tmp13_ = ch <= ((gunichar) 0x07FF);
					} else {
						_tmp13_ = FALSE;
					}
					_tmp7_ = _tmp13_;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp14_ = FALSE;
					if (ch >= ((gunichar) 0x800)) {
						_tmp14_ = ch <= ((gunichar) 0xFFFF);
					} else {
						_tmp14_ = FALSE;
					}
					_tmp6_ = _tmp14_;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp15_ = FALSE;
					if (ch >= ((gunichar) 0x10000)) {
						_tmp15_ = ch <= ((gunichar) 0x10FFFF);
					} else {
						_tmp15_ = FALSE;
					}
					_tmp5_ = _tmp15_;
				}
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					gunichar* _tmp16_;
					gint _tmp16__length1;
					_tmp16_ = geary_rf_c822_mailbox_address_ATEXT;
					_tmp16__length1 = geary_rf_c822_mailbox_address_ATEXT_length1;
					_tmp4_ = _vala_unichar_array_contains (_tmp16_, _tmp16__length1, ch);
				}
				if (_tmp4_) {
					_tmp3_ = TRUE;
				} else {
					gboolean _tmp17_ = FALSE;
					if (is_dot) {
						_tmp17_ = index > 1;
					} else {
						_tmp17_ = FALSE;
					}
					_tmp3_ = _tmp17_;
				}
				if (!_tmp3_) {
					needs_quote = TRUE;
					break;
				}
			}
		}
	}
	if (needs_quote) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = is_dot;
	}
	result = _tmp18_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
geary_rf_c822_mailbox_address_quote_string (const gchar* needs_quoting)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (needs_quoting != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (!geary_string_is_empty (needs_quoting)) {
		GString* _tmp1_;
		gint index = 0;
		GString* _tmp8_;
		_tmp1_ = builder;
		g_string_append_c (_tmp1_, '"');
		index = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar ch = '\0';
				const gchar* _tmp3_;
				gint _tmp4_;
				gboolean _tmp5_ = FALSE;
				GString* _tmp7_;
				if (!_tmp2_) {
				}
				_tmp2_ = FALSE;
				_tmp3_ = needs_quoting;
				_tmp4_ = index;
				index = _tmp4_ + 1;
				ch = string_get (_tmp3_, (glong) _tmp4_);
				if (ch == GEARY_STRING_EOS) {
					break;
				}
				if (ch == '"') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = ch == '\\';
				}
				if (_tmp5_) {
					GString* _tmp6_;
					_tmp6_ = builder;
					g_string_append_c (_tmp6_, '\\');
				}
				_tmp7_ = builder;
				g_string_append_c (_tmp7_, ch);
			}
		}
		_tmp8_ = builder;
		g_string_append_c (_tmp8_, '"');
	}
	_tmp9_ = builder;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
geary_rf_c822_mailbox_address_prepare_header_text_part (const gchar* part)
{
	gchar* _tmp0_ = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* text = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gint offset = 0;
	gint start = 0;
	gchar* result;
	g_return_val_if_fail (part != NULL, NULL);
	_tmp1_ = string_get_data (part, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	if (!g_mime_utils_text_is_8bit (_tmp3_, (gsize) _tmp3__length1)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (part);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		GMimeParserOptions* _tmp5_;
		GMimeParserOptions* _tmp6_;
		guint8* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		guint8* _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_;
		_tmp5_ = geary_rf_c822_get_parser_options ();
		_tmp6_ = _tmp5_;
		_tmp7_ = string_get_data (part, &_tmp8_);
		_tmp7__length1 = _tmp8_;
		_tmp9_ = _tmp7_;
		_tmp9__length1 = _tmp7__length1;
		_tmp10_ = g_mime_utils_decode_8bit (_tmp6_, _tmp9_, (gsize) _tmp9__length1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
		__vala_GMimeParserOptions_free0 (_tmp6_);
	}
	_tmp11_ = g_strdup (_tmp0_);
	text = _tmp11_;
	_tmp12_ = text;
	_tmp13_ = g_mime_utils_header_unfold (_tmp12_);
	_g_free0 (text);
	text = _tmp13_;
	_tmp14_ = text;
	g_mime_utils_unquote_string (_tmp14_);
	offset = 0;
	while (TRUE) {
		const gchar* _tmp15_;
		gint end = 0;
		const gchar* _tmp16_;
		gchar* encoded = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp15_ = text;
		start = string_index_of (_tmp15_, "=?", offset);
		if (!(start != -1)) {
			break;
		}
		_tmp16_ = text;
		end = string_index_of (_tmp16_, "?=", start + 2) + 2;
		if (end <= 1) {
			const gchar* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp17_ = text;
			_tmp18_ = strlen (_tmp17_);
			_tmp19_ = _tmp18_;
			end = _tmp19_;
		}
		_tmp20_ = text;
		_tmp21_ = string_substring (_tmp20_, (glong) start, (glong) (end - start));
		encoded = _tmp21_;
		_tmp22_ = encoded;
		if (string_contains (_tmp22_, "\x20")) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp23_ = text;
			_tmp24_ = encoded;
			_tmp25_ = encoded;
			_tmp26_ = string_replace (_tmp25_, "\x20", "_");
			_tmp27_ = _tmp26_;
			_tmp28_ = string_replace (_tmp23_, _tmp24_, _tmp27_);
			_g_free0 (text);
			text = _tmp28_;
			_g_free0 (_tmp27_);
		}
		offset = end;
		_g_free0 (encoded);
	}
	result = text;
	_g_free0 (_tmp0_);
	return result;
}

const gchar*
geary_rf_c822_mailbox_address_get_name (GearyRFC822MailboxAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_set_name (GearyRFC822MailboxAddress* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self));
	old_value = geary_rf_c822_mailbox_address_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_mailbox_address_get_source_route (GearyRFC822MailboxAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_source_route;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_set_source_route (GearyRFC822MailboxAddress* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self));
	old_value = geary_rf_c822_mailbox_address_get_source_route (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_source_route);
		self->priv->_source_route = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_mailbox_address_get_mailbox (GearyRFC822MailboxAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_set_mailbox (GearyRFC822MailboxAddress* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self));
	old_value = geary_rf_c822_mailbox_address_get_mailbox (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mailbox);
		self->priv->_mailbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_mailbox_address_get_domain (GearyRFC822MailboxAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_domain;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_set_domain (GearyRFC822MailboxAddress* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self));
	old_value = geary_rf_c822_mailbox_address_get_domain (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_domain);
		self->priv->_domain = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_mailbox_address_get_address (GearyRFC822MailboxAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_address;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_set_address (GearyRFC822MailboxAddress* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self));
	old_value = geary_rf_c822_mailbox_address_get_address (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_address);
		self->priv->_address = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY]);
	}
}

/**
     * Constructs a new mailbox address from unquoted, decoded parts.
     *
     * The given name (if any) and address parts will be used
     * verbatim, and quoted or encoded if needed when serialising to
     * an RFC 822 mailbox address string.
     */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_construct (GType object_type,
                                         const gchar* name,
                                         const gchar* address)
{
	GearyRFC822MailboxAddress * self = NULL;
	gint atsign = 0;
	g_return_val_if_fail (address != NULL, NULL);
	self = (GearyRFC822MailboxAddress*) geary_message_data_abstract_message_data_construct (object_type);
	geary_rf_c822_mailbox_address_set_name (self, name);
	geary_rf_c822_mailbox_address_set_source_route (self, NULL);
	geary_rf_c822_mailbox_address_set_address (self, address);
	atsign = geary_ascii_last_index_of (address, '@');
	if (atsign > 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = string_slice (address, (glong) 0, (glong) atsign);
		_tmp1_ = _tmp0_;
		geary_rf_c822_mailbox_address_set_mailbox (self, _tmp1_);
		_g_free0 (_tmp1_);
		_tmp2_ = strlen (address);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_slice (address, (glong) (atsign + 1), (glong) _tmp3_);
		_tmp5_ = _tmp4_;
		geary_rf_c822_mailbox_address_set_domain (self, _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		geary_rf_c822_mailbox_address_set_mailbox (self, "");
		geary_rf_c822_mailbox_address_set_domain (self, "");
	}
	return self;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_new (const gchar* name,
                                   const gchar* address)
{
	return geary_rf_c822_mailbox_address_construct (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, name, address);
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_construct_imap (GType object_type,
                                              const gchar* name,
                                              const gchar* source_route,
                                              const gchar* mailbox,
                                              const gchar* domain)
{
	GearyRFC822MailboxAddress * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean empty_mailbox = FALSE;
	gboolean empty_domain = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (mailbox != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	self = (GearyRFC822MailboxAddress*) geary_message_data_abstract_message_data_construct (object_type);
	if (name != NULL) {
		gchar* _tmp1_;
		_tmp1_ = geary_rf_c822_mailbox_address_decode_name (name);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	geary_rf_c822_mailbox_address_set_name (self, _tmp0_);
	geary_rf_c822_mailbox_address_set_source_route (self, source_route);
	_tmp2_ = geary_rf_c822_mailbox_address_decode_address_part (mailbox);
	_tmp3_ = _tmp2_;
	geary_rf_c822_mailbox_address_set_mailbox (self, _tmp3_);
	_g_free0 (_tmp3_);
	geary_rf_c822_mailbox_address_set_domain (self, domain);
	empty_mailbox = geary_string_is_empty_or_whitespace (mailbox);
	empty_domain = geary_string_is_empty_or_whitespace (domain);
	if (!empty_mailbox) {
		_tmp4_ = !empty_domain;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("%s@%s", mailbox, domain);
		_tmp6_ = _tmp5_;
		geary_rf_c822_mailbox_address_set_address (self, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		if (empty_mailbox) {
			geary_rf_c822_mailbox_address_set_address (self, domain);
		} else {
			if (empty_domain) {
				geary_rf_c822_mailbox_address_set_address (self, mailbox);
			} else {
				geary_rf_c822_mailbox_address_set_address (self, "");
			}
		}
	}
	_g_free0 (_tmp0_);
	return self;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_new_imap (const gchar* name,
                                        const gchar* source_route,
                                        const gchar* mailbox,
                                        const gchar* domain)
{
	return geary_rf_c822_mailbox_address_construct_imap (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, name, source_route, mailbox, domain);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_construct_from_rfc822_string (GType object_type,
                                                            const gchar* rfc822,
                                                            GError** error)
{
	GearyRFC822MailboxAddress * self = NULL;
	InternetAddressList* addrlist = NULL;
	GMimeParserOptions* _tmp0_;
	GMimeParserOptions* _tmp1_;
	InternetAddressList* _tmp2_;
	InternetAddressList* _tmp3_;
	InternetAddressList* _tmp4_;
	InternetAddressList* _tmp6_;
	InternetAddress* addr = NULL;
	InternetAddressList* _tmp8_;
	InternetAddress* _tmp9_;
	InternetAddress* _tmp10_;
	InternetAddressMailbox* mbox_addr = NULL;
	InternetAddressMailbox* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (rfc822 != NULL, NULL);
	_tmp0_ = geary_rf_c822_get_parser_options ();
	_tmp1_ = _tmp0_;
	_tmp2_ = internet_address_list_parse (_tmp1_, rfc822);
	_tmp3_ = _tmp2_;
	__vala_GMimeParserOptions_free0 (_tmp1_);
	addrlist = _tmp3_;
	_tmp4_ = addrlist;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Not a RFC822 mailbox address: %s", rfc822);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (addrlist);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (addrlist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = addrlist;
	if (internet_address_list_length (_tmp6_) != 1) {
		GError* _tmp7_;
		_tmp7_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Not a single RFC822 mailbox address: %s", rfc822);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (addrlist);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (addrlist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = addrlist;
	_tmp9_ = internet_address_list_get_address (_tmp8_, 0);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	addr = _tmp10_;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (addr, internet_address_mailbox_get_type ()) ? ((InternetAddressMailbox*) addr) : NULL);
	mbox_addr = _tmp11_;
	if (mbox_addr == NULL) {
		GError* _tmp12_;
		_tmp12_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Group lists not currently supported: %s", rfc822);
		_inner_error0_ = _tmp12_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (mbox_addr);
			_g_object_unref0 (addr);
			_g_object_unref0 (addrlist);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (mbox_addr);
			_g_object_unref0 (addr);
			_g_object_unref0 (addrlist);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (GearyRFC822MailboxAddress*) geary_rf_c822_mailbox_address_construct_from_gmime (object_type, mbox_addr);
	_g_object_unref0 (mbox_addr);
	_g_object_unref0 (addr);
	_g_object_unref0 (addrlist);
	return self;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_new_from_rfc822_string (const gchar* rfc822,
                                                      GError** error)
{
	return geary_rf_c822_mailbox_address_construct_from_rfc822_string (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, rfc822, error);
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_construct_from_gmime (GType object_type,
                                                    InternetAddressMailbox* mailbox)
{
	GearyRFC822MailboxAddress * self = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* address = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint atsign = 0;
	const gchar* _tmp8_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mailbox, internet_address_mailbox_get_type ()), NULL);
	self = (GearyRFC822MailboxAddress*) geary_message_data_abstract_message_data_construct (object_type);
	_tmp0_ = internet_address_get_name (G_TYPE_CHECK_INSTANCE_CAST (mailbox, internet_address_get_type (), InternetAddress));
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (!geary_string_is_empty_or_whitespace (_tmp3_)) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = name;
		_tmp5_ = geary_rf_c822_mailbox_address_decode_name (_tmp4_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		_g_free0 (_tmp2_);
		_tmp2_ = NULL;
	}
	geary_rf_c822_mailbox_address_set_name (self, _tmp2_);
	_tmp6_ = internet_address_mailbox_get_addr (mailbox);
	_tmp7_ = g_strdup (_tmp6_);
	address = _tmp7_;
	_tmp8_ = address;
	atsign = geary_ascii_last_index_of (_tmp8_, '@');
	if (atsign == -1) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = address;
		_tmp10_ = geary_rf_c822_mailbox_address_decode_address_part (_tmp9_);
		_g_free0 (address);
		address = _tmp10_;
		_tmp11_ = address;
		atsign = geary_ascii_last_index_of (_tmp11_, '@');
	}
	if (atsign >= 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp12_ = address;
		_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) atsign);
		_tmp14_ = _tmp13_;
		_tmp15_ = geary_rf_c822_mailbox_address_decode_address_part (_tmp14_);
		_tmp16_ = _tmp15_;
		geary_rf_c822_mailbox_address_set_mailbox (self, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_tmp17_ = address;
		_tmp18_ = address;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_slice (_tmp17_, (glong) (atsign + 1), (glong) _tmp20_);
		_tmp22_ = _tmp21_;
		geary_rf_c822_mailbox_address_set_domain (self, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = self->priv->_mailbox;
		_tmp24_ = self->priv->_domain;
		_tmp25_ = g_strdup_printf ("%s@%s", _tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		geary_rf_c822_mailbox_address_set_address (self, _tmp26_);
		_g_free0 (_tmp26_);
	} else {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		geary_rf_c822_mailbox_address_set_mailbox (self, "");
		geary_rf_c822_mailbox_address_set_domain (self, "");
		_tmp27_ = address;
		_tmp28_ = geary_rf_c822_mailbox_address_decode_address_part (_tmp27_);
		_tmp29_ = _tmp28_;
		geary_rf_c822_mailbox_address_set_address (self, _tmp29_);
		_g_free0 (_tmp29_);
	}
	_g_free0 (address);
	_g_free0 (_tmp2_);
	_g_free0 (name);
	return self;
}

GearyRFC822MailboxAddress*
geary_rf_c822_mailbox_address_new_from_gmime (InternetAddressMailbox* mailbox)
{
	return geary_rf_c822_mailbox_address_construct_from_gmime (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, mailbox);
}

/**
     * Returns a full human-readable version of the mailbox address.
     *
     * This returns a formatted version of the address including
     * {@link name} (if present, not a spoof, and distinct from the
     * address) and {@link address} parts, suitable for display to
     * people. The string will have white space reduced and
     * non-printable characters removed, and the address will be
     * surrounded by angle brackets if a name is present, and if the
     * name contains a reserved character, it will be quoted.
     *
     * If you need a form suitable for sending a message, see {@link
     * to_rfc822_string} instead.
     *
     * @see has_distinct_name
     * @see is_spoofed
     * @param open optional string to use as the opening bracket for
     * the address part, defaults to //<//
     * @param close optional string to use as the closing bracket for
     * the address part, defaults to //>//
     * @return the cleaned //name// part if present, not spoofed and
     * distinct from //address//, followed by a space then the cleaned
     * //address// part, cleaned and enclosed within the specified
     * brackets.
     */
gchar*
geary_rf_c822_mailbox_address_to_full_display (GearyRFC822MailboxAddress* self,
                                               const gchar* open,
                                               const gchar* close)
{
	gchar* clean_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* clean_address = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	g_return_val_if_fail (open != NULL, NULL);
	g_return_val_if_fail (close != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = geary_string_reduce_whitespace (_tmp0_);
	clean_name = _tmp1_;
	_tmp2_ = clean_name;
	if (geary_rf_c822_mailbox_address_display_name_needs_quoting (_tmp2_)) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = clean_name;
		_tmp4_ = geary_rf_c822_mailbox_address_quote_string (_tmp3_);
		_g_free0 (clean_name);
		clean_name = _tmp4_;
	}
	_tmp5_ = self->priv->_address;
	_tmp6_ = geary_string_reduce_whitespace (_tmp5_);
	clean_address = _tmp6_;
	if (!geary_rf_c822_mailbox_address_has_distinct_name (self)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = geary_rf_c822_mailbox_address_is_spoofed (self);
	}
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = clean_address;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp10_;
	} else {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = clean_name;
		_tmp12_ = clean_address;
		_tmp13_ = g_strdup_printf ("%s %s%s%s", _tmp11_, open, _tmp12_, close);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp13_;
	}
	result = _tmp7_;
	_g_free0 (clean_address);
	_g_free0 (clean_name);
	return result;
}

/**
     * Returns a short human-readable version of the mailbox address.
     *
     * This returns a shortened version of the address suitable for
     * display to people: Either the {@link name} (if present and not
     * a spoof) or the {@link address} part otherwise. The string will
     * have white space reduced and non-printable characters removed.
     *
     * @see is_spoofed
     * @return the cleaned //name// part if present and not spoofed,
     * or else the cleaned //address// part, cleaned but without
     * brackets.
     */
gchar*
geary_rf_c822_mailbox_address_to_short_display (GearyRFC822MailboxAddress* self)
{
	gchar* clean_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* clean_address = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = geary_string_reduce_whitespace (_tmp0_);
	clean_name = _tmp1_;
	_tmp2_ = self->priv->_address;
	_tmp3_ = geary_string_reduce_whitespace (_tmp2_);
	clean_address = _tmp3_;
	_tmp6_ = clean_name;
	if (geary_string_is_empty (_tmp6_)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = geary_rf_c822_mailbox_address_is_spoofed (self);
	}
	if (_tmp5_) {
		const gchar* _tmp7_;
		_tmp7_ = clean_address;
		_tmp4_ = _tmp7_;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = clean_name;
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = g_strdup (_tmp4_);
	result = _tmp9_;
	_g_free0 (clean_address);
	_g_free0 (clean_name);
	return result;
}

/**
     * Returns a human-readable version of the address part.
     *
     * @param open optional string to use as the opening bracket,
     * defaults to //<//
     * @param close optional string to use as the closing bracket,
     * defaults to //>//
     * @return the {@link address} part, cleaned and enclosed within the
     * specified brackets.
     */
gchar*
geary_rf_c822_mailbox_address_to_address_display (GearyRFC822MailboxAddress* self,
                                                  const gchar* open,
                                                  const gchar* close)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	g_return_val_if_fail (open != NULL, NULL);
	g_return_val_if_fail (close != NULL, NULL);
	_tmp0_ = self->priv->_address;
	_tmp1_ = geary_string_reduce_whitespace (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (open, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, close, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

/**
     * Returns true if the email syntax is valid.
     */
gboolean
geary_rf_c822_mailbox_address_is_valid (GearyRFC822MailboxAddress* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), FALSE);
	_tmp0_ = self->priv->_address;
	result = geary_rf_c822_mailbox_address_is_valid_address (_tmp0_);
	return result;
}

/**
     * Determines if the mailbox address appears to have been spoofed.
     *
     * Using recipient and sender mailbox addresses where the name
     * part is also actually a valid RFC822 address
     * (e.g. "you@example.com <jerk@spammer.com>") is a common tactic
     * used by spammers and malware authors to exploit MUAs that will
     * display the name part only if present. It also enables more
     * sophisticated attacks such as
     * [[https://www.mailsploit.com/|Mailsploit]], which uses
     * Quoted-Printable or Base64 encoded nulls, new lines, @'s and
     * other characters to further trick MUAs into displaying a bogus
     * address.
     *
     * This method attempts to detect such attacks by examining the
     * {@link name} for non-printing characters and determining if it
     * is by itself also a valid RFC822 address.
     *
     * @return //true// if the complete decoded address contains any
     * non-printing characters, if the name part is also a valid
     * RFC822 address, or if the address part is not a valid RFC822
     * address.
     */
gboolean
geary_rf_c822_mailbox_address_is_spoofed (GearyRFC822MailboxAddress* self)
{
	static const char CONTROLS[] = "[[:cntrl:]]+";
	gboolean is_spoof = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), FALSE);
	is_spoof = FALSE;
	_tmp0_ = self->priv->_name;
	if (!geary_string_is_empty (_tmp0_)) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		if (g_regex_match_simple (CONTROLS, _tmp1_, 0, 0)) {
			is_spoof = TRUE;
		} else {
			if (geary_rf_c822_mailbox_address_has_distinct_name (self)) {
				gchar* clean_name = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp2_ = self->priv->_name;
				_tmp3_ = geary_string_reduce_whitespace (_tmp2_);
				clean_name = _tmp3_;
				_tmp4_ = clean_name;
				_tmp5_ = string_replace (_tmp4_, " ", "");
				_g_free0 (clean_name);
				clean_name = _tmp5_;
				_tmp6_ = clean_name;
				if (geary_rf_c822_mailbox_address_is_valid_address (_tmp6_)) {
					is_spoof = TRUE;
				}
				_g_free0 (clean_name);
			}
		}
	}
	if (!is_spoof) {
		const gchar* _tmp8_;
		_tmp8_ = self->priv->_mailbox;
		_tmp7_ = string_contains (_tmp8_, "@");
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		is_spoof = TRUE;
	}
	if (!is_spoof) {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->_address;
		_tmp9_ = g_regex_match_simple (GEARY_STRING_WS_OR_NP, _tmp10_, 0, 0);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		is_spoof = TRUE;
	}
	result = is_spoof;
	return result;
}

/**
     * Determines if the name part is different to the address part.
     *
     * @return //true// if {@link name} is not empty, and the
     * normalised {@link address} part is not equal to the name part
     * when performing a case-insensitive comparison.
     */
gboolean
geary_rf_c822_mailbox_address_has_distinct_name (GearyRFC822MailboxAddress* self)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean ret = FALSE;
	const gchar* _tmp18_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), FALSE);
	_tmp0_ = self->priv->_name;
	_tmp1_ = geary_string_reduce_whitespace (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	if (!geary_string_is_empty (_tmp2_)) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = name;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ >= 2) {
			const gchar* _tmp8_;
			_tmp8_ = name;
			_tmp4_ = string_get (_tmp8_, (glong) 0) == '\'';
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp9_ = name;
			_tmp10_ = name;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp3_ = string_get (_tmp9_, (glong) (_tmp12_ - 1)) == '\'';
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = name;
			_tmp14_ = name;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp13_, (glong) 1, (glong) (_tmp16_ - 2));
			_g_free0 (name);
			name = _tmp17_;
		}
	}
	ret = FALSE;
	_tmp18_ = name;
	if (!geary_string_is_empty (_tmp18_)) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* address = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp19_ = name;
		_tmp20_ = g_utf8_normalize (_tmp19_, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_utf8_casefold (_tmp21_, (gssize) -1);
		_g_free0 (name);
		name = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp23_ = self->priv->_address;
		_tmp24_ = g_utf8_normalize (_tmp23_, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_utf8_casefold (_tmp25_, (gssize) -1);
		_tmp27_ = _tmp26_;
		_tmp28_ = geary_string_reduce_whitespace (_tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		address = _tmp29_;
		_tmp30_ = name;
		_tmp31_ = address;
		ret = g_strcmp0 (_tmp30_, _tmp31_) != 0;
		_g_free0 (address);
	}
	result = ret;
	_g_free0 (name);
	return result;
}

/**
     * Returns the complete mailbox address, armoured for RFC 822 use.
     *
     * This method is similar to {@link to_full_display}, but only
     * checks for a distinct address (per Postel's Law) and not for
     * any spoofing, and does not strip extra white space or
     * non-printing characters.
     *
     * @return the RFC822 encoded form of the full address.
     */
static void
_vala_GMimeFormatOptions_free (GMimeFormatOptions* self)
{
	g_boxed_free (g_mime_format_options_get_type (), self);
}

static gchar*
geary_rf_c822_mailbox_address_real_to_rfc822_string (GearyRFC822DecodedMessageData* base)
{
	GearyRFC822MailboxAddress * self;
	gchar* _tmp0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	if (geary_rf_c822_mailbox_address_has_distinct_name (self)) {
		GMimeFormatOptions* _tmp1_;
		GMimeFormatOptions* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = geary_rf_c822_get_format_options ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_name;
		_tmp4_ = g_mime_utils_header_encode_phrase (_tmp2_, _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_rf_c822_mailbox_address_to_rfc822_address (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s <%s>", _tmp5_, _tmp7_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		__vala_GMimeFormatOptions_free0 (_tmp2_);
	} else {
		gchar* _tmp9_;
		_tmp9_ = geary_rf_c822_mailbox_address_to_rfc822_address (self);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp9_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the address part only, armoured for RFC 822 use.
     *
     * @return the RFC822 encoded form of the address, without angle
     * brackets.
     */
gchar*
geary_rf_c822_mailbox_address_to_rfc822_address (GearyRFC822MailboxAddress* self)
{
	gchar* address = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	const gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), NULL);
	_tmp0_ = g_strdup ("");
	address = _tmp0_;
	_tmp1_ = self->priv->_mailbox;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->_mailbox;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (address);
		address = _tmp3_;
		_tmp4_ = address;
		if (geary_rf_c822_mailbox_address_local_part_needs_quoting (_tmp4_)) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = address;
			_tmp6_ = geary_rf_c822_mailbox_address_quote_string (_tmp5_);
			_g_free0 (address);
			address = _tmp6_;
		}
	}
	_tmp7_ = self->priv->_domain;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = address;
		_tmp9_ = self->priv->_domain;
		_tmp10_ = g_strdup_printf ("%s@%s", _tmp8_, _tmp9_);
		_g_free0 (address);
		address = _tmp10_;
	}
	_tmp11_ = address;
	if (g_strcmp0 (_tmp11_, "") == 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->_address;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (address);
		address = _tmp13_;
		_tmp14_ = address;
		if (geary_rf_c822_mailbox_address_local_part_needs_quoting (_tmp14_)) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = address;
			_tmp16_ = geary_rf_c822_mailbox_address_quote_string (_tmp15_);
			_g_free0 (address);
			address = _tmp16_;
		}
	}
	result = address;
	return result;
}

/**
     * See Geary.MessageData.SearchableMessageData.
     */
static gchar*
geary_rf_c822_mailbox_address_real_to_searchable_string (GearyMessageDataSearchableMessageData* base)
{
	GearyRFC822MailboxAddress * self;
	gchar* _tmp0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	if (geary_rf_c822_mailbox_address_has_distinct_name (self)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_name;
		_tmp2_ = self->priv->_address;
		_tmp3_ = g_strdup_printf ("%s <%s>", _tmp1_, _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_address;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static guint
geary_rf_c822_mailbox_address_real_hash (GeeHashable* base)
{
	GearyRFC822MailboxAddress * self;
	const gchar* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	_tmp0_ = self->priv->_address;
	result = geary_string_stri_hash (_tmp0_);
	return result;
}

/**
     * Determines if this mailbox is equal to another by address.
     *
     * Equality is defined as case-insensitive comparison of the
     * {@link address} of both mailboxes.
     */
static gboolean
geary_rf_c822_mailbox_address_real_equal_to (GeeHashable* base,
                                             GearyRFC822MailboxAddress* other)
{
	GearyRFC822MailboxAddress * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (other), FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_address;
		_tmp2_ = other->priv->_address;
		_tmp0_ = geary_string_stri_equal (_tmp1_, _tmp2_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Determines if this mailbox is equal to another by address.
     *
     * This is suitable for determining equality for weaker cases such
     * as user searches. Here equality is defined as case-insensitive
     * comparison of the normalised, case-folded {@link address} and
     * the same for the given string.
     */
gboolean
geary_rf_c822_mailbox_address_equal_normalized (GearyRFC822MailboxAddress* self,
                                                const gchar* address)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (self), FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->_address;
	_tmp1_ = g_utf8_normalize (_tmp0_, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_normalize (address, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) == 0;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

/**
     * Returns the RFC822 formatted version of the address.
     *
     * @see to_rfc822_string
     */
static gchar*
geary_rf_c822_mailbox_address_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyRFC822MailboxAddress * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	_tmp0_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_mailbox_address_class_init (GearyRFC822MailboxAddressClass * klass,
                                          gpointer klass_data)
{
	gunichar* _tmp0_;
	geary_rf_c822_mailbox_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822MailboxAddress_private_offset);
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_rf_c822_mailbox_address_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_mailbox_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_rf_c822_mailbox_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_mailbox_address_finalize;
	/**
	     * The optional human-readable part of the mailbox address.
	     *
	     * For "Dirk Gently <dirk@example.com>", this would be "Dirk Gently".
	     *
	     * The returned value has been unquoted and decoded into UTF-8.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The routing of the message (optional, obsolete).
	     *
	     * The returned value has been decoded into UTF-8.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY] = g_param_spec_string ("source-route", "source-route", "source-route", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The mailbox (local-part) portion of the mailbox's address.
	     *
	     * For "Dirk Gently <dirk@example.com>", this would be "dirk".
	     *
	     * The returned value has been decoded into UTF-8.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY] = g_param_spec_string ("mailbox", "mailbox", "mailbox", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The domain portion of the mailbox's address.
	     *
	     * For "Dirk Gently <dirk@example.com>", this would be "example.com".
	     *
	     * The returned value has been decoded into UTF-8.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY] = g_param_spec_string ("domain", "domain", "domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The complete address part of the mailbox address.
	     *
	     * For "Dirk Gently <dirk@example.com>", this would be "dirk@example.com".
	     *
	     * The returned value has been decoded into UTF-8.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY, geary_rf_c822_mailbox_address_properties[GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY] = g_param_spec_string ("address", "address", "address", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_new0 (gunichar, 19);
	_tmp0_[0] = (gunichar) '!';
	_tmp0_[1] = (gunichar) '#';
	_tmp0_[2] = (gunichar) '$';
	_tmp0_[3] = (gunichar) '%';
	_tmp0_[4] = (gunichar) '&';
	_tmp0_[5] = (gunichar) '\'';
	_tmp0_[6] = (gunichar) '*';
	_tmp0_[7] = (gunichar) '+';
	_tmp0_[8] = (gunichar) '-';
	_tmp0_[9] = (gunichar) '/';
	_tmp0_[10] = (gunichar) '=';
	_tmp0_[11] = (gunichar) '?';
	_tmp0_[12] = (gunichar) '^';
	_tmp0_[13] = (gunichar) '_';
	_tmp0_[14] = (gunichar) '`';
	_tmp0_[15] = (gunichar) '{';
	_tmp0_[16] = (gunichar) '|';
	_tmp0_[17] = (gunichar) '}';
	_tmp0_[18] = (gunichar) '~';
	geary_rf_c822_mailbox_address_ATEXT = _tmp0_;
	geary_rf_c822_mailbox_address_ATEXT_length1 = 19;
}

static void
geary_rf_c822_mailbox_address_geary_message_data_searchable_message_data_interface_init (GearyMessageDataSearchableMessageDataIface * iface,
                                                                                         gpointer iface_data)
{
	geary_rf_c822_mailbox_address_geary_message_data_searchable_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_searchable_string = (gchar* (*) (GearyMessageDataSearchableMessageData*)) geary_rf_c822_mailbox_address_real_to_searchable_string;
}

static void
geary_rf_c822_mailbox_address_gee_hashable_interface_init (GeeHashableIface * iface,
                                                           gpointer iface_data)
{
	geary_rf_c822_mailbox_address_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->hash = (guint (*) (GeeHashable*)) geary_rf_c822_mailbox_address_real_hash;
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_rf_c822_mailbox_address_real_equal_to;
}

static void
geary_rf_c822_mailbox_address_geary_rf_c822_decoded_message_data_interface_init (GearyRFC822DecodedMessageDataIface * iface,
                                                                                 gpointer iface_data)
{
	geary_rf_c822_mailbox_address_geary_rf_c822_decoded_message_data_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_rfc822_string = (gchar* (*) (GearyRFC822DecodedMessageData*)) geary_rf_c822_mailbox_address_real_to_rfc822_string;
}

static void
geary_rf_c822_mailbox_address_instance_init (GearyRFC822MailboxAddress * self,
                                             gpointer klass)
{
	self->priv = geary_rf_c822_mailbox_address_get_instance_private (self);
}

static void
geary_rf_c822_mailbox_address_finalize (GObject * obj)
{
	GearyRFC822MailboxAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_source_route);
	_g_free0 (self->priv->_mailbox);
	_g_free0 (self->priv->_domain);
	_g_free0 (self->priv->_address);
	G_OBJECT_CLASS (geary_rf_c822_mailbox_address_parent_class)->finalize (obj);
}

/**
 * An immutable representation of an RFC 822 mailbox address.
 *
 * The properties of this class such as {@link name} and {@link
 * address} are stores decoded UTF-8, thus they must be re-encoded
 * using methods such as {@link to_rfc822_string} before being re-used
 * in a message envelope.
 *
 * See [[https://tools.ietf.org/html/rfc5322#section-3.4]]
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_mailbox_address_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822MailboxAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_mailbox_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822MailboxAddress), 0, (GInstanceInitFunc) geary_rf_c822_mailbox_address_instance_init, NULL };
	static const GInterfaceInfo geary_message_data_searchable_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_address_geary_message_data_searchable_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_address_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_rf_c822_decoded_message_data_info = { (GInterfaceInitFunc) geary_rf_c822_mailbox_address_geary_rf_c822_decoded_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_mailbox_address_type_id;
	geary_rf_c822_mailbox_address_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyRFC822MailboxAddress", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_mailbox_address_type_id, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, &geary_message_data_searchable_message_data_info);
	g_type_add_interface_static (geary_rf_c822_mailbox_address_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	g_type_add_interface_static (geary_rf_c822_mailbox_address_type_id, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, &geary_rf_c822_decoded_message_data_info);
	GearyRFC822MailboxAddress_private_offset = g_type_add_instance_private (geary_rf_c822_mailbox_address_type_id, sizeof (GearyRFC822MailboxAddressPrivate));
	return geary_rf_c822_mailbox_address_type_id;
}

GType
geary_rf_c822_mailbox_address_get_type (void)
{
	static gsize geary_rf_c822_mailbox_address_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_mailbox_address_type_id__once)) {
		GType geary_rf_c822_mailbox_address_type_id;
		geary_rf_c822_mailbox_address_type_id = geary_rf_c822_mailbox_address_get_type_once ();
		g_once_init_leave (&geary_rf_c822_mailbox_address_type_id__once, geary_rf_c822_mailbox_address_type_id);
	}
	return geary_rf_c822_mailbox_address_type_id__once;
}

static void
_vala_geary_rf_c822_mailbox_address_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyRFC822MailboxAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	switch (property_id) {
		case GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY:
		g_value_set_string (value, geary_rf_c822_mailbox_address_get_name (self));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY:
		g_value_set_string (value, geary_rf_c822_mailbox_address_get_source_route (self));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY:
		g_value_set_string (value, geary_rf_c822_mailbox_address_get_mailbox (self));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY:
		g_value_set_string (value, geary_rf_c822_mailbox_address_get_domain (self));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY:
		g_value_set_string (value, geary_rf_c822_mailbox_address_get_address (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_rf_c822_mailbox_address_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GearyRFC822MailboxAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, GearyRFC822MailboxAddress);
	switch (property_id) {
		case GEARY_RF_C822_MAILBOX_ADDRESS_NAME_PROPERTY:
		geary_rf_c822_mailbox_address_set_name (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_SOURCE_ROUTE_PROPERTY:
		geary_rf_c822_mailbox_address_set_source_route (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_MAILBOX_PROPERTY:
		geary_rf_c822_mailbox_address_set_mailbox (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_DOMAIN_PROPERTY:
		geary_rf_c822_mailbox_address_set_domain (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_MAILBOX_ADDRESS_ADDRESS_PROPERTY:
		geary_rf_c822_mailbox_address_set_address (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

