/* util-stream.c generated by valac 0.56.3, the Vala compiler
 * generated from util-stream.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <gio/gio.h>
#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gmime/gmime.h>
#include <glib-object.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _GearyStreamWriteAllAsyncData GearyStreamWriteAllAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyStreamWriteStringAsyncData GearyStreamWriteStringAsyncData;
enum  {
	GEARY_STREAM_MIME_OUTPUT_STREAM_0_PROPERTY,
	GEARY_STREAM_MIME_OUTPUT_STREAM_NUM_PROPERTIES
};
static GParamSpec* geary_stream_mime_output_stream_properties[GEARY_STREAM_MIME_OUTPUT_STREAM_NUM_PROPERTIES];

struct _GearyStreamWriteAllAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GOutputStream* outs;
	GearyMemoryBuffer* buffer;
	GCancellable* cancellable;
	gsize _tmp0_;
	gsize _tmp1_;
	GBytes* bytes;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GearyMemoryUnownedBytesBuffer* unowned_bytes;
	GearyMemoryUnownedBytesBuffer* _tmp2_;
	GearyMemoryUnownedBytesBuffer* _tmp3_;
	GearyMemoryUnownedBytesBuffer* _tmp4_;
	gint _tmp5_;
	guint8* _tmp6_;
	GBytes* _tmp7_;
	GBytes* _tmp8_;
	gsize _tmp9_;
	guint8* _tmp10_;
	gssize offset;
	gboolean _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gssize _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_;
};

struct _GearyStreamWriteStringAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GOutputStream* outs;
	gchar* str;
	GCancellable* cancellable;
	GearyMemoryStringBuffer* _tmp0_;
	GearyMemoryStringBuffer* _tmp1_;
	GError* _inner_error0_;
};

struct _GearyStreamMimeOutputStreamPrivate {
	GOutputStream* dest;
	gint64 written;
};

static gint GearyStreamMimeOutputStream_private_offset;
static gpointer geary_stream_mime_output_stream_parent_class = NULL;

static void geary_stream_write_all_async_data_free (gpointer _data);
static gboolean geary_stream_write_all_async_co (GearyStreamWriteAllAsyncData* _data_);
static void geary_stream_write_all_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void geary_stream_write_string_async_data_free (gpointer _data);
static gboolean geary_stream_write_string_async_co (GearyStreamWriteStringAsyncData* _data_);
static void geary_stream_write_string_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gint64 geary_stream_mime_output_stream_real_length (GMimeStream* base);
static gssize geary_stream_mime_output_stream_real_write (GMimeStream* base,
                                                   guint8* buf,
                                                   gsize buf_length1);
static gint geary_stream_mime_output_stream_real_close (GMimeStream* base);
static gint geary_stream_mime_output_stream_real_flush (GMimeStream* base);
static gboolean geary_stream_mime_output_stream_real_eos (GMimeStream* base);
static void geary_stream_mime_output_stream_finalize (GObject * obj);
static GType geary_stream_mime_output_stream_get_type_once (void);

static void
geary_stream_write_all_async_data_free (gpointer _data)
{
	GearyStreamWriteAllAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->outs);
	_g_object_unref0 (_data_->buffer);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyStreamWriteAllAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_stream_write_all_async (GOutputStream* outs,
                              GearyMemoryBuffer* buffer,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyStreamWriteAllAsyncData* _data_;
	GOutputStream* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (outs, g_output_stream_get_type ()));
	g_return_if_fail (GEARY_MEMORY_IS_BUFFER (buffer));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyStreamWriteAllAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_stream_write_all_async_data_free);
	_tmp0_ = _g_object_ref0 (outs);
	_g_object_unref0 (_data_->outs);
	_data_->outs = _tmp0_;
	_tmp1_ = _g_object_ref0 (buffer);
	_g_object_unref0 (_data_->buffer);
	_data_->buffer = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_stream_write_all_async_co (_data_);
}

void
geary_stream_write_all_finish (GAsyncResult* _res_,
                               GError** error)
{
	GearyStreamWriteAllAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Provides an asynchronous version of OutputStream.write_all().
     */
static void
geary_stream_write_all_async_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GearyStreamWriteAllAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_stream_write_all_async_co (_data_);
}

static gboolean
geary_stream_write_all_async_co (GearyStreamWriteAllAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_memory_buffer_get_size (_data_->buffer);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == ((gsize) 0)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->bytes = NULL;
	_data_->data_length1 = 0;
	_data_->_data_size_ = 0;
	_data_->_tmp2_ = _g_object_ref0 (GEARY_MEMORY_IS_UNOWNED_BYTES_BUFFER (_data_->buffer) ? ((GearyMemoryUnownedBytesBuffer*) _data_->buffer) : NULL);
	_data_->unowned_bytes = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->unowned_bytes;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->unowned_bytes;
		_data_->_tmp5_ = 0;
		_data_->_tmp6_ = geary_memory_unowned_bytes_buffer_to_unowned_uint8_array (_data_->_tmp4_, &_data_->_tmp5_);
		_data_->data = _data_->_tmp6_;
		_data_->data_length1 = _data_->_tmp5_;
		_data_->_data_size_ = _data_->data_length1;
	} else {
		_data_->_tmp7_ = geary_memory_buffer_get_bytes (_data_->buffer);
		_g_bytes_unref0 (_data_->bytes);
		_data_->bytes = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->bytes;
		_data_->_tmp9_ = 0;
		_data_->_tmp10_ = g_bytes_get_data (_data_->_tmp8_, &_data_->_tmp9_);
		_data_->data = _data_->_tmp10_;
		_data_->data_length1 = _data_->_tmp9_;
		_data_->_data_size_ = _data_->data_length1;
	}
	_data_->offset = (gssize) 0;
	{
		_data_->_tmp11_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp11_) {
				_data_->_tmp12_ = _data_->data;
				_data_->_tmp12__length1 = _data_->data_length1;
				if (!(_data_->offset < ((gssize) _data_->_tmp12__length1))) {
					break;
				}
			}
			_data_->_tmp11_ = FALSE;
			_data_->_tmp14_ = _data_->data;
			_data_->_tmp14__length1 = _data_->data_length1;
			_data_->_tmp15_ = _data_->data;
			_data_->_tmp15__length1 = _data_->data_length1;
			_data_->_state_ = 1;
			g_output_stream_write_async (_data_->outs, _data_->_tmp14_ + ((gint) _data_->offset), (gsize) (_data_->_tmp15__length1 - ((gint) _data_->offset)), G_PRIORITY_DEFAULT, _data_->cancellable, geary_stream_write_all_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp13_ = g_output_stream_write_finish (_data_->outs, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->unowned_bytes);
				_g_bytes_unref0 (_data_->bytes);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->offset += _data_->_tmp13_;
		}
	}
	_g_object_unref0 (_data_->unowned_bytes);
	_g_bytes_unref0 (_data_->bytes);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_stream_write_string_async_data_free (gpointer _data)
{
	GearyStreamWriteStringAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->outs);
	_g_free0 (_data_->str);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyStreamWriteStringAsyncData, _data_);
}

void
geary_stream_write_string_async (GOutputStream* outs,
                                 const gchar* str,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GearyStreamWriteStringAsyncData* _data_;
	GOutputStream* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (outs, g_output_stream_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyStreamWriteStringAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_stream_write_string_async_data_free);
	_tmp0_ = _g_object_ref0 (outs);
	_g_object_unref0 (_data_->outs);
	_data_->outs = _tmp0_;
	_tmp1_ = g_strdup (str);
	_g_free0 (_data_->str);
	_data_->str = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_stream_write_string_async_co (_data_);
}

void
geary_stream_write_string_finish (GAsyncResult* _res_,
                                  GError** error)
{
	GearyStreamWriteStringAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Asynchronously writes the entire string to the OutputStream.
     */
static void
geary_stream_write_string_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GearyStreamWriteStringAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_stream_write_string_async_co (_data_);
}

static gboolean
geary_stream_write_string_async_co (GearyStreamWriteStringAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!geary_string_is_empty (_data_->str)) {
		_data_->_tmp0_ = geary_memory_string_buffer_new (_data_->str);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_state_ = 1;
		geary_stream_write_all_async (_data_->outs, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer), _data_->cancellable, geary_stream_write_string_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_stream_write_all_finish (_data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline gpointer
geary_stream_mime_output_stream_get_instance_private (GearyStreamMimeOutputStream* self)
{
	return G_STRUCT_MEMBER_P (self, GearyStreamMimeOutputStream_private_offset);
}

GearyStreamMimeOutputStream*
geary_stream_mime_output_stream_construct (GType object_type,
                                           GOutputStream* dest)
{
	GearyStreamMimeOutputStream * self = NULL;
	GOutputStream* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest, g_output_stream_get_type ()), NULL);
	self = (GearyStreamMimeOutputStream*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (dest);
	_g_object_unref0 (self->priv->dest);
	self->priv->dest = _tmp0_;
	return self;
}

GearyStreamMimeOutputStream*
geary_stream_mime_output_stream_new (GOutputStream* dest)
{
	return geary_stream_mime_output_stream_construct (GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, dest);
}

static gint64
geary_stream_mime_output_stream_real_length (GMimeStream* base)
{
	GearyStreamMimeOutputStream * self;
	gint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	result = self->priv->written;
	return result;
}

static gssize
geary_stream_mime_output_stream_real_write (GMimeStream* base,
                                            guint8* buf,
                                            gsize buf_length1)
{
	GearyStreamMimeOutputStream * self;
	gssize _tmp2_ = -1L;
	GError* _inner_error0_ = NULL;
	gssize result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	{
		gssize ret = 0L;
		GOutputStream* _tmp0_;
		_tmp0_ = self->priv->dest;
		ret = g_output_stream_write (_tmp0_, buf, (gsize) buf_length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gssize _tmp1_ = -1L;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		if (ret > ((gssize) 0)) {
			self->priv->written = self->priv->written + ret;
		}
		result = ret;
		return result;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = (gssize) -1;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

static gint
geary_stream_mime_output_stream_real_close (GMimeStream* base)
{
	GearyStreamMimeOutputStream * self;
	gint ret = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	ret = -1;
	{
		gint _tmp0_ = 0;
		gboolean _tmp1_ = FALSE;
		GOutputStream* _tmp2_;
		_tmp2_ = self->priv->dest;
		_tmp1_ = g_output_stream_close (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		if (_tmp1_) {
			_tmp0_ = 0;
		} else {
			_tmp0_ = -1;
		}
		ret = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp4_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = ret;
	return result;
}

static gint
geary_stream_mime_output_stream_real_flush (GMimeStream* base)
{
	GearyStreamMimeOutputStream * self;
	gint ret = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	ret = -1;
	{
		gint _tmp0_ = 0;
		gboolean _tmp1_ = FALSE;
		GOutputStream* _tmp2_;
		_tmp2_ = self->priv->dest;
		_tmp1_ = g_output_stream_flush (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp1_) {
			_tmp0_ = 0;
		} else {
			_tmp0_ = -1;
		}
		ret = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp3_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = ret;
	return result;
}

static gboolean
geary_stream_mime_output_stream_real_eos (GMimeStream* base)
{
	GearyStreamMimeOutputStream * self;
	gboolean _tmp0_ = FALSE;
	GOutputStream* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	_tmp1_ = self->priv->dest;
	if (g_output_stream_is_closed (_tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		GOutputStream* _tmp2_;
		_tmp2_ = self->priv->dest;
		_tmp0_ = g_output_stream_is_closing (_tmp2_);
	}
	result = _tmp0_;
	return result;
}

static void
geary_stream_mime_output_stream_class_init (GearyStreamMimeOutputStreamClass * klass,
                                            gpointer klass_data)
{
	geary_stream_mime_output_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyStreamMimeOutputStream_private_offset);
	((GMimeStreamClass *) klass)->length = (gint64 (*) (GMimeStream*)) geary_stream_mime_output_stream_real_length;
	((GMimeStreamClass *) klass)->write = (gssize (*) (GMimeStream*, guint8*, gsize)) geary_stream_mime_output_stream_real_write;
	((GMimeStreamClass *) klass)->close = (gint (*) (GMimeStream*)) geary_stream_mime_output_stream_real_close;
	((GMimeStreamClass *) klass)->flush = (gint (*) (GMimeStream*)) geary_stream_mime_output_stream_real_flush;
	((GMimeStreamClass *) klass)->eos = (gboolean (*) (GMimeStream*)) geary_stream_mime_output_stream_real_eos;
	G_OBJECT_CLASS (klass)->finalize = geary_stream_mime_output_stream_finalize;
}

static void
geary_stream_mime_output_stream_instance_init (GearyStreamMimeOutputStream * self,
                                               gpointer klass)
{
	self->priv = geary_stream_mime_output_stream_get_instance_private (self);
	self->priv->written = (gint64) 0;
}

static void
geary_stream_mime_output_stream_finalize (GObject * obj)
{
	GearyStreamMimeOutputStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_STREAM_TYPE_MIME_OUTPUT_STREAM, GearyStreamMimeOutputStream);
	_g_object_unref0 (self->priv->dest);
	G_OBJECT_CLASS (geary_stream_mime_output_stream_parent_class)->finalize (obj);
}

/**
     * Adaptor from a GMime stream to a GLib OutputStream.
     */
 G_GNUC_NO_INLINE static GType
geary_stream_mime_output_stream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyStreamMimeOutputStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_stream_mime_output_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyStreamMimeOutputStream), 0, (GInstanceInitFunc) geary_stream_mime_output_stream_instance_init, NULL };
	GType geary_stream_mime_output_stream_type_id;
	geary_stream_mime_output_stream_type_id = g_type_register_static (g_mime_stream_get_type (), "GearyStreamMimeOutputStream", &g_define_type_info, 0);
	GearyStreamMimeOutputStream_private_offset = g_type_add_instance_private (geary_stream_mime_output_stream_type_id, sizeof (GearyStreamMimeOutputStreamPrivate));
	return geary_stream_mime_output_stream_type_id;
}

GType
geary_stream_mime_output_stream_get_type (void)
{
	static gsize geary_stream_mime_output_stream_type_id__once = 0;
	if (g_once_init_enter (&geary_stream_mime_output_stream_type_id__once)) {
		GType geary_stream_mime_output_stream_type_id;
		geary_stream_mime_output_stream_type_id = geary_stream_mime_output_stream_get_type_once ();
		g_once_init_leave (&geary_stream_mime_output_stream_type_id__once, geary_stream_mime_output_stream_type_id);
	}
	return geary_stream_mime_output_stream_type_id__once;
}

