/* web-process-extension.c generated by valac 0.56.3, the Vala compiler
 * generated from web-process-extension.vala, do not modify */

/*
 * Copyright © 2016-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-web-process.h"
#include <webkit2/webkit-web-extension.h>
#include <glib.h>
#include "geary-engine.h"
#include <stdio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <jsc/jsc.h>

#define GEARY_WEB_EXTENSION_PAGE_STATE_OBJECT_NAME "geary"
#define GEARY_WEB_EXTENSION_MESSAGE_EXCEPTION "__exception__"
#define GEARY_WEB_EXTENSION_MESSAGE_ENABLE_REMOTE_LOAD "__enable_remote_load__"
#define GEARY_WEB_EXTENSION_MESSAGE_RETURN_VALUE "__return__"
#define GEARY_WEB_EXTENSION_EXTENSION_CLASS_VAR "_GearyWebExtension"
#define GEARY_WEB_EXTENSION_EXTENSION_CLASS_SEND "send"
#define GEARY_WEB_EXTENSION_EXTENSION_CLASS_ALLOW_REMOTE_LOAD "allowRemoteResourceLoad"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GEARY_WEB_EXTENSION_0_PROPERTY,
	GEARY_WEB_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* geary_web_extension_properties[GEARY_WEB_EXTENSION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _GearyWebExtensionPrivate {
	WebKitWebExtension* extension;
};

struct _Block1Data {
	int _ref_count_;
	GearyWebExtension* self;
	WebKitWebPage* page;
};

static gint GearyWebExtension_private_offset;
static gpointer geary_web_extension_parent_class = NULL;

static GLogWriterOutput _geary_logging_default_log_writer_glog_writer_func (GLogLevelFlags log_level,
                                                                     GLogField* fields,
                                                                     gsize fields_length1,
                                                                     gpointer self);
static void geary_web_extension_on_page_created (GearyWebExtension* self,
                                          WebKitWebExtension* extension,
                                          WebKitWebPage* page);
static void _geary_web_extension_on_page_created_webkit_web_extension_page_created (WebKitWebExtension* _sender,
                                                                             WebKitWebPage* web_page,
                                                                             gpointer self);
static void geary_web_extension_on_window_object_cleared (GearyWebExtension* self,
                                                   WebKitScriptWorld* world,
                                                   WebKitWebPage* page,
                                                   WebKitFrame* frame);
static void _geary_web_extension_on_window_object_cleared_webkit_script_world_window_object_cleared (WebKitScriptWorld* _sender,
                                                                                              WebKitWebPage* page,
                                                                                              WebKitFrame* frame,
                                                                                              gpointer self);
static void geary_web_extension_on_console_message (GearyWebExtension* self,
                                             WebKitWebPage* page,
                                             WebKitConsoleMessage* message);
static gboolean geary_web_extension_on_send_request (GearyWebExtension* self,
                                              WebKitWebPage* page,
                                              WebKitURIRequest* request,
                                              WebKitURIResponse* response);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static gboolean geary_web_extension_should_load_remote_resources (GearyWebExtension* self,
                                                           WebKitWebPage* page);
static WebKitUserMessage* geary_web_extension_to_exception_message (GearyWebExtension* self,
                                                             const gchar* name,
                                                             const gchar* message,
                                                             const gchar* backtrace,
                                                             const gchar* source,
                                                             gint line_number,
                                                             gint column_number);
static void _geary_web_extension_on_console_message_webkit_web_page_console_message_sent (WebKitWebPage* _sender,
                                                                                   WebKitConsoleMessage* console_message,
                                                                                   gpointer self);
static gboolean _geary_web_extension_on_send_request_webkit_web_page_send_request (WebKitWebPage* _sender,
                                                                            WebKitURIRequest* request,
                                                                            WebKitURIResponse* redirected_response,
                                                                            gpointer self);
static gboolean geary_web_extension_on_page_message_received (GearyWebExtension* self,
                                                       WebKitWebPage* page,
                                                       WebKitUserMessage* message);
static gboolean _geary_web_extension_on_page_message_received_webkit_web_page_user_message_received (WebKitWebPage* _sender,
                                                                                              WebKitUserMessage* message,
                                                                                              gpointer self);
static gboolean geary_web_extension_on_page_send_message (GearyWebExtension* self,
                                                   WebKitWebPage* page,
                                                   GPtrArray* args);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gpointer __lambda4_ (Block1Data* _data1_,
                     JSCClass* instance,
                     GPtrArray* values);
static gpointer ___lambda4__gcallback (JSCClass* instance,
                                GPtrArray* values,
                                gpointer self);
static void geary_web_extension_finalize (GObject * obj);
static GType geary_web_extension_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* GEARY_WEB_EXTENSION_ALLOWED_SCHEMES[4] = {"cid", "geary", "data", "blob"};

/**
 * Initialises GearyWebExtension for WebKit web processes.
 */
static GLogWriterOutput
_geary_logging_default_log_writer_glog_writer_func (GLogLevelFlags log_level,
                                                    GLogField* fields,
                                                    gsize fields_length1,
                                                    gpointer self)
{
	GLogWriterOutput result;
	result = geary_logging_default_log_writer (log_level, fields, fields_length1);
	return result;
}

void
webkit_web_extension_initialize_with_user_data (WebKitWebExtension* extension,
                                                GVariant* data)
{
	gboolean logging_enabled = FALSE;
	GearyWebExtension* instance = NULL;
	GearyWebExtension* _tmp1_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (extension, webkit_web_extension_get_type ()));
	g_return_if_fail (data != NULL);
	logging_enabled = g_variant_get_boolean (data);
	geary_logging_init ();
	if (logging_enabled) {
		FILE* _tmp0_;
		g_log_set_writer_func (_geary_logging_default_log_writer_glog_writer_func, NULL, NULL);
		_tmp0_ = stdout;
		geary_logging_log_to (_tmp0_);
	}
	g_debug ("web-process-extension.vala:21: Initialising...");
	_tmp1_ = geary_web_extension_new (extension);
	instance = _tmp1_;
	g_object_ref (G_TYPE_CHECK_INSTANCE_CAST (instance, G_TYPE_OBJECT, GObject));
	_g_object_unref0 (instance);
}

static inline gpointer
geary_web_extension_get_instance_private (GearyWebExtension* self)
{
	return G_STRUCT_MEMBER_P (self, GearyWebExtension_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_geary_web_extension_on_page_created_webkit_web_extension_page_created (WebKitWebExtension* _sender,
                                                                        WebKitWebPage* web_page,
                                                                        gpointer self)
{
	geary_web_extension_on_page_created ((GearyWebExtension*) self, _sender, web_page);
}

static void
_geary_web_extension_on_window_object_cleared_webkit_script_world_window_object_cleared (WebKitScriptWorld* _sender,
                                                                                         WebKitWebPage* page,
                                                                                         WebKitFrame* frame,
                                                                                         gpointer self)
{
	geary_web_extension_on_window_object_cleared ((GearyWebExtension*) self, _sender, page, frame);
}

GearyWebExtension*
geary_web_extension_construct (GType object_type,
                               WebKitWebExtension* extension)
{
	GearyWebExtension * self = NULL;
	WebKitWebExtension* _tmp0_;
	WebKitScriptWorld* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (extension, webkit_web_extension_get_type ()), NULL);
	self = (GearyWebExtension*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (extension);
	_g_object_unref0 (self->priv->extension);
	self->priv->extension = _tmp0_;
	g_signal_connect_object (extension, "page-created", (GCallback) _geary_web_extension_on_page_created_webkit_web_extension_page_created, self, 0);
	_tmp1_ = webkit_script_world_get_default ();
	g_signal_connect_object (_tmp1_, "window-object-cleared", (GCallback) _geary_web_extension_on_window_object_cleared_webkit_script_world_window_object_cleared, self, 0);
	return self;
}

GearyWebExtension*
geary_web_extension_new (WebKitWebExtension* extension)
{
	return geary_web_extension_construct (TYPE_GEARY_WEB_EXTENSION, extension);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
geary_web_extension_on_console_message (GearyWebExtension* self,
                                        WebKitWebPage* page,
                                        WebKitConsoleMessage* message)
{
	gchar* source = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	GEnumValue* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GEnumValue* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (IS_GEARY_WEB_EXTENSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()));
	g_return_if_fail (message != NULL);
	_tmp0_ = webkit_console_message_get_source_id (message);
	_tmp1_ = g_strdup (_tmp0_);
	source = _tmp1_;
	_tmp3_ = source;
	if (geary_string_is_empty (_tmp3_)) {
		_tmp2_ = "unknown";
	} else {
		const gchar* _tmp4_;
		_tmp4_ = source;
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = g_enum_get_value (g_type_class_ref (webkit_console_message_level_get_type ()), webkit_console_message_get_level (message));
	_tmp6_ = strlen ("WEBKIT_CONSOLE_MESSAGE_LEVEL_");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring ((_tmp5_ != NULL) ? _tmp5_->value_name : NULL, (glong) _tmp7_, (glong) -1);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_enum_get_value (g_type_class_ref (webkit_console_message_source_get_type ()), webkit_console_message_get_source (message));
	_tmp11_ = strlen ("WEBKIT_CONSOLE_MESSAGE_SOURCE_");
	_tmp12_ = _tmp11_;
	_tmp13_ = string_substring ((_tmp10_ != NULL) ? _tmp10_->value_name : NULL, (glong) _tmp12_, (glong) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = webkit_console_message_get_text (message);
	g_debug ("web-process-extension.vala:58: Console: [%s] %s %s:%u: %s", _tmp9_, _tmp14_, _tmp2_, webkit_console_message_get_line (message), _tmp15_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp9_);
	_g_free0 (source);
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
geary_web_extension_on_send_request (GearyWebExtension* self,
                                     WebKitWebPage* page,
                                     WebKitURIRequest* request,
                                     WebKitURIResponse* response)
{
	gboolean should_load = FALSE;
	GUri* uri = NULL;
	gboolean _tmp8_ = FALSE;
	GUri* _tmp9_;
	gboolean _tmp14_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_GEARY_WEB_EXTENSION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (request, webkit_uri_request_get_type ()), FALSE);
	g_return_val_if_fail ((response == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (response, webkit_uri_response_get_type ()), FALSE);
	should_load = FALSE;
	uri = NULL;
	{
		GUri* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GUri* _tmp2_;
		GUri* _tmp4_;
		_tmp1_ = webkit_uri_request_get_uri (request);
		_tmp2_ = g_uri_parse (_tmp1_, G_URI_FLAGS_NONE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp3_ = FALSE;
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch0_g_uri_error;
			}
			_g_uri_unref0 (uri);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_uri_unref0 (uri);
		uri = _tmp4_;
		_g_uri_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_uri_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("web-process-extension.vala:75: Invalid request URI: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_uri_unref0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp9_ = uri;
	if (_tmp9_ != NULL) {
		GUri* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = uri;
		_tmp11_ = g_uri_get_scheme (_tmp10_);
		_tmp8_ = _vala_string_array_contains (GEARY_WEB_EXTENSION_ALLOWED_SCHEMES, G_N_ELEMENTS (GEARY_WEB_EXTENSION_ALLOWED_SCHEMES), _tmp11_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		should_load = TRUE;
	} else {
		if (geary_web_extension_should_load_remote_resources (self, page)) {
			should_load = TRUE;
		} else {
			WebKitUserMessage* _tmp12_;
			WebKitUserMessage* _tmp13_;
			_tmp12_ = webkit_user_message_new ("remote_resource_load_blocked", NULL);
			g_object_ref_sink (_tmp12_);
			_tmp13_ = _tmp12_;
			webkit_web_page_send_message_to_view (page, _tmp13_, NULL, NULL, NULL);
			_g_object_unref0 (_tmp13_);
		}
	}
	if (should_load) {
		_tmp14_ = GDK_EVENT_PROPAGATE;
	} else {
		_tmp14_ = GDK_EVENT_STOP;
	}
	result = _tmp14_;
	_g_uri_unref0 (uri);
	return result;
}

static gboolean
geary_web_extension_should_load_remote_resources (GearyWebExtension* self,
                                                  WebKitWebPage* page)
{
	gconstpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_GEARY_WEB_EXTENSION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()), FALSE);
	_tmp0_ = g_object_get_data (G_TYPE_CHECK_INSTANCE_CAST (page, G_TYPE_OBJECT, GObject), GEARY_WEB_EXTENSION_EXTENSION_CLASS_ALLOW_REMOTE_LOAD);
	result = ((const gchar*) _tmp0_) != NULL;
	return result;
}

static WebKitUserMessage*
geary_web_extension_to_exception_message (GearyWebExtension* self,
                                          const gchar* name,
                                          const gchar* message,
                                          const gchar* backtrace,
                                          const gchar* source,
                                          gint line_number,
                                          gint column_number)
{
	GVariantDict* detail = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	WebKitUserMessage* _tmp22_;
	WebKitUserMessage* _tmp23_;
	WebKitUserMessage* result;
	g_return_val_if_fail (IS_GEARY_WEB_EXTENSION (self), NULL);
	_tmp0_ = g_variant_dict_new (NULL);
	detail = _tmp0_;
	if (name != NULL) {
		GVariantDict* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		_tmp1_ = detail;
		_tmp2_ = g_variant_new_string (name);
		g_variant_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		g_variant_dict_insert_value (_tmp1_, "name", _tmp3_);
		_g_variant_unref0 (_tmp3_);
	}
	if (message != NULL) {
		GVariantDict* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp4_ = detail;
		_tmp5_ = g_variant_new_string (message);
		g_variant_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		g_variant_dict_insert_value (_tmp4_, "message", _tmp6_);
		_g_variant_unref0 (_tmp6_);
	}
	if (backtrace != NULL) {
		GVariantDict* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp7_ = detail;
		_tmp8_ = g_variant_new_string (backtrace);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_variant_dict_insert_value (_tmp7_, "backtrace", _tmp9_);
		_g_variant_unref0 (_tmp9_);
	}
	if (source != NULL) {
		GVariantDict* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp10_ = detail;
		_tmp11_ = g_variant_new_string (source);
		g_variant_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		g_variant_dict_insert_value (_tmp10_, "source", _tmp12_);
		_g_variant_unref0 (_tmp12_);
	}
	if (line_number > 0) {
		GVariantDict* _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		_tmp13_ = detail;
		_tmp14_ = g_variant_new_uint32 ((guint32) line_number);
		g_variant_ref_sink (_tmp14_);
		_tmp15_ = _tmp14_;
		g_variant_dict_insert_value (_tmp13_, "line_number", _tmp15_);
		_g_variant_unref0 (_tmp15_);
	}
	if (column_number > 0) {
		GVariantDict* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		_tmp16_ = detail;
		_tmp17_ = g_variant_new_uint32 ((guint32) column_number);
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		g_variant_dict_insert_value (_tmp16_, "column_number", _tmp18_);
		_g_variant_unref0 (_tmp18_);
	}
	_tmp19_ = detail;
	_tmp20_ = g_variant_dict_end (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	_tmp22_ = webkit_user_message_new (GEARY_WEB_EXTENSION_MESSAGE_EXCEPTION, _tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_variant_unref0 (_tmp21_);
	result = _tmp23_;
	_g_variant_dict_unref0 (detail);
	return result;
}

static void
_geary_web_extension_on_console_message_webkit_web_page_console_message_sent (WebKitWebPage* _sender,
                                                                              WebKitConsoleMessage* console_message,
                                                                              gpointer self)
{
	geary_web_extension_on_console_message ((GearyWebExtension*) self, _sender, console_message);
}

static gboolean
_geary_web_extension_on_send_request_webkit_web_page_send_request (WebKitWebPage* _sender,
                                                                   WebKitURIRequest* request,
                                                                   WebKitURIResponse* redirected_response,
                                                                   gpointer self)
{
	gboolean result;
	result = geary_web_extension_on_send_request ((GearyWebExtension*) self, _sender, request, redirected_response);
	return result;
}

static gboolean
_geary_web_extension_on_page_message_received_webkit_web_page_user_message_received (WebKitWebPage* _sender,
                                                                                     WebKitUserMessage* message,
                                                                                     gpointer self)
{
	gboolean result;
	result = geary_web_extension_on_page_message_received ((GearyWebExtension*) self, _sender, message);
	return result;
}

static void
geary_web_extension_on_page_created (GearyWebExtension* self,
                                     WebKitWebExtension* extension,
                                     WebKitWebPage* page)
{
	g_return_if_fail (IS_GEARY_WEB_EXTENSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (extension, webkit_web_extension_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()));
	g_signal_connect_object (page, "console-message-sent", (GCallback) _geary_web_extension_on_console_message_webkit_web_page_console_message_sent, self, 0);
	g_signal_connect_object (page, "send-request", (GCallback) _geary_web_extension_on_send_request_webkit_web_page_send_request, self, 0);
	g_signal_connect_object (page, "user-message-received", (GCallback) _geary_web_extension_on_page_message_received_webkit_web_page_user_message_received, self, 0);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
geary_web_extension_on_page_message_received (GearyWebExtension* self,
                                              WebKitWebPage* page,
                                              WebKitUserMessage* message)
{
	WebKitFrame* frame = NULL;
	WebKitFrame* _tmp0_;
	WebKitFrame* _tmp1_;
	JSCContext* context = NULL;
	WebKitFrame* _tmp2_;
	JSCContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_GEARY_WEB_EXTENSION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, webkit_user_message_get_type ()), FALSE);
	_tmp0_ = webkit_web_page_get_main_frame (page);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	frame = _tmp1_;
	_tmp2_ = frame;
	_tmp3_ = webkit_frame_get_js_context (_tmp2_);
	context = _tmp3_;
	{
		JSCValue** call_param = NULL;
		gint call_param_length1;
		gint _call_param_size_;
		GVariant* message_param = NULL;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		JSCValue* page_state = NULL;
		JSCContext* _tmp28_;
		JSCValue* _tmp29_;
		JSCValue* ret = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		JSCException* thrown = NULL;
		JSCContext* _tmp41_;
		JSCException* _tmp42_;
		JSCException* _tmp43_;
		JSCException* _tmp44_;
		call_param = NULL;
		call_param_length1 = 0;
		_call_param_size_ = call_param_length1;
		_tmp4_ = webkit_user_message_get_parameters (message);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_variant_ref0 (_tmp5_);
		message_param = _tmp6_;
		_tmp7_ = message_param;
		if (_tmp7_ != NULL) {
			GVariant* _tmp8_;
			_tmp8_ = message_param;
			if (g_variant_is_container (_tmp8_)) {
				gsize len = 0UL;
				GVariant* _tmp9_;
				JSCValue** _tmp10_;
				_tmp9_ = message_param;
				len = g_variant_n_children (_tmp9_);
				_tmp10_ = g_new0 (JSCValue*, len + 1);
				call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
				call_param = _tmp10_;
				call_param_length1 = len;
				_call_param_size_ = call_param_length1;
				{
					gsize i = 0UL;
					i = (gsize) 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							JSCValue* _tmp13_ = NULL;
							JSCContext* _tmp14_;
							GVariant* _tmp15_;
							GVariant* _tmp16_;
							GVariant* _tmp17_;
							JSCValue* _tmp18_;
							JSCValue* _tmp19_;
							JSCValue** _tmp20_;
							gint _tmp20__length1;
							JSCValue* _tmp21_;
							if (!_tmp11_) {
								gsize _tmp12_;
								_tmp12_ = i;
								i = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							if (!(i < len)) {
								break;
							}
							_tmp14_ = context;
							_tmp15_ = message_param;
							_tmp16_ = g_variant_get_child_value (_tmp15_, i);
							_tmp17_ = _tmp16_;
							_tmp18_ = util_js_variant_to_value (_tmp14_, _tmp17_, &_inner_error0_);
							_tmp19_ = _tmp18_;
							_g_variant_unref0 (_tmp17_);
							_tmp13_ = _tmp19_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_variant_unref0 (message_param);
								call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
								goto __catch0_g_error;
							}
							_tmp20_ = call_param;
							_tmp20__length1 = call_param_length1;
							_tmp21_ = _tmp13_;
							_tmp13_ = NULL;
							_g_object_unref0 (_tmp20_[i]);
							_tmp20_[i] = _tmp21_;
							_g_object_unref0 (_tmp13_);
						}
					}
				}
			} else {
				JSCValue* _tmp22_ = NULL;
				JSCContext* _tmp23_;
				GVariant* _tmp24_;
				JSCValue* _tmp25_;
				JSCValue* _tmp26_;
				JSCValue** _tmp27_;
				_tmp23_ = context;
				_tmp24_ = message_param;
				_tmp25_ = util_js_variant_to_value (_tmp23_, _tmp24_, &_inner_error0_);
				_tmp22_ = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_variant_unref0 (message_param);
					call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
					goto __catch0_g_error;
				}
				_tmp26_ = _tmp22_;
				_tmp22_ = NULL;
				_tmp27_ = g_new0 (JSCValue*, 1 + 1);
				_tmp27_[0] = _tmp26_;
				call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
				call_param = _tmp27_;
				call_param_length1 = 1;
				_call_param_size_ = call_param_length1;
				_g_object_unref0 (_tmp22_);
			}
		}
		_tmp28_ = context;
		_tmp29_ = jsc_context_get_value (_tmp28_, GEARY_WEB_EXTENSION_PAGE_STATE_OBJECT_NAME);
		page_state = _tmp29_;
		ret = NULL;
		_tmp30_ = webkit_user_message_get_name (message);
		_tmp31_ = _tmp30_;
		if (g_strcmp0 (_tmp31_, GEARY_WEB_EXTENSION_MESSAGE_ENABLE_REMOTE_LOAD) == 0) {
			gchar* _tmp32_;
			JSCValue* _tmp33_;
			_tmp32_ = g_strdup (GEARY_WEB_EXTENSION_EXTENSION_CLASS_ALLOW_REMOTE_LOAD);
			g_object_set_data_full (G_TYPE_CHECK_INSTANCE_CAST (page, G_TYPE_OBJECT, GObject), GEARY_WEB_EXTENSION_EXTENSION_CLASS_ALLOW_REMOTE_LOAD, _tmp32_, g_free);
			_tmp33_ = page_state;
			if (!jsc_value_is_undefined (_tmp33_)) {
				JSCValue* _tmp34_;
				JSCValue* _tmp35_;
				_tmp34_ = page_state;
				_tmp35_ = jsc_value_object_invoke_methodv (_tmp34_, "loadRemoteResources", (guint) 0, NULL);
				_g_object_unref0 (ret);
				ret = _tmp35_;
			}
		} else {
			JSCValue* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			JSCValue** _tmp39_;
			gint _tmp39__length1;
			JSCValue* _tmp40_;
			_tmp36_ = page_state;
			_tmp37_ = webkit_user_message_get_name (message);
			_tmp38_ = _tmp37_;
			_tmp39_ = call_param;
			_tmp39__length1 = call_param_length1;
			_tmp40_ = jsc_value_object_invoke_methodv (_tmp36_, _tmp38_, (guint) _tmp39__length1, _tmp39_);
			_g_object_unref0 (ret);
			ret = _tmp40_;
		}
		_tmp41_ = context;
		_tmp42_ = jsc_context_get_exception (_tmp41_);
		_tmp43_ = _g_object_ref0 (_tmp42_);
		thrown = _tmp43_;
		_tmp44_ = thrown;
		if (_tmp44_ != NULL) {
			JSCException* _tmp45_;
			const gchar* _tmp46_;
			JSCException* _tmp47_;
			const gchar* _tmp48_;
			JSCException* _tmp49_;
			const gchar* _tmp50_;
			JSCException* _tmp51_;
			const gchar* _tmp52_;
			JSCException* _tmp53_;
			JSCException* _tmp54_;
			WebKitUserMessage* _tmp55_;
			WebKitUserMessage* _tmp56_;
			_tmp45_ = thrown;
			_tmp46_ = jsc_exception_get_name (_tmp45_);
			_tmp47_ = thrown;
			_tmp48_ = jsc_exception_get_message (_tmp47_);
			_tmp49_ = thrown;
			_tmp50_ = jsc_exception_get_backtrace_string (_tmp49_);
			_tmp51_ = thrown;
			_tmp52_ = jsc_exception_get_source_uri (_tmp51_);
			_tmp53_ = thrown;
			_tmp54_ = thrown;
			_tmp55_ = geary_web_extension_to_exception_message (self, _tmp46_, _tmp48_, _tmp50_, _tmp52_, (gint) jsc_exception_get_line_number (_tmp53_), (gint) jsc_exception_get_column_number (_tmp54_));
			_tmp56_ = _tmp55_;
			webkit_user_message_send_reply (message, _tmp56_);
			_g_object_unref0 (_tmp56_);
		} else {
			GVariant* _tmp57_ = NULL;
			JSCValue* _tmp58_;
			WebKitUserMessage* _tmp61_;
			WebKitUserMessage* _tmp62_;
			_tmp58_ = ret;
			if (_tmp58_ != NULL) {
				JSCValue* _tmp59_;
				GVariant* _tmp60_;
				_tmp59_ = ret;
				_tmp60_ = util_js_value_to_variant (_tmp59_, &_inner_error0_);
				_g_variant_unref0 (_tmp57_);
				_tmp57_ = _tmp60_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_variant_unref0 (_tmp57_);
					_g_object_unref0 (thrown);
					_g_object_unref0 (ret);
					_g_object_unref0 (page_state);
					_g_variant_unref0 (message_param);
					call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
					goto __catch0_g_error;
				}
			} else {
				_g_variant_unref0 (_tmp57_);
				_tmp57_ = NULL;
			}
			_tmp61_ = webkit_user_message_new (GEARY_WEB_EXTENSION_MESSAGE_RETURN_VALUE, _tmp57_);
			g_object_ref_sink (_tmp61_);
			_tmp62_ = _tmp61_;
			webkit_user_message_send_reply (message, _tmp62_);
			_g_object_unref0 (_tmp62_);
			_g_variant_unref0 (_tmp57_);
		}
		_g_object_unref0 (thrown);
		_g_object_unref0 (ret);
		_g_object_unref0 (page_state);
		_g_variant_unref0 (message_param);
		call_param = (_vala_array_free (call_param, call_param_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp63_;
		const gchar* _tmp64_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp63_ = err;
		_tmp64_ = _tmp63_->message;
		g_debug ("web-process-extension.vala:206: Failed to handle message: %s", _tmp64_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp65_ = FALSE;
		_g_object_unref0 (context);
		_g_object_unref0 (frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp65_;
	}
	result = TRUE;
	_g_object_unref0 (context);
	_g_object_unref0 (frame);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
geary_web_extension_on_page_send_message (GearyWebExtension* self,
                                          WebKitWebPage* page,
                                          GPtrArray* args)
{
	WebKitUserMessage* message = NULL;
	gint _tmp0_;
	gint _tmp1_;
	WebKitUserMessage* _tmp35_;
	WebKitUserMessage* _tmp41_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_GEARY_WEB_EXTENSION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()), FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	message = NULL;
	_tmp0_ = vala_g_ptr_array_get_length (args);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		gchar* name = NULL;
		gconstpointer _tmp2_;
		gchar* _tmp3_;
		GVariant* parameters = NULL;
		gint _tmp4_;
		gint _tmp5_;
		WebKitUserMessage* _tmp31_;
		_tmp2_ = g_ptr_array_index (args, (guint) 0);
		_tmp3_ = jsc_value_to_string ((JSCValue*) _tmp2_);
		name = _tmp3_;
		parameters = NULL;
		_tmp4_ = vala_g_ptr_array_get_length (args);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 1) {
			JSCValue* param_value = NULL;
			gconstpointer _tmp6_;
			JSCValue* _tmp7_;
			_tmp6_ = g_ptr_array_index (args, (guint) 1);
			_tmp7_ = _g_object_ref0 ((JSCValue*) _tmp6_);
			param_value = _tmp7_;
			{
				gint len = 0;
				JSCValue* _tmp8_;
				JSCValue* _tmp9_;
				JSCValue* _tmp10_;
				gint _tmp11_;
				_tmp8_ = param_value;
				_tmp9_ = jsc_value_object_get_property (_tmp8_, "length");
				_tmp10_ = _tmp9_;
				_tmp11_ = (gint) util_js_to_int32 (_tmp10_, &_inner_error0_);
				_g_object_unref0 (_tmp10_);
				len = _tmp11_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp12_ = FALSE;
					if (_inner_error0_->domain == UTIL_JS_ERROR) {
						goto __catch0_util_js_error;
					}
					_g_object_unref0 (param_value);
					_g_variant_unref0 (parameters);
					_g_free0 (name);
					_g_object_unref0 (message);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp12_;
				}
				if (len == 1) {
					GVariant* _tmp13_ = NULL;
					JSCValue* _tmp14_;
					JSCValue* _tmp15_;
					JSCValue* _tmp16_;
					GVariant* _tmp17_;
					GVariant* _tmp18_;
					GVariant* _tmp20_;
					_tmp14_ = param_value;
					_tmp15_ = jsc_value_object_get_property_at_index (_tmp14_, (guint) 0);
					_tmp16_ = _tmp15_;
					_tmp17_ = util_js_value_to_variant (_tmp16_, &_inner_error0_);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp16_);
					_tmp13_ = _tmp18_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp19_ = FALSE;
						if (_inner_error0_->domain == UTIL_JS_ERROR) {
							goto __catch0_util_js_error;
						}
						_g_object_unref0 (param_value);
						_g_variant_unref0 (parameters);
						_g_free0 (name);
						_g_object_unref0 (message);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp19_;
					}
					_tmp20_ = _tmp13_;
					_tmp13_ = NULL;
					_g_variant_unref0 (parameters);
					parameters = _tmp20_;
					_g_variant_unref0 (_tmp13_);
				} else {
					if (len > 1) {
						GVariant* _tmp21_ = NULL;
						JSCValue* _tmp22_;
						GVariant* _tmp23_;
						GVariant* _tmp25_;
						_tmp22_ = param_value;
						_tmp23_ = util_js_value_to_variant (_tmp22_, &_inner_error0_);
						_tmp21_ = _tmp23_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp24_ = FALSE;
							if (_inner_error0_->domain == UTIL_JS_ERROR) {
								goto __catch0_util_js_error;
							}
							_g_object_unref0 (param_value);
							_g_variant_unref0 (parameters);
							_g_free0 (name);
							_g_object_unref0 (message);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp24_;
						}
						_tmp25_ = _tmp21_;
						_tmp21_ = NULL;
						_g_variant_unref0 (parameters);
						parameters = _tmp25_;
						_g_variant_unref0 (_tmp21_);
					}
				}
			}
			goto __finally0;
			__catch0_util_js_error:
			{
				GError* err = NULL;
				const gchar* _tmp26_;
				GError* _tmp27_;
				const gchar* _tmp28_;
				WebKitUserMessage* _tmp29_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
				_tmp27_ = err;
				_tmp28_ = _tmp27_->message;
				_tmp29_ = geary_web_extension_to_exception_message (self, _tmp26_, _tmp28_, NULL, NULL, -1, -1);
				_g_object_unref0 (message);
				message = _tmp29_;
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp30_ = FALSE;
				_g_object_unref0 (param_value);
				_g_variant_unref0 (parameters);
				_g_free0 (name);
				_g_object_unref0 (message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp30_;
			}
			_g_object_unref0 (param_value);
		}
		_tmp31_ = message;
		if (_tmp31_ == NULL) {
			const gchar* _tmp32_;
			GVariant* _tmp33_;
			WebKitUserMessage* _tmp34_;
			_tmp32_ = name;
			_tmp33_ = parameters;
			_tmp34_ = webkit_user_message_new (_tmp32_, _tmp33_);
			g_object_ref_sink (_tmp34_);
			_g_object_unref0 (message);
			message = _tmp34_;
		}
		_g_variant_unref0 (parameters);
		_g_free0 (name);
	}
	_tmp35_ = message;
	if (_tmp35_ == NULL) {
		gchar* log_message = NULL;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		WebKitUserMessage* _tmp40_;
		_tmp36_ = g_strdup_printf ("Not enough parameters for JS call to %s.%s()", GEARY_WEB_EXTENSION_EXTENSION_CLASS_VAR, GEARY_WEB_EXTENSION_EXTENSION_CLASS_SEND);
		log_message = _tmp36_;
		_tmp37_ = log_message;
		g_debug ("web-process-extension.vala:246: %s", _tmp37_);
		_tmp38_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
		_tmp39_ = log_message;
		_tmp40_ = geary_web_extension_to_exception_message (self, _tmp38_, _tmp39_, NULL, NULL, -1, -1);
		_g_object_unref0 (message);
		message = _tmp40_;
		_g_free0 (log_message);
	}
	_tmp41_ = message;
	webkit_web_page_send_message_to_view (page, _tmp41_, NULL, NULL, NULL);
	result = TRUE;
	_g_object_unref0 (message);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GearyWebExtension* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->page);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
__lambda4_ (Block1Data* _data1_,
            JSCClass* instance,
            GPtrArray* values)
{
	GearyWebExtension* self;
	gpointer result;
	self = _data1_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (instance, jsc_class_get_type ()), NULL);
	g_return_val_if_fail (values != NULL, NULL);
	result = geary_web_extension_on_page_send_message (self, _data1_->page, values);
	return result;
}

static gpointer
___lambda4__gcallback (JSCClass* instance,
                       GPtrArray* values,
                       gpointer self)
{
	gpointer result;
	result = __lambda4_ (self, instance, values);
	return result;
}

static void
geary_web_extension_on_window_object_cleared (GearyWebExtension* self,
                                              WebKitScriptWorld* world,
                                              WebKitWebPage* page,
                                              WebKitFrame* frame)
{
	Block1Data* _data1_;
	WebKitWebPage* _tmp0_;
	JSCContext* context = NULL;
	JSCContext* _tmp1_;
	JSCClass* extension_class = NULL;
	const gchar* _tmp2_;
	JSCClass* _tmp3_;
	JSCClass* _tmp4_;
	JSCValue* _tmp5_;
	JSCValue* _tmp6_;
	g_return_if_fail (IS_GEARY_WEB_EXTENSION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (world, webkit_script_world_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (page, webkit_web_page_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (frame, webkit_frame_get_type ()));
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (page);
	_g_object_unref0 (_data1_->page);
	_data1_->page = _tmp0_;
	_tmp1_ = webkit_frame_get_js_context (frame);
	context = _tmp1_;
	_tmp2_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
	_tmp3_ = jsc_context_register_class (context, _tmp2_, NULL, NULL, NULL);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	extension_class = _tmp4_;
	jsc_class_add_method_variadic (extension_class, GEARY_WEB_EXTENSION_EXTENSION_CLASS_SEND, (GCallback) ___lambda4__gcallback, block1_data_ref (_data1_), block1_data_unref, G_TYPE_NONE);
	_tmp5_ = jsc_value_new_object (context, extension_class, extension_class);
	_tmp6_ = _tmp5_;
	jsc_context_set_value (context, GEARY_WEB_EXTENSION_EXTENSION_CLASS_VAR, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (extension_class);
	_g_object_unref0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
geary_web_extension_class_init (GearyWebExtensionClass * klass,
                                gpointer klass_data)
{
	geary_web_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyWebExtension_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_web_extension_finalize;
}

static void
geary_web_extension_instance_init (GearyWebExtension * self,
                                   gpointer klass)
{
	self->priv = geary_web_extension_get_instance_private (self);
}

static void
geary_web_extension_finalize (GObject * obj)
{
	GearyWebExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GEARY_WEB_EXTENSION, GearyWebExtension);
	_g_object_unref0 (self->priv->extension);
	G_OBJECT_CLASS (geary_web_extension_parent_class)->finalize (obj);
}

/**
 * A WebExtension that manages Geary-specific behaviours in web processes.
 */
static GType
geary_web_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyWebExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_web_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyWebExtension), 0, (GInstanceInitFunc) geary_web_extension_instance_init, NULL };
	GType geary_web_extension_type_id;
	geary_web_extension_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyWebExtension", &g_define_type_info, 0);
	GearyWebExtension_private_offset = g_type_add_instance_private (geary_web_extension_type_id, sizeof (GearyWebExtensionPrivate));
	return geary_web_extension_type_id;
}

GType
geary_web_extension_get_type (void)
{
	static volatile gsize geary_web_extension_type_id__once = 0;
	if (g_once_init_enter (&geary_web_extension_type_id__once)) {
		GType geary_web_extension_type_id;
		geary_web_extension_type_id = geary_web_extension_get_type_once ();
		g_once_init_leave (&geary_web_extension_type_id__once, geary_web_extension_type_id);
	}
	return geary_web_extension_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

