- [ConfigOptions](#configoptions)
  * [Git options](#git-options)
  * [SVN options](#svn-options)
  * [URL options](#url-options)
  * [Misc options](#misc-options)



# Config Options
Most of Hound's behavior is defined by a single `config.json` configuration file. A list of its available options are provided below, along with their defaults.
keys used in the config json file are the options,description provides details about keys.Default values gives idea about value which can be used for the option.


ConfigOption | Description | Default Values
:------ | :----- | :-----
max-concurrent-indexers | defines the total number of indexers required to be used for indexing code | 2
health-check-uri |  health check url for hound | `/healthz`
dbpath | absolute file path where the `config.json` file exists| `data`
title | Title used for the application | Hound
url-pattern | composed of base url and anchor values in form of key value pairs | n/a
vcs-config | holds the version control config, default VCS used in Hound is git.Other options for VCS are svn,mercurial,bitbucket,hg, etc.Refer to `config-example.json` to get the list of vcs and usage. Below tables provide detailed options list of each type of vcs | git
repos | holds the list of repos which are required to be indexed by Hound . Each Repo is added with reponame as a Json Key with options associated with repo as values similar to example provided in `config-example.json` | n/a

## Git Options
List of options associated with git vcs in repos

GitOptions  | Description | Default Values
:------ | :----- | :-----
ms-between-poll | time interval to poll the repo url | 30s
detect-ref    | used to determine branch |  master branch 
ref | used to provide reference for the branch for repo| n/a

## SVN Options

List of options available for SVN vcs in repos

SvnOptions  | Descriptions| Default Values
:------ | :-----| :-----
username  | user name for the svn repo | n/a
password | password to authenticate use for svn repo | n/a


## URL Options 
Options for url used for repo link under repos

URLOptions | Description | Default Values
:------ | :--- | :-----
url-pattern | when provided used by Hound for config|`{url}/blob/{rev}/{path}{anchor}`
anchor | when provided used for vcs config| `#L{line}`

## Misc Options
These options are available for repos

Options | Description | Default Values
:------ | :--- | :-----
exclude-dot-files | excludes filenames that start with dot|`true`
auto-generated-files | marks filenames as autogenerated in UI| `[]` (for git, Hound checks for git attributes with the `linguist-generated` attribute)
