/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Edge;
import org.jmol.util.Logger;

public class XmlChemDrawReader
extends XmlReader {
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float minZ = Float.MAX_VALUE;
    private float maxZ = -3.4028235E38f;
    private float maxY = -3.4028235E38f;
    private float maxX = -3.4028235E38f;
    private boolean no3D;
    private Stack<String> fragments = new Stack();
    private String thisFragment;
    private CDNode thisNode;
    private Stack<CDNode> nodes = new Stack();
    private List<CDNode> nostereo = new ArrayList<CDNode>();
    private String textBuffer;
    public boolean isCDX;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.is2D = true;
        if (parent == null) {
            this.processXml2(this, saxReader);
            parent = this;
        } else {
            this.no3D = parent.checkFilterKey("NO3D");
            this.noHydrogens = parent.noHydrogens;
            this.processXml2(parent, saxReader);
            this.filter = parent.filter;
        }
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        String id = (String)this.atts.get("id");
        if ("fragment".equals(localName)) {
            this.thisFragment = id;
            this.fragments.push(this.thisFragment);
            return;
        }
        if ("n".equals(localName)) {
            this.setNode(id);
            return;
        }
        if ("t".equals(localName)) {
            this.textBuffer = "";
        }
        if ("s".equals(localName)) {
            this.setKeepChars(true);
        }
        if ("b".equals(localName)) {
            this.setBond();
            return;
        }
    }

    @Override
    void processEndElement(String localName) {
        if ("fragment".equals(localName)) {
            this.thisFragment = this.fragments.pop();
            return;
        }
        if ("n".equals(localName)) {
            this.thisNode = this.nodes.size() == 0 ? null : this.nodes.pop();
            return;
        }
        if ("s".equals(localName)) {
            this.textBuffer = this.textBuffer + this.chars.toString();
        }
        if ("t".equals(localName)) {
            if (this.thisNode == null) {
                System.out.println("XmlChemDrawReader unassigned text: " + this.textBuffer);
            } else {
                this.thisNode.text = this.textBuffer;
                if (this.atom.elementNumber == 0) {
                    System.err.println("XmlChemDrawReader: Problem with \"" + this.textBuffer + "\"");
                }
                if (this.thisNode.warning != null) {
                    this.parent.appendLoadNote("Warning: " + this.textBuffer + " " + this.thisNode.warning);
                }
            }
            this.textBuffer = "";
        }
        this.setKeepChars(false);
    }

    private void setNode(String id) {
        String nodeType = (String)this.atts.get("nodetype");
        if (this.asc.bsAtoms == null) {
            this.asc.bsAtoms = new BS();
        }
        if (this.thisNode != null) {
            this.nodes.push(this.thisNode);
        }
        if ("_".equals(nodeType)) {
            this.thisNode = null;
            this.atom = null;
            return;
        }
        this.thisNode = new CDNode(id, nodeType, this.thisFragment, this.thisNode);
        this.atom = this.thisNode;
        this.asc.addAtomWithMappedSerialNumber(this.atom);
        this.asc.bsAtoms.set(this.atom.index);
        String w = (String)this.atts.get("warning");
        if (w != null) {
            this.thisNode.warning = PT.rep(w, "&apos;", "'");
            this.thisNode.isValid = w.indexOf("ChemDraw can't interpret") < 0;
        }
        String element = (String)this.atts.get("element");
        String s = (String)this.atts.get("genericnickname");
        if (s != null) {
            element = s;
        }
        this.atom.elementNumber = (short)(!this.checkWarningOK(w) ? 0 : (element == null ? 6 : this.parseIntStr(element)));
        element = JmolAdapter.getElementSymbol(this.atom.elementNumber);
        s = (String)this.atts.get("isotope");
        if (s != null) {
            element = s + element;
        }
        this.setElementAndIsotope(this.atom, element);
        s = (String)this.atts.get("charge");
        if (s != null) {
            this.atom.formalCharge = this.parseIntStr(s);
        }
        boolean hasXYZ = this.atts.containsKey("xyz");
        boolean hasXY = this.atts.containsKey("p");
        if (!(!hasXYZ || this.no3D && hasXY)) {
            this.is2D = false;
            this.setAtom("xyz");
        } else if (this.atts.containsKey("p")) {
            this.setAtom("p");
        }
        s = (String)this.atts.get("attachments");
        if (s != null) {
            this.thisNode.setMultipleAttachments(PT.split(s.trim(), " "));
        }
        if (Logger.debugging) {
            Logger.info("XmlChemDraw id=" + id + " " + element + " " + this.atom);
        }
    }

    private boolean checkWarningOK(String warning) {
        return warning == null || warning.indexOf("valence") >= 0 || warning.indexOf("very close") >= 0 || warning.indexOf("two identical colinear bonds") >= 0;
    }

    private void setBond() {
        String atom1 = (String)this.atts.get("b");
        String atom2 = (String)this.atts.get("e");
        String a = (String)this.atts.get("beginattach");
        int beginAttach = a == null ? 0 : this.parseIntStr(a);
        a = (String)this.atts.get("endattach");
        int endAttach = a == null ? 0 : this.parseIntStr(a);
        String s = (String)this.atts.get("order");
        String disp = (String)this.atts.get("display");
        String disp2 = (String)this.atts.get("display2");
        int order = 131071;
        boolean invertEnds = false;
        if (disp == null) {
            if (s == null) {
                order = 1;
            } else if (s.equals("1.5")) {
                order = 515;
            } else {
                if (s.indexOf(".") > 0 && !"Dash".equals(disp2)) {
                    s = s.substring(0, s.indexOf("."));
                }
                order = Edge.getBondOrderFromString(s);
            }
        } else if (disp.equals("WedgeBegin")) {
            order = 1025;
        } else if (disp.equals("Hash") || disp.equals("WedgedHashBegin")) {
            order = 1041;
        } else if (disp.equals("WedgeEnd")) {
            invertEnds = true;
            order = 1025;
        } else if (disp.equals("WedgedHashEnd")) {
            invertEnds = true;
            order = 1041;
        } else if (disp.equals("Wavy")) {
            order = 1057;
        }
        if (order == 131071) {
            System.err.println("XmlChemDrawReader ignoring bond type " + s);
            return;
        }
        CDBond b = invertEnds ? new CDBond(atom2, atom1, order) : new CDBond(atom1, atom2, order);
        CDNode node1 = (CDNode)this.asc.atoms[b.atomIndex1];
        CDNode node2 = (CDNode)this.asc.atoms[b.atomIndex2];
        if (order == 1057) {
            if (!this.nostereo.contains(node1)) {
                this.nostereo.add(node1);
            }
            if (!this.nostereo.contains(node2)) {
                this.nostereo.add(node2);
            }
        }
        if (node1.hasMultipleAttachments) {
            node1.attachedAtom = node2;
            return;
        }
        if (node2.hasMultipleAttachments) {
            node2.attachedAtom = node1;
            return;
        }
        if (node1.isFragment && beginAttach == 0) {
            beginAttach = 1;
        }
        if (node2.isFragment && endAttach == 0) {
            endAttach = 1;
        }
        if (beginAttach > 0) {
            (invertEnds ? node2 : node1).addAttachedAtom(b, beginAttach);
        }
        if (endAttach > 0) {
            (invertEnds ? node1 : node2).addAttachedAtom(b, endAttach);
        }
        if (node1.isExternalPt) {
            node1.internalBond = b;
            node2.parentNode.addExternalPoint(node2);
        }
        if (node2.isExternalPt) {
            node2.internalBond = b;
            node1.parentNode.addExternalPoint(node1);
        }
        this.asc.addBondNoCheck(b);
    }

    private void setAtom(String key) {
        float z;
        String xyz = (String)this.atts.get(key);
        String[] tokens = PT.getTokens(xyz);
        float x = this.parseFloatStr(tokens[0]);
        float y = -this.parseFloatStr(tokens[1]);
        float f = z = key == "xyz" ? this.parseFloatStr(tokens[2]) : 0.0f;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        this.atom.set(x, y, z);
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.fixConnections();
        this.fixInvalidAtoms();
        this.centerAndScale();
        this.parent.appendLoadNote((this.isCDX ? "CDX: " : "CDXML: ") + (this.is2D ? "2D" : "3D"));
        this.asc.setInfo("minimize3D", !this.is2D && !this.noHydrogens);
        this.asc.setInfo("is2D", this.is2D);
        if (this.is2D) {
            this.optimize2D = !this.noHydrogens && !this.noMinimize;
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
            this.set2D();
        }
    }

    private void fixConnections() {
        int i = this.asc.ac;
        while (--i >= 0) {
            CDNode a = (CDNode)this.asc.atoms[i];
            if (!a.isFragment && !a.hasMultipleAttachments) continue;
            a.fixAttachments();
        }
        int n = this.asc.bondCount;
        for (i = 0; i < n; ++i) {
            Bond b = this.asc.bonds[i];
            if (b == null) continue;
            CDNode a1 = (CDNode)this.asc.atoms[b.atomIndex1];
            CDNode a2 = (CDNode)this.asc.atoms[b.atomIndex2];
            a1.isConnected = true;
            a2.isConnected = true;
            if (this.nostereo.contains(a1) == this.nostereo.contains(a2)) continue;
            b.order = 1;
        }
    }

    private void centerAndScale() {
        float f;
        if (this.minX > this.maxX) {
            return;
        }
        float sum = 0.0f;
        int n = 0;
        float lenH = 1.0f;
        int i = this.asc.bondCount;
        while (--i >= 0) {
            Atom a1 = this.asc.atoms[this.asc.bonds[i].atomIndex1];
            Atom a2 = this.asc.atoms[this.asc.bonds[i].atomIndex2];
            float d = a1.distance(a2);
            if (a1.elementNumber > 1 && a2.elementNumber > 1) {
                sum += d;
                ++n;
                continue;
            }
            lenH = d;
        }
        float f2 = sum > 0.0f ? 1.45f * (float)n / sum : (f = lenH > 0.0f ? 1.0f / lenH : 1.0f);
        if (f > 0.5f) {
            f = 1.0f;
        }
        float cx = (this.maxX + this.minX) / 2.0f;
        float cy = (this.maxY + this.minY) / 2.0f;
        float cz = (this.maxZ + this.minZ) / 2.0f;
        int i2 = this.asc.ac;
        while (--i2 >= 0) {
            Atom a = this.asc.atoms[i2];
            a.x = (a.x - cx) * f;
            a.y = (a.y - cy) * f;
            a.z = (a.z - cz) * f;
        }
    }

    private void fixInvalidAtoms() {
        int i = this.asc.ac;
        while (--i >= 0) {
            CDNode a = (CDNode)this.asc.atoms[i];
            a.atomSerial = Integer.MIN_VALUE;
            if (!a.isFragment && !a.isExternalPt && (a.isConnected || a.isValid && a.elementNumber != 6 && a.elementNumber != 0)) continue;
            this.asc.bsAtoms.clear(a.index);
        }
    }

    class CDBond
    extends Bond {
        String id1;
        String id2;

        CDBond(String id1, String id2, int order) {
            super(XmlChemDrawReader.this.asc.getAtomFromName((String)id1).index, XmlChemDrawReader.this.asc.getAtomFromName((String)id2).index, order);
            this.id1 = id1;
            this.id2 = id2;
        }

        CDNode getOtherNode(CDNode a) {
            return (CDNode)XmlChemDrawReader.this.asc.atoms[this.atomIndex1 == a.index ? this.atomIndex2 : this.atomIndex1];
        }

        @Override
        public String toString() {
            return super.toString() + " id1=" + this.id1 + " id2=" + this.id2;
        }
    }

    class CDNode
    extends Atom {
        String warning;
        String id;
        int intID;
        boolean isValid = true;
        boolean isConnected;
        boolean isFragment;
        boolean isExternalPt;
        String nodeType;
        String fragment;
        public String text;
        CDNode parentNode;
        Lst<CDNode> orderedExternalPoints;
        Lst<Object[]> orderedAttachedBonds;
        CDBond internalBond;
        private String[] attachments;
        public boolean hasMultipleAttachments;
        CDNode attachedAtom;
        private boolean isGeneric;

        CDNode(String id, String nodeType, String fragment, CDNode parent) {
            this.id = id;
            this.fragment = fragment;
            this.atomSerial = this.intID = Integer.parseInt(id);
            this.nodeType = nodeType;
            this.parentNode = parent;
            this.isFragment = "Fragment".equals(nodeType) || "Nickname".equals(nodeType);
            this.isExternalPt = "ExternalConnectionPoint".equals(nodeType);
            this.isGeneric = "GenericNickname".equals(nodeType);
        }

        void setMultipleAttachments(String[] attachments) {
            this.attachments = attachments;
            this.hasMultipleAttachments = true;
        }

        void addExternalPoint(CDNode node) {
            if (this.orderedExternalPoints == null) {
                this.orderedExternalPoints = new Lst();
            }
            int i = this.orderedExternalPoints.size();
            while (--i >= 0 && ((CDNode)this.orderedExternalPoints.get((int)i)).intID >= node.intID) {
            }
            this.orderedExternalPoints.add(++i, node);
        }

        void addAttachedAtom(CDBond bond, int pt) {
            if (this.orderedAttachedBonds == null) {
                this.orderedAttachedBonds = new Lst();
            }
            int i = this.orderedAttachedBonds.size();
            while (--i >= 0 && (Integer)((Object[])this.orderedAttachedBonds.get(i))[0] > pt) {
            }
            this.orderedAttachedBonds.add(++i, new Object[]{pt, bond});
        }

        void fixAttachments() {
            if (this.hasMultipleAttachments && this.attachedAtom != null) {
                int order = Edge.getBondOrderFromString("partial");
                int a1 = this.attachedAtom.index;
                int i = this.attachments.length;
                while (--i >= 0) {
                    Atom a = XmlChemDrawReader.this.asc.getAtomFromName(this.attachments[i]);
                    if (a == null) continue;
                    XmlChemDrawReader.this.asc.addBondNoCheck(new Bond(a1, a.index, order));
                }
            }
            if (this.orderedExternalPoints == null || this.text == null) {
                return;
            }
            int n = this.orderedExternalPoints.size();
            if (n != this.orderedAttachedBonds.size()) {
                System.err.println("cannot fix attachments for " + this.text);
            }
            for (int i = 0; i < n; ++i) {
                CDNode a = (CDNode)this.orderedExternalPoints.get(i);
                CDBond b = (CDBond)((Object[])this.orderedAttachedBonds.get(i))[1];
                if (b.atomIndex2 == this.index) {
                    b.atomIndex2 = a.index;
                    continue;
                }
                b.atomIndex1 = a.index;
            }
        }

        @Override
        public String toString() {
            return this.id + " " + this.elementSymbol + " " + this.elementNumber + " index=" + this.index + " ext=" + this.isExternalPt + " frag=" + this.isFragment + " " + this.elementSymbol + " " + this.x + " " + this.y;
        }
    }
}

