import { MatrixUser, MatrixRoom, RoomBridgeStoreEntry as Entry, ProvisionSession, ProvisioningStore, UserActivitySet, UserActivity } from "matrix-appservice-bridge";
import { DataStore, RoomOrigin, ChannelMappings, UserFeatures } from "../DataStore";
import { MatrixDirectoryVisibility } from "../../bridge/IrcHandler";
import { IrcRoom } from "../../models/IrcRoom";
import { IrcClientConfig } from "../../models/IrcClientConfig";
import { IrcServer, IrcServerConfig } from "../../irc/IrcServer";
import Bluebird from "bluebird";
export declare class PgDataStore implements DataStore, ProvisioningStore {
    private bridgeDomain;
    private serverMappings;
    static readonly LATEST_SCHEMA = 9;
    private pgPool;
    private hasEnded;
    private cryptoStore?;
    private userFeatureCache;
    constructor(bridgeDomain: string, connectionString: string, pkeyPath?: string, min?: number, max?: number);
    setServerFromConfig(server: IrcServer, serverConfig: IrcServerConfig): Promise<void>;
    storeRoom(ircRoom: IrcRoom, matrixRoom: MatrixRoom, origin: RoomOrigin): Promise<void>;
    upsertRoom(origin: RoomOrigin, type: string, domain: string, channel: string, roomId: string, ircJson: string, matrixJson: string): Promise<void>;
    private static pgToRoomEntry;
    getRoom(roomId: string, ircDomain: string, ircChannel: string, origin?: RoomOrigin): Promise<Entry | null>;
    getAllChannelMappings(): Promise<ChannelMappings>;
    getEntriesByMatrixId(roomId: string): Bluebird<Entry[]>;
    getProvisionedMappings(roomId: string): Promise<Entry[]>;
    removeRoom(roomId: string, ircDomain: string, ircChannel: string, origin?: RoomOrigin): Promise<void>;
    getIrcChannelsForRoomId(roomId: string): Promise<IrcRoom[]>;
    getIrcChannelsForRoomIds(roomIds: string[]): Promise<{
        [roomId: string]: IrcRoom[];
    }>;
    getMatrixRoomsForChannel(server: IrcServer, channel: string): Promise<MatrixRoom[]>;
    getMappingsForChannelByOrigin(server: IrcServer, channel: string, origin: RoomOrigin | RoomOrigin[]): Promise<Entry[]>;
    getModesForChannel(server: IrcServer, channel: string): Promise<{
        [id: string]: string[];
    }>;
    setModeForRoom(roomId: string, mode: string, enabled: boolean): Promise<void>;
    setPmRoom(ircRoom: IrcRoom, matrixRoom: MatrixRoom, userId: string, virtualUserId: string): Promise<void>;
    removePmRoom(roomId: string): Promise<void>;
    getMatrixPmRoom(realUserId: string, virtualUserId: string): Promise<MatrixRoom | null>;
    getMatrixPmRoomById(roomId: string): Promise<MatrixRoom | null>;
    getTrackedChannelsForServer(domain: string): Promise<string[]>;
    getRoomIdsFromConfig(): Promise<string[]>;
    removeConfigMappings(): Promise<void>;
    getIpv6Counter(server: IrcServer, homeserver: string | null): Promise<number>;
    setIpv6Counter(counter: number, server: IrcServer, homeserver: string | null): Promise<void>;
    upsertMatrixRoom(room: MatrixRoom): Promise<void>;
    getAdminRoomById(roomId: string): Promise<MatrixRoom | null>;
    storeAdminRoom(room: MatrixRoom, userId: string): Promise<void>;
    getAdminRoomByUserId(userId: string): Promise<MatrixRoom | null>;
    removeAdminRoom(room: MatrixRoom): Promise<void>;
    storeMatrixUser(matrixUser: MatrixUser): Promise<void>;
    getIrcClientConfig(userId: string, domain: string): Promise<IrcClientConfig | null>;
    storeIrcClientConfig(config: IrcClientConfig): Promise<void>;
    getMatrixUserByLocalpart(localpart: string): Promise<MatrixUser | null>;
    getUserFeatures(userId: string): Promise<UserFeatures>;
    storeUserFeatures(userId: string, features: UserFeatures): Promise<void>;
    getUserActivity(): Promise<UserActivitySet>;
    storeUserActivity(userId: string, activity: UserActivity): Promise<void>;
    storePass(userId: string, domain: string, pass: string, encrypt?: boolean): Promise<void>;
    removePass(userId: string, domain: string): Promise<void>;
    getMatrixUserByUsername(domain: string, username: string): Promise<MatrixUser | undefined>;
    getCountForUsernamePrefix(domain: string, usernamePrefix: string): Promise<number>;
    roomUpgradeOnRoomMigrated(oldRoomId: string, newRoomId: string): Promise<void>;
    updateLastSeenTimeForUser(userId: string): Promise<void>;
    getLastSeenTimeForUsers(): Promise<{
        user_id: string;
        ts: number;
    }[]>;
    getAllUserIds(): Promise<any[]>;
    getRoomsVisibility(roomIds: string[]): Promise<Map<string, MatrixDirectoryVisibility>>;
    setRoomVisibility(roomId: string, visibility: MatrixDirectoryVisibility): Promise<void>;
    isUserDeactivated(userId: string): Promise<boolean>;
    deactivateUser(userId: string): Promise<void>;
    ensureSchema(): Promise<void>;
    getRoomCount(): Promise<number>;
    getSessionForToken(token: string): Promise<ProvisionSession | null>;
    createSession(session: ProvisionSession): Promise<void>;
    deleteSession(token: string): Promise<void>;
    deleteAllSessions(userId: string): Promise<void>;
    destroy(): Promise<void>;
    private updateSchemaVersion;
    private getSchemaVersion;
    private static BuildUpsertStatement;
}
