/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.import_actions;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.gui.messages.ReplaceListChangedEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.ReplaceList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000eH\u0082\u0002\u00a2\u0006\u0002\u0010\u0010J8\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter;", "", "()V", "daten", "Lmediathek/config/Daten;", "inFactory", "Ljavax/xml/stream/XMLInputFactory;", "get", "", "parser", "Ljavax/xml/stream/XMLStreamReader;", "xmlElem", "", "xmlNames", "", "strRet", "(Ljavax/xml/stream/XMLStreamReader;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Z", "importAboBlacklist", "Lorg/apache/commons/lang3/tuple/ImmutableTriple;", "", "datei", "importAbo", "importBlacklist", "importReplaceList", "importAboEntry", "Companion", "MediathekView"})
public final class OldConfigFileImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Daten daten;
    @NotNull
    private final XMLInputFactory inFactory;
    private static final Logger logger = LogManager.getLogger();

    public OldConfigFileImporter() {
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue(daten, "getInstance()");
        this.daten = daten;
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue(xMLInputFactory, "newInstance()");
        this.inFactory = xMLInputFactory;
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ImmutableTriple<Integer, Integer, Integer> importAboBlacklist(@NotNull String datei, boolean importAbo, boolean importBlacklist, boolean importReplaceList) throws IOException, XMLStreamException {
        Intrinsics.checkNotNullParameter(datei, "datei");
        int foundAbos = 0;
        int foundBlacklistEntries = 0;
        int foundReplaceListEntries = 0;
        XMLStreamReader parser = null;
        try {
            Closeable closeable = new FileInputStream(datei);
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    InputStreamReader isr = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    parser = this.inFactory.createXMLStreamReader(isr);
                    while (true) {
                        XMLStreamReader xMLStreamReader = parser;
                        Intrinsics.checkNotNull(xMLStreamReader);
                        if (!xMLStreamReader.hasNext()) break;
                        int event = parser.next();
                        if (event != 1) continue;
                        if (importAbo && Intrinsics.areEqual(parser.getLocalName(), "Abonnement")) {
                            if (!this.importAboEntry(parser)) continue;
                            ++foundAbos;
                            continue;
                        }
                        if (importBlacklist && Intrinsics.areEqual(parser.getLocalName(), "Blacklist")) {
                            try {
                                BlacklistRule rule = new BlacklistRule(null, null, null, null, 15, null);
                                rule.readFromConfig(parser);
                                this.daten.getListeBlacklist().addWithoutNotification(rule);
                                int n = foundBlacklistEntries;
                                foundBlacklistEntries = n + 1;
                            }
                            catch (Exception e) {
                                logger.error("Failed to read blacklist rule", (Throwable)e);
                            }
                            continue;
                        }
                        if (!importReplaceList || !Intrinsics.areEqual(parser.getLocalName(), "Ersetzungstabelle") || !this.importReplaceList(parser)) continue;
                        ++foundReplaceListEntries;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Throwable throwable) {
            if (parser != null) {
                try {
                    ((XMLStreamReader)parser).close();
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            parser.close();
        }
        catch (XMLStreamException xMLStreamException) {}
        if (foundAbos > 0) {
            this.daten.getListeAbo().aenderungMelden();
        }
        if (foundBlacklistEntries > 0) {
            this.daten.getListeBlacklist().filterListAndNotifyListeners();
        }
        if (foundReplaceListEntries > 0) {
            MessageBus.getMessageBus().publishAsync(new ReplaceListChangedEvent());
        }
        return new ImmutableTriple<Integer, Integer, Integer>(foundAbos, foundBlacklistEntries, foundReplaceListEntries);
    }

    private final boolean importAboEntry(XMLStreamReader parser) {
        boolean bl;
        try {
            DatenAbo datenAbo = new DatenAbo();
            datenAbo.readFromConfig(parser);
            this.daten.getListeAbo().addAbo(datenAbo);
            bl = true;
        }
        catch (Exception e) {
            logger.error("Error importing abo entry");
            bl = false;
        }
        return bl;
    }

    private final boolean importReplaceList(XMLStreamReader parser) {
        boolean bl;
        String[] sa = new String[2];
        Intrinsics.checkNotNullExpressionValue(ReplaceList.COLUMN_NAMES, "COLUMN_NAMES");
        boolean success = this.get(parser, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa);
        if (success) {
            ReplaceList.list.add(sa);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean bl;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            if (strRet[i] != null) continue;
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !Intrinsics.areEqual(parser.getLocalName(), xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!Intrinsics.areEqual(parser.getLocalName(), xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
            bl = true;
        }
        catch (Exception ex) {
            logger.error("get", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/gui/actions/import_actions/OldConfigFileImporter$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

