/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.BucketLevelMonitorRunner;
import org.opensearch.alerting.DocumentLevelMonitorRunner;
import org.opensearch.alerting.InputService;
import org.opensearch.alerting.MonitorRunnerExecutionContext;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.QueryLevelMonitorRunner;
import org.opensearch.alerting.TriggerService;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.alerts.AlertMoverKt;
import org.opensearch.alerting.core.JobRunner;
import org.opensearch.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.alerting.model.DocumentLevelTriggerRunResult;
import org.opensearch.alerting.model.MonitorRunResult;
import org.opensearch.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.alerting.model.destination.DestinationContextFactory;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.script.TriggerExecutionContext;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.action.Throttle;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;
import org.opensearch.threadpool.ThreadPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\n \u000b*\u0004\u0018\u00010\u001c0\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J\b\u0010!\u001a\u00020\u001fH\u0014J\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020\u0000J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020UJ\u000e\u0010V\u001a\u00020\u001f2\u0006\u0010N\u001a\u00020OJ \u0010W\u001a\u00020\u001f2\u0006\u00101\u001a\u0002022\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u001cH\u0016J5\u0010W\u001a\u0006\u0012\u0002\b\u00030Z2\u0006\u00101\u001a\u0002022\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\\R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006]"}, d2={"Lorg/opensearch/alerting/MonitorRunnerService;", "Lorg/opensearch/alerting/core/JobRunner;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/opensearch/common/component/AbstractLifecycleComponent;", "()V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "monitorCtx", "Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "getMonitorCtx", "()Lorg/opensearch/alerting/MonitorRunnerExecutionContext;", "setMonitorCtx", "(Lorg/opensearch/alerting/MonitorRunnerExecutionContext;)V", "runnerSupervisor", "Lkotlinx/coroutines/Job;", "compileTemplate", "", "template", "Lorg/opensearch/script/Script;", "ctx", "Lorg/opensearch/alerting/script/TriggerExecutionContext;", "compileTemplate$opensearch_alerting", "currentTime", "Ljava/time/Instant;", "currentTime$opensearch_alerting", "doClose", "", "doStart", "doStop", "getRolesForMonitor", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "getRolesForMonitor$opensearch_alerting", "isActionActionable", "", "action", "Lorg/opensearch/commons/alerting/model/action/Action;", "alert", "Lorg/opensearch/commons/alerting/model/Alert;", "isActionActionable$opensearch_alerting", "postDelete", "jobId", "postIndex", "job", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "registerAlertIndices", "alertIndices", "Lorg/opensearch/alerting/alerts/AlertIndices;", "registerAlertService", "alertService", "Lorg/opensearch/alerting/AlertService;", "registerClient", "client", "Lorg/opensearch/client/Client;", "registerClusterService", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "registerConsumers", "registerDestinationSettings", "registerDocLevelMonitorQueries", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "registerInputService", "inputService", "Lorg/opensearch/alerting/InputService;", "registerNamedXContentRegistry", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "registerScriptService", "scriptService", "Lorg/opensearch/script/ScriptService;", "registerSettings", "settings", "Lorg/opensearch/common/settings/Settings;", "registerThreadPool", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "registerTriggerService", "triggerService", "Lorg/opensearch/alerting/TriggerService;", "reloadDestinationSettings", "runJob", "periodStart", "periodEnd", "Lorg/opensearch/alerting/model/MonitorRunResult;", "dryrun", "(Lorg/opensearch/commons/alerting/model/ScheduledJob;Ljava/time/Instant;Ljava/time/Instant;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-alerting"})
public final class MonitorRunnerService
extends AbstractLifecycleComponent
implements JobRunner,
CoroutineScope {
    @NotNull
    public static final MonitorRunnerService INSTANCE = new MonitorRunnerService();
    private static final Logger logger = LogManager.getLogger(((Object)((Object)INSTANCE)).getClass());
    @NotNull
    private static MonitorRunnerExecutionContext monitorCtx = new MonitorRunnerExecutionContext(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0L, null, 524287, null);
    private static Job runnerSupervisor;

    private MonitorRunnerService() {
    }

    @NotNull
    public final MonitorRunnerExecutionContext getMonitorCtx() {
        return monitorCtx;
    }

    public final void setMonitorCtx(@NotNull MonitorRunnerExecutionContext monitorRunnerExecutionContext) {
        Intrinsics.checkNotNullParameter((Object)monitorRunnerExecutionContext, (String)"<set-?>");
        monitorCtx = monitorRunnerExecutionContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getDefault();
        Job job = runnerSupervisor;
        if (job == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runnerSupervisor");
            job = null;
        }
        return coroutineDispatcher.plus((CoroutineContext)job);
    }

    @NotNull
    public final MonitorRunnerService registerClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        monitorCtx.setClusterService(clusterService);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        monitorCtx.setClient(client);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerNamedXContentRegistry(@NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        monitorCtx.setXContentRegistry(xContentRegistry);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerScriptService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        monitorCtx.setScriptService(scriptService);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        monitorCtx.setSettings(settings);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        monitorCtx.setThreadPool(threadPool);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerAlertIndices(@NotNull AlertIndices alertIndices) {
        Intrinsics.checkNotNullParameter((Object)alertIndices, (String)"alertIndices");
        monitorCtx.setAlertIndices(alertIndices);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerInputService(@NotNull InputService inputService) {
        Intrinsics.checkNotNullParameter((Object)inputService, (String)"inputService");
        monitorCtx.setInputService(inputService);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerTriggerService(@NotNull TriggerService triggerService) {
        Intrinsics.checkNotNullParameter((Object)triggerService, (String)"triggerService");
        monitorCtx.setTriggerService(triggerService);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerAlertService(@NotNull AlertService alertService) {
        Intrinsics.checkNotNullParameter((Object)alertService, (String)"alertService");
        monitorCtx.setAlertService(alertService);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerDocLevelMonitorQueries(@NotNull DocLevelMonitorQueries docLevelMonitorQueries) {
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"docLevelMonitorQueries");
        monitorCtx.setDocLevelMonitorQueries(docLevelMonitorQueries);
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerConsumers() {
        TimeValue timeValue = (TimeValue)AlertingSettings.Companion.getALERT_BACKOFF_MILLIS().get(monitorCtx.getSettings());
        Object object = AlertingSettings.Companion.getALERT_BACKOFF_COUNT().get(monitorCtx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ALERT_BACKOFF_COUNT.get(monitorCtx.settings)");
        monitorCtx.setRetryPolicy(BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue()));
        ClusterService clusterService = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), AlertingSettings.Companion.getALERT_BACKOFF_COUNT(), MonitorRunnerService::registerConsumers$lambda-0);
        TimeValue timeValue2 = (TimeValue)AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS().get(monitorCtx.getSettings());
        object = AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT().get(monitorCtx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MOVE_ALERTS_BACKOFF_COUNT.get(monitorCtx.settings)");
        monitorCtx.setMoveAlertsRetryPolicy(BackoffPolicy.exponentialBackoff((TimeValue)timeValue2, (int)((Number)object).intValue()));
        ClusterService clusterService2 = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService2);
        clusterService2.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), MonitorRunnerService::registerConsumers$lambda-1);
        object = DestinationSettings.Companion.getALLOW_LIST().get(monitorCtx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ALLOW_LIST.get(monitorCtx.settings)");
        monitorCtx.setAllowList((List)object);
        ClusterService clusterService3 = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService3);
        clusterService3.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), MonitorRunnerService::registerConsumers$lambda-2);
        object = DestinationSettings.Companion.getHOST_DENY_LIST().get(monitorCtx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HOST_DENY_LIST.get(monitorCtx.settings)");
        monitorCtx.setHostDenyList((List)object);
        object = AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT().get(monitorCtx.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAX_ACTIONABLE_ALERT_COU\u2026.get(monitorCtx.settings)");
        monitorCtx.setMaxActionableAlertCount(((Number)object).longValue());
        ClusterService clusterService4 = monitorCtx.getClusterService();
        Intrinsics.checkNotNull((Object)clusterService4);
        clusterService4.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT(), MonitorRunnerService::registerConsumers$lambda-3);
        monitorCtx.setIndexTimeout((TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(monitorCtx.getSettings()));
        return this;
    }

    @NotNull
    public final MonitorRunnerService registerDestinationSettings() {
        Settings settings = monitorCtx.getSettings();
        Intrinsics.checkNotNull((Object)settings);
        monitorCtx.setDestinationSettings(DestinationSettings.Companion.loadDestinationSettings(settings));
        Client client = monitorCtx.getClient();
        Intrinsics.checkNotNull((Object)client);
        NamedXContentRegistry namedXContentRegistry = monitorCtx.getXContentRegistry();
        Intrinsics.checkNotNull((Object)namedXContentRegistry);
        Map<String, DestinationSettings.Companion.SecureDestinationSettings> map = monitorCtx.getDestinationSettings();
        Intrinsics.checkNotNull(map);
        monitorCtx.setDestinationContextFactory(new DestinationContextFactory(client, namedXContentRegistry, map));
        return this;
    }

    public final void reloadDestinationSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        monitorCtx.setDestinationSettings(DestinationSettings.Companion.loadDestinationSettings(settings));
        DestinationContextFactory destinationContextFactory = monitorCtx.getDestinationContextFactory();
        Intrinsics.checkNotNull((Object)destinationContextFactory);
        Map<String, DestinationSettings.Companion.SecureDestinationSettings> map = monitorCtx.getDestinationSettings();
        Intrinsics.checkNotNull(map);
        destinationContextFactory.updateDestinationSettings(map);
    }

    protected void doStart() {
        runnerSupervisor = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    }

    protected void doStop() {
        Job job = runnerSupervisor;
        if (job == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runnerSupervisor");
            job = null;
        }
        job.cancel();
    }

    protected void doClose() {
    }

    public void postIndex(@NotNull ScheduledJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        if (!(job instanceof Monitor)) {
            throw new IllegalArgumentException("Invalid job type");
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, null){
            int label;
            final /* synthetic */ ScheduledJob $job;
            {
                this.$job = $job;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BackoffPolicy backoffPolicy = MonitorRunnerService.INSTANCE.getMonitorCtx().getMoveAlertsRetryPolicy();
                        Intrinsics.checkNotNull((Object)backoffPolicy);
                        Logger logger = MonitorRunnerService.access$getLogger$p();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                        this.label = 1;
                        Object object3 = OpenSearchExtensionsKt.retry$default((BackoffPolicy)backoffPolicy, (Logger)logger, null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$job, null){
                            int label;
                            final /* synthetic */ ScheduledJob $job;
                            {
                                this.$job = $job;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AlertIndices alertIndices = MonitorRunnerService.INSTANCE.getMonitorCtx().getAlertIndices();
                                        Intrinsics.checkNotNull((Object)alertIndices);
                                        if (!alertIndices.isAlertInitialized(((Monitor)this.$job).getDataSources())) return Unit.INSTANCE;
                                        Client client = MonitorRunnerService.INSTANCE.getMonitorCtx().getClient();
                                        Intrinsics.checkNotNull((Object)client);
                                        this.label = 1;
                                        Object object3 = AlertMoverKt.moveAlerts(client, this.$job.getId(), (Monitor)this.$job, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            MonitorRunnerService.access$getLogger$p().error("Failed to move active alerts for monitor [" + this.$job.getId() + "].", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void postDelete(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jobId, null){
            int label;
            final /* synthetic */ String $jobId;
            {
                this.$jobId = $jobId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BackoffPolicy backoffPolicy = MonitorRunnerService.INSTANCE.getMonitorCtx().getMoveAlertsRetryPolicy();
                        Intrinsics.checkNotNull((Object)backoffPolicy);
                        Logger logger = MonitorRunnerService.access$getLogger$p();
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                        this.label = 1;
                        Object object3 = OpenSearchExtensionsKt.retry$default((BackoffPolicy)backoffPolicy, (Logger)logger, null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$jobId, null){
                            int label;
                            final /* synthetic */ String $jobId;
                            {
                                this.$jobId = $jobId;
                                super(1, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AlertIndices alertIndices = MonitorRunnerService.INSTANCE.getMonitorCtx().getAlertIndices();
                                        Intrinsics.checkNotNull((Object)alertIndices);
                                        if (!alertIndices.isAlertInitialized()) return Unit.INSTANCE;
                                        Client client = MonitorRunnerService.INSTANCE.getMonitorCtx().getClient();
                                        Intrinsics.checkNotNull((Object)client);
                                        this.label = 1;
                                        Object object3 = AlertMoverKt.moveAlerts(client, this.$jobId, null, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            MonitorRunnerService.access$getLogger$p().error("Failed to move active alerts for monitor [" + this.$jobId + "].", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void runJob(@NotNull ScheduledJob job, @NotNull Instant periodStart, @NotNull Instant periodEnd) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)periodStart, (String)"periodStart");
        Intrinsics.checkNotNullParameter((Object)periodEnd, (String)"periodEnd");
        if (!(job instanceof Monitor)) {
            throw new IllegalArgumentException("Invalid job type");
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, periodStart, periodEnd, null){
            int label;
            final /* synthetic */ ScheduledJob $job;
            final /* synthetic */ Instant $periodStart;
            final /* synthetic */ Instant $periodEnd;
            {
                this.$job = $job;
                this.$periodStart = $periodStart;
                this.$periodEnd = $periodEnd;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = MonitorRunnerService.INSTANCE.runJob(this.$job, this.$periodStart, this.$periodEnd, false, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object runJob(@NotNull ScheduledJob var1_1, @NotNull Instant var2_2, @NotNull Instant var3_3, boolean var4_4, @NotNull Continuation<? super MonitorRunResult<?>> var5_5) {
        block11: {
            if (!(var5_5 instanceof runJob.2)) ** GOTO lbl-1000
            var9_6 = var5_5;
            if ((var9_6.label & -2147483648) != 0) {
                var9_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    /* synthetic */ Object result;
                    final /* synthetic */ MonitorRunnerService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runJob(null, null, null, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    monitor = (Monitor)job;
                    if (!IndexUtilsKt.isBucketLevelMonitor((Monitor)monitor)) break;
                    $continuation.label = 1;
                    v0 = BucketLevelMonitorRunner.INSTANCE.runMonitor(monitor, this.getMonitorCtx(), (Instant)periodStart, (Instant)periodEnd, dryrun != false, (Continuation<? super MonitorRunResult<BucketLevelTriggerRunResult>>)$continuation);
                    if (v0 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    v1 = (MonitorRunResult)v0;
                    ** GOTO lbl45
                }
            }
            if (!AlertingUtilsKt.isDocLevelMonitor(monitor)) break block11;
            $continuation.label = 2;
            v2 = DocumentLevelMonitorRunner.INSTANCE.runMonitor(monitor, this.getMonitorCtx(), (Instant)periodStart, (Instant)periodEnd, dryrun != false, (Continuation<? super MonitorRunResult<DocumentLevelTriggerRunResult>>)$continuation);
            if (v2 == var10_8) {
                return var10_8;
            }
            ** GOTO lbl33
            {
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl33:
                    // 2 sources

                    v1 = (MonitorRunResult)v2;
                    ** GOTO lbl45
                }
            }
        }
        $continuation.label = 3;
        v3 = QueryLevelMonitorRunner.INSTANCE.runMonitor(monitor, this.getMonitorCtx(), (Instant)periodStart, (Instant)periodEnd, dryrun != false, (Continuation<? super MonitorRunResult<QueryLevelTriggerRunResult>>)$continuation);
        if (v3 == var10_8) {
            return var10_8;
        }
        ** GOTO lbl44
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl44:
                // 2 sources

                v1 = (MonitorRunResult)v3;
lbl45:
                // 3 sources

                runResult = v1;
                return runResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<String> getRolesForMonitor$opensearch_alerting(@NotNull Monitor monitor) {
        List list;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        if (monitor.getUser() == null) {
            Settings settings = monitorCtx.getSettings();
            Intrinsics.checkNotNull((Object)settings);
            Object[] objectArray = new String[]{"all_access", "AmazonES_all_access"};
            List list2 = settings.getAsList("", CollectionsKt.listOf((Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n            // fixme: \u2026S_all_access\"))\n        }");
            list = list2;
        } else {
            User user = monitor.getUser();
            Intrinsics.checkNotNull((Object)user);
            List list3 = user.getRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"{\n            monitor.user!!.roles\n        }");
            list = list3;
        }
        return list;
    }

    public final Instant currentTime$opensearch_alerting() {
        ThreadPool threadPool = monitorCtx.getThreadPool();
        Intrinsics.checkNotNull((Object)threadPool);
        return Instant.ofEpochMilli(threadPool.absoluteTimeInMillis());
    }

    public final boolean isActionActionable$opensearch_alerting(@NotNull Action action, @Nullable Alert alert) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (alert == null || action.getThrottle() == null) {
            return true;
        }
        if (action.getThrottleEnabled()) {
            ActionExecutionResult result;
            Object v0;
            block3: {
                Iterable $this$firstOrNull$iv = alert.getActionExecutionResults();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ActionExecutionResult r = (ActionExecutionResult)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)r.getActionId(), (Object)action.getId())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            ActionExecutionResult actionExecutionResult = result = (ActionExecutionResult)v0;
            Instant lastExecutionTime = actionExecutionResult == null ? null : actionExecutionResult.getLastExecutionTime();
            Instant instant = this.currentTime$opensearch_alerting();
            Throttle throttle = action.getThrottle();
            Intrinsics.checkNotNull((Object)throttle);
            long l = throttle.getValue();
            Throttle throttle2 = action.getThrottle();
            Intrinsics.checkNotNull((Object)throttle2);
            Instant throttledTimeBound = instant.minus(l, throttle2.getUnit());
            return lastExecutionTime == null || lastExecutionTime.isBefore(throttledTimeBound);
        }
        return true;
    }

    @NotNull
    public final String compileTemplate$opensearch_alerting(@NotNull Script template, @NotNull TriggerExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ScriptService scriptService = monitorCtx.getScriptService();
        Intrinsics.checkNotNull((Object)scriptService);
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        Map map = template.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"template.params");
        String string = factory.newInstance(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", ctx.asTemplateArg())))).execute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"monitorCtx.scriptService\u2026))\n            .execute()");
        return string;
    }

    private static final void registerConsumers$lambda-0(TimeValue millis, Integer count) {
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        monitorCtx.setRetryPolicy(BackoffPolicy.constantBackoff((TimeValue)millis, (int)count));
    }

    private static final void registerConsumers$lambda-1(TimeValue millis, Integer count) {
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        monitorCtx.setMoveAlertsRetryPolicy(BackoffPolicy.exponentialBackoff((TimeValue)millis, (int)count));
    }

    private static final void registerConsumers$lambda-2(List it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        monitorCtx.setAllowList(it);
    }

    private static final void registerConsumers$lambda-3(Long it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        monitorCtx.setMaxActionableAlertCount(it);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }
}

