/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestMapper;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.serialize.json.v1.V1JsonToV3StateConverter;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.ad.AnomalyDetectorJobRunner;
import org.opensearch.ad.AnomalyDetectorRunner;
import org.opensearch.ad.ExecuteADResultResponseRecorder;
import org.opensearch.ad.MemoryTracker;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.caching.PriorityCache;
import org.opensearch.ad.cluster.ADClusterEventListener;
import org.opensearch.ad.cluster.ADDataMigrator;
import org.opensearch.ad.cluster.ClusterManagerEventListener;
import org.opensearch.ad.cluster.HashRing;
import org.opensearch.ad.dataprocessor.IntegerSensitiveSingleFeatureLinearUniformInterpolator;
import org.opensearch.ad.dataprocessor.LinearUniformInterpolator;
import org.opensearch.ad.feature.FeatureManager;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.ml.CheckpointDao;
import org.opensearch.ad.ml.EntityColdStarter;
import org.opensearch.ad.ml.HybridThresholdingModel;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.DetectorInternalState;
import org.opensearch.ad.ratelimit.CheckPointMaintainRequestAdapter;
import org.opensearch.ad.ratelimit.CheckpointMaintainWorker;
import org.opensearch.ad.ratelimit.CheckpointReadWorker;
import org.opensearch.ad.ratelimit.CheckpointWriteWorker;
import org.opensearch.ad.ratelimit.ColdEntityWorker;
import org.opensearch.ad.ratelimit.EntityColdStartWorker;
import org.opensearch.ad.ratelimit.ResultWriteWorker;
import org.opensearch.ad.rest.RestAnomalyDetectorJobAction;
import org.opensearch.ad.rest.RestDeleteAnomalyDetectorAction;
import org.opensearch.ad.rest.RestDeleteAnomalyResultsAction;
import org.opensearch.ad.rest.RestExecuteAnomalyDetectorAction;
import org.opensearch.ad.rest.RestGetAnomalyDetectorAction;
import org.opensearch.ad.rest.RestIndexAnomalyDetectorAction;
import org.opensearch.ad.rest.RestPreviewAnomalyDetectorAction;
import org.opensearch.ad.rest.RestSearchADTasksAction;
import org.opensearch.ad.rest.RestSearchAnomalyDetectorAction;
import org.opensearch.ad.rest.RestSearchAnomalyDetectorInfoAction;
import org.opensearch.ad.rest.RestSearchAnomalyResultAction;
import org.opensearch.ad.rest.RestSearchTopAnomalyResultAction;
import org.opensearch.ad.rest.RestStatsAnomalyDetectorAction;
import org.opensearch.ad.rest.RestValidateAnomalyDetectorAction;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.settings.LegacyOpenDistroAnomalyDetectorSettings;
import org.opensearch.ad.settings.NumericSetting;
import org.opensearch.ad.stats.ADStat;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.StatNames;
import org.opensearch.ad.stats.suppliers.CounterSupplier;
import org.opensearch.ad.stats.suppliers.IndexStatusSupplier;
import org.opensearch.ad.stats.suppliers.ModelsOnNodeCountSupplier;
import org.opensearch.ad.stats.suppliers.ModelsOnNodeSupplier;
import org.opensearch.ad.stats.suppliers.SettableSupplier;
import org.opensearch.ad.task.ADBatchTaskRunner;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADBatchAnomalyResultAction;
import org.opensearch.ad.transport.ADBatchAnomalyResultTransportAction;
import org.opensearch.ad.transport.ADBatchTaskRemoteExecutionAction;
import org.opensearch.ad.transport.ADBatchTaskRemoteExecutionTransportAction;
import org.opensearch.ad.transport.ADCancelTaskAction;
import org.opensearch.ad.transport.ADCancelTaskTransportAction;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkTransportAction;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.ad.transport.ADStatsNodesTransportAction;
import org.opensearch.ad.transport.ADTaskProfileAction;
import org.opensearch.ad.transport.ADTaskProfileTransportAction;
import org.opensearch.ad.transport.AnomalyDetectorJobAction;
import org.opensearch.ad.transport.AnomalyDetectorJobTransportAction;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultTransportAction;
import org.opensearch.ad.transport.CronAction;
import org.opensearch.ad.transport.CronTransportAction;
import org.opensearch.ad.transport.DeleteAnomalyDetectorAction;
import org.opensearch.ad.transport.DeleteAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.DeleteAnomalyResultsAction;
import org.opensearch.ad.transport.DeleteAnomalyResultsTransportAction;
import org.opensearch.ad.transport.DeleteModelAction;
import org.opensearch.ad.transport.DeleteModelTransportAction;
import org.opensearch.ad.transport.EntityProfileAction;
import org.opensearch.ad.transport.EntityProfileTransportAction;
import org.opensearch.ad.transport.EntityResultAction;
import org.opensearch.ad.transport.EntityResultTransportAction;
import org.opensearch.ad.transport.ForwardADTaskAction;
import org.opensearch.ad.transport.ForwardADTaskTransportAction;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.GetAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.IndexAnomalyDetectorAction;
import org.opensearch.ad.transport.IndexAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.ProfileAction;
import org.opensearch.ad.transport.ProfileTransportAction;
import org.opensearch.ad.transport.RCFPollingAction;
import org.opensearch.ad.transport.RCFPollingTransportAction;
import org.opensearch.ad.transport.RCFResultAction;
import org.opensearch.ad.transport.RCFResultTransportAction;
import org.opensearch.ad.transport.SearchADTasksAction;
import org.opensearch.ad.transport.SearchADTasksTransportAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoTransportAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.ad.transport.SearchAnomalyResultTransportAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultTransportAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.StopDetectorAction;
import org.opensearch.ad.transport.StopDetectorTransportAction;
import org.opensearch.ad.transport.ThresholdResultAction;
import org.opensearch.ad.transport.ThresholdResultTransportAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.handler.ADSearchHandler;
import org.opensearch.ad.transport.handler.AnomalyIndexHandler;
import org.opensearch.ad.transport.handler.AnomalyResultBulkIndexHandler;
import org.opensearch.ad.transport.handler.MultiEntityResultHandler;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.ad.util.IndexUtils;
import org.opensearch.ad.util.Throttler;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class AnomalyDetectorPlugin
extends Plugin
implements ActionPlugin,
ScriptPlugin,
JobSchedulerExtension {
    private static final Logger LOG = LogManager.getLogger(AnomalyDetectorPlugin.class);
    public static final String LEGACY_AD_BASE = "/_opendistro/_anomaly_detection";
    public static final String LEGACY_OPENDISTRO_AD_BASE_URI = "/_opendistro/_anomaly_detection/detectors";
    public static final String AD_BASE_URI = "/_plugins/_anomaly_detection";
    public static final String AD_BASE_DETECTORS_URI = "/_plugins/_anomaly_detection/detectors";
    public static final String AD_THREAD_POOL_PREFIX = "opensearch.ad.";
    public static final String AD_THREAD_POOL_NAME = "ad-threadpool";
    public static final String AD_BATCH_TASK_THREAD_POOL_NAME = "ad-batch-task-threadpool";
    public static final String AD_JOB_TYPE = "opendistro_anomaly_detector";
    private static Gson gson;
    private AnomalyDetectionIndices anomalyDetectionIndices;
    private AnomalyDetectorRunner anomalyDetectorRunner;
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private ADStats adStats;
    private ClientUtil clientUtil;
    private DiscoveryNodeFilterer nodeFilter;
    private IndexUtils indexUtils;
    private ADTaskManager adTaskManager;
    private ADBatchTaskRunner adBatchTaskRunner;
    GenericObjectPool<LinkedBuffer> serializeRCFBufferPool;
    private NodeStateManager stateManager;
    private ExecuteADResultResponseRecorder adResultResponseRecorder;

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        AnomalyDetectorJobRunner jobRunner = AnomalyDetectorJobRunner.getJobRunnerInstance();
        jobRunner.setClient(this.client);
        jobRunner.setThreadPool(this.threadPool);
        jobRunner.setSettings(settings);
        jobRunner.setAnomalyDetectionIndices(this.anomalyDetectionIndices);
        jobRunner.setAdTaskManager(this.adTaskManager);
        jobRunner.setNodeStateManager(this.stateManager);
        jobRunner.setExecuteADResultResponseRecorder(this.adResultResponseRecorder);
        RestGetAnomalyDetectorAction restGetAnomalyDetectorAction = new RestGetAnomalyDetectorAction();
        RestIndexAnomalyDetectorAction restIndexAnomalyDetectorAction = new RestIndexAnomalyDetectorAction(settings, this.clusterService);
        RestSearchAnomalyDetectorAction searchAnomalyDetectorAction = new RestSearchAnomalyDetectorAction();
        RestSearchAnomalyResultAction searchAnomalyResultAction = new RestSearchAnomalyResultAction();
        RestSearchADTasksAction searchADTasksAction = new RestSearchADTasksAction();
        RestDeleteAnomalyDetectorAction deleteAnomalyDetectorAction = new RestDeleteAnomalyDetectorAction();
        RestExecuteAnomalyDetectorAction executeAnomalyDetectorAction = new RestExecuteAnomalyDetectorAction(settings, this.clusterService);
        RestStatsAnomalyDetectorAction statsAnomalyDetectorAction = new RestStatsAnomalyDetectorAction(this.adStats, this.nodeFilter);
        RestAnomalyDetectorJobAction anomalyDetectorJobAction = new RestAnomalyDetectorJobAction(settings, this.clusterService);
        RestSearchAnomalyDetectorInfoAction searchAnomalyDetectorInfoAction = new RestSearchAnomalyDetectorInfoAction();
        RestPreviewAnomalyDetectorAction previewAnomalyDetectorAction = new RestPreviewAnomalyDetectorAction();
        RestDeleteAnomalyResultsAction deleteAnomalyResultsAction = new RestDeleteAnomalyResultsAction();
        RestSearchTopAnomalyResultAction searchTopAnomalyResultAction = new RestSearchTopAnomalyResultAction();
        RestValidateAnomalyDetectorAction validateAnomalyDetectorAction = new RestValidateAnomalyDetectorAction(settings, this.clusterService);
        return ImmutableList.of((Object)((Object)restGetAnomalyDetectorAction), (Object)((Object)restIndexAnomalyDetectorAction), (Object)((Object)searchAnomalyDetectorAction), (Object)((Object)searchAnomalyResultAction), (Object)((Object)searchADTasksAction), (Object)((Object)deleteAnomalyDetectorAction), (Object)((Object)executeAnomalyDetectorAction), (Object)((Object)anomalyDetectorJobAction), (Object)((Object)statsAnomalyDetectorAction), (Object)((Object)searchAnomalyDetectorInfoAction), (Object)((Object)previewAnomalyDetectorAction), (Object)((Object)deleteAnomalyResultsAction), (Object[])new RestHandler[]{searchTopAnomalyResultAction, validateAnomalyDetectorAction});
    }

    private static Void initGson() {
        gson = new GsonBuilder().serializeSpecialFloatingPointValues().create();
        return null;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        EnabledSetting.getInstance().init(clusterService);
        NumericSetting.getInstance().init(clusterService);
        this.client = client;
        this.threadPool = threadPool;
        Settings settings = environment.settings();
        Throttler throttler = new Throttler(this.getClock());
        this.clientUtil = new ClientUtil(settings, client, throttler, threadPool);
        this.indexUtils = new IndexUtils(client, this.clientUtil, clusterService, indexNameExpressionResolver);
        this.nodeFilter = new DiscoveryNodeFilterer(clusterService);
        this.anomalyDetectionIndices = new AnomalyDetectionIndices(client, clusterService, threadPool, settings, this.nodeFilter, AnomalyDetectorSettings.MAX_UPDATE_RETRY_TIMES);
        this.clusterService = clusterService;
        IntegerSensitiveSingleFeatureLinearUniformInterpolator singleFeatureLinearUniformInterpolator = new IntegerSensitiveSingleFeatureLinearUniformInterpolator();
        LinearUniformInterpolator interpolator = new LinearUniformInterpolator(singleFeatureLinearUniformInterpolator);
        SearchFeatureDao searchFeatureDao = new SearchFeatureDao(client, xContentRegistry, interpolator, this.clientUtil, settings, clusterService, 256);
        JvmService jvmService = new JvmService(environment.settings());
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        mapper.setSaveTreeStateEnabled(true);
        mapper.setPartialTreeStateEnabled(true);
        V1JsonToV3StateConverter converter = new V1JsonToV3StateConverter();
        double modelMaxSizePercent = (Double)AnomalyDetectorSettings.MODEL_MAX_SIZE_PERCENTAGE.get(settings);
        ADCircuitBreakerService adCircuitBreakerService = new ADCircuitBreakerService(jvmService).init();
        MemoryTracker memoryTracker = new MemoryTracker(jvmService, modelMaxSizePercent, 0.002, clusterService, adCircuitBreakerService);
        this.stateManager = new NodeStateManager(client, xContentRegistry, settings, this.clientUtil, this.getClock(), AnomalyDetectorSettings.HOURLY_MAINTENANCE, clusterService);
        FeatureManager featureManager = new FeatureManager(searchFeatureDao, interpolator, this.getClock(), 24, 64, 24, 512, 0.25, 2, 0.25, 300, AnomalyDetectorSettings.HOURLY_MAINTENANCE, threadPool, AD_THREAD_POOL_NAME);
        long heapSizeBytes = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
        this.serializeRCFBufferPool = AccessController.doPrivileged(new PrivilegedAction<GenericObjectPool<LinkedBuffer>>(){

            @Override
            public GenericObjectPool<LinkedBuffer> run() {
                return new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<LinkedBuffer>(){

                    public LinkedBuffer create() throws Exception {
                        return LinkedBuffer.allocate((int)512);
                    }

                    public PooledObject<LinkedBuffer> wrap(LinkedBuffer obj) {
                        return new DefaultPooledObject((Object)obj);
                    }
                });
            }
        });
        this.serializeRCFBufferPool.setMaxTotal(20);
        this.serializeRCFBufferPool.setMaxIdle(20);
        this.serializeRCFBufferPool.setMinIdle(0);
        this.serializeRCFBufferPool.setBlockWhenExhausted(false);
        this.serializeRCFBufferPool.setTimeBetweenEvictionRuns(AnomalyDetectorSettings.HOURLY_MAINTENANCE);
        CheckpointDao checkpoint = new CheckpointDao(client, this.clientUtil, ".opendistro-anomaly-checkpoints", gson, mapper, converter, new ThresholdedRandomCutForestMapper(), (Schema<ThresholdedRandomCutForestState>)AccessController.doPrivileged(() -> RuntimeSchema.getSchema(ThresholdedRandomCutForestState.class)), HybridThresholdingModel.class, this.anomalyDetectionIndices, 30000000, this.serializeRCFBufferPool, 512, 0.0050000000000000044);
        Random random = new Random(42L);
        CacheProvider cacheProvider = new CacheProvider();
        CheckPointMaintainRequestAdapter adapter = new CheckPointMaintainRequestAdapter(cacheProvider, checkpoint, ".opendistro-anomaly-checkpoints", AnomalyDetectorSettings.CHECKPOINT_SAVING_FREQ, this.getClock(), clusterService, settings);
        CheckpointWriteWorker checkpointWriteQueue = new CheckpointWriteWorker(heapSizeBytes, AnomalyDetectorSettings.CHECKPOINT_WRITE_QUEUE_SIZE_IN_BYTES, AnomalyDetectorSettings.CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, AnomalyDetectorSettings.QUEUE_MAINTENANCE, checkpoint, ".opendistro-anomaly-checkpoints", AnomalyDetectorSettings.HOURLY_MAINTENANCE, this.stateManager, AnomalyDetectorSettings.HOURLY_MAINTENANCE);
        CheckpointMaintainWorker checkpointMaintainQueue = new CheckpointMaintainWorker(heapSizeBytes, AnomalyDetectorSettings.CHECKPOINT_MAINTAIN_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, checkpointWriteQueue, AnomalyDetectorSettings.HOURLY_MAINTENANCE, this.stateManager, adapter);
        PriorityCache cache = new PriorityCache(checkpoint, (Integer)AnomalyDetectorSettings.DEDICATED_CACHE_SIZE.get(settings), AnomalyDetectorSettings.CHECKPOINT_TTL, 1000000, memoryTracker, 30, this.getClock(), clusterService, AnomalyDetectorSettings.HOURLY_MAINTENANCE, threadPool, checkpointWriteQueue, 10000, checkpointMaintainQueue, settings, AnomalyDetectorSettings.CHECKPOINT_SAVING_FREQ);
        cacheProvider.set(cache);
        EntityColdStarter entityColdStarter = new EntityColdStarter(this.getClock(), threadPool, this.stateManager, 256, 30, 1.0E-4, 32, 64, 24, interpolator, searchFeatureDao, 0.995, featureManager, settings, AnomalyDetectorSettings.HOURLY_MAINTENANCE, checkpointWriteQueue, AnomalyDetectorSettings.MAX_COLD_START_ROUNDS);
        EntityColdStartWorker coldstartQueue = new EntityColdStartWorker(heapSizeBytes, AnomalyDetectorSettings.ENTITY_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.ENTITY_COLD_START_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, AnomalyDetectorSettings.QUEUE_MAINTENANCE, entityColdStarter, AnomalyDetectorSettings.HOURLY_MAINTENANCE, this.stateManager, cacheProvider);
        ModelManager modelManager = new ModelManager(checkpoint, this.getClock(), 30, 256, 1.0E-4, 32, 0.995, 400, AnomalyDetectorSettings.HOURLY_MAINTENANCE, AnomalyDetectorSettings.CHECKPOINT_SAVING_FREQ, entityColdStarter, featureManager, memoryTracker, settings, clusterService);
        MultiEntityResultHandler multiEntityResultHandler = new MultiEntityResultHandler(client, settings, threadPool, this.anomalyDetectionIndices, this.clientUtil, this.indexUtils, clusterService);
        ResultWriteWorker resultWriteQueue = new ResultWriteWorker(heapSizeBytes, AnomalyDetectorSettings.RESULT_WRITE_QUEUE_SIZE_IN_BYTES, AnomalyDetectorSettings.RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, AnomalyDetectorSettings.QUEUE_MAINTENANCE, multiEntityResultHandler, xContentRegistry, this.stateManager, AnomalyDetectorSettings.HOURLY_MAINTENANCE);
        ImmutableMap stats = ImmutableMap.builder().put((Object)StatNames.AD_EXECUTE_REQUEST_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_EXECUTE_FAIL_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_HC_EXECUTE_REQUEST_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_HC_EXECUTE_FAIL_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.MODEL_INFORMATION.getName(), new ADStat<List<Map<String, Object>>>(false, new ModelsOnNodeSupplier(modelManager, cacheProvider, settings, clusterService))).put((Object)StatNames.ANOMALY_DETECTORS_INDEX_STATUS.getName(), new ADStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detectors"))).put((Object)StatNames.ANOMALY_RESULTS_INDEX_STATUS.getName(), new ADStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-results"))).put((Object)StatNames.MODELS_CHECKPOINT_INDEX_STATUS.getName(), new ADStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-checkpoints"))).put((Object)StatNames.ANOMALY_DETECTION_JOB_INDEX_STATUS.getName(), new ADStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detector-jobs"))).put((Object)StatNames.ANOMALY_DETECTION_STATE_STATUS.getName(), new ADStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detection-state"))).put((Object)StatNames.DETECTOR_COUNT.getName(), new ADStat<Long>(true, new SettableSupplier())).put((Object)StatNames.SINGLE_ENTITY_DETECTOR_COUNT.getName(), new ADStat<Long>(true, new SettableSupplier())).put((Object)StatNames.MULTI_ENTITY_DETECTOR_COUNT.getName(), new ADStat<Long>(true, new SettableSupplier())).put((Object)StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_CANCELED_BATCH_TASK_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_TOTAL_BATCH_TASK_EXECUTION_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_BATCH_TASK_FAILURE_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).put((Object)StatNames.MODEL_COUNT.getName(), new ADStat<Long>(false, new ModelsOnNodeCountSupplier(modelManager, cacheProvider))).put((Object)StatNames.MODEL_CORRUTPION_COUNT.getName(), new ADStat<Long>(false, new CounterSupplier())).build();
        this.adStats = new ADStats((Map<String, ADStat<?>>)stats);
        CheckpointReadWorker checkpointReadQueue = new CheckpointReadWorker(heapSizeBytes, AnomalyDetectorSettings.ENTITY_FEATURE_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, AnomalyDetectorSettings.QUEUE_MAINTENANCE, modelManager, checkpoint, coldstartQueue, resultWriteQueue, this.stateManager, this.anomalyDetectionIndices, cacheProvider, AnomalyDetectorSettings.HOURLY_MAINTENANCE, checkpointWriteQueue, this.adStats);
        ColdEntityWorker coldEntityQueue = new ColdEntityWorker(heapSizeBytes, AnomalyDetectorSettings.ENTITY_FEATURE_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, clusterService, random, adCircuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, checkpointReadQueue, AnomalyDetectorSettings.HOURLY_MAINTENANCE, this.stateManager);
        ADDataMigrator dataMigrator = new ADDataMigrator(client, clusterService, xContentRegistry, this.anomalyDetectionIndices);
        HashRing hashRing = new HashRing(this.nodeFilter, this.getClock(), settings, client, clusterService, dataMigrator, modelManager);
        this.anomalyDetectorRunner = new AnomalyDetectorRunner(modelManager, featureManager, 1000);
        ADTaskCacheManager adTaskCacheManager = new ADTaskCacheManager(settings, clusterService, memoryTracker);
        this.adTaskManager = new ADTaskManager(settings, clusterService, client, xContentRegistry, this.anomalyDetectionIndices, this.nodeFilter, hashRing, adTaskCacheManager, threadPool);
        AnomalyResultBulkIndexHandler anomalyResultBulkIndexHandler = new AnomalyResultBulkIndexHandler(client, settings, threadPool, this.clientUtil, this.indexUtils, clusterService, this.anomalyDetectionIndices);
        this.adBatchTaskRunner = new ADBatchTaskRunner(settings, threadPool, clusterService, client, adCircuitBreakerService, featureManager, this.adTaskManager, this.anomalyDetectionIndices, this.adStats, anomalyResultBulkIndexHandler, adTaskCacheManager, searchFeatureDao, hashRing, modelManager);
        ADSearchHandler adSearchHandler = new ADSearchHandler(settings, clusterService, client);
        AnomalyIndexHandler<AnomalyResult> anomalyResultHandler = new AnomalyIndexHandler<AnomalyResult>(client, settings, threadPool, ".opendistro-anomaly-results", this.anomalyDetectionIndices, this.clientUtil, this.indexUtils, clusterService);
        this.adResultResponseRecorder = new ExecuteADResultResponseRecorder(this.anomalyDetectionIndices, anomalyResultHandler, this.adTaskManager, this.nodeFilter, threadPool, client, this.stateManager, adTaskCacheManager, 32);
        return ImmutableList.of((Object)this.anomalyDetectionIndices, (Object)this.anomalyDetectorRunner, (Object)searchFeatureDao, (Object)singleFeatureLinearUniformInterpolator, (Object)interpolator, (Object)gson, (Object)jvmService, (Object)hashRing, (Object)featureManager, (Object)modelManager, (Object)this.stateManager, (Object)new ADClusterEventListener(clusterService, hashRing), (Object[])new Object[]{adCircuitBreakerService, this.adStats, new ClusterManagerEventListener(clusterService, threadPool, client, this.getClock(), this.clientUtil, this.nodeFilter, AnomalyDetectorSettings.CHECKPOINT_TTL, settings), this.nodeFilter, multiEntityResultHandler, checkpoint, cacheProvider, this.adTaskManager, this.adBatchTaskRunner, adSearchHandler, coldstartQueue, resultWriteQueue, checkpointReadQueue, checkpointWriteQueue, coldEntityQueue, entityColdStarter, adTaskCacheManager, this.adResultResponseRecorder});
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return ImmutableList.of((Object)new ScalingExecutorBuilder(AD_THREAD_POOL_NAME, 1, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) / 2), TimeValue.timeValueMinutes((long)10L), "opensearch.ad.ad-threadpool"), (Object)new ScalingExecutorBuilder(AD_BATCH_TASK_THREAD_POOL_NAME, 1, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) / 8), TimeValue.timeValueMinutes((long)10L), "opensearch.ad.ad-batch-task-threadpool"));
    }

    public List<Setting<?>> getSettings() {
        List<Setting<?>> enabledSetting = EnabledSetting.getInstance().getSettings();
        List<Setting<?>> numericSetting = NumericSetting.getInstance().getSettings();
        ImmutableList systemSetting = ImmutableList.of(LegacyOpenDistroAnomalyDetectorSettings.MAX_CACHE_MISS_HANDLING_PER_SECOND, AnomalyDetectorSettings.DEDICATED_CACHE_SIZE, LegacyOpenDistroAnomalyDetectorSettings.DETECTION_INTERVAL, LegacyOpenDistroAnomalyDetectorSettings.DETECTION_WINDOW_DELAY, LegacyOpenDistroAnomalyDetectorSettings.MAX_ANOMALY_FEATURES, AnomalyDetectorSettings.DETECTION_INTERVAL, AnomalyDetectorSettings.DETECTION_WINDOW_DELAY, AnomalyDetectorSettings.MAX_ANOMALY_FEATURES, LegacyOpenDistroAnomalyDetectorSettings.REQUEST_TIMEOUT, LegacyOpenDistroAnomalyDetectorSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, LegacyOpenDistroAnomalyDetectorSettings.COOLDOWN_MINUTES, LegacyOpenDistroAnomalyDetectorSettings.BACKOFF_MINUTES, (Object[])new Setting[]{LegacyOpenDistroAnomalyDetectorSettings.BACKOFF_INITIAL_DELAY, LegacyOpenDistroAnomalyDetectorSettings.MAX_RETRY_FOR_BACKOFF, AnomalyDetectorSettings.REQUEST_TIMEOUT, AnomalyDetectorSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, AnomalyDetectorSettings.COOLDOWN_MINUTES, AnomalyDetectorSettings.BACKOFF_MINUTES, AnomalyDetectorSettings.BACKOFF_INITIAL_DELAY, AnomalyDetectorSettings.MAX_RETRY_FOR_BACKOFF, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD, AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, LegacyOpenDistroAnomalyDetectorSettings.MODEL_MAX_SIZE_PERCENTAGE, LegacyOpenDistroAnomalyDetectorSettings.MAX_SINGLE_ENTITY_ANOMALY_DETECTORS, LegacyOpenDistroAnomalyDetectorSettings.MAX_MULTI_ENTITY_ANOMALY_DETECTORS, LegacyOpenDistroAnomalyDetectorSettings.INDEX_PRESSURE_SOFT_LIMIT, LegacyOpenDistroAnomalyDetectorSettings.MAX_PRIMARY_SHARDS, AnomalyDetectorSettings.MODEL_MAX_SIZE_PERCENTAGE, AnomalyDetectorSettings.MAX_SINGLE_ENTITY_ANOMALY_DETECTORS, AnomalyDetectorSettings.MAX_MULTI_ENTITY_ANOMALY_DETECTORS, AnomalyDetectorSettings.INDEX_PRESSURE_SOFT_LIMIT, AnomalyDetectorSettings.INDEX_PRESSURE_HARD_LIMIT, AnomalyDetectorSettings.MAX_PRIMARY_SHARDS, LegacyOpenDistroAnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, LegacyOpenDistroAnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, LegacyOpenDistroAnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS, LegacyOpenDistroAnomalyDetectorSettings.MAX_OLD_AD_TASK_DOCS_PER_DETECTOR, LegacyOpenDistroAnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE, AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, AnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS, AnomalyDetectorSettings.MAX_OLD_AD_TASK_DOCS_PER_DETECTOR, AnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE, AnomalyDetectorSettings.MAX_TOP_ENTITIES_FOR_HISTORICAL_ANALYSIS, AnomalyDetectorSettings.MAX_RUNNING_ENTITIES_PER_DETECTOR_FOR_HISTORICAL_ANALYSIS, AnomalyDetectorSettings.MAX_CACHED_DELETED_TASKS, AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_CONCURRENCY, AnomalyDetectorSettings.CHECKPOINT_WRITE_QUEUE_CONCURRENCY, AnomalyDetectorSettings.ENTITY_COLD_START_QUEUE_CONCURRENCY, AnomalyDetectorSettings.RESULT_WRITE_QUEUE_CONCURRENCY, AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.CHECKPOINT_WRITE_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.RESULT_WRITE_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.ENTITY_COLD_START_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_MILLISECS, AnomalyDetectorSettings.EXPECTED_CHECKPOINT_MAINTAIN_TIME_IN_MILLISECS, AnomalyDetectorSettings.CHECKPOINT_SAVING_FREQ, AnomalyDetectorSettings.CHECKPOINT_TTL, LegacyOpenDistroAnomalyDetectorSettings.MAX_ENTITIES_PER_QUERY, LegacyOpenDistroAnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW, AnomalyDetectorSettings.MAX_ENTITIES_PER_QUERY, AnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW, AnomalyDetectorSettings.MAX_CONCURRENT_PREVIEW, AnomalyDetectorSettings.PAGE_SIZE, AnomalyDetectorSettings.DELETE_AD_RESULT_WHEN_DELETE_DETECTOR, AnomalyDetectorSettings.MAX_MODEL_SIZE_PER_NODE});
        return Collections.unmodifiableList(Stream.of(enabledSetting.stream(), systemSetting.stream(), numericSetting.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList()));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return ImmutableList.of((Object)AnomalyDetector.XCONTENT_REGISTRY, (Object)AnomalyResult.XCONTENT_REGISTRY, (Object)DetectorInternalState.XCONTENT_REGISTRY, (Object)AnomalyDetectorJob.XCONTENT_REGISTRY);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)DeleteModelAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopDetectorAction.INSTANCE, StopDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RCFResultAction.INSTANCE, RCFResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ThresholdResultAction.INSTANCE, ThresholdResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AnomalyResultAction.INSTANCE, AnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CronAction.INSTANCE, CronTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADStatsNodesAction.INSTANCE, ADStatsNodesTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ProfileAction.INSTANCE, ProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RCFPollingAction.INSTANCE, RCFPollingTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyDetectorAction.INSTANCE, SearchAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyResultAction.INSTANCE, SearchAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchADTasksAction.INSTANCE, SearchADTasksTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StatsAnomalyDetectorAction.INSTANCE, StatsAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAnomalyDetectorAction.INSTANCE, DeleteAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAnomalyDetectorAction.INSTANCE, GetAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexAnomalyDetectorAction.INSTANCE, IndexAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AnomalyDetectorJobAction.INSTANCE, AnomalyDetectorJobTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADResultBulkAction.INSTANCE, ADResultBulkTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EntityResultAction.INSTANCE, EntityResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EntityProfileAction.INSTANCE, EntityProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyDetectorInfoAction.INSTANCE, SearchAnomalyDetectorInfoTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewAnomalyDetectorAction.INSTANCE, PreviewAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADBatchAnomalyResultAction.INSTANCE, ADBatchAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADBatchTaskRemoteExecutionAction.INSTANCE, ADBatchTaskRemoteExecutionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADTaskProfileAction.INSTANCE, ADTaskProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADCancelTaskAction.INSTANCE, ADCancelTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForwardADTaskAction.INSTANCE, ForwardADTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAnomalyResultsAction.INSTANCE, DeleteAnomalyResultsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchTopAnomalyResultAction.INSTANCE, SearchTopAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateAnomalyDetectorAction.INSTANCE, ValidateAnomalyDetectorTransportAction.class, new Class[0]));
    }

    public String getJobType() {
        return AD_JOB_TYPE;
    }

    public String getJobIndex() {
        return ".opendistro-anomaly-detector-jobs";
    }

    public ScheduledJobRunner getJobRunner() {
        return AnomalyDetectorJobRunner.getJobRunnerInstance();
    }

    public ScheduledJobParser getJobParser() {
        return (parser, id, jobDocVersion) -> {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            return AnomalyDetectorJob.parse(parser);
        };
    }

    public void close() {
        if (this.serializeRCFBufferPool != null) {
            try {
                AccessController.doPrivileged(() -> {
                    this.serializeRCFBufferPool.clear();
                    this.serializeRCFBufferPool.close();
                    return null;
                });
                this.serializeRCFBufferPool = null;
            }
            catch (Exception e) {
                LOG.error("Failed to shut down object Pool", (Throwable)e);
            }
        }
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(AnomalyDetectorPlugin::initGson);
    }
}

