/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.ExecuteADResultResponseRecorder;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.DetectionDateRange;
import org.opensearch.ad.rest.handler.IndexAnomalyDetectorJobActionHandler;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyDetectorJobAction;
import org.opensearch.ad.transport.AnomalyDetectorJobRequest;
import org.opensearch.ad.transport.AnomalyDetectorJobResponse;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.commons.authuser.User;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class AnomalyDetectorJobTransportAction
extends HandledTransportAction<AnomalyDetectorJobRequest, AnomalyDetectorJobResponse> {
    private final Logger logger = LogManager.getLogger(AnomalyDetectorJobTransportAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final AnomalyDetectionIndices anomalyDetectionIndices;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final ADTaskManager adTaskManager;
    private final TransportService transportService;
    private final ExecuteADResultResponseRecorder recorder;

    @Inject
    public AnomalyDetectorJobTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, Settings settings, AnomalyDetectionIndices anomalyDetectionIndices, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager, ExecuteADResultResponseRecorder recorder) {
        super(AnomalyDetectorJobAction.NAME, transportService, actionFilters, AnomalyDetectorJobRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.xContentRegistry = xContentRegistry;
        this.adTaskManager = adTaskManager;
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.recorder = recorder;
    }

    protected void doExecute(Task task, AnomalyDetectorJobRequest request, ActionListener<AnomalyDetectorJobResponse> actionListener) {
        String detectorId = request.getDetectorID();
        DetectionDateRange detectionDateRange = request.getDetectionDateRange();
        boolean historical = request.isHistorical();
        long seqNo = request.getSeqNo();
        long primaryTerm = request.getPrimaryTerm();
        String rawPath = request.getRawPath();
        TimeValue requestTimeout = (TimeValue)AnomalyDetectorSettings.REQUEST_TIMEOUT.get(this.settings);
        String errorMessage = rawPath.endsWith("_start") ? CommonErrorMessages.FAIL_TO_START_DETECTOR : CommonErrorMessages.FAIL_TO_STOP_DETECTOR;
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, errorMessage);
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, detectorId, this.filterByEnabled, listener, anomalyDetector -> this.executeDetector((ActionListener<AnomalyDetectorJobResponse>)listener, detectorId, detectionDateRange, historical, seqNo, primaryTerm, rawPath, requestTimeout, user, context), this.client, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void executeDetector(ActionListener<AnomalyDetectorJobResponse> listener, String detectorId, DetectionDateRange detectionDateRange, boolean historical, long seqNo, long primaryTerm, String rawPath, TimeValue requestTimeout, User user, ThreadContext.StoredContext context) {
        IndexAnomalyDetectorJobActionHandler handler = new IndexAnomalyDetectorJobActionHandler(this.client, this.anomalyDetectionIndices, detectorId, seqNo, primaryTerm, requestTimeout, this.xContentRegistry, this.transportService, this.adTaskManager, this.recorder);
        if (rawPath.endsWith("_start")) {
            this.adTaskManager.startDetector(detectorId, detectionDateRange, handler, user, this.transportService, context, listener);
        } else if (rawPath.endsWith("_stop")) {
            this.adTaskManager.stopDetector(detectorId, historical, handler, user, this.transportService, listener);
        }
    }
}

