/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.utils.OpenForTesting;
import org.opensearch.replication.ReplicationPlugin;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R$\u0010\u0015\u001a\n \r*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\n \r*\u0004\u0018\u00010\u001c0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\n \r*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010\u0019R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000f\"\u0004\b,\u0010\u0011R\"\u0010-\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000f\"\u0004\b/\u0010\u0011R\u001a\u00100\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000f\"\u0004\b2\u0010\u0011R$\u00103\u001a\n \r*\u0004\u0018\u00010\u00060\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b4\u0010\u0017\"\u0004\b5\u0010\u0019\u00a8\u0006:"}, d2={"Lorg/opensearch/replication/ReplicationSettings;", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/cluster/service/ClusterService;)V", "autofollowConcurrentJobsTriggerSize", "", "getAutofollowConcurrentJobsTriggerSize", "()I", "setAutofollowConcurrentJobsTriggerSize", "(I)V", "autofollowFetchPollDuration", "Lorg/opensearch/common/unit/TimeValue;", "kotlin.jvm.PlatformType", "getAutofollowFetchPollDuration", "()Lorg/opensearch/common/unit/TimeValue;", "setAutofollowFetchPollDuration", "(Lorg/opensearch/common/unit/TimeValue;)V", "autofollowRetryPollDuration", "getAutofollowRetryPollDuration", "setAutofollowRetryPollDuration", "batchSize", "getBatchSize", "()Ljava/lang/Integer;", "setBatchSize", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "chunkSize", "Lorg/opensearch/common/unit/ByteSizeValue;", "getChunkSize", "()Lorg/opensearch/common/unit/ByteSizeValue;", "setChunkSize", "(Lorg/opensearch/common/unit/ByteSizeValue;)V", "concurrentFileChunks", "getConcurrentFileChunks", "setConcurrentFileChunks", "followerBlockStart", "", "getFollowerBlockStart", "()Z", "setFollowerBlockStart", "(Z)V", "leaseRenewalMaxFailureDuration", "getLeaseRenewalMaxFailureDuration", "setLeaseRenewalMaxFailureDuration", "metadataSyncInterval", "getMetadataSyncInterval", "setMetadataSyncInterval", "pollDuration", "getPollDuration", "setPollDuration", "readersPerShard", "getReadersPerShard", "setReadersPerShard", "listenForUpdates", "", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "opensearch-cross-cluster-replication"})
public class ReplicationSettings {
    private volatile ByteSizeValue chunkSize;
    private volatile Integer concurrentFileChunks;
    private volatile Integer readersPerShard;
    private volatile Integer batchSize;
    @NotNull
    private volatile TimeValue pollDuration;
    private volatile TimeValue autofollowFetchPollDuration;
    private volatile TimeValue autofollowRetryPollDuration;
    private volatile TimeValue metadataSyncInterval;
    @NotNull
    private volatile TimeValue leaseRenewalMaxFailureDuration;
    private volatile boolean followerBlockStart;
    private volatile int autofollowConcurrentJobsTriggerSize;

    public ReplicationSettings(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.chunkSize = (ByteSizeValue)ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE().get(clusterService.getSettings());
        this.concurrentFileChunks = (Integer)ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS().get(clusterService.getSettings());
        this.readersPerShard = (Integer)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD());
        this.batchSize = (Integer)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE());
        Object object = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_PARALLEL_READ_POLL_INTERVAL());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.clusterSe\u2026ALLEL_READ_POLL_INTERVAL)");
        this.pollDuration = (TimeValue)object;
        this.autofollowFetchPollDuration = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL());
        this.autofollowRetryPollDuration = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL());
        this.metadataSyncInterval = (TimeValue)clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_METADATA_SYNC_INTERVAL());
        object = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.clusterSe\u2026ASE_MAX_FAILURE_DURATION)");
        this.leaseRenewalMaxFailureDuration = (TimeValue)object;
        object = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_BLOCK_START());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.clusterSe\u2026ION_FOLLOWER_BLOCK_START)");
        this.followerBlockStart = (Boolean)object;
        object = clusterService.getClusterSettings().get(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.clusterSe\u2026CATION_JOBS_TRIGGER_SIZE)");
        this.autofollowConcurrentJobsTriggerSize = ((Number)object).intValue();
        object = clusterService.getClusterSettings();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clusterService.clusterSettings");
        this.listenForUpdates((ClusterSettings)object);
    }

    public final ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    public final void setChunkSize(ByteSizeValue byteSizeValue) {
        this.chunkSize = byteSizeValue;
    }

    public final Integer getConcurrentFileChunks() {
        return this.concurrentFileChunks;
    }

    public final void setConcurrentFileChunks(Integer n) {
        this.concurrentFileChunks = n;
    }

    public final Integer getReadersPerShard() {
        return this.readersPerShard;
    }

    public final void setReadersPerShard(Integer n) {
        this.readersPerShard = n;
    }

    public final Integer getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(Integer n) {
        this.batchSize = n;
    }

    @NotNull
    public final TimeValue getPollDuration() {
        return this.pollDuration;
    }

    public final void setPollDuration(@NotNull TimeValue timeValue) {
        Intrinsics.checkNotNullParameter((Object)timeValue, (String)"<set-?>");
        this.pollDuration = timeValue;
    }

    public final TimeValue getAutofollowFetchPollDuration() {
        return this.autofollowFetchPollDuration;
    }

    public final void setAutofollowFetchPollDuration(TimeValue timeValue) {
        this.autofollowFetchPollDuration = timeValue;
    }

    public final TimeValue getAutofollowRetryPollDuration() {
        return this.autofollowRetryPollDuration;
    }

    public final void setAutofollowRetryPollDuration(TimeValue timeValue) {
        this.autofollowRetryPollDuration = timeValue;
    }

    public final TimeValue getMetadataSyncInterval() {
        return this.metadataSyncInterval;
    }

    public final void setMetadataSyncInterval(TimeValue timeValue) {
        this.metadataSyncInterval = timeValue;
    }

    @NotNull
    public final TimeValue getLeaseRenewalMaxFailureDuration() {
        return this.leaseRenewalMaxFailureDuration;
    }

    public final void setLeaseRenewalMaxFailureDuration(@NotNull TimeValue timeValue) {
        Intrinsics.checkNotNullParameter((Object)timeValue, (String)"<set-?>");
        this.leaseRenewalMaxFailureDuration = timeValue;
    }

    public final boolean getFollowerBlockStart() {
        return this.followerBlockStart;
    }

    public final void setFollowerBlockStart(boolean bl) {
        this.followerBlockStart = bl;
    }

    public final int getAutofollowConcurrentJobsTriggerSize() {
        return this.autofollowConcurrentJobsTriggerSize;
    }

    public final void setAutofollowConcurrentJobsTriggerSize(int n) {
        this.autofollowConcurrentJobsTriggerSize = n;
    }

    private final void listenForUpdates(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_CHUNK_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-0(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_RECOVERY_PARALLEL_CHUNKS(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-1(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_CONCURRENT_READERS_PER_SHARD(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-2(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_OPS_BATCH_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-3(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_PARALLEL_READ_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-4(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_RETENTION_LEASE_MAX_FAILURE_DURATION(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-5(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-6(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_REMOTE_INDICES_RETRY_POLL_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-7(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_METADATA_SYNC_INTERVAL(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-8(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_FOLLOWER_BLOCK_START(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-9(this, arg_0));
        clusterSettings.addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_AUTOFOLLOW_CONCURRENT_REPLICATION_JOBS_TRIGGER_SIZE(), arg_0 -> ReplicationSettings.listenForUpdates$lambda-10(this, arg_0));
    }

    private static final void listenForUpdates$lambda-0(ReplicationSettings this$0, ByteSizeValue value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.chunkSize = value;
    }

    private static final void listenForUpdates$lambda-1(ReplicationSettings this$0, int value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.concurrentFileChunks = value;
    }

    private static final void listenForUpdates$lambda-2(ReplicationSettings this$0, int value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.readersPerShard = value;
    }

    private static final void listenForUpdates$lambda-3(ReplicationSettings this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.batchSize = it;
    }

    private static final void listenForUpdates$lambda-4(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.pollDuration = it;
    }

    private static final void listenForUpdates$lambda-5(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.leaseRenewalMaxFailureDuration = it;
    }

    private static final void listenForUpdates$lambda-6(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.autofollowFetchPollDuration = it;
    }

    private static final void listenForUpdates$lambda-7(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.autofollowRetryPollDuration = it;
    }

    private static final void listenForUpdates$lambda-8(ReplicationSettings this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.metadataSyncInterval = it;
    }

    private static final void listenForUpdates$lambda-9(ReplicationSettings this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.followerBlockStart = it;
    }

    private static final void listenForUpdates$lambda-10(ReplicationSettings this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.autofollowConcurrentJobsTriggerSize = it;
    }
}

