"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;

var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));

var _services = require("./services");

var _routes = require("../server/routes");

var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexPatternManagementPlugin {
  async setup(core) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    }); // Initialize services

    const indexService = new _services.IndexService(osDriver);
    const dataStreamService = new _services.DataStreamService(osDriver);
    const policyService = new _services.PolicyService(osDriver);
    const managedIndexService = new _services.ManagedIndexService(osDriver);
    const rollupService = new _services.RollupService(osDriver);
    const transformService = new _services.TransformService(osDriver);
    const notificationService = new _services.NotificationService(osDriver);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver);
    const commonService = new _services.CommonService(osDriver);
    const aliasService = new _services.AliasServices(osDriver);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService,
      commonService,
      aliasService
    }; // create router

    const router = core.http.createRouter(); // Add server routes

    (0, _routes.indices)(services, router);
    (0, _dataStreams.default)(services, router);
    (0, _routes.policies)(services, router);
    (0, _routes.managedIndices)(services, router);
    (0, _routes.rollups)(services, router);
    (0, _routes.transforms)(services, router);
    (0, _routes.notifications)(services, router);
    (0, _routes.snapshotManagement)(services, router);
    (0, _routes.common)(services, router);
    (0, _routes.aliases)(services, router);
    return {};
  }

  async start(core) {
    return {};
  }

}

exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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