"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YELLOW_ORANGE_RED_PALETTE = exports.YELLOW_GREEN_BLUE_PALETTE = exports.SPECTRUM = exports.SINGLE_COLOR_PALETTE = exports.RED_BLUE_PALETTE = exports.REDS_PALETTE = exports.PIE_PALETTES = exports.OPACITY = exports.MULTI_COLOR_PALETTE = exports.HEX_CONTRAST_COLOR = exports.HEATMAP_SINGLE_COLOR = exports.HEATMAP_PALETTE_COLOR = exports.GREYS_PALETTE = exports.GREENS_PALETTE = exports.DEFAULT_PALETTE = exports.COLOR_WHITE = exports.COLOR_PALETTES = exports.COLOR_BLACK = exports.BLUE_RED_PALETTE = exports.BLUES_PALETTE = void 0;

var _eui = require("@elastic/eui");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const BLUES_PALETTE = {
  name: 'Blues',
  label: 'Blues',
  colors: ['rgb(5,10,172)', 'rgb(40,60,190)', 'rgb(70,100,245)', 'rgb(90,120,245)', 'rgb(106,137,247)', 'rgb(220,220,220)']
};
exports.BLUES_PALETTE = BLUES_PALETTE;
const REDS_PALETTE = {
  name: 'Reds',
  label: 'Reds',
  colors: ['rgb(220,220,220)', 'rgb(245,195,157)', 'rgb(245,160,105)', 'rgb(178,10,28)']
};
exports.REDS_PALETTE = REDS_PALETTE;
const GREENS_PALETTE = {
  name: 'Greens',
  label: 'Greens',
  colors: ['rgb(0,68,27)', 'rgb(0,109,44)', 'rgb(35,139,69)', 'rgb(65,171,93)', 'rgb(116,196,118)', 'rgb(161,217,155)', 'rgb(199,233,192)', 'rgb(229,245,224)', 'rgb(247,252,245)']
};
exports.GREENS_PALETTE = GREENS_PALETTE;
const GREYS_PALETTE = {
  name: 'Greys',
  label: 'Greys',
  colors: ['rgb(0,0,0)', 'rgb(255,255,255)']
};
exports.GREYS_PALETTE = GREYS_PALETTE;
const BLUE_RED_PALETTE = {
  name: 'Bluered',
  label: 'Blue-Red',
  colors: ['rgb(0,0,255)', 'rgb(255,0,0)']
};
exports.BLUE_RED_PALETTE = BLUE_RED_PALETTE;
const RED_BLUE_PALETTE = {
  name: 'RdBu',
  label: 'Red-Blue',
  colors: ['rgb(5,10,172)', 'rgb(106,137,247)', 'rgb(190,190,190)', 'rgb(220,170,132)', 'rgb(230,145,90)', 'rgb(178,10,28)']
};
exports.RED_BLUE_PALETTE = RED_BLUE_PALETTE;
const YELLOW_ORANGE_RED_PALETTE = {
  name: 'YlOrRd',
  label: 'Yellow-Orange-Red',
  colors: ['rgb(128,0,38)', 'rgb(189,0,38)', 'rgb(227,26,28)', 'rgb(252,78,42)', 'rgb(253,141,60)', 'rgb(254,178,76)', 'rgb(254,217,118)', 'rgb(255,237,160)', 'rgb(255,255,204)']
};
exports.YELLOW_ORANGE_RED_PALETTE = YELLOW_ORANGE_RED_PALETTE;
const YELLOW_GREEN_BLUE_PALETTE = {
  name: 'YlGnBu',
  label: 'Yellow-Green-Blue',
  colors: ['rgb(8,29,88)', 'rgb(37,52,148)', 'rgb(34,94,168)', 'rgb(29,145,192)', 'rgb(65,182,196)', 'rgb(127,205,187)', 'rgb(199,233,180)', 'rgb(237,248,217)', 'rgb(255,255,217)']
};
exports.YELLOW_GREEN_BLUE_PALETTE = YELLOW_GREEN_BLUE_PALETTE;
const DEFAULT_PALETTE = 'default';
exports.DEFAULT_PALETTE = DEFAULT_PALETTE;
const SINGLE_COLOR_PALETTE = 'singleColor';
exports.SINGLE_COLOR_PALETTE = SINGLE_COLOR_PALETTE;
const MULTI_COLOR_PALETTE = 'multicolor';
exports.MULTI_COLOR_PALETTE = MULTI_COLOR_PALETTE;
const COLOR_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single color',
  type: 'text'
}, {
  value: MULTI_COLOR_PALETTE,
  title: 'Multicolored',
  type: 'text'
}, {
  value: BLUES_PALETTE.name,
  title: BLUES_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUES_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: REDS_PALETTE.name,
  title: REDS_PALETTE.label,
  palette: (0, _eui.colorPalette)(REDS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREENS_PALETTE.name,
  title: GREENS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREENS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREYS_PALETTE.name,
  title: GREYS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREYS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: BLUE_RED_PALETTE.name,
  title: BLUE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: RED_BLUE_PALETTE.name,
  title: RED_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(RED_BLUE_PALETTE.colors, 20, true),
  type: 'gradient'
}, {
  value: YELLOW_ORANGE_RED_PALETTE.name,
  title: YELLOW_ORANGE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_ORANGE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: YELLOW_GREEN_BLUE_PALETTE.name,
  title: YELLOW_GREEN_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_GREEN_BLUE_PALETTE.colors, 20),
  type: 'gradient'
}];
exports.COLOR_PALETTES = COLOR_PALETTES;
const HEX_CONTRAST_COLOR = 0xffffff;
exports.HEX_CONTRAST_COLOR = HEX_CONTRAST_COLOR;
const PIE_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single Color',
  type: 'text'
}];
exports.PIE_PALETTES = PIE_PALETTES;
const HEATMAP_PALETTE_COLOR = {
  name: REDS_PALETTE.label,
  color: REDS_PALETTE.label
};
exports.HEATMAP_PALETTE_COLOR = HEATMAP_PALETTE_COLOR;
const HEATMAP_SINGLE_COLOR = {
  name: 'singleColor',
  color: '#000000'
};
exports.HEATMAP_SINGLE_COLOR = HEATMAP_SINGLE_COLOR;
const OPACITY = 'opacity';
exports.OPACITY = OPACITY;
const SPECTRUM = 'spectrum';
exports.SPECTRUM = SPECTRUM;
const COLOR_BLACK = 'rgb(0,0,0)';
exports.COLOR_BLACK = COLOR_BLACK;
const COLOR_WHITE = 'rgb(255,255,255)';
exports.COLOR_WHITE = COLOR_WHITE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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