"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportsDashboardsPlugin = void 0;

var _opensearchReportsPlugin = _interopRequireDefault(require("./backend/opensearch-reports-plugin"));

var _routes = _interopRequireDefault(require("./routes"));

var _notificationsPlugin = require("./clusters/notificationsPlugin");

var _config = require("./config");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReportsDashboardsPlugin {
  constructor(context) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "initializerContext", void 0);

    _defineProperty(this, "reportingConfig", void 0);

    this.logger = context.logger.get();
    this.initializerContext = context;
  }

  async setup(core) {
    this.logger.debug('reports-dashboards: Setup');

    try {
      const config = await (0, _config.buildConfig)(this.initializerContext, core, this.logger);
      this.reportingConfig = config;
      this.logger.debug('Setup complete');
    } catch (error) {
      this.logger.error(`Error in Reporting setup, reporting may not function properly`);
      this.logger.error(error);
    }

    if (!this.reportingConfig) {
      throw new Error('Reporting Config is not initialized');
    }

    const router = core.http.createRouter(); // Deprecated API. Switch to the new opensearch client as soon as https://github.com/elastic/kibana/issues/35508 done.

    const opensearchReportsClient = core.opensearch.legacy.createClient('opensearch_reports', {
      plugins: [_opensearchReportsPlugin.default, _notificationsPlugin.NotificationsPlugin]
    });
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    }); // Register server side APIs

    (0, _routes.default)(router, this.reportingConfig); // put logger into route handler context, so that we don't need to pass through parameters

    core.http.registerRouteHandlerContext( //@ts-ignore
    'reporting_plugin', (context, request) => {
      return {
        logger: this.logger,
        opensearchReportsClient,
        notificationsClient
      };
    });
    return {};
  }

  start(core) {
    this.logger.debug('reports-dashboards: Started');
    return {};
  }

  stop() {}

}

exports.ReportsDashboardsPlugin = ReportsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBsdWdpbi50cyJdLCJuYW1lcyI6WyJSZXBvcnRzRGFzaGJvYXJkc1BsdWdpbiIsImNvbnN0cnVjdG9yIiwiY29udGV4dCIsImxvZ2dlciIsImdldCIsImluaXRpYWxpemVyQ29udGV4dCIsInNldHVwIiwiY29yZSIsImRlYnVnIiwiY29uZmlnIiwicmVwb3J0aW5nQ29uZmlnIiwiZXJyb3IiLCJFcnJvciIsInJvdXRlciIsImh0dHAiLCJjcmVhdGVSb3V0ZXIiLCJvcGVuc2VhcmNoUmVwb3J0c0NsaWVudCIsIm9wZW5zZWFyY2giLCJsZWdhY3kiLCJjcmVhdGVDbGllbnQiLCJwbHVnaW5zIiwib3BlbnNlYXJjaFJlcG9ydHNQbHVnaW4iLCJOb3RpZmljYXRpb25zUGx1Z2luIiwibm90aWZpY2F0aW9uc0NsaWVudCIsInJlZ2lzdGVyUm91dGVIYW5kbGVyQ29udGV4dCIsInJlcXVlc3QiLCJzdGFydCIsInN0b3AiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFhQTs7QUFLQTs7QUFDQTs7QUFDQTs7Ozs7O0FBY08sTUFBTUEsdUJBQU4sQ0FFZ0U7QUFPckVDLEVBQUFBLFdBQVcsQ0FBQ0MsT0FBRCxFQUF5RDtBQUFBOztBQUFBOztBQUFBOztBQUNsRSxTQUFLQyxNQUFMLEdBQWNELE9BQU8sQ0FBQ0MsTUFBUixDQUFlQyxHQUFmLEVBQWQ7QUFDQSxTQUFLQyxrQkFBTCxHQUEwQkgsT0FBMUI7QUFDRDs7QUFFaUIsUUFBTEksS0FBSyxDQUFDQyxJQUFELEVBQWtCO0FBQ2xDLFNBQUtKLE1BQUwsQ0FBWUssS0FBWixDQUFrQiwyQkFBbEI7O0FBRUEsUUFBSTtBQUNGLFlBQU1DLE1BQU0sR0FBRyxNQUFNLHlCQUNuQixLQUFLSixrQkFEYyxFQUVuQkUsSUFGbUIsRUFHbkIsS0FBS0osTUFIYyxDQUFyQjtBQUtBLFdBQUtPLGVBQUwsR0FBdUJELE1BQXZCO0FBQ0EsV0FBS04sTUFBTCxDQUFZSyxLQUFaLENBQWtCLGdCQUFsQjtBQUNELEtBUkQsQ0FRRSxPQUFPRyxLQUFQLEVBQWM7QUFDZCxXQUFLUixNQUFMLENBQVlRLEtBQVosQ0FDRywrREFESDtBQUdBLFdBQUtSLE1BQUwsQ0FBWVEsS0FBWixDQUFrQkEsS0FBbEI7QUFDRDs7QUFFRCxRQUFJLENBQUMsS0FBS0QsZUFBVixFQUEyQjtBQUN6QixZQUFNLElBQUlFLEtBQUosQ0FBVSxxQ0FBVixDQUFOO0FBQ0Q7O0FBRUQsVUFBTUMsTUFBTSxHQUFHTixJQUFJLENBQUNPLElBQUwsQ0FBVUMsWUFBVixFQUFmLENBdEJrQyxDQXVCbEM7O0FBQ0EsVUFBTUMsdUJBQTZDLEdBQUdULElBQUksQ0FBQ1UsVUFBTCxDQUFnQkMsTUFBaEIsQ0FBdUJDLFlBQXZCLENBQ3BELG9CQURvRCxFQUVwRDtBQUNFQyxNQUFBQSxPQUFPLEVBQUUsQ0FBQ0MsZ0NBQUQsRUFBMEJDLHdDQUExQjtBQURYLEtBRm9ELENBQXREO0FBT0EsVUFBTUMsbUJBQXlDLEdBQUdoQixJQUFJLENBQUNVLFVBQUwsQ0FBZ0JDLE1BQWhCLENBQXVCQyxZQUF2QixDQUNoRCwwQkFEZ0QsRUFFaEQ7QUFDRUMsTUFBQUEsT0FBTyxFQUFFLENBQUNFLHdDQUFEO0FBRFgsS0FGZ0QsQ0FBbEQsQ0EvQmtDLENBc0NsQzs7QUFDQSx5QkFBZVQsTUFBZixFQUF1QixLQUFLSCxlQUE1QixFQXZDa0MsQ0F5Q2xDOztBQUNBSCxJQUFBQSxJQUFJLENBQUNPLElBQUwsQ0FBVVUsMkJBQVYsRUFDRTtBQUNBLHNCQUZGLEVBR0UsQ0FBQ3RCLE9BQUQsRUFBVXVCLE9BQVYsS0FBc0I7QUFDcEIsYUFBTztBQUNMdEIsUUFBQUEsTUFBTSxFQUFFLEtBQUtBLE1BRFI7QUFFTGEsUUFBQUEsdUJBRks7QUFHTE8sUUFBQUE7QUFISyxPQUFQO0FBS0QsS0FUSDtBQVlBLFdBQU8sRUFBUDtBQUNEOztBQUVNRyxFQUFBQSxLQUFLLENBQUNuQixJQUFELEVBQWtCO0FBQzVCLFNBQUtKLE1BQUwsQ0FBWUssS0FBWixDQUFrQiw2QkFBbEI7QUFDQSxXQUFPLEVBQVA7QUFDRDs7QUFFTW1CLEVBQUFBLElBQUksR0FBRyxDQUFFOztBQTFFcUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIFBsdWdpbkluaXRpYWxpemVyQ29udGV4dCxcbiAgQ29yZVNldHVwLFxuICBDb3JlU3RhcnQsXG4gIFBsdWdpbixcbiAgTG9nZ2VyLFxuICBJTGVnYWN5Q2x1c3RlckNsaWVudCxcbn0gZnJvbSAnLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCBvcGVuc2VhcmNoUmVwb3J0c1BsdWdpbiBmcm9tICcuL2JhY2tlbmQvb3BlbnNlYXJjaC1yZXBvcnRzLXBsdWdpbic7XG5pbXBvcnQge1xuICBSZXBvcnRzRGFzaGJvYXJkc1BsdWdpblNldHVwLFxuICBSZXBvcnRzRGFzaGJvYXJkc1BsdWdpblN0YXJ0LFxufSBmcm9tICcuL3R5cGVzJztcbmltcG9ydCByZWdpc3RlclJvdXRlcyBmcm9tICcuL3JvdXRlcyc7XG5pbXBvcnQgeyBOb3RpZmljYXRpb25zUGx1Z2luIH0gZnJvbSAnLi9jbHVzdGVycy9ub3RpZmljYXRpb25zUGx1Z2luJztcbmltcG9ydCB7IGJ1aWxkQ29uZmlnLCBSZXBvcnRpbmdDb25maWdUeXBlIH0gZnJvbSAnLi9jb25maWcnO1xuaW1wb3J0IHsgUmVwb3J0aW5nQ29uZmlnIH0gZnJvbSAnLi9jb25maWcvY29uZmlnJztcblxuZXhwb3J0IGludGVyZmFjZSBSZXBvcnRzUGx1Z2luUmVxdWVzdENvbnRleHQge1xuICBsb2dnZXI6IExvZ2dlcjtcbiAgb3BlbnNlYXJjaENsaWVudDogSUxlZ2FjeUNsdXN0ZXJDbGllbnQ7XG59XG4vL0B0cy1pZ25vcmVcbmRlY2xhcmUgbW9kdWxlICdraWJhbmEvc2VydmVyJyB7XG4gIGludGVyZmFjZSBSZXF1ZXN0SGFuZGxlckNvbnRleHQge1xuICAgIHJlcG9ydHNfcGx1Z2luOiBSZXBvcnRzUGx1Z2luUmVxdWVzdENvbnRleHQ7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFJlcG9ydHNEYXNoYm9hcmRzUGx1Z2luXG4gIGltcGxlbWVudHNcbiAgICBQbHVnaW48UmVwb3J0c0Rhc2hib2FyZHNQbHVnaW5TZXR1cCwgUmVwb3J0c0Rhc2hib2FyZHNQbHVnaW5TdGFydD4ge1xuICBwcml2YXRlIHJlYWRvbmx5IGxvZ2dlcjogTG9nZ2VyO1xuICBwcml2YXRlIHJlYWRvbmx5IGluaXRpYWxpemVyQ29udGV4dDogUGx1Z2luSW5pdGlhbGl6ZXJDb250ZXh0PFxuICAgIFJlcG9ydGluZ0NvbmZpZ1R5cGVcbiAgPjtcbiAgcHJpdmF0ZSByZXBvcnRpbmdDb25maWc/OiBSZXBvcnRpbmdDb25maWc7XG5cbiAgY29uc3RydWN0b3IoY29udGV4dDogUGx1Z2luSW5pdGlhbGl6ZXJDb250ZXh0PFJlcG9ydGluZ0NvbmZpZ1R5cGU+KSB7XG4gICAgdGhpcy5sb2dnZXIgPSBjb250ZXh0LmxvZ2dlci5nZXQoKTtcbiAgICB0aGlzLmluaXRpYWxpemVyQ29udGV4dCA9IGNvbnRleHQ7XG4gIH1cblxuICBwdWJsaWMgYXN5bmMgc2V0dXAoY29yZTogQ29yZVNldHVwKSB7XG4gICAgdGhpcy5sb2dnZXIuZGVidWcoJ3JlcG9ydHMtZGFzaGJvYXJkczogU2V0dXAnKTtcblxuICAgIHRyeSB7XG4gICAgICBjb25zdCBjb25maWcgPSBhd2FpdCBidWlsZENvbmZpZyhcbiAgICAgICAgdGhpcy5pbml0aWFsaXplckNvbnRleHQsXG4gICAgICAgIGNvcmUsXG4gICAgICAgIHRoaXMubG9nZ2VyXG4gICAgICApO1xuICAgICAgdGhpcy5yZXBvcnRpbmdDb25maWcgPSBjb25maWc7XG4gICAgICB0aGlzLmxvZ2dlci5kZWJ1ZygnU2V0dXAgY29tcGxldGUnKTtcbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgdGhpcy5sb2dnZXIuZXJyb3IoXG4gICAgICAgIGBFcnJvciBpbiBSZXBvcnRpbmcgc2V0dXAsIHJlcG9ydGluZyBtYXkgbm90IGZ1bmN0aW9uIHByb3Blcmx5YFxuICAgICAgKTtcbiAgICAgIHRoaXMubG9nZ2VyLmVycm9yKGVycm9yKTtcbiAgICB9XG5cbiAgICBpZiAoIXRoaXMucmVwb3J0aW5nQ29uZmlnKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1JlcG9ydGluZyBDb25maWcgaXMgbm90IGluaXRpYWxpemVkJyk7XG4gICAgfVxuXG4gICAgY29uc3Qgcm91dGVyID0gY29yZS5odHRwLmNyZWF0ZVJvdXRlcigpO1xuICAgIC8vIERlcHJlY2F0ZWQgQVBJLiBTd2l0Y2ggdG8gdGhlIG5ldyBvcGVuc2VhcmNoIGNsaWVudCBhcyBzb29uIGFzIGh0dHBzOi8vZ2l0aHViLmNvbS9lbGFzdGljL2tpYmFuYS9pc3N1ZXMvMzU1MDggZG9uZS5cbiAgICBjb25zdCBvcGVuc2VhcmNoUmVwb3J0c0NsaWVudDogSUxlZ2FjeUNsdXN0ZXJDbGllbnQgPSBjb3JlLm9wZW5zZWFyY2gubGVnYWN5LmNyZWF0ZUNsaWVudChcbiAgICAgICdvcGVuc2VhcmNoX3JlcG9ydHMnLFxuICAgICAge1xuICAgICAgICBwbHVnaW5zOiBbb3BlbnNlYXJjaFJlcG9ydHNQbHVnaW4sIE5vdGlmaWNhdGlvbnNQbHVnaW5dLFxuICAgICAgfVxuICAgICk7XG5cbiAgICBjb25zdCBub3RpZmljYXRpb25zQ2xpZW50OiBJTGVnYWN5Q2x1c3RlckNsaWVudCA9IGNvcmUub3BlbnNlYXJjaC5sZWdhY3kuY3JlYXRlQ2xpZW50KFxuICAgICAgJ29wZW5zZWFyY2hfbm90aWZpY2F0aW9ucycsXG4gICAgICB7XG4gICAgICAgIHBsdWdpbnM6IFtOb3RpZmljYXRpb25zUGx1Z2luXSxcbiAgICAgIH1cbiAgICApO1xuXG4gICAgLy8gUmVnaXN0ZXIgc2VydmVyIHNpZGUgQVBJc1xuICAgIHJlZ2lzdGVyUm91dGVzKHJvdXRlciwgdGhpcy5yZXBvcnRpbmdDb25maWcpO1xuXG4gICAgLy8gcHV0IGxvZ2dlciBpbnRvIHJvdXRlIGhhbmRsZXIgY29udGV4dCwgc28gdGhhdCB3ZSBkb24ndCBuZWVkIHRvIHBhc3MgdGhyb3VnaCBwYXJhbWV0ZXJzXG4gICAgY29yZS5odHRwLnJlZ2lzdGVyUm91dGVIYW5kbGVyQ29udGV4dChcbiAgICAgIC8vQHRzLWlnbm9yZVxuICAgICAgJ3JlcG9ydGluZ19wbHVnaW4nLFxuICAgICAgKGNvbnRleHQsIHJlcXVlc3QpID0+IHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICBsb2dnZXI6IHRoaXMubG9nZ2VyLFxuICAgICAgICAgIG9wZW5zZWFyY2hSZXBvcnRzQ2xpZW50LFxuICAgICAgICAgIG5vdGlmaWNhdGlvbnNDbGllbnQsXG4gICAgICAgIH07XG4gICAgICB9XG4gICAgKTtcblxuICAgIHJldHVybiB7fTtcbiAgfVxuXG4gIHB1YmxpYyBzdGFydChjb3JlOiBDb3JlU3RhcnQpIHtcbiAgICB0aGlzLmxvZ2dlci5kZWJ1ZygncmVwb3J0cy1kYXNoYm9hcmRzOiBTdGFydGVkJyk7XG4gICAgcmV0dXJuIHt9O1xuICB9XG5cbiAgcHVibGljIHN0b3AoKSB7fVxufVxuIl19