/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroupRuleDescription;
import com.amazonaws.services.ec2.model.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateSecurityGroupRuleDescriptionsEgressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<UpdateSecurityGroupRuleDescriptionsEgressRequest> {
    private String groupId;
    private String groupName;
    private SdkInternalList<IpPermission> ipPermissions;
    private SdkInternalList<SecurityGroupRuleDescription> securityGroupRuleDescriptions;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new SdkInternalList();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        this.ipPermissions = new SdkInternalList(ipPermissions);
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.setIpPermissions((Collection<IpPermission>)new SdkInternalList(ipPermissions.length));
        }
        for (IpPermission ele : ipPermissions) {
            this.ipPermissions.add((Object)ele);
        }
        return this;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withIpPermissions(Collection<IpPermission> ipPermissions) {
        this.setIpPermissions(ipPermissions);
        return this;
    }

    public List<SecurityGroupRuleDescription> getSecurityGroupRuleDescriptions() {
        if (this.securityGroupRuleDescriptions == null) {
            this.securityGroupRuleDescriptions = new SdkInternalList();
        }
        return this.securityGroupRuleDescriptions;
    }

    public void setSecurityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> securityGroupRuleDescriptions) {
        if (securityGroupRuleDescriptions == null) {
            this.securityGroupRuleDescriptions = null;
            return;
        }
        this.securityGroupRuleDescriptions = new SdkInternalList(securityGroupRuleDescriptions);
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withSecurityGroupRuleDescriptions(SecurityGroupRuleDescription ... securityGroupRuleDescriptions) {
        if (this.securityGroupRuleDescriptions == null) {
            this.setSecurityGroupRuleDescriptions((Collection<SecurityGroupRuleDescription>)new SdkInternalList(securityGroupRuleDescriptions.length));
        }
        for (SecurityGroupRuleDescription ele : securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions.add((Object)ele);
        }
        return this;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withSecurityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> securityGroupRuleDescriptions) {
        this.setSecurityGroupRuleDescriptions(securityGroupRuleDescriptions);
        return this;
    }

    @Override
    public Request<UpdateSecurityGroupRuleDescriptionsEgressRequest> getDryRunRequest() {
        Request<UpdateSecurityGroupRuleDescriptionsEgressRequest> request = new UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: ").append(this.getIpPermissions()).append(",");
        }
        if (this.getSecurityGroupRuleDescriptions() != null) {
            sb.append("SecurityGroupRuleDescriptions: ").append(this.getSecurityGroupRuleDescriptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsEgressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsEgressRequest other = (UpdateSecurityGroupRuleDescriptionsEgressRequest)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        if (other.getIpPermissions() != null && !other.getIpPermissions().equals(this.getIpPermissions())) {
            return false;
        }
        if (other.getSecurityGroupRuleDescriptions() == null ^ this.getSecurityGroupRuleDescriptions() == null) {
            return false;
        }
        return other.getSecurityGroupRuleDescriptions() == null || other.getSecurityGroupRuleDescriptions().equals(this.getSecurityGroupRuleDescriptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupRuleDescriptions() == null ? 0 : this.getSecurityGroupRuleDescriptions().hashCode());
        return hashCode;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest clone() {
        return (UpdateSecurityGroupRuleDescriptionsEgressRequest)super.clone();
    }
}

