/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceRequirements;
import com.amazonaws.services.ec2.model.transform.AcceleratorCountStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.AcceleratorTotalMemoryMiBStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.BaselineEbsBandwidthMbpsStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.MemoryGiBPerVCpuStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.MemoryMiBStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkInterfaceCountStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TotalLocalStorageGBStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.VCpuCountRangeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class InstanceRequirementsStaxUnmarshaller
implements Unmarshaller<InstanceRequirements, StaxUnmarshallerContext> {
    private static InstanceRequirementsStaxUnmarshaller instance;

    public InstanceRequirements unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceRequirements instanceRequirements = new InstanceRequirements();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceRequirements;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("vCpuCount", targetDepth)) {
                    instanceRequirements.setVCpuCount(VCpuCountRangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("memoryMiB", targetDepth)) {
                    instanceRequirements.setMemoryMiB(MemoryMiBStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("cpuManufacturerSet", targetDepth)) {
                    instanceRequirements.withCpuManufacturers(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("cpuManufacturerSet/item", targetDepth)) {
                    instanceRequirements.withCpuManufacturers(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("memoryGiBPerVCpu", targetDepth)) {
                    instanceRequirements.setMemoryGiBPerVCpu(MemoryGiBPerVCpuStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("excludedInstanceTypeSet", targetDepth)) {
                    instanceRequirements.withExcludedInstanceTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("excludedInstanceTypeSet/item", targetDepth)) {
                    instanceRequirements.withExcludedInstanceTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceGenerationSet", targetDepth)) {
                    instanceRequirements.withInstanceGenerations(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("instanceGenerationSet/item", targetDepth)) {
                    instanceRequirements.withInstanceGenerations(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("spotMaxPricePercentageOverLowestPrice", targetDepth)) {
                    instanceRequirements.setSpotMaxPricePercentageOverLowestPrice(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("onDemandMaxPricePercentageOverLowestPrice", targetDepth)) {
                    instanceRequirements.setOnDemandMaxPricePercentageOverLowestPrice(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("bareMetal", targetDepth)) {
                    instanceRequirements.setBareMetal(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("burstablePerformance", targetDepth)) {
                    instanceRequirements.setBurstablePerformance(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requireHibernateSupport", targetDepth)) {
                    instanceRequirements.setRequireHibernateSupport(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkInterfaceCount", targetDepth)) {
                    instanceRequirements.setNetworkInterfaceCount(NetworkInterfaceCountStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("localStorage", targetDepth)) {
                    instanceRequirements.setLocalStorage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("localStorageTypeSet", targetDepth)) {
                    instanceRequirements.withLocalStorageTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("localStorageTypeSet/item", targetDepth)) {
                    instanceRequirements.withLocalStorageTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("totalLocalStorageGB", targetDepth)) {
                    instanceRequirements.setTotalLocalStorageGB(TotalLocalStorageGBStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("baselineEbsBandwidthMbps", targetDepth)) {
                    instanceRequirements.setBaselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("acceleratorTypeSet", targetDepth)) {
                    instanceRequirements.withAcceleratorTypes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("acceleratorTypeSet/item", targetDepth)) {
                    instanceRequirements.withAcceleratorTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("acceleratorCount", targetDepth)) {
                    instanceRequirements.setAcceleratorCount(AcceleratorCountStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("acceleratorManufacturerSet", targetDepth)) {
                    instanceRequirements.withAcceleratorManufacturers(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("acceleratorManufacturerSet/item", targetDepth)) {
                    instanceRequirements.withAcceleratorManufacturers(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("acceleratorNameSet", targetDepth)) {
                    instanceRequirements.withAcceleratorNames(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("acceleratorNameSet/item", targetDepth)) {
                    instanceRequirements.withAcceleratorNames(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("acceleratorTotalMemoryMiB", targetDepth)) continue;
                instanceRequirements.setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceRequirements;
    }

    public static InstanceRequirementsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceRequirementsStaxUnmarshaller();
        }
        return instance;
    }
}

