/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGrid;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;

public abstract class InternalGeoGridBucket<B extends InternalGeoGridBucket>
extends InternalMultiBucketAggregation.InternalBucket
implements GeoGrid.Bucket,
Comparable<InternalGeoGridBucket> {
    protected long hashAsLong;
    protected long docCount;
    protected InternalAggregations aggregations;
    long bucketOrd;

    public InternalGeoGridBucket(long hashAsLong, long docCount, InternalAggregations aggregations) {
        this.docCount = docCount;
        this.aggregations = aggregations;
        this.hashAsLong = hashAsLong;
    }

    public InternalGeoGridBucket(StreamInput in) throws IOException {
        this.hashAsLong = in.readLong();
        this.docCount = in.readVLong();
        this.aggregations = InternalAggregations.readFrom((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.hashAsLong);
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    public long hashAsLong() {
        return this.hashAsLong;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public int compareTo(InternalGeoGridBucket other) {
        if (this.hashAsLong > other.hashAsLong) {
            return 1;
        }
        if (this.hashAsLong < other.hashAsLong) {
            return -1;
        }
        return 0;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalGeoGridBucket bucket = (InternalGeoGridBucket)o;
        return this.hashAsLong == bucket.hashAsLong && this.docCount == bucket.docCount && Objects.equals(this.aggregations, bucket.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.hashAsLong, this.docCount, this.aggregations);
    }
}

