/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.ContinuousMetadata;
import org.opensearch.indexmanagement.rollup.model.RollupStats;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0002DEB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005Bs\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0017H\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\u0017\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u00c6\u0003J\t\u00100\u001a\u00020\u0010H\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\t\u00102\u001a\u00020\u0014H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u007f\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u00c6\u0001J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\t\u0010:\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006F"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "Lorg/opensearch/common/xcontent/ToXContentObject;", "Lorg/opensearch/common/io/stream/Writeable;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "id", "", "seqNo", "", "primaryTerm", "rollupID", "afterKey", "", "", "lastUpdatedTime", "Ljava/time/Instant;", "continuous", "Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "status", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "failureReason", "stats", "Lorg/opensearch/indexmanagement/rollup/model/RollupStats;", "(Ljava/lang/String;JJLjava/lang/String;Ljava/util/Map;Ljava/time/Instant;Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/RollupStats;)V", "getAfterKey", "()Ljava/util/Map;", "getContinuous", "()Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "getFailureReason", "()Ljava/lang/String;", "getId", "getLastUpdatedTime", "()Ljava/time/Instant;", "getPrimaryTerm", "()J", "getRollupID", "getSeqNo", "getStats", "()Lorg/opensearch/indexmanagement/rollup/model/RollupStats;", "getStatus", "()Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "Status", "opensearch-index-management"})
public final class RollupMetadata
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final String rollupID;
    @Nullable
    private final Map<String, Object> afterKey;
    @NotNull
    private final Instant lastUpdatedTime;
    @Nullable
    private final ContinuousMetadata continuous;
    @NotNull
    private final Status status;
    @Nullable
    private final String failureReason;
    @NotNull
    private final RollupStats stats;
    @NotNull
    public static final String ROLLUP_METADATA_TYPE = "rollup_metadata";
    @NotNull
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    @NotNull
    public static final String AFTER_KEY_FIELD = "after_key";
    @NotNull
    public static final String LAST_UPDATED_FIELD = "last_updated_time";
    @NotNull
    public static final String LAST_UPDATED_FIELD_IN_MILLIS = "last_updated_time_in_millis";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String STATUS_FIELD = "status";
    @NotNull
    public static final String FAILURE_REASON = "failure_reason";
    @NotNull
    public static final String STATS_FIELD = "stats";

    public RollupMetadata(@NotNull String id2, long seqNo, long primaryTerm, @NotNull String rollupID, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedTime, @Nullable ContinuousMetadata continuous, @NotNull Status status, @Nullable String failureReason, @NotNull RollupStats stats) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)rollupID, (String)"rollupID");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        this.id = id2;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.rollupID = rollupID;
        this.afterKey = afterKey;
        this.lastUpdatedTime = lastUpdatedTime;
        this.continuous = continuous;
        this.status = status;
        this.failureReason = failureReason;
        this.stats = stats;
    }

    public /* synthetic */ RollupMetadata(String string, long l, long l2, String string2, Map map, Instant instant, ContinuousMetadata continuousMetadata, Status status, String string3, RollupStats rollupStats, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            l = -2L;
        }
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            map = null;
        }
        if ((n & 0x40) != 0) {
            continuousMetadata = null;
        }
        if ((n & 0x100) != 0) {
            string3 = null;
        }
        this(string, l, l2, string2, map, instant, continuousMetadata, status, string3, rollupStats);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final String getRollupID() {
        return this.rollupID;
    }

    @Nullable
    public final Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ContinuousMetadata getContinuous() {
        return this.continuous;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getFailureReason() {
        return this.failureReason;
    }

    @NotNull
    public final RollupStats getStats() {
        return this.stats;
    }

    public RollupMetadata(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string = object;
        long l = sin.readLong();
        long l2 = sin.readLong();
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        String string2 = object;
        Map map = sin.readBoolean() ? sin.readMap() : null;
        object = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readInstant()");
        Object object2 = object;
        ContinuousMetadata continuousMetadata = sin.readBoolean() ? new ContinuousMetadata(sin) : null;
        object = sin.readEnum(Status.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readEnum(Status::class.java)");
        this(string, l, l2, string2, map, (Instant)object2, continuousMetadata, (Status)((Object)object), sin.readOptionalString(), new RollupStats(sin));
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(ROLLUP_METADATA_TYPE);
        }
        builder.field(ROLLUP_ID_FIELD, this.rollupID);
        if (this.afterKey != null) {
            builder.field(AFTER_KEY_FIELD, this.afterKey);
        }
        builder.timeField(LAST_UPDATED_FIELD, LAST_UPDATED_FIELD_IN_MILLIS, this.lastUpdatedTime.toEpochMilli());
        if (this.continuous != null) {
            builder.field(CONTINUOUS_FIELD, (ToXContent)this.continuous);
        }
        builder.field(STATUS_FIELD, this.status.getType());
        builder.field(FAILURE_REASON, this.failureReason);
        builder.field(STATS_FIELD, (ToXContent)this.stats);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.rollupID);
        out.writeBoolean(this.afterKey != null);
        Map<String, Object> map = this.afterKey;
        if (map != null) {
            Map<String, Object> it = map;
            boolean bl = false;
            out.writeMap(it);
        }
        out.writeInstant(this.lastUpdatedTime);
        out.writeBoolean(this.continuous != null);
        ContinuousMetadata continuousMetadata = this.continuous;
        if (continuousMetadata != null) {
            continuousMetadata.writeTo(out);
        }
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.failureReason);
        this.stats.writeTo(out);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    @NotNull
    public final String component4() {
        return this.rollupID;
    }

    @Nullable
    public final Map<String, Object> component5() {
        return this.afterKey;
    }

    @NotNull
    public final Instant component6() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final ContinuousMetadata component7() {
        return this.continuous;
    }

    @NotNull
    public final Status component8() {
        return this.status;
    }

    @Nullable
    public final String component9() {
        return this.failureReason;
    }

    @NotNull
    public final RollupStats component10() {
        return this.stats;
    }

    @NotNull
    public final RollupMetadata copy(@NotNull String id2, long seqNo, long primaryTerm, @NotNull String rollupID, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedTime, @Nullable ContinuousMetadata continuous, @NotNull Status status, @Nullable String failureReason, @NotNull RollupStats stats) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)rollupID, (String)"rollupID");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        return new RollupMetadata(id2, seqNo, primaryTerm, rollupID, afterKey, lastUpdatedTime, continuous, status, failureReason, stats);
    }

    public static /* synthetic */ RollupMetadata copy$default(RollupMetadata rollupMetadata, String string, long l, long l2, String string2, Map map, Instant instant, ContinuousMetadata continuousMetadata, Status status, String string3, RollupStats rollupStats, int n, Object object) {
        if ((n & 1) != 0) {
            string = rollupMetadata.id;
        }
        if ((n & 2) != 0) {
            l = rollupMetadata.seqNo;
        }
        if ((n & 4) != 0) {
            l2 = rollupMetadata.primaryTerm;
        }
        if ((n & 8) != 0) {
            string2 = rollupMetadata.rollupID;
        }
        if ((n & 0x10) != 0) {
            map = rollupMetadata.afterKey;
        }
        if ((n & 0x20) != 0) {
            instant = rollupMetadata.lastUpdatedTime;
        }
        if ((n & 0x40) != 0) {
            continuousMetadata = rollupMetadata.continuous;
        }
        if ((n & 0x80) != 0) {
            status = rollupMetadata.status;
        }
        if ((n & 0x100) != 0) {
            string3 = rollupMetadata.failureReason;
        }
        if ((n & 0x200) != 0) {
            rollupStats = rollupMetadata.stats;
        }
        return rollupMetadata.copy(string, l, l2, string2, map, instant, continuousMetadata, status, string3, rollupStats);
    }

    @NotNull
    public String toString() {
        return "RollupMetadata(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", rollupID=" + this.rollupID + ", afterKey=" + this.afterKey + ", lastUpdatedTime=" + this.lastUpdatedTime + ", continuous=" + this.continuous + ", status=" + this.status + ", failureReason=" + this.failureReason + ", stats=" + this.stats + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + this.rollupID.hashCode();
        result2 = result2 * 31 + (this.afterKey == null ? 0 : ((Object)this.afterKey).hashCode());
        result2 = result2 * 31 + this.lastUpdatedTime.hashCode();
        result2 = result2 * 31 + (this.continuous == null ? 0 : this.continuous.hashCode());
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.failureReason == null ? 0 : this.failureReason.hashCode());
        result2 = result2 * 31 + this.stats.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollupMetadata)) {
            return false;
        }
        RollupMetadata rollupMetadata = (RollupMetadata)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rollupMetadata.id)) {
            return false;
        }
        if (this.seqNo != rollupMetadata.seqNo) {
            return false;
        }
        if (this.primaryTerm != rollupMetadata.primaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rollupID, (Object)rollupMetadata.rollupID)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.afterKey, rollupMetadata.afterKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)rollupMetadata.lastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.continuous, (Object)rollupMetadata.continuous)) {
            return false;
        }
        if (this.status != rollupMetadata.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureReason, (Object)rollupMetadata.failureReason)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stats, (Object)rollupMetadata.stats);
    }

    @JvmStatic
    @NotNull
    public static final RollupMetadata parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id2, seqNo, primaryTerm);
    }

    @JvmStatic
    @NotNull
    public static final RollupMetadata readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Status;", "", "type", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "toString", "INIT", "STARTED", "STOPPED", "FINISHED", "FAILED", "RETRY", "opensearch-index-management"})
    public static final class Status
    extends Enum<Status> {
        @NotNull
        private final String type;
        public static final /* enum */ Status INIT = new Status("init");
        public static final /* enum */ Status STARTED = new Status("started");
        public static final /* enum */ Status STOPPED = new Status("stopped");
        public static final /* enum */ Status FINISHED = new Status("finished");
        public static final /* enum */ Status FAILED = new Status("failed");
        public static final /* enum */ Status RETRY = new Status("retry");
        private static final /* synthetic */ Status[] $VALUES;

        private Status(String type) {
            this.type = type;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return this.type;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.INIT, Status.STARTED, Status.STOPPED, Status.FINISHED, Status.FAILED, Status.RETRY};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata$Companion;", "", "()V", "AFTER_KEY_FIELD", "", "CONTINUOUS_FIELD", "FAILURE_REASON", "LAST_UPDATED_FIELD", "LAST_UPDATED_FIELD_IN_MILLIS", "ROLLUP_ID_FIELD", "ROLLUP_METADATA_TYPE", "STATS_FIELD", "STATUS_FIELD", "parse", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "xcp", "Lorg/opensearch/common/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RollupMetadata parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            String rollupID = null;
            Map afterKey = null;
            Instant lastUpdatedTime = null;
            ContinuousMetadata continuous = null;
            Status status = null;
            String failureReason = null;
            RollupStats stats = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case -1670470950: {
                        if (string.equals(RollupMetadata.LAST_UPDATED_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 109757599: {
                        if (string.equals(RollupMetadata.STATS_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 379114255: {
                        if (string.equals(RollupMetadata.CONTINUOUS_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1019577724: {
                        if (string.equals(RollupMetadata.AFTER_KEY_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 1743941273: {
                        if (string.equals(RollupMetadata.FAILURE_REASON)) {
                            n = 5;
                        }
                        break;
                    }
                    case 556621538: {
                        if (string.equals(RollupMetadata.ROLLUP_ID_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case -892481550: {
                        if (string.equals(RollupMetadata.STATUS_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 6: {
                        rollupID = xcp.text();
                        break;
                    }
                    case 4: {
                        afterKey = xcp.map();
                        break;
                    }
                    case 1: {
                        lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                        break;
                    }
                    case 3: {
                        continuous = ContinuousMetadata.Companion.parse(xcp);
                        break;
                    }
                    case 7: {
                        String string2 = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string3 = string2.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
                        status = Status.valueOf(string3);
                        break;
                    }
                    case 5: {
                        failureReason = xcp.textOrNull();
                        break;
                    }
                    case 2: {
                        stats = RollupStats.Companion.parse(xcp);
                    }
                }
            }
            String string = id2;
            long l = seqNo;
            long l2 = primaryTerm;
            String string4 = rollupID;
            if (string4 == null) {
                long l3 = l2;
                long l4 = l;
                String string5 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$52 = false;
                String string6 = "RollupID must not be null";
                String string7 = string5;
                long l5 = l4;
                long l6 = l3;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$52 = string6;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$52.toString());
            }
            Map map = afterKey;
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                Map map2 = map;
                String string8 = string4;
                long l7 = l2;
                long l8 = l;
                String string9 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$62 = false;
                String string10 = "Last updated time must not be null";
                String string11 = string9;
                long l9 = l8;
                long l10 = l7;
                String string12 = string8;
                Map map3 = map2;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$62 = string10;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$62.toString());
            }
            ContinuousMetadata continuousMetadata = continuous;
            Status status2 = status;
            if (status2 == null) {
                ContinuousMetadata continuousMetadata2 = continuousMetadata;
                Instant instant2 = instant;
                Map map4 = map;
                String string13 = string4;
                long l11 = l2;
                long l12 = l;
                String string14 = string;
                boolean $i$a$-requireNotNull-RollupMetadata$Companion$parse$72 = false;
                String string15 = "Status must not be null";
                String string16 = string14;
                long l13 = l12;
                long l14 = l11;
                String string17 = string13;
                Map map5 = map4;
                Instant instant3 = instant2;
                ContinuousMetadata continuousMetadata3 = continuousMetadata2;
                String $i$a$-requireNotNull-RollupMetadata$Companion$parse$72 = string15;
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetadata$Companion$parse$72.toString());
            }
            String string18 = failureReason;
            RollupStats rollupStats = stats;
            if (rollupStats == null) {
                String string19 = string18;
                Status status3 = status2;
                ContinuousMetadata continuousMetadata4 = continuousMetadata;
                Instant instant4 = instant;
                Map map6 = map;
                String string20 = string4;
                long l15 = l2;
                long l16 = l;
                String string21 = string;
                boolean bl = false;
                String string22 = "Stats must not be null";
                String string23 = string21;
                long l17 = l16;
                long l18 = l15;
                String string24 = string20;
                Map map7 = map6;
                Instant instant5 = instant4;
                ContinuousMetadata continuousMetadata5 = continuousMetadata4;
                Status status4 = status3;
                String string25 = string19;
                String string26 = string22;
                throw new IllegalArgumentException(string26.toString());
            }
            RollupStats rollupStats2 = rollupStats;
            String string27 = string18;
            Status status5 = status2;
            ContinuousMetadata continuousMetadata6 = continuousMetadata;
            Instant instant6 = instant;
            Map map8 = map;
            String string28 = string4;
            long l19 = l2;
            long l20 = l;
            String string29 = string;
            return new RollupMetadata(string29, l20, l19, string28, map8, instant6, continuousMetadata6, status5, string27, rollupStats2);
        }

        public static /* synthetic */ RollupMetadata parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @NotNull
        public final RollupMetadata readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new RollupMetadata(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

