/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import java.io.Closeable;
import java.io.IOException;
import org.opensearch.common.Nullable;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.repositories.s3.AmazonS3WithCredentials;

public class AmazonS3Reference
extends RefCountedReleasable<AmazonS3> {
    AmazonS3Reference(AmazonS3 client) {
        this(client, null);
    }

    AmazonS3Reference(AmazonS3WithCredentials client) {
        this(client.client(), client.credentials());
    }

    AmazonS3Reference(AmazonS3 client, @Nullable AWSCredentialsProvider credentials) {
        super("AWS_S3_CLIENT", (Object)client, () -> {
            client.shutdown();
            if (credentials instanceof Closeable) {
                try {
                    ((Closeable)credentials).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

