/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;

public enum OpenSearchDataType implements ExprType
{
    OPENSEARCH_TEXT(Collections.singletonList(ExprCoreType.STRING), "string"){

        public boolean shouldCast(ExprType other) {
            return false;
        }
    }
    ,
    OPENSEARCH_TEXT_KEYWORD((List)Arrays.asList(new ExprType[]{ExprCoreType.STRING, OPENSEARCH_TEXT}), "string"){

        public boolean shouldCast(ExprType other) {
            return false;
        }
    }
    ,
    OPENSEARCH_IP(Arrays.asList(ExprCoreType.UNKNOWN), "ip"),
    OPENSEARCH_GEO_POINT(Arrays.asList(ExprCoreType.UNKNOWN), "geo_point"),
    OPENSEARCH_BINARY(Arrays.asList(ExprCoreType.UNKNOWN), "binary");

    private static final BiMap<String, ExprType> OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING;
    private static final Map<String, ExprType> EXTRA_OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING;
    private static final Map<ExprType, String> LEGACY_TYPE_NAME_MAPPING;
    private final List<ExprType> parents;
    private final String jdbcType;

    public static ExprType getExprType(String openSearchType) {
        if (OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING.containsKey((Object)openSearchType)) {
            return (ExprType)OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING.get((Object)openSearchType);
        }
        return EXTRA_OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING.getOrDefault(openSearchType, (ExprType)ExprCoreType.UNKNOWN);
    }

    public static String getOpenSearchType(ExprType type) {
        return (String)OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING.inverse().get((Object)type);
    }

    public List<ExprType> getParent() {
        return this.parents;
    }

    public String typeName() {
        return this.jdbcType;
    }

    public String legacyTypeName() {
        return LEGACY_TYPE_NAME_MAPPING.getOrDefault((Object)this, this.typeName());
    }

    @Generated
    private OpenSearchDataType(List<ExprType> parents, String jdbcType) {
        this.parents = parents;
        this.jdbcType = jdbcType;
    }

    static {
        OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING = ImmutableBiMap.builder().put((Object)"text", (Object)OPENSEARCH_TEXT).put((Object)"text_keyword", (Object)OPENSEARCH_TEXT_KEYWORD).put((Object)"keyword", (Object)ExprCoreType.STRING).put((Object)"byte", (Object)ExprCoreType.BYTE).put((Object)"short", (Object)ExprCoreType.SHORT).put((Object)"integer", (Object)ExprCoreType.INTEGER).put((Object)"long", (Object)ExprCoreType.LONG).put((Object)"float", (Object)ExprCoreType.FLOAT).put((Object)"double", (Object)ExprCoreType.DOUBLE).put((Object)"boolean", (Object)ExprCoreType.BOOLEAN).put((Object)"nested", (Object)ExprCoreType.ARRAY).put((Object)"object", (Object)ExprCoreType.STRUCT).put((Object)"date", (Object)ExprCoreType.TIMESTAMP).put((Object)"ip", (Object)OPENSEARCH_IP).put((Object)"geo_point", (Object)OPENSEARCH_GEO_POINT).put((Object)"binary", (Object)OPENSEARCH_BINARY).build();
        EXTRA_OPENSEARCH_TYPE_TO_EXPR_TYPE_MAPPING = ImmutableMap.builder().put((Object)"half_float", (Object)ExprCoreType.FLOAT).put((Object)"scaled_float", (Object)ExprCoreType.DOUBLE).put((Object)"date_nanos", (Object)ExprCoreType.TIMESTAMP).build();
        LEGACY_TYPE_NAME_MAPPING = new ImmutableMap.Builder().put((Object)OPENSEARCH_TEXT, (Object)"text").put((Object)OPENSEARCH_TEXT_KEYWORD, (Object)"text").build();
    }
}

