/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl;

import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.QueryPlanFactory;
import org.opensearch.sql.ppl.antlr.PPLSyntaxParser;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.ppl.parser.AstBuilder;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.parser.AstStatementBuilder;
import org.opensearch.sql.ppl.utils.PPLQueryDataAnonymizer;

public class PPLService {
    private final PPLSyntaxParser parser;
    private final QueryManager queryManager;
    private final QueryPlanFactory queryExecutionFactory;
    private final PPLQueryDataAnonymizer anonymizer = new PPLQueryDataAnonymizer();
    private static final Logger LOG = LogManager.getLogger();

    public void execute(PPLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, Optional.of(listener), Optional.empty()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(PPLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, Optional.empty(), Optional.of(listener)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private AbstractPlan plan(PPLQueryRequest request, Optional<ResponseListener<ExecutionEngine.QueryResponse>> queryListener, Optional<ResponseListener<ExecutionEngine.ExplainResponse>> explainListener) {
        ParseTree cst = this.parser.parse(request.getRequest());
        Statement statement = (Statement)cst.accept((ParseTreeVisitor)new AstStatementBuilder(new AstBuilder(new AstExpressionBuilder(), request.getRequest()), AstStatementBuilder.StatementBuilderContext.builder().isExplain(request.isExplainRequest()).build()));
        LOG.info("[{}] Incoming request {}", (Object)QueryContext.getRequestId(), (Object)this.anonymizer.anonymizeStatement(statement));
        return this.queryExecutionFactory.create(statement, queryListener, explainListener);
    }

    @Generated
    public PPLService(PPLSyntaxParser parser, QueryManager queryManager, QueryPlanFactory queryExecutionFactory) {
        this.parser = parser;
        this.queryManager = queryManager;
        this.queryExecutionFactory = queryExecutionFactory;
    }
}

