/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.domain;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.sql.protocol.response.format.Format;

public class SQLQueryRequest {
    private static final Set<String> SUPPORTED_FIELDS = ImmutableSet.of((Object)"query", (Object)"fetch_size", (Object)"parameters");
    private static final String QUERY_PARAMS_FORMAT = "format";
    private static final String QUERY_PARAMS_SANITIZE = "sanitize";
    private final JSONObject jsonContent;
    private final String query;
    private final String path;
    private final String format;
    private Map<String, String> params = Collections.emptyMap();
    private boolean sanitize = true;

    public SQLQueryRequest(JSONObject jsonContent, String query, String path, Map<String, String> params) {
        this.jsonContent = jsonContent;
        this.query = query;
        this.path = path;
        this.params = params;
        this.format = this.getFormat(params);
        this.sanitize = this.shouldSanitize(params);
    }

    public boolean isSupported() {
        return this.isOnlySupportedFieldInPayload() && this.isFetchSizeZeroIfPresent() && this.isSupportedFormat();
    }

    public boolean isExplainRequest() {
        return this.path.endsWith("/_explain");
    }

    public Format format() {
        Optional optionalFormat = Format.of((String)this.format);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", this.format));
    }

    private boolean isOnlySupportedFieldInPayload() {
        return SUPPORTED_FIELDS.containsAll(this.jsonContent.keySet());
    }

    private boolean isFetchSizeZeroIfPresent() {
        return this.jsonContent.optInt("fetch_size") == 0;
    }

    private boolean isSupportedFormat() {
        return Strings.isNullOrEmpty((String)this.format) || "jdbc".equalsIgnoreCase(this.format) || "csv".equalsIgnoreCase(this.format) || "raw".equalsIgnoreCase(this.format);
    }

    private String getFormat(Map<String, String> params) {
        if (params.containsKey(QUERY_PARAMS_FORMAT)) {
            return params.get(QUERY_PARAMS_FORMAT);
        }
        return "jdbc";
    }

    private boolean shouldSanitize(Map<String, String> params) {
        if (params.containsKey(QUERY_PARAMS_SANITIZE)) {
            return Boolean.parseBoolean(params.get(QUERY_PARAMS_SANITIZE));
        }
        return true;
    }

    @Generated
    public String toString() {
        return "SQLQueryRequest(jsonContent=" + this.jsonContent + ", query=" + this.getQuery() + ", path=" + this.path + ", format=" + this.format + ", params=" + this.params + ", sanitize=" + this.sanitize() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLQueryRequest)) {
            return false;
        }
        SQLQueryRequest other = (SQLQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.sanitize() != other.sanitize()) {
            return false;
        }
        JSONObject this$jsonContent = this.jsonContent;
        JSONObject other$jsonContent = other.jsonContent;
        if (this$jsonContent == null ? other$jsonContent != null : !this$jsonContent.equals(other$jsonContent)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$format = this.format;
        String other$format = other.format;
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Map<String, String> this$params = this.params;
        Map<String, String> other$params = other.params;
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sanitize() ? 79 : 97);
        JSONObject $jsonContent = this.jsonContent;
        result = result * 59 + ($jsonContent == null ? 43 : $jsonContent.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $format = this.format;
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Map<String, String> $params = this.params;
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @Generated
    public SQLQueryRequest(JSONObject jsonContent, String query, String path, String format) {
        this.jsonContent = jsonContent;
        this.query = query;
        this.path = path;
        this.format = format;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public boolean sanitize() {
        return this.sanitize;
    }
}

