/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.util.GeneralizedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralizedTimeComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(GeneralizedTimeComparator.class);

    public GeneralizedTimeComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        GeneralizedTime assertTime;
        GeneralizedTime backendTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13753_COMPARING_GENERALIZED_TIME_ORDERING, backendValue, assertValue));
        }
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            backendTime = new GeneralizedTime(backendValue);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13724_INVALID_VALUE, backendValue), pe);
        }
        try {
            assertTime = new GeneralizedTime(assertValue);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13724_INVALID_VALUE, assertValue), pe);
        }
        return backendTime.compareTo(assertTime);
    }
}

