import { CallHierarchyIncomingCall, CallHierarchyItem, CallHierarchyOutgoingCall, CancellationToken, CodeAction, CodeActionContext, CompletionContext, DefinitionLink, Diagnostic, Hover, InlayHint, Location, Position, Range, ReferenceContext, SelectionRange, SemanticTokens, SignatureHelp, SignatureHelpContext, SymbolInformation, TextDocumentContentChangeEvent, WorkspaceEdit } from 'vscode-languageserver';
import { Document } from '../../lib/documents';
import { LSConfigManager } from '../../ls-config';
import { AppCompletionItem, AppCompletionList, CodeActionsProvider, CompletionsProvider, DefinitionsProvider, DiagnosticsProvider, DocumentSymbolsProvider, FileRename, FindReferencesProvider, FileReferencesProvider, FindComponentReferencesProvider, HoverProvider, ImplementationProvider, InlayHintProvider, OnWatchFileChanges, OnWatchFileChangesPara, RenameProvider, SelectionRangeProvider, SemanticTokensProvider, SignatureHelpProvider, TypeDefinitionProvider, UpdateImportsProvider, UpdateTsOrJsFile, CallHierarchyProvider } from '../interfaces';
import { CompletionEntryWithIdentifier } from './features/CompletionProvider';
import { LSAndTSDocResolver } from './LSAndTSDocResolver';
export declare class TypeScriptPlugin implements DiagnosticsProvider, HoverProvider, DocumentSymbolsProvider, DefinitionsProvider, CodeActionsProvider, UpdateImportsProvider, RenameProvider, FindReferencesProvider, FileReferencesProvider, FindComponentReferencesProvider, SelectionRangeProvider, SignatureHelpProvider, SemanticTokensProvider, ImplementationProvider, TypeDefinitionProvider, InlayHintProvider, CallHierarchyProvider, OnWatchFileChanges, CompletionsProvider<CompletionEntryWithIdentifier>, UpdateTsOrJsFile {
    __name: string;
    private readonly configManager;
    private readonly lsAndTsDocResolver;
    private readonly completionProvider;
    private readonly codeActionsProvider;
    private readonly updateImportsProvider;
    private readonly diagnosticsProvider;
    private readonly renameProvider;
    private readonly hoverProvider;
    private readonly findReferencesProvider;
    private readonly findFileReferencesProvider;
    private readonly findComponentReferencesProvider;
    private readonly selectionRangeProvider;
    private readonly signatureHelpProvider;
    private readonly semanticTokensProvider;
    private readonly implementationProvider;
    private readonly typeDefinitionProvider;
    private readonly inlayHintProvider;
    private readonly callHierarchyProvider;
    constructor(configManager: LSConfigManager, lsAndTsDocResolver: LSAndTSDocResolver, workspaceUris: string[]);
    getDiagnostics(document: Document, cancellationToken?: CancellationToken): Promise<Diagnostic[]>;
    doHover(document: Document, position: Position): Promise<Hover | null>;
    getDocumentSymbols(document: Document, cancellationToken?: CancellationToken): Promise<SymbolInformation[]>;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext, cancellationToken?: CancellationToken): Promise<AppCompletionList<CompletionEntryWithIdentifier> | null>;
    resolveCompletion(document: Document, completionItem: AppCompletionItem<CompletionEntryWithIdentifier>, cancellationToken?: CancellationToken): Promise<AppCompletionItem<CompletionEntryWithIdentifier>>;
    getDefinitions(document: Document, position: Position): Promise<DefinitionLink[]>;
    prepareRename(document: Document, position: Position): Promise<Range | null>;
    rename(document: Document, position: Position, newName: string): Promise<WorkspaceEdit | null>;
    getCodeActions(document: Document, range: Range, context: CodeActionContext, cancellationToken?: CancellationToken): Promise<CodeAction[]>;
    executeCommand(document: Document, command: string, args?: any[]): Promise<WorkspaceEdit | null>;
    updateImports(fileRename: FileRename): Promise<WorkspaceEdit | null>;
    findReferences(document: Document, position: Position, context: ReferenceContext): Promise<Location[] | null>;
    fileReferences(uri: string): Promise<Location[] | null>;
    findComponentReferences(uri: string): Promise<Location[] | null>;
    onWatchFileChanges(onWatchFileChangesParas: OnWatchFileChangesPara[]): Promise<void>;
    updateTsOrJsFile(fileName: string, changes: TextDocumentContentChangeEvent[]): Promise<void>;
    getSelectionRange(document: Document, position: Position): Promise<SelectionRange | null>;
    getSignatureHelp(document: Document, position: Position, context: SignatureHelpContext | undefined, cancellationToken?: CancellationToken): Promise<SignatureHelp | null>;
    getSemanticTokens(textDocument: Document, range?: Range, cancellationToken?: CancellationToken): Promise<SemanticTokens | null>;
    getImplementation(document: Document, position: Position): Promise<Location[] | null>;
    getTypeDefinition(document: Document, position: Position): Promise<Location[] | null>;
    getInlayHints(document: Document, range: Range, cancellationToken?: CancellationToken): Promise<InlayHint[] | null>;
    prepareCallHierarchy(document: Document, position: Position, cancellationToken?: CancellationToken): Promise<CallHierarchyItem[] | null>;
    getIncomingCalls(item: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyIncomingCall[] | null>;
    getOutgoingCalls(item: CallHierarchyItem, cancellationToken?: CancellationToken | undefined): Promise<CallHierarchyOutgoingCall[] | null>;
    private getLSAndTSDoc;
    /**
     * @internal Public for tests only
     */
    getSnapshotManager(fileName: string): Promise<import("./SnapshotManager").SnapshotManager>;
    private featureEnabled;
}
