import ts from 'typescript';
import { CancellationToken, CompletionContext, Position, TextDocumentIdentifier, TextEdit } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { LSConfigManager } from '../../../ls-config';
import { AppCompletionItem, AppCompletionList, CompletionsProvider } from '../../interfaces';
import { SvelteDocumentSnapshot } from '../DocumentSnapshot';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export interface CompletionEntryWithIdentifier extends ts.CompletionEntry, TextDocumentIdentifier {
    position: Position;
    __is_sveltekit$typeImport?: boolean;
}
export declare class CompletionsProviderImpl implements CompletionsProvider<CompletionEntryWithIdentifier> {
    private readonly lsAndTsDocResolver;
    private readonly configManager;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver, configManager: LSConfigManager);
    /**
     * The language service throws an error if the character is not a valid trigger character.
     * Also, the completions are worse.
     * Therefore, only use the characters the typescript compiler treats as valid.
     */
    private readonly validTriggerCharacters;
    private commitCharacters;
    /**
     * For performance reasons, try to reuse the last completion if possible.
     */
    private lastCompletion?;
    private isValidTriggerCharacter;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext, cancellationToken?: CancellationToken): Promise<AppCompletionList<CompletionEntryWithIdentifier> | null>;
    private canReuseLastCompletion;
    private getExistingImports;
    private getEventAndSlotLetCompletions;
    private componentInfoToCompletionEntry;
    private toCompletionItem;
    private getCompletionLabelAndInsert;
    private isExistingSvelteComponentImport;
    /**
     * If the textEdit is out of the word range of the triggered position
     * vscode would refuse to show the completions
     * split those edits into additionalTextEdit to fix it
     */
    private fixTextEditRange;
    /**
     * TypeScript throws a debug assertion error if the importModuleSpecifierEnding config is
     * 'js' and there's an unknown file extension - which is the case for `.svelte`. Therefore
     * rewrite the importModuleSpecifierEnding for this case to silence the error.
     */
    fixUserPreferencesForSvelteComponentImport(userPreferences: ts.UserPreferences): ts.UserPreferences;
    resolveCompletion(document: Document, completionItem: AppCompletionItem<CompletionEntryWithIdentifier>, cancellationToken?: CancellationToken): Promise<AppCompletionItem<CompletionEntryWithIdentifier>>;
    private getCompletionDocument;
    private codeActionChangesToTextEdit;
    codeActionChangeToTextEdit(doc: Document, snapshot: SvelteDocumentSnapshot, change: ts.TextChange, isImport: boolean, originalTriggerPosition: Position, is$typeImport?: boolean): TextEdit;
    private mapRangeForNewImport;
    private offsetLinesAndMovetoStartOfLine;
    private changeComponentImport;
}
