
#ifndef KNEWSTUFFCORE_EXPORT_H
#define KNEWSTUFFCORE_EXPORT_H

#ifdef KNEWSTUFFCORE_STATIC_DEFINE
#  define KNEWSTUFFCORE_EXPORT
#  define KNEWSTUFFCORE_NO_EXPORT
#else
#  ifndef KNEWSTUFFCORE_EXPORT
#    ifdef KF5NewStuffCore_EXPORTS
        /* We are building this library */
#      define KNEWSTUFFCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KNEWSTUFFCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KNEWSTUFFCORE_NO_EXPORT
#    define KNEWSTUFFCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KNEWSTUFFCORE_DECL_DEPRECATED
#  define KNEWSTUFFCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KNEWSTUFFCORE_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFFCORE_DECL_DEPRECATED_EXPORT KNEWSTUFFCORE_EXPORT KNEWSTUFFCORE_DECL_DEPRECATED
#endif

#ifndef KNEWSTUFFCORE_DECL_DEPRECATED_NO_EXPORT
#  define KNEWSTUFFCORE_DECL_DEPRECATED_NO_EXPORT KNEWSTUFFCORE_NO_EXPORT KNEWSTUFFCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KNEWSTUFFCORE_NO_DEPRECATED
#    define KNEWSTUFFCORE_NO_DEPRECATED
#  endif
#endif

#define KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KNEWSTUFFCORE_NO_DEPRECATED) && !defined(KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KNEWSTUFFCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KNEWSTUFFCORE_NO_DEPRECATED_WARNINGS) && !defined(KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KNEWSTUFFCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KNEWSTUFFCORE_NO_DEPRECATED)
#  undef KNEWSTUFFCORE_DEPRECATED
#  define KNEWSTUFFCORE_DEPRECATED_EXPORT KNEWSTUFFCORE_EXPORT
#  define KNEWSTUFFCORE_DEPRECATED_NO_EXPORT KNEWSTUFFCORE_NO_EXPORT
#elif defined(KNEWSTUFFCORE_NO_DEPRECATED_WARNINGS)
#  define KNEWSTUFFCORE_DEPRECATED
#  define KNEWSTUFFCORE_DEPRECATED_EXPORT KNEWSTUFFCORE_EXPORT
#  define KNEWSTUFFCORE_DEPRECATED_NO_EXPORT KNEWSTUFFCORE_NO_EXPORT
#else
#  define KNEWSTUFFCORE_DEPRECATED KNEWSTUFFCORE_DECL_DEPRECATED
#  define KNEWSTUFFCORE_DEPRECATED_EXPORT KNEWSTUFFCORE_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFFCORE_DEPRECATED_NO_EXPORT KNEWSTUFFCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KNEWSTUFFCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KNEWSTUFFCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KNEWSTUFFCORE_NO_DEPRECATED
#  define KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56800
#endif
#ifdef KNEWSTUFFCORE_NO_DEPRECATED_WARNINGS
#  define KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE 0x56800
#  endif
#endif

#ifndef KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KNEWSTUFFCORE_DEPRECATED
#  define KNEWSTUFFCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KNEWSTUFFCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KNEWSTUFFCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x51f00
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_31(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_31(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x52400
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_36(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_36(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x53500
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_53(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_53(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_71(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_71(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x54a00
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_74(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_74(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x54d00
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_77(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_77(text)
#endif

#if KNEWSTUFFCORE_DEPRECATED_WARNINGS_SINCE >= 0x55300
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_83(text) KNEWSTUFFCORE_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFCORE_DEPRECATED_VERSION_5_83(text)
#endif
#define KNEWSTUFFCORE_DEPRECATED_VERSION_5(minor, text)      KNEWSTUFFCORE_DEPRECATED_VERSION_5_##minor(text)
#define KNEWSTUFFCORE_DEPRECATED_VERSION(major, minor, text) KNEWSTUFFCORE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KNEWSTUFFCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KNEWSTUFFCORE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KNEWSTUFFCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KNEWSTUFFCORE_DEPRECATED_VERSION(major, minor, text)
#  define KNEWSTUFFCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KNEWSTUFFCORE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KNEWSTUFFCORE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KNEWSTUFFCORE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KNEWSTUFFCORE_EXPORT_H */
