/* page-view.c generated by valac 0.56.3, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo-gobject.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
enum  {
	PAGE_VIEW_0_PROPERTY,
	PAGE_VIEW_PAGE_PROPERTY,
	PAGE_VIEW_SELECTED_PROPERTY,
	PAGE_VIEW_X_OFFSET_PROPERTY,
	PAGE_VIEW_Y_OFFSET_PROPERTY,
	PAGE_VIEW_CURSOR_PROPERTY,
	PAGE_VIEW_WIDTH_PROPERTY,
	PAGE_VIEW_HEIGHT_PROPERTY,
	PAGE_VIEW_NUM_PROPERTIES
};
static GParamSpec* page_view_properties[PAGE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PAGE_VIEW_SIZE_CHANGED_SIGNAL,
	PAGE_VIEW_CHANGED_SIGNAL,
	PAGE_VIEW_NUM_SIGNALS
};
static guint page_view_signals[PAGE_VIEW_NUM_SIGNALS] = {0};

struct _PageView {
	GObject parent_instance;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GObjectClass parent_class;
};

struct _PageViewPrivate {
	Page* _page;
	GdkPixbuf* image;
	gboolean selected_;
	gint ruler_width;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width_;
	gint height_;
	gint _x_offset;
	gint _y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType _cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

static gint PageView_private_offset;
static gpointer page_view_parent_class = NULL;

VALA_EXTERN GType crop_location_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType page_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageView, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Page* page_view_get_page (PageView* self);
static void page_view_page_pixels_changed_cb (PageView* self,
                                       Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                            gpointer self);
static void page_view_page_size_changed_cb (PageView* self,
                                     Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                        gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self,
                                        Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                           gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                                gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self,
                                          Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                       gpointer self);
VALA_EXTERN PageView* page_view_new (Page* page);
VALA_EXTERN PageView* page_view_construct (GType object_type,
                               Page* page);
static void page_view_set_page (PageView* self,
                         Page* value);
static guchar page_view_get_sample (PageView* self,
                             guchar* pixels,
                             gint pixels_length1,
                             gint offset,
                             gint x,
                             gint depth,
                             gint sample);
static void page_view_get_pixel (PageView* self,
                          Page* page,
                          gint x,
                          gint y,
                          guchar* pixel,
                          gint pixel_length1);
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN gint page_get_scan_width (Page* self);
VALA_EXTERN gint page_get_scan_height (Page* self);
VALA_EXTERN gint page_get_depth (Page* self);
VALA_EXTERN gint page_get_n_channels (Page* self);
VALA_EXTERN guchar* page_get_pixels (Page* self,
                         gint* result_length1);
VALA_EXTERN gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self,
                          Page* page,
                          gdouble l,
                          gdouble r,
                          gdouble t,
                          gdouble b,
                          guchar* output,
                          gint output_length1,
                          gint offset);
static void page_view_update_preview (PageView* self,
                               Page* page,
                               GdkPixbuf** output_image,
                               gint output_width,
                               gint output_height,
                               ScanDirection scan_direction,
                               gint old_scan_line,
                               gint scan_line);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN gboolean page_get_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
VALA_EXTERN gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self,
                                 gint x);
static gint page_view_page_to_screen_y (PageView* self,
                                 gint y);
static gint page_view_screen_to_page_x (PageView* self,
                                 gint x);
static gint page_view_screen_to_page_y (PageView* self,
                                 gint y);
static CropLocation page_view_get_crop_location (PageView* self,
                                          gint x,
                                          gint y);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN gint page_get_crop_x (Page* self);
VALA_EXTERN gint page_get_crop_y (Page* self);
VALA_EXTERN gint page_get_crop_width (Page* self);
VALA_EXTERN gint page_get_crop_height (Page* self);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
VALA_EXTERN void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
VALA_EXTERN void page_view_motion (PageView* self,
                       gint x,
                       gint y);
static void page_view_set_cursor (PageView* self,
                           GdkCursorType value);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
VALA_EXTERN gboolean page_get_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
VALA_EXTERN void page_view_render (PageView* self,
                       cairo_t* context,
                       GdkRGBA* ruler_color);
VALA_EXTERN gint page_view_get_x_offset (PageView* self);
VALA_EXTERN gint page_view_get_y_offset (PageView* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN gboolean page_view_get_selected (PageView* self);
VALA_EXTERN void page_view_set_selected (PageView* self,
                             gboolean value);
VALA_EXTERN void page_view_set_x_offset (PageView* self,
                             gint value);
VALA_EXTERN void page_view_set_y_offset (PageView* self,
                             gint value);
VALA_EXTERN GdkCursorType page_view_get_cursor (PageView* self);
VALA_EXTERN gint page_view_get_width (PageView* self);
VALA_EXTERN void page_view_set_width (PageView* self,
                          gint value);
VALA_EXTERN gint page_view_get_height (PageView* self);
VALA_EXTERN void page_view_set_height (PageView* self,
                           gint value);
static void page_view_finalize (GObject * obj);
static GType page_view_get_type_once (void);
static void _vala_page_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_page_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
crop_location_get_type_once (void)
{
	static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
	GType crop_location_type_id;
	crop_location_type_id = g_enum_register_static ("CropLocation", values);
	return crop_location_type_id;
}

GType
crop_location_get_type (void)
{
	static volatile gsize crop_location_type_id__once = 0;
	if (g_once_init_enter (&crop_location_type_id__once)) {
		GType crop_location_type_id;
		crop_location_type_id = crop_location_get_type_once ();
		g_once_init_leave (&crop_location_type_id__once, crop_location_type_id);
	}
	return crop_location_type_id__once;
}

static inline gpointer
page_view_get_instance_private (PageView* self)
{
	return G_STRUCT_MEMBER_P (self, PageView_private_offset);
}

static void
_page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender,
                                                       gpointer self)
{
	page_view_page_pixels_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_size_changed_cb_page_size_changed (Page* _sender,
                                                   gpointer self)
{
	page_view_page_size_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender,
                                                      gpointer self)
{
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender,
                                                           gpointer self)
{
	page_view_page_overlay_changed_cb ((PageView*) self, _sender);
}

static void
_page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender,
                                                                  gpointer self)
{
	page_view_scan_direction_changed_cb ((PageView*) self, _sender);
}

PageView*
page_view_construct (GType object_type,
                     Page* page)
{
	PageView * self = NULL;
	g_return_val_if_fail (page != NULL, NULL);
	self = (PageView*) g_object_new (object_type, NULL);
	page_view_set_page (self, page);
	g_signal_connect_object (page, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self, 0);
	g_signal_connect_object (page, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self, 0);
	g_signal_connect_object (page, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self, 0);
	g_signal_connect_object (page, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self, 0);
	g_signal_connect_object (page, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self, 0);
	return self;
}

PageView*
page_view_new (Page* page)
{
	return page_view_construct (TYPE_PAGE_VIEW, page);
}

static guchar
page_view_get_sample (PageView* self,
                      guchar* pixels,
                      gint pixels_length1,
                      gint offset,
                      gint x,
                      gint depth,
                      gint sample)
{
	guchar result;
	g_return_val_if_fail (self != NULL, '\0');
	result = (guchar) 0xFF;
	return result;
}

static void
page_view_get_pixel (PageView* self,
                     Page* page,
                     gint x,
                     gint y,
                     guchar* pixel,
                     gint pixel_length1)
{
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	gint depth = 0;
	gint _tmp10_;
	gint _tmp11_;
	gint n_channels = 0;
	gint _tmp12_;
	gint _tmp13_;
	guchar* pixels = NULL;
	gint _tmp14_ = 0;
	guchar* _tmp15_;
	gint pixels_length1;
	gint _pixels_size_;
	gint offset = 0;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_ = FALSE;
	guchar* _tmp37_;
	gint _tmp37__length1;
	guchar* _tmp38_;
	gint _tmp38__length1;
	guchar* _tmp39_;
	gint _tmp39__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_scan_direction (page);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp2_ = page_get_scan_width (page);
			_tmp3_ = _tmp2_;
			x = (_tmp3_ - x) - 1;
			_tmp4_ = page_get_scan_height (page);
			_tmp5_ = _tmp4_;
			y = (_tmp5_ - y) - 1;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			gint t = 0;
			gint _tmp6_;
			gint _tmp7_;
			t = x;
			_tmp6_ = page_get_scan_width (page);
			_tmp7_ = _tmp6_;
			x = (_tmp7_ - y) - 1;
			y = t;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			gint t = 0;
			gint _tmp8_;
			gint _tmp9_;
			t = x;
			x = y;
			_tmp8_ = page_get_scan_height (page);
			_tmp9_ = _tmp8_;
			y = (_tmp9_ - t) - 1;
			break;
		}
		default:
		break;
	}
	_tmp10_ = page_get_depth (page);
	_tmp11_ = _tmp10_;
	depth = _tmp11_;
	_tmp12_ = page_get_n_channels (page);
	_tmp13_ = _tmp12_;
	n_channels = _tmp13_;
	_tmp15_ = page_get_pixels (page, &_tmp14_);
	pixels = _tmp15_;
	pixels_length1 = _tmp14_;
	_pixels_size_ = pixels_length1;
	_tmp16_ = page_get_rowstride (page);
	_tmp17_ = _tmp16_;
	offset = _tmp17_ * y;
	if (depth == 8) {
		_tmp18_ = n_channels == 3;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint o = 0;
		guchar* _tmp19_;
		gint _tmp19__length1;
		guchar _tmp20_;
		guchar* _tmp21_;
		gint _tmp21__length1;
		guchar _tmp22_;
		guchar* _tmp23_;
		gint _tmp23__length1;
		guchar _tmp24_;
		o = offset + (x * n_channels);
		_tmp19_ = pixels;
		_tmp19__length1 = pixels_length1;
		_tmp20_ = _tmp19_[o];
		pixel[0] = _tmp20_;
		_tmp21_ = pixels;
		_tmp21__length1 = pixels_length1;
		_tmp22_ = _tmp21_[o + 1];
		pixel[1] = _tmp22_;
		_tmp23_ = pixels;
		_tmp23__length1 = pixels_length1;
		_tmp24_ = _tmp23_[o + 2];
		pixel[2] = _tmp24_;
		return;
	} else {
		gboolean _tmp25_ = FALSE;
		if (depth == 8) {
			_tmp25_ = n_channels == 1;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			guchar* _tmp26_;
			gint _tmp26__length1;
			guchar _tmp27_;
			_tmp26_ = pixels;
			_tmp26__length1 = pixels_length1;
			_tmp27_ = _tmp26_[offset + x];
			pixel[2] = _tmp27_;
			pixel[1] = pixel[2];
			pixel[0] = pixel[1];
			return;
		} else {
			gboolean _tmp28_ = FALSE;
			if (depth == 1) {
				_tmp28_ = n_channels == 1;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gint o = 0;
				gint _tmp29_ = 0;
				guchar* _tmp30_;
				gint _tmp30__length1;
				guchar _tmp31_;
				o = offset + (x / 8);
				_tmp30_ = pixels;
				_tmp30__length1 = pixels_length1;
				_tmp31_ = _tmp30_[o];
				if (((gint) (_tmp31_ & (0x80 >> (x % 8)))) != 0) {
					_tmp29_ = 0x00;
				} else {
					_tmp29_ = 0xFF;
				}
				pixel[2] = (guchar) _tmp29_;
				pixel[1] = pixel[2];
				pixel[0] = pixel[1];
				return;
			} else {
				gboolean _tmp32_ = FALSE;
				if (depth == 2) {
					_tmp32_ = n_channels == 1;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					gint block_shift[4] = {0};
					gint _tmp33_[4] = {0};
					gint o = 0;
					gint sample = 0;
					guchar* _tmp34_;
					gint _tmp34__length1;
					guchar _tmp35_;
					gint _tmp36_;
					_tmp33_[0] = 6;
					_tmp33_[1] = 4;
					_tmp33_[2] = 2;
					_tmp33_[3] = 0;
					memcpy (block_shift, _tmp33_, 4 * sizeof (gint));
					o = offset + (x / 4);
					_tmp34_ = pixels;
					_tmp34__length1 = pixels_length1;
					_tmp35_ = _tmp34_[o];
					_tmp36_ = block_shift[x % 4];
					sample = (_tmp35_ >> _tmp36_) & 0x3;
					sample = (sample * 255) / 3;
					pixel[2] = (guchar) sample;
					pixel[1] = pixel[2];
					pixel[0] = pixel[1];
					return;
				}
			}
		}
	}
	_tmp37_ = pixels;
	_tmp37__length1 = pixels_length1;
	pixel[0] = page_view_get_sample (self, _tmp37_, (gint) _tmp37__length1, offset, x, depth, x * n_channels);
	_tmp38_ = pixels;
	_tmp38__length1 = pixels_length1;
	pixel[1] = page_view_get_sample (self, _tmp38_, (gint) _tmp38__length1, offset, x, depth, (x * n_channels) + 1);
	_tmp39_ = pixels;
	_tmp39__length1 = pixels_length1;
	pixel[2] = page_view_get_sample (self, _tmp39_, (gint) _tmp39__length1, offset, x, depth, (x * n_channels) + 2);
}

static void
page_view_set_pixel (PageView* self,
                     Page* page,
                     gdouble l,
                     gdouble r,
                     gdouble t,
                     gdouble b,
                     guchar* output,
                     gint output_length1,
                     gint offset)
{
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gdouble scale = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	L = (gint) l;
	if (((gdouble) L) != l) {
		gint _tmp0_;
		_tmp0_ = L;
		L = _tmp0_ + 1;
	}
	R = (gint) r;
	T = (gint) t;
	if (((gdouble) T) != t) {
		gint _tmp1_;
		_tmp1_ = T;
		T = _tmp1_ + 1;
	}
	B = (gint) b;
	red = 0.0;
	green = 0.0;
	blue = 0.0;
	if ((r - l) <= 1.0) {
		_tmp3_ = ((gint) r) == ((gint) l);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if ((b - t) <= 1.0) {
			_tmp4_ = ((gint) b) == ((gint) t);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		gdouble scale = 0.0;
		if (((gint) l) == ((gint) r)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = ((gint) t) == ((gint) b);
		}
		if (_tmp5_) {
			guchar p[3] = {0};
			guchar _tmp6_;
			guchar _tmp7_;
			guchar _tmp8_;
			page_view_get_pixel (self, page, (gint) l, (gint) t, p, (gint) 3);
			_tmp6_ = p[0];
			output[offset] = _tmp6_;
			_tmp7_ = p[1];
			output[offset + 1] = _tmp7_;
			_tmp8_ = p[2];
			output[offset + 2] = _tmp8_;
			return;
		}
		if (L > R) {
			guchar p[3] = {0};
			guchar _tmp9_;
			guchar _tmp10_;
			guchar _tmp11_;
			guchar _tmp17_;
			guchar _tmp18_;
			guchar _tmp19_;
			page_view_get_pixel (self, page, R, T - 1, p, (gint) 3);
			_tmp9_ = p[0];
			red += (_tmp9_ * (r - l)) * (T - t);
			_tmp10_ = p[1];
			green += (_tmp10_ * (r - l)) * (T - t);
			_tmp11_ = p[2];
			blue += (_tmp11_ * (r - l)) * (T - t);
			{
				gint y = 0;
				y = T;
				{
					gboolean _tmp12_ = FALSE;
					_tmp12_ = TRUE;
					while (TRUE) {
						guchar _tmp14_;
						guchar _tmp15_;
						guchar _tmp16_;
						if (!_tmp12_) {
							gint _tmp13_;
							_tmp13_ = y;
							y = _tmp13_ + 1;
						}
						_tmp12_ = FALSE;
						if (!(y < B)) {
							break;
						}
						page_view_get_pixel (self, page, R, y, p, (gint) 3);
						_tmp14_ = p[0];
						red += _tmp14_ * (r - l);
						_tmp15_ = p[1];
						green += _tmp15_ * (r - l);
						_tmp16_ = p[2];
						blue += _tmp16_ * (r - l);
					}
				}
			}
			page_view_get_pixel (self, page, R, B, p, (gint) 3);
			_tmp17_ = p[0];
			red += (_tmp17_ * (r - l)) * (b - B);
			_tmp18_ = p[1];
			green += (_tmp18_ * (r - l)) * (b - B);
			_tmp19_ = p[2];
			blue += (_tmp19_ * (r - l)) * (b - B);
		} else {
			guchar p[3] = {0};
			guchar _tmp20_;
			guchar _tmp21_;
			guchar _tmp22_;
			guchar _tmp28_;
			guchar _tmp29_;
			guchar _tmp30_;
			page_view_get_pixel (self, page, L - 1, B, p, (gint) 3);
			_tmp20_ = p[0];
			red += (_tmp20_ * (b - t)) * (L - l);
			_tmp21_ = p[1];
			green += (_tmp21_ * (b - t)) * (L - l);
			_tmp22_ = p[2];
			blue += (_tmp22_ * (b - t)) * (L - l);
			{
				gint x = 0;
				x = L;
				{
					gboolean _tmp23_ = FALSE;
					_tmp23_ = TRUE;
					while (TRUE) {
						guchar _tmp25_;
						guchar _tmp26_;
						guchar _tmp27_;
						if (!_tmp23_) {
							gint _tmp24_;
							_tmp24_ = x;
							x = _tmp24_ + 1;
						}
						_tmp23_ = FALSE;
						if (!(x < R)) {
							break;
						}
						page_view_get_pixel (self, page, x, B, p, (gint) 3);
						_tmp25_ = p[0];
						red += _tmp25_ * (b - t);
						_tmp26_ = p[1];
						green += _tmp26_ * (b - t);
						_tmp27_ = p[2];
						blue += _tmp27_ * (b - t);
					}
				}
			}
			page_view_get_pixel (self, page, R, B, p, (gint) 3);
			_tmp28_ = p[0];
			red += (_tmp28_ * (b - t)) * (r - R);
			_tmp29_ = p[1];
			green += (_tmp29_ * (b - t)) * (r - R);
			_tmp30_ = p[2];
			blue += (_tmp30_ * (b - t)) * (r - R);
		}
		scale = 1.0 / ((r - l) * (b - t));
		output[offset] = (guchar) ((red * scale) + 0.5);
		output[offset + 1] = (guchar) ((green * scale) + 0.5);
		output[offset + 2] = (guchar) ((blue * scale) + 0.5);
		return;
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = x;
					x = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				if (!(x < R)) {
					break;
				}
				{
					gint y = 0;
					y = T;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							guchar p[3] = {0};
							guchar _tmp35_;
							guchar _tmp36_;
							guchar _tmp37_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = y;
								y = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							if (!(y < B)) {
								break;
							}
							page_view_get_pixel (self, page, x, y, p, (gint) 3);
							_tmp35_ = p[0];
							red += (gdouble) _tmp35_;
							_tmp36_ = p[1];
							green += (gdouble) _tmp36_;
							_tmp37_ = p[2];
							blue += (gdouble) _tmp37_;
						}
					}
				}
			}
		}
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = x;
					x = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				if (!(x < R)) {
					break;
				}
				if (t != ((gdouble) T)) {
					guchar p[3] = {0};
					guchar _tmp40_;
					guchar _tmp41_;
					guchar _tmp42_;
					page_view_get_pixel (self, page, x, T - 1, p, (gint) 3);
					_tmp40_ = p[0];
					red += _tmp40_ * (T - t);
					_tmp41_ = p[1];
					green += _tmp41_ * (T - t);
					_tmp42_ = p[2];
					blue += _tmp42_ * (T - t);
				}
				if (b != ((gdouble) B)) {
					guchar p[3] = {0};
					guchar _tmp43_;
					guchar _tmp44_;
					guchar _tmp45_;
					page_view_get_pixel (self, page, x, B, p, (gint) 3);
					_tmp43_ = p[0];
					red += _tmp43_ * (b - B);
					_tmp44_ = p[1];
					green += _tmp44_ * (b - B);
					_tmp45_ = p[2];
					blue += _tmp45_ * (b - B);
				}
			}
		}
	}
	{
		gint y = 0;
		y = T;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = y;
					y = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				if (!(y < B)) {
					break;
				}
				if (l != ((gdouble) L)) {
					guchar p[3] = {0};
					guchar _tmp48_;
					guchar _tmp49_;
					guchar _tmp50_;
					page_view_get_pixel (self, page, L - 1, y, p, (gint) 3);
					_tmp48_ = p[0];
					red += _tmp48_ * (L - l);
					_tmp49_ = p[1];
					green += _tmp49_ * (L - l);
					_tmp50_ = p[2];
					blue += _tmp50_ * (L - l);
				}
				if (r != ((gdouble) R)) {
					guchar p[3] = {0};
					guchar _tmp51_;
					guchar _tmp52_;
					guchar _tmp53_;
					page_view_get_pixel (self, page, R, y, p, (gint) 3);
					_tmp51_ = p[0];
					red += _tmp51_ * (r - R);
					_tmp52_ = p[1];
					green += _tmp52_ * (r - R);
					_tmp53_ = p[2];
					blue += _tmp53_ * (r - R);
				}
			}
		}
	}
	if (l != ((gdouble) L)) {
		_tmp54_ = t != ((gdouble) T);
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		guchar p[3] = {0};
		guchar _tmp55_;
		guchar _tmp56_;
		guchar _tmp57_;
		page_view_get_pixel (self, page, L - 1, T - 1, p, (gint) 3);
		_tmp55_ = p[0];
		red += (_tmp55_ * (L - l)) * (T - t);
		_tmp56_ = p[1];
		green += (_tmp56_ * (L - l)) * (T - t);
		_tmp57_ = p[2];
		blue += (_tmp57_ * (L - l)) * (T - t);
	}
	if (r != ((gdouble) R)) {
		_tmp58_ = t != ((gdouble) T);
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		guchar p[3] = {0};
		guchar _tmp59_;
		guchar _tmp60_;
		guchar _tmp61_;
		page_view_get_pixel (self, page, R, T - 1, p, (gint) 3);
		_tmp59_ = p[0];
		red += (_tmp59_ * (r - R)) * (T - t);
		_tmp60_ = p[1];
		green += (_tmp60_ * (r - R)) * (T - t);
		_tmp61_ = p[2];
		blue += (_tmp61_ * (r - R)) * (T - t);
	}
	if (r != ((gdouble) R)) {
		_tmp62_ = b != ((gdouble) B);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		guchar p[3] = {0};
		guchar _tmp63_;
		guchar _tmp64_;
		guchar _tmp65_;
		page_view_get_pixel (self, page, R, B, p, (gint) 3);
		_tmp63_ = p[0];
		red += (_tmp63_ * (r - R)) * (b - B);
		_tmp64_ = p[1];
		green += (_tmp64_ * (r - R)) * (b - B);
		_tmp65_ = p[2];
		blue += (_tmp65_ * (r - R)) * (b - B);
	}
	if (l != ((gdouble) L)) {
		_tmp66_ = b != ((gdouble) B);
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		guchar p[3] = {0};
		guchar _tmp67_;
		guchar _tmp68_;
		guchar _tmp69_;
		page_view_get_pixel (self, page, L - 1, B, p, (gint) 3);
		_tmp67_ = p[0];
		red += (_tmp67_ * (L - l)) * (b - B);
		_tmp68_ = p[1];
		green += (_tmp68_ * (L - l)) * (b - B);
		_tmp69_ = p[2];
		blue += (_tmp69_ * (L - l)) * (b - B);
	}
	scale = 1.0 / ((r - l) * (b - t));
	output[offset] = (guchar) ((red * scale) + 0.5);
	output[offset + 1] = (guchar) ((green * scale) + 0.5);
	output[offset + 2] = (guchar) ((blue * scale) + 0.5);
}

static void
page_view_update_preview (PageView* self,
                          Page* page,
                          GdkPixbuf** output_image,
                          gint output_width,
                          gint output_height,
                          ScanDirection scan_direction,
                          gint old_scan_line,
                          gint scan_line)
{
	gint input_width = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint input_height = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guchar* output = NULL;
	guint8* _tmp11_;
	gint output_length1;
	gint _output_size_;
	gint output_rowstride = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint output_n_channels = 0;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_width (page);
	_tmp1_ = _tmp0_;
	input_width = _tmp1_;
	_tmp2_ = page_get_height (page);
	_tmp3_ = _tmp2_;
	input_height = _tmp3_;
	if ((*output_image) == NULL) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = gdk_pixbuf_get_width (*output_image);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_ != output_width;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = gdk_pixbuf_get_height (*output_image);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_ != output_height;
	}
	if (_tmp4_) {
		GdkPixbuf* _tmp10_;
		_tmp10_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, output_width, output_height);
		_g_object_unref0 (*output_image);
		*output_image = _tmp10_;
		L = 0;
		R = output_width - 1;
		T = 0;
		B = output_height - 1;
	} else {
		switch (scan_direction) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				L = 0;
				R = output_width - 1;
				T = (gint) ((((gdouble) old_scan_line) * output_height) / input_height);
				B = (gint) (((((gdouble) scan_line) * output_height) / input_height) + 0.5);
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				L = (gint) ((((gdouble) old_scan_line) * output_width) / input_width);
				R = (gint) (((((gdouble) scan_line) * output_width) / input_width) + 0.5);
				T = 0;
				B = output_height - 1;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				L = 0;
				R = output_width - 1;
				T = (gint) ((((gdouble) (input_height - scan_line)) * output_height) / input_height);
				B = (gint) (((((gdouble) (input_height - old_scan_line)) * output_height) / input_height) + 0.5);
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				L = (gint) ((((gdouble) (input_width - scan_line)) * output_width) / input_width);
				R = (gint) (((((gdouble) (input_width - old_scan_line)) * output_width) / input_width) + 0.5);
				T = 0;
				B = output_height - 1;
				break;
			}
			default:
			{
				T = 0;
				B = T;
				R = B;
				L = R;
				break;
			}
		}
	}
	if (R >= output_width) {
		R = output_width - 1;
	}
	if (B >= output_height) {
		B = output_height - 1;
	}
	g_return_if_fail (L >= 0);
	g_return_if_fail (R < output_width);
	g_return_if_fail (T >= 0);
	g_return_if_fail (B < output_height);
	g_return_if_fail ((*output_image) != NULL);
	_tmp11_ = gdk_pixbuf_get_pixels (*output_image);
	output = _tmp11_;
	output_length1 = -1;
	_output_size_ = output_length1;
	_tmp12_ = gdk_pixbuf_get_rowstride (*output_image);
	_tmp13_ = _tmp12_;
	output_rowstride = _tmp13_;
	_tmp14_ = gdk_pixbuf_get_n_channels (*output_image);
	_tmp15_ = _tmp14_;
	output_n_channels = _tmp15_;
	_tmp16_ = page_get_has_data (page);
	_tmp17_ = _tmp16_;
	if (!_tmp17_) {
		{
			gint x = 0;
			x = L;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = x;
						x = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(x <= R)) {
						break;
					}
					{
						gint y = 0;
						y = T;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								gint o = 0;
								guchar* _tmp22_;
								gint _tmp22__length1;
								guchar* _tmp23_;
								gint _tmp23__length1;
								guchar* _tmp24_;
								gint _tmp24__length1;
								if (!_tmp20_) {
									gint _tmp21_;
									_tmp21_ = y;
									y = _tmp21_ + 1;
								}
								_tmp20_ = FALSE;
								if (!(y <= B)) {
									break;
								}
								o = (output_rowstride * y) + (x * output_n_channels);
								_tmp22_ = output;
								_tmp22__length1 = output_length1;
								_tmp23_ = output;
								_tmp23__length1 = output_length1;
								_tmp24_ = output;
								_tmp24__length1 = output_length1;
								_tmp24_[o + 2] = (guchar) 0xFF;
								_tmp23_[o + 1] = _tmp24_[o + 2];
								_tmp22_[o] = _tmp23_[o + 1];
							}
						}
					}
				}
			}
		}
		return;
	}
	{
		gint x = 0;
		x = L;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gdouble l = 0.0;
				gdouble r = 0.0;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = x;
					x = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				if (!(x <= R)) {
					break;
				}
				l = (((gdouble) x) * input_width) / output_width;
				r = (((gdouble) (x + 1)) * input_width) / output_width;
				{
					gint y = 0;
					y = T;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gdouble t = 0.0;
							gdouble b = 0.0;
							guchar* _tmp29_;
							gint _tmp29__length1;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = y;
								y = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							if (!(y <= B)) {
								break;
							}
							t = (((gdouble) y) * input_height) / output_height;
							b = (((gdouble) (y + 1)) * input_height) / output_height;
							_tmp29_ = output;
							_tmp29__length1 = output_length1;
							page_view_set_pixel (self, page, l, r, t, b, _tmp29_, (gint) _tmp29__length1, (output_rowstride * y) + (x * output_n_channels));
						}
					}
				}
			}
		}
	}
}

static gint
page_view_get_preview_width (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->width_ - ((self->priv->border_width + self->priv->ruler_width) * 2);
	return result;
}

static gint
page_view_get_preview_height (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->height_ - ((self->priv->border_width + self->priv->ruler_width) * 2);
	return result;
}

static void
page_view_update_page_view (PageView* self)
{
	gint old_scan_line = 0;
	gint scan_line = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ScanDirection left_steps = 0;
	Page* _tmp3_;
	ScanDirection _tmp4_;
	ScanDirection _tmp5_;
	gboolean _tmp6_ = FALSE;
	Page* _tmp8_;
	ScanDirection _tmp9_;
	ScanDirection _tmp10_;
	Page* _tmp11_;
	Page* _tmp12_;
	ScanDirection _tmp13_;
	ScanDirection _tmp14_;
	g_return_if_fail (self != NULL);
	if (!self->priv->update_image) {
		return;
	}
	old_scan_line = self->priv->scan_line;
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_scan_line (_tmp0_);
	_tmp2_ = _tmp1_;
	scan_line = _tmp2_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_scan_direction (_tmp3_);
	_tmp5_ = _tmp4_;
	left_steps = self->priv->scan_direction - _tmp5_;
	if (left_steps != 0) {
		GdkPixbuf* _tmp7_;
		_tmp7_ = self->priv->image;
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_g_object_unref0 (self->priv->image);
		self->priv->image = NULL;
	}
	_tmp8_ = self->priv->_page;
	_tmp9_ = page_get_scan_direction (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->scan_direction = _tmp10_;
	_tmp11_ = self->priv->_page;
	_tmp12_ = self->priv->_page;
	_tmp13_ = page_get_scan_direction (_tmp12_);
	_tmp14_ = _tmp13_;
	page_view_update_preview (self, _tmp11_, &self->priv->image, page_view_get_preview_width (self), page_view_get_preview_height (self), _tmp14_, old_scan_line, scan_line);
	self->priv->update_image = FALSE;
	self->priv->scan_line = scan_line;
}

static gint
page_view_page_to_screen_x (PageView* self,
                            gint x)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) x) * page_view_get_preview_width (self)) / _tmp2_) + 0.5);
	return result;
}

static gint
page_view_page_to_screen_y (PageView* self,
                            gint y)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) y) * page_view_get_preview_height (self)) / _tmp2_) + 0.5);
	return result;
}

static gint
page_view_screen_to_page_x (PageView* self,
                            gint x)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) x) * _tmp2_) / page_view_get_preview_width (self)) + 0.5);
	return result;
}

static gint
page_view_screen_to_page_y (PageView* self,
                            gint y)
{
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint) (((((gdouble) y) * _tmp2_) / page_view_get_preview_height (self)) + 0.5);
	return result;
}

static CropLocation
page_view_get_crop_location (PageView* self,
                             gint x,
                             gint y)
{
	Page* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint cx = 0;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cy = 0;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint cw = 0;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint ch = 0;
	Page* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint dx = 0;
	gint dy = 0;
	gint dw = 0;
	gint dh = 0;
	gint ix = 0;
	gint iy = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gchar* name = NULL;
	Page* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gint crop_border = 0;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	CropLocation result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_has_crop (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		result = CROP_LOCATION_NONE;
		return result;
	}
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_crop_x (_tmp3_);
	_tmp5_ = _tmp4_;
	cx = _tmp5_;
	_tmp6_ = self->priv->_page;
	_tmp7_ = page_get_crop_y (_tmp6_);
	_tmp8_ = _tmp7_;
	cy = _tmp8_;
	_tmp9_ = self->priv->_page;
	_tmp10_ = page_get_crop_width (_tmp9_);
	_tmp11_ = _tmp10_;
	cw = _tmp11_;
	_tmp12_ = self->priv->_page;
	_tmp13_ = page_get_crop_height (_tmp12_);
	_tmp14_ = _tmp13_;
	ch = _tmp14_;
	dx = (page_view_page_to_screen_x (self, cx) + self->priv->border_width) + self->priv->ruler_width;
	dy = (page_view_page_to_screen_y (self, cy) + self->priv->border_width) + self->priv->ruler_width;
	dw = (page_view_page_to_screen_x (self, cw) + self->priv->border_width) + self->priv->ruler_width;
	dh = (page_view_page_to_screen_y (self, ch) + self->priv->border_width) + self->priv->ruler_width;
	ix = x - dx;
	iy = y - dy;
	if (ix < 0) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = ix > dw;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = iy < 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = iy > dh;
	}
	if (_tmp15_) {
		result = CROP_LOCATION_NONE;
		return result;
	}
	_tmp18_ = self->priv->_page;
	_tmp19_ = page_get_crop_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup (_tmp20_);
	name = _tmp21_;
	_tmp22_ = name;
	if (_tmp22_ != NULL) {
		result = CROP_LOCATION_MIDDLE;
		_g_free0 (name);
		return result;
	}
	crop_border = 20;
	if (dw < (crop_border * 3)) {
		crop_border = dw / 3;
	}
	if (dh < (crop_border * 3)) {
		crop_border = dh / 3;
	}
	if (ix < crop_border) {
		_tmp23_ = iy < crop_border;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		result = CROP_LOCATION_TOP_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		_tmp24_ = iy < crop_border;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = CROP_LOCATION_TOP_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (ix < crop_border) {
		_tmp25_ = iy > (dh - crop_border);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		result = CROP_LOCATION_BOTTOM_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		_tmp26_ = iy > (dh - crop_border);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = CROP_LOCATION_BOTTOM_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (ix < crop_border) {
		result = CROP_LOCATION_LEFT;
		_g_free0 (name);
		return result;
	}
	if (ix > (dw - crop_border)) {
		result = CROP_LOCATION_RIGHT;
		_g_free0 (name);
		return result;
	}
	if (iy < crop_border) {
		result = CROP_LOCATION_TOP;
		_g_free0 (name);
		return result;
	}
	if (iy > (dh - crop_border)) {
		result = CROP_LOCATION_BOTTOM;
		_g_free0 (name);
		return result;
	}
	result = CROP_LOCATION_MIDDLE;
	_g_free0 (name);
	return result;
}

void
page_view_button_press (PageView* self,
                        gint x,
                        gint y)
{
	CropLocation location = 0;
	g_return_if_fail (self != NULL);
	location = page_view_get_crop_location (self, x, y);
	if (location != CROP_LOCATION_NONE) {
		Page* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		Page* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		Page* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		Page* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		self->priv->crop_location = location;
		self->priv->selected_crop_px = (gdouble) x;
		self->priv->selected_crop_py = (gdouble) y;
		_tmp0_ = self->priv->_page;
		_tmp1_ = page_get_crop_x (_tmp0_);
		_tmp2_ = _tmp1_;
		self->priv->selected_crop_x = _tmp2_;
		_tmp3_ = self->priv->_page;
		_tmp4_ = page_get_crop_y (_tmp3_);
		_tmp5_ = _tmp4_;
		self->priv->selected_crop_y = _tmp5_;
		_tmp6_ = self->priv->_page;
		_tmp7_ = page_get_crop_width (_tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->selected_crop_w = _tmp8_;
		_tmp9_ = self->priv->_page;
		_tmp10_ = page_get_crop_height (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->selected_crop_h = _tmp11_;
	}
}

void
page_view_motion (PageView* self,
                  gint x,
                  gint y)
{
	CropLocation location = 0;
	GdkCursorType cursor = 0;
	gint pw = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint ph = 0;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cw = 0;
	Page* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint ch = 0;
	Page* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint dx = 0;
	gint dy = 0;
	gint new_x = 0;
	gint new_y = 0;
	gint new_w = 0;
	gint new_h = 0;
	gint min_size = 0;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	Page* _tmp28_;
	gboolean _tmp29_ = FALSE;
	g_return_if_fail (self != NULL);
	location = page_view_get_crop_location (self, x, y);
	switch (location) {
		case CROP_LOCATION_MIDDLE:
		{
			cursor = GDK_HAND1;
			break;
		}
		case CROP_LOCATION_TOP:
		{
			cursor = GDK_TOP_SIDE;
			break;
		}
		case CROP_LOCATION_BOTTOM:
		{
			cursor = GDK_BOTTOM_SIDE;
			break;
		}
		case CROP_LOCATION_LEFT:
		{
			cursor = GDK_LEFT_SIDE;
			break;
		}
		case CROP_LOCATION_RIGHT:
		{
			cursor = GDK_RIGHT_SIDE;
			break;
		}
		case CROP_LOCATION_TOP_LEFT:
		{
			cursor = GDK_TOP_LEFT_CORNER;
			break;
		}
		case CROP_LOCATION_TOP_RIGHT:
		{
			cursor = GDK_TOP_RIGHT_CORNER;
			break;
		}
		case CROP_LOCATION_BOTTOM_LEFT:
		{
			cursor = GDK_BOTTOM_LEFT_CORNER;
			break;
		}
		case CROP_LOCATION_BOTTOM_RIGHT:
		{
			cursor = GDK_BOTTOM_RIGHT_CORNER;
			break;
		}
		default:
		{
			cursor = GDK_ARROW;
			break;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_NONE) {
		page_view_set_cursor (self, cursor);
		return;
	}
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	pw = _tmp2_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	ph = _tmp5_;
	_tmp6_ = self->priv->_page;
	_tmp7_ = page_get_crop_width (_tmp6_);
	_tmp8_ = _tmp7_;
	cw = _tmp8_;
	_tmp9_ = self->priv->_page;
	_tmp10_ = page_get_crop_height (_tmp9_);
	_tmp11_ = _tmp10_;
	ch = _tmp11_;
	dx = page_view_screen_to_page_x (self, x - ((gint) self->priv->selected_crop_px));
	dy = page_view_screen_to_page_y (self, y - ((gint) self->priv->selected_crop_py));
	new_x = self->priv->selected_crop_x;
	new_y = self->priv->selected_crop_y;
	new_w = self->priv->selected_crop_w;
	new_h = self->priv->selected_crop_h;
	min_size = page_view_screen_to_page_x (self, 15);
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = self->priv->crop_location == CROP_LOCATION_LEFT;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT;
	}
	if (_tmp12_) {
		if (dx > (new_w - min_size)) {
			dx = new_w - min_size;
		}
		if ((new_x + dx) < 0) {
			dx = -new_x;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = self->priv->crop_location == CROP_LOCATION_TOP;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = self->priv->crop_location == CROP_LOCATION_TOP_RIGHT;
	}
	if (_tmp14_) {
		if (dy > (new_h - min_size)) {
			dy = new_h - min_size;
		}
		if ((new_y + dy) < 0) {
			dy = -new_y;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_RIGHT) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = self->priv->crop_location == CROP_LOCATION_RIGHT;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp16_) {
		if (dx < (min_size - new_w)) {
			dx = min_size - new_w;
		}
		if (((new_x + new_w) + dx) > pw) {
			dx = (pw - new_x) - new_w;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = self->priv->crop_location == CROP_LOCATION_BOTTOM;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp18_) {
		if (dy < (min_size - new_h)) {
			dy = min_size - new_h;
		}
		if (((new_y + new_h) + dy) > ph) {
			dy = (ph - new_y) - new_h;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_MIDDLE) {
		if (((new_x + dx) + new_w) > pw) {
			dx = (pw - new_x) - new_w;
		}
		if ((new_x + dx) < 0) {
			dx = -new_x;
		}
		if (((new_y + dy) + new_h) > ph) {
			dy = (ph - new_y) - new_h;
		}
		if ((new_y + dy) < 0) {
			dy = -new_y;
		}
	}
	if (self->priv->crop_location == CROP_LOCATION_MIDDLE) {
		new_x += dx;
		new_y += dy;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = self->priv->crop_location == CROP_LOCATION_LEFT;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT;
	}
	if (_tmp20_) {
		new_x += dx;
		new_w -= dx;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_LEFT) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = self->priv->crop_location == CROP_LOCATION_TOP;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = self->priv->crop_location == CROP_LOCATION_TOP_RIGHT;
	}
	if (_tmp22_) {
		new_y += dy;
		new_h -= dy;
	}
	if (self->priv->crop_location == CROP_LOCATION_TOP_RIGHT) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = self->priv->crop_location == CROP_LOCATION_RIGHT;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp24_) {
		new_w += dx;
	}
	if (self->priv->crop_location == CROP_LOCATION_BOTTOM_LEFT) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = self->priv->crop_location == CROP_LOCATION_BOTTOM;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = self->priv->crop_location == CROP_LOCATION_BOTTOM_RIGHT;
	}
	if (_tmp26_) {
		new_h += dy;
	}
	_tmp28_ = self->priv->_page;
	page_move_crop (_tmp28_, new_x, new_y);
	if (new_w != cw) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = new_h != ch;
	}
	if (_tmp29_) {
		Page* _tmp30_;
		_tmp30_ = self->priv->_page;
		page_set_custom_crop (_tmp30_, new_w, new_h);
	}
}

void
page_view_button_release (PageView* self,
                          gint x,
                          gint y)
{
	g_return_if_fail (self != NULL);
	self->priv->crop_location = CROP_LOCATION_NONE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static gboolean
page_view_animation_cb (PageView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->animate_segment = (self->priv->animate_segment + 1) % self->priv->animate_n_segments;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
_page_view_animation_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = page_view_animation_cb ((PageView*) self);
	return result;
}

static void
page_view_update_animation (PageView* self)
{
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_page;
	_tmp2_ = page_get_is_scanning (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_page;
		_tmp5_ = page_get_has_data (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	animate = _tmp0_;
	is_animating = self->priv->animate_timeout != ((guint) 0);
	if (animate == is_animating) {
		return;
	}
	if (animate) {
		self->priv->animate_segment = 0;
		if (self->priv->animate_timeout == ((guint) 0)) {
			self->priv->animate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
	} else {
		if (self->priv->animate_timeout != ((guint) 0)) {
			g_source_remove (self->priv->animate_timeout);
		}
		self->priv->animate_timeout = (guint) 0;
	}
}

void
page_view_render (PageView* self,
                  cairo_t* context,
                  GdkRGBA* ruler_color)
{
	gint w = 0;
	gint h = 0;
	gint _tmp0_;
	gint _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkRGBA _tmp3_;
	gint ruler_tick = 0;
	gdouble line = 0.0;
	gint big_ruler_tick = 0;
	gboolean _tmp16_ = FALSE;
	Page* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	Page* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (ruler_color != NULL);
	page_view_update_animation (self);
	page_view_update_page_view (self);
	w = page_view_get_preview_width (self);
	h = page_view_get_preview_height (self);
	cairo_set_line_width (context, (gdouble) 1);
	_tmp0_ = self->priv->_x_offset;
	_tmp1_ = self->priv->_y_offset;
	cairo_translate (context, (gdouble) _tmp0_, (gdouble) _tmp1_);
	cairo_translate (context, (gdouble) (self->priv->border_width + self->priv->ruler_width), (gdouble) (self->priv->border_width + self->priv->ruler_width));
	_tmp2_ = self->priv->image;
	gdk_cairo_set_source_pixbuf (context, _tmp2_, (gdouble) 0, (gdouble) 0);
	cairo_paint (context);
	_tmp3_ = *ruler_color;
	gdk_cairo_set_source_rgba (context, &_tmp3_);
	cairo_set_line_width (context, (gdouble) self->priv->border_width);
	cairo_rectangle (context, (gdouble) 0, 0.0, (gdouble) w, (gdouble) h);
	cairo_stroke (context);
	cairo_set_line_width (context, (gdouble) 1);
	ruler_tick = 0;
	line = 0.0;
	big_ruler_tick = 5;
	while (TRUE) {
		Page* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		Page* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp4_ = self->priv->_page;
		_tmp5_ = page_get_width (_tmp4_);
		_tmp6_ = _tmp5_;
		if (!(ruler_tick <= _tmp6_)) {
			break;
		}
		line = page_view_page_to_screen_x (self, ruler_tick) + 0.5;
		if (big_ruler_tick == 5) {
			cairo_move_to (context, line, (gdouble) 0);
			cairo_line_to (context, line, (gdouble) (-self->priv->ruler_width));
			cairo_move_to (context, line, (gdouble) h);
			cairo_line_to (context, line, (gdouble) (h + self->priv->ruler_width));
			big_ruler_tick = 0;
		} else {
			cairo_move_to (context, line, (gdouble) -2);
			cairo_line_to (context, line, (gdouble) -5);
			cairo_move_to (context, line, (gdouble) (h + 2));
			cairo_line_to (context, line, (gdouble) (h + 5));
		}
		_tmp7_ = self->priv->_page;
		_tmp8_ = page_get_dpi (_tmp7_);
		_tmp9_ = _tmp8_;
		ruler_tick = ruler_tick + (_tmp9_ / 5);
		big_ruler_tick = big_ruler_tick + 1;
	}
	cairo_stroke (context);
	ruler_tick = 0;
	line = 0.0;
	big_ruler_tick = 5;
	while (TRUE) {
		Page* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		Page* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp10_ = self->priv->_page;
		_tmp11_ = page_get_height (_tmp10_);
		_tmp12_ = _tmp11_;
		if (!(ruler_tick <= _tmp12_)) {
			break;
		}
		line = page_view_page_to_screen_y (self, ruler_tick) + 0.5;
		if (big_ruler_tick == 5) {
			cairo_move_to (context, (gdouble) 0, line);
			cairo_line_to (context, (gdouble) (-self->priv->ruler_width), line);
			cairo_move_to (context, (gdouble) w, line);
			cairo_line_to (context, (gdouble) (w + self->priv->ruler_width), line);
			big_ruler_tick = 0;
		} else {
			cairo_move_to (context, (gdouble) -2, line);
			cairo_line_to (context, (gdouble) -5, line);
			cairo_move_to (context, (gdouble) (w + 2), line);
			cairo_line_to (context, (gdouble) (w + 5), line);
		}
		_tmp13_ = self->priv->_page;
		_tmp14_ = page_get_dpi (_tmp13_);
		_tmp15_ = _tmp14_;
		ruler_tick = ruler_tick + (_tmp15_ / 5);
		big_ruler_tick = big_ruler_tick + 1;
	}
	cairo_stroke (context);
	_tmp17_ = self->priv->_page;
	_tmp18_ = page_get_is_scanning (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		Page* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = self->priv->_page;
		_tmp21_ = page_get_scan_line (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gint scan_line = 0;
		Page* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp26_;
		ScanDirection _tmp27_;
		ScanDirection _tmp28_;
		_tmp23_ = self->priv->_page;
		_tmp24_ = page_get_scan_line (_tmp23_);
		_tmp25_ = _tmp24_;
		scan_line = _tmp25_;
		_tmp26_ = self->priv->_page;
		_tmp27_ = page_get_scan_direction (_tmp26_);
		_tmp28_ = _tmp27_;
		switch (_tmp28_) {
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
			{
				s = (gdouble) page_view_page_to_screen_y (self, scan_line);
				x1 = (gdouble) 0;
				y1 = s + 0.5;
				x2 = (gdouble) w;
				y2 = s + 0.5;
				break;
			}
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
			{
				s = (gdouble) page_view_page_to_screen_y (self, scan_line);
				x1 = (gdouble) 0;
				y1 = (h - s) + 0.5;
				x2 = (gdouble) w;
				y2 = (h - s) + 0.5;
				break;
			}
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
			{
				s = (gdouble) page_view_page_to_screen_x (self, scan_line);
				x1 = s + 0.5;
				y1 = (gdouble) 0;
				x2 = s + 0.5;
				y2 = (gdouble) h;
				break;
			}
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
			{
				s = (gdouble) page_view_page_to_screen_x (self, scan_line);
				x1 = (w - s) + 0.5;
				y1 = (gdouble) 0;
				x2 = (w - s) + 0.5;
				y2 = (gdouble) h;
				break;
			}
			default:
			{
				y2 = (gdouble) 0;
				x2 = y2;
				y1 = x2;
				x1 = y1;
				break;
			}
		}
		cairo_move_to (context, x1, y1);
		cairo_line_to (context, x2, y2);
		cairo_set_source_rgb (context, 1.0, 0.0, 0.0);
		cairo_stroke (context);
	}
	_tmp29_ = self->priv->_page;
	_tmp30_ = page_get_has_crop (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		gint x = 0;
		Page* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint y = 0;
		Page* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint crop_width = 0;
		Page* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint crop_height = 0;
		Page* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint dx = 0;
		gint dy = 0;
		gint dw = 0;
		gint dh = 0;
		_tmp32_ = self->priv->_page;
		_tmp33_ = page_get_crop_x (_tmp32_);
		_tmp34_ = _tmp33_;
		x = _tmp34_;
		_tmp35_ = self->priv->_page;
		_tmp36_ = page_get_crop_y (_tmp35_);
		_tmp37_ = _tmp36_;
		y = _tmp37_;
		_tmp38_ = self->priv->_page;
		_tmp39_ = page_get_crop_width (_tmp38_);
		_tmp40_ = _tmp39_;
		crop_width = _tmp40_;
		_tmp41_ = self->priv->_page;
		_tmp42_ = page_get_crop_height (_tmp41_);
		_tmp43_ = _tmp42_;
		crop_height = _tmp43_;
		dx = page_view_page_to_screen_x (self, x);
		dy = page_view_page_to_screen_y (self, y);
		dw = page_view_page_to_screen_x (self, crop_width);
		dh = page_view_page_to_screen_y (self, crop_height);
		cairo_rectangle (context, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
		cairo_new_sub_path (context);
		cairo_rectangle (context, (gdouble) dx, (gdouble) dy, (gdouble) dw, (gdouble) dh);
		cairo_set_fill_rule (context, CAIRO_FILL_RULE_EVEN_ODD);
		cairo_set_source_rgba (context, 0.25, 0.25, 0.25, 0.2);
		cairo_fill (context);
		cairo_set_source_rgb (context, 1.0, 1.0, 1.0);
		cairo_move_to (context, (gdouble) (-self->priv->border_width), dy - 1.5);
		cairo_line_to (context, (gdouble) (self->priv->border_width + w), dy - 1.5);
		cairo_move_to (context, (gdouble) (-self->priv->border_width), (dy + dh) + 1.5);
		cairo_line_to (context, (gdouble) (self->priv->border_width + w), (dy + dh) + 1.5);
		cairo_stroke (context);
		cairo_move_to (context, dx - 1.5, (gdouble) (-self->priv->border_width));
		cairo_line_to (context, dx - 1.5, (gdouble) (self->priv->border_width + h));
		cairo_move_to (context, (dx + dw) + 1.5, (gdouble) (-self->priv->border_width));
		cairo_line_to (context, (dx + dw) + 1.5, (gdouble) (self->priv->border_width + h));
		cairo_stroke (context);
		cairo_rectangle (context, dx - 0.5, dy - 0.5, (gdouble) (dw + 1), (gdouble) (dh + 1));
		cairo_set_source_rgb (context, 0.0, 0.0, 0.0);
		cairo_stroke (context);
	}
}

static void
page_view_page_pixels_changed_cb (PageView* self,
                                  Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_page_size_changed_cb (PageView* self,
                                Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_page_overlay_changed_cb (PageView* self,
                                   Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

static void
page_view_scan_direction_changed_cb (PageView* self,
                                     Page* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
}

Page*
page_view_get_page (PageView* self)
{
	Page* result;
	Page* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
page_view_set_page (PageView* self,
                    Page* value)
{
	Page* old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_page (self);
	if (old_value != value) {
		Page* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_page);
		self->priv->_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_PAGE_PROPERTY]);
	}
}

gboolean
page_view_get_selected (PageView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->selected_;
	return result;
}

void
page_view_set_selected (PageView* self,
                        gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp2_ = page_view_get_selected (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = page_view_get_selected (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = page_view_get_selected (self);
		_tmp8_ = _tmp7_;
		if (!_tmp8_) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = page_view_get_selected (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = !_tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = page_view_get_selected (self);
	_tmp12_ = _tmp11_;
	page_view_set_selected (self, _tmp12_);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_SELECTED_PROPERTY]);
}

gint
page_view_get_x_offset (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_x_offset;
	return result;
}

void
page_view_set_x_offset (PageView* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_x_offset (self);
	if (old_value != value) {
		self->priv->_x_offset = value;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_X_OFFSET_PROPERTY]);
	}
}

gint
page_view_get_y_offset (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_y_offset;
	return result;
}

void
page_view_set_y_offset (PageView* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_y_offset (self);
	if (old_value != value) {
		self->priv->_y_offset = value;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_Y_OFFSET_PROPERTY]);
	}
}

GdkCursorType
page_view_get_cursor (PageView* self)
{
	GdkCursorType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cursor;
	return result;
}

static void
page_view_set_cursor (PageView* self,
                      GdkCursorType value)
{
	GdkCursorType old_value;
	g_return_if_fail (self != NULL);
	old_value = page_view_get_cursor (self);
	if (old_value != value) {
		self->priv->_cursor = value;
		g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_CURSOR_PROPERTY]);
	}
}

gint
page_view_get_width (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->width_;
	return result;
}

void
page_view_set_width (PageView* self,
                     gint value)
{
	gint h = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_width (_tmp3_);
	_tmp5_ = _tmp4_;
	h = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
	if (self->priv->width_ == value) {
		_tmp6_ = self->priv->height_ == h;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	self->priv->width_ = value;
	self->priv->height_ = h;
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_WIDTH_PROPERTY]);
}

gint
page_view_get_height (PageView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->height_;
	return result;
}

void
page_view_set_height (PageView* self,
                      gint value)
{
	gint w = 0;
	Page* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_page;
	_tmp1_ = page_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_page;
	_tmp4_ = page_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	w = (gint) ((((gdouble) value) * _tmp2_) / _tmp5_);
	if (self->priv->width_ == w) {
		_tmp6_ = self->priv->height_ == value;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		return;
	}
	self->priv->width_ = w;
	self->priv->height_ = value;
	self->priv->update_image = TRUE;
	g_signal_emit (self, page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL], 0);
	g_signal_emit (self, page_view_signals[PAGE_VIEW_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, page_view_properties[PAGE_VIEW_HEIGHT_PROPERTY]);
}

static void
page_view_class_init (PageViewClass * klass,
                      gpointer klass_data)
{
	page_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PageView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_page_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_page_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = page_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_PAGE_PROPERTY, page_view_properties[PAGE_VIEW_PAGE_PROPERTY] = g_param_spec_object ("page", "page", "page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_SELECTED_PROPERTY, page_view_properties[PAGE_VIEW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_X_OFFSET_PROPERTY, page_view_properties[PAGE_VIEW_X_OFFSET_PROPERTY] = g_param_spec_int ("x-offset", "x-offset", "x-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_Y_OFFSET_PROPERTY, page_view_properties[PAGE_VIEW_Y_OFFSET_PROPERTY] = g_param_spec_int ("y-offset", "y-offset", "y-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_CURSOR_PROPERTY, page_view_properties[PAGE_VIEW_CURSOR_PROPERTY] = g_param_spec_enum ("cursor", "cursor", "cursor", gdk_cursor_type_get_type (), GDK_ARROW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_WIDTH_PROPERTY, page_view_properties[PAGE_VIEW_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAGE_VIEW_HEIGHT_PROPERTY, page_view_properties[PAGE_VIEW_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	page_view_signals[PAGE_VIEW_SIZE_CHANGED_SIGNAL] = g_signal_new ("size-changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	page_view_signals[PAGE_VIEW_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
page_view_instance_init (PageView * self,
                         gpointer klass)
{
	self->priv = page_view_get_instance_private (self);
	self->priv->image = NULL;
	self->priv->selected_ = FALSE;
	self->priv->ruler_width = 8;
	self->priv->border_width = 2;
	self->priv->update_image = TRUE;
	self->priv->_cursor = GDK_ARROW;
	self->priv->animate_n_segments = 7;
}

static void
page_view_finalize (GObject * obj)
{
	PageView * self;
	Page* _tmp0_;
	guint _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	guint _tmp5_;
	Page* _tmp6_;
	guint _tmp7_;
	Page* _tmp8_;
	guint _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
	_tmp0_ = self->priv->_page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
	_tmp2_ = self->priv->_page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
	_tmp4_ = self->priv->_page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
	_tmp6_ = self->priv->_page;
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
	_tmp8_ = self->priv->_page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
	_g_object_unref0 (self->priv->_page);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (page_view_parent_class)->finalize (obj);
}

static GType
page_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, NULL };
	GType page_view_type_id;
	page_view_type_id = g_type_register_static (G_TYPE_OBJECT, "PageView", &g_define_type_info, 0);
	PageView_private_offset = g_type_add_instance_private (page_view_type_id, sizeof (PageViewPrivate));
	return page_view_type_id;
}

GType
page_view_get_type (void)
{
	static volatile gsize page_view_type_id__once = 0;
	if (g_once_init_enter (&page_view_type_id__once)) {
		GType page_view_type_id;
		page_view_type_id = page_view_get_type_once ();
		g_once_init_leave (&page_view_type_id__once, page_view_type_id);
	}
	return page_view_type_id__once;
}

static void
_vala_page_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	PageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW, PageView);
	switch (property_id) {
		case PAGE_VIEW_PAGE_PROPERTY:
		g_value_set_object (value, page_view_get_page (self));
		break;
		case PAGE_VIEW_SELECTED_PROPERTY:
		g_value_set_boolean (value, page_view_get_selected (self));
		break;
		case PAGE_VIEW_X_OFFSET_PROPERTY:
		g_value_set_int (value, page_view_get_x_offset (self));
		break;
		case PAGE_VIEW_Y_OFFSET_PROPERTY:
		g_value_set_int (value, page_view_get_y_offset (self));
		break;
		case PAGE_VIEW_CURSOR_PROPERTY:
		g_value_set_enum (value, page_view_get_cursor (self));
		break;
		case PAGE_VIEW_WIDTH_PROPERTY:
		g_value_set_int (value, page_view_get_width (self));
		break;
		case PAGE_VIEW_HEIGHT_PROPERTY:
		g_value_set_int (value, page_view_get_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_page_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	PageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PAGE_VIEW, PageView);
	switch (property_id) {
		case PAGE_VIEW_PAGE_PROPERTY:
		page_view_set_page (self, g_value_get_object (value));
		break;
		case PAGE_VIEW_SELECTED_PROPERTY:
		page_view_set_selected (self, g_value_get_boolean (value));
		break;
		case PAGE_VIEW_X_OFFSET_PROPERTY:
		page_view_set_x_offset (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_Y_OFFSET_PROPERTY:
		page_view_set_y_offset (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_CURSOR_PROPERTY:
		page_view_set_cursor (self, g_value_get_enum (value));
		break;
		case PAGE_VIEW_WIDTH_PROPERTY:
		page_view_set_width (self, g_value_get_int (value));
		break;
		case PAGE_VIEW_HEIGHT_PROPERTY:
		page_view_set_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

