/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.TokenList;

public class ResponseUtil {
    private static final String VARY_HEADER = "vary";
    private static final String VARY_ALL = "*";

    private ResponseUtil() {
    }

    public static void addVaryFieldName(MimeHeaders mimeHeaders, String string) {
        ResponseUtil.addVaryFieldName(new HeaderAdapter(mimeHeaders), string);
    }

    public static void addVaryFieldName(HttpServletResponse httpServletResponse, String string) {
        ResponseUtil.addVaryFieldName(new ResponseAdapter(httpServletResponse), string);
    }

    private static void addVaryFieldName(Adapter adapter, String string) {
        Collection<String> collection = adapter.getHeaders(VARY_HEADER);
        if (collection.size() == 1 && collection.iterator().next().trim().equals(VARY_ALL)) {
            return;
        }
        if (collection.size() == 0) {
            adapter.addHeader(VARY_HEADER, string);
            return;
        }
        if (VARY_ALL.equals(string.trim())) {
            adapter.setHeader(VARY_HEADER, VARY_ALL);
            return;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String object2 : collection) {
            StringReader stringReader = new StringReader(object2);
            try {
                TokenList.parseTokenList(stringReader, linkedHashSet);
            }
            catch (IOException iOException) {}
        }
        if (linkedHashSet.contains(VARY_ALL)) {
            adapter.setHeader(VARY_HEADER, VARY_ALL);
            return;
        }
        linkedHashSet.add(string);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = linkedHashSet.iterator();
        stringBuilder.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(',');
            stringBuilder.append((String)iterator.next());
        }
        adapter.setHeader(VARY_HEADER, stringBuilder.toString());
    }

    private static final class ResponseAdapter
    implements Adapter {
        private final HttpServletResponse response;

        ResponseAdapter(HttpServletResponse httpServletResponse) {
            this.response = httpServletResponse;
        }

        @Override
        public Collection<String> getHeaders(String string) {
            return this.response.getHeaders(string);
        }

        @Override
        public void setHeader(String string, String string2) {
            this.response.setHeader(string, string2);
        }

        @Override
        public void addHeader(String string, String string2) {
            this.response.addHeader(string, string2);
        }
    }

    private static final class HeaderAdapter
    implements Adapter {
        private final MimeHeaders headers;

        HeaderAdapter(MimeHeaders mimeHeaders) {
            this.headers = mimeHeaders;
        }

        @Override
        public Collection<String> getHeaders(String string) {
            Enumeration<String> enumeration = this.headers.values(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            return arrayList;
        }

        @Override
        public void setHeader(String string, String string2) {
            this.headers.setValue(string).setString(string2);
        }

        @Override
        public void addHeader(String string, String string2) {
            this.headers.addValue(string).setString(string2);
        }
    }

    private static interface Adapter {
        public Collection<String> getHeaders(String var1);

        public void setHeader(String var1, String var2);

        public void addHeader(String var1, String var2);
    }
}

