/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.catalina.tribes.transport.AbstractRxTask;

public class RxTaskPool {
    final List<AbstractRxTask> idle = new ArrayList<AbstractRxTask>();
    final List<AbstractRxTask> used = new ArrayList<AbstractRxTask>();
    final Object mutex = new Object();
    boolean running = true;
    private int maxTasks;
    private int minTasks;
    private final TaskCreator creator;

    public RxTaskPool(int n, int n2, TaskCreator taskCreator) throws Exception {
        this.maxTasks = n;
        this.minTasks = n2;
        this.creator = taskCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureTask(AbstractRxTask abstractRxTask) {
        AbstractRxTask abstractRxTask2 = abstractRxTask;
        synchronized (abstractRxTask2) {
            abstractRxTask.setTaskPool(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractRxTask getRxTask() {
        AbstractRxTask abstractRxTask = null;
        Object object = this.mutex;
        synchronized (object) {
            while (abstractRxTask == null && this.running) {
                if (this.idle.size() > 0) {
                    try {
                        abstractRxTask = this.idle.remove(0);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        abstractRxTask = null;
                    }
                    continue;
                }
                if (this.used.size() < this.maxTasks && this.creator != null) {
                    abstractRxTask = this.creator.createRxTask();
                    this.configureTask(abstractRxTask);
                    continue;
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (abstractRxTask != null) {
                this.used.add(abstractRxTask);
            }
        }
        return abstractRxTask;
    }

    public int available() {
        return this.idle.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnWorker(AbstractRxTask abstractRxTask) {
        if (this.running) {
            Object object = this.mutex;
            synchronized (object) {
                this.used.remove(abstractRxTask);
                if (this.idle.size() < this.maxTasks && !this.idle.contains(abstractRxTask)) {
                    this.idle.add(abstractRxTask);
                } else {
                    abstractRxTask.setDoRun(false);
                    AbstractRxTask abstractRxTask2 = abstractRxTask;
                    synchronized (abstractRxTask2) {
                        abstractRxTask.notifyAll();
                    }
                }
                this.mutex.notifyAll();
            }
        }
        abstractRxTask.setDoRun(false);
        AbstractRxTask abstractRxTask3 = abstractRxTask;
        synchronized (abstractRxTask3) {
            abstractRxTask.notifyAll();
        }
    }

    public int getMaxThreads() {
        return this.maxTasks;
    }

    public int getMinThreads() {
        return this.minTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        Object object = this.mutex;
        synchronized (object) {
            Iterator<AbstractRxTask> iterator = this.idle.iterator();
            while (iterator.hasNext()) {
                AbstractRxTask abstractRxTask = iterator.next();
                this.returnWorker(abstractRxTask);
                iterator.remove();
            }
        }
    }

    public void setMaxTasks(int n) {
        this.maxTasks = n;
    }

    public void setMinTasks(int n) {
        this.minTasks = n;
    }

    public TaskCreator getTaskCreator() {
        return this.creator;
    }

    public static interface TaskCreator {
        public AbstractRxTask createRxTask();
    }
}

