/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.Track;
import tim.prune.function.compress.CompressionAlgorithm;
import tim.prune.function.compress.TrackDetails;
import tim.prune.gui.DecimalNumberField;

public abstract class SingleParameterAlgorithm
extends CompressionAlgorithm {
    private final DecimalNumberField _parameterField;
    private ActionListener _listener = null;

    public SingleParameterAlgorithm(Track track, TrackDetails trackDetails, ActionListener actionListener) {
        super(track, trackDetails, actionListener);
        this._listener = actionListener;
        this._parameterField = new DecimalNumberField();
        this._parameterField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (SingleParameterAlgorithm.this.isActivated()) {
                    SingleParameterAlgorithm.this._listener.actionPerformed(null);
                }
            }
        });
    }

    protected Component getSpecificGuiComponents(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText(string)) + " : ");
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        jPanel.add(this._parameterField);
        this._parameterField.setText(string2);
        return jPanel;
    }

    protected double getParameter() {
        return this._parameterField.getValue();
    }

    @Override
    public String getSettingsString() {
        return this._activateCheckBox.isSelected() ? "" + this._parameterField.getValue() : "";
    }

    @Override
    public void applySettingsString(String string) {
        super.applySettingsString(string);
        if (this.isActivated()) {
            this._parameterField.setValue(string);
        }
    }
}

