/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsClassFinder;", "", "()V", "findMultifileClassParts", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "partNames", "", "isKotlinInternalCompiledFile", "", "fileContent", "", "decompiler-to-file-stubs"})
public final class ClsClassFinder {
    @NotNull
    public static final ClsClassFinder INSTANCE = new ClsClassFinder();

    private ClsClassFinder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file2, @NotNull ClassId classId, @NotNull List<String> partNames) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(partNames, "partNames");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        FqName packageFqName = fqName2;
        VirtualFile virtualFile2 = file2.getParent();
        Intrinsics.checkNotNull(virtualFile2);
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile2, packageFqName);
        Iterable $this$mapNotNull$iv = partNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)partsFinder, new ClassId(packageFqName, Name.identifier(StringsKt.substringAfterLast$default(it, '/', null, 2, null)))) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        boolean bl;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter(file2, "file");
                if (!file2.isValid()) break block9;
                boolean bl2 = fileContent != null ? fileContent.length == 0 : false;
                if (!bl2 && file2.exists()) break block10;
            }
            return false;
        }
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
        if (!clsKotlinBinaryClassCache.isKotlinJvmCompiledFile(file2, fileContent)) {
            return false;
        }
        try {
            bl = fileContent == null ? ClassFileViewProvider.isInnerClass(file2) : ClassFileViewProvider.isInnerClass(file2, fileContent);
        }
        catch (Exception exception) {
            Logger.getInstance("org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder.isKotlinInternalCompiledFile").debug(file2.getPath(), exception);
            return false;
        }
        boolean innerClass = bl;
        if (innerClass) {
            return true;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(file2, fileContent);
        if (kotlinBinaryClassHeaderData == null) {
            return false;
        }
        ClsKotlinBinaryClassCache.KotlinBinaryClassHeaderData header = kotlinBinaryClassHeaderData;
        if (header.getClassId().isLocal()) {
            return true;
        }
        return header.getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS || header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isKotlinInternalCompiledFile$default(ClsClassFinder clsClassFinder, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsClassFinder.isKotlinInternalCompiledFile(virtualFile2, byArray);
    }
}

