/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.Check;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.OperatorFunctionChecks;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOperatorModifierChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirOperatorModifierChecker INSTANCE = new FirOperatorModifierChecker();

    private FirOperatorModifierChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        List checks2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isOperator$iv = declaration;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getStatus().isOperator()) {
            return;
        }
        FirElement firElement = declaration;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPERATOR_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            return;
        }
        Map<Name, List<Check>> map = OperatorFunctionChecks.INSTANCE.getChecksByName();
        List list2 = map.get(declaration.getName());
        if (list2 == null) {
            Object v5;
            block6: {
                boolean bl = false;
                Iterable iterable = OperatorFunctionChecks.INSTANCE.getRegexChecks();
                for (Object t : iterable) {
                    Pair it = (Pair)t;
                    boolean bl2 = false;
                    Regex regex = (Regex)it.getFirst();
                    String string2 = declaration.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
                    if (!regex.matches(string2)) continue;
                    v5 = t;
                    break block6;
                }
                v5 = null;
            }
            Pair pair = v5;
            list2 = pair != null ? (List)pair.getSecond() : null;
        }
        if ((checks2 = list2) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"illegal function name", (DiagnosticContext)context, null, 16, null);
            return;
        }
        for (Check check2 : checks2) {
            String string3 = check2.check(context, declaration);
            if (string3 == null) continue;
            String error = string3;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)error, (DiagnosticContext)context, null, 16, null);
            return;
        }
    }
}

