/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.builder.FirSmartCastExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"removeSmartCastTypeForAttemptToFitVisibility", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "dispatchReceiverValue", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getBackingFieldIfApplicable", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isVisible", "", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "declaration", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
public final class VisibilityUtilsKt {
    public static final boolean isVisible(@NotNull FirVisibilityChecker $this$isVisible, @NotNull FirMemberDeclaration declaration, @NotNull CallInfo callInfo, @Nullable ReceiverValue dispatchReceiverValue2) {
        Intrinsics.checkNotNullParameter($this$isVisible, "<this>");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        if (declaration instanceof FirCallableDeclaration && (ClassMembersKt.isIntersectionOverride((FirCallableDeclaration)declaration) || ClassMembersKt.isSubstitutionOverride((FirCallableDeclaration)declaration))) {
            FirCallableDeclaration $this$originalIfFakeOverride$iv = (FirCallableDeclaration)declaration;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = $this$originalIfFakeOverride$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
            }
            Intrinsics.checkNotNull(firCallableDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
            return VisibilityUtilsKt.isVisible($this$isVisible, firCallableDeclaration, callInfo, dispatchReceiverValue2);
        }
        FirFile useSiteFile = callInfo.getContainingFile();
        List<FirDeclaration> containingDeclarations = callInfo.getContainingDeclarations();
        FirSession session2 = callInfo.getSession();
        return FirVisibilityChecker.isVisible$default($this$isVisible, declaration, session2, useSiteFile, containingDeclarations, dispatchReceiverValue2, callInfo.getCallSite() instanceof FirVariableAssignment, false, null, 192, null);
    }

    public static final boolean isVisible(@NotNull FirVisibilityChecker $this$isVisible, @NotNull FirMemberDeclaration declaration, @NotNull Candidate candidate2) {
        FirBackingField backingField2;
        Intrinsics.checkNotNullParameter($this$isVisible, "<this>");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        CallInfo callInfo = candidate2.getCallInfo();
        if (!VisibilityUtilsKt.isVisible($this$isVisible, declaration, callInfo, candidate2.getDispatchReceiverValue())) {
            ReceiverValue receiverValue = VisibilityUtilsKt.removeSmartCastTypeForAttemptToFitVisibility(candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getSession());
            if (receiverValue == null) {
                return false;
            }
            ReceiverValue dispatchReceiverWithoutSmartCastType = receiverValue;
            if (!VisibilityUtilsKt.isVisible($this$isVisible, declaration, callInfo, dispatchReceiverWithoutSmartCastType)) {
                return false;
            }
            candidate2.setDispatchReceiverValue(dispatchReceiverWithoutSmartCastType);
        }
        if ((backingField2 = VisibilityUtilsKt.getBackingFieldIfApplicable(declaration)) != null) {
            candidate2.setHasVisibleBackingField(FirVisibilityChecker.isVisible$default($this$isVisible, backingField2, callInfo.getSession(), callInfo.getContainingFile(), callInfo.getContainingDeclarations(), candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getCallSite() instanceof FirVariableAssignment, false, null, 192, null));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final ReceiverValue removeSmartCastTypeForAttemptToFitVisibility(ReceiverValue dispatchReceiverValue2, FirSession session2) {
        FirExpression firExpression2;
        FirSmartCastExpression firSmartCastExpression;
        block8: {
            block7: {
                FirSmartCastExpression firSmartCastExpression2;
                ReceiverValue receiverValue = dispatchReceiverValue2;
                FirExpression firExpression3 = receiverValue != null ? receiverValue.getReceiverExpression() : null;
                firSmartCastExpression = firExpression3 instanceof FirSmartCastExpression ? (FirSmartCastExpression)firExpression3 : null;
                if (firSmartCastExpression == null) break block7;
                FirSmartCastExpression it = firSmartCastExpression2 = firSmartCastExpression;
                boolean bl = false;
                firSmartCastExpression = it.isStable() ? firSmartCastExpression2 : null;
                if (firSmartCastExpression != null) break block8;
            }
            return null;
        }
        FirSmartCastExpression expressionWithSmartcastIfStable = firSmartCastExpression;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(dispatchReceiverValue2.getType())) {
            return null;
        }
        FirExpression originalExpression = expressionWithSmartcastIfStable.getOriginalExpression();
        ConeKotlinType originalType = FirTypeUtilsKt.getConeType(originalExpression.getTypeRef());
        ConeKotlinType originalTypeNotNullable = TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull$default(originalType, TypeComponentsKt.getTypeContext(session2), false, 2, null);
        if (Intrinsics.areEqual(originalTypeNotNullable, dispatchReceiverValue2.getType())) {
            return null;
        }
        ConeInferenceContext $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        if ($this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243.isNullableType(originalType) && !$this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243.isNullableType(dispatchReceiverValue2.getType())) {
            void $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242_u24lambda_u241;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder;
            boolean $i$f$buildSmartCastExpression = false;
            FirSmartCastExpressionBuilder $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242 = firSmartCastExpressionBuilder = new FirSmartCastExpressionBuilder();
            boolean bl2 = false;
            KtSourceElement ktSourceElement = originalExpression.getSource();
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.SmartCastExpression.INSTANCE) : null);
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.setOriginalExpression(originalExpression);
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder2 = $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242;
            boolean bl3 = false;
            KtSourceElement ktSourceElement2 = originalExpression.getTypeRef().getSource();
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242_u24lambda_u241.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement(ktSourceElement2, KtFakeSourceElementKind.SmartCastedTypeRef.INSTANCE) : null);
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242_u24lambda_u241.setType(originalTypeNotNullable);
            firSmartCastExpressionBuilder2.setSmartcastType(firResolvedTypeRefBuilder.build());
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.setTypesFromSmartCast((Collection<? extends ConeKotlinType>)CollectionsKt.listOf(originalTypeNotNullable));
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.setSmartcastStability(expressionWithSmartcastIfStable.getSmartcastStability());
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.setTypeRef(UtilsKt.copyWithNewSourceKind($this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u243_u24lambda_u242.getSmartcastType(), KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE));
            firExpression2 = firSmartCastExpressionBuilder.build();
        } else {
            firExpression2 = originalExpression;
        }
        FirExpression expressionForReceiver = firExpression2;
        return new ExpressionReceiverValue(expressionForReceiver);
    }

    private static final FirBackingField getBackingFieldIfApplicable(FirMemberDeclaration $this$getBackingFieldIfApplicable) {
        FirVariable firVariable = $this$getBackingFieldIfApplicable instanceof FirProperty ? (FirProperty)$this$getBackingFieldIfApplicable : null;
        if (firVariable == null || (firVariable = DeclarationAttributesKt.getExplicitBackingField(firVariable)) == null) {
            return null;
        }
        FirVariable field2 = firVariable;
        FirMemberDeclaration $this$visibility$iv = field2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        return ((Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE) ? true : Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE)) ? true : Intrinsics.areEqual(visibility2, Visibilities.Internal.INSTANCE)) ? field2 : null;
    }
}

