import { IrcBridge } from "./IrcBridge";
import { AppServiceBot, MembershipQueue } from "matrix-appservice-bridge";
import { IrcServer } from "../irc/IrcServer";
import { IrcRoom } from "../models/IrcRoom";
import { BridgeRequest } from "../models/BridgeRequest";
interface RoomInfo {
    id: string;
    state?: string;
    displayNames: {
        [userId: string]: string;
    };
    realJoinedUsers: string[];
    remoteJoinedUsers: string[];
}
declare type InjectJoinFn = (roomId: string, joiningUserId: string, displayName: string, isFrontier: boolean) => PromiseLike<unknown>;
export declare class MemberListSyncer {
    private ircBridge;
    private memberQueue;
    private appServiceBot;
    private server;
    private appServiceUserId;
    private injectJoinFn;
    private syncableRoomsPromise;
    private usersToLeave;
    private usersToJoin;
    private memberLists;
    constructor(ircBridge: IrcBridge, memberQueue: MembershipQueue, appServiceBot: AppServiceBot, server: IrcServer, appServiceUserId: string, injectJoinFn: InjectJoinFn);
    sync(): Promise<void>;
    getChannelsToJoin(): Promise<string[]>;
    checkBotPartRoom(ircRoom: IrcRoom, req: BridgeRequest): Promise<void>;
    getSyncableRooms(resetCache?: boolean): Promise<RoomInfo[]>;
    private joinMatrixUsersToChannels;
    leaveIrcUsersFromRooms(rooms: RoomInfo[]): void;
    private leaveUsersInRoom;
    updateIrcMemberList(channel: string, names: Map<string, unknown>): Promise<void>;
    getUsersWaitingToJoin(): number;
    getUsersWaitingToLeave(): number;
    addToLeavePool(userIds: string[], roomId: string): Promise<void>;
    private static getRoomMemberData;
}
export {};
