/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bandwidth;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.util.Duration;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import mediathek.gui.messages.BandwidthMonitorStateChangedEvent;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.MVHttpClient;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;

public class BandwidthMonitorController {
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 150;
    private static final String CONFIG_X = "bandwidth_monitor.x";
    private static final String CONFIG_Y = "bandwidth_monitor.y";
    private static final String CONFIG_HEIGHT = "bandwidth_monitor.height";
    private static final String CONFIG_WIDTH = "bandwidth_monitor.width";
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private JDialog hudDialog;
    private Timeline updateMemoryTimer;
    private Tile bandwidthTile;
    private JFXPanel fxPanel;

    public BandwidthMonitorController(JFrame parent) {
        this.createDialog(parent);
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.fxPanel.setScene(new Scene(this.createTile()));
            this.createUpdateTimer();
        });
        this.restoreSizeFromConfig();
        MessageBus.getMessageBus().subscribe(this);
        this.setVisibility();
        this.hudDialog.addComponentListener(new WriteConfigComponentListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        try {
            this.config.lock(LockMode.READ);
            int x = this.config.getInt(CONFIG_X);
            int y = this.config.getInt(CONFIG_Y);
            int width = this.config.getInt(CONFIG_WIDTH);
            int height = this.config.getInt(CONFIG_HEIGHT);
            this.hudDialog.setSize(width, height);
            this.hudDialog.setLocation(x, y);
        }
        catch (Exception ex) {
            this.hudDialog.setSize(300, 150);
            this.calculateHudPosition();
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    public void close() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            if (this.updateMemoryTimer != null) {
                this.updateMemoryTimer.stop();
            }
        });
        this.hudDialog.dispose();
    }

    @Handler
    private void handleBandwidthMonitorStateChangedEvent(BandwidthMonitorStateChangedEvent e) {
        SwingUtilities.invokeLater(this::setVisibility);
    }

    private void createDialog(JFrame parent) {
        this.hudDialog = new JDialog(parent);
        this.hudDialog.setTitle("Bandbreite");
        this.hudDialog.setResizable(true);
        this.hudDialog.setType(Window.Type.UTILITY);
        this.hudDialog.setDefaultCloseOperation(1);
        this.hudDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Platform.runLater(() -> BandwidthMonitorController.this.updateMemoryTimer.play());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Platform.runLater(() -> BandwidthMonitorController.this.updateMemoryTimer.stop());
                BandwidthMonitorController.this.updateListeners();
            }
        });
        this.hudDialog.setLayout(new BorderLayout(0, 0));
        this.fxPanel = new JFXPanel();
        this.hudDialog.getContentPane().add((Component)this.fxPanel, "Center");
    }

    private void calculateHudPosition() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode dm = gd.getDisplayMode();
        this.hudDialog.setLocation(dm.getWidth() - 300, 0);
    }

    private double calculateBandwidthUsage() {
        ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
        double bandwidth = byteCounter.bytesRead();
        byteCounter.resetCounters();
        bandwidth = bandwidth * 8.0 / 1048576.0;
        if (bandwidth < 0.0) {
            bandwidth = 0.0;
        }
        return bandwidth;
    }

    private void createUpdateTimer() {
        this.updateMemoryTimer = new Timeline(new KeyFrame(Duration.seconds(1.0), event -> this.bandwidthTile.setValue(this.calculateBandwidthUsage()), new KeyValue[0]));
        this.updateMemoryTimer.setCycleCount(-1);
    }

    private Tile createTile() {
        this.bandwidthTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SPARK_LINE)).prefSize(400.0, 400.0)).unit("MBit/s")).minValue(0.0)).maxValue(2048.0)).decimals(0)).tickLabelDecimals(0)).time(ZonedDateTime.now(ZoneId.of("Europe/Berlin")))).gradientStops(new Stop(0.0, Color.web("#1CAF4D")), new Stop(0.0075, Color.web("#1CAF4D")), new Stop(0.00751, Color.web("#91CA40")), new Stop(0.01166, Color.web("#91CA40")), new Stop(0.01167, Color.web("#F8C610")), new Stop(0.01666, Color.web("#F8C610")), new Stop(0.01667, Color.web("#F29222")), new Stop(0.025, Color.web("#F29222")), new Stop(0.02501, Color.web("#EC1D24")), new Stop(1.0, Color.web("#EC1D24")))).strokeWithGradient(true)).averagingPeriod(96)).averageVisible(true)).averagingEnabled(true)).smoothing(true)).build();
        this.bandwidthTile.setValue(0.0);
        return this.bandwidthTile;
    }

    private void updateListeners() {
        this.config.setProperty("application.ui.bandwidth_monitor.visible", false);
        MessageBus.getMessageBus().publishAsync(new BandwidthMonitorStateChangedEvent());
    }

    public void setVisibility() {
        boolean visible = this.config.getBoolean("application.ui.bandwidth_monitor.visible", false);
        if (visible) {
            ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
            byteCounter.resetCounters();
        }
        this.hudDialog.setVisible(visible);
    }

    private class WriteConfigComponentListener
    extends ComponentAdapter {
        private WriteConfigComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                BandwidthMonitorController.this.config.lock(LockMode.WRITE);
                Dimension size = BandwidthMonitorController.this.hudDialog.getSize();
                BandwidthMonitorController.this.config.setProperty(BandwidthMonitorController.CONFIG_WIDTH, size.width);
                BandwidthMonitorController.this.config.setProperty(BandwidthMonitorController.CONFIG_HEIGHT, size.height);
            }
            finally {
                BandwidthMonitorController.this.config.unlock(LockMode.WRITE);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            try {
                BandwidthMonitorController.this.config.lock(LockMode.WRITE);
                Point location = BandwidthMonitorController.this.hudDialog.getLocation();
                BandwidthMonitorController.this.config.setProperty(BandwidthMonitorController.CONFIG_X, location.x);
                BandwidthMonitorController.this.config.setProperty(BandwidthMonitorController.CONFIG_Y, location.y);
            }
            finally {
                BandwidthMonitorController.this.config.unlock(LockMode.WRITE);
            }
        }
    }
}

