# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from pynitrokey.nethsm.client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    INFO = "/info"
    HEALTH_ALIVE = "/health/alive"
    HEALTH_READY = "/health/ready"
    HEALTH_STATE = "/health/state"
    METRICS = "/metrics"
    PROVISION = "/provision"
    UNLOCK = "/unlock"
    LOCK = "/lock"
    RANDOM = "/random"
    KEYS = "/keys"
    KEYS_GENERATE = "/keys/generate"
    KEYS_KEY_ID = "/keys/{KeyID}"
    KEYS_KEY_ID_PUBLIC_PEM = "/keys/{KeyID}/public.pem"
    KEYS_KEY_ID_CSR_PEM = "/keys/{KeyID}/csr.pem"
    KEYS_KEY_ID_DECRYPT = "/keys/{KeyID}/decrypt"
    KEYS_KEY_ID_ENCRYPT = "/keys/{KeyID}/encrypt"
    KEYS_KEY_ID_SIGN = "/keys/{KeyID}/sign"
    KEYS_KEY_ID_CERT = "/keys/{KeyID}/cert"
    KEYS_KEY_ID_RESTRICTIONS_TAGS_TAG = "/keys/{KeyID}/restrictions/tags/{Tag}"
    USERS = "/users"
    USERS_USER_ID = "/users/{UserID}"
    USERS_USER_ID_PASSPHRASE = "/users/{UserID}/passphrase"
    USERS_USER_ID_TAGS = "/users/{UserID}/tags"
    USERS_USER_ID_TAGS_TAG = "/users/{UserID}/tags/{Tag}"
    CONFIG_UNLOCKPASSPHRASE = "/config/unlock-passphrase"
    CONFIG_UNATTENDEDBOOT = "/config/unattended-boot"
    CONFIG_TLS_PUBLIC_PEM = "/config/tls/public.pem"
    CONFIG_TLS_CERT_PEM = "/config/tls/cert.pem"
    CONFIG_TLS_CSR_PEM = "/config/tls/csr.pem"
    CONFIG_TLS_GENERATE = "/config/tls/generate"
    CONFIG_NETWORK = "/config/network"
    CONFIG_LOGGING = "/config/logging"
    CONFIG_BACKUPPASSPHRASE = "/config/backup-passphrase"
    CONFIG_TIME = "/config/time"
    SYSTEM_INFO = "/system/info"
    SYSTEM_REBOOT = "/system/reboot"
    SYSTEM_SHUTDOWN = "/system/shutdown"
    SYSTEM_FACTORYRESET = "/system/factory-reset"
    SYSTEM_UPDATE = "/system/update"
    SYSTEM_COMMITUPDATE = "/system/commit-update"
    SYSTEM_CANCELUPDATE = "/system/cancel-update"
    SYSTEM_BACKUP = "/system/backup"
    SYSTEM_RESTORE = "/system/restore"
