// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAME70Q20B.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsame70q20b

// Microchip ATSAME70Q20B Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAME70Q20B"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Supply Controller
	IRQ_SUPC = 0

	// Reset Controller
	IRQ_RSTC = 1

	// Real-time Clock
	IRQ_RTC = 2

	// Real-time Timer
	IRQ_RTT = 3

	// Watchdog Timer
	IRQ_WDT = 4

	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller
	IRQ_EFC = 6

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART0 = 7

	IRQ_UART1 = 8

	// Parallel Input/Output Controller
	IRQ_PIOA = 10

	IRQ_PIOB = 11

	IRQ_PIOC = 12

	// Universal Synchronous Asynchronous Receiver Transmitter
	IRQ_USART0 = 13

	IRQ_USART1 = 14

	IRQ_USART2 = 15

	IRQ_PIOD = 16

	IRQ_PIOE = 17

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 18

	// Two-wire Interface High Speed
	IRQ_TWIHS0 = 19

	IRQ_TWIHS1 = 20

	// Serial Peripheral Interface
	IRQ_SPI0 = 21

	// Synchronous Serial Controller
	IRQ_SSC = 22

	// Timer Counter
	IRQ_TC0 = 23

	// Timer Counter
	IRQ_TC1 = 24

	// Timer Counter
	IRQ_TC2 = 25

	IRQ_TC3 = 26

	IRQ_TC4 = 27

	IRQ_TC5 = 28

	// Analog Front-End Controller
	IRQ_AFEC0 = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM0 = 31

	// Integrity Check Monitor
	IRQ_ICM = 32

	// Analog Comparator Controller
	IRQ_ACC = 33

	// USB High-Speed Interface
	IRQ_USBHS = 34

	// Controller Area Network
	IRQ_MCAN0_INT0 = 35

	// Controller Area Network
	IRQ_MCAN0_INT1 = 36

	IRQ_MCAN1_INT0 = 37

	IRQ_MCAN1_INT1 = 38

	// Gigabit Ethernet MAC
	IRQ_GMAC = 39

	IRQ_AFEC1 = 40

	IRQ_TWIHS2 = 41

	IRQ_SPI1 = 42

	// Quad Serial Peripheral Interface
	IRQ_QSPI = 43

	IRQ_UART2 = 44

	IRQ_UART3 = 45

	IRQ_UART4 = 46

	IRQ_TC6 = 47

	IRQ_TC7 = 48

	IRQ_TC8 = 49

	IRQ_TC9 = 50

	IRQ_TC10 = 51

	IRQ_TC11 = 52

	// Advanced Encryption Standard
	IRQ_AES = 56

	// True Random Number Generator
	IRQ_TRNG = 57

	// Extensible DMA Controller
	IRQ_XDMAC = 58

	// Image Sensor Interface
	IRQ_ISI = 59

	IRQ_PWM1 = 60

	// Floating Point Unit
	IRQ_FPU = 61

	// SDRAM Controller
	IRQ_SDRAMC = 62

	// Reinforced Safety Watchdog Timer
	IRQ_RSWDT = 63

	// System Control Block
	IRQ_CCW = 64

	// System Control Block
	IRQ_CCF = 65

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q1 = 66

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q2 = 67

	// Floating Point Unit
	IRQ_IXC = 68

	// Inter-IC Sound Controller
	IRQ_I2SC0 = 69

	IRQ_I2SC1 = 70

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q3 = 71

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q4 = 72

	// Gigabit Ethernet MAC
	IRQ_GMAC_Q5 = 73

	// Highest interrupt number on this device.
	IRQ_max = 73
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SUPC_IRQHandler
func interruptSUPC() {
	callHandlers(IRQ_SUPC)
}

//export RSTC_IRQHandler
func interruptRSTC() {
	callHandlers(IRQ_RSTC)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTT_IRQHandler
func interruptRTT() {
	callHandlers(IRQ_RTT)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC_IRQHandler
func interruptEFC() {
	callHandlers(IRQ_EFC)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export PIOD_IRQHandler
func interruptPIOD() {
	callHandlers(IRQ_PIOD)
}

//export PIOE_IRQHandler
func interruptPIOE() {
	callHandlers(IRQ_PIOE)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export TWIHS0_IRQHandler
func interruptTWIHS0() {
	callHandlers(IRQ_TWIHS0)
}

//export TWIHS1_IRQHandler
func interruptTWIHS1() {
	callHandlers(IRQ_TWIHS1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export AFEC0_IRQHandler
func interruptAFEC0() {
	callHandlers(IRQ_AFEC0)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export ICM_IRQHandler
func interruptICM() {
	callHandlers(IRQ_ICM)
}

//export ACC_IRQHandler
func interruptACC() {
	callHandlers(IRQ_ACC)
}

//export USBHS_IRQHandler
func interruptUSBHS() {
	callHandlers(IRQ_USBHS)
}

//export MCAN0_INT0_IRQHandler
func interruptMCAN0_INT0() {
	callHandlers(IRQ_MCAN0_INT0)
}

//export MCAN0_INT1_IRQHandler
func interruptMCAN0_INT1() {
	callHandlers(IRQ_MCAN0_INT1)
}

//export MCAN1_INT0_IRQHandler
func interruptMCAN1_INT0() {
	callHandlers(IRQ_MCAN1_INT0)
}

//export MCAN1_INT1_IRQHandler
func interruptMCAN1_INT1() {
	callHandlers(IRQ_MCAN1_INT1)
}

//export GMAC_IRQHandler
func interruptGMAC() {
	callHandlers(IRQ_GMAC)
}

//export AFEC1_IRQHandler
func interruptAFEC1() {
	callHandlers(IRQ_AFEC1)
}

//export TWIHS2_IRQHandler
func interruptTWIHS2() {
	callHandlers(IRQ_TWIHS2)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export QSPI_IRQHandler
func interruptQSPI() {
	callHandlers(IRQ_QSPI)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export UART3_IRQHandler
func interruptUART3() {
	callHandlers(IRQ_UART3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export TC6_IRQHandler
func interruptTC6() {
	callHandlers(IRQ_TC6)
}

//export TC7_IRQHandler
func interruptTC7() {
	callHandlers(IRQ_TC7)
}

//export TC8_IRQHandler
func interruptTC8() {
	callHandlers(IRQ_TC8)
}

//export TC9_IRQHandler
func interruptTC9() {
	callHandlers(IRQ_TC9)
}

//export TC10_IRQHandler
func interruptTC10() {
	callHandlers(IRQ_TC10)
}

//export TC11_IRQHandler
func interruptTC11() {
	callHandlers(IRQ_TC11)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export XDMAC_IRQHandler
func interruptXDMAC() {
	callHandlers(IRQ_XDMAC)
}

//export ISI_IRQHandler
func interruptISI() {
	callHandlers(IRQ_ISI)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export SDRAMC_IRQHandler
func interruptSDRAMC() {
	callHandlers(IRQ_SDRAMC)
}

//export RSWDT_IRQHandler
func interruptRSWDT() {
	callHandlers(IRQ_RSWDT)
}

//export CCW_IRQHandler
func interruptCCW() {
	callHandlers(IRQ_CCW)
}

//export CCF_IRQHandler
func interruptCCF() {
	callHandlers(IRQ_CCF)
}

//export GMAC_Q1_IRQHandler
func interruptGMAC_Q1() {
	callHandlers(IRQ_GMAC_Q1)
}

//export GMAC_Q2_IRQHandler
func interruptGMAC_Q2() {
	callHandlers(IRQ_GMAC_Q2)
}

//export IXC_IRQHandler
func interruptIXC() {
	callHandlers(IRQ_IXC)
}

//export I2SC0_IRQHandler
func interruptI2SC0() {
	callHandlers(IRQ_I2SC0)
}

//export I2SC1_IRQHandler
func interruptI2SC1() {
	callHandlers(IRQ_I2SC1)
}

//export GMAC_Q3_IRQHandler
func interruptGMAC_Q3() {
	callHandlers(IRQ_GMAC_Q3)
}

//export GMAC_Q4_IRQHandler
func interruptGMAC_Q4() {
	callHandlers(IRQ_GMAC_Q4)
}

//export GMAC_Q5_IRQHandler
func interruptGMAC_Q5() {
	callHandlers(IRQ_GMAC_Q5)
}

// Peripherals.
var (
	// Analog Comparator Controller
	ACC = (*ACC_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Analog Front-End Controller
	AFEC0 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0940)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Embedded Flash Controller
	EFC = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Gigabit Ethernet MAC
	GMAC = (*GMAC_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// General Purpose Backup Registers
	GPBR = (*GPBR_Type)(unsafe.Pointer(uintptr(0x400e1890)))

	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Inter-IC Sound Controller
	I2SC0 = (*I2SC_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Integrity Check Monitor
	ICM = (*ICM_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Controller Area Network
	MCAN0 = (*MCAN_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Parallel Input/Output Controller
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Pulse Width Modulation Controller
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Quad Serial Peripheral Interface
	QSPI = (*QSPI_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Reset Controller
	RSTC = (*RSTC_Type)(unsafe.Pointer(uintptr(0x400e1800)))

	// Reinforced Safety Watchdog Timer
	RSWDT = (*RSWDT_Type)(unsafe.Pointer(uintptr(0x400e1900)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x400e1860)))

	// Real-time Timer
	RTT = (*RTT_Type)(unsafe.Pointer(uintptr(0x400e1830)))

	// SDRAM Controller
	SDRAMC = (*SDRAMC_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Static Memory Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Supply Controller
	SUPC = (*SUPC_Type)(unsafe.Pointer(uintptr(0x400e1810)))

	// Timer Counter
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// Two-wire Interface High Speed
	TWIHS0 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Universal Asynchronous Receiver Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// USB High-Speed Interface
	USBHS = (*USBHS_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// USB Transmitter Interface Macrocell
	UTMI = (*UTMI_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x400e1850)))

	// Extensible DMA Controller
	XDMAC = (*XDMAC_Type)(unsafe.Pointer(uintptr(0x40078000)))

	LOCKBIT = (*LOCKBIT_Type)(unsafe.Pointer(uintptr(0x0)))

	// System control not in SCB
	SCnSCB = (*SCnSCB_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System Control Block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory Protection Unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Floating Point Unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef30)))

	// Analog Front-End Controller
	AFEC1 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Inter-IC Sound Controller
	I2SC1 = (*I2SC_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Controller Area Network
	MCAN1 = (*MCAN_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// Parallel Input/Output Controller
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Parallel Input/Output Controller
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1200)))

	// Parallel Input/Output Controller
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Parallel Input/Output Controller
	PIOE = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1600)))

	// Pulse Width Modulation Controller
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// Timer Counter
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer Counter
	TC2 = (*TC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Timer Counter
	TC3 = (*TC_Type)(unsafe.Pointer(uintptr(0x40054000)))

	// Two-wire Interface High Speed
	TWIHS1 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Two-wire Interface High Speed
	TWIHS2 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// Universal Asynchronous Receiver Transmitter
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Universal Asynchronous Receiver Transmitter
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e1a00)))

	// Universal Asynchronous Receiver Transmitter
	UART3 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e1c00)))

	// Universal Asynchronous Receiver Transmitter
	UART4 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e1e00)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x4002c000)))
)

// Analog Comparator Controller
type ACC_Type struct {
	ACC_CR   volatile.Register32 // 0x0
	ACC_MR   volatile.Register32 // 0x4
	_        [28]byte
	ACC_IER  volatile.Register32 // 0x24
	ACC_IDR  volatile.Register32 // 0x28
	ACC_IMR  volatile.Register32 // 0x2C
	ACC_ISR  volatile.Register32 // 0x30
	_        [96]byte
	ACC_ACR  volatile.Register32 // 0x94
	_        [76]byte
	ACC_WPMR volatile.Register32 // 0xE4
	ACC_WPSR volatile.Register32 // 0xE8
}

// ACC.ACC_CR: Control Register
func (o *ACC_Type) SetACC_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.ACC_CR.Reg, volatile.LoadUint32(&o.ACC_CR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_CR_SWRST() uint32 {
	return volatile.LoadUint32(&o.ACC_CR.Reg) & 0x1
}

// ACC.ACC_MR: Mode Register
func (o *ACC_Type) SetACC_MR_SELMINUS(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x7)|value)
}
func (o *ACC_Type) GetACC_MR_SELMINUS() uint32 {
	return volatile.LoadUint32(&o.ACC_MR.Reg) & 0x7
}
func (o *ACC_Type) SetACC_MR_SELPLUS(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x70)|value<<4)
}
func (o *ACC_Type) GetACC_MR_SELPLUS() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x70) >> 4
}
func (o *ACC_Type) SetACC_MR_ACEN(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x100)|value<<8)
}
func (o *ACC_Type) GetACC_MR_ACEN() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x100) >> 8
}
func (o *ACC_Type) SetACC_MR_EDGETYP(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x600)|value<<9)
}
func (o *ACC_Type) GetACC_MR_EDGETYP() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x600) >> 9
}
func (o *ACC_Type) SetACC_MR_INV(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x1000)|value<<12)
}
func (o *ACC_Type) GetACC_MR_INV() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x1000) >> 12
}
func (o *ACC_Type) SetACC_MR_SELFS(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x2000)|value<<13)
}
func (o *ACC_Type) GetACC_MR_SELFS() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x2000) >> 13
}
func (o *ACC_Type) SetACC_MR_FE(value uint32) {
	volatile.StoreUint32(&o.ACC_MR.Reg, volatile.LoadUint32(&o.ACC_MR.Reg)&^(0x4000)|value<<14)
}
func (o *ACC_Type) GetACC_MR_FE() uint32 {
	return (volatile.LoadUint32(&o.ACC_MR.Reg) & 0x4000) >> 14
}

// ACC.ACC_IER: Interrupt Enable Register
func (o *ACC_Type) SetACC_IER_CE(value uint32) {
	volatile.StoreUint32(&o.ACC_IER.Reg, volatile.LoadUint32(&o.ACC_IER.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_IER_CE() uint32 {
	return volatile.LoadUint32(&o.ACC_IER.Reg) & 0x1
}

// ACC.ACC_IDR: Interrupt Disable Register
func (o *ACC_Type) SetACC_IDR_CE(value uint32) {
	volatile.StoreUint32(&o.ACC_IDR.Reg, volatile.LoadUint32(&o.ACC_IDR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_IDR_CE() uint32 {
	return volatile.LoadUint32(&o.ACC_IDR.Reg) & 0x1
}

// ACC.ACC_IMR: Interrupt Mask Register
func (o *ACC_Type) SetACC_IMR_CE(value uint32) {
	volatile.StoreUint32(&o.ACC_IMR.Reg, volatile.LoadUint32(&o.ACC_IMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_IMR_CE() uint32 {
	return volatile.LoadUint32(&o.ACC_IMR.Reg) & 0x1
}

// ACC.ACC_ISR: Interrupt Status Register
func (o *ACC_Type) SetACC_ISR_CE(value uint32) {
	volatile.StoreUint32(&o.ACC_ISR.Reg, volatile.LoadUint32(&o.ACC_ISR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_ISR_CE() uint32 {
	return volatile.LoadUint32(&o.ACC_ISR.Reg) & 0x1
}
func (o *ACC_Type) SetACC_ISR_SCO(value uint32) {
	volatile.StoreUint32(&o.ACC_ISR.Reg, volatile.LoadUint32(&o.ACC_ISR.Reg)&^(0x2)|value<<1)
}
func (o *ACC_Type) GetACC_ISR_SCO() uint32 {
	return (volatile.LoadUint32(&o.ACC_ISR.Reg) & 0x2) >> 1
}
func (o *ACC_Type) SetACC_ISR_MASK(value uint32) {
	volatile.StoreUint32(&o.ACC_ISR.Reg, volatile.LoadUint32(&o.ACC_ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ACC_Type) GetACC_ISR_MASK() uint32 {
	return (volatile.LoadUint32(&o.ACC_ISR.Reg) & 0x80000000) >> 31
}

// ACC.ACC_ACR: Analog Control Register
func (o *ACC_Type) SetACC_ACR_ISEL(value uint32) {
	volatile.StoreUint32(&o.ACC_ACR.Reg, volatile.LoadUint32(&o.ACC_ACR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_ACR_ISEL() uint32 {
	return volatile.LoadUint32(&o.ACC_ACR.Reg) & 0x1
}
func (o *ACC_Type) SetACC_ACR_HYST(value uint32) {
	volatile.StoreUint32(&o.ACC_ACR.Reg, volatile.LoadUint32(&o.ACC_ACR.Reg)&^(0x6)|value<<1)
}
func (o *ACC_Type) GetACC_ACR_HYST() uint32 {
	return (volatile.LoadUint32(&o.ACC_ACR.Reg) & 0x6) >> 1
}

// ACC.ACC_WPMR: Write Protection Mode Register
func (o *ACC_Type) SetACC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.ACC_WPMR.Reg, volatile.LoadUint32(&o.ACC_WPMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.ACC_WPMR.Reg) & 0x1
}
func (o *ACC_Type) SetACC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.ACC_WPMR.Reg, volatile.LoadUint32(&o.ACC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ACC_Type) GetACC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.ACC_WPMR.Reg) & 0xffffff00) >> 8
}

// ACC.ACC_WPSR: Write Protection Status Register
func (o *ACC_Type) SetACC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.ACC_WPSR.Reg, volatile.LoadUint32(&o.ACC_WPSR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.ACC_WPSR.Reg) & 0x1
}

// Advanced Encryption Standard
type AES_Type struct {
	AES_CR      volatile.Register32 // 0x0
	AES_MR      volatile.Register32 // 0x4
	_           [8]byte
	AES_IER     volatile.Register32    // 0x10
	AES_IDR     volatile.Register32    // 0x14
	AES_IMR     volatile.Register32    // 0x18
	AES_ISR     volatile.Register32    // 0x1C
	AES_KEYWR   [8]volatile.Register32 // 0x20
	AES_IDATAR  [4]volatile.Register32 // 0x40
	AES_ODATAR  [4]volatile.Register32 // 0x50
	AES_IVR     [4]volatile.Register32 // 0x60
	AES_AADLENR volatile.Register32    // 0x70
	AES_CLENR   volatile.Register32    // 0x74
	AES_GHASHR  [4]volatile.Register32 // 0x78
	AES_TAGR    [4]volatile.Register32 // 0x88
	AES_CTRR    volatile.Register32    // 0x98
	AES_GCMHR   [4]volatile.Register32 // 0x9C
}

// AES.AES_CR: Control Register
func (o *AES_Type) SetAES_CR_START(value uint32) {
	volatile.StoreUint32(&o.AES_CR.Reg, volatile.LoadUint32(&o.AES_CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_CR_START() uint32 {
	return volatile.LoadUint32(&o.AES_CR.Reg) & 0x1
}
func (o *AES_Type) SetAES_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.AES_CR.Reg, volatile.LoadUint32(&o.AES_CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetAES_CR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.AES_CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetAES_CR_LOADSEED(value uint32) {
	volatile.StoreUint32(&o.AES_CR.Reg, volatile.LoadUint32(&o.AES_CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetAES_CR_LOADSEED() uint32 {
	return (volatile.LoadUint32(&o.AES_CR.Reg) & 0x10000) >> 16
}

// AES.AES_MR: Mode Register
func (o *AES_Type) SetAES_MR_CIPHER(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_MR_CIPHER() uint32 {
	return volatile.LoadUint32(&o.AES_MR.Reg) & 0x1
}
func (o *AES_Type) SetAES_MR_GTAGEN(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetAES_MR_GTAGEN() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetAES_MR_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetAES_MR_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetAES_MR_PROCDLY(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0xf0)|value<<4)
}
func (o *AES_Type) GetAES_MR_PROCDLY() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0xf0) >> 4
}
func (o *AES_Type) SetAES_MR_SMOD(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x300)|value<<8)
}
func (o *AES_Type) GetAES_MR_SMOD() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x300) >> 8
}
func (o *AES_Type) SetAES_MR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0xc00)|value<<10)
}
func (o *AES_Type) GetAES_MR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0xc00) >> 10
}
func (o *AES_Type) SetAES_MR_OPMOD(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x7000)|value<<12)
}
func (o *AES_Type) GetAES_MR_OPMOD() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x7000) >> 12
}
func (o *AES_Type) SetAES_MR_LOD(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x8000)|value<<15)
}
func (o *AES_Type) GetAES_MR_LOD() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x8000) >> 15
}
func (o *AES_Type) SetAES_MR_CFBS(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0x70000)|value<<16)
}
func (o *AES_Type) GetAES_MR_CFBS() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0x70000) >> 16
}
func (o *AES_Type) SetAES_MR_CKEY(value uint32) {
	volatile.StoreUint32(&o.AES_MR.Reg, volatile.LoadUint32(&o.AES_MR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetAES_MR_CKEY() uint32 {
	return (volatile.LoadUint32(&o.AES_MR.Reg) & 0xf00000) >> 20
}

// AES.AES_IER: Interrupt Enable Register
func (o *AES_Type) SetAES_IER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IER.Reg, volatile.LoadUint32(&o.AES_IER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_IER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.AES_IER.Reg) & 0x1
}
func (o *AES_Type) SetAES_IER_URAD(value uint32) {
	volatile.StoreUint32(&o.AES_IER.Reg, volatile.LoadUint32(&o.AES_IER.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetAES_IER_URAD() uint32 {
	return (volatile.LoadUint32(&o.AES_IER.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetAES_IER_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IER.Reg, volatile.LoadUint32(&o.AES_IER.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetAES_IER_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.AES_IER.Reg) & 0x10000) >> 16
}

// AES.AES_IDR: Interrupt Disable Register
func (o *AES_Type) SetAES_IDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IDR.Reg, volatile.LoadUint32(&o.AES_IDR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_IDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.AES_IDR.Reg) & 0x1
}
func (o *AES_Type) SetAES_IDR_URAD(value uint32) {
	volatile.StoreUint32(&o.AES_IDR.Reg, volatile.LoadUint32(&o.AES_IDR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetAES_IDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.AES_IDR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetAES_IDR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IDR.Reg, volatile.LoadUint32(&o.AES_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetAES_IDR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.AES_IDR.Reg) & 0x10000) >> 16
}

// AES.AES_IMR: Interrupt Mask Register
func (o *AES_Type) SetAES_IMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IMR.Reg, volatile.LoadUint32(&o.AES_IMR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_IMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.AES_IMR.Reg) & 0x1
}
func (o *AES_Type) SetAES_IMR_URAD(value uint32) {
	volatile.StoreUint32(&o.AES_IMR.Reg, volatile.LoadUint32(&o.AES_IMR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetAES_IMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.AES_IMR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetAES_IMR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.AES_IMR.Reg, volatile.LoadUint32(&o.AES_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetAES_IMR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.AES_IMR.Reg) & 0x10000) >> 16
}

// AES.AES_ISR: Interrupt Status Register
func (o *AES_Type) SetAES_ISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.AES_ISR.Reg, volatile.LoadUint32(&o.AES_ISR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetAES_ISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.AES_ISR.Reg) & 0x1
}
func (o *AES_Type) SetAES_ISR_URAD(value uint32) {
	volatile.StoreUint32(&o.AES_ISR.Reg, volatile.LoadUint32(&o.AES_ISR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetAES_ISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.AES_ISR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetAES_ISR_URAT(value uint32) {
	volatile.StoreUint32(&o.AES_ISR.Reg, volatile.LoadUint32(&o.AES_ISR.Reg)&^(0xf000)|value<<12)
}
func (o *AES_Type) GetAES_ISR_URAT() uint32 {
	return (volatile.LoadUint32(&o.AES_ISR.Reg) & 0xf000) >> 12
}
func (o *AES_Type) SetAES_ISR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.AES_ISR.Reg, volatile.LoadUint32(&o.AES_ISR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetAES_ISR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.AES_ISR.Reg) & 0x10000) >> 16
}

// AES.AES_KEYWR: Key Word Register
func (o *AES_Type) SetAES_KEYWR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_KEYWR[idx].Reg, value)
}
func (o *AES_Type) GetAES_KEYWR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_KEYWR[idx].Reg)
}

// AES.AES_IDATAR: Input Data Register
func (o *AES_Type) SetAES_IDATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_IDATAR[idx].Reg, value)
}
func (o *AES_Type) GetAES_IDATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_IDATAR[idx].Reg)
}

// AES.AES_ODATAR: Output Data Register
func (o *AES_Type) SetAES_ODATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_ODATAR[idx].Reg, value)
}
func (o *AES_Type) GetAES_ODATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_ODATAR[idx].Reg)
}

// AES.AES_IVR: Initialization Vector Register
func (o *AES_Type) SetAES_IVR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_IVR[idx].Reg, value)
}
func (o *AES_Type) GetAES_IVR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_IVR[idx].Reg)
}

// AES.AES_AADLENR: Additional Authenticated Data Length Register
func (o *AES_Type) SetAES_AADLENR(value uint32) {
	volatile.StoreUint32(&o.AES_AADLENR.Reg, value)
}
func (o *AES_Type) GetAES_AADLENR() uint32 {
	return volatile.LoadUint32(&o.AES_AADLENR.Reg)
}

// AES.AES_CLENR: Plaintext/Ciphertext Length Register
func (o *AES_Type) SetAES_CLENR(value uint32) {
	volatile.StoreUint32(&o.AES_CLENR.Reg, value)
}
func (o *AES_Type) GetAES_CLENR() uint32 {
	return volatile.LoadUint32(&o.AES_CLENR.Reg)
}

// AES.AES_GHASHR: GCM Intermediate Hash Word Register
func (o *AES_Type) SetAES_GHASHR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_GHASHR[idx].Reg, value)
}
func (o *AES_Type) GetAES_GHASHR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_GHASHR[idx].Reg)
}

// AES.AES_TAGR: GCM Authentication Tag Word Register
func (o *AES_Type) SetAES_TAGR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_TAGR[idx].Reg, value)
}
func (o *AES_Type) GetAES_TAGR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_TAGR[idx].Reg)
}

// AES.AES_CTRR: GCM Encryption Counter Value Register
func (o *AES_Type) SetAES_CTRR(value uint32) {
	volatile.StoreUint32(&o.AES_CTRR.Reg, value)
}
func (o *AES_Type) GetAES_CTRR() uint32 {
	return volatile.LoadUint32(&o.AES_CTRR.Reg)
}

// AES.AES_GCMHR: GCM H Word Register
func (o *AES_Type) SetAES_GCMHR(idx int, value uint32) {
	volatile.StoreUint32(&o.AES_GCMHR[idx].Reg, value)
}
func (o *AES_Type) GetAES_GCMHR(idx int) uint32 {
	return volatile.LoadUint32(&o.AES_GCMHR[idx].Reg)
}

// Analog Front-End Controller
type AFEC_Type struct {
	AFEC_CR      volatile.Register32 // 0x0
	AFEC_MR      volatile.Register32 // 0x4
	AFEC_EMR     volatile.Register32 // 0x8
	AFEC_SEQ1R   volatile.Register32 // 0xC
	AFEC_SEQ2R   volatile.Register32 // 0x10
	AFEC_CHER    volatile.Register32 // 0x14
	AFEC_CHDR    volatile.Register32 // 0x18
	AFEC_CHSR    volatile.Register32 // 0x1C
	AFEC_LCDR    volatile.Register32 // 0x20
	AFEC_IER     volatile.Register32 // 0x24
	AFEC_IDR     volatile.Register32 // 0x28
	AFEC_IMR     volatile.Register32 // 0x2C
	AFEC_ISR     volatile.Register32 // 0x30
	_            [24]byte
	AFEC_OVER    volatile.Register32 // 0x4C
	AFEC_CWR     volatile.Register32 // 0x50
	AFEC_CGR     volatile.Register32 // 0x54
	_            [8]byte
	AFEC_DIFFR   volatile.Register32 // 0x60
	AFEC_CSELR   volatile.Register32 // 0x64
	AFEC_CDR     volatile.Register32 // 0x68
	AFEC_COCR    volatile.Register32 // 0x6C
	AFEC_TEMPMR  volatile.Register32 // 0x70
	AFEC_TEMPCWR volatile.Register32 // 0x74
	_            [28]byte
	AFEC_ACR     volatile.Register32 // 0x94
	_            [8]byte
	AFEC_SHMR    volatile.Register32 // 0xA0
	_            [44]byte
	AFEC_COSR    volatile.Register32 // 0xD0
	AFEC_CVR     volatile.Register32 // 0xD4
	AFEC_CECR    volatile.Register32 // 0xD8
	_            [8]byte
	AFEC_WPMR    volatile.Register32 // 0xE4
	AFEC_WPSR    volatile.Register32 // 0xE8
}

// AFEC.AFEC_CR: AFEC Control Register
func (o *AFEC_Type) SetAFEC_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.AFEC_CR.Reg, volatile.LoadUint32(&o.AFEC_CR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_CR_SWRST() uint32 {
	return volatile.LoadUint32(&o.AFEC_CR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_CR_START(value uint32) {
	volatile.StoreUint32(&o.AFEC_CR.Reg, volatile.LoadUint32(&o.AFEC_CR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_CR_START() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CR.Reg) & 0x2) >> 1
}

// AFEC.AFEC_MR: AFEC Mode Register
func (o *AFEC_Type) SetAFEC_MR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_MR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_MR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0xe)|value<<1)
}
func (o *AFEC_Type) GetAFEC_MR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0xe) >> 1
}
func (o *AFEC_Type) SetAFEC_MR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_MR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_MR_FWUP(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_MR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_MR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_MR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_MR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0xff00)|value<<8)
}
func (o *AFEC_Type) GetAFEC_MR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0xff00) >> 8
}
func (o *AFEC_Type) SetAFEC_MR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_MR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetAFEC_MR_ONE(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x800000)|value<<23)
}
func (o *AFEC_Type) GetAFEC_MR_ONE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x800000) >> 23
}
func (o *AFEC_Type) SetAFEC_MR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_MR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetAFEC_MR_TRANSFER(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetAFEC_MR_TRANSFER() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x30000000) >> 28
}
func (o *AFEC_Type) SetAFEC_MR_USEQ(value uint32) {
	volatile.StoreUint32(&o.AFEC_MR.Reg, volatile.LoadUint32(&o.AFEC_MR.Reg)&^(0x80000000)|value<<31)
}
func (o *AFEC_Type) GetAFEC_MR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.AFEC_MR.Reg) & 0x80000000) >> 31
}

// AFEC.AFEC_EMR: AFEC Extended Mode Register
func (o *AFEC_Type) SetAFEC_EMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetAFEC_EMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x3
}
func (o *AFEC_Type) SetAFEC_EMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0xf8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_EMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0xf8) >> 3
}
func (o *AFEC_Type) SetAFEC_EMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_EMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_EMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetAFEC_EMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetAFEC_EMR_RES(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x70000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_EMR_RES() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x70000) >> 16
}
func (o *AFEC_Type) SetAFEC_EMR_TAG(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_EMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetAFEC_EMR_STM(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetAFEC_EMR_STM() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetAFEC_EMR_SIGNMODE(value uint32) {
	volatile.StoreUint32(&o.AFEC_EMR.Reg, volatile.LoadUint32(&o.AFEC_EMR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetAFEC_EMR_SIGNMODE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_EMR.Reg) & 0x30000000) >> 28
}

// AFEC.AFEC_SEQ1R: AFEC Channel Sequence 1 Register
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH0(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH0() uint32 {
	return volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH1(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH2(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH3(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf000) >> 12
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH4(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH5(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf00000)|value<<20)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf00000) >> 20
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH6(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetAFEC_SEQ1R_USCH7(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ1R.Reg, volatile.LoadUint32(&o.AFEC_SEQ1R.Reg)&^(0xf0000000)|value<<28)
}
func (o *AFEC_Type) GetAFEC_SEQ1R_USCH7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ1R.Reg) & 0xf0000000) >> 28
}

// AFEC.AFEC_SEQ2R: AFEC Channel Sequence 2 Register
func (o *AFEC_Type) SetAFEC_SEQ2R_USCH8(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ2R.Reg, volatile.LoadUint32(&o.AFEC_SEQ2R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetAFEC_SEQ2R_USCH8() uint32 {
	return volatile.LoadUint32(&o.AFEC_SEQ2R.Reg) & 0xf
}
func (o *AFEC_Type) SetAFEC_SEQ2R_USCH9(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ2R.Reg, volatile.LoadUint32(&o.AFEC_SEQ2R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetAFEC_SEQ2R_USCH9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ2R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetAFEC_SEQ2R_USCH10(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ2R.Reg, volatile.LoadUint32(&o.AFEC_SEQ2R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetAFEC_SEQ2R_USCH10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ2R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetAFEC_SEQ2R_USCH11(value uint32) {
	volatile.StoreUint32(&o.AFEC_SEQ2R.Reg, volatile.LoadUint32(&o.AFEC_SEQ2R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetAFEC_SEQ2R_USCH11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SEQ2R.Reg) & 0xf000) >> 12
}

// AFEC.AFEC_CHER: AFEC Channel Enable Register
func (o *AFEC_Type) SetAFEC_CHER_CH0(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_CHER_CH0() uint32 {
	return volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_CHER_CH1(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_CHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_CHER_CH2(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_CHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_CHER_CH3(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_CHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_CHER_CH4(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_CHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_CHER_CH5(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_CHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_CHER_CH6(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_CHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_CHER_CH7(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_CHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_CHER_CH8(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_CHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_CHER_CH9(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_CHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_CHER_CH10(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_CHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_CHER_CH11(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHER.Reg, volatile.LoadUint32(&o.AFEC_CHER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_CHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHER.Reg) & 0x800) >> 11
}

// AFEC.AFEC_CHDR: AFEC Channel Disable Register
func (o *AFEC_Type) SetAFEC_CHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_CHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_CHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_CHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_CHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_CHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_CHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_CHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_CHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_CHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_CHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_CHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHDR.Reg, volatile.LoadUint32(&o.AFEC_CHDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_CHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHDR.Reg) & 0x800) >> 11
}

// AFEC.AFEC_CHSR: AFEC Channel Status Register
func (o *AFEC_Type) SetAFEC_CHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_CHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_CHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_CHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_CHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_CHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_CHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_CHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_CHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_CHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_CHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_CHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.AFEC_CHSR.Reg, volatile.LoadUint32(&o.AFEC_CHSR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_CHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CHSR.Reg) & 0x800) >> 11
}

// AFEC.AFEC_LCDR: AFEC Last Converted Data Register
func (o *AFEC_Type) SetAFEC_LCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.AFEC_LCDR.Reg, volatile.LoadUint32(&o.AFEC_LCDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetAFEC_LCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.AFEC_LCDR.Reg) & 0xffff
}
func (o *AFEC_Type) SetAFEC_LCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.AFEC_LCDR.Reg, volatile.LoadUint32(&o.AFEC_LCDR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_LCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.AFEC_LCDR.Reg) & 0xf000000) >> 24
}

// AFEC.AFEC_IER: AFEC Interrupt Enable Register
func (o *AFEC_Type) SetAFEC_IER_EOC0(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_IER_EOC0() uint32 {
	return volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_IER_EOC1(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_IER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_IER_EOC2(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_IER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_IER_EOC3(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_IER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_IER_EOC4(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_IER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_IER_EOC5(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_IER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_IER_EOC6(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_IER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_IER_EOC7(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_IER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_IER_EOC8(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_IER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_IER_EOC9(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_IER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_IER_EOC10(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_IER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_IER_EOC11(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_IER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetAFEC_IER_DRDY(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_IER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetAFEC_IER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetAFEC_IER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetAFEC_IER_COMPE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetAFEC_IER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetAFEC_IER_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.AFEC_IER.Reg, volatile.LoadUint32(&o.AFEC_IER.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetAFEC_IER_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IER.Reg) & 0x40000000) >> 30
}

// AFEC.AFEC_IDR: AFEC Interrupt Disable Register
func (o *AFEC_Type) SetAFEC_IDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_IDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_IDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_IDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_IDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_IDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_IDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_IDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_IDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_IDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_IDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_IDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_IDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetAFEC_IDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_IDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetAFEC_IDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetAFEC_IDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetAFEC_IDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetAFEC_IDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetAFEC_IDR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.AFEC_IDR.Reg, volatile.LoadUint32(&o.AFEC_IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetAFEC_IDR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IDR.Reg) & 0x40000000) >> 30
}

// AFEC.AFEC_IMR: AFEC Interrupt Mask Register
func (o *AFEC_Type) SetAFEC_IMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_IMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_IMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_IMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_IMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_IMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_IMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_IMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_IMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_IMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_IMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_IMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_IMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetAFEC_IMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_IMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetAFEC_IMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetAFEC_IMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetAFEC_IMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetAFEC_IMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetAFEC_IMR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.AFEC_IMR.Reg, volatile.LoadUint32(&o.AFEC_IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetAFEC_IMR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.AFEC_IMR.Reg) & 0x40000000) >> 30
}

// AFEC.AFEC_ISR: AFEC Interrupt Status Register
func (o *AFEC_Type) SetAFEC_ISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_ISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_ISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_ISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_ISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_ISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_ISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_ISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_ISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_ISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_ISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_ISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_ISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetAFEC_ISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetAFEC_ISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetAFEC_ISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetAFEC_ISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetAFEC_ISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetAFEC_ISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetAFEC_ISR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.AFEC_ISR.Reg, volatile.LoadUint32(&o.AFEC_ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetAFEC_ISR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ISR.Reg) & 0x40000000) >> 30
}

// AFEC.AFEC_OVER: AFEC Overrun Status Register
func (o *AFEC_Type) SetAFEC_OVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_OVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.AFEC_OVER.Reg, volatile.LoadUint32(&o.AFEC_OVER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_OVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_OVER.Reg) & 0x800) >> 11
}

// AFEC.AFEC_CWR: AFEC Compare Window Register
func (o *AFEC_Type) SetAFEC_CWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.AFEC_CWR.Reg, volatile.LoadUint32(&o.AFEC_CWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetAFEC_CWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.AFEC_CWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetAFEC_CWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.AFEC_CWR.Reg, volatile.LoadUint32(&o.AFEC_CWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_CWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CWR.Reg) & 0xffff0000) >> 16
}

// AFEC.AFEC_CGR: AFEC Channel Gain Register
func (o *AFEC_Type) SetAFEC_CGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x3
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc)|value<<2)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc) >> 2
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x30) >> 4
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc0)|value<<6)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc0) >> 6
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x300) >> 8
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc00)|value<<10)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc00) >> 10
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc000)|value<<14)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc000) >> 14
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x30000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x30000) >> 16
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc0000) >> 18
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0x300000)|value<<20)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0x300000) >> 20
}
func (o *AFEC_Type) SetAFEC_CGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.AFEC_CGR.Reg, volatile.LoadUint32(&o.AFEC_CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *AFEC_Type) GetAFEC_CGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CGR.Reg) & 0xc00000) >> 22
}

// AFEC.AFEC_DIFFR: AFEC Channel Differential Register
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF0() uint32 {
	return volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_DIFFR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.AFEC_DIFFR.Reg, volatile.LoadUint32(&o.AFEC_DIFFR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_DIFFR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_DIFFR.Reg) & 0x800) >> 11
}

// AFEC.AFEC_CSELR: AFEC Channel Selection Register
func (o *AFEC_Type) SetAFEC_CSELR_CSEL(value uint32) {
	volatile.StoreUint32(&o.AFEC_CSELR.Reg, volatile.LoadUint32(&o.AFEC_CSELR.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetAFEC_CSELR_CSEL() uint32 {
	return volatile.LoadUint32(&o.AFEC_CSELR.Reg) & 0xf
}

// AFEC.AFEC_CDR: AFEC Channel Data Register
func (o *AFEC_Type) SetAFEC_CDR_DATA(value uint32) {
	volatile.StoreUint32(&o.AFEC_CDR.Reg, volatile.LoadUint32(&o.AFEC_CDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetAFEC_CDR_DATA() uint32 {
	return volatile.LoadUint32(&o.AFEC_CDR.Reg) & 0xffff
}

// AFEC.AFEC_COCR: AFEC Channel Offset Compensation Register
func (o *AFEC_Type) SetAFEC_COCR_AOFF(value uint32) {
	volatile.StoreUint32(&o.AFEC_COCR.Reg, volatile.LoadUint32(&o.AFEC_COCR.Reg)&^(0x3ff)|value)
}
func (o *AFEC_Type) GetAFEC_COCR_AOFF() uint32 {
	return volatile.LoadUint32(&o.AFEC_COCR.Reg) & 0x3ff
}

// AFEC.AFEC_TEMPMR: AFEC Temperature Sensor Mode Register
func (o *AFEC_Type) SetAFEC_TEMPMR_RTCT(value uint32) {
	volatile.StoreUint32(&o.AFEC_TEMPMR.Reg, volatile.LoadUint32(&o.AFEC_TEMPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_TEMPMR_RTCT() uint32 {
	return volatile.LoadUint32(&o.AFEC_TEMPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_TEMPMR_TEMPCMPMOD(value uint32) {
	volatile.StoreUint32(&o.AFEC_TEMPMR.Reg, volatile.LoadUint32(&o.AFEC_TEMPMR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetAFEC_TEMPMR_TEMPCMPMOD() uint32 {
	return (volatile.LoadUint32(&o.AFEC_TEMPMR.Reg) & 0x30) >> 4
}

// AFEC.AFEC_TEMPCWR: AFEC Temperature Compare Window Register
func (o *AFEC_Type) SetAFEC_TEMPCWR_TLOWTHRES(value uint32) {
	volatile.StoreUint32(&o.AFEC_TEMPCWR.Reg, volatile.LoadUint32(&o.AFEC_TEMPCWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetAFEC_TEMPCWR_TLOWTHRES() uint32 {
	return volatile.LoadUint32(&o.AFEC_TEMPCWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetAFEC_TEMPCWR_THIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.AFEC_TEMPCWR.Reg, volatile.LoadUint32(&o.AFEC_TEMPCWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_TEMPCWR_THIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.AFEC_TEMPCWR.Reg) & 0xffff0000) >> 16
}

// AFEC.AFEC_ACR: AFEC Analog Control Register
func (o *AFEC_Type) SetAFEC_ACR_PGA0EN(value uint32) {
	volatile.StoreUint32(&o.AFEC_ACR.Reg, volatile.LoadUint32(&o.AFEC_ACR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_ACR_PGA0EN() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ACR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_ACR_PGA1EN(value uint32) {
	volatile.StoreUint32(&o.AFEC_ACR.Reg, volatile.LoadUint32(&o.AFEC_ACR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_ACR_PGA1EN() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ACR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_ACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.AFEC_ACR.Reg, volatile.LoadUint32(&o.AFEC_ACR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetAFEC_ACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.AFEC_ACR.Reg) & 0x300) >> 8
}

// AFEC.AFEC_SHMR: AFEC Sample & Hold Mode Register
func (o *AFEC_Type) SetAFEC_SHMR_DUAL0(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL0() uint32 {
	return volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL1(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL2(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL3(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL4(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL5(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL6(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL7(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL8(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL9(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL10(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_SHMR_DUAL11(value uint32) {
	volatile.StoreUint32(&o.AFEC_SHMR.Reg, volatile.LoadUint32(&o.AFEC_SHMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_SHMR_DUAL11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_SHMR.Reg) & 0x800) >> 11
}

// AFEC.AFEC_COSR: AFEC Correction Select Register
func (o *AFEC_Type) SetAFEC_COSR_CSEL(value uint32) {
	volatile.StoreUint32(&o.AFEC_COSR.Reg, volatile.LoadUint32(&o.AFEC_COSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_COSR_CSEL() uint32 {
	return volatile.LoadUint32(&o.AFEC_COSR.Reg) & 0x1
}

// AFEC.AFEC_CVR: AFEC Correction Values Register
func (o *AFEC_Type) SetAFEC_CVR_OFFSETCORR(value uint32) {
	volatile.StoreUint32(&o.AFEC_CVR.Reg, volatile.LoadUint32(&o.AFEC_CVR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetAFEC_CVR_OFFSETCORR() uint32 {
	return volatile.LoadUint32(&o.AFEC_CVR.Reg) & 0xffff
}
func (o *AFEC_Type) SetAFEC_CVR_GAINCORR(value uint32) {
	volatile.StoreUint32(&o.AFEC_CVR.Reg, volatile.LoadUint32(&o.AFEC_CVR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetAFEC_CVR_GAINCORR() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CVR.Reg) & 0xffff0000) >> 16
}

// AFEC.AFEC_CECR: AFEC Channel Error Correction Register
func (o *AFEC_Type) SetAFEC_CECR_ECORR0(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR0() uint32 {
	return volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR1(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR1() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR2(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR2() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR3(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR3() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR4(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR4() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR5(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR5() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR6(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR6() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR7(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR7() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR8(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR8() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR9(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR9() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR10(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR10() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetAFEC_CECR_ECORR11(value uint32) {
	volatile.StoreUint32(&o.AFEC_CECR.Reg, volatile.LoadUint32(&o.AFEC_CECR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetAFEC_CECR_ECORR11() uint32 {
	return (volatile.LoadUint32(&o.AFEC_CECR.Reg) & 0x800) >> 11
}

// AFEC.AFEC_WPMR: AFEC Write Protection Mode Register
func (o *AFEC_Type) SetAFEC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.AFEC_WPMR.Reg, volatile.LoadUint32(&o.AFEC_WPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.AFEC_WPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.AFEC_WPMR.Reg, volatile.LoadUint32(&o.AFEC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *AFEC_Type) GetAFEC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.AFEC_WPMR.Reg) & 0xffffff00) >> 8
}

// AFEC.AFEC_WPSR: AFEC Write Protection Status Register
func (o *AFEC_Type) SetAFEC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.AFEC_WPSR.Reg, volatile.LoadUint32(&o.AFEC_WPSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetAFEC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.AFEC_WPSR.Reg) & 0x1
}
func (o *AFEC_Type) SetAFEC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.AFEC_WPSR.Reg, volatile.LoadUint32(&o.AFEC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *AFEC_Type) GetAFEC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.AFEC_WPSR.Reg) & 0xffff00) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CHIPID_CIDR volatile.Register32 // 0x0
	CHIPID_EXID volatile.Register32 // 0x4
}

// CHIPID.CHIPID_CIDR: Chip ID Register
func (o *CHIPID_Type) SetCHIPID_CIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCHIPID_CIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCHIPID_CIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCHIPID_CIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCHIPID_CIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCHIPID_CIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCHIPID_CIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCHIPID_CIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CHIPID_CIDR.Reg, volatile.LoadUint32(&o.CHIPID_CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCHIPID_CIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CHIPID_CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.CHIPID_EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetCHIPID_EXID(value uint32) {
	volatile.StoreUint32(&o.CHIPID_EXID.Reg, value)
}
func (o *CHIPID_Type) GetCHIPID_EXID() uint32 {
	return volatile.LoadUint32(&o.CHIPID_EXID.Reg)
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	DACC_CR    volatile.Register32 // 0x0
	DACC_MR    volatile.Register32 // 0x4
	DACC_TRIGR volatile.Register32 // 0x8
	_          [4]byte
	DACC_CHER  volatile.Register32    // 0x10
	DACC_CHDR  volatile.Register32    // 0x14
	DACC_CHSR  volatile.Register32    // 0x18
	DACC_CDR   [2]volatile.Register32 // 0x1C
	DACC_IER   volatile.Register32    // 0x24
	DACC_IDR   volatile.Register32    // 0x28
	DACC_IMR   volatile.Register32    // 0x2C
	DACC_ISR   volatile.Register32    // 0x30
	_          [96]byte
	DACC_ACR   volatile.Register32 // 0x94
	_          [76]byte
	DACC_WPMR  volatile.Register32 // 0xE4
	DACC_WPSR  volatile.Register32 // 0xE8
}

// DACC.DACC_CR: Control Register
func (o *DACC_Type) SetDACC_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.DACC_CR.Reg, volatile.LoadUint32(&o.DACC_CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_CR_SWRST() uint32 {
	return volatile.LoadUint32(&o.DACC_CR.Reg) & 0x1
}

// DACC.DACC_MR: Mode Register
func (o *DACC_Type) SetDACC_MR_MAXS0(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_MR_MAXS0() uint32 {
	return volatile.LoadUint32(&o.DACC_MR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_MR_MAXS1(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_MR_MAXS1() uint32 {
	return (volatile.LoadUint32(&o.DACC_MR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_MR_WORD(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetDACC_MR_WORD() uint32 {
	return (volatile.LoadUint32(&o.DACC_MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetDACC_MR_ZERO(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetDACC_MR_ZERO() uint32 {
	return (volatile.LoadUint32(&o.DACC_MR.Reg) & 0x20) >> 5
}
func (o *DACC_Type) SetDACC_MR_DIFF(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0x800000)|value<<23)
}
func (o *DACC_Type) GetDACC_MR_DIFF() uint32 {
	return (volatile.LoadUint32(&o.DACC_MR.Reg) & 0x800000) >> 23
}
func (o *DACC_Type) SetDACC_MR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.DACC_MR.Reg, volatile.LoadUint32(&o.DACC_MR.Reg)&^(0xf000000)|value<<24)
}
func (o *DACC_Type) GetDACC_MR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.DACC_MR.Reg) & 0xf000000) >> 24
}

// DACC.DACC_TRIGR: Trigger Register
func (o *DACC_Type) SetDACC_TRIGR_TRGEN0(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_TRIGR_TRGEN0() uint32 {
	return volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_TRIGR_TRGEN1(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_TRIGR_TRGEN1() uint32 {
	return (volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_TRIGR_TRGSEL0(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x70)|value<<4)
}
func (o *DACC_Type) GetDACC_TRIGR_TRGSEL0() uint32 {
	return (volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x70) >> 4
}
func (o *DACC_Type) SetDACC_TRIGR_TRGSEL1(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x700)|value<<8)
}
func (o *DACC_Type) GetDACC_TRIGR_TRGSEL1() uint32 {
	return (volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x700) >> 8
}
func (o *DACC_Type) SetDACC_TRIGR_OSR0(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x70000)|value<<16)
}
func (o *DACC_Type) GetDACC_TRIGR_OSR0() uint32 {
	return (volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x70000) >> 16
}
func (o *DACC_Type) SetDACC_TRIGR_OSR1(value uint32) {
	volatile.StoreUint32(&o.DACC_TRIGR.Reg, volatile.LoadUint32(&o.DACC_TRIGR.Reg)&^(0x700000)|value<<20)
}
func (o *DACC_Type) GetDACC_TRIGR_OSR1() uint32 {
	return (volatile.LoadUint32(&o.DACC_TRIGR.Reg) & 0x700000) >> 20
}

// DACC.DACC_CHER: Channel Enable Register
func (o *DACC_Type) SetDACC_CHER_CH0(value uint32) {
	volatile.StoreUint32(&o.DACC_CHER.Reg, volatile.LoadUint32(&o.DACC_CHER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_CHER_CH0() uint32 {
	return volatile.LoadUint32(&o.DACC_CHER.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_CHER_CH1(value uint32) {
	volatile.StoreUint32(&o.DACC_CHER.Reg, volatile.LoadUint32(&o.DACC_CHER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_CHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.DACC_CHER.Reg) & 0x2) >> 1
}

// DACC.DACC_CHDR: Channel Disable Register
func (o *DACC_Type) SetDACC_CHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.DACC_CHDR.Reg, volatile.LoadUint32(&o.DACC_CHDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_CHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.DACC_CHDR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_CHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.DACC_CHDR.Reg, volatile.LoadUint32(&o.DACC_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_CHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.DACC_CHDR.Reg) & 0x2) >> 1
}

// DACC.DACC_CHSR: Channel Status Register
func (o *DACC_Type) SetDACC_CHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.DACC_CHSR.Reg, volatile.LoadUint32(&o.DACC_CHSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_CHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.DACC_CHSR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_CHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.DACC_CHSR.Reg, volatile.LoadUint32(&o.DACC_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_CHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.DACC_CHSR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_CHSR_DACRDY0(value uint32) {
	volatile.StoreUint32(&o.DACC_CHSR.Reg, volatile.LoadUint32(&o.DACC_CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetDACC_CHSR_DACRDY0() uint32 {
	return (volatile.LoadUint32(&o.DACC_CHSR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetDACC_CHSR_DACRDY1(value uint32) {
	volatile.StoreUint32(&o.DACC_CHSR.Reg, volatile.LoadUint32(&o.DACC_CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetDACC_CHSR_DACRDY1() uint32 {
	return (volatile.LoadUint32(&o.DACC_CHSR.Reg) & 0x200) >> 9
}

// DACC.DACC_CDR: Conversion Data Register 0
func (o *DACC_Type) SetDACC_CDR_DATA0(idx int, value uint32) {
	volatile.StoreUint32(&o.DACC_CDR[idx].Reg, volatile.LoadUint32(&o.DACC_CDR[idx].Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetDACC_CDR_DATA0(idx int) uint32 {
	return volatile.LoadUint32(&o.DACC_CDR[idx].Reg) & 0xffff
}
func (o *DACC_Type) SetDACC_CDR_DATA1(idx int, value uint32) {
	volatile.StoreUint32(&o.DACC_CDR[idx].Reg, volatile.LoadUint32(&o.DACC_CDR[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *DACC_Type) GetDACC_CDR_DATA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.DACC_CDR[idx].Reg) & 0xffff0000) >> 16
}

// DACC.DACC_IER: Interrupt Enable Register
func (o *DACC_Type) SetDACC_IER_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.DACC_IER.Reg, volatile.LoadUint32(&o.DACC_IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_IER_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.DACC_IER.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_IER_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.DACC_IER.Reg, volatile.LoadUint32(&o.DACC_IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_IER_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_IER_EOC0(value uint32) {
	volatile.StoreUint32(&o.DACC_IER.Reg, volatile.LoadUint32(&o.DACC_IER.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetDACC_IER_EOC0() uint32 {
	return (volatile.LoadUint32(&o.DACC_IER.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetDACC_IER_EOC1(value uint32) {
	volatile.StoreUint32(&o.DACC_IER.Reg, volatile.LoadUint32(&o.DACC_IER.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetDACC_IER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IER.Reg) & 0x20) >> 5
}

// DACC.DACC_IDR: Interrupt Disable Register
func (o *DACC_Type) SetDACC_IDR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.DACC_IDR.Reg, volatile.LoadUint32(&o.DACC_IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_IDR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.DACC_IDR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_IDR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.DACC_IDR.Reg, volatile.LoadUint32(&o.DACC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_IDR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_IDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.DACC_IDR.Reg, volatile.LoadUint32(&o.DACC_IDR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetDACC_IDR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.DACC_IDR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetDACC_IDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.DACC_IDR.Reg, volatile.LoadUint32(&o.DACC_IDR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetDACC_IDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IDR.Reg) & 0x20) >> 5
}

// DACC.DACC_IMR: Interrupt Mask Register
func (o *DACC_Type) SetDACC_IMR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.DACC_IMR.Reg, volatile.LoadUint32(&o.DACC_IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_IMR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.DACC_IMR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_IMR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.DACC_IMR.Reg, volatile.LoadUint32(&o.DACC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_IMR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_IMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.DACC_IMR.Reg, volatile.LoadUint32(&o.DACC_IMR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetDACC_IMR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.DACC_IMR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetDACC_IMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.DACC_IMR.Reg, volatile.LoadUint32(&o.DACC_IMR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetDACC_IMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.DACC_IMR.Reg) & 0x20) >> 5
}

// DACC.DACC_ISR: Interrupt Status Register
func (o *DACC_Type) SetDACC_ISR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.DACC_ISR.Reg, volatile.LoadUint32(&o.DACC_ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_ISR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.DACC_ISR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_ISR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.DACC_ISR.Reg, volatile.LoadUint32(&o.DACC_ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetDACC_ISR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.DACC_ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetDACC_ISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.DACC_ISR.Reg, volatile.LoadUint32(&o.DACC_ISR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetDACC_ISR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.DACC_ISR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetDACC_ISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.DACC_ISR.Reg, volatile.LoadUint32(&o.DACC_ISR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetDACC_ISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.DACC_ISR.Reg) & 0x20) >> 5
}

// DACC.DACC_ACR: Analog Current Register
func (o *DACC_Type) SetDACC_ACR_IBCTLCH0(value uint32) {
	volatile.StoreUint32(&o.DACC_ACR.Reg, volatile.LoadUint32(&o.DACC_ACR.Reg)&^(0x3)|value)
}
func (o *DACC_Type) GetDACC_ACR_IBCTLCH0() uint32 {
	return volatile.LoadUint32(&o.DACC_ACR.Reg) & 0x3
}
func (o *DACC_Type) SetDACC_ACR_IBCTLCH1(value uint32) {
	volatile.StoreUint32(&o.DACC_ACR.Reg, volatile.LoadUint32(&o.DACC_ACR.Reg)&^(0xc)|value<<2)
}
func (o *DACC_Type) GetDACC_ACR_IBCTLCH1() uint32 {
	return (volatile.LoadUint32(&o.DACC_ACR.Reg) & 0xc) >> 2
}

// DACC.DACC_WPMR: Write Protection Mode Register
func (o *DACC_Type) SetDACC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.DACC_WPMR.Reg, volatile.LoadUint32(&o.DACC_WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.DACC_WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.DACC_WPMR.Reg, volatile.LoadUint32(&o.DACC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetDACC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.DACC_WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.DACC_WPSR: Write Protection Status Register
func (o *DACC_Type) SetDACC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.DACC_WPSR.Reg, volatile.LoadUint32(&o.DACC_WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetDACC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.DACC_WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetDACC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.DACC_WPSR.Reg, volatile.LoadUint32(&o.DACC_WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetDACC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.DACC_WPSR.Reg) & 0xff00) >> 8
}

// Embedded Flash Controller
type EFC_Type struct {
	EEFC_FMR  volatile.Register32 // 0x0
	EEFC_FCR  volatile.Register32 // 0x4
	EEFC_FSR  volatile.Register32 // 0x8
	EEFC_FRR  volatile.Register32 // 0xC
	_         [212]byte
	EEFC_WPMR volatile.Register32 // 0xE4
}

// EFC.EEFC_FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetEEFC_FMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FMR_FWS(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetEEFC_FMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FMR_CLOE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x4000000)|value<<26)
}
func (o *EFC_Type) GetEEFC_FMR_CLOE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x4000000) >> 26
}

// EFC.EEFC_FCR: EEFC Flash Command Register
func (o *EFC_Type) SetEEFC_FCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetEEFC_FCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff
}
func (o *EFC_Type) SetEEFC_FCR_FARG(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetEEFC_FCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetEEFC_FCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff000000) >> 24
}

// EFC.EEFC_FSR: EEFC Flash Status Register
func (o *EFC_Type) SetEEFC_FSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetEEFC_FSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetEEFC_FSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetEEFC_FSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x4) >> 2
}
func (o *EFC_Type) SetEEFC_FSR_FLERR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x8)|value<<3)
}
func (o *EFC_Type) GetEEFC_FSR_FLERR() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x8) >> 3
}
func (o *EFC_Type) SetEEFC_FSR_UECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FSR_UECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FSR_MECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x20000)|value<<17)
}
func (o *EFC_Type) GetEEFC_FSR_MECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x20000) >> 17
}
func (o *EFC_Type) SetEEFC_FSR_UECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x40000)|value<<18)
}
func (o *EFC_Type) GetEEFC_FSR_UECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x40000) >> 18
}
func (o *EFC_Type) SetEEFC_FSR_MECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x80000)|value<<19)
}
func (o *EFC_Type) GetEEFC_FSR_MECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x80000) >> 19
}

// EFC.EEFC_FRR: EEFC Flash Result Register
func (o *EFC_Type) SetEEFC_FRR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FRR.Reg, value)
}
func (o *EFC_Type) GetEEFC_FRR() uint32 {
	return volatile.LoadUint32(&o.EEFC_FRR.Reg)
}

// EFC.EEFC_WPMR: Write Protection Mode Register
func (o *EFC_Type) SetEEFC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0xffffff00) >> 8
}

// Gigabit Ethernet MAC
type GMAC_Type struct {
	GMAC_NCR       volatile.Register32 // 0x0
	GMAC_NCFGR     volatile.Register32 // 0x4
	GMAC_NSR       volatile.Register32 // 0x8
	GMAC_UR        volatile.Register32 // 0xC
	GMAC_DCFGR     volatile.Register32 // 0x10
	GMAC_TSR       volatile.Register32 // 0x14
	GMAC_RBQB      volatile.Register32 // 0x18
	GMAC_TBQB      volatile.Register32 // 0x1C
	GMAC_RSR       volatile.Register32 // 0x20
	GMAC_ISR       volatile.Register32 // 0x24
	GMAC_IER       volatile.Register32 // 0x28
	GMAC_IDR       volatile.Register32 // 0x2C
	GMAC_IMR       volatile.Register32 // 0x30
	GMAC_MAN       volatile.Register32 // 0x34
	GMAC_RPQ       volatile.Register32 // 0x38
	GMAC_TPQ       volatile.Register32 // 0x3C
	GMAC_TPSF      volatile.Register32 // 0x40
	GMAC_RPSF      volatile.Register32 // 0x44
	GMAC_RJFML     volatile.Register32 // 0x48
	_              [52]byte
	GMAC_HRB       volatile.Register32  // 0x80
	GMAC_HRT       volatile.Register32  // 0x84
	GMAC_SA        [4]GMAC_GMAC_SA_Type // 0x88
	GMAC_TIDM1     volatile.Register32  // 0xA8
	GMAC_TIDM2     volatile.Register32  // 0xAC
	GMAC_TIDM3     volatile.Register32  // 0xB0
	GMAC_TIDM4     volatile.Register32  // 0xB4
	GMAC_WOL       volatile.Register32  // 0xB8
	GMAC_IPGS      volatile.Register32  // 0xBC
	GMAC_SVLAN     volatile.Register32  // 0xC0
	GMAC_TPFCP     volatile.Register32  // 0xC4
	GMAC_SAMB1     volatile.Register32  // 0xC8
	GMAC_SAMT1     volatile.Register32  // 0xCC
	_              [12]byte
	GMAC_NSC       volatile.Register32 // 0xDC
	GMAC_SCL       volatile.Register32 // 0xE0
	GMAC_SCH       volatile.Register32 // 0xE4
	GMAC_EFTSH     volatile.Register32 // 0xE8
	GMAC_EFRSH     volatile.Register32 // 0xEC
	GMAC_PEFTSH    volatile.Register32 // 0xF0
	GMAC_PEFRSH    volatile.Register32 // 0xF4
	_              [8]byte
	GMAC_OTLO      volatile.Register32 // 0x100
	GMAC_OTHI      volatile.Register32 // 0x104
	GMAC_FT        volatile.Register32 // 0x108
	GMAC_BCFT      volatile.Register32 // 0x10C
	GMAC_MFT       volatile.Register32 // 0x110
	GMAC_PFT       volatile.Register32 // 0x114
	GMAC_BFT64     volatile.Register32 // 0x118
	GMAC_TBFT127   volatile.Register32 // 0x11C
	GMAC_TBFT255   volatile.Register32 // 0x120
	GMAC_TBFT511   volatile.Register32 // 0x124
	GMAC_TBFT1023  volatile.Register32 // 0x128
	GMAC_TBFT1518  volatile.Register32 // 0x12C
	GMAC_GTBFT1518 volatile.Register32 // 0x130
	GMAC_TUR       volatile.Register32 // 0x134
	GMAC_SCF       volatile.Register32 // 0x138
	GMAC_MCF       volatile.Register32 // 0x13C
	GMAC_EC        volatile.Register32 // 0x140
	GMAC_LC        volatile.Register32 // 0x144
	GMAC_DTF       volatile.Register32 // 0x148
	GMAC_CSE       volatile.Register32 // 0x14C
	GMAC_ORLO      volatile.Register32 // 0x150
	GMAC_ORHI      volatile.Register32 // 0x154
	GMAC_FR        volatile.Register32 // 0x158
	GMAC_BCFR      volatile.Register32 // 0x15C
	GMAC_MFR       volatile.Register32 // 0x160
	GMAC_PFR       volatile.Register32 // 0x164
	GMAC_BFR64     volatile.Register32 // 0x168
	GMAC_TBFR127   volatile.Register32 // 0x16C
	GMAC_TBFR255   volatile.Register32 // 0x170
	GMAC_TBFR511   volatile.Register32 // 0x174
	GMAC_TBFR1023  volatile.Register32 // 0x178
	GMAC_TBFR1518  volatile.Register32 // 0x17C
	GMAC_TMXBFR    volatile.Register32 // 0x180
	GMAC_UFR       volatile.Register32 // 0x184
	GMAC_OFR       volatile.Register32 // 0x188
	GMAC_JR        volatile.Register32 // 0x18C
	GMAC_FCSE      volatile.Register32 // 0x190
	GMAC_LFFE      volatile.Register32 // 0x194
	GMAC_RSE       volatile.Register32 // 0x198
	GMAC_AE        volatile.Register32 // 0x19C
	GMAC_RRE       volatile.Register32 // 0x1A0
	GMAC_ROE       volatile.Register32 // 0x1A4
	GMAC_IHCE      volatile.Register32 // 0x1A8
	GMAC_TCE       volatile.Register32 // 0x1AC
	GMAC_UCE       volatile.Register32 // 0x1B0
	_              [8]byte
	GMAC_TISUBN    volatile.Register32 // 0x1BC
	GMAC_TSH       volatile.Register32 // 0x1C0
	_              [12]byte
	GMAC_TSL       volatile.Register32 // 0x1D0
	GMAC_TN        volatile.Register32 // 0x1D4
	GMAC_TA        volatile.Register32 // 0x1D8
	GMAC_TI        volatile.Register32 // 0x1DC
	GMAC_EFTSL     volatile.Register32 // 0x1E0
	GMAC_EFTN      volatile.Register32 // 0x1E4
	GMAC_EFRSL     volatile.Register32 // 0x1E8
	GMAC_EFRN      volatile.Register32 // 0x1EC
	GMAC_PEFTSL    volatile.Register32 // 0x1F0
	GMAC_PEFTN     volatile.Register32 // 0x1F4
	GMAC_PEFRSL    volatile.Register32 // 0x1F8
	GMAC_PEFRN     volatile.Register32 // 0x1FC
	_              [112]byte
	GMAC_RXLPI     volatile.Register32 // 0x270
	GMAC_RXLPITIME volatile.Register32 // 0x274
	GMAC_TXLPI     volatile.Register32 // 0x278
	GMAC_TXLPITIME volatile.Register32 // 0x27C
	_              [384]byte
	GMAC_ISRPQ     [5]volatile.Register32 // 0x400
	_              [44]byte
	GMAC_TBQBAPQ   [5]volatile.Register32 // 0x440
	_              [44]byte
	GMAC_RBQBAPQ   [5]volatile.Register32 // 0x480
	_              [12]byte
	GMAC_RBSRPQ    [5]volatile.Register32 // 0x4A0
	_              [8]byte
	GMAC_CBSCR     volatile.Register32 // 0x4BC
	GMAC_CBSISQA   volatile.Register32 // 0x4C0
	GMAC_CBSISQB   volatile.Register32 // 0x4C4
	_              [56]byte
	GMAC_ST1RPQ    [4]volatile.Register32 // 0x500
	_              [48]byte
	GMAC_ST2RPQ    [8]volatile.Register32 // 0x540
	_              [160]byte
	GMAC_IERPQ     [5]volatile.Register32 // 0x600
	_              [12]byte
	GMAC_IDRPQ     [5]volatile.Register32 // 0x620
	_              [12]byte
	GMAC_IMRPQ     [5]volatile.Register32 // 0x640
	_              [140]byte
	GMAC_ST2ER     [4]volatile.Register32 // 0x6E0
	_              [16]byte
	GMAC_ST2CW     [24]GMAC_GMAC_ST2CW_Type // 0x700
}

// GMAC.GMAC_NCR: Network Control Register
func (o *GMAC_Type) SetGMAC_NCR_LBL(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_NCR_LBL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_NCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_NCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_NCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_NCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_NCR_MPE(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_NCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_NCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_NCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_NCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_NCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_NCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_NCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_NCR_BP(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetGMAC_NCR_BP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetGMAC_NCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x200)|value<<9)
}
func (o *GMAC_Type) GetGMAC_NCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x200) >> 9
}
func (o *GMAC_Type) SetGMAC_NCR_THALT(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_NCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_NCR_TXPF(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_NCR_TXPF() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_NCR_TXZQPF(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_NCR_TXZQPF() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_NCR_SRTSM(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetGMAC_NCR_SRTSM() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetGMAC_NCR_ENPBPR(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_NCR_ENPBPR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetGMAC_NCR_TXPBPF(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetGMAC_NCR_TXPBPF() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetGMAC_NCR_FNP(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_NCR_FNP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_NCR_TXLPIEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCR.Reg, volatile.LoadUint32(&o.GMAC_NCR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_NCR_TXLPIEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCR.Reg) & 0x80000) >> 19
}

// GMAC.GMAC_NCFGR: Network Configuration Register
func (o *GMAC_Type) SetGMAC_NCFGR_SPD(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_NCFGR_SPD() uint32 {
	return volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_NCFGR_FD(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_NCFGR_FD() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_NCFGR_DNVLAN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_NCFGR_DNVLAN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_NCFGR_JFRAME(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_NCFGR_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_NCFGR_CAF(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_NCFGR_CAF() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_NCFGR_NBC(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_NCFGR_NBC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_NCFGR_MTIHEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_NCFGR_MTIHEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_NCFGR_UNIHEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_NCFGR_UNIHEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_NCFGR_MAXFS(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetGMAC_NCFGR_MAXFS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetGMAC_NCFGR_RTY(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_NCFGR_RTY() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_NCFGR_PEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_NCFGR_PEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetGMAC_NCFGR_RXBUFO(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0xc000)|value<<14)
}
func (o *GMAC_Type) GetGMAC_NCFGR_RXBUFO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0xc000) >> 14
}
func (o *GMAC_Type) SetGMAC_NCFGR_LFERD(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_NCFGR_LFERD() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetGMAC_NCFGR_RFCS(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetGMAC_NCFGR_RFCS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetGMAC_NCFGR_CLK(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x1c0000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_NCFGR_CLK() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x1c0000) >> 18
}
func (o *GMAC_Type) SetGMAC_NCFGR_DBW(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x600000)|value<<21)
}
func (o *GMAC_Type) GetGMAC_NCFGR_DBW() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x600000) >> 21
}
func (o *GMAC_Type) SetGMAC_NCFGR_DCPF(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_NCFGR_DCPF() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetGMAC_NCFGR_RXCOEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_NCFGR_RXCOEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_NCFGR_EFRHD(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_NCFGR_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetGMAC_NCFGR_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetGMAC_NCFGR_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetGMAC_NCFGR_IPGSEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_NCFGR_IPGSEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_NCFGR_RXBP(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_NCFGR_RXBP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x20000000) >> 29
}
func (o *GMAC_Type) SetGMAC_NCFGR_IRXER(value uint32) {
	volatile.StoreUint32(&o.GMAC_NCFGR.Reg, volatile.LoadUint32(&o.GMAC_NCFGR.Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetGMAC_NCFGR_IRXER() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NCFGR.Reg) & 0x40000000) >> 30
}

// GMAC.GMAC_NSR: Network Status Register
func (o *GMAC_Type) SetGMAC_NSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.GMAC_NSR.Reg, volatile.LoadUint32(&o.GMAC_NSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_NSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_NSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.GMAC_NSR.Reg, volatile.LoadUint32(&o.GMAC_NSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_NSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_NSR_RXLPIS(value uint32) {
	volatile.StoreUint32(&o.GMAC_NSR.Reg, volatile.LoadUint32(&o.GMAC_NSR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_NSR_RXLPIS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_NSR.Reg) & 0x80) >> 7
}

// GMAC.GMAC_UR: User Register
func (o *GMAC_Type) SetGMAC_UR_RMII(value uint32) {
	volatile.StoreUint32(&o.GMAC_UR.Reg, volatile.LoadUint32(&o.GMAC_UR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_UR_RMII() uint32 {
	return volatile.LoadUint32(&o.GMAC_UR.Reg) & 0x1
}

// GMAC.GMAC_DCFGR: DMA Configuration Register
func (o *GMAC_Type) SetGMAC_DCFGR_FBLDO(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x1f)|value)
}
func (o *GMAC_Type) GetGMAC_DCFGR_FBLDO() uint32 {
	return volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x1f
}
func (o *GMAC_Type) SetGMAC_DCFGR_ESMA(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_DCFGR_ESMA() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_DCFGR_ESPA(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_DCFGR_ESPA() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_DCFGR_RXBMS(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x300)|value<<8)
}
func (o *GMAC_Type) GetGMAC_DCFGR_RXBMS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x300) >> 8
}
func (o *GMAC_Type) SetGMAC_DCFGR_TXPBMS(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_DCFGR_TXPBMS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_DCFGR_TXCOEN(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_DCFGR_TXCOEN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_DCFGR_DRBS(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_DCFGR_DRBS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0xff0000) >> 16
}
func (o *GMAC_Type) SetGMAC_DCFGR_DDRP(value uint32) {
	volatile.StoreUint32(&o.GMAC_DCFGR.Reg, volatile.LoadUint32(&o.GMAC_DCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_DCFGR_DDRP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_DCFGR.Reg) & 0x1000000) >> 24
}

// GMAC.GMAC_TSR: Transmit Status Register
func (o *GMAC_Type) SetGMAC_TSR_UBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_TSR_UBR() uint32 {
	return volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_TSR_COL(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_TSR_COL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_TSR_RLE(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_TSR_RLE() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_TSR_TXGO(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_TSR_TXGO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_TSR_TFC(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_TSR_TFC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_TSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_TSR_TXCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_TSR_HRESP(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSR.Reg, volatile.LoadUint32(&o.GMAC_TSR.Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetGMAC_TSR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TSR.Reg) & 0x100) >> 8
}

// GMAC.GMAC_RBQB: Receive Buffer Queue Base Address Register
func (o *GMAC_Type) SetGMAC_RBQB_ADDR(value uint32) {
	volatile.StoreUint32(&o.GMAC_RBQB.Reg, volatile.LoadUint32(&o.GMAC_RBQB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetGMAC_RBQB_ADDR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_RBQB.Reg) & 0xfffffffc) >> 2
}

// GMAC.GMAC_TBQB: Transmit Buffer Queue Base Address Register
func (o *GMAC_Type) SetGMAC_TBQB_ADDR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBQB.Reg, volatile.LoadUint32(&o.GMAC_TBQB.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetGMAC_TBQB_ADDR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TBQB.Reg) & 0xfffffffc) >> 2
}

// GMAC.GMAC_RSR: Receive Status Register
func (o *GMAC_Type) SetGMAC_RSR_BNA(value uint32) {
	volatile.StoreUint32(&o.GMAC_RSR.Reg, volatile.LoadUint32(&o.GMAC_RSR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_RSR_BNA() uint32 {
	return volatile.LoadUint32(&o.GMAC_RSR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_RSR_REC(value uint32) {
	volatile.StoreUint32(&o.GMAC_RSR.Reg, volatile.LoadUint32(&o.GMAC_RSR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_RSR_REC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_RSR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_RSR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_RSR.Reg, volatile.LoadUint32(&o.GMAC_RSR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_RSR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_RSR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_RSR_HNO(value uint32) {
	volatile.StoreUint32(&o.GMAC_RSR.Reg, volatile.LoadUint32(&o.GMAC_RSR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_RSR_HNO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_RSR.Reg) & 0x8) >> 3
}

// GMAC.GMAC_ISR: Interrupt Status Register
func (o *GMAC_Type) SetGMAC_ISR_MFS(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_ISR_MFS() uint32 {
	return volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_ISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_ISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_ISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_ISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_ISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_ISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_ISR_TUR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_ISR_TUR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_ISR_RLEX(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_ISR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_ISR_TFC(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_ISR_TFC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_ISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_ISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_ISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_ISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_ISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_ISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_ISR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_ISR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_ISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_ISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetGMAC_ISR_PFTR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetGMAC_ISR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetGMAC_ISR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_ISR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_ISR_SFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_ISR_SFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetGMAC_ISR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetGMAC_ISR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetGMAC_ISR_SFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetGMAC_ISR_SFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetGMAC_ISR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetGMAC_ISR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetGMAC_ISR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_ISR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetGMAC_ISR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_ISR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_ISR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_ISR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetGMAC_ISR_SRI(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetGMAC_ISR_SRI() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetGMAC_ISR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetGMAC_ISR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetGMAC_ISR_WOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_ISR_WOL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_ISR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_ISR.Reg, volatile.LoadUint32(&o.GMAC_ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_ISR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISR.Reg) & 0x20000000) >> 29
}

// GMAC.GMAC_IER: Interrupt Enable Register
func (o *GMAC_Type) SetGMAC_IER_MFS(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_IER_MFS() uint32 {
	return volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_IER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_IER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_IER_TUR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_IER_TUR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_IER_RLEX(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IER_RLEX() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IER_TFC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IER_TFC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IER_ROVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IER_HRESP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_IER_PFNZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_IER_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_IER_PTZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_IER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetGMAC_IER_PFTR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetGMAC_IER_PFTR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetGMAC_IER_EXINT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetGMAC_IER_EXINT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetGMAC_IER_DRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_IER_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_IER_SFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_IER_SFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetGMAC_IER_DRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetGMAC_IER_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetGMAC_IER_SFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetGMAC_IER_SFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetGMAC_IER_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetGMAC_IER_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetGMAC_IER_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_IER_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetGMAC_IER_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_IER_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_IER_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_IER_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetGMAC_IER_SRI(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetGMAC_IER_SRI() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetGMAC_IER_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetGMAC_IER_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetGMAC_IER_WOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_IER_WOL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_IER_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IER.Reg, volatile.LoadUint32(&o.GMAC_IER.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_IER_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IER.Reg) & 0x20000000) >> 29
}

// GMAC.GMAC_IDR: Interrupt Disable Register
func (o *GMAC_Type) SetGMAC_IDR_MFS(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_IDR_MFS() uint32 {
	return volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_IDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_IDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_IDR_TUR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_IDR_TUR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_IDR_RLEX(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IDR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IDR_TFC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IDR_TFC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_IDR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_IDR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_IDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_IDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetGMAC_IDR_PFTR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetGMAC_IDR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetGMAC_IDR_EXINT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetGMAC_IDR_EXINT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetGMAC_IDR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_IDR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_IDR_SFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_IDR_SFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetGMAC_IDR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetGMAC_IDR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetGMAC_IDR_SFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetGMAC_IDR_SFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetGMAC_IDR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetGMAC_IDR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetGMAC_IDR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_IDR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetGMAC_IDR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_IDR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_IDR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_IDR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetGMAC_IDR_SRI(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetGMAC_IDR_SRI() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetGMAC_IDR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetGMAC_IDR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetGMAC_IDR_WOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_IDR_WOL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_IDR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IDR.Reg, volatile.LoadUint32(&o.GMAC_IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_IDR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDR.Reg) & 0x20000000) >> 29
}

// GMAC.GMAC_IMR: Interrupt Mask Register
func (o *GMAC_Type) SetGMAC_IMR_MFS(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_IMR_MFS() uint32 {
	return volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_IMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *GMAC_Type) GetGMAC_IMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x8) >> 3
}
func (o *GMAC_Type) SetGMAC_IMR_TUR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x10)|value<<4)
}
func (o *GMAC_Type) GetGMAC_IMR_TUR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x10) >> 4
}
func (o *GMAC_Type) SetGMAC_IMR_RLEX(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IMR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IMR_TFC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IMR_TFC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x800) >> 11
}
func (o *GMAC_Type) SetGMAC_IMR_PFNZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_IMR_PFNZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_IMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x2000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_IMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x2000) >> 13
}
func (o *GMAC_Type) SetGMAC_IMR_PFTR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x4000)|value<<14)
}
func (o *GMAC_Type) GetGMAC_IMR_PFTR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x4000) >> 14
}
func (o *GMAC_Type) SetGMAC_IMR_EXINT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x8000)|value<<15)
}
func (o *GMAC_Type) GetGMAC_IMR_EXINT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x8000) >> 15
}
func (o *GMAC_Type) SetGMAC_IMR_DRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_IMR_DRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_IMR_SFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_IMR_SFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x80000) >> 19
}
func (o *GMAC_Type) SetGMAC_IMR_DRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x100000)|value<<20)
}
func (o *GMAC_Type) GetGMAC_IMR_DRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x100000) >> 20
}
func (o *GMAC_Type) SetGMAC_IMR_SFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x200000)|value<<21)
}
func (o *GMAC_Type) GetGMAC_IMR_SFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x200000) >> 21
}
func (o *GMAC_Type) SetGMAC_IMR_PDRQFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x400000)|value<<22)
}
func (o *GMAC_Type) GetGMAC_IMR_PDRQFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x400000) >> 22
}
func (o *GMAC_Type) SetGMAC_IMR_PDRSFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_IMR_PDRSFR() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x800000) >> 23
}
func (o *GMAC_Type) SetGMAC_IMR_PDRQFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_IMR_PDRQFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_IMR_PDRSFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_IMR_PDRSFT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x2000000) >> 25
}
func (o *GMAC_Type) SetGMAC_IMR_SRI(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *GMAC_Type) GetGMAC_IMR_SRI() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x4000000) >> 26
}
func (o *GMAC_Type) SetGMAC_IMR_RXLPISBC(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *GMAC_Type) GetGMAC_IMR_RXLPISBC() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x8000000) >> 27
}
func (o *GMAC_Type) SetGMAC_IMR_WOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_IMR_WOL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_IMR_TSUTIMCOMP(value uint32) {
	volatile.StoreUint32(&o.GMAC_IMR.Reg, volatile.LoadUint32(&o.GMAC_IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_IMR_TSUTIMCOMP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMR.Reg) & 0x20000000) >> 29
}

// GMAC.GMAC_MAN: PHY Maintenance Register
func (o *GMAC_Type) SetGMAC_MAN_DATA(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_MAN_DATA() uint32 {
	return volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_MAN_WTN(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0x30000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_MAN_WTN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0x30000) >> 16
}
func (o *GMAC_Type) SetGMAC_MAN_REGA(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_MAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0x7c0000) >> 18
}
func (o *GMAC_Type) SetGMAC_MAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *GMAC_Type) GetGMAC_MAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0xf800000) >> 23
}
func (o *GMAC_Type) SetGMAC_MAN_OP(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_MAN_OP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0x30000000) >> 28
}
func (o *GMAC_Type) SetGMAC_MAN_CLTTO(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetGMAC_MAN_CLTTO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0x40000000) >> 30
}
func (o *GMAC_Type) SetGMAC_MAN_WZO(value uint32) {
	volatile.StoreUint32(&o.GMAC_MAN.Reg, volatile.LoadUint32(&o.GMAC_MAN.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_MAN_WZO() uint32 {
	return (volatile.LoadUint32(&o.GMAC_MAN.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_RPQ: Received Pause Quantum Register
func (o *GMAC_Type) SetGMAC_RPQ_RPQ(value uint32) {
	volatile.StoreUint32(&o.GMAC_RPQ.Reg, volatile.LoadUint32(&o.GMAC_RPQ.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_RPQ_RPQ() uint32 {
	return volatile.LoadUint32(&o.GMAC_RPQ.Reg) & 0xffff
}

// GMAC.GMAC_TPQ: Transmit Pause Quantum Register
func (o *GMAC_Type) SetGMAC_TPQ_TPQ(value uint32) {
	volatile.StoreUint32(&o.GMAC_TPQ.Reg, volatile.LoadUint32(&o.GMAC_TPQ.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TPQ_TPQ() uint32 {
	return volatile.LoadUint32(&o.GMAC_TPQ.Reg) & 0xffff
}

// GMAC.GMAC_TPSF: TX Partial Store and Forward Register
func (o *GMAC_Type) SetGMAC_TPSF_TPB1ADR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TPSF.Reg, volatile.LoadUint32(&o.GMAC_TPSF.Reg)&^(0xfff)|value)
}
func (o *GMAC_Type) GetGMAC_TPSF_TPB1ADR() uint32 {
	return volatile.LoadUint32(&o.GMAC_TPSF.Reg) & 0xfff
}
func (o *GMAC_Type) SetGMAC_TPSF_ENTXP(value uint32) {
	volatile.StoreUint32(&o.GMAC_TPSF.Reg, volatile.LoadUint32(&o.GMAC_TPSF.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TPSF_ENTXP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TPSF.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_RPSF: RX Partial Store and Forward Register
func (o *GMAC_Type) SetGMAC_RPSF_RPB1ADR(value uint32) {
	volatile.StoreUint32(&o.GMAC_RPSF.Reg, volatile.LoadUint32(&o.GMAC_RPSF.Reg)&^(0xfff)|value)
}
func (o *GMAC_Type) GetGMAC_RPSF_RPB1ADR() uint32 {
	return volatile.LoadUint32(&o.GMAC_RPSF.Reg) & 0xfff
}
func (o *GMAC_Type) SetGMAC_RPSF_ENRXP(value uint32) {
	volatile.StoreUint32(&o.GMAC_RPSF.Reg, volatile.LoadUint32(&o.GMAC_RPSF.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_RPSF_ENRXP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_RPSF.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_RJFML: RX Jumbo Frame Max Length Register
func (o *GMAC_Type) SetGMAC_RJFML_FML(value uint32) {
	volatile.StoreUint32(&o.GMAC_RJFML.Reg, volatile.LoadUint32(&o.GMAC_RJFML.Reg)&^(0x3fff)|value)
}
func (o *GMAC_Type) GetGMAC_RJFML_FML() uint32 {
	return volatile.LoadUint32(&o.GMAC_RJFML.Reg) & 0x3fff
}

// GMAC.GMAC_HRB: Hash Register Bottom
func (o *GMAC_Type) SetGMAC_HRB(value uint32) {
	volatile.StoreUint32(&o.GMAC_HRB.Reg, value)
}
func (o *GMAC_Type) GetGMAC_HRB() uint32 {
	return volatile.LoadUint32(&o.GMAC_HRB.Reg)
}

// GMAC.GMAC_HRT: Hash Register Top
func (o *GMAC_Type) SetGMAC_HRT(value uint32) {
	volatile.StoreUint32(&o.GMAC_HRT.Reg, value)
}
func (o *GMAC_Type) GetGMAC_HRT() uint32 {
	return volatile.LoadUint32(&o.GMAC_HRT.Reg)
}

// GMAC.GMAC_TIDM1: Type ID Match 1 Register
func (o *GMAC_Type) SetGMAC_TIDM1_TID(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM1.Reg, volatile.LoadUint32(&o.GMAC_TIDM1.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TIDM1_TID() uint32 {
	return volatile.LoadUint32(&o.GMAC_TIDM1.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_TIDM1_ENID1(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM1.Reg, volatile.LoadUint32(&o.GMAC_TIDM1.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TIDM1_ENID1() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TIDM1.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_TIDM2: Type ID Match 2 Register
func (o *GMAC_Type) SetGMAC_TIDM2_TID(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM2.Reg, volatile.LoadUint32(&o.GMAC_TIDM2.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TIDM2_TID() uint32 {
	return volatile.LoadUint32(&o.GMAC_TIDM2.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_TIDM2_ENID2(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM2.Reg, volatile.LoadUint32(&o.GMAC_TIDM2.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TIDM2_ENID2() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TIDM2.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_TIDM3: Type ID Match 3 Register
func (o *GMAC_Type) SetGMAC_TIDM3_TID(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM3.Reg, volatile.LoadUint32(&o.GMAC_TIDM3.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TIDM3_TID() uint32 {
	return volatile.LoadUint32(&o.GMAC_TIDM3.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_TIDM3_ENID3(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM3.Reg, volatile.LoadUint32(&o.GMAC_TIDM3.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TIDM3_ENID3() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TIDM3.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_TIDM4: Type ID Match 4 Register
func (o *GMAC_Type) SetGMAC_TIDM4_TID(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM4.Reg, volatile.LoadUint32(&o.GMAC_TIDM4.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TIDM4_TID() uint32 {
	return volatile.LoadUint32(&o.GMAC_TIDM4.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_TIDM4_ENID4(value uint32) {
	volatile.StoreUint32(&o.GMAC_TIDM4.Reg, volatile.LoadUint32(&o.GMAC_TIDM4.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TIDM4_ENID4() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TIDM4.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_WOL: Wake on LAN Register
func (o *GMAC_Type) SetGMAC_WOL_IP(value uint32) {
	volatile.StoreUint32(&o.GMAC_WOL.Reg, volatile.LoadUint32(&o.GMAC_WOL.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_WOL_IP() uint32 {
	return volatile.LoadUint32(&o.GMAC_WOL.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_WOL_MAG(value uint32) {
	volatile.StoreUint32(&o.GMAC_WOL.Reg, volatile.LoadUint32(&o.GMAC_WOL.Reg)&^(0x10000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_WOL_MAG() uint32 {
	return (volatile.LoadUint32(&o.GMAC_WOL.Reg) & 0x10000) >> 16
}
func (o *GMAC_Type) SetGMAC_WOL_ARP(value uint32) {
	volatile.StoreUint32(&o.GMAC_WOL.Reg, volatile.LoadUint32(&o.GMAC_WOL.Reg)&^(0x20000)|value<<17)
}
func (o *GMAC_Type) GetGMAC_WOL_ARP() uint32 {
	return (volatile.LoadUint32(&o.GMAC_WOL.Reg) & 0x20000) >> 17
}
func (o *GMAC_Type) SetGMAC_WOL_SA1(value uint32) {
	volatile.StoreUint32(&o.GMAC_WOL.Reg, volatile.LoadUint32(&o.GMAC_WOL.Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_WOL_SA1() uint32 {
	return (volatile.LoadUint32(&o.GMAC_WOL.Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_WOL_MTI(value uint32) {
	volatile.StoreUint32(&o.GMAC_WOL.Reg, volatile.LoadUint32(&o.GMAC_WOL.Reg)&^(0x80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_WOL_MTI() uint32 {
	return (volatile.LoadUint32(&o.GMAC_WOL.Reg) & 0x80000) >> 19
}

// GMAC.GMAC_IPGS: IPG Stretch Register
func (o *GMAC_Type) SetGMAC_IPGS_FL(value uint32) {
	volatile.StoreUint32(&o.GMAC_IPGS.Reg, volatile.LoadUint32(&o.GMAC_IPGS.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_IPGS_FL() uint32 {
	return volatile.LoadUint32(&o.GMAC_IPGS.Reg) & 0xffff
}

// GMAC.GMAC_SVLAN: Stacked VLAN Register
func (o *GMAC_Type) SetGMAC_SVLAN_VLAN_TYPE(value uint32) {
	volatile.StoreUint32(&o.GMAC_SVLAN.Reg, volatile.LoadUint32(&o.GMAC_SVLAN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_SVLAN_VLAN_TYPE() uint32 {
	return volatile.LoadUint32(&o.GMAC_SVLAN.Reg) & 0xffff
}
func (o *GMAC_Type) SetGMAC_SVLAN_ESVLAN(value uint32) {
	volatile.StoreUint32(&o.GMAC_SVLAN.Reg, volatile.LoadUint32(&o.GMAC_SVLAN.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_SVLAN_ESVLAN() uint32 {
	return (volatile.LoadUint32(&o.GMAC_SVLAN.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_TPFCP: Transmit PFC Pause Register
func (o *GMAC_Type) SetGMAC_TPFCP_PEV(value uint32) {
	volatile.StoreUint32(&o.GMAC_TPFCP.Reg, volatile.LoadUint32(&o.GMAC_TPFCP.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetGMAC_TPFCP_PEV() uint32 {
	return volatile.LoadUint32(&o.GMAC_TPFCP.Reg) & 0xff
}
func (o *GMAC_Type) SetGMAC_TPFCP_PQ(value uint32) {
	volatile.StoreUint32(&o.GMAC_TPFCP.Reg, volatile.LoadUint32(&o.GMAC_TPFCP.Reg)&^(0xff00)|value<<8)
}
func (o *GMAC_Type) GetGMAC_TPFCP_PQ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TPFCP.Reg) & 0xff00) >> 8
}

// GMAC.GMAC_SAMB1: Specific Address 1 Mask Bottom Register
func (o *GMAC_Type) SetGMAC_SAMB1(value uint32) {
	volatile.StoreUint32(&o.GMAC_SAMB1.Reg, value)
}
func (o *GMAC_Type) GetGMAC_SAMB1() uint32 {
	return volatile.LoadUint32(&o.GMAC_SAMB1.Reg)
}

// GMAC.GMAC_SAMT1: Specific Address 1 Mask Top Register
func (o *GMAC_Type) SetGMAC_SAMT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.GMAC_SAMT1.Reg, volatile.LoadUint32(&o.GMAC_SAMT1.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_SAMT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.GMAC_SAMT1.Reg) & 0xffff
}

// GMAC.GMAC_NSC: 1588 Timer Nanosecond Comparison Register
func (o *GMAC_Type) SetGMAC_NSC_NANOSEC(value uint32) {
	volatile.StoreUint32(&o.GMAC_NSC.Reg, volatile.LoadUint32(&o.GMAC_NSC.Reg)&^(0x3fffff)|value)
}
func (o *GMAC_Type) GetGMAC_NSC_NANOSEC() uint32 {
	return volatile.LoadUint32(&o.GMAC_NSC.Reg) & 0x3fffff
}

// GMAC.GMAC_SCL: 1588 Timer Second Comparison Low Register
func (o *GMAC_Type) SetGMAC_SCL(value uint32) {
	volatile.StoreUint32(&o.GMAC_SCL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_SCL() uint32 {
	return volatile.LoadUint32(&o.GMAC_SCL.Reg)
}

// GMAC.GMAC_SCH: 1588 Timer Second Comparison High Register
func (o *GMAC_Type) SetGMAC_SCH_SEC(value uint32) {
	volatile.StoreUint32(&o.GMAC_SCH.Reg, volatile.LoadUint32(&o.GMAC_SCH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_SCH_SEC() uint32 {
	return volatile.LoadUint32(&o.GMAC_SCH.Reg) & 0xffff
}

// GMAC.GMAC_EFTSH: PTP Event Frame Transmitted Seconds High Register
func (o *GMAC_Type) SetGMAC_EFTSH_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFTSH.Reg, volatile.LoadUint32(&o.GMAC_EFTSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_EFTSH_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFTSH.Reg) & 0xffff
}

// GMAC.GMAC_EFRSH: PTP Event Frame Received Seconds High Register
func (o *GMAC_Type) SetGMAC_EFRSH_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFRSH.Reg, volatile.LoadUint32(&o.GMAC_EFRSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_EFRSH_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFRSH.Reg) & 0xffff
}

// GMAC.GMAC_PEFTSH: PTP Peer Event Frame Transmitted Seconds High Register
func (o *GMAC_Type) SetGMAC_PEFTSH_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFTSH.Reg, volatile.LoadUint32(&o.GMAC_PEFTSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_PEFTSH_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFTSH.Reg) & 0xffff
}

// GMAC.GMAC_PEFRSH: PTP Peer Event Frame Received Seconds High Register
func (o *GMAC_Type) SetGMAC_PEFRSH_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFRSH.Reg, volatile.LoadUint32(&o.GMAC_PEFRSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_PEFRSH_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFRSH.Reg) & 0xffff
}

// GMAC.GMAC_OTLO: Octets Transmitted Low Register
func (o *GMAC_Type) SetGMAC_OTLO(value uint32) {
	volatile.StoreUint32(&o.GMAC_OTLO.Reg, value)
}
func (o *GMAC_Type) GetGMAC_OTLO() uint32 {
	return volatile.LoadUint32(&o.GMAC_OTLO.Reg)
}

// GMAC.GMAC_OTHI: Octets Transmitted High Register
func (o *GMAC_Type) SetGMAC_OTHI_TXO(value uint32) {
	volatile.StoreUint32(&o.GMAC_OTHI.Reg, volatile.LoadUint32(&o.GMAC_OTHI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_OTHI_TXO() uint32 {
	return volatile.LoadUint32(&o.GMAC_OTHI.Reg) & 0xffff
}

// GMAC.GMAC_FT: Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_FT(value uint32) {
	volatile.StoreUint32(&o.GMAC_FT.Reg, value)
}
func (o *GMAC_Type) GetGMAC_FT() uint32 {
	return volatile.LoadUint32(&o.GMAC_FT.Reg)
}

// GMAC.GMAC_BCFT: Broadcast Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_BCFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_BCFT.Reg, value)
}
func (o *GMAC_Type) GetGMAC_BCFT() uint32 {
	return volatile.LoadUint32(&o.GMAC_BCFT.Reg)
}

// GMAC.GMAC_MFT: Multicast Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_MFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_MFT.Reg, value)
}
func (o *GMAC_Type) GetGMAC_MFT() uint32 {
	return volatile.LoadUint32(&o.GMAC_MFT.Reg)
}

// GMAC.GMAC_PFT: Pause Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_PFT_PFTX(value uint32) {
	volatile.StoreUint32(&o.GMAC_PFT.Reg, volatile.LoadUint32(&o.GMAC_PFT.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_PFT_PFTX() uint32 {
	return volatile.LoadUint32(&o.GMAC_PFT.Reg) & 0xffff
}

// GMAC.GMAC_BFT64: 64 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_BFT64(value uint32) {
	volatile.StoreUint32(&o.GMAC_BFT64.Reg, value)
}
func (o *GMAC_Type) GetGMAC_BFT64() uint32 {
	return volatile.LoadUint32(&o.GMAC_BFT64.Reg)
}

// GMAC.GMAC_TBFT127: 65 to 127 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_TBFT127(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFT127.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFT127() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFT127.Reg)
}

// GMAC.GMAC_TBFT255: 128 to 255 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_TBFT255(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFT255.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFT255() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFT255.Reg)
}

// GMAC.GMAC_TBFT511: 256 to 511 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_TBFT511(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFT511.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFT511() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFT511.Reg)
}

// GMAC.GMAC_TBFT1023: 512 to 1023 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_TBFT1023(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFT1023.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFT1023() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFT1023.Reg)
}

// GMAC.GMAC_TBFT1518: 1024 to 1518 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_TBFT1518(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFT1518.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFT1518() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFT1518.Reg)
}

// GMAC.GMAC_GTBFT1518: Greater Than 1518 Byte Frames Transmitted Register
func (o *GMAC_Type) SetGMAC_GTBFT1518(value uint32) {
	volatile.StoreUint32(&o.GMAC_GTBFT1518.Reg, value)
}
func (o *GMAC_Type) GetGMAC_GTBFT1518() uint32 {
	return volatile.LoadUint32(&o.GMAC_GTBFT1518.Reg)
}

// GMAC.GMAC_TUR: Transmit Underruns Register
func (o *GMAC_Type) SetGMAC_TUR_TXUNR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TUR.Reg, volatile.LoadUint32(&o.GMAC_TUR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_TUR_TXUNR() uint32 {
	return volatile.LoadUint32(&o.GMAC_TUR.Reg) & 0x3ff
}

// GMAC.GMAC_SCF: Single Collision Frames Register
func (o *GMAC_Type) SetGMAC_SCF_SCOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_SCF.Reg, volatile.LoadUint32(&o.GMAC_SCF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetGMAC_SCF_SCOL() uint32 {
	return volatile.LoadUint32(&o.GMAC_SCF.Reg) & 0x3ffff
}

// GMAC.GMAC_MCF: Multiple Collision Frames Register
func (o *GMAC_Type) SetGMAC_MCF_MCOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_MCF.Reg, volatile.LoadUint32(&o.GMAC_MCF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetGMAC_MCF_MCOL() uint32 {
	return volatile.LoadUint32(&o.GMAC_MCF.Reg) & 0x3ffff
}

// GMAC.GMAC_EC: Excessive Collisions Register
func (o *GMAC_Type) SetGMAC_EC_XCOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_EC.Reg, volatile.LoadUint32(&o.GMAC_EC.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_EC_XCOL() uint32 {
	return volatile.LoadUint32(&o.GMAC_EC.Reg) & 0x3ff
}

// GMAC.GMAC_LC: Late Collisions Register
func (o *GMAC_Type) SetGMAC_LC_LCOL(value uint32) {
	volatile.StoreUint32(&o.GMAC_LC.Reg, volatile.LoadUint32(&o.GMAC_LC.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_LC_LCOL() uint32 {
	return volatile.LoadUint32(&o.GMAC_LC.Reg) & 0x3ff
}

// GMAC.GMAC_DTF: Deferred Transmission Frames Register
func (o *GMAC_Type) SetGMAC_DTF_DEFT(value uint32) {
	volatile.StoreUint32(&o.GMAC_DTF.Reg, volatile.LoadUint32(&o.GMAC_DTF.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetGMAC_DTF_DEFT() uint32 {
	return volatile.LoadUint32(&o.GMAC_DTF.Reg) & 0x3ffff
}

// GMAC.GMAC_CSE: Carrier Sense Errors Register
func (o *GMAC_Type) SetGMAC_CSE_CSR(value uint32) {
	volatile.StoreUint32(&o.GMAC_CSE.Reg, volatile.LoadUint32(&o.GMAC_CSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_CSE_CSR() uint32 {
	return volatile.LoadUint32(&o.GMAC_CSE.Reg) & 0x3ff
}

// GMAC.GMAC_ORLO: Octets Received Low Received Register
func (o *GMAC_Type) SetGMAC_ORLO(value uint32) {
	volatile.StoreUint32(&o.GMAC_ORLO.Reg, value)
}
func (o *GMAC_Type) GetGMAC_ORLO() uint32 {
	return volatile.LoadUint32(&o.GMAC_ORLO.Reg)
}

// GMAC.GMAC_ORHI: Octets Received High Received Register
func (o *GMAC_Type) SetGMAC_ORHI_RXO(value uint32) {
	volatile.StoreUint32(&o.GMAC_ORHI.Reg, volatile.LoadUint32(&o.GMAC_ORHI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_ORHI_RXO() uint32 {
	return volatile.LoadUint32(&o.GMAC_ORHI.Reg) & 0xffff
}

// GMAC.GMAC_FR: Frames Received Register
func (o *GMAC_Type) SetGMAC_FR(value uint32) {
	volatile.StoreUint32(&o.GMAC_FR.Reg, value)
}
func (o *GMAC_Type) GetGMAC_FR() uint32 {
	return volatile.LoadUint32(&o.GMAC_FR.Reg)
}

// GMAC.GMAC_BCFR: Broadcast Frames Received Register
func (o *GMAC_Type) SetGMAC_BCFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_BCFR.Reg, value)
}
func (o *GMAC_Type) GetGMAC_BCFR() uint32 {
	return volatile.LoadUint32(&o.GMAC_BCFR.Reg)
}

// GMAC.GMAC_MFR: Multicast Frames Received Register
func (o *GMAC_Type) SetGMAC_MFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_MFR.Reg, value)
}
func (o *GMAC_Type) GetGMAC_MFR() uint32 {
	return volatile.LoadUint32(&o.GMAC_MFR.Reg)
}

// GMAC.GMAC_PFR: Pause Frames Received Register
func (o *GMAC_Type) SetGMAC_PFR_PFRX(value uint32) {
	volatile.StoreUint32(&o.GMAC_PFR.Reg, volatile.LoadUint32(&o.GMAC_PFR.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_PFR_PFRX() uint32 {
	return volatile.LoadUint32(&o.GMAC_PFR.Reg) & 0xffff
}

// GMAC.GMAC_BFR64: 64 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_BFR64(value uint32) {
	volatile.StoreUint32(&o.GMAC_BFR64.Reg, value)
}
func (o *GMAC_Type) GetGMAC_BFR64() uint32 {
	return volatile.LoadUint32(&o.GMAC_BFR64.Reg)
}

// GMAC.GMAC_TBFR127: 65 to 127 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TBFR127(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFR127.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFR127() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFR127.Reg)
}

// GMAC.GMAC_TBFR255: 128 to 255 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TBFR255(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFR255.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFR255() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFR255.Reg)
}

// GMAC.GMAC_TBFR511: 256 to 511 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TBFR511(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFR511.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFR511() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFR511.Reg)
}

// GMAC.GMAC_TBFR1023: 512 to 1023 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TBFR1023(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFR1023.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFR1023() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFR1023.Reg)
}

// GMAC.GMAC_TBFR1518: 1024 to 1518 Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TBFR1518(value uint32) {
	volatile.StoreUint32(&o.GMAC_TBFR1518.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TBFR1518() uint32 {
	return volatile.LoadUint32(&o.GMAC_TBFR1518.Reg)
}

// GMAC.GMAC_TMXBFR: 1519 to Maximum Byte Frames Received Register
func (o *GMAC_Type) SetGMAC_TMXBFR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TMXBFR.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TMXBFR() uint32 {
	return volatile.LoadUint32(&o.GMAC_TMXBFR.Reg)
}

// GMAC.GMAC_UFR: Undersize Frames Received Register
func (o *GMAC_Type) SetGMAC_UFR_UFRX(value uint32) {
	volatile.StoreUint32(&o.GMAC_UFR.Reg, volatile.LoadUint32(&o.GMAC_UFR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_UFR_UFRX() uint32 {
	return volatile.LoadUint32(&o.GMAC_UFR.Reg) & 0x3ff
}

// GMAC.GMAC_OFR: Oversize Frames Received Register
func (o *GMAC_Type) SetGMAC_OFR_OFRX(value uint32) {
	volatile.StoreUint32(&o.GMAC_OFR.Reg, volatile.LoadUint32(&o.GMAC_OFR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_OFR_OFRX() uint32 {
	return volatile.LoadUint32(&o.GMAC_OFR.Reg) & 0x3ff
}

// GMAC.GMAC_JR: Jabbers Received Register
func (o *GMAC_Type) SetGMAC_JR_JRX(value uint32) {
	volatile.StoreUint32(&o.GMAC_JR.Reg, volatile.LoadUint32(&o.GMAC_JR.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_JR_JRX() uint32 {
	return volatile.LoadUint32(&o.GMAC_JR.Reg) & 0x3ff
}

// GMAC.GMAC_FCSE: Frame Check Sequence Errors Register
func (o *GMAC_Type) SetGMAC_FCSE_FCKR(value uint32) {
	volatile.StoreUint32(&o.GMAC_FCSE.Reg, volatile.LoadUint32(&o.GMAC_FCSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_FCSE_FCKR() uint32 {
	return volatile.LoadUint32(&o.GMAC_FCSE.Reg) & 0x3ff
}

// GMAC.GMAC_LFFE: Length Field Frame Errors Register
func (o *GMAC_Type) SetGMAC_LFFE_LFER(value uint32) {
	volatile.StoreUint32(&o.GMAC_LFFE.Reg, volatile.LoadUint32(&o.GMAC_LFFE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_LFFE_LFER() uint32 {
	return volatile.LoadUint32(&o.GMAC_LFFE.Reg) & 0x3ff
}

// GMAC.GMAC_RSE: Receive Symbol Errors Register
func (o *GMAC_Type) SetGMAC_RSE_RXSE(value uint32) {
	volatile.StoreUint32(&o.GMAC_RSE.Reg, volatile.LoadUint32(&o.GMAC_RSE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_RSE_RXSE() uint32 {
	return volatile.LoadUint32(&o.GMAC_RSE.Reg) & 0x3ff
}

// GMAC.GMAC_AE: Alignment Errors Register
func (o *GMAC_Type) SetGMAC_AE_AER(value uint32) {
	volatile.StoreUint32(&o.GMAC_AE.Reg, volatile.LoadUint32(&o.GMAC_AE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_AE_AER() uint32 {
	return volatile.LoadUint32(&o.GMAC_AE.Reg) & 0x3ff
}

// GMAC.GMAC_RRE: Receive Resource Errors Register
func (o *GMAC_Type) SetGMAC_RRE_RXRER(value uint32) {
	volatile.StoreUint32(&o.GMAC_RRE.Reg, volatile.LoadUint32(&o.GMAC_RRE.Reg)&^(0x3ffff)|value)
}
func (o *GMAC_Type) GetGMAC_RRE_RXRER() uint32 {
	return volatile.LoadUint32(&o.GMAC_RRE.Reg) & 0x3ffff
}

// GMAC.GMAC_ROE: Receive Overrun Register
func (o *GMAC_Type) SetGMAC_ROE_RXOVR(value uint32) {
	volatile.StoreUint32(&o.GMAC_ROE.Reg, volatile.LoadUint32(&o.GMAC_ROE.Reg)&^(0x3ff)|value)
}
func (o *GMAC_Type) GetGMAC_ROE_RXOVR() uint32 {
	return volatile.LoadUint32(&o.GMAC_ROE.Reg) & 0x3ff
}

// GMAC.GMAC_IHCE: IP Header Checksum Errors Register
func (o *GMAC_Type) SetGMAC_IHCE_HCKER(value uint32) {
	volatile.StoreUint32(&o.GMAC_IHCE.Reg, volatile.LoadUint32(&o.GMAC_IHCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetGMAC_IHCE_HCKER() uint32 {
	return volatile.LoadUint32(&o.GMAC_IHCE.Reg) & 0xff
}

// GMAC.GMAC_TCE: TCP Checksum Errors Register
func (o *GMAC_Type) SetGMAC_TCE_TCKER(value uint32) {
	volatile.StoreUint32(&o.GMAC_TCE.Reg, volatile.LoadUint32(&o.GMAC_TCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetGMAC_TCE_TCKER() uint32 {
	return volatile.LoadUint32(&o.GMAC_TCE.Reg) & 0xff
}

// GMAC.GMAC_UCE: UDP Checksum Errors Register
func (o *GMAC_Type) SetGMAC_UCE_UCKER(value uint32) {
	volatile.StoreUint32(&o.GMAC_UCE.Reg, volatile.LoadUint32(&o.GMAC_UCE.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetGMAC_UCE_UCKER() uint32 {
	return volatile.LoadUint32(&o.GMAC_UCE.Reg) & 0xff
}

// GMAC.GMAC_TISUBN: 1588 Timer Increment Sub-nanoseconds Register
func (o *GMAC_Type) SetGMAC_TISUBN_LSBTIR(value uint32) {
	volatile.StoreUint32(&o.GMAC_TISUBN.Reg, volatile.LoadUint32(&o.GMAC_TISUBN.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TISUBN_LSBTIR() uint32 {
	return volatile.LoadUint32(&o.GMAC_TISUBN.Reg) & 0xffff
}

// GMAC.GMAC_TSH: 1588 Timer Seconds High Register
func (o *GMAC_Type) SetGMAC_TSH_TCS(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSH.Reg, volatile.LoadUint32(&o.GMAC_TSH.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TSH_TCS() uint32 {
	return volatile.LoadUint32(&o.GMAC_TSH.Reg) & 0xffff
}

// GMAC.GMAC_TSL: 1588 Timer Seconds Low Register
func (o *GMAC_Type) SetGMAC_TSL(value uint32) {
	volatile.StoreUint32(&o.GMAC_TSL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_TSL() uint32 {
	return volatile.LoadUint32(&o.GMAC_TSL.Reg)
}

// GMAC.GMAC_TN: 1588 Timer Nanoseconds Register
func (o *GMAC_Type) SetGMAC_TN_TNS(value uint32) {
	volatile.StoreUint32(&o.GMAC_TN.Reg, volatile.LoadUint32(&o.GMAC_TN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_TN_TNS() uint32 {
	return volatile.LoadUint32(&o.GMAC_TN.Reg) & 0x3fffffff
}

// GMAC.GMAC_TA: 1588 Timer Adjust Register
func (o *GMAC_Type) SetGMAC_TA_ITDT(value uint32) {
	volatile.StoreUint32(&o.GMAC_TA.Reg, volatile.LoadUint32(&o.GMAC_TA.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_TA_ITDT() uint32 {
	return volatile.LoadUint32(&o.GMAC_TA.Reg) & 0x3fffffff
}
func (o *GMAC_Type) SetGMAC_TA_ADJ(value uint32) {
	volatile.StoreUint32(&o.GMAC_TA.Reg, volatile.LoadUint32(&o.GMAC_TA.Reg)&^(0x80000000)|value<<31)
}
func (o *GMAC_Type) GetGMAC_TA_ADJ() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TA.Reg) & 0x80000000) >> 31
}

// GMAC.GMAC_TI: 1588 Timer Increment Register
func (o *GMAC_Type) SetGMAC_TI_CNS(value uint32) {
	volatile.StoreUint32(&o.GMAC_TI.Reg, volatile.LoadUint32(&o.GMAC_TI.Reg)&^(0xff)|value)
}
func (o *GMAC_Type) GetGMAC_TI_CNS() uint32 {
	return volatile.LoadUint32(&o.GMAC_TI.Reg) & 0xff
}
func (o *GMAC_Type) SetGMAC_TI_ACNS(value uint32) {
	volatile.StoreUint32(&o.GMAC_TI.Reg, volatile.LoadUint32(&o.GMAC_TI.Reg)&^(0xff00)|value<<8)
}
func (o *GMAC_Type) GetGMAC_TI_ACNS() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TI.Reg) & 0xff00) >> 8
}
func (o *GMAC_Type) SetGMAC_TI_NIT(value uint32) {
	volatile.StoreUint32(&o.GMAC_TI.Reg, volatile.LoadUint32(&o.GMAC_TI.Reg)&^(0xff0000)|value<<16)
}
func (o *GMAC_Type) GetGMAC_TI_NIT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_TI.Reg) & 0xff0000) >> 16
}

// GMAC.GMAC_EFTSL: PTP Event Frame Transmitted Seconds Low Register
func (o *GMAC_Type) SetGMAC_EFTSL(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFTSL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_EFTSL() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFTSL.Reg)
}

// GMAC.GMAC_EFTN: PTP Event Frame Transmitted Nanoseconds Register
func (o *GMAC_Type) SetGMAC_EFTN_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFTN.Reg, volatile.LoadUint32(&o.GMAC_EFTN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_EFTN_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFTN.Reg) & 0x3fffffff
}

// GMAC.GMAC_EFRSL: PTP Event Frame Received Seconds Low Register
func (o *GMAC_Type) SetGMAC_EFRSL(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFRSL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_EFRSL() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFRSL.Reg)
}

// GMAC.GMAC_EFRN: PTP Event Frame Received Nanoseconds Register
func (o *GMAC_Type) SetGMAC_EFRN_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_EFRN.Reg, volatile.LoadUint32(&o.GMAC_EFRN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_EFRN_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_EFRN.Reg) & 0x3fffffff
}

// GMAC.GMAC_PEFTSL: PTP Peer Event Frame Transmitted Seconds Low Register
func (o *GMAC_Type) SetGMAC_PEFTSL(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFTSL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_PEFTSL() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFTSL.Reg)
}

// GMAC.GMAC_PEFTN: PTP Peer Event Frame Transmitted Nanoseconds Register
func (o *GMAC_Type) SetGMAC_PEFTN_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFTN.Reg, volatile.LoadUint32(&o.GMAC_PEFTN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_PEFTN_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFTN.Reg) & 0x3fffffff
}

// GMAC.GMAC_PEFRSL: PTP Peer Event Frame Received Seconds Low Register
func (o *GMAC_Type) SetGMAC_PEFRSL(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFRSL.Reg, value)
}
func (o *GMAC_Type) GetGMAC_PEFRSL() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFRSL.Reg)
}

// GMAC.GMAC_PEFRN: PTP Peer Event Frame Received Nanoseconds Register
func (o *GMAC_Type) SetGMAC_PEFRN_RUD(value uint32) {
	volatile.StoreUint32(&o.GMAC_PEFRN.Reg, volatile.LoadUint32(&o.GMAC_PEFRN.Reg)&^(0x3fffffff)|value)
}
func (o *GMAC_Type) GetGMAC_PEFRN_RUD() uint32 {
	return volatile.LoadUint32(&o.GMAC_PEFRN.Reg) & 0x3fffffff
}

// GMAC.GMAC_RXLPI: Received LPI Transitions
func (o *GMAC_Type) SetGMAC_RXLPI_COUNT(value uint32) {
	volatile.StoreUint32(&o.GMAC_RXLPI.Reg, volatile.LoadUint32(&o.GMAC_RXLPI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_RXLPI_COUNT() uint32 {
	return volatile.LoadUint32(&o.GMAC_RXLPI.Reg) & 0xffff
}

// GMAC.GMAC_RXLPITIME: Received LPI Time
func (o *GMAC_Type) SetGMAC_RXLPITIME_LPITIME(value uint32) {
	volatile.StoreUint32(&o.GMAC_RXLPITIME.Reg, volatile.LoadUint32(&o.GMAC_RXLPITIME.Reg)&^(0xffffff)|value)
}
func (o *GMAC_Type) GetGMAC_RXLPITIME_LPITIME() uint32 {
	return volatile.LoadUint32(&o.GMAC_RXLPITIME.Reg) & 0xffffff
}

// GMAC.GMAC_TXLPI: Transmit LPI Transitions
func (o *GMAC_Type) SetGMAC_TXLPI_COUNT(value uint32) {
	volatile.StoreUint32(&o.GMAC_TXLPI.Reg, volatile.LoadUint32(&o.GMAC_TXLPI.Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_TXLPI_COUNT() uint32 {
	return volatile.LoadUint32(&o.GMAC_TXLPI.Reg) & 0xffff
}

// GMAC.GMAC_TXLPITIME: Transmit LPI Time
func (o *GMAC_Type) SetGMAC_TXLPITIME_LPITIME(value uint32) {
	volatile.StoreUint32(&o.GMAC_TXLPITIME.Reg, volatile.LoadUint32(&o.GMAC_TXLPITIME.Reg)&^(0xffffff)|value)
}
func (o *GMAC_Type) GetGMAC_TXLPITIME_LPITIME() uint32 {
	return volatile.LoadUint32(&o.GMAC_TXLPITIME.Reg) & 0xffffff
}

// GMAC.GMAC_ISRPQ: Interrupt Status Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_ISRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_ISRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_ISRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_ISRPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_ISRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_ISRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_ISRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ISRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_ISRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ISRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.GMAC_TBQBAPQ: Transmit Buffer Queue Base Address Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_TBQBAPQ_TXBQBA(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_TBQBAPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_TBQBAPQ[idx].Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetGMAC_TBQBAPQ_TXBQBA(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_TBQBAPQ[idx].Reg) & 0xfffffffc) >> 2
}

// GMAC.GMAC_RBQBAPQ: Receive Buffer Queue Base Address Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_RBQBAPQ_RXBQBA(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_RBQBAPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_RBQBAPQ[idx].Reg)&^(0xfffffffc)|value<<2)
}
func (o *GMAC_Type) GetGMAC_RBQBAPQ_RXBQBA(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_RBQBAPQ[idx].Reg) & 0xfffffffc) >> 2
}

// GMAC.GMAC_RBSRPQ: Receive Buffer Size Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_RBSRPQ_RBS(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_RBSRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_RBSRPQ[idx].Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_RBSRPQ_RBS(idx int) uint32 {
	return volatile.LoadUint32(&o.GMAC_RBSRPQ[idx].Reg) & 0xffff
}

// GMAC.GMAC_CBSCR: Credit-Based Shaping Control Register
func (o *GMAC_Type) SetGMAC_CBSCR_QBE(value uint32) {
	volatile.StoreUint32(&o.GMAC_CBSCR.Reg, volatile.LoadUint32(&o.GMAC_CBSCR.Reg)&^(0x1)|value)
}
func (o *GMAC_Type) GetGMAC_CBSCR_QBE() uint32 {
	return volatile.LoadUint32(&o.GMAC_CBSCR.Reg) & 0x1
}
func (o *GMAC_Type) SetGMAC_CBSCR_QAE(value uint32) {
	volatile.StoreUint32(&o.GMAC_CBSCR.Reg, volatile.LoadUint32(&o.GMAC_CBSCR.Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_CBSCR_QAE() uint32 {
	return (volatile.LoadUint32(&o.GMAC_CBSCR.Reg) & 0x2) >> 1
}

// GMAC.GMAC_CBSISQA: Credit-Based Shaping IdleSlope Register for Queue A
func (o *GMAC_Type) SetGMAC_CBSISQA(value uint32) {
	volatile.StoreUint32(&o.GMAC_CBSISQA.Reg, value)
}
func (o *GMAC_Type) GetGMAC_CBSISQA() uint32 {
	return volatile.LoadUint32(&o.GMAC_CBSISQA.Reg)
}

// GMAC.GMAC_CBSISQB: Credit-Based Shaping IdleSlope Register for Queue B
func (o *GMAC_Type) SetGMAC_CBSISQB(value uint32) {
	volatile.StoreUint32(&o.GMAC_CBSISQB.Reg, value)
}
func (o *GMAC_Type) GetGMAC_CBSISQB() uint32 {
	return volatile.LoadUint32(&o.GMAC_CBSISQB.Reg)
}

// GMAC.GMAC_ST1RPQ: Screening Type 1 Register Priority Queue
func (o *GMAC_Type) SetGMAC_ST1RPQ_QNB(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST1RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg)&^(0x7)|value)
}
func (o *GMAC_Type) GetGMAC_ST1RPQ_QNB(idx int) uint32 {
	return volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg) & 0x7
}
func (o *GMAC_Type) SetGMAC_ST1RPQ_DSTCM(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST1RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg)&^(0xff0)|value<<4)
}
func (o *GMAC_Type) GetGMAC_ST1RPQ_DSTCM(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg) & 0xff0) >> 4
}
func (o *GMAC_Type) SetGMAC_ST1RPQ_UDPM(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST1RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg)&^(0xffff000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_ST1RPQ_UDPM(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg) & 0xffff000) >> 12
}
func (o *GMAC_Type) SetGMAC_ST1RPQ_DSTCE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST1RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *GMAC_Type) GetGMAC_ST1RPQ_DSTCE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg) & 0x10000000) >> 28
}
func (o *GMAC_Type) SetGMAC_ST1RPQ_UDPE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST1RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *GMAC_Type) GetGMAC_ST1RPQ_UDPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST1RPQ[idx].Reg) & 0x20000000) >> 29
}

// GMAC.GMAC_ST2RPQ: Screening Type 2 Register Priority Queue
func (o *GMAC_Type) SetGMAC_ST2RPQ_QNB(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x7)|value)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_QNB(idx int) uint32 {
	return volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x7
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_VLANP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x70)|value<<4)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_VLANP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x70) >> 4
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_VLANE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x100)|value<<8)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_VLANE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x100) >> 8
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_I2ETH(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0xe00)|value<<9)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_I2ETH(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0xe00) >> 9
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_ETHE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x1000)|value<<12)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_ETHE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x1000) >> 12
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPA(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x3e000)|value<<13)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPA(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x3e000) >> 13
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPAE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x40000)|value<<18)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPAE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x40000) >> 18
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPB(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0xf80000)|value<<19)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPB(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0xf80000) >> 19
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPBE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPBE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x1000000) >> 24
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPC(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x3e000000)|value<<25)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPC(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x3e000000) >> 25
}
func (o *GMAC_Type) SetGMAC_ST2RPQ_COMPCE(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2RPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *GMAC_Type) GetGMAC_ST2RPQ_COMPCE(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2RPQ[idx].Reg) & 0x40000000) >> 30
}

// GMAC.GMAC_IERPQ: Interrupt Enable Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_IERPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IERPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IERPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IERPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IERPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IERPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IERPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IERPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IERPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IERPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IERPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IERPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IERPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IERPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IERPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IERPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.GMAC_IDRPQ: Interrupt Disable Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_IDRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IDRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IDRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IDRPQ_TFC(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_TFC(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IDRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IDRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IDRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IDRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IDRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IDRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.GMAC_IMRPQ: Interrupt Mask Register Priority Queue (1..5)
func (o *GMAC_Type) SetGMAC_IMRPQ_RCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x2)|value<<1)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_RCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x2) >> 1
}
func (o *GMAC_Type) SetGMAC_IMRPQ_RXUBR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x4)|value<<2)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_RXUBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x4) >> 2
}
func (o *GMAC_Type) SetGMAC_IMRPQ_RLEX(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x20)|value<<5)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_RLEX(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x20) >> 5
}
func (o *GMAC_Type) SetGMAC_IMRPQ_AHB(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x40)|value<<6)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_AHB(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x40) >> 6
}
func (o *GMAC_Type) SetGMAC_IMRPQ_TCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x80)|value<<7)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_TCOMP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x80) >> 7
}
func (o *GMAC_Type) SetGMAC_IMRPQ_ROVR(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x400)|value<<10)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_ROVR(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x400) >> 10
}
func (o *GMAC_Type) SetGMAC_IMRPQ_HRESP(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_IMRPQ[idx].Reg, volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg)&^(0x800)|value<<11)
}
func (o *GMAC_Type) GetGMAC_IMRPQ_HRESP(idx int) uint32 {
	return (volatile.LoadUint32(&o.GMAC_IMRPQ[idx].Reg) & 0x800) >> 11
}

// GMAC.GMAC_ST2ER: Screening Type 2 Ethertype Register
func (o *GMAC_Type) SetGMAC_ST2ER_COMPVAL(idx int, value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2ER[idx].Reg, volatile.LoadUint32(&o.GMAC_ST2ER[idx].Reg)&^(0xffff)|value)
}
func (o *GMAC_Type) GetGMAC_ST2ER_COMPVAL(idx int) uint32 {
	return volatile.LoadUint32(&o.GMAC_ST2ER[idx].Reg) & 0xffff
}

type GMAC_GMAC_SA_Type struct {
	GMAC_SAB volatile.Register32 // 0x88
	GMAC_SAT volatile.Register32 // 0x8C
}

// GMAC_GMAC_SA.GMAC_SAB: Specific Address 1 Bottom Register
func (o *GMAC_GMAC_SA_Type) SetGMAC_SAB(value uint32) {
	volatile.StoreUint32(&o.GMAC_SAB.Reg, value)
}
func (o *GMAC_GMAC_SA_Type) GetGMAC_SAB() uint32 {
	return volatile.LoadUint32(&o.GMAC_SAB.Reg)
}

// GMAC_GMAC_SA.GMAC_SAT: Specific Address 1 Top Register
func (o *GMAC_GMAC_SA_Type) SetGMAC_SAT_ADDR(value uint32) {
	volatile.StoreUint32(&o.GMAC_SAT.Reg, volatile.LoadUint32(&o.GMAC_SAT.Reg)&^(0xffff)|value)
}
func (o *GMAC_GMAC_SA_Type) GetGMAC_SAT_ADDR() uint32 {
	return volatile.LoadUint32(&o.GMAC_SAT.Reg) & 0xffff
}

type GMAC_GMAC_ST2CW_Type struct {
	GMAC_ST2CW0 volatile.Register32 // 0x700
	GMAC_ST2CW1 volatile.Register32 // 0x704
}

// GMAC_GMAC_ST2CW.GMAC_ST2CW0: Screening Type 2 Compare Word 0 Register
func (o *GMAC_GMAC_ST2CW_Type) SetGMAC_ST2CW0_MASKVAL(value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2CW0.Reg, volatile.LoadUint32(&o.GMAC_ST2CW0.Reg)&^(0xffff)|value)
}
func (o *GMAC_GMAC_ST2CW_Type) GetGMAC_ST2CW0_MASKVAL() uint32 {
	return volatile.LoadUint32(&o.GMAC_ST2CW0.Reg) & 0xffff
}
func (o *GMAC_GMAC_ST2CW_Type) SetGMAC_ST2CW0_COMPVAL(value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2CW0.Reg, volatile.LoadUint32(&o.GMAC_ST2CW0.Reg)&^(0xffff0000)|value<<16)
}
func (o *GMAC_GMAC_ST2CW_Type) GetGMAC_ST2CW0_COMPVAL() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2CW0.Reg) & 0xffff0000) >> 16
}

// GMAC_GMAC_ST2CW.GMAC_ST2CW1: Screening Type 2 Compare Word 1 Register
func (o *GMAC_GMAC_ST2CW_Type) SetGMAC_ST2CW1_OFFSVAL(value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2CW1.Reg, volatile.LoadUint32(&o.GMAC_ST2CW1.Reg)&^(0x7f)|value)
}
func (o *GMAC_GMAC_ST2CW_Type) GetGMAC_ST2CW1_OFFSVAL() uint32 {
	return volatile.LoadUint32(&o.GMAC_ST2CW1.Reg) & 0x7f
}
func (o *GMAC_GMAC_ST2CW_Type) SetGMAC_ST2CW1_OFFSSTRT(value uint32) {
	volatile.StoreUint32(&o.GMAC_ST2CW1.Reg, volatile.LoadUint32(&o.GMAC_ST2CW1.Reg)&^(0x180)|value<<7)
}
func (o *GMAC_GMAC_ST2CW_Type) GetGMAC_ST2CW1_OFFSSTRT() uint32 {
	return (volatile.LoadUint32(&o.GMAC_ST2CW1.Reg) & 0x180) >> 7
}

// General Purpose Backup Registers
type GPBR_Type struct {
	SYS_GPBR [8]volatile.Register32 // 0x0
}

// GPBR.SYS_GPBR: General Purpose Backup Register 0
func (o *GPBR_Type) SetSYS_GPBR(idx int, value uint32) {
	volatile.StoreUint32(&o.SYS_GPBR[idx].Reg, value)
}
func (o *GPBR_Type) GetSYS_GPBR(idx int) uint32 {
	return volatile.LoadUint32(&o.SYS_GPBR[idx].Reg)
}

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	HSMCI_CR    volatile.Register32    // 0x0
	HSMCI_MR    volatile.Register32    // 0x4
	HSMCI_DTOR  volatile.Register32    // 0x8
	HSMCI_SDCR  volatile.Register32    // 0xC
	HSMCI_ARGR  volatile.Register32    // 0x10
	HSMCI_CMDR  volatile.Register32    // 0x14
	HSMCI_BLKR  volatile.Register32    // 0x18
	HSMCI_CSTOR volatile.Register32    // 0x1C
	HSMCI_RSPR  [4]volatile.Register32 // 0x20
	HSMCI_RDR   volatile.Register32    // 0x30
	HSMCI_TDR   volatile.Register32    // 0x34
	_           [8]byte
	HSMCI_SR    volatile.Register32 // 0x40
	HSMCI_IER   volatile.Register32 // 0x44
	HSMCI_IDR   volatile.Register32 // 0x48
	HSMCI_IMR   volatile.Register32 // 0x4C
	HSMCI_DMA   volatile.Register32 // 0x50
	HSMCI_CFG   volatile.Register32 // 0x54
	_           [140]byte
	HSMCI_WPMR  volatile.Register32 // 0xE4
	HSMCI_WPSR  volatile.Register32 // 0xE8
	_           [276]byte
	HSMCI_FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.HSMCI_CR: Control Register
func (o *HSMCI_Type) SetHSMCI_CR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CR.Reg, volatile.LoadUint32(&o.HSMCI_CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_CR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.HSMCI_CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_CR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CR.Reg, volatile.LoadUint32(&o.HSMCI_CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetHSMCI_CR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetHSMCI_CR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CR.Reg, volatile.LoadUint32(&o.HSMCI_CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetHSMCI_CR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetHSMCI_CR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CR.Reg, volatile.LoadUint32(&o.HSMCI_CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetHSMCI_CR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetHSMCI_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CR.Reg, volatile.LoadUint32(&o.HSMCI_CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetHSMCI_CR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CR.Reg) & 0x80) >> 7
}

// HSMCI.HSMCI_MR: Mode Register
func (o *HSMCI_Type) SetHSMCI_MR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetHSMCI_MR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetHSMCI_MR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_MR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetHSMCI_MR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetHSMCI_MR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetHSMCI_MR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_MR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_MR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetHSMCI_MR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetHSMCI_MR_PADV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetHSMCI_MR_PADV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetHSMCI_MR_CLKODD(value uint32) {
	volatile.StoreUint32(&o.HSMCI_MR.Reg, volatile.LoadUint32(&o.HSMCI_MR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_MR_CLKODD() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_MR.Reg) & 0x10000) >> 16
}

// HSMCI.HSMCI_DTOR: Data Timeout Register
func (o *HSMCI_Type) SetHSMCI_DTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.HSMCI_DTOR.Reg, volatile.LoadUint32(&o.HSMCI_DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetHSMCI_DTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.HSMCI_DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetHSMCI_DTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.HSMCI_DTOR.Reg, volatile.LoadUint32(&o.HSMCI_DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_DTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_DTOR.Reg) & 0x70) >> 4
}

// HSMCI.HSMCI_SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetHSMCI_SDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SDCR.Reg, volatile.LoadUint32(&o.HSMCI_SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetHSMCI_SDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.HSMCI_SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetHSMCI_SDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SDCR.Reg, volatile.LoadUint32(&o.HSMCI_SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetHSMCI_SDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.HSMCI_ARGR: Argument Register
func (o *HSMCI_Type) SetHSMCI_ARGR(value uint32) {
	volatile.StoreUint32(&o.HSMCI_ARGR.Reg, value)
}
func (o *HSMCI_Type) GetHSMCI_ARGR() uint32 {
	return volatile.LoadUint32(&o.HSMCI_ARGR.Reg)
}

// HSMCI.HSMCI_CMDR: Command Register
func (o *HSMCI_Type) SetHSMCI_CMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetHSMCI_CMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetHSMCI_CMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetHSMCI_CMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetHSMCI_CMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_CMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetHSMCI_CMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetHSMCI_CMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetHSMCI_CMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetHSMCI_CMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetHSMCI_CMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CMDR.Reg, volatile.LoadUint32(&o.HSMCI_CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetHSMCI_CMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.HSMCI_BLKR: Block Register
func (o *HSMCI_Type) SetHSMCI_BLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_BLKR.Reg, volatile.LoadUint32(&o.HSMCI_BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetHSMCI_BLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.HSMCI_BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetHSMCI_BLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.HSMCI_BLKR.Reg, volatile.LoadUint32(&o.HSMCI_BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_BLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.HSMCI_CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetHSMCI_CSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CSTOR.Reg, volatile.LoadUint32(&o.HSMCI_CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetHSMCI_CSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.HSMCI_CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetHSMCI_CSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CSTOR.Reg, volatile.LoadUint32(&o.HSMCI_CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_CSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.HSMCI_RSPR: Response Register 0
func (o *HSMCI_Type) SetHSMCI_RSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.HSMCI_RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetHSMCI_RSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.HSMCI_RSPR[idx].Reg)
}

// HSMCI.HSMCI_RDR: Receive Data Register
func (o *HSMCI_Type) SetHSMCI_RDR(value uint32) {
	volatile.StoreUint32(&o.HSMCI_RDR.Reg, value)
}
func (o *HSMCI_Type) GetHSMCI_RDR() uint32 {
	return volatile.LoadUint32(&o.HSMCI_RDR.Reg)
}

// HSMCI.HSMCI_TDR: Transmit Data Register
func (o *HSMCI_Type) SetHSMCI_TDR(value uint32) {
	volatile.StoreUint32(&o.HSMCI_TDR.Reg, value)
}
func (o *HSMCI_Type) GetHSMCI_TDR() uint32 {
	return volatile.LoadUint32(&o.HSMCI_TDR.Reg)
}

// HSMCI.HSMCI_SR: Status Register
func (o *HSMCI_Type) SetHSMCI_SR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_SR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_SR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetHSMCI_SR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetHSMCI_SR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetHSMCI_SR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetHSMCI_SR_BLKE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetHSMCI_SR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetHSMCI_SR_DTIP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_SR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetHSMCI_SR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetHSMCI_SR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetHSMCI_SR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_SR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetHSMCI_SR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_SR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_SR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetHSMCI_SR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetHSMCI_SR_RINDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_SR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetHSMCI_SR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetHSMCI_SR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetHSMCI_SR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetHSMCI_SR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetHSMCI_SR_RENDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetHSMCI_SR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetHSMCI_SR_RTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetHSMCI_SR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetHSMCI_SR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetHSMCI_SR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetHSMCI_SR_DTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetHSMCI_SR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetHSMCI_SR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetHSMCI_SR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetHSMCI_SR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetHSMCI_SR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetHSMCI_SR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetHSMCI_SR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetHSMCI_SR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetHSMCI_SR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetHSMCI_SR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetHSMCI_SR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetHSMCI_SR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetHSMCI_SR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetHSMCI_SR_OVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetHSMCI_SR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetHSMCI_SR_UNRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_SR.Reg, volatile.LoadUint32(&o.HSMCI_SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetHSMCI_SR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_SR.Reg) & 0x80000000) >> 31
}

// HSMCI.HSMCI_IER: Interrupt Enable Register
func (o *HSMCI_Type) SetHSMCI_IER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_IER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_IER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetHSMCI_IER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetHSMCI_IER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetHSMCI_IER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetHSMCI_IER_BLKE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetHSMCI_IER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetHSMCI_IER_DTIP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_IER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetHSMCI_IER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetHSMCI_IER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetHSMCI_IER_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_IER_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetHSMCI_IER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_IER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_IER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetHSMCI_IER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetHSMCI_IER_RINDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_IER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetHSMCI_IER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetHSMCI_IER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetHSMCI_IER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetHSMCI_IER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetHSMCI_IER_RENDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetHSMCI_IER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetHSMCI_IER_RTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetHSMCI_IER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetHSMCI_IER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetHSMCI_IER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetHSMCI_IER_DTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetHSMCI_IER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetHSMCI_IER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetHSMCI_IER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetHSMCI_IER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetHSMCI_IER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetHSMCI_IER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetHSMCI_IER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetHSMCI_IER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetHSMCI_IER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetHSMCI_IER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetHSMCI_IER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetHSMCI_IER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetHSMCI_IER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetHSMCI_IER_OVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetHSMCI_IER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetHSMCI_IER_UNRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IER.Reg, volatile.LoadUint32(&o.HSMCI_IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetHSMCI_IER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IER.Reg) & 0x80000000) >> 31
}

// HSMCI.HSMCI_IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetHSMCI_IDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_IDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_IDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetHSMCI_IDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetHSMCI_IDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetHSMCI_IDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetHSMCI_IDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetHSMCI_IDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_IDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetHSMCI_IDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetHSMCI_IDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetHSMCI_IDR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_IDR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetHSMCI_IDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_IDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_IDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetHSMCI_IDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetHSMCI_IDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetHSMCI_IDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetHSMCI_IDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetHSMCI_IDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetHSMCI_IDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetHSMCI_IDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetHSMCI_IDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetHSMCI_IDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetHSMCI_IDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetHSMCI_IDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetHSMCI_IDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetHSMCI_IDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetHSMCI_IDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetHSMCI_IDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetHSMCI_IDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetHSMCI_IDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetHSMCI_IDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetHSMCI_IDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetHSMCI_IDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetHSMCI_IDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetHSMCI_IDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetHSMCI_IDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetHSMCI_IDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetHSMCI_IDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetHSMCI_IDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IDR.Reg, volatile.LoadUint32(&o.HSMCI_IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetHSMCI_IDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.HSMCI_IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetHSMCI_IMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_IMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_IMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetHSMCI_IMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetHSMCI_IMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetHSMCI_IMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetHSMCI_IMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetHSMCI_IMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_IMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetHSMCI_IMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetHSMCI_IMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetHSMCI_IMR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_IMR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetHSMCI_IMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_IMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetHSMCI_IMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetHSMCI_IMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetHSMCI_IMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetHSMCI_IMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetHSMCI_IMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetHSMCI_IMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetHSMCI_IMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetHSMCI_IMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetHSMCI_IMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetHSMCI_IMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetHSMCI_IMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetHSMCI_IMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetHSMCI_IMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetHSMCI_IMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetHSMCI_IMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetHSMCI_IMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetHSMCI_IMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetHSMCI_IMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetHSMCI_IMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetHSMCI_IMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetHSMCI_IMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetHSMCI_IMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetHSMCI_IMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetHSMCI_IMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetHSMCI_IMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetHSMCI_IMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetHSMCI_IMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_IMR.Reg, volatile.LoadUint32(&o.HSMCI_IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetHSMCI_IMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.HSMCI_DMA: DMA Configuration Register
func (o *HSMCI_Type) SetHSMCI_DMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_DMA.Reg, volatile.LoadUint32(&o.HSMCI_DMA.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_DMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_DMA.Reg) & 0x70) >> 4
}
func (o *HSMCI_Type) SetHSMCI_DMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.HSMCI_DMA.Reg, volatile.LoadUint32(&o.HSMCI_DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_DMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_DMA.Reg) & 0x100) >> 8
}

// HSMCI.HSMCI_CFG: Configuration Register
func (o *HSMCI_Type) SetHSMCI_CFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CFG.Reg, volatile.LoadUint32(&o.HSMCI_CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_CFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.HSMCI_CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_CFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CFG.Reg, volatile.LoadUint32(&o.HSMCI_CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetHSMCI_CFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetHSMCI_CFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CFG.Reg, volatile.LoadUint32(&o.HSMCI_CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_CFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetHSMCI_CFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.HSMCI_CFG.Reg, volatile.LoadUint32(&o.HSMCI_CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetHSMCI_CFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_CFG.Reg) & 0x1000) >> 12
}

// HSMCI.HSMCI_WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetHSMCI_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.HSMCI_WPMR.Reg, volatile.LoadUint32(&o.HSMCI_WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.HSMCI_WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.HSMCI_WPMR.Reg, volatile.LoadUint32(&o.HSMCI_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.HSMCI_WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetHSMCI_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.HSMCI_WPSR.Reg, volatile.LoadUint32(&o.HSMCI_WPSR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetHSMCI_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.HSMCI_WPSR.Reg) & 0x1
}
func (o *HSMCI_Type) SetHSMCI_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.HSMCI_WPSR.Reg, volatile.LoadUint32(&o.HSMCI_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetHSMCI_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.HSMCI_WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.HSMCI_FIFO: FIFO Memory Aperture0 0
func (o *HSMCI_Type) SetHSMCI_FIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.HSMCI_FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetHSMCI_FIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.HSMCI_FIFO[idx].Reg)
}

// Inter-IC Sound Controller
type I2SC_Type struct {
	I2SC_CR  volatile.Register32 // 0x0
	I2SC_MR  volatile.Register32 // 0x4
	I2SC_SR  volatile.Register32 // 0x8
	I2SC_SCR volatile.Register32 // 0xC
	I2SC_SSR volatile.Register32 // 0x10
	I2SC_IER volatile.Register32 // 0x14
	I2SC_IDR volatile.Register32 // 0x18
	I2SC_IMR volatile.Register32 // 0x1C
	I2SC_RHR volatile.Register32 // 0x20
	I2SC_THR volatile.Register32 // 0x24
}

// I2SC.I2SC_CR: Control Register
func (o *I2SC_Type) SetI2SC_CR_RXEN(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x1)|value)
}
func (o *I2SC_Type) GetI2SC_CR_RXEN() uint32 {
	return volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x1
}
func (o *I2SC_Type) SetI2SC_CR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x2)|value<<1)
}
func (o *I2SC_Type) GetI2SC_CR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x2) >> 1
}
func (o *I2SC_Type) SetI2SC_CR_CKEN(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_CR_CKEN() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_CR_CKDIS(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x8)|value<<3)
}
func (o *I2SC_Type) GetI2SC_CR_CKDIS() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x8) >> 3
}
func (o *I2SC_Type) SetI2SC_CR_TXEN(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x10)|value<<4)
}
func (o *I2SC_Type) GetI2SC_CR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x10) >> 4
}
func (o *I2SC_Type) SetI2SC_CR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x20)|value<<5)
}
func (o *I2SC_Type) GetI2SC_CR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x20) >> 5
}
func (o *I2SC_Type) SetI2SC_CR_SWRST(value uint32) {
	volatile.StoreUint32(&o.I2SC_CR.Reg, volatile.LoadUint32(&o.I2SC_CR.Reg)&^(0x80)|value<<7)
}
func (o *I2SC_Type) GetI2SC_CR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.I2SC_CR.Reg) & 0x80) >> 7
}

// I2SC.I2SC_MR: Mode Register
func (o *I2SC_Type) SetI2SC_MR_MODE(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x1)|value)
}
func (o *I2SC_Type) GetI2SC_MR_MODE() uint32 {
	return volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x1
}
func (o *I2SC_Type) SetI2SC_MR_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x1c)|value<<2)
}
func (o *I2SC_Type) GetI2SC_MR_DATALENGTH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x1c) >> 2
}
func (o *I2SC_Type) SetI2SC_MR_RXMONO(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x100)|value<<8)
}
func (o *I2SC_Type) GetI2SC_MR_RXMONO() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x100) >> 8
}
func (o *I2SC_Type) SetI2SC_MR_RXDMA(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x200)|value<<9)
}
func (o *I2SC_Type) GetI2SC_MR_RXDMA() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x200) >> 9
}
func (o *I2SC_Type) SetI2SC_MR_RXLOOP(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x400)|value<<10)
}
func (o *I2SC_Type) GetI2SC_MR_RXLOOP() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x400) >> 10
}
func (o *I2SC_Type) SetI2SC_MR_TXMONO(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x1000)|value<<12)
}
func (o *I2SC_Type) GetI2SC_MR_TXMONO() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x1000) >> 12
}
func (o *I2SC_Type) SetI2SC_MR_TXDMA(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x2000)|value<<13)
}
func (o *I2SC_Type) GetI2SC_MR_TXDMA() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x2000) >> 13
}
func (o *I2SC_Type) SetI2SC_MR_TXSAME(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x4000)|value<<14)
}
func (o *I2SC_Type) GetI2SC_MR_TXSAME() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x4000) >> 14
}
func (o *I2SC_Type) SetI2SC_MR_IMCKDIV(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x3f0000)|value<<16)
}
func (o *I2SC_Type) GetI2SC_MR_IMCKDIV() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x3f0000) >> 16
}
func (o *I2SC_Type) SetI2SC_MR_IMCKFS(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x3f000000)|value<<24)
}
func (o *I2SC_Type) GetI2SC_MR_IMCKFS() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x3f000000) >> 24
}
func (o *I2SC_Type) SetI2SC_MR_IMCKMODE(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2SC_Type) GetI2SC_MR_IMCKMODE() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x40000000) >> 30
}
func (o *I2SC_Type) SetI2SC_MR_IWS(value uint32) {
	volatile.StoreUint32(&o.I2SC_MR.Reg, volatile.LoadUint32(&o.I2SC_MR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2SC_Type) GetI2SC_MR_IWS() uint32 {
	return (volatile.LoadUint32(&o.I2SC_MR.Reg) & 0x80000000) >> 31
}

// I2SC.I2SC_SR: Status Register
func (o *I2SC_Type) SetI2SC_SR_RXEN(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x1)|value)
}
func (o *I2SC_Type) GetI2SC_SR_RXEN() uint32 {
	return volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x1
}
func (o *I2SC_Type) SetI2SC_SR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x2)|value<<1)
}
func (o *I2SC_Type) GetI2SC_SR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x2) >> 1
}
func (o *I2SC_Type) SetI2SC_SR_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_SR_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_SR_TXEN(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x10)|value<<4)
}
func (o *I2SC_Type) GetI2SC_SR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x10) >> 4
}
func (o *I2SC_Type) SetI2SC_SR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x20)|value<<5)
}
func (o *I2SC_Type) GetI2SC_SR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x20) >> 5
}
func (o *I2SC_Type) SetI2SC_SR_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_SR_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x40) >> 6
}
func (o *I2SC_Type) SetI2SC_SR_RXORCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x300)|value<<8)
}
func (o *I2SC_Type) GetI2SC_SR_RXORCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x300) >> 8
}
func (o *I2SC_Type) SetI2SC_SR_TXURCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SR.Reg, volatile.LoadUint32(&o.I2SC_SR.Reg)&^(0x300000)|value<<20)
}
func (o *I2SC_Type) GetI2SC_SR_TXURCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SR.Reg) & 0x300000) >> 20
}

// I2SC.I2SC_SCR: Status Clear Register
func (o *I2SC_Type) SetI2SC_SCR_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SCR.Reg, volatile.LoadUint32(&o.I2SC_SCR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_SCR_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SCR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_SCR_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SCR.Reg, volatile.LoadUint32(&o.I2SC_SCR.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_SCR_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SCR.Reg) & 0x40) >> 6
}
func (o *I2SC_Type) SetI2SC_SCR_RXORCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SCR.Reg, volatile.LoadUint32(&o.I2SC_SCR.Reg)&^(0x300)|value<<8)
}
func (o *I2SC_Type) GetI2SC_SCR_RXORCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SCR.Reg) & 0x300) >> 8
}
func (o *I2SC_Type) SetI2SC_SCR_TXURCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SCR.Reg, volatile.LoadUint32(&o.I2SC_SCR.Reg)&^(0x300000)|value<<20)
}
func (o *I2SC_Type) GetI2SC_SCR_TXURCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SCR.Reg) & 0x300000) >> 20
}

// I2SC.I2SC_SSR: Status Set Register
func (o *I2SC_Type) SetI2SC_SSR_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SSR.Reg, volatile.LoadUint32(&o.I2SC_SSR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_SSR_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SSR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_SSR_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_SSR.Reg, volatile.LoadUint32(&o.I2SC_SSR.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_SSR_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SSR.Reg) & 0x40) >> 6
}
func (o *I2SC_Type) SetI2SC_SSR_RXORCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SSR.Reg, volatile.LoadUint32(&o.I2SC_SSR.Reg)&^(0x300)|value<<8)
}
func (o *I2SC_Type) GetI2SC_SSR_RXORCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SSR.Reg) & 0x300) >> 8
}
func (o *I2SC_Type) SetI2SC_SSR_TXURCH(value uint32) {
	volatile.StoreUint32(&o.I2SC_SSR.Reg, volatile.LoadUint32(&o.I2SC_SSR.Reg)&^(0x300000)|value<<20)
}
func (o *I2SC_Type) GetI2SC_SSR_TXURCH() uint32 {
	return (volatile.LoadUint32(&o.I2SC_SSR.Reg) & 0x300000) >> 20
}

// I2SC.I2SC_IER: Interrupt Enable Register
func (o *I2SC_Type) SetI2SC_IER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IER.Reg, volatile.LoadUint32(&o.I2SC_IER.Reg)&^(0x2)|value<<1)
}
func (o *I2SC_Type) GetI2SC_IER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IER.Reg) & 0x2) >> 1
}
func (o *I2SC_Type) SetI2SC_IER_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IER.Reg, volatile.LoadUint32(&o.I2SC_IER.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_IER_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IER.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_IER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IER.Reg, volatile.LoadUint32(&o.I2SC_IER.Reg)&^(0x20)|value<<5)
}
func (o *I2SC_Type) GetI2SC_IER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IER.Reg) & 0x20) >> 5
}
func (o *I2SC_Type) SetI2SC_IER_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IER.Reg, volatile.LoadUint32(&o.I2SC_IER.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_IER_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IER.Reg) & 0x40) >> 6
}

// I2SC.I2SC_IDR: Interrupt Disable Register
func (o *I2SC_Type) SetI2SC_IDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IDR.Reg, volatile.LoadUint32(&o.I2SC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *I2SC_Type) GetI2SC_IDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IDR.Reg) & 0x2) >> 1
}
func (o *I2SC_Type) SetI2SC_IDR_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IDR.Reg, volatile.LoadUint32(&o.I2SC_IDR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_IDR_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IDR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_IDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IDR.Reg, volatile.LoadUint32(&o.I2SC_IDR.Reg)&^(0x20)|value<<5)
}
func (o *I2SC_Type) GetI2SC_IDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IDR.Reg) & 0x20) >> 5
}
func (o *I2SC_Type) SetI2SC_IDR_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IDR.Reg, volatile.LoadUint32(&o.I2SC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_IDR_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IDR.Reg) & 0x40) >> 6
}

// I2SC.I2SC_IMR: Interrupt Mask Register
func (o *I2SC_Type) SetI2SC_IMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IMR.Reg, volatile.LoadUint32(&o.I2SC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *I2SC_Type) GetI2SC_IMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IMR.Reg) & 0x2) >> 1
}
func (o *I2SC_Type) SetI2SC_IMR_RXOR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IMR.Reg, volatile.LoadUint32(&o.I2SC_IMR.Reg)&^(0x4)|value<<2)
}
func (o *I2SC_Type) GetI2SC_IMR_RXOR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IMR.Reg) & 0x4) >> 2
}
func (o *I2SC_Type) SetI2SC_IMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.I2SC_IMR.Reg, volatile.LoadUint32(&o.I2SC_IMR.Reg)&^(0x20)|value<<5)
}
func (o *I2SC_Type) GetI2SC_IMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IMR.Reg) & 0x20) >> 5
}
func (o *I2SC_Type) SetI2SC_IMR_TXUR(value uint32) {
	volatile.StoreUint32(&o.I2SC_IMR.Reg, volatile.LoadUint32(&o.I2SC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *I2SC_Type) GetI2SC_IMR_TXUR() uint32 {
	return (volatile.LoadUint32(&o.I2SC_IMR.Reg) & 0x40) >> 6
}

// I2SC.I2SC_RHR: Receiver Holding Register
func (o *I2SC_Type) SetI2SC_RHR(value uint32) {
	volatile.StoreUint32(&o.I2SC_RHR.Reg, value)
}
func (o *I2SC_Type) GetI2SC_RHR() uint32 {
	return volatile.LoadUint32(&o.I2SC_RHR.Reg)
}

// I2SC.I2SC_THR: Transmitter Holding Register
func (o *I2SC_Type) SetI2SC_THR(value uint32) {
	volatile.StoreUint32(&o.I2SC_THR.Reg, value)
}
func (o *I2SC_Type) GetI2SC_THR() uint32 {
	return volatile.LoadUint32(&o.I2SC_THR.Reg)
}

// Integrity Check Monitor
type ICM_Type struct {
	ICM_CFG    volatile.Register32 // 0x0
	ICM_CTRL   volatile.Register32 // 0x4
	ICM_SR     volatile.Register32 // 0x8
	_          [4]byte
	ICM_IER    volatile.Register32 // 0x10
	ICM_IDR    volatile.Register32 // 0x14
	ICM_IMR    volatile.Register32 // 0x18
	ICM_ISR    volatile.Register32 // 0x1C
	ICM_UASR   volatile.Register32 // 0x20
	_          [12]byte
	ICM_DSCR   volatile.Register32    // 0x30
	ICM_HASH   volatile.Register32    // 0x34
	ICM_UIHVAL [8]volatile.Register32 // 0x38
}

// ICM.ICM_CFG: Configuration Register
func (o *ICM_Type) SetICM_CFG_WBDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetICM_CFG_WBDIS() uint32 {
	return volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x1
}
func (o *ICM_Type) SetICM_CFG_EOMDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetICM_CFG_EOMDIS() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetICM_CFG_SLBDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetICM_CFG_SLBDIS() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetICM_CFG_BBC(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_CFG_BBC() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_CFG_ASCD(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x100)|value<<8)
}
func (o *ICM_Type) GetICM_CFG_ASCD() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x100) >> 8
}
func (o *ICM_Type) SetICM_CFG_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x200)|value<<9)
}
func (o *ICM_Type) GetICM_CFG_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x200) >> 9
}
func (o *ICM_Type) SetICM_CFG_UIHASH(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0x1000)|value<<12)
}
func (o *ICM_Type) GetICM_CFG_UIHASH() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0x1000) >> 12
}
func (o *ICM_Type) SetICM_CFG_UALGO(value uint32) {
	volatile.StoreUint32(&o.ICM_CFG.Reg, volatile.LoadUint32(&o.ICM_CFG.Reg)&^(0xe000)|value<<13)
}
func (o *ICM_Type) GetICM_CFG_UALGO() uint32 {
	return (volatile.LoadUint32(&o.ICM_CFG.Reg) & 0xe000) >> 13
}

// ICM.ICM_CTRL: Control Register
func (o *ICM_Type) SetICM_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetICM_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0x1
}
func (o *ICM_Type) SetICM_CTRL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetICM_CTRL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetICM_CTRL_SWRST(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetICM_CTRL_SWRST() uint32 {
	return (volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetICM_CTRL_REHASH(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_CTRL_REHASH() uint32 {
	return (volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_CTRL_RMDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_CTRL_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_CTRL_RMEN(value uint32) {
	volatile.StoreUint32(&o.ICM_CTRL.Reg, volatile.LoadUint32(&o.ICM_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_CTRL_RMEN() uint32 {
	return (volatile.LoadUint32(&o.ICM_CTRL.Reg) & 0xf000) >> 12
}

// ICM.ICM_SR: Status Register
func (o *ICM_Type) SetICM_SR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ICM_SR.Reg, volatile.LoadUint32(&o.ICM_SR.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetICM_SR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ICM_SR.Reg) & 0x1
}
func (o *ICM_Type) SetICM_SR_RAWRMDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_SR.Reg, volatile.LoadUint32(&o.ICM_SR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_SR_RAWRMDIS() uint32 {
	return (volatile.LoadUint32(&o.ICM_SR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_SR_RMDIS(value uint32) {
	volatile.StoreUint32(&o.ICM_SR.Reg, volatile.LoadUint32(&o.ICM_SR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_SR_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.ICM_SR.Reg) & 0xf000) >> 12
}

// ICM.ICM_IER: Interrupt Enable Register
func (o *ICM_Type) SetICM_IER_RHC(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetICM_IER_RHC() uint32 {
	return volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf
}
func (o *ICM_Type) SetICM_IER_RDM(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_IER_RDM() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_IER_RBE(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_IER_RBE() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_IER_RWC(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_IER_RWC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetICM_IER_REC(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetICM_IER_REC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetICM_IER_RSU(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetICM_IER_RSU() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetICM_IER_URAD(value uint32) {
	volatile.StoreUint32(&o.ICM_IER.Reg, volatile.LoadUint32(&o.ICM_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetICM_IER_URAD() uint32 {
	return (volatile.LoadUint32(&o.ICM_IER.Reg) & 0x1000000) >> 24
}

// ICM.ICM_IDR: Interrupt Disable Register
func (o *ICM_Type) SetICM_IDR_RHC(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetICM_IDR_RHC() uint32 {
	return volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf
}
func (o *ICM_Type) SetICM_IDR_RDM(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_IDR_RDM() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_IDR_RBE(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_IDR_RBE() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_IDR_RWC(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_IDR_RWC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetICM_IDR_REC(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetICM_IDR_REC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetICM_IDR_RSU(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetICM_IDR_RSU() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetICM_IDR_URAD(value uint32) {
	volatile.StoreUint32(&o.ICM_IDR.Reg, volatile.LoadUint32(&o.ICM_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetICM_IDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ICM_IDR.Reg) & 0x1000000) >> 24
}

// ICM.ICM_IMR: Interrupt Mask Register
func (o *ICM_Type) SetICM_IMR_RHC(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetICM_IMR_RHC() uint32 {
	return volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf
}
func (o *ICM_Type) SetICM_IMR_RDM(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_IMR_RDM() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_IMR_RBE(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_IMR_RBE() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_IMR_RWC(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_IMR_RWC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetICM_IMR_REC(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetICM_IMR_REC() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetICM_IMR_RSU(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetICM_IMR_RSU() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetICM_IMR_URAD(value uint32) {
	volatile.StoreUint32(&o.ICM_IMR.Reg, volatile.LoadUint32(&o.ICM_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetICM_IMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ICM_IMR.Reg) & 0x1000000) >> 24
}

// ICM.ICM_ISR: Interrupt Status Register
func (o *ICM_Type) SetICM_ISR_RHC(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetICM_ISR_RHC() uint32 {
	return volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf
}
func (o *ICM_Type) SetICM_ISR_RDM(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetICM_ISR_RDM() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetICM_ISR_RBE(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetICM_ISR_RBE() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetICM_ISR_RWC(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetICM_ISR_RWC() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetICM_ISR_REC(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetICM_ISR_REC() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetICM_ISR_RSU(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetICM_ISR_RSU() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetICM_ISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ICM_ISR.Reg, volatile.LoadUint32(&o.ICM_ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetICM_ISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ICM_ISR.Reg) & 0x1000000) >> 24
}

// ICM.ICM_UASR: Undefined Access Status Register
func (o *ICM_Type) SetICM_UASR_URAT(value uint32) {
	volatile.StoreUint32(&o.ICM_UASR.Reg, volatile.LoadUint32(&o.ICM_UASR.Reg)&^(0x7)|value)
}
func (o *ICM_Type) GetICM_UASR_URAT() uint32 {
	return volatile.LoadUint32(&o.ICM_UASR.Reg) & 0x7
}

// ICM.ICM_DSCR: Region Descriptor Area Start Address Register
func (o *ICM_Type) SetICM_DSCR_DASA(value uint32) {
	volatile.StoreUint32(&o.ICM_DSCR.Reg, volatile.LoadUint32(&o.ICM_DSCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *ICM_Type) GetICM_DSCR_DASA() uint32 {
	return (volatile.LoadUint32(&o.ICM_DSCR.Reg) & 0xffffffc0) >> 6
}

// ICM.ICM_HASH: Region Hash Area Start Address Register
func (o *ICM_Type) SetICM_HASH_HASA(value uint32) {
	volatile.StoreUint32(&o.ICM_HASH.Reg, volatile.LoadUint32(&o.ICM_HASH.Reg)&^(0xffffff80)|value<<7)
}
func (o *ICM_Type) GetICM_HASH_HASA() uint32 {
	return (volatile.LoadUint32(&o.ICM_HASH.Reg) & 0xffffff80) >> 7
}

// ICM.ICM_UIHVAL: User Initial Hash Value 0 Register 0
func (o *ICM_Type) SetICM_UIHVAL(idx int, value uint32) {
	volatile.StoreUint32(&o.ICM_UIHVAL[idx].Reg, value)
}
func (o *ICM_Type) GetICM_UIHVAL(idx int) uint32 {
	return volatile.LoadUint32(&o.ICM_UIHVAL[idx].Reg)
}

// Image Sensor Interface
type ISI_Type struct {
	ISI_CFG1       volatile.Register32 // 0x0
	ISI_CFG2       volatile.Register32 // 0x4
	ISI_PSIZE      volatile.Register32 // 0x8
	ISI_PDECF      volatile.Register32 // 0xC
	ISI_Y2R_SET0   volatile.Register32 // 0x10
	ISI_Y2R_SET1   volatile.Register32 // 0x14
	ISI_R2Y_SET0   volatile.Register32 // 0x18
	ISI_R2Y_SET1   volatile.Register32 // 0x1C
	ISI_R2Y_SET2   volatile.Register32 // 0x20
	ISI_CR         volatile.Register32 // 0x24
	ISI_SR         volatile.Register32 // 0x28
	ISI_IER        volatile.Register32 // 0x2C
	ISI_IDR        volatile.Register32 // 0x30
	ISI_IMR        volatile.Register32 // 0x34
	ISI_DMA_CHER   volatile.Register32 // 0x38
	ISI_DMA_CHDR   volatile.Register32 // 0x3C
	ISI_DMA_CHSR   volatile.Register32 // 0x40
	ISI_DMA_P_ADDR volatile.Register32 // 0x44
	ISI_DMA_P_CTRL volatile.Register32 // 0x48
	ISI_DMA_P_DSCR volatile.Register32 // 0x4C
	ISI_DMA_C_ADDR volatile.Register32 // 0x50
	ISI_DMA_C_CTRL volatile.Register32 // 0x54
	ISI_DMA_C_DSCR volatile.Register32 // 0x58
	_              [136]byte
	ISI_WPMR       volatile.Register32 // 0xE4
	ISI_WPSR       volatile.Register32 // 0xE8
}

// ISI.ISI_CFG1: ISI Configuration 1 Register
func (o *ISI_Type) SetISI_CFG1_HSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_CFG1_HSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_CFG1_VSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetISI_CFG1_VSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x8) >> 3
}
func (o *ISI_Type) SetISI_CFG1_PIXCLK_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ISI_Type) GetISI_CFG1_PIXCLK_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x10) >> 4
}
func (o *ISI_Type) SetISI_CFG1_GRAYLE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x20)|value<<5)
}
func (o *ISI_Type) GetISI_CFG1_GRAYLE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x20) >> 5
}
func (o *ISI_Type) SetISI_CFG1_EMB_SYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x40)|value<<6)
}
func (o *ISI_Type) GetISI_CFG1_EMB_SYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x40) >> 6
}
func (o *ISI_Type) SetISI_CFG1_CRC_SYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ISI_Type) GetISI_CFG1_CRC_SYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x80) >> 7
}
func (o *ISI_Type) SetISI_CFG1_FRATE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x700)|value<<8)
}
func (o *ISI_Type) GetISI_CFG1_FRATE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x700) >> 8
}
func (o *ISI_Type) SetISI_CFG1_DISCR(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetISI_CFG1_DISCR() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetISI_CFG1_FULL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_CFG1_FULL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_CFG1_THMASK(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x6000)|value<<13)
}
func (o *ISI_Type) GetISI_CFG1_THMASK() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x6000) >> 13
}
func (o *ISI_Type) SetISI_CFG1_SLD(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_CFG1_SLD() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_CFG1_SFD(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetISI_CFG1_SFD() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0xff000000) >> 24
}

// ISI.ISI_CFG2: ISI Configuration 2 Register
func (o *ISI_Type) SetISI_CFG2_IM_VSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x7ff)|value)
}
func (o *ISI_Type) GetISI_CFG2_IM_VSIZE() uint32 {
	return volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x7ff
}
func (o *ISI_Type) SetISI_CFG2_GS_MODE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetISI_CFG2_GS_MODE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetISI_CFG2_RGB_MODE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_CFG2_RGB_MODE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_CFG2_GRAYSCALE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetISI_CFG2_GRAYSCALE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetISI_CFG2_RGB_SWAP(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetISI_CFG2_RGB_SWAP() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x4000) >> 14
}
func (o *ISI_Type) SetISI_CFG2_COL_SPACE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *ISI_Type) GetISI_CFG2_COL_SPACE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x8000) >> 15
}
func (o *ISI_Type) SetISI_CFG2_IM_HSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ISI_Type) GetISI_CFG2_IM_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x7ff0000) >> 16
}
func (o *ISI_Type) SetISI_CFG2_YCC_SWAP(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *ISI_Type) GetISI_CFG2_YCC_SWAP() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x30000000) >> 28
}
func (o *ISI_Type) SetISI_CFG2_RGB_CFG(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ISI_Type) GetISI_CFG2_RGB_CFG() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0xc0000000) >> 30
}

// ISI.ISI_PSIZE: ISI Preview Size Register
func (o *ISI_Type) SetISI_PSIZE_PREV_VSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_PSIZE.Reg, volatile.LoadUint32(&o.ISI_PSIZE.Reg)&^(0x3ff)|value)
}
func (o *ISI_Type) GetISI_PSIZE_PREV_VSIZE() uint32 {
	return volatile.LoadUint32(&o.ISI_PSIZE.Reg) & 0x3ff
}
func (o *ISI_Type) SetISI_PSIZE_PREV_HSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_PSIZE.Reg, volatile.LoadUint32(&o.ISI_PSIZE.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ISI_Type) GetISI_PSIZE_PREV_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.ISI_PSIZE.Reg) & 0x3ff0000) >> 16
}

// ISI.ISI_PDECF: ISI Preview Decimation Factor Register
func (o *ISI_Type) SetISI_PDECF_DEC_FACTOR(value uint32) {
	volatile.StoreUint32(&o.ISI_PDECF.Reg, volatile.LoadUint32(&o.ISI_PDECF.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_PDECF_DEC_FACTOR() uint32 {
	return volatile.LoadUint32(&o.ISI_PDECF.Reg) & 0xff
}

// ISI.ISI_Y2R_SET0: ISI Color Space Conversion YCrCb To RGB Set 0 Register
func (o *ISI_Type) SetISI_Y2R_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetISI_Y2R_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetISI_Y2R_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_Y2R_SET0_C3(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C3() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff000000) >> 24
}

// ISI.ISI_Y2R_SET1: ISI Color Space Conversion YCrCb To RGB Set 1 Register
func (o *ISI_Type) SetISI_Y2R_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x1ff)|value)
}
func (o *ISI_Type) GetISI_Y2R_SET1_C4() uint32 {
	return volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x1ff
}
func (o *ISI_Type) SetISI_Y2R_SET1_Yoff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Yoff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_Y2R_SET1_Croff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Croff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetISI_Y2R_SET1_Cboff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Cboff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x4000) >> 14
}

// ISI.ISI_R2Y_SET0: ISI Color Space Conversion RGB To YCrCb Set 0 Register
func (o *ISI_Type) SetISI_R2Y_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0x7f
}
func (o *ISI_Type) SetISI_R2Y_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET0_Roff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET0_Roff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0x1000000) >> 24
}

// ISI.ISI_R2Y_SET1: ISI Color Space Conversion RGB To YCrCb Set 1 Register
func (o *ISI_Type) SetISI_R2Y_SET1_C3(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C3() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0x7f
}
func (o *ISI_Type) SetISI_R2Y_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C4() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET1_C5(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C5() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET1_Goff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET1_Goff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0x1000000) >> 24
}

// ISI.ISI_R2Y_SET2: ISI Color Space Conversion RGB To YCrCb Set 2 Register
func (o *ISI_Type) SetISI_R2Y_SET2_C6(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C6() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0x7f
}
func (o *ISI_Type) SetISI_R2Y_SET2_C7(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C7() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET2_C8(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C8() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET2_Boff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET2_Boff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0x1000000) >> 24
}

// ISI.ISI_CR: ISI Control Register
func (o *ISI_Type) SetISI_CR_ISI_EN(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_CR_ISI_EN() uint32 {
	return volatile.LoadUint32(&o.ISI_CR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_CR_ISI_DIS(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_CR_ISI_DIS() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_CR_ISI_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_CR_ISI_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_CR_ISI_CDC(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetISI_CR_ISI_CDC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x100) >> 8
}

// ISI.ISI_SR: ISI Status Register
func (o *ISI_Type) SetISI_SR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_SR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ISI_SR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_SR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_SR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_SR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_SR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_SR_CDC_PND(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetISI_SR_CDC_PND() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x100) >> 8
}
func (o *ISI_Type) SetISI_SR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_SR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_SR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_SR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_SR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_SR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_SR_SIP(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x80000)|value<<19)
}
func (o *ISI_Type) GetISI_SR_SIP() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x80000) >> 19
}
func (o *ISI_Type) SetISI_SR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_SR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_SR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_SR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_SR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_SR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_SR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_SR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IER: ISI Interrupt Enable Register
func (o *ISI_Type) SetISI_IER_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IER_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IER_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IER_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IER_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IER_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IER_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IER_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IER_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IER_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IER_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IER_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IER_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IER_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IER_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IER_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IER_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IER_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IDR: ISI Interrupt Disable Register
func (o *ISI_Type) SetISI_IDR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IDR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IDR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IDR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IDR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IDR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IDR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IDR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IDR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IDR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IDR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IDR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IDR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IDR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IDR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IDR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IDR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IDR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IMR: ISI Interrupt Mask Register
func (o *ISI_Type) SetISI_IMR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IMR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IMR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IMR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IMR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IMR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IMR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IMR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IMR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IMR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IMR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IMR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IMR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IMR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IMR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IMR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IMR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IMR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x8000000) >> 27
}

// ISI.ISI_DMA_CHER: DMA Channel Enable Register
func (o *ISI_Type) SetISI_DMA_CHER_P_CH_EN(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHER.Reg, volatile.LoadUint32(&o.ISI_DMA_CHER.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_DMA_CHER_P_CH_EN() uint32 {
	return volatile.LoadUint32(&o.ISI_DMA_CHER.Reg) & 0x1
}
func (o *ISI_Type) SetISI_DMA_CHER_C_CH_EN(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHER.Reg, volatile.LoadUint32(&o.ISI_DMA_CHER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_DMA_CHER_C_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_CHER.Reg) & 0x2) >> 1
}

// ISI.ISI_DMA_CHDR: DMA Channel Disable Register
func (o *ISI_Type) SetISI_DMA_CHDR_P_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHDR.Reg, volatile.LoadUint32(&o.ISI_DMA_CHDR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_DMA_CHDR_P_CH_DIS() uint32 {
	return volatile.LoadUint32(&o.ISI_DMA_CHDR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_DMA_CHDR_C_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHDR.Reg, volatile.LoadUint32(&o.ISI_DMA_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_DMA_CHDR_C_CH_DIS() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_CHDR.Reg) & 0x2) >> 1
}

// ISI.ISI_DMA_CHSR: DMA Channel Status Register
func (o *ISI_Type) SetISI_DMA_CHSR_P_CH_S(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHSR.Reg, volatile.LoadUint32(&o.ISI_DMA_CHSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_DMA_CHSR_P_CH_S() uint32 {
	return volatile.LoadUint32(&o.ISI_DMA_CHSR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_DMA_CHSR_C_CH_S(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_CHSR.Reg, volatile.LoadUint32(&o.ISI_DMA_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_DMA_CHSR_C_CH_S() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_CHSR.Reg) & 0x2) >> 1
}

// ISI.ISI_DMA_P_ADDR: DMA Preview Base Address Register
func (o *ISI_Type) SetISI_DMA_P_ADDR_P_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_ADDR.Reg, volatile.LoadUint32(&o.ISI_DMA_P_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_P_ADDR_P_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_P_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.ISI_DMA_P_CTRL: DMA Preview Control Register
func (o *ISI_Type) SetISI_DMA_P_CTRL_P_FETCH(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_DMA_P_CTRL_P_FETCH() uint32 {
	return volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetISI_DMA_P_CTRL_P_WB(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_DMA_P_CTRL_P_WB() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_DMA_P_CTRL_P_IEN(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_P_CTRL_P_IEN() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_DMA_P_CTRL_P_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetISI_DMA_P_CTRL_P_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_P_CTRL.Reg) & 0x8) >> 3
}

// ISI.ISI_DMA_P_DSCR: DMA Preview Descriptor Address Register
func (o *ISI_Type) SetISI_DMA_P_DSCR_P_DSCR(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_P_DSCR.Reg, volatile.LoadUint32(&o.ISI_DMA_P_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_P_DSCR_P_DSCR() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_P_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.ISI_DMA_C_ADDR: DMA Codec Base Address Register
func (o *ISI_Type) SetISI_DMA_C_ADDR_C_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_ADDR.Reg, volatile.LoadUint32(&o.ISI_DMA_C_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_C_ADDR_C_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_C_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.ISI_DMA_C_CTRL: DMA Codec Control Register
func (o *ISI_Type) SetISI_DMA_C_CTRL_C_FETCH(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_DMA_C_CTRL_C_FETCH() uint32 {
	return volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetISI_DMA_C_CTRL_C_WB(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_DMA_C_CTRL_C_WB() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_DMA_C_CTRL_C_IEN(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_C_CTRL_C_IEN() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_DMA_C_CTRL_C_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_CTRL.Reg, volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetISI_DMA_C_CTRL_C_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_C_CTRL.Reg) & 0x8) >> 3
}

// ISI.ISI_DMA_C_DSCR: DMA Codec Descriptor Address Register
func (o *ISI_Type) SetISI_DMA_C_DSCR_C_DSCR(value uint32) {
	volatile.StoreUint32(&o.ISI_DMA_C_DSCR.Reg, volatile.LoadUint32(&o.ISI_DMA_C_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetISI_DMA_C_DSCR_C_DSCR() uint32 {
	return (volatile.LoadUint32(&o.ISI_DMA_C_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.ISI_WPMR: Write Protection Mode Register
func (o *ISI_Type) SetISI_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.ISI_WPMR.Reg, volatile.LoadUint32(&o.ISI_WPMR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.ISI_WPMR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.ISI_WPMR.Reg, volatile.LoadUint32(&o.ISI_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ISI_Type) GetISI_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.ISI_WPMR.Reg) & 0xffffff00) >> 8
}

// ISI.ISI_WPSR: Write Protection Status Register
func (o *ISI_Type) SetISI_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.ISI_WPSR.Reg, volatile.LoadUint32(&o.ISI_WPSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.ISI_WPSR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.ISI_WPSR.Reg, volatile.LoadUint32(&o.ISI_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ISI_Type) GetISI_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.ISI_WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [13]volatile.Register32 // 0x0
	_            [12]byte
	MATRIX_SCFG  [9]volatile.Register32 // 0x40
	_            [28]byte
	MATRIX_PR    [9]MATRIX_MATRIX_PR_Type // 0x80
	_            [56]byte
	MATRIX_MRCR  volatile.Register32 // 0x100
	_            [12]byte
	CCFG_CAN0    volatile.Register32 // 0x110
	CCFG_SYSIO   volatile.Register32 // 0x114
	CCFG_PCCR    volatile.Register32 // 0x118
	CCFG_DYNCKG  volatile.Register32 // 0x11C
	_            [4]byte
	CCFG_SMCNFCS volatile.Register32 // 0x124
	_            [188]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MATRIX_MCFG: Master Configuration Register 0
func (o *MATRIX_Type) SetMATRIX_MCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg) & 0x7
}

// MATRIX.MATRIX_SCFG: Slave Configuration Register 0
func (o *MATRIX_Type) SetMATRIX_SCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetMATRIX_SCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_SCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.MATRIX_MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB6(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB6() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB8(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB8() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x100) >> 8
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB9(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x200)|value<<9)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB9() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x200) >> 9
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB10(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x400)|value<<10)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB10() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x400) >> 10
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB11(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x800)|value<<11)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB11() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x800) >> 11
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB12(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB12() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x1000) >> 12
}

// MATRIX.CCFG_CAN0: CAN0 Configuration Register
func (o *MATRIX_Type) SetCCFG_CAN0_CAN0DMABA(value uint32) {
	volatile.StoreUint32(&o.CCFG_CAN0.Reg, volatile.LoadUint32(&o.CCFG_CAN0.Reg)&^(0xffff0000)|value<<16)
}
func (o *MATRIX_Type) GetCCFG_CAN0_CAN0DMABA() uint32 {
	return (volatile.LoadUint32(&o.CCFG_CAN0.Reg) & 0xffff0000) >> 16
}

// MATRIX.CCFG_SYSIO: System I/O and CAN1 Configuration Register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO4(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO4() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO5(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO5() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO6(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO6() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO7(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO7() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}
func (o *MATRIX_Type) SetCCFG_SYSIO_CAN1DMABA(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0xffff0000)|value<<16)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_CAN1DMABA() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0xffff0000) >> 16
}

// MATRIX.CCFG_PCCR: Peripheral Clock Configuration Register
func (o *MATRIX_Type) SetCCFG_PCCR_TC0CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x100000)|value<<20)
}
func (o *MATRIX_Type) GetCCFG_PCCR_TC0CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x100000) >> 20
}
func (o *MATRIX_Type) SetCCFG_PCCR_I2SC0CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x200000)|value<<21)
}
func (o *MATRIX_Type) GetCCFG_PCCR_I2SC0CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x200000) >> 21
}
func (o *MATRIX_Type) SetCCFG_PCCR_I2SC1CC(value uint32) {
	volatile.StoreUint32(&o.CCFG_PCCR.Reg, volatile.LoadUint32(&o.CCFG_PCCR.Reg)&^(0x400000)|value<<22)
}
func (o *MATRIX_Type) GetCCFG_PCCR_I2SC1CC() uint32 {
	return (volatile.LoadUint32(&o.CCFG_PCCR.Reg) & 0x400000) >> 22
}

// MATRIX.CCFG_DYNCKG: Dynamic Clock Gating Register
func (o *MATRIX_Type) SetCCFG_DYNCKG_MATCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_MATCKG() uint32 {
	return volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_DYNCKG_BRIDCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_BRIDCKG() uint32 {
	return (volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_DYNCKG_EFCCKG(value uint32) {
	volatile.StoreUint32(&o.CCFG_DYNCKG.Reg, volatile.LoadUint32(&o.CCFG_DYNCKG.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_DYNCKG_EFCCKG() uint32 {
	return (volatile.LoadUint32(&o.CCFG_DYNCKG.Reg) & 0x4) >> 2
}

// MATRIX.CCFG_SMCNFCS: SMC NAND Flash Chip Select Configuration Register
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS0(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS0() uint32 {
	return volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS1(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS1() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS2(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS2() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS3(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS3() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SDRAMEN(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SDRAMEN() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x10) >> 4
}

// MATRIX.MATRIX_WPMR: Write Protection Mode Register
func (o *MATRIX_Type) SetMATRIX_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.MATRIX_WPSR: Write Protection Status Register
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0xffff00) >> 8
}

type MATRIX_MATRIX_PR_Type struct {
	MATRIX_PRAS volatile.Register32 // 0x80
	MATRIX_PRBS volatile.Register32 // 0x84
}

// MATRIX_MATRIX_PR.MATRIX_PRAS: Priority Register A for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x3
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x30) >> 4
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x300) >> 8
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x3000) >> 12
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x30000) >> 16
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x300000) >> 20
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRAS_M6PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS.Reg, volatile.LoadUint32(&o.MATRIX_PRAS.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRAS_M6PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS.Reg) & 0x3000000) >> 24
}

// MATRIX_MATRIX_PR.MATRIX_PRBS: Priority Register B for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRBS_M8PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRBS.Reg, volatile.LoadUint32(&o.MATRIX_PRBS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRBS_M8PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRBS.Reg) & 0x3
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRBS_M9PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRBS.Reg, volatile.LoadUint32(&o.MATRIX_PRBS.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRBS_M9PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRBS.Reg) & 0x30) >> 4
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRBS_M10PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRBS.Reg, volatile.LoadUint32(&o.MATRIX_PRBS.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRBS_M10PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRBS.Reg) & 0x300) >> 8
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRBS_M11PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRBS.Reg, volatile.LoadUint32(&o.MATRIX_PRBS.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRBS_M11PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRBS.Reg) & 0x3000) >> 12
}
func (o *MATRIX_MATRIX_PR_Type) SetMATRIX_PRBS_M12PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRBS.Reg, volatile.LoadUint32(&o.MATRIX_PRBS.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_MATRIX_PR_Type) GetMATRIX_PRBS_M12PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRBS.Reg) & 0x30000) >> 16
}

// Controller Area Network
type MCAN_Type struct {
	MCAN_CREL   volatile.Register32 // 0x0
	MCAN_ENDN   volatile.Register32 // 0x4
	MCAN_CUST   volatile.Register32 // 0x8
	MCAN_DBTP   volatile.Register32 // 0xC
	MCAN_TEST   volatile.Register32 // 0x10
	MCAN_RWD    volatile.Register32 // 0x14
	MCAN_CCCR   volatile.Register32 // 0x18
	MCAN_NBTP   volatile.Register32 // 0x1C
	MCAN_TSCC   volatile.Register32 // 0x20
	MCAN_TSCV   volatile.Register32 // 0x24
	MCAN_TOCC   volatile.Register32 // 0x28
	MCAN_TOCV   volatile.Register32 // 0x2C
	_           [16]byte
	MCAN_ECR    volatile.Register32 // 0x40
	MCAN_PSR    volatile.Register32 // 0x44
	MCAN_TDCR   volatile.Register32 // 0x48
	_           [4]byte
	MCAN_IR     volatile.Register32 // 0x50
	MCAN_IE     volatile.Register32 // 0x54
	MCAN_ILS    volatile.Register32 // 0x58
	MCAN_ILE    volatile.Register32 // 0x5C
	_           [32]byte
	MCAN_GFC    volatile.Register32 // 0x80
	MCAN_SIDFC  volatile.Register32 // 0x84
	MCAN_XIDFC  volatile.Register32 // 0x88
	_           [4]byte
	MCAN_XIDAM  volatile.Register32 // 0x90
	MCAN_HPMS   volatile.Register32 // 0x94
	MCAN_NDAT1  volatile.Register32 // 0x98
	MCAN_NDAT2  volatile.Register32 // 0x9C
	MCAN_RXF0C  volatile.Register32 // 0xA0
	MCAN_RXF0S  volatile.Register32 // 0xA4
	MCAN_RXF0A  volatile.Register32 // 0xA8
	MCAN_RXBC   volatile.Register32 // 0xAC
	MCAN_RXF1C  volatile.Register32 // 0xB0
	MCAN_RXF1S  volatile.Register32 // 0xB4
	MCAN_RXF1A  volatile.Register32 // 0xB8
	MCAN_RXESC  volatile.Register32 // 0xBC
	MCAN_TXBC   volatile.Register32 // 0xC0
	MCAN_TXFQS  volatile.Register32 // 0xC4
	MCAN_TXESC  volatile.Register32 // 0xC8
	MCAN_TXBRP  volatile.Register32 // 0xCC
	MCAN_TXBAR  volatile.Register32 // 0xD0
	MCAN_TXBCR  volatile.Register32 // 0xD4
	MCAN_TXBTO  volatile.Register32 // 0xD8
	MCAN_TXBCF  volatile.Register32 // 0xDC
	MCAN_TXBTIE volatile.Register32 // 0xE0
	MCAN_TXBCIE volatile.Register32 // 0xE4
	_           [8]byte
	MCAN_TXEFC  volatile.Register32 // 0xF0
	MCAN_TXEFS  volatile.Register32 // 0xF4
	MCAN_TXEFA  volatile.Register32 // 0xF8
}

// MCAN.MCAN_CREL: Core Release Register
func (o *MCAN_Type) SetMCAN_CREL_DAY(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetMCAN_CREL_DAY() uint32 {
	return volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xff
}
func (o *MCAN_Type) SetMCAN_CREL_MON(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_CREL_MON() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xff00) >> 8
}
func (o *MCAN_Type) SetMCAN_CREL_YEAR(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xf0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_CREL_YEAR() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xf0000) >> 16
}
func (o *MCAN_Type) SetMCAN_CREL_SUBSTEP(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xf00000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_CREL_SUBSTEP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xf00000) >> 20
}
func (o *MCAN_Type) SetMCAN_CREL_STEP(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xf000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_CREL_STEP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xf000000) >> 24
}
func (o *MCAN_Type) SetMCAN_CREL_REL(value uint32) {
	volatile.StoreUint32(&o.MCAN_CREL.Reg, volatile.LoadUint32(&o.MCAN_CREL.Reg)&^(0xf0000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_CREL_REL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CREL.Reg) & 0xf0000000) >> 28
}

// MCAN.MCAN_ENDN: Endian Register
func (o *MCAN_Type) SetMCAN_ENDN(value uint32) {
	volatile.StoreUint32(&o.MCAN_ENDN.Reg, value)
}
func (o *MCAN_Type) GetMCAN_ENDN() uint32 {
	return volatile.LoadUint32(&o.MCAN_ENDN.Reg)
}

// MCAN.MCAN_CUST: Customer Register
func (o *MCAN_Type) SetMCAN_CUST(value uint32) {
	volatile.StoreUint32(&o.MCAN_CUST.Reg, value)
}
func (o *MCAN_Type) GetMCAN_CUST() uint32 {
	return volatile.LoadUint32(&o.MCAN_CUST.Reg)
}

// MCAN.MCAN_DBTP: Data Bit Timing and Prescaler Register
func (o *MCAN_Type) SetMCAN_DBTP_DSJW(value uint32) {
	volatile.StoreUint32(&o.MCAN_DBTP.Reg, volatile.LoadUint32(&o.MCAN_DBTP.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetMCAN_DBTP_DSJW() uint32 {
	return volatile.LoadUint32(&o.MCAN_DBTP.Reg) & 0x7
}
func (o *MCAN_Type) SetMCAN_DBTP_DTSEG2(value uint32) {
	volatile.StoreUint32(&o.MCAN_DBTP.Reg, volatile.LoadUint32(&o.MCAN_DBTP.Reg)&^(0xf0)|value<<4)
}
func (o *MCAN_Type) GetMCAN_DBTP_DTSEG2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_DBTP.Reg) & 0xf0) >> 4
}
func (o *MCAN_Type) SetMCAN_DBTP_DTSEG1(value uint32) {
	volatile.StoreUint32(&o.MCAN_DBTP.Reg, volatile.LoadUint32(&o.MCAN_DBTP.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_DBTP_DTSEG1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_DBTP.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetMCAN_DBTP_DBRP(value uint32) {
	volatile.StoreUint32(&o.MCAN_DBTP.Reg, volatile.LoadUint32(&o.MCAN_DBTP.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_DBTP_DBRP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_DBTP.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_DBTP_TDC(value uint32) {
	volatile.StoreUint32(&o.MCAN_DBTP.Reg, volatile.LoadUint32(&o.MCAN_DBTP.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_DBTP_TDC() uint32 {
	return (volatile.LoadUint32(&o.MCAN_DBTP.Reg) & 0x800000) >> 23
}

// MCAN.MCAN_TEST: Test Register
func (o *MCAN_Type) SetMCAN_TEST_LBCK(value uint32) {
	volatile.StoreUint32(&o.MCAN_TEST.Reg, volatile.LoadUint32(&o.MCAN_TEST.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TEST_LBCK() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TEST.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TEST_TX(value uint32) {
	volatile.StoreUint32(&o.MCAN_TEST.Reg, volatile.LoadUint32(&o.MCAN_TEST.Reg)&^(0x60)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TEST_TX() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TEST.Reg) & 0x60) >> 5
}
func (o *MCAN_Type) SetMCAN_TEST_RX(value uint32) {
	volatile.StoreUint32(&o.MCAN_TEST.Reg, volatile.LoadUint32(&o.MCAN_TEST.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TEST_RX() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TEST.Reg) & 0x80) >> 7
}

// MCAN.MCAN_RWD: RAM Watchdog Register
func (o *MCAN_Type) SetMCAN_RWD_WDC(value uint32) {
	volatile.StoreUint32(&o.MCAN_RWD.Reg, volatile.LoadUint32(&o.MCAN_RWD.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetMCAN_RWD_WDC() uint32 {
	return volatile.LoadUint32(&o.MCAN_RWD.Reg) & 0xff
}
func (o *MCAN_Type) SetMCAN_RWD_WDV(value uint32) {
	volatile.StoreUint32(&o.MCAN_RWD.Reg, volatile.LoadUint32(&o.MCAN_RWD.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_RWD_WDV() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RWD.Reg) & 0xff00) >> 8
}

// MCAN.MCAN_CCCR: CC Control Register
func (o *MCAN_Type) SetMCAN_CCCR_INIT(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_CCCR_INIT() uint32 {
	return volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_CCCR_CCE(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_CCCR_CCE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_CCCR_ASM(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_CCCR_ASM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_CCCR_CSA(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_CCCR_CSA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_CCCR_CSR(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_CCCR_CSR() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_CCCR_MON(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_CCCR_MON() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_CCCR_DAR(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_CCCR_DAR() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_CCCR_TEST(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_CCCR_TEST() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_CCCR_FDOE(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_CCCR_FDOE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_CCCR_BRSE(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_CCCR_BRSE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_CCCR_PXHD(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_CCCR_PXHD() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_CCCR_EFBI(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_CCCR_EFBI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_CCCR_TXP(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_CCCR_TXP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_CCCR_NISO(value uint32) {
	volatile.StoreUint32(&o.MCAN_CCCR.Reg, volatile.LoadUint32(&o.MCAN_CCCR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_CCCR_NISO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_CCCR.Reg) & 0x8000) >> 15
}

// MCAN.MCAN_NBTP: Nominal Bit Timing and Prescaler Register
func (o *MCAN_Type) SetMCAN_NBTP_NTSEG2(value uint32) {
	volatile.StoreUint32(&o.MCAN_NBTP.Reg, volatile.LoadUint32(&o.MCAN_NBTP.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetMCAN_NBTP_NTSEG2() uint32 {
	return volatile.LoadUint32(&o.MCAN_NBTP.Reg) & 0x7f
}
func (o *MCAN_Type) SetMCAN_NBTP_NTSEG1(value uint32) {
	volatile.StoreUint32(&o.MCAN_NBTP.Reg, volatile.LoadUint32(&o.MCAN_NBTP.Reg)&^(0xff00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_NBTP_NTSEG1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NBTP.Reg) & 0xff00) >> 8
}
func (o *MCAN_Type) SetMCAN_NBTP_NBRP(value uint32) {
	volatile.StoreUint32(&o.MCAN_NBTP.Reg, volatile.LoadUint32(&o.MCAN_NBTP.Reg)&^(0x1ff0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_NBTP_NBRP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NBTP.Reg) & 0x1ff0000) >> 16
}
func (o *MCAN_Type) SetMCAN_NBTP_NSJW(value uint32) {
	volatile.StoreUint32(&o.MCAN_NBTP.Reg, volatile.LoadUint32(&o.MCAN_NBTP.Reg)&^(0xfe000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_NBTP_NSJW() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NBTP.Reg) & 0xfe000000) >> 25
}

// MCAN.MCAN_TSCC: Timestamp Counter Configuration Register
func (o *MCAN_Type) SetMCAN_TSCC_TSS(value uint32) {
	volatile.StoreUint32(&o.MCAN_TSCC.Reg, volatile.LoadUint32(&o.MCAN_TSCC.Reg)&^(0x3)|value)
}
func (o *MCAN_Type) GetMCAN_TSCC_TSS() uint32 {
	return volatile.LoadUint32(&o.MCAN_TSCC.Reg) & 0x3
}
func (o *MCAN_Type) SetMCAN_TSCC_TCP(value uint32) {
	volatile.StoreUint32(&o.MCAN_TSCC.Reg, volatile.LoadUint32(&o.MCAN_TSCC.Reg)&^(0xf0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TSCC_TCP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TSCC.Reg) & 0xf0000) >> 16
}

// MCAN.MCAN_TSCV: Timestamp Counter Value Register
func (o *MCAN_Type) SetMCAN_TSCV_TSC(value uint32) {
	volatile.StoreUint32(&o.MCAN_TSCV.Reg, volatile.LoadUint32(&o.MCAN_TSCV.Reg)&^(0xffff)|value)
}
func (o *MCAN_Type) GetMCAN_TSCV_TSC() uint32 {
	return volatile.LoadUint32(&o.MCAN_TSCV.Reg) & 0xffff
}

// MCAN.MCAN_TOCC: Timeout Counter Configuration Register
func (o *MCAN_Type) SetMCAN_TOCC_ETOC(value uint32) {
	volatile.StoreUint32(&o.MCAN_TOCC.Reg, volatile.LoadUint32(&o.MCAN_TOCC.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TOCC_ETOC() uint32 {
	return volatile.LoadUint32(&o.MCAN_TOCC.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TOCC_TOS(value uint32) {
	volatile.StoreUint32(&o.MCAN_TOCC.Reg, volatile.LoadUint32(&o.MCAN_TOCC.Reg)&^(0x6)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TOCC_TOS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TOCC.Reg) & 0x6) >> 1
}
func (o *MCAN_Type) SetMCAN_TOCC_TOP(value uint32) {
	volatile.StoreUint32(&o.MCAN_TOCC.Reg, volatile.LoadUint32(&o.MCAN_TOCC.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TOCC_TOP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TOCC.Reg) & 0xffff0000) >> 16
}

// MCAN.MCAN_TOCV: Timeout Counter Value Register
func (o *MCAN_Type) SetMCAN_TOCV_TOC(value uint32) {
	volatile.StoreUint32(&o.MCAN_TOCV.Reg, volatile.LoadUint32(&o.MCAN_TOCV.Reg)&^(0xffff)|value)
}
func (o *MCAN_Type) GetMCAN_TOCV_TOC() uint32 {
	return volatile.LoadUint32(&o.MCAN_TOCV.Reg) & 0xffff
}

// MCAN.MCAN_ECR: Error Counter Register
func (o *MCAN_Type) SetMCAN_ECR_TEC(value uint32) {
	volatile.StoreUint32(&o.MCAN_ECR.Reg, volatile.LoadUint32(&o.MCAN_ECR.Reg)&^(0xff)|value)
}
func (o *MCAN_Type) GetMCAN_ECR_TEC() uint32 {
	return volatile.LoadUint32(&o.MCAN_ECR.Reg) & 0xff
}
func (o *MCAN_Type) SetMCAN_ECR_REC(value uint32) {
	volatile.StoreUint32(&o.MCAN_ECR.Reg, volatile.LoadUint32(&o.MCAN_ECR.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_ECR_REC() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ECR.Reg) & 0x7f00) >> 8
}
func (o *MCAN_Type) SetMCAN_ECR_RP(value uint32) {
	volatile.StoreUint32(&o.MCAN_ECR.Reg, volatile.LoadUint32(&o.MCAN_ECR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_ECR_RP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ECR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_ECR_CEL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ECR.Reg, volatile.LoadUint32(&o.MCAN_ECR.Reg)&^(0xff0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_ECR_CEL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ECR.Reg) & 0xff0000) >> 16
}

// MCAN.MCAN_PSR: Protocol Status Register
func (o *MCAN_Type) SetMCAN_PSR_LEC(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetMCAN_PSR_LEC() uint32 {
	return volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x7
}
func (o *MCAN_Type) SetMCAN_PSR_ACT(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x18)|value<<3)
}
func (o *MCAN_Type) GetMCAN_PSR_ACT() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x18) >> 3
}
func (o *MCAN_Type) SetMCAN_PSR_EP(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_PSR_EP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_PSR_EW(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_PSR_EW() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_PSR_BO(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_PSR_BO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_PSR_DLEC(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x700)|value<<8)
}
func (o *MCAN_Type) GetMCAN_PSR_DLEC() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x700) >> 8
}
func (o *MCAN_Type) SetMCAN_PSR_RESI(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_PSR_RESI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_PSR_RBRS(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_PSR_RBRS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_PSR_RFDF(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_PSR_RFDF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_PSR_PXE(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_PSR_PXE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_PSR_TDCV(value uint32) {
	volatile.StoreUint32(&o.MCAN_PSR.Reg, volatile.LoadUint32(&o.MCAN_PSR.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_PSR_TDCV() uint32 {
	return (volatile.LoadUint32(&o.MCAN_PSR.Reg) & 0x7f0000) >> 16
}

// MCAN.MCAN_TDCR: Transmit Delay Compensation Register
func (o *MCAN_Type) SetMCAN_TDCR_TDCF(value uint32) {
	volatile.StoreUint32(&o.MCAN_TDCR.Reg, volatile.LoadUint32(&o.MCAN_TDCR.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetMCAN_TDCR_TDCF() uint32 {
	return volatile.LoadUint32(&o.MCAN_TDCR.Reg) & 0x7f
}
func (o *MCAN_Type) SetMCAN_TDCR_TDCO(value uint32) {
	volatile.StoreUint32(&o.MCAN_TDCR.Reg, volatile.LoadUint32(&o.MCAN_TDCR.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TDCR_TDCO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TDCR.Reg) & 0x7f00) >> 8
}

// MCAN.MCAN_IR: Interrupt Register
func (o *MCAN_Type) SetMCAN_IR_RF0N(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_IR_RF0N() uint32 {
	return volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_IR_RF0W(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_IR_RF0W() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_IR_RF0F(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_IR_RF0F() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_IR_RF0L(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_IR_RF0L() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_IR_RF1N(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_IR_RF1N() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_IR_RF1W(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_IR_RF1W() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_IR_RF1F(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_IR_RF1F() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_IR_RF1L(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_IR_RF1L() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_IR_HPM(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_IR_HPM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_IR_TC(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_IR_TC() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_IR_TCF(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_IR_TCF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_IR_TFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_IR_TFE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_IR_TEFN(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_IR_TEFN() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_IR_TEFW(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_IR_TEFW() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_IR_TEFF(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_IR_TEFF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_IR_TEFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_IR_TEFL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_IR_TSW(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_IR_TSW() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_IR_MRAF(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_IR_MRAF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_IR_TOO(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_IR_TOO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_IR_DRX(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_IR_DRX() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_IR_ELO(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_IR_ELO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_IR_EP(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_IR_EP() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_IR_EW(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_IR_EW() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_IR_BO(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_IR_BO() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_IR_WDI(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_IR_WDI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_IR_PEA(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_IR_PEA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_IR_PED(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_IR_PED() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_IR_ARA(value uint32) {
	volatile.StoreUint32(&o.MCAN_IR.Reg, volatile.LoadUint32(&o.MCAN_IR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_IR_ARA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IR.Reg) & 0x20000000) >> 29
}

// MCAN.MCAN_IE: Interrupt Enable Register
func (o *MCAN_Type) SetMCAN_IE_RF0NE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_IE_RF0NE() uint32 {
	return volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_IE_RF0WE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_IE_RF0WE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_IE_RF0FE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_IE_RF0FE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_IE_RF0LE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_IE_RF0LE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_IE_RF1NE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_IE_RF1NE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_IE_RF1WE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_IE_RF1WE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_IE_RF1FE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_IE_RF1FE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_IE_RF1LE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_IE_RF1LE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_IE_HPME(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_IE_HPME() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_IE_TCE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_IE_TCE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_IE_TCFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_IE_TCFE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_IE_TFEE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_IE_TFEE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_IE_TEFNE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_IE_TEFNE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_IE_TEFWE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_IE_TEFWE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_IE_TEFFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_IE_TEFFE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_IE_TEFLE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_IE_TEFLE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_IE_TSWE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_IE_TSWE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_IE_MRAFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_IE_MRAFE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_IE_TOOE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_IE_TOOE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_IE_DRXE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_IE_DRXE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_IE_ELOE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_IE_ELOE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_IE_EPE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_IE_EPE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_IE_EWE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_IE_EWE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_IE_BOE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_IE_BOE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_IE_WDIE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_IE_WDIE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_IE_PEAE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_IE_PEAE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_IE_PEDE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_IE_PEDE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_IE_ARAE(value uint32) {
	volatile.StoreUint32(&o.MCAN_IE.Reg, volatile.LoadUint32(&o.MCAN_IE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_IE_ARAE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_IE.Reg) & 0x20000000) >> 29
}

// MCAN.MCAN_ILS: Interrupt Line Select Register
func (o *MCAN_Type) SetMCAN_ILS_RF0NL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_ILS_RF0NL() uint32 {
	return volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_ILS_RF0WL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_ILS_RF0WL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_ILS_RF0FL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_ILS_RF0FL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_ILS_RF0LL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_ILS_RF0LL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_ILS_RF1NL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_ILS_RF1NL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_ILS_RF1WL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_ILS_RF1WL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_ILS_RF1FL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_ILS_RF1FL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_ILS_RF1LL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_ILS_RF1LL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_ILS_HPML(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_ILS_HPML() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_ILS_TCL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_ILS_TCL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_ILS_TCFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_ILS_TCFL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_ILS_TFEL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_ILS_TFEL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_ILS_TEFNL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_ILS_TEFNL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_ILS_TEFWL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_ILS_TEFWL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_ILS_TEFFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_ILS_TEFFL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_ILS_TEFLL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_ILS_TEFLL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_ILS_TSWL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_ILS_TSWL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_ILS_MRAFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_ILS_MRAFL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_ILS_TOOL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_ILS_TOOL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_ILS_DRXL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_ILS_DRXL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_ILS_ELOL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_ILS_ELOL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_ILS_EPL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_ILS_EPL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_ILS_EWL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_ILS_EWL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_ILS_BOL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_ILS_BOL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_ILS_WDIL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_ILS_WDIL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_ILS_PEAL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_ILS_PEAL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_ILS_PEDL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_ILS_PEDL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_ILS_ARAL(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILS.Reg, volatile.LoadUint32(&o.MCAN_ILS.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_ILS_ARAL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILS.Reg) & 0x20000000) >> 29
}

// MCAN.MCAN_ILE: Interrupt Line Enable Register
func (o *MCAN_Type) SetMCAN_ILE_EINT0(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILE.Reg, volatile.LoadUint32(&o.MCAN_ILE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_ILE_EINT0() uint32 {
	return volatile.LoadUint32(&o.MCAN_ILE.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_ILE_EINT1(value uint32) {
	volatile.StoreUint32(&o.MCAN_ILE.Reg, volatile.LoadUint32(&o.MCAN_ILE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_ILE_EINT1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_ILE.Reg) & 0x2) >> 1
}

// MCAN.MCAN_GFC: Global Filter Configuration Register
func (o *MCAN_Type) SetMCAN_GFC_RRFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_GFC.Reg, volatile.LoadUint32(&o.MCAN_GFC.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_GFC_RRFE() uint32 {
	return volatile.LoadUint32(&o.MCAN_GFC.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_GFC_RRFS(value uint32) {
	volatile.StoreUint32(&o.MCAN_GFC.Reg, volatile.LoadUint32(&o.MCAN_GFC.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_GFC_RRFS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_GFC.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_GFC_ANFE(value uint32) {
	volatile.StoreUint32(&o.MCAN_GFC.Reg, volatile.LoadUint32(&o.MCAN_GFC.Reg)&^(0xc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_GFC_ANFE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_GFC.Reg) & 0xc) >> 2
}
func (o *MCAN_Type) SetMCAN_GFC_ANFS(value uint32) {
	volatile.StoreUint32(&o.MCAN_GFC.Reg, volatile.LoadUint32(&o.MCAN_GFC.Reg)&^(0x30)|value<<4)
}
func (o *MCAN_Type) GetMCAN_GFC_ANFS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_GFC.Reg) & 0x30) >> 4
}

// MCAN.MCAN_SIDFC: Standard ID Filter Configuration Register
func (o *MCAN_Type) SetMCAN_SIDFC_FLSSA(value uint32) {
	volatile.StoreUint32(&o.MCAN_SIDFC.Reg, volatile.LoadUint32(&o.MCAN_SIDFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_SIDFC_FLSSA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_SIDFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_SIDFC_LSS(value uint32) {
	volatile.StoreUint32(&o.MCAN_SIDFC.Reg, volatile.LoadUint32(&o.MCAN_SIDFC.Reg)&^(0xff0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_SIDFC_LSS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_SIDFC.Reg) & 0xff0000) >> 16
}

// MCAN.MCAN_XIDFC: Extended ID Filter Configuration Register
func (o *MCAN_Type) SetMCAN_XIDFC_FLESA(value uint32) {
	volatile.StoreUint32(&o.MCAN_XIDFC.Reg, volatile.LoadUint32(&o.MCAN_XIDFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_XIDFC_FLESA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_XIDFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_XIDFC_LSE(value uint32) {
	volatile.StoreUint32(&o.MCAN_XIDFC.Reg, volatile.LoadUint32(&o.MCAN_XIDFC.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_XIDFC_LSE() uint32 {
	return (volatile.LoadUint32(&o.MCAN_XIDFC.Reg) & 0x7f0000) >> 16
}

// MCAN.MCAN_XIDAM: Extended ID AND Mask Register
func (o *MCAN_Type) SetMCAN_XIDAM_EIDM(value uint32) {
	volatile.StoreUint32(&o.MCAN_XIDAM.Reg, volatile.LoadUint32(&o.MCAN_XIDAM.Reg)&^(0x1fffffff)|value)
}
func (o *MCAN_Type) GetMCAN_XIDAM_EIDM() uint32 {
	return volatile.LoadUint32(&o.MCAN_XIDAM.Reg) & 0x1fffffff
}

// MCAN.MCAN_HPMS: High Priority Message Status Register
func (o *MCAN_Type) SetMCAN_HPMS_BIDX(value uint32) {
	volatile.StoreUint32(&o.MCAN_HPMS.Reg, volatile.LoadUint32(&o.MCAN_HPMS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetMCAN_HPMS_BIDX() uint32 {
	return volatile.LoadUint32(&o.MCAN_HPMS.Reg) & 0x3f
}
func (o *MCAN_Type) SetMCAN_HPMS_MSI(value uint32) {
	volatile.StoreUint32(&o.MCAN_HPMS.Reg, volatile.LoadUint32(&o.MCAN_HPMS.Reg)&^(0xc0)|value<<6)
}
func (o *MCAN_Type) GetMCAN_HPMS_MSI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_HPMS.Reg) & 0xc0) >> 6
}
func (o *MCAN_Type) SetMCAN_HPMS_FIDX(value uint32) {
	volatile.StoreUint32(&o.MCAN_HPMS.Reg, volatile.LoadUint32(&o.MCAN_HPMS.Reg)&^(0x7f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_HPMS_FIDX() uint32 {
	return (volatile.LoadUint32(&o.MCAN_HPMS.Reg) & 0x7f00) >> 8
}
func (o *MCAN_Type) SetMCAN_HPMS_FLST(value uint32) {
	volatile.StoreUint32(&o.MCAN_HPMS.Reg, volatile.LoadUint32(&o.MCAN_HPMS.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_HPMS_FLST() uint32 {
	return (volatile.LoadUint32(&o.MCAN_HPMS.Reg) & 0x8000) >> 15
}

// MCAN.MCAN_NDAT1: New Data 1 Register
func (o *MCAN_Type) SetMCAN_NDAT1_ND0(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND0() uint32 {
	return volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND1(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND2(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND3(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND4(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND5(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND6(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND7(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND8(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND9(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND10(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND11(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND12(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND13(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND14(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND15(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND16(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND17(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND18(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND19(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND20(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND21(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND22(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND23(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND24(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND25(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND26(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND27(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND28(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND29(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND30(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_NDAT1_ND31(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT1.Reg, volatile.LoadUint32(&o.MCAN_NDAT1.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_NDAT1_ND31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT1.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_NDAT2: New Data 2 Register
func (o *MCAN_Type) SetMCAN_NDAT2_ND32(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND32() uint32 {
	return volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND33(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND33() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND34(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND34() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND35(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND35() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND36(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND36() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND37(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND37() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND38(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND38() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND39(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND39() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND40(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND40() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND41(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND41() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND42(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND42() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND43(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND43() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND44(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND44() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND45(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND45() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND46(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND46() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND47(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND47() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND48(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND48() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND49(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND49() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND50(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND50() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND51(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND51() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND52(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND52() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND53(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND53() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND54(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND54() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND55(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND55() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND56(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND56() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND57(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND57() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND58(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND58() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND59(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND59() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND60(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND60() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND61(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND61() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND62(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND62() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_NDAT2_ND63(value uint32) {
	volatile.StoreUint32(&o.MCAN_NDAT2.Reg, volatile.LoadUint32(&o.MCAN_NDAT2.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_NDAT2_ND63() uint32 {
	return (volatile.LoadUint32(&o.MCAN_NDAT2.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_RXF0C: Receive FIFO 0 Configuration Register
func (o *MCAN_Type) SetMCAN_RXF0C_F0SA(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0C.Reg, volatile.LoadUint32(&o.MCAN_RXF0C.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_RXF0C_F0SA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0C.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_RXF0C_F0S(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0C.Reg, volatile.LoadUint32(&o.MCAN_RXF0C.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_RXF0C_F0S() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0C.Reg) & 0x7f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_RXF0C_F0WM(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0C.Reg, volatile.LoadUint32(&o.MCAN_RXF0C.Reg)&^(0x7f000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_RXF0C_F0WM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0C.Reg) & 0x7f000000) >> 24
}
func (o *MCAN_Type) SetMCAN_RXF0C_F0OM(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0C.Reg, volatile.LoadUint32(&o.MCAN_RXF0C.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_RXF0C_F0OM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0C.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_RXF0S: Receive FIFO 0 Status Register
func (o *MCAN_Type) SetMCAN_RXF0S_F0FL(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0S.Reg, volatile.LoadUint32(&o.MCAN_RXF0S.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetMCAN_RXF0S_F0FL() uint32 {
	return volatile.LoadUint32(&o.MCAN_RXF0S.Reg) & 0x7f
}
func (o *MCAN_Type) SetMCAN_RXF0S_F0GI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0S.Reg, volatile.LoadUint32(&o.MCAN_RXF0S.Reg)&^(0x3f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_RXF0S_F0GI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0S.Reg) & 0x3f00) >> 8
}
func (o *MCAN_Type) SetMCAN_RXF0S_F0PI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0S.Reg, volatile.LoadUint32(&o.MCAN_RXF0S.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_RXF0S_F0PI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0S.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_RXF0S_F0F(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0S.Reg, volatile.LoadUint32(&o.MCAN_RXF0S.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_RXF0S_F0F() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0S.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_RXF0S_RF0L(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0S.Reg, volatile.LoadUint32(&o.MCAN_RXF0S.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_RXF0S_RF0L() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF0S.Reg) & 0x2000000) >> 25
}

// MCAN.MCAN_RXF0A: Receive FIFO 0 Acknowledge Register
func (o *MCAN_Type) SetMCAN_RXF0A_F0AI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF0A.Reg, volatile.LoadUint32(&o.MCAN_RXF0A.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetMCAN_RXF0A_F0AI() uint32 {
	return volatile.LoadUint32(&o.MCAN_RXF0A.Reg) & 0x3f
}

// MCAN.MCAN_RXBC: Receive Rx Buffer Configuration Register
func (o *MCAN_Type) SetMCAN_RXBC_RBSA(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXBC.Reg, volatile.LoadUint32(&o.MCAN_RXBC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_RXBC_RBSA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXBC.Reg) & 0xfffc) >> 2
}

// MCAN.MCAN_RXF1C: Receive FIFO 1 Configuration Register
func (o *MCAN_Type) SetMCAN_RXF1C_F1SA(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1C.Reg, volatile.LoadUint32(&o.MCAN_RXF1C.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_RXF1C_F1SA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1C.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_RXF1C_F1S(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1C.Reg, volatile.LoadUint32(&o.MCAN_RXF1C.Reg)&^(0x7f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_RXF1C_F1S() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1C.Reg) & 0x7f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_RXF1C_F1WM(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1C.Reg, volatile.LoadUint32(&o.MCAN_RXF1C.Reg)&^(0x7f000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_RXF1C_F1WM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1C.Reg) & 0x7f000000) >> 24
}
func (o *MCAN_Type) SetMCAN_RXF1C_F1OM(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1C.Reg, volatile.LoadUint32(&o.MCAN_RXF1C.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_RXF1C_F1OM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1C.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_RXF1S: Receive FIFO 1 Status Register
func (o *MCAN_Type) SetMCAN_RXF1S_F1FL(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0x7f)|value)
}
func (o *MCAN_Type) GetMCAN_RXF1S_F1FL() uint32 {
	return volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0x7f
}
func (o *MCAN_Type) SetMCAN_RXF1S_F1GI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0x3f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_RXF1S_F1GI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0x3f00) >> 8
}
func (o *MCAN_Type) SetMCAN_RXF1S_F1PI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_RXF1S_F1PI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_RXF1S_F1F(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_RXF1S_F1F() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_RXF1S_RF1L(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_RXF1S_RF1L() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_RXF1S_DMS(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1S.Reg, volatile.LoadUint32(&o.MCAN_RXF1S.Reg)&^(0xc0000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_RXF1S_DMS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXF1S.Reg) & 0xc0000000) >> 30
}

// MCAN.MCAN_RXF1A: Receive FIFO 1 Acknowledge Register
func (o *MCAN_Type) SetMCAN_RXF1A_F1AI(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXF1A.Reg, volatile.LoadUint32(&o.MCAN_RXF1A.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetMCAN_RXF1A_F1AI() uint32 {
	return volatile.LoadUint32(&o.MCAN_RXF1A.Reg) & 0x3f
}

// MCAN.MCAN_RXESC: Receive Buffer / FIFO Element Size Configuration Register
func (o *MCAN_Type) SetMCAN_RXESC_F0DS(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXESC.Reg, volatile.LoadUint32(&o.MCAN_RXESC.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetMCAN_RXESC_F0DS() uint32 {
	return volatile.LoadUint32(&o.MCAN_RXESC.Reg) & 0x7
}
func (o *MCAN_Type) SetMCAN_RXESC_F1DS(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXESC.Reg, volatile.LoadUint32(&o.MCAN_RXESC.Reg)&^(0x70)|value<<4)
}
func (o *MCAN_Type) GetMCAN_RXESC_F1DS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXESC.Reg) & 0x70) >> 4
}
func (o *MCAN_Type) SetMCAN_RXESC_RBDS(value uint32) {
	volatile.StoreUint32(&o.MCAN_RXESC.Reg, volatile.LoadUint32(&o.MCAN_RXESC.Reg)&^(0x700)|value<<8)
}
func (o *MCAN_Type) GetMCAN_RXESC_RBDS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_RXESC.Reg) & 0x700) >> 8
}

// MCAN.MCAN_TXBC: Transmit Buffer Configuration Register
func (o *MCAN_Type) SetMCAN_TXBC_TBSA(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBC.Reg, volatile.LoadUint32(&o.MCAN_TXBC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBC_TBSA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBC_NDTB(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBC.Reg, volatile.LoadUint32(&o.MCAN_TXBC.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBC_NDTB() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBC.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBC_TFQS(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBC.Reg, volatile.LoadUint32(&o.MCAN_TXBC.Reg)&^(0x3f000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBC_TFQS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBC.Reg) & 0x3f000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBC_TFQM(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBC.Reg, volatile.LoadUint32(&o.MCAN_TXBC.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBC_TFQM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBC.Reg) & 0x40000000) >> 30
}

// MCAN.MCAN_TXFQS: Transmit FIFO/Queue Status Register
func (o *MCAN_Type) SetMCAN_TXFQS_TFFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXFQS.Reg, volatile.LoadUint32(&o.MCAN_TXFQS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetMCAN_TXFQS_TFFL() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXFQS.Reg) & 0x3f
}
func (o *MCAN_Type) SetMCAN_TXFQS_TFGI(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXFQS.Reg, volatile.LoadUint32(&o.MCAN_TXFQS.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXFQS_TFGI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXFQS.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetMCAN_TXFQS_TFQPI(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXFQS.Reg, volatile.LoadUint32(&o.MCAN_TXFQS.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXFQS_TFQPI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXFQS.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXFQS_TFQF(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXFQS.Reg, volatile.LoadUint32(&o.MCAN_TXFQS.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXFQS_TFQF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXFQS.Reg) & 0x200000) >> 21
}

// MCAN.MCAN_TXESC: Transmit Buffer Element Size Configuration Register
func (o *MCAN_Type) SetMCAN_TXESC_TBDS(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXESC.Reg, volatile.LoadUint32(&o.MCAN_TXESC.Reg)&^(0x7)|value)
}
func (o *MCAN_Type) GetMCAN_TXESC_TBDS() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXESC.Reg) & 0x7
}

// MCAN.MCAN_TXBRP: Transmit Buffer Request Pending Register
func (o *MCAN_Type) SetMCAN_TXBRP_TRP0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBRP_TRP31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBRP.Reg, volatile.LoadUint32(&o.MCAN_TXBRP.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBRP_TRP31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBRP.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBAR: Transmit Buffer Add Request Register
func (o *MCAN_Type) SetMCAN_TXBAR_AR0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBAR_AR31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBAR.Reg, volatile.LoadUint32(&o.MCAN_TXBAR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBAR_AR31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBAR.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBCR: Transmit Buffer Cancellation Request Register
func (o *MCAN_Type) SetMCAN_TXBCR_CR0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBCR_CR31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCR.Reg, volatile.LoadUint32(&o.MCAN_TXBCR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBCR_CR31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCR.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBTO: Transmit Buffer Transmission Occurred Register
func (o *MCAN_Type) SetMCAN_TXBTO_TO0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBTO_TO31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTO.Reg, volatile.LoadUint32(&o.MCAN_TXBTO.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBTO_TO31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTO.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBCF: Transmit Buffer Cancellation Finished Register
func (o *MCAN_Type) SetMCAN_TXBCF_CF0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBCF_CF31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCF.Reg, volatile.LoadUint32(&o.MCAN_TXBCF.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBCF_CF31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCF.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBTIE: Transmit Buffer Transmission Interrupt Enable Register
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBTIE_TIE31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBTIE.Reg, volatile.LoadUint32(&o.MCAN_TXBTIE.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBTIE_TIE31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBTIE.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXBCIE: Transmit Buffer Cancellation Finished Interrupt Enable Register
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE0(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x1)|value)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE0() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x1
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE1(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x2)|value<<1)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE1() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x2) >> 1
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE2(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x4)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE2() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x4) >> 2
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE3(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x8)|value<<3)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE3() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x8) >> 3
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE4(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x10)|value<<4)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE4() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x10) >> 4
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE5(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x20)|value<<5)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE5() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x20) >> 5
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE6(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x40)|value<<6)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE6() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x40) >> 6
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE7(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x80)|value<<7)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE7() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x80) >> 7
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE8(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x100)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE8() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x100) >> 8
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE9(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x200)|value<<9)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE9() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x200) >> 9
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE10(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x400)|value<<10)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE10() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x400) >> 10
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE11(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x800)|value<<11)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE11() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x800) >> 11
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE12(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x1000)|value<<12)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE12() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x1000) >> 12
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE13(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x2000)|value<<13)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE13() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x2000) >> 13
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE14(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x4000)|value<<14)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE14() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x4000) >> 14
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE15(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x8000)|value<<15)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE15() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x8000) >> 15
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE16(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x10000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE16() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x10000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE17(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x20000)|value<<17)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE17() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x20000) >> 17
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE18(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x40000)|value<<18)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE18() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x40000) >> 18
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE19(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x80000)|value<<19)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE19() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x80000) >> 19
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE20(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x100000)|value<<20)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE20() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x100000) >> 20
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE21(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x200000)|value<<21)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE21() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x200000) >> 21
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE22(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x400000)|value<<22)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE22() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x400000) >> 22
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE23(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x800000)|value<<23)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE23() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x800000) >> 23
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE24(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE24() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE25(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE25() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x2000000) >> 25
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE26(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x4000000)|value<<26)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE26() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x4000000) >> 26
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE27(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x8000000)|value<<27)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE27() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x8000000) >> 27
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE28(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x10000000)|value<<28)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE28() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x10000000) >> 28
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE29(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x20000000)|value<<29)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE29() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x20000000) >> 29
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE30(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x40000000)|value<<30)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE30() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x40000000) >> 30
}
func (o *MCAN_Type) SetMCAN_TXBCIE_CFIE31(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXBCIE.Reg, volatile.LoadUint32(&o.MCAN_TXBCIE.Reg)&^(0x80000000)|value<<31)
}
func (o *MCAN_Type) GetMCAN_TXBCIE_CFIE31() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXBCIE.Reg) & 0x80000000) >> 31
}

// MCAN.MCAN_TXEFC: Transmit Event FIFO Configuration Register
func (o *MCAN_Type) SetMCAN_TXEFC_EFSA(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFC.Reg, volatile.LoadUint32(&o.MCAN_TXEFC.Reg)&^(0xfffc)|value<<2)
}
func (o *MCAN_Type) GetMCAN_TXEFC_EFSA() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFC.Reg) & 0xfffc) >> 2
}
func (o *MCAN_Type) SetMCAN_TXEFC_EFS(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFC.Reg, volatile.LoadUint32(&o.MCAN_TXEFC.Reg)&^(0x3f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXEFC_EFS() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFC.Reg) & 0x3f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXEFC_EFWM(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFC.Reg, volatile.LoadUint32(&o.MCAN_TXEFC.Reg)&^(0x3f000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXEFC_EFWM() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFC.Reg) & 0x3f000000) >> 24
}

// MCAN.MCAN_TXEFS: Transmit Event FIFO Status Register
func (o *MCAN_Type) SetMCAN_TXEFS_EFFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFS.Reg, volatile.LoadUint32(&o.MCAN_TXEFS.Reg)&^(0x3f)|value)
}
func (o *MCAN_Type) GetMCAN_TXEFS_EFFL() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXEFS.Reg) & 0x3f
}
func (o *MCAN_Type) SetMCAN_TXEFS_EFGI(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFS.Reg, volatile.LoadUint32(&o.MCAN_TXEFS.Reg)&^(0x1f00)|value<<8)
}
func (o *MCAN_Type) GetMCAN_TXEFS_EFGI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFS.Reg) & 0x1f00) >> 8
}
func (o *MCAN_Type) SetMCAN_TXEFS_EFPI(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFS.Reg, volatile.LoadUint32(&o.MCAN_TXEFS.Reg)&^(0x1f0000)|value<<16)
}
func (o *MCAN_Type) GetMCAN_TXEFS_EFPI() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFS.Reg) & 0x1f0000) >> 16
}
func (o *MCAN_Type) SetMCAN_TXEFS_EFF(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFS.Reg, volatile.LoadUint32(&o.MCAN_TXEFS.Reg)&^(0x1000000)|value<<24)
}
func (o *MCAN_Type) GetMCAN_TXEFS_EFF() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFS.Reg) & 0x1000000) >> 24
}
func (o *MCAN_Type) SetMCAN_TXEFS_TEFL(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFS.Reg, volatile.LoadUint32(&o.MCAN_TXEFS.Reg)&^(0x2000000)|value<<25)
}
func (o *MCAN_Type) GetMCAN_TXEFS_TEFL() uint32 {
	return (volatile.LoadUint32(&o.MCAN_TXEFS.Reg) & 0x2000000) >> 25
}

// MCAN.MCAN_TXEFA: Transmit Event FIFO Acknowledge Register
func (o *MCAN_Type) SetMCAN_TXEFA_EFAI(value uint32) {
	volatile.StoreUint32(&o.MCAN_TXEFA.Reg, volatile.LoadUint32(&o.MCAN_TXEFA.Reg)&^(0x1f)|value)
}
func (o *MCAN_Type) GetMCAN_TXEFA_EFAI() uint32 {
	return volatile.LoadUint32(&o.MCAN_TXEFA.Reg) & 0x1f
}

// Parallel Input/Output Controller
type PIO_Type struct {
	PIO_PER     volatile.Register32 // 0x0
	PIO_PDR     volatile.Register32 // 0x4
	PIO_PSR     volatile.Register32 // 0x8
	_           [4]byte
	PIO_OER     volatile.Register32 // 0x10
	PIO_ODR     volatile.Register32 // 0x14
	PIO_OSR     volatile.Register32 // 0x18
	_           [4]byte
	PIO_IFER    volatile.Register32 // 0x20
	PIO_IFDR    volatile.Register32 // 0x24
	PIO_IFSR    volatile.Register32 // 0x28
	_           [4]byte
	PIO_SODR    volatile.Register32 // 0x30
	PIO_CODR    volatile.Register32 // 0x34
	PIO_ODSR    volatile.Register32 // 0x38
	PIO_PDSR    volatile.Register32 // 0x3C
	PIO_IER     volatile.Register32 // 0x40
	PIO_IDR     volatile.Register32 // 0x44
	PIO_IMR     volatile.Register32 // 0x48
	PIO_ISR     volatile.Register32 // 0x4C
	PIO_MDER    volatile.Register32 // 0x50
	PIO_MDDR    volatile.Register32 // 0x54
	PIO_MDSR    volatile.Register32 // 0x58
	_           [4]byte
	PIO_PUDR    volatile.Register32 // 0x60
	PIO_PUER    volatile.Register32 // 0x64
	PIO_PUSR    volatile.Register32 // 0x68
	_           [4]byte
	PIO_ABCDSR  [2]volatile.Register32 // 0x70
	_           [8]byte
	PIO_IFSCDR  volatile.Register32 // 0x80
	PIO_IFSCER  volatile.Register32 // 0x84
	PIO_IFSCSR  volatile.Register32 // 0x88
	PIO_SCDR    volatile.Register32 // 0x8C
	PIO_PPDDR   volatile.Register32 // 0x90
	PIO_PPDER   volatile.Register32 // 0x94
	PIO_PPDSR   volatile.Register32 // 0x98
	_           [4]byte
	PIO_OWER    volatile.Register32 // 0xA0
	PIO_OWDR    volatile.Register32 // 0xA4
	PIO_OWSR    volatile.Register32 // 0xA8
	_           [4]byte
	PIO_AIMER   volatile.Register32 // 0xB0
	PIO_AIMDR   volatile.Register32 // 0xB4
	PIO_AIMMR   volatile.Register32 // 0xB8
	_           [4]byte
	PIO_ESR     volatile.Register32 // 0xC0
	PIO_LSR     volatile.Register32 // 0xC4
	PIO_ELSR    volatile.Register32 // 0xC8
	_           [4]byte
	PIO_FELLSR  volatile.Register32 // 0xD0
	PIO_REHLSR  volatile.Register32 // 0xD4
	PIO_FRLHSR  volatile.Register32 // 0xD8
	_           [4]byte
	PIO_LOCKSR  volatile.Register32 // 0xE0
	PIO_WPMR    volatile.Register32 // 0xE4
	PIO_WPSR    volatile.Register32 // 0xE8
	_           [20]byte
	PIO_SCHMITT volatile.Register32 // 0x100
	_           [20]byte
	PIO_DRIVER  volatile.Register32 // 0x118
	_           [52]byte
	PIO_PCMR    volatile.Register32 // 0x150
	PIO_PCIER   volatile.Register32 // 0x154
	PIO_PCIDR   volatile.Register32 // 0x158
	PIO_PCIMR   volatile.Register32 // 0x15C
	PIO_PCISR   volatile.Register32 // 0x160
	PIO_PCRHR   volatile.Register32 // 0x164
}

// PIO.PIO_PER: PIO Enable Register
func (o *PIO_Type) SetPIO_PER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PER.Reg, volatile.LoadUint32(&o.PIO_PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PDR: PIO Disable Register
func (o *PIO_Type) SetPIO_PDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PDR.Reg, volatile.LoadUint32(&o.PIO_PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PSR: PIO Status Register
func (o *PIO_Type) SetPIO_PSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PSR.Reg, volatile.LoadUint32(&o.PIO_PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_OER: Output Enable Register
func (o *PIO_Type) SetPIO_OER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_OER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_OER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_OER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_OER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_OER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_OER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_OER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_OER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_OER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_OER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_OER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_OER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_OER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_OER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_OER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_OER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_OER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_OER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_OER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_OER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_OER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_OER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_OER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_OER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_OER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_OER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_OER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_OER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_OER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_OER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_OER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_OER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_OER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_OER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_OER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_OER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_OER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_OER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_OER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_OER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_OER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_OER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_OER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_OER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_OER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_OER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_OER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_OER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_OER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_OER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_OER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_OER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_OER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_OER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_OER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_OER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_OER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_OER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_OER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_OER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_OER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_OER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_OER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_OER.Reg, volatile.LoadUint32(&o.PIO_OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_OER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_OER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ODR: Output Disable Register
func (o *PIO_Type) SetPIO_ODR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ODR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ODR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ODR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ODR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ODR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ODR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ODR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ODR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ODR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ODR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ODR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ODR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ODR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ODR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ODR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ODR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ODR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ODR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ODR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ODR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ODR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ODR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ODR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ODR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ODR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ODR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ODR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ODR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ODR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ODR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ODR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ODR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ODR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ODR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ODR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ODR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ODR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ODR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ODR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ODR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ODR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ODR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ODR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ODR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ODR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ODR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ODR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ODR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ODR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ODR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ODR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ODR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ODR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ODR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ODR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ODR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ODR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ODR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ODR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ODR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ODR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ODR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_ODR.Reg, volatile.LoadUint32(&o.PIO_ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ODR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_OSR: Output Status Register
func (o *PIO_Type) SetPIO_OSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_OSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_OSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_OSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_OSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_OSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_OSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_OSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_OSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_OSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_OSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_OSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_OSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_OSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_OSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_OSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_OSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_OSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_OSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_OSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_OSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_OSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_OSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_OSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_OSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_OSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_OSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_OSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_OSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_OSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_OSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_OSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_OSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_OSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_OSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_OSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_OSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_OSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_OSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_OSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_OSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_OSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_OSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_OSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_OSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_OSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_OSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_OSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_OSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_OSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_OSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_OSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_OSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_OSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_OSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_OSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_OSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_OSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_OSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_OSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_OSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_OSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_OSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_OSR.Reg, volatile.LoadUint32(&o.PIO_OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_OSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_OSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetPIO_IFER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFER.Reg, volatile.LoadUint32(&o.PIO_IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetPIO_IFDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFDR.Reg, volatile.LoadUint32(&o.PIO_IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetPIO_IFSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSR.Reg, volatile.LoadUint32(&o.PIO_IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_SODR: Set Output Data Register
func (o *PIO_Type) SetPIO_SODR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_SODR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_SODR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_SODR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_SODR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_SODR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_SODR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_SODR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_SODR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_SODR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_SODR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_SODR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_SODR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_SODR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_SODR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_SODR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_SODR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_SODR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_SODR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_SODR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_SODR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_SODR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_SODR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_SODR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_SODR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_SODR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_SODR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_SODR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_SODR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_SODR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_SODR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_SODR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_SODR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_SODR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_SODR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_SODR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_SODR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_SODR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_SODR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_SODR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_SODR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_SODR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_SODR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_SODR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_SODR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_SODR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_SODR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_SODR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_SODR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_SODR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_SODR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_SODR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_SODR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_SODR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_SODR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_SODR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_SODR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_SODR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_SODR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_SODR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_SODR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_SODR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_SODR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_SODR.Reg, volatile.LoadUint32(&o.PIO_SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_SODR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_SODR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_CODR: Clear Output Data Register
func (o *PIO_Type) SetPIO_CODR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_CODR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_CODR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_CODR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_CODR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_CODR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_CODR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_CODR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_CODR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_CODR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_CODR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_CODR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_CODR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_CODR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_CODR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_CODR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_CODR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_CODR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_CODR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_CODR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_CODR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_CODR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_CODR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_CODR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_CODR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_CODR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_CODR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_CODR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_CODR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_CODR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_CODR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_CODR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_CODR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_CODR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_CODR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_CODR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_CODR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_CODR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_CODR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_CODR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_CODR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_CODR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_CODR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_CODR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_CODR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_CODR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_CODR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_CODR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_CODR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_CODR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_CODR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_CODR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_CODR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_CODR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_CODR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_CODR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_CODR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_CODR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_CODR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_CODR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_CODR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_CODR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_CODR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_CODR.Reg, volatile.LoadUint32(&o.PIO_CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_CODR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_CODR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ODSR: Output Data Status Register
func (o *PIO_Type) SetPIO_ODSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ODSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ODSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ODSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ODSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ODSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ODSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ODSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ODSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ODSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ODSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ODSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ODSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ODSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ODSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ODSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ODSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ODSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ODSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ODSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ODSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ODSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ODSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ODSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ODSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ODSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ODSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ODSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ODSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ODSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ODSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ODSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ODSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_ODSR.Reg, volatile.LoadUint32(&o.PIO_ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PDSR: Pin Data Status Register
func (o *PIO_Type) SetPIO_PDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PDSR.Reg, volatile.LoadUint32(&o.PIO_PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PDSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IER: Interrupt Enable Register
func (o *PIO_Type) SetPIO_IER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IER.Reg, volatile.LoadUint32(&o.PIO_IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IDR: Interrupt Disable Register
func (o *PIO_Type) SetPIO_IDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IDR.Reg, volatile.LoadUint32(&o.PIO_IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IMR: Interrupt Mask Register
func (o *PIO_Type) SetPIO_IMR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IMR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IMR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IMR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IMR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IMR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IMR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IMR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IMR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IMR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IMR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IMR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IMR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IMR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IMR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IMR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IMR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IMR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IMR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IMR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IMR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IMR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IMR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IMR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IMR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IMR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IMR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IMR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IMR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IMR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IMR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IMR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IMR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IMR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IMR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IMR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IMR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IMR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IMR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IMR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IMR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IMR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IMR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IMR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IMR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IMR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IMR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IMR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IMR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IMR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IMR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IMR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IMR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IMR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IMR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IMR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IMR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IMR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IMR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IMR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IMR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IMR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IMR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IMR.Reg, volatile.LoadUint32(&o.PIO_IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IMR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IMR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ISR: Interrupt Status Register
func (o *PIO_Type) SetPIO_ISR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ISR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ISR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ISR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ISR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ISR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ISR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ISR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ISR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ISR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ISR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ISR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ISR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ISR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ISR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ISR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ISR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ISR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ISR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ISR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ISR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ISR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ISR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ISR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ISR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ISR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ISR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ISR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ISR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ISR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ISR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ISR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ISR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ISR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ISR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ISR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ISR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ISR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ISR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ISR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ISR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ISR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ISR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ISR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ISR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ISR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ISR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ISR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ISR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ISR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ISR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ISR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ISR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ISR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ISR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ISR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ISR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ISR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ISR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ISR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ISR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ISR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ISR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_ISR.Reg, volatile.LoadUint32(&o.PIO_ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ISR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_ISR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_MDER: Multi-driver Enable Register
func (o *PIO_Type) SetPIO_MDER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_MDER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_MDER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_MDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_MDER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_MDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_MDER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_MDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_MDER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_MDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_MDER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_MDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_MDER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_MDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_MDER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_MDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_MDER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_MDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_MDER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_MDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_MDER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_MDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_MDER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_MDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_MDER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_MDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_MDER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_MDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_MDER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_MDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_MDER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_MDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_MDER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_MDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_MDER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_MDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_MDER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_MDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_MDER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_MDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_MDER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_MDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_MDER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_MDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_MDER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_MDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_MDER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_MDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_MDER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_MDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_MDER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_MDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_MDER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_MDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_MDER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_MDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_MDER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_MDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_MDER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_MDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_MDER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_MDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_MDER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_MDER.Reg, volatile.LoadUint32(&o.PIO_MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_MDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetPIO_MDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_MDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_MDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_MDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_MDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_MDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_MDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_MDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_MDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_MDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_MDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_MDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_MDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_MDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_MDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_MDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_MDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_MDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_MDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_MDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_MDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_MDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_MDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_MDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_MDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_MDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_MDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_MDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_MDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_MDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_MDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_MDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_MDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_MDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_MDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_MDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_MDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_MDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_MDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_MDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_MDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_MDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_MDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_MDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_MDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_MDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_MDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_MDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_MDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_MDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_MDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_MDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_MDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_MDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_MDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_MDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_MDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_MDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_MDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_MDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_MDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_MDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_MDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_MDDR.Reg, volatile.LoadUint32(&o.PIO_MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_MDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_MDSR: Multi-driver Status Register
func (o *PIO_Type) SetPIO_MDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_MDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_MDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_MDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_MDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_MDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_MDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_MDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_MDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_MDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_MDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_MDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_MDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_MDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_MDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_MDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_MDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_MDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_MDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_MDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_MDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_MDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_MDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_MDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_MDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_MDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_MDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_MDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_MDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_MDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_MDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_MDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_MDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_MDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_MDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_MDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_MDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_MDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_MDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_MDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_MDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_MDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_MDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_MDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_MDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_MDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_MDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_MDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_MDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_MDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_MDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_MDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_MDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_MDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_MDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_MDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_MDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_MDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_MDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_MDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_MDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_MDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_MDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_MDSR.Reg, volatile.LoadUint32(&o.PIO_MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_MDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPIO_PUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PUDR.Reg, volatile.LoadUint32(&o.PIO_PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PUER: Pull-up Enable Register
func (o *PIO_Type) SetPIO_PUER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PUER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PUER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PUER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PUER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PUER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PUER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PUER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PUER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PUER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PUER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PUER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PUER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PUER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PUER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PUER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PUER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PUER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PUER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PUER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PUER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PUER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PUER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PUER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PUER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PUER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PUER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PUER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PUER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PUER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PUER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PUER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PUER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PUER.Reg, volatile.LoadUint32(&o.PIO_PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPIO_PUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PUSR.Reg, volatile.LoadUint32(&o.PIO_PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PUSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ABCDSR: Peripheral ABCD Select Register 0
func (o *PIO_Type) SetPIO_ABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.PIO_ABCDSR[idx].Reg, volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIO_ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetPIO_IFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCDR.Reg, volatile.LoadUint32(&o.PIO_IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetPIO_IFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCER.Reg, volatile.LoadUint32(&o.PIO_IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetPIO_IFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_IFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_IFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_IFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_IFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_IFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_IFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_IFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_IFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_IFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_IFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_IFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_IFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_IFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_IFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_IFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_IFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_IFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_IFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_IFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_IFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_IFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_IFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_IFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_IFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_IFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_IFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_IFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_IFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_IFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_IFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_IFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_IFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_IFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_IFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_IFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_IFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_IFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_IFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_IFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_IFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_IFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_IFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_IFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_IFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_IFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_IFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_IFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_IFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_IFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_IFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_IFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_IFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_IFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_IFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_IFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_IFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_IFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_IFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_IFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_IFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_IFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_IFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_IFSCSR.Reg, volatile.LoadUint32(&o.PIO_IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_IFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetPIO_SCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO_SCDR.Reg, volatile.LoadUint32(&o.PIO_SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetPIO_SCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.PIO_SCDR.Reg) & 0x3fff
}

// PIO.PIO_PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPIO_PPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDDR.Reg, volatile.LoadUint32(&o.PIO_PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPIO_PPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDER.Reg, volatile.LoadUint32(&o.PIO_PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPIO_PPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_PPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_PPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_PPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_PPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_PPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_PPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_PPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_PPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_PPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_PPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_PPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_PPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_PPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_PPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_PPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_PPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_PPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_PPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_PPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_PPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_PPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_PPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_PPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_PPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_PPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_PPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_PPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_PPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_PPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_PPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_PPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_PPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_PPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_PPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_PPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_PPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_PPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_PPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_PPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_PPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_PPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_PPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_PPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_PPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_PPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_PPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_PPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_PPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_PPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_PPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_PPDSR.Reg, volatile.LoadUint32(&o.PIO_PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_PPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_OWER: Output Write Enable
func (o *PIO_Type) SetPIO_OWER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_OWER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_OWER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_OWER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_OWER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_OWER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_OWER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_OWER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_OWER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_OWER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_OWER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_OWER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_OWER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_OWER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_OWER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_OWER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_OWER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_OWER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_OWER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_OWER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_OWER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_OWER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_OWER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_OWER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_OWER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_OWER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_OWER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_OWER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_OWER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_OWER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_OWER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_OWER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_OWER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_OWER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_OWER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_OWER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_OWER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_OWER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_OWER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_OWER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_OWER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_OWER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_OWER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_OWER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_OWER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_OWER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_OWER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_OWER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_OWER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_OWER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_OWER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_OWER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_OWER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_OWER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_OWER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_OWER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_OWER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_OWER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_OWER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_OWER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_OWER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_OWER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_OWER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_OWER.Reg, volatile.LoadUint32(&o.PIO_OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_OWER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_OWDR: Output Write Disable
func (o *PIO_Type) SetPIO_OWDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_OWDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_OWDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_OWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_OWDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_OWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_OWDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_OWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_OWDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_OWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_OWDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_OWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_OWDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_OWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_OWDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_OWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_OWDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_OWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_OWDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_OWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_OWDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_OWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_OWDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_OWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_OWDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_OWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_OWDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_OWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_OWDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_OWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_OWDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_OWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_OWDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_OWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_OWDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_OWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_OWDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_OWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_OWDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_OWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_OWDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_OWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_OWDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_OWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_OWDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_OWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_OWDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_OWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_OWDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_OWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_OWDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_OWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_OWDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_OWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_OWDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_OWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_OWDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_OWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_OWDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_OWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_OWDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_OWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_OWDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_OWDR.Reg, volatile.LoadUint32(&o.PIO_OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_OWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_OWSR: Output Write Status Register
func (o *PIO_Type) SetPIO_OWSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_OWSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_OWSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_OWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_OWSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_OWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_OWSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_OWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_OWSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_OWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_OWSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_OWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_OWSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_OWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_OWSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_OWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_OWSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_OWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_OWSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_OWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_OWSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_OWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_OWSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_OWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_OWSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_OWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_OWSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_OWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_OWSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_OWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_OWSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_OWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_OWSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_OWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_OWSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_OWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_OWSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_OWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_OWSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_OWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_OWSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_OWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_OWSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_OWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_OWSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_OWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_OWSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_OWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_OWSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_OWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_OWSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_OWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_OWSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_OWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_OWSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_OWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_OWSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_OWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_OWSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_OWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_OWSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_OWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_OWSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_OWSR.Reg, volatile.LoadUint32(&o.PIO_OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_OWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_OWSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetPIO_AIMER_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_AIMER_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_AIMER_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_AIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_AIMER_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_AIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_AIMER_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_AIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_AIMER_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_AIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_AIMER_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_AIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_AIMER_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_AIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_AIMER_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_AIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_AIMER_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_AIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_AIMER_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_AIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_AIMER_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_AIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_AIMER_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_AIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_AIMER_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_AIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_AIMER_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_AIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_AIMER_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_AIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_AIMER_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_AIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_AIMER_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_AIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_AIMER_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_AIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_AIMER_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_AIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_AIMER_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_AIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_AIMER_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_AIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_AIMER_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_AIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_AIMER_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_AIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_AIMER_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_AIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_AIMER_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_AIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_AIMER_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_AIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_AIMER_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_AIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_AIMER_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_AIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_AIMER_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_AIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_AIMER_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_AIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_AIMER_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_AIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_AIMER_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMER.Reg, volatile.LoadUint32(&o.PIO_AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_AIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_AIMDR: Additional Interrupt Modes Disable Register
func (o *PIO_Type) SetPIO_AIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_AIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_AIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_AIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_AIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_AIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_AIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_AIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_AIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_AIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_AIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_AIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_AIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_AIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_AIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_AIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_AIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_AIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_AIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_AIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_AIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_AIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_AIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_AIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_AIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_AIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_AIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_AIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_AIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_AIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_AIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_AIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_AIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_AIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_AIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_AIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_AIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_AIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_AIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_AIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_AIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_AIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_AIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_AIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_AIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_AIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_AIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_AIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_AIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_AIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_AIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_AIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_AIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_AIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_AIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_AIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_AIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_AIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_AIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_AIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_AIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_AIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_AIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMDR.Reg, volatile.LoadUint32(&o.PIO_AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_AIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetPIO_AIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_AIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_AIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_AIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_AIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_AIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_AIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_AIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_AIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_AIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_AIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_AIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_AIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_AIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_AIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_AIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_AIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_AIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_AIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_AIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_AIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_AIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_AIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_AIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_AIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_AIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_AIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_AIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_AIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_AIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_AIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_AIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_AIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_AIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_AIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_AIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_AIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_AIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_AIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_AIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_AIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_AIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_AIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_AIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_AIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_AIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_AIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_AIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_AIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_AIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_AIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_AIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_AIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_AIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_AIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_AIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_AIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_AIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_AIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_AIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_AIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_AIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_AIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_AIMMR.Reg, volatile.LoadUint32(&o.PIO_AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_AIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ESR: Edge Select Register
func (o *PIO_Type) SetPIO_ESR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ESR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ESR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ESR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ESR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ESR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ESR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ESR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ESR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ESR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ESR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ESR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ESR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ESR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ESR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ESR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ESR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ESR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ESR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ESR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ESR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ESR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ESR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ESR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ESR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ESR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ESR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ESR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ESR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ESR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ESR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ESR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ESR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ESR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ESR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ESR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ESR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ESR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ESR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ESR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ESR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ESR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ESR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ESR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ESR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ESR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ESR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ESR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ESR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ESR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ESR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ESR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ESR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ESR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ESR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ESR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ESR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ESR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ESR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ESR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ESR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ESR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ESR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_ESR.Reg, volatile.LoadUint32(&o.PIO_ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ESR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_ESR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_LSR: Level Select Register
func (o *PIO_Type) SetPIO_LSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_LSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_LSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_LSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_LSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_LSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_LSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_LSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_LSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_LSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_LSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_LSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_LSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_LSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_LSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_LSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_LSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_LSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_LSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_LSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_LSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_LSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_LSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_LSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_LSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_LSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_LSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_LSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_LSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_LSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_LSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_LSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_LSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_LSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_LSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_LSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_LSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_LSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_LSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_LSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_LSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_LSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_LSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_LSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_LSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_LSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_LSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_LSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_LSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_LSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_LSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_LSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_LSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_LSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_LSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_LSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_LSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_LSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_LSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_LSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_LSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_LSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_LSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_LSR.Reg, volatile.LoadUint32(&o.PIO_LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_LSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_LSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_ELSR: Edge/Level Status Register
func (o *PIO_Type) SetPIO_ELSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_ELSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_ELSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_ELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_ELSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_ELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_ELSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_ELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_ELSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_ELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_ELSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_ELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_ELSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_ELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_ELSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_ELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_ELSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_ELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_ELSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_ELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_ELSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_ELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_ELSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_ELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_ELSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_ELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_ELSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_ELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_ELSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_ELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_ELSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_ELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_ELSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_ELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_ELSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_ELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_ELSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_ELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_ELSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_ELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_ELSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_ELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_ELSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_ELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_ELSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_ELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_ELSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_ELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_ELSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_ELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_ELSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_ELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_ELSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_ELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_ELSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_ELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_ELSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_ELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_ELSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_ELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_ELSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_ELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_ELSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_ELSR.Reg, volatile.LoadUint32(&o.PIO_ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_ELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_ELSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_FELLSR: Falling Edge/Low-Level Select Register
func (o *PIO_Type) SetPIO_FELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_FELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_FELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_FELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_FELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_FELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_FELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_FELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_FELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_FELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_FELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_FELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_FELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_FELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_FELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_FELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_FELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_FELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_FELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_FELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_FELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_FELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_FELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_FELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_FELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_FELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_FELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_FELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_FELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_FELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_FELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_FELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_FELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_FELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_FELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_FELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_FELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_FELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_FELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_FELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_FELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_FELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_FELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_FELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_FELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_FELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_FELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_FELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_FELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_FELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_FELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_FELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_FELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_FELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_FELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_FELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_FELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_FELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_FELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_FELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_FELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_FELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_FELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_FELLSR.Reg, volatile.LoadUint32(&o.PIO_FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_FELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_REHLSR: Rising Edge/High-Level Select Register
func (o *PIO_Type) SetPIO_REHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_REHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_REHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_REHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_REHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_REHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_REHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_REHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_REHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_REHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_REHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_REHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_REHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_REHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_REHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_REHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_REHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_REHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_REHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_REHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_REHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_REHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_REHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_REHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_REHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_REHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_REHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_REHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_REHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_REHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_REHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_REHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_REHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_REHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_REHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_REHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_REHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_REHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_REHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_REHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_REHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_REHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_REHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_REHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_REHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_REHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_REHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_REHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_REHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_REHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_REHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_REHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_REHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_REHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_REHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_REHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_REHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_REHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_REHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_REHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_REHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_REHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_REHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_REHLSR.Reg, volatile.LoadUint32(&o.PIO_REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_REHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetPIO_FRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_FRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_FRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_FRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_FRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_FRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_FRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_FRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_FRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_FRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_FRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_FRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_FRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_FRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_FRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_FRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_FRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_FRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_FRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_FRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_FRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_FRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_FRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_FRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_FRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_FRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_FRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_FRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_FRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_FRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_FRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_FRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_FRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_FRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_FRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_FRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_FRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_FRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_FRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_FRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_FRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_FRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_FRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_FRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_FRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_FRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_FRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_FRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_FRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_FRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_FRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_FRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_FRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_FRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_FRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_FRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_FRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_FRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_FRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_FRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_FRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_FRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_FRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_FRLHSR.Reg, volatile.LoadUint32(&o.PIO_FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_FRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_LOCKSR: Lock Status
func (o *PIO_Type) SetPIO_LOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_LOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_LOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_LOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_LOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_LOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_LOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_LOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_LOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_LOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_LOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_LOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_LOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_LOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_LOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_LOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_LOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_LOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_LOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_LOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_LOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_LOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_LOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_LOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_LOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_LOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_LOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_LOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_LOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_LOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_LOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_LOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_LOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_LOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_LOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_LOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_LOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_LOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_LOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_LOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_LOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_LOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_LOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_LOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_LOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_LOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_LOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_LOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_LOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_LOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_LOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_LOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_LOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_LOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_LOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_LOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_LOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_LOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_LOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_LOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_LOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_LOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_LOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.PIO_LOCKSR.Reg, volatile.LoadUint32(&o.PIO_LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_LOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PIO_LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.PIO_WPMR: Write Protection Mode Register
func (o *PIO_Type) SetPIO_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PIO_WPMR.Reg, volatile.LoadUint32(&o.PIO_WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PIO_WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PIO_WPMR.Reg, volatile.LoadUint32(&o.PIO_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetPIO_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PIO_WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.PIO_WPSR: Write Protection Status Register
func (o *PIO_Type) SetPIO_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PIO_WPSR.Reg, volatile.LoadUint32(&o.PIO_WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PIO_WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PIO_WPSR.Reg, volatile.LoadUint32(&o.PIO_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetPIO_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PIO_WPSR.Reg) & 0xffff00) >> 8
}

// PIO.PIO_SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_SCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.PIO_SCHMITT.Reg, volatile.LoadUint32(&o.PIO_SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_SCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.PIO_SCHMITT.Reg) & 0x80000000) >> 31
}

// PIO.PIO_DRIVER: I/O Drive Register
func (o *PIO_Type) SetPIO_DRIVER_LINE0(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE0() uint32 {
	return volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_DRIVER_LINE1(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE1() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_DRIVER_LINE2(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE2() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_DRIVER_LINE3(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE3() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPIO_DRIVER_LINE4(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE4() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPIO_DRIVER_LINE5(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE5() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPIO_DRIVER_LINE6(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE6() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPIO_DRIVER_LINE7(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE7() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPIO_DRIVER_LINE8(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE8() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPIO_DRIVER_LINE9(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE9() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_DRIVER_LINE10(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE10() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_DRIVER_LINE11(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE11() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPIO_DRIVER_LINE12(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE12() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPIO_DRIVER_LINE13(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE13() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPIO_DRIVER_LINE14(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE14() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPIO_DRIVER_LINE15(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE15() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPIO_DRIVER_LINE16(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE16() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPIO_DRIVER_LINE17(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE17() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPIO_DRIVER_LINE18(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE18() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPIO_DRIVER_LINE19(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE19() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPIO_DRIVER_LINE20(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE20() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPIO_DRIVER_LINE21(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE21() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPIO_DRIVER_LINE22(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE22() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPIO_DRIVER_LINE23(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE23() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPIO_DRIVER_LINE24(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE24() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPIO_DRIVER_LINE25(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE25() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPIO_DRIVER_LINE26(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE26() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPIO_DRIVER_LINE27(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE27() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPIO_DRIVER_LINE28(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE28() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPIO_DRIVER_LINE29(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE29() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPIO_DRIVER_LINE30(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE30() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPIO_DRIVER_LINE31(value uint32) {
	volatile.StoreUint32(&o.PIO_DRIVER.Reg, volatile.LoadUint32(&o.PIO_DRIVER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPIO_DRIVER_LINE31() uint32 {
	return (volatile.LoadUint32(&o.PIO_DRIVER.Reg) & 0x80000000) >> 31
}

// PIO.PIO_PCMR: Parallel Capture Mode Register
func (o *PIO_Type) SetPIO_PCMR_PCEN(value uint32) {
	volatile.StoreUint32(&o.PIO_PCMR.Reg, volatile.LoadUint32(&o.PIO_PCMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PCMR_PCEN() uint32 {
	return volatile.LoadUint32(&o.PIO_PCMR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PCMR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.PIO_PCMR.Reg, volatile.LoadUint32(&o.PIO_PCMR.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetPIO_PCMR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCMR.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetPIO_PCMR_ALWYS(value uint32) {
	volatile.StoreUint32(&o.PIO_PCMR.Reg, volatile.LoadUint32(&o.PIO_PCMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPIO_PCMR_ALWYS() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPIO_PCMR_HALFS(value uint32) {
	volatile.StoreUint32(&o.PIO_PCMR.Reg, volatile.LoadUint32(&o.PIO_PCMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPIO_PCMR_HALFS() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPIO_PCMR_FRSTS(value uint32) {
	volatile.StoreUint32(&o.PIO_PCMR.Reg, volatile.LoadUint32(&o.PIO_PCMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPIO_PCMR_FRSTS() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCMR.Reg) & 0x800) >> 11
}

// PIO.PIO_PCIER: Parallel Capture Interrupt Enable Register
func (o *PIO_Type) SetPIO_PCIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIER.Reg, volatile.LoadUint32(&o.PIO_PCIER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PCIER_DRDY() uint32 {
	return volatile.LoadUint32(&o.PIO_PCIER.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PCIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIER.Reg, volatile.LoadUint32(&o.PIO_PCIER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PCIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PCIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIER.Reg, volatile.LoadUint32(&o.PIO_PCIER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PCIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PCIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIER.Reg, volatile.LoadUint32(&o.PIO_PCIER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PCIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIER.Reg) & 0x8) >> 3
}

// PIO.PIO_PCIDR: Parallel Capture Interrupt Disable Register
func (o *PIO_Type) SetPIO_PCIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIDR.Reg, volatile.LoadUint32(&o.PIO_PCIDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PCIDR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PIO_PCIDR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PCIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIDR.Reg, volatile.LoadUint32(&o.PIO_PCIDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PCIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PCIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIDR.Reg, volatile.LoadUint32(&o.PIO_PCIDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PCIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PCIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIDR.Reg, volatile.LoadUint32(&o.PIO_PCIDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PCIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIDR.Reg) & 0x8) >> 3
}

// PIO.PIO_PCIMR: Parallel Capture Interrupt Mask Register
func (o *PIO_Type) SetPIO_PCIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIMR.Reg, volatile.LoadUint32(&o.PIO_PCIMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PCIMR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PIO_PCIMR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PCIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIMR.Reg, volatile.LoadUint32(&o.PIO_PCIMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PCIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPIO_PCIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIMR.Reg, volatile.LoadUint32(&o.PIO_PCIMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPIO_PCIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPIO_PCIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PIO_PCIMR.Reg, volatile.LoadUint32(&o.PIO_PCIMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPIO_PCIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCIMR.Reg) & 0x8) >> 3
}

// PIO.PIO_PCISR: Parallel Capture Interrupt Status Register
func (o *PIO_Type) SetPIO_PCISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PIO_PCISR.Reg, volatile.LoadUint32(&o.PIO_PCISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPIO_PCISR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PIO_PCISR.Reg) & 0x1
}
func (o *PIO_Type) SetPIO_PCISR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PIO_PCISR.Reg, volatile.LoadUint32(&o.PIO_PCISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPIO_PCISR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PIO_PCISR.Reg) & 0x2) >> 1
}

// PIO.PIO_PCRHR: Parallel Capture Reception Holding Register
func (o *PIO_Type) SetPIO_PCRHR(value uint32) {
	volatile.StoreUint32(&o.PIO_PCRHR.Reg, value)
}
func (o *PIO_Type) GetPIO_PCRHR() uint32 {
	return volatile.LoadUint32(&o.PIO_PCRHR.Reg)
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER       volatile.Register32 // 0x0
	PMC_SCDR       volatile.Register32 // 0x4
	PMC_SCSR       volatile.Register32 // 0x8
	_              [4]byte
	PMC_PCER0      volatile.Register32 // 0x10
	PMC_PCDR0      volatile.Register32 // 0x14
	PMC_PCSR0      volatile.Register32 // 0x18
	CKGR_UCKR      volatile.Register32 // 0x1C
	CKGR_MOR       volatile.Register32 // 0x20
	CKGR_MCFR      volatile.Register32 // 0x24
	CKGR_PLLAR     volatile.Register32 // 0x28
	_              [4]byte
	PMC_MCKR       volatile.Register32 // 0x30
	_              [4]byte
	PMC_USB        volatile.Register32 // 0x38
	_              [4]byte
	PMC_PCK        [8]volatile.Register32 // 0x40
	PMC_IER        volatile.Register32    // 0x60
	PMC_IDR        volatile.Register32    // 0x64
	PMC_SR         volatile.Register32    // 0x68
	PMC_IMR        volatile.Register32    // 0x6C
	PMC_FSMR       volatile.Register32    // 0x70
	PMC_FSPR       volatile.Register32    // 0x74
	PMC_FOCR       volatile.Register32    // 0x78
	_              [104]byte
	PMC_WPMR       volatile.Register32 // 0xE4
	PMC_WPSR       volatile.Register32 // 0xE8
	_              [20]byte
	PMC_PCER1      volatile.Register32 // 0x100
	PMC_PCDR1      volatile.Register32 // 0x104
	PMC_PCSR1      volatile.Register32 // 0x108
	PMC_PCR        volatile.Register32 // 0x10C
	PMC_OCR        volatile.Register32 // 0x110
	PMC_SLPWK_ER0  volatile.Register32 // 0x114
	PMC_SLPWK_DR0  volatile.Register32 // 0x118
	PMC_SLPWK_SR0  volatile.Register32 // 0x11C
	PMC_SLPWK_ASR0 volatile.Register32 // 0x120
	_              [12]byte
	PMC_PMMR       volatile.Register32 // 0x130
	PMC_SLPWK_ER1  volatile.Register32 // 0x134
	PMC_SLPWK_DR1  volatile.Register32 // 0x138
	PMC_SLPWK_SR1  volatile.Register32 // 0x13C
	PMC_SLPWK_ASR1 volatile.Register32 // 0x140
	PMC_SLPWK_AIPR volatile.Register32 // 0x144
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_USBCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCER_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCER_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCER_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCER_PCK4(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SCER_PCK4() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SCER_PCK5(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SCER_PCK5() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SCER_PCK6(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SCER_PCK6() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SCER_PCK7(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SCER_PCK7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x8000) >> 15
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCDR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCDR_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCDR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCDR_PCK4(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SCDR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SCDR_PCK5(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SCDR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SCDR_PCK6(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SCDR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SCDR_PCK7(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SCDR_PCK7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x8000) >> 15
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_HCLKS(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SCSR_HCLKS() uint32 {
	return volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SCSR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCSR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCSR_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCSR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCSR_PCK4(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SCSR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SCSR_PCK5(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SCSR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SCSR_PCK6(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SCSR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SCSR_PCK7(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SCSR_PCK7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x8000) >> 15
}

// PMC.PMC_PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPMC_PCER0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPMC_PCDR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCDR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCDR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCDR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPMC_PCSR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCSR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCSR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCSR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_UCKR: UTMI Clock Register
func (o *PMC_Type) SetCKGR_UCKR_UPLLEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_UCKR_UPLLCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0xf00000)|value<<20)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0xf00000) >> 20
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_WAITMODE(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetCKGR_MOR_WAITMODE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetCKGR_MOR_XT32KFME(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetCKGR_MOR_XT32KFME() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4000000) >> 26
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_MCFR_RCMEAS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetCKGR_MCFR_RCMEAS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetCKGR_MCFR_CCSS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MCFR_CCSS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x1000000) >> 24
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetPMC_MCKR_MDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x300)|value<<8)
}
func (o *PMC_Type) GetPMC_MCKR_MDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x300) >> 8
}
func (o *PMC_Type) SetPMC_MCKR_UPLLDIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_MCKR_UPLLDIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x2000) >> 13
}

// PMC.PMC_USB: USB Clock Register
func (o *PMC_Type) SetPMC_USB_USBS(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_USB_USBS() uint32 {
	return volatile.LoadUint32(&o.PMC_USB.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_USB_USBDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0xf00)|value<<8)
}
func (o *PMC_Type) GetPMC_USB_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_USB.Reg) & 0xf00) >> 8
}

// PMC.PMC_PCK: Programmable Clock Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0xff0)|value<<4)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0xff0) >> 4
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IER_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_IER_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_IER_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_IER_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_IER_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_IER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_IER_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_IER_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200000) >> 21
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IDR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_IDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_IDR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_IDR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200000) >> 21
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SR_CFDS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SR_FOS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SR_FOS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_SR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200000) >> 21
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IMR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY7(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY7() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_IMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_IMR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_IMR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200000) >> 21
}

// PMC.PMC_FSMR: Fast Startup Mode Register
func (o *PMC_Type) SetPMC_FSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_FSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_FSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_FSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_FSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_FSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_FSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_FSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_FSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_FSMR_FLPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x600000)|value<<21)
}
func (o *PMC_Type) GetPMC_FSMR_FLPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x600000) >> 21
}
func (o *PMC_Type) SetPMC_FSMR_FFLPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_FSMR_FFLPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800000) >> 23
}

// PMC.PMC_FSPR: Fast Startup Polarity Register
func (o *PMC_Type) SetPMC_FSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8000) >> 15
}

// PMC.PMC_FOCR: Fault Output Clear Register
func (o *PMC_Type) SetPMC_FOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.PMC_FOCR.Reg, volatile.LoadUint32(&o.PMC_FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.PMC_FOCR.Reg) & 0x1
}

// PMC.PMC_WPMR: Write Protection Mode Register
func (o *PMC_Type) SetPMC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.PMC_WPSR: Write Protection Status Register
func (o *PMC_Type) SetPMC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0xffff00) >> 8
}

// PMC.PMC_PCER1: Peripheral Clock Enable Register 1
func (o *PMC_Type) SetPMC_PCER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCER1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCER1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCER1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCER1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCER1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCER1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_PCDR1: Peripheral Clock Disable Register 1
func (o *PMC_Type) SetPMC_PCDR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCDR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCDR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCDR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCDR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCDR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCDR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCDR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCDR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCDR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCDR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCDR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCDR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCDR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCDR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_PCSR1: Peripheral Clock Status Register 1
func (o *PMC_Type) SetPMC_PCSR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCSR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCSR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCSR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCSR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCSR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCSR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCSR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCSR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCSR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCSR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCSR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCSR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCSR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCSR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_PCR: Peripheral Control Register
func (o *PMC_Type) SetPMC_PCR_PID(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetPMC_PCR_PID() uint32 {
	return volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x7f
}
func (o *PMC_Type) SetPMC_PCR_GCLKCSS(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x700)|value<<8)
}
func (o *PMC_Type) GetPMC_PCR_GCLKCSS() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x700) >> 8
}
func (o *PMC_Type) SetPMC_PCR_CMD(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCR_CMD() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCR_GCLKDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0xff00000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCR_GCLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0xff00000) >> 20
}
func (o *PMC_Type) SetPMC_PCR_EN(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCR_EN() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCR_GCLKEN(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCR_GCLKEN() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x20000000) >> 29
}

// PMC.PMC_OCR: Oscillator Calibration Register
func (o *PMC_Type) SetPMC_OCR_CAL4(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetPMC_OCR_CAL4() uint32 {
	return volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f
}
func (o *PMC_Type) SetPMC_OCR_SEL4(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_OCR_SEL4() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_OCR_CAL8(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f00)|value<<8)
}
func (o *PMC_Type) GetPMC_OCR_CAL8() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f00) >> 8
}
func (o *PMC_Type) SetPMC_OCR_SEL8(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_OCR_SEL8() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_OCR_CAL12(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x7f0000)|value<<16)
}
func (o *PMC_Type) GetPMC_OCR_CAL12() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x7f0000) >> 16
}
func (o *PMC_Type) SetPMC_OCR_SEL12(value uint32) {
	volatile.StoreUint32(&o.PMC_OCR.Reg, volatile.LoadUint32(&o.PMC_OCR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_OCR_SEL12() uint32 {
	return (volatile.LoadUint32(&o.PMC_OCR.Reg) & 0x800000) >> 23
}

// PMC.PMC_SLPWK_ER0: SleepWalking Enable Register 0
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_SLPWK_ER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_SLPWK_ER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_SLPWK_DR0: SleepWalking Disable Register 0
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_SLPWK_DR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_SLPWK_DR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_SLPWK_SR0: SleepWalking Status Register 0
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_SLPWK_SR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_SLPWK_SR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_SLPWK_ASR0: SleepWalking Activity Status Register 0
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_SLPWK_ASR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR0.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PMMR: PLL Maximum Multiplier Value Register
func (o *PMC_Type) SetPMC_PMMR_PLLA_MMAX(value uint32) {
	volatile.StoreUint32(&o.PMC_PMMR.Reg, volatile.LoadUint32(&o.PMC_PMMR.Reg)&^(0x7ff)|value)
}
func (o *PMC_Type) GetPMC_PMMR_PLLA_MMAX() uint32 {
	return volatile.LoadUint32(&o.PMC_PMMR.Reg) & 0x7ff
}

// PMC.PMC_SLPWK_ER1: SleepWalking Enable Register 1
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_ER1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ER1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_ER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ER1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_SLPWK_DR1: SleepWalking Disable Register 1
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_DR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_DR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_DR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_DR1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_SLPWK_SR1: SleepWalking Status Register 1
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_SR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_SR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_SR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_SR1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_SLPWK_ASR1: SleepWalking Activity Status Register 1
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_SLPWK_ASR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_ASR1.Reg, volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_SLPWK_ASR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PMC_SLPWK_ASR1.Reg) & 0x10000000) >> 28
}

// PMC.PMC_SLPWK_AIPR: SleepWalking Activity In Progress Register
func (o *PMC_Type) SetPMC_SLPWK_AIPR_AIP(value uint32) {
	volatile.StoreUint32(&o.PMC_SLPWK_AIPR.Reg, volatile.LoadUint32(&o.PMC_SLPWK_AIPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SLPWK_AIPR_AIP() uint32 {
	return volatile.LoadUint32(&o.PMC_SLPWK_AIPR.Reg) & 0x1
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	PWM_CLK     volatile.Register32 // 0x0
	PWM_ENA     volatile.Register32 // 0x4
	PWM_DIS     volatile.Register32 // 0x8
	PWM_SR      volatile.Register32 // 0xC
	PWM_IER1   