// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32g0b0.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32g0b0

// STM32G0B0
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32G0B0"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// DMAMUX
	IRQ_DMA_Channel4_5_6_7 = 11

	// Advanced-timers
	IRQ_TIM1_BRK_UP_TRG_COM = 13

	// Advanced-timers
	IRQ_TIM1_CC = 14

	// General-purpose-timers
	IRQ_TIM3 = 16

	// Basic timers
	IRQ_TIM6_DAC = 17

	IRQ_TIM7 = 18

	// General purpose timers
	IRQ_TIM14 = 19

	// General purpose timers
	IRQ_TIM15 = 20

	// General purpose timers
	IRQ_TIM16 = 21

	IRQ_TIM17 = 22

	// Inter-integrated circuit
	IRQ_I2C1 = 23

	IRQ_I2C2 = 24

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 27

	IRQ_USART2 = 28

	IRQ_USART3_USART4_USART5_USART6_LPUART1 = 29

	// Highest interrupt number on this device.
	IRQ_max = 29
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export DMA_Channel4_5_6_7_IRQHandler
func interruptDMA_Channel4_5_6_7() {
	callHandlers(IRQ_DMA_Channel4_5_6_7)
}

//export TIM1_BRK_UP_TRG_COM_IRQHandler
func interruptTIM1_BRK_UP_TRG_COM() {
	callHandlers(IRQ_TIM1_BRK_UP_TRG_COM)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export TIM14_IRQHandler
func interruptTIM14() {
	callHandlers(IRQ_TIM14)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_USART4_USART5_USART6_LPUART1_IRQHandler
func interruptUSART3_USART4_USART5_USART6_LPUART1() {
	callHandlers(IRQ_USART3_USART4_USART5_USART6_LPUART1)
}

// Peripherals.
var (
	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Debug support
	DBG = (*DBG_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// DMAMUX
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// System configuration controller
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// DMA controller
	DMA1 = (*DMA1_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA controller
	DMA2 = (*DMA2_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	USART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013c00)))
)

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB_FZ1 volatile.Register32 // 0x8
	APB_FZ2 volatile.Register32 // 0xC
}

// DBG.IDCODE: MCU Device ID Code Register
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: DBG configuration register
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// DBG.APB_FZ1: DBG APB freeze register 1
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x1
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x10)|value<<4)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x10) >> 4
}
func (o *DBG_Type) SetAPB_FZ1_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetAPB_FZ1_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x400)|value<<10)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x400) >> 10
}
func (o *DBG_Type) SetAPB_FZ1_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB_FZ1_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB_FZ1_DBG_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB_FZ1_DBG_LPTIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x40000000)|value<<30)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_LPTIM2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x40000000) >> 30
}
func (o *DBG_Type) SetAPB_FZ1_DBG_LPTIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ1.Reg, volatile.LoadUint32(&o.APB_FZ1.Reg)&^(0x80000000)|value<<31)
}
func (o *DBG_Type) GetAPB_FZ1_DBG_LPTIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ1.Reg) & 0x80000000) >> 31
}

// DBG.APB_FZ2: DBG APB freeze register 2
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x8000)|value<<15)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x8000) >> 15
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM15_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM15_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB_FZ2_DBG_TIM17_STOP(value uint32) {
	volatile.StoreUint32(&o.APB_FZ2.Reg, volatile.LoadUint32(&o.APB_FZ2.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB_FZ2_DBG_TIM17_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB_FZ2.Reg) & 0x40000) >> 18
}

// DMAMUX
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	_     [100]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [48]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C1CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C2CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C3CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C4CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C5CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC5CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.C6CR: DMAMUX request line multiplexer channel x configuration register
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CSR: DMAMUX request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}

// DMAMUX.CFR: DMAMUX request line multiplexer interrupt clear flag register
func (o *DMAMUX_Type) SetCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}

// DMAMUX.RG0CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG1CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG2CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RG3CR: DMAMUX request generator channel x configuration register
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGSR: DMAMUX request generator interrupt status register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}

// DMAMUX.RGCFR: DMAMUX request generator interrupt clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_COF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_COF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_COF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_COF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_COF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_COF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFSEL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFSEL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFSEL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFSEL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFSEL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFSEL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFSEL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFSEL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFSEL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFSEL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFSEL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFSEL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFSEL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFSEL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFSEL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFSEL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFSEL15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFSEL15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFSEL14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFSEL14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFSEL13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFSEL13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFSEL12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFSEL12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFSEL11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFSEL11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFSEL10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFSEL10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFSEL9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFSEL9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFSEL8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFSEL8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// Inter-integrated circuit
type I2C_Type struct {
	I2C_CR1      volatile.Register32 // 0x0
	I2C_CR2      volatile.Register32 // 0x4
	I2C_OAR1     volatile.Register32 // 0x8
	I2C_OAR2     volatile.Register32 // 0xC
	I2C_TIMINGR  volatile.Register32 // 0x10
	I2C_TIMEOUTR volatile.Register32 // 0x14
	I2C_ISR      volatile.Register32 // 0x18
	I2C_ICR      volatile.Register32 // 0x1C
	I2C_PECR     volatile.Register32 // 0x20
	I2C_RXDR     volatile.Register32 // 0x24
	I2C_TXDR     volatile.Register32 // 0x28
}

// I2C.I2C_CR1: Control register 1
func (o *I2C_Type) SetI2C_CR1_PE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetI2C_CR1_PE() uint32 {
	return volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x1
}
func (o *I2C_Type) SetI2C_CR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetI2C_CR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetI2C_CR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetI2C_CR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetI2C_CR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetI2C_CR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetI2C_CR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetI2C_CR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetI2C_CR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetI2C_CR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetI2C_CR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetI2C_CR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetI2C_CR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetI2C_CR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetI2C_CR1_DNF(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetI2C_CR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetI2C_CR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetI2C_CR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetI2C_CR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetI2C_CR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetI2C_CR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_CR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetI2C_CR1_SBC(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetI2C_CR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetI2C_CR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetI2C_CR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetI2C_CR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetI2C_CR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetI2C_CR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetI2C_CR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetI2C_CR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetI2C_CR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetI2C_CR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetI2C_CR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetI2C_CR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetI2C_CR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetI2C_CR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR1.Reg, volatile.LoadUint32(&o.I2C_CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetI2C_CR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR1.Reg) & 0x800000) >> 23
}

// I2C.I2C_CR2: Control register 2
func (o *I2C_Type) SetI2C_CR2_SADD(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetI2C_CR2_SADD() uint32 {
	return volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x3ff
}
func (o *I2C_Type) SetI2C_CR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetI2C_CR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetI2C_CR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetI2C_CR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetI2C_CR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetI2C_CR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetI2C_CR2_START(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetI2C_CR2_START() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetI2C_CR2_STOP(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetI2C_CR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetI2C_CR2_NACK(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_CR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetI2C_CR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetI2C_CR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetI2C_CR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetI2C_CR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetI2C_CR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetI2C_CR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetI2C_CR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.I2C_CR2.Reg, volatile.LoadUint32(&o.I2C_CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetI2C_CR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CR2.Reg) & 0x4000000) >> 26
}

// I2C.I2C_OAR1: Own address register 1
func (o *I2C_Type) SetI2C_OAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR1.Reg, volatile.LoadUint32(&o.I2C_OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetI2C_OAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.I2C_OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetI2C_OAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR1.Reg, volatile.LoadUint32(&o.I2C_OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetI2C_OAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.I2C_OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetI2C_OAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR1.Reg, volatile.LoadUint32(&o.I2C_OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_OAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.I2C_OAR1.Reg) & 0x8000) >> 15
}

// I2C.I2C_OAR2: Own address register 2
func (o *I2C_Type) SetI2C_OAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR2.Reg, volatile.LoadUint32(&o.I2C_OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetI2C_OAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.I2C_OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetI2C_OAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR2.Reg, volatile.LoadUint32(&o.I2C_OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetI2C_OAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.I2C_OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetI2C_OAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.I2C_OAR2.Reg, volatile.LoadUint32(&o.I2C_OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_OAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.I2C_OAR2.Reg) & 0x8000) >> 15
}

// I2C.I2C_TIMINGR: Timing register
func (o *I2C_Type) SetI2C_TIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMINGR.Reg, volatile.LoadUint32(&o.I2C_TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetI2C_TIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.I2C_TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetI2C_TIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMINGR.Reg, volatile.LoadUint32(&o.I2C_TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetI2C_TIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetI2C_TIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMINGR.Reg, volatile.LoadUint32(&o.I2C_TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetI2C_TIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetI2C_TIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMINGR.Reg, volatile.LoadUint32(&o.I2C_TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetI2C_TIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetI2C_TIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMINGR.Reg, volatile.LoadUint32(&o.I2C_TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetI2C_TIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.I2C_TIMEOUTR: Status register 1
func (o *I2C_Type) SetI2C_TIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMEOUTR.Reg, volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetI2C_TIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetI2C_TIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMEOUTR.Reg, volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetI2C_TIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetI2C_TIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMEOUTR.Reg, volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_TIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetI2C_TIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMEOUTR.Reg, volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetI2C_TIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetI2C_TIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.I2C_TIMEOUTR.Reg, volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetI2C_TIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.I2C_TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.I2C_ISR: Interrupt and Status register
func (o *I2C_Type) SetI2C_ISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetI2C_ISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetI2C_ISR_DIR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetI2C_ISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetI2C_ISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetI2C_ISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetI2C_ISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetI2C_ISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetI2C_ISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetI2C_ISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetI2C_ISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetI2C_ISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetI2C_ISR_OVR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetI2C_ISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetI2C_ISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetI2C_ISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetI2C_ISR_BERR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetI2C_ISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetI2C_ISR_TCR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetI2C_ISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetI2C_ISR_TC(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetI2C_ISR_TC() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetI2C_ISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetI2C_ISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetI2C_ISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetI2C_ISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetI2C_ISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetI2C_ISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetI2C_ISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetI2C_ISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetI2C_ISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetI2C_ISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetI2C_ISR_TXE(value uint32) {
	volatile.StoreUint32(&o.I2C_ISR.Reg, volatile.LoadUint32(&o.I2C_ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetI2C_ISR_TXE() uint32 {
	return volatile.LoadUint32(&o.I2C_ISR.Reg) & 0x1
}

// I2C.I2C_ICR: Interrupt clear register
func (o *I2C_Type) SetI2C_ICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetI2C_ICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetI2C_ICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetI2C_ICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetI2C_ICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetI2C_ICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetI2C_ICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetI2C_ICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetI2C_ICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetI2C_ICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetI2C_ICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetI2C_ICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetI2C_ICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetI2C_ICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetI2C_ICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetI2C_ICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetI2C_ICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.I2C_ICR.Reg, volatile.LoadUint32(&o.I2C_ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetI2C_ICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.I2C_ICR.Reg) & 0x8) >> 3
}

// I2C.I2C_PECR: PEC register
func (o *I2C_Type) SetI2C_PECR_PEC(value uint32) {
	volatile.StoreUint32(&o.I2C_PECR.Reg, volatile.LoadUint32(&o.I2C_PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetI2C_PECR_PEC() uint32 {
	return volatile.LoadUint32(&o.I2C_PECR.Reg) & 0xff
}

// I2C.I2C_RXDR: Receive data register
func (o *I2C_Type) SetI2C_RXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.I2C_RXDR.Reg, volatile.LoadUint32(&o.I2C_RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetI2C_RXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.I2C_RXDR.Reg) & 0xff
}

// I2C.I2C_TXDR: Transmit data register
func (o *I2C_Type) SetI2C_TXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.I2C_TXDR.Reg, volatile.LoadUint32(&o.I2C_TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetI2C_TXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.I2C_TXDR.Reg) & 0xff
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR1          volatile.Register32 // 0x50
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
	TISEL        volatile.Register32 // 0x68
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIM_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIM_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS1(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS1() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}
func (o *TIM_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSMCR_TS1(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS1() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_SMS2(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS2() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_TS2(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x300000)|value<<20)
}
func (o *TIM_Type) GetSMCR_TS2() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x300000) >> 20
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_SBIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetSR_SBIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetSR_CC5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSR_CC5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSR_CC6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetSR_CC6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1M1(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M1() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC1M2(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M2() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIM_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIM_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIM_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TIM.CCR1: capture/compare register 1
func (o *TIM_Type) SetCCR1(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register 2
func (o *TIM_Type) SetCCR2(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register 3
func (o *TIM_Type) SetCCR3(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register 4
func (o *TIM_Type) SetCCR4(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIM_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}
func (o *TIM_Type) SetBDTR_BKDSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000000)|value<<26)
}
func (o *TIM_Type) GetBDTR_BKDSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000000) >> 26
}
func (o *TIM_Type) SetBDTR_BK2DSRM(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000000)|value<<27)
}
func (o *TIM_Type) GetBDTR_BK2DSRM() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000000) >> 27
}
func (o *TIM_Type) SetBDTR_BKBID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x10000000)|value<<28)
}
func (o *TIM_Type) GetBDTR_BKBID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x10000000) >> 28
}
func (o *TIM_Type) SetBDTR_BK2BID(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetBDTR_BK2BID() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x20000000) >> 29
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, value)
}
func (o *TIM_Type) GetDMAR() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg)
}

// TIM.OR1: option register 1
func (o *TIM_Type) SetOR1_OCREF_CLR(value uint32) {
	volatile.StoreUint32(&o.OR1.Reg, volatile.LoadUint32(&o.OR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetOR1_OCREF_CLR() uint32 {
	return volatile.LoadUint32(&o.OR1.Reg) & 0x1
}

// TIM.CCMR3_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}

// TIM.CCR5: capture/compare register 4
func (o *TIM_Type) SetCCR5(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR5() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}
func (o *TIM_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIM_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIM_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}

// TIM.CCR6: capture/compare register 4
func (o *TIM_Type) SetCCR6(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR6() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// TIM.AF1: DMA address for full transfer
func (o *TIM_Type) SetAF1_BKINE(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF1_BKINE() uint32 {
	return volatile.LoadUint32(&o.AF1.Reg) & 0x1
}
func (o *TIM_Type) SetAF1_BKCMP1E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF1_BKCMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF1_BKCMP2E(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF1_BKCMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF1_BKINP(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF1_BKINP() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF1_BKCMP1P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF1_BKCMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF1_BKCMP2P(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF1_BKCMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetAF1_ETRSEL(value uint32) {
	volatile.StoreUint32(&o.AF1.Reg, volatile.LoadUint32(&o.AF1.Reg)&^(0x3c000)|value<<14)
}
func (o *TIM_Type) GetAF1_ETRSEL() uint32 {
	return (volatile.LoadUint32(&o.AF1.Reg) & 0x3c000) >> 14
}

// TIM.AF2: DMA address for full transfer
func (o *TIM_Type) SetAF2_BK2INE(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetAF2_BK2INE() uint32 {
	return volatile.LoadUint32(&o.AF2.Reg) & 0x1
}
func (o *TIM_Type) SetAF2_BK2CMP1E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetAF2_BK2CMP1E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetAF2_BK2CMP2E(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetAF2_BK2CMP2E() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetAF2_BK2INP(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetAF2_BK2INP() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetAF2_BK2CMP1P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetAF2_BK2CMP1P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetAF2_BK2CMP2P(value uint32) {
	volatile.StoreUint32(&o.AF2.Reg, volatile.LoadUint32(&o.AF2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetAF2_BK2CMP2P() uint32 {
	return (volatile.LoadUint32(&o.AF2.Reg) & 0x800) >> 11
}

// TIM.TISEL: TIM1 timer input selection register
func (o *TIM_Type) SetTISEL_TI1SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf)|value)
}
func (o *TIM_Type) GetTISEL_TI1SEL() uint32 {
	return volatile.LoadUint32(&o.TISEL.Reg) & 0xf
}
func (o *TIM_Type) SetTISEL_TI2SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetTISEL_TI2SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetTISEL_TI3SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetTISEL_TI3SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf0000) >> 16
}
func (o *TIM_Type) SetTISEL_TI4SEL(value uint32) {
	volatile.StoreUint32(&o.TISEL.Reg, volatile.LoadUint32(&o.TISEL.Reg)&^(0xf000000)|value<<24)
}
func (o *TIM_Type) GetTISEL_TI4SEL() uint32 {
	return (volatile.LoadUint32(&o.TISEL.Reg) & 0xf000000) >> 24
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1_FIFO_ENABLED volatile.Register32 // 0x0
	CR2              volatile.Register32 // 0x4
	CR3              volatile.Register32 // 0x8
	BRR              volatile.Register32 // 0xC
	GTPR             volatile.Register32 // 0x10
	RTOR             volatile.Register32 // 0x14
	RQR              volatile.Register32 // 0x18
	ISR_FIFO_ENABLED volatile.Register32 // 0x1C
	ICR              volatile.Register32 // 0x20
	RDR              volatile.Register32 // 0x24
	TDR              volatile.Register32 // 0x28
	PRESC            volatile.Register32 // 0x2C
}

// USART.CR1_FIFO_ENABLED: Control register 1
func (o *USART_Type) SetCR1_FIFO_ENABLED_UE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_UE() uint32 {
	return volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RXFNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RXFNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TXFNFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TXFNFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PS(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_M0(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_MME(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x1f0000) >> 16
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_M1(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetCR1_FIFO_ENABLED_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetCR1_FIFO_ENABLED_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1_FIFO_ENABLED.Reg) & 0x80000000) >> 31
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR2_SLVEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *USART_Type) SetCR2_DIS_NSS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR2_DIS_NSS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR3_TCBGTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR3_TCBGTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *USART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *USART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *USART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}

// USART.ISR_FIFO_ENABLED: Interrupt & status register
func (o *USART_Type) SetISR_FIFO_ENABLED_PE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_PE() uint32 {
	return volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1
}
func (o *USART_Type) SetISR_FIFO_ENABLED_FE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_FIFO_ENABLED_NE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_FIFO_ENABLED_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFNE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFNE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TC(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFNF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFNF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_FIFO_ENABLED_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_FIFO_ENABLED_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_FIFO_ENABLED_UDR(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_UDR() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_FIFO_ENABLED_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_FIFO_ENABLED_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_FIFO_ENABLED_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_FIFO_ENABLED_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_FIFO_ENABLED_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_FIFO_ENABLED_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x1000000) >> 24
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TCBGT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TCBGT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x2000000) >> 25
}
func (o *USART_Type) SetISR_FIFO_ENABLED_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetISR_FIFO_ENABLED_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR_FIFO_ENABLED.Reg, volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetISR_FIFO_ENABLED_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR_FIFO_ENABLED.Reg) & 0x8000000) >> 27
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_NECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_TXFECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetICR_TXFECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_TCBGTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetICR_TCBGTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_UDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetICR_UDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USART.PRESC: Prescaler register
func (o *USART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// System configuration controller
type VREFBUF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// VREFBUF.CSR: VREFBUF control and status register
func (o *VREFBUF_Type) SetCSR_ENVR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *VREFBUF_Type) GetCSR_ENVR() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *VREFBUF_Type) SetCSR_HIZ(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *VREFBUF_Type) GetCSR_HIZ() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *VREFBUF_Type) SetCSR_VRS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *VREFBUF_Type) GetCSR_VRS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *VREFBUF_Type) SetCSR_VRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *VREFBUF_Type) GetCSR_VRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}

// VREFBUF.CCR: VREFBUF calibration control register
func (o *VREFBUF_Type) SetCCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3f)|value)
}
func (o *VREFBUF_Type) GetCCR_TRIM() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x3f
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x3800)|value<<11)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x3800) >> 11
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DMA controller
type DMA1_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]DMA1_CH_Type     // 0x8
}

// DMA1.ISR: low interrupt status register
func (o *DMA1_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA1_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA1_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA1_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA1_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA1_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA1_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA1_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA1_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA1_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA1_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA1_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA1_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA1_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA1_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA1_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA1_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA1_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA1_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA1_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA1_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA1_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA1_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA1_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA1_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA1_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA1_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA1_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA1_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA1_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA1_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA1_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA1_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA1_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA1_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA1_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA1_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA1_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA1_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA1_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA1_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA1_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA1_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA1_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA1_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA1_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA1_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA1_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}

// DMA1.IFCR: high interrupt status register
func (o *DMA1_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA1_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA1_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA1_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA1_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA1_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA1_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA1_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA1_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA1_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA1_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA1_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA1_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA1_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA1_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA1_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA1_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA1_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA1_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA1_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA1_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA1_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA1_Type) SetIFCR_CTEIF15(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA1_Type) GetIFCR_CTEIF15() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA1_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA1_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA1_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA1_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA1_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA1_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA1_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA1_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA1_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA1_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA1_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA1_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA1_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA1_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA1_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA1_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA1_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA1_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA1_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA1_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA1_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA1_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA1_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA1_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}

type DMA1_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	MAR  volatile.Register32 // 0x14
	_    [4]byte
}

// DMA1_CH.CR: DMA channel 1 configuration register
func (o *DMA1_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA1_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA1_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA1_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA1_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA1_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA1_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA1_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA1_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA1_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA1_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA1_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA1_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA1_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA1_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA1_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA1_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DMA1_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DMA1_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DMA1_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DMA1_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *DMA1_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *DMA1_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA1_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// DMA1_CH.NDTR: DMA channel 1 number of data tegister
func (o *DMA1_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA1_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA1_CH.PAR: DMA channel 1 peripheral address
func (o *DMA1_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA1_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA1_CH.MAR: DMA channel 1 memory address
func (o *DMA1_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *DMA1_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// DMA controller
type DMA2_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [5]DMA2_CH_Type     // 0x8
}

// DMA2.ISR: low interrupt status register
func (o *DMA2_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA2_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA2_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA2_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA2_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA2_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA2_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA2_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA2_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA2_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA2_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA2_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA2_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA2_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA2_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA2_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA2_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA2_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA2_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA2_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA2_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}

// DMA2.IFCR: high interrupt status register
func (o *DMA2_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA2_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA2_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA2_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA2_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA2_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA2_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA2_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA2_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA2_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA2_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA2_Type) SetIFCR_CTEIF15(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA2_Type) GetIFCR_CTEIF15() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA2_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA2_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA2_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA2_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA2_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA2_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA2_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA2_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}

type DMA2_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	MAR  volatile.Register32 // 0x14
	_    [4]byte
}

// DMA2_CH.CR: DMA channel 1 configuration register
func (o *DMA2_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA2_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA2_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA2_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA2_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA2_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA2_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA2_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA2_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DMA2_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DMA2_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DMA2_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DMA2_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *DMA2_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *DMA2_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA2_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// DMA2_CH.NDTR: DMA channel 1 number of data tegister
func (o *DMA2_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA2_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA2_CH.PAR: DMA channel 1 peripheral address
func (o *DMA2_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA2_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA2_CH.MAR: DMA channel 1 memory address
func (o *DMA2_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *DMA2_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// Constants for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xffffffff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_B_0x0 = 0x0
	// Bit-reversed output format
	CRC_CR_REV_OUT_B_0x1 = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_B_0x0 = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_B_0x1 = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_B_0x2 = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_B_0x3 = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32 bit polynomial
	CRC_CR_POLYSIZE_B_0x0 = 0x0
	// 16 bit polynomial
	CRC_CR_POLYSIZE_B_0x1 = 0x1
	// 8 bit polynomial
	CRC_CR_POLYSIZE_B_0x2 = 0x2
	// 7 bit polynomial
	CRC_CR_POLYSIZE_B_0x3 = 0x3
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1

	// INIT: Initial CRC value
	// Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Pos = 0x0
	// Bit mask of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Constants for DBG: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: DBG configuration register
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// All clocks disabled, including FCLK and HCLK. Upon Stop mode exit, the CPU is clocked by the HSI internal RC oscillator.
	DBG_CR_DBG_STOP_B_0x0 = 0x0
	// FCLK and HCLK running, derived from the internal RC oscillator remaining active. If Systick is enabled, it may generate periodic interrupt and wake up events.
	DBG_CR_DBG_STOP_B_0x1 = 0x1
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Digital part powered. From software point of view, exiting Standby and Shutdown modes is identical as fetching reset vector (except for status bits indicating that the MCU exits Standby)
	DBG_CR_DBG_STANDBY_B_0x0 = 0x0
	// Digital part powered and FCLK and HCLK running, derived from the internal RC oscillator remaining active. The MCU generates a system reset so that exiting Standby and Shutdown has the same effect as starting from reset.
	DBG_CR_DBG_STANDBY_B_0x1 = 0x1

	// APB_FZ1: DBG APB freeze register 1
	// Position of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB_FZ1_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB_FZ1_DBG_TIM2_STOP = 0x1
	// Enable
	DBG_APB_FZ1_DBG_TIM2_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM2_STOP_B_0x1 = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB_FZ1_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB_FZ1_DBG_TIM3_STOP = 0x2
	// Enable
	DBG_APB_FZ1_DBG_TIM3_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM3_STOP_B_0x1 = 0x1
	// Position of DBG_TIM6_STOP field.
	DBG_APB_FZ1_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBG_APB_FZ1_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBG_APB_FZ1_DBG_TIM6_STOP = 0x10
	// Enable
	DBG_APB_FZ1_DBG_TIM6_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM6_STOP_B_0x1 = 0x1
	// Position of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBG_APB_FZ1_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBG_APB_FZ1_DBG_TIM7_STOP = 0x20
	// Enable
	DBG_APB_FZ1_DBG_TIM7_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_TIM7_STOP_B_0x1 = 0x1
	// Position of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBG_APB_FZ1_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBG_APB_FZ1_DBG_RTC_STOP = 0x400
	// Enable
	DBG_APB_FZ1_DBG_RTC_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_RTC_STOP_B_0x1 = 0x1
	// Position of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB_FZ1_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB_FZ1_DBG_WWDG_STOP = 0x800
	// Enable
	DBG_APB_FZ1_DBG_WWDG_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_WWDG_STOP_B_0x1 = 0x1
	// Position of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB_FZ1_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB_FZ1_DBG_IWDG_STOP = 0x1000
	// Enable
	DBG_APB_FZ1_DBG_IWDG_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_IWDG_STOP_B_0x1 = 0x1
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT = 0x200000
	// Same behavior as in normal mode
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_B_0x0 = 0x0
	// The SMBUS timeout is frozen
	DBG_APB_FZ1_DBG_I2C1_SMBUS_TIMEOUT_B_0x1 = 0x1
	// Position of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Pos = 0x1e
	// Bit mask of DBG_LPTIM2_STOP field.
	DBG_APB_FZ1_DBG_LPTIM2_STOP_Msk = 0x40000000
	// Bit DBG_LPTIM2_STOP.
	DBG_APB_FZ1_DBG_LPTIM2_STOP = 0x40000000
	// Enable
	DBG_APB_FZ1_DBG_LPTIM2_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_LPTIM2_STOP_B_0x1 = 0x1
	// Position of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIM1_STOP field.
	DBG_APB_FZ1_DBG_LPTIM1_STOP_Msk = 0x80000000
	// Bit DBG_LPTIM1_STOP.
	DBG_APB_FZ1_DBG_LPTIM1_STOP = 0x80000000
	// Enable
	DBG_APB_FZ1_DBG_LPTIM1_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ1_DBG_LPTIM1_STOP_B_0x1 = 0x1

	// APB_FZ2: DBG APB freeze register 2
	// Position of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Pos = 0xb
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB_FZ2_DBG_TIM1_STOP_Msk = 0x800
	// Bit DBG_TIM1_STOP.
	DBG_APB_FZ2_DBG_TIM1_STOP = 0x800
	// Enable
	DBG_APB_FZ2_DBG_TIM1_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM1_STOP_B_0x1 = 0x1
	// Position of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Pos = 0xf
	// Bit mask of DBG_TIM14_STOP field.
	DBG_APB_FZ2_DBG_TIM14_STOP_Msk = 0x8000
	// Bit DBG_TIM14_STOP.
	DBG_APB_FZ2_DBG_TIM14_STOP = 0x8000
	// Enable
	DBG_APB_FZ2_DBG_TIM14_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM14_STOP_B_0x1 = 0x1
	// Position of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP_Pos = 0x10
	// Bit mask of DBG_TIM15_STOP field.
	DBG_APB_FZ2_DBG_TIM15_STOP_Msk = 0x10000
	// Bit DBG_TIM15_STOP.
	DBG_APB_FZ2_DBG_TIM15_STOP = 0x10000
	// Enable
	DBG_APB_FZ2_DBG_TIM15_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM15_STOP_B_0x1 = 0x1
	// Position of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Pos = 0x11
	// Bit mask of DBG_TIM16_STOP field.
	DBG_APB_FZ2_DBG_TIM16_STOP_Msk = 0x20000
	// Bit DBG_TIM16_STOP.
	DBG_APB_FZ2_DBG_TIM16_STOP = 0x20000
	// Enable
	DBG_APB_FZ2_DBG_TIM16_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM16_STOP_B_0x1 = 0x1
	// Position of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Pos = 0x12
	// Bit mask of DBG_TIM17_STOP field.
	DBG_APB_FZ2_DBG_TIM17_STOP_Msk = 0x40000
	// Bit DBG_TIM17_STOP.
	DBG_APB_FZ2_DBG_TIM17_STOP = 0x40000
	// Enable
	DBG_APB_FZ2_DBG_TIM17_STOP_B_0x0 = 0x0
	// Disable
	DBG_APB_FZ2_DBG_TIM17_STOP_B_0x1 = 0x1
)

// Constants for DMAMUX: DMAMUX
const (
	// C0CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C0CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C0CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C0CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C0CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C0CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C0CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C0CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C0CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C0CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C0CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C0CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C0CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C0CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C0CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C0CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C0CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C0CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C0CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C0CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C0CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C0CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C0CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C0CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C0CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C0CR_SYNC_ID_Msk = 0x1f000000

	// C1CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C1CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C1CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C1CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C1CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C1CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C1CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C1CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C1CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C1CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C1CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C1CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C1CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C1CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C1CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C1CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C1CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C1CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C1CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C1CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C1CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C1CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C1CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C1CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C1CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C1CR_SYNC_ID_Msk = 0x1f000000

	// C2CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C2CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C2CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C2CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C2CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C2CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C2CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C2CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C2CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C2CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C2CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C2CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C2CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C2CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C2CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C2CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C2CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C2CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C2CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C2CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C2CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C2CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C2CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C2CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C2CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C2CR_SYNC_ID_Msk = 0x1f000000

	// C3CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C3CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C3CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C3CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C3CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C3CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C3CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C3CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C3CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C3CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C3CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C3CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C3CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C3CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C3CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C3CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C3CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C3CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C3CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C3CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C3CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C3CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C3CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C3CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C3CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C3CR_SYNC_ID_Msk = 0x1f000000

	// C4CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C4CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C4CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C4CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C4CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C4CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C4CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C4CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C4CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C4CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C4CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C4CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C4CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C4CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C4CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C4CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C4CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C4CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C4CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C4CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C4CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C4CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C4CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C4CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C4CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C4CR_SYNC_ID_Msk = 0x1f000000

	// C5CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C5CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C5CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C5CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C5CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C5CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C5CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C5CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C5CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C5CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C5CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C5CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C5CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C5CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C5CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C5CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C5CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C5CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C5CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C5CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C5CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C5CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C5CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C5CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C5CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C5CR_SYNC_ID_Msk = 0x1f000000

	// C6CR: DMAMUX request line multiplexer channel x configuration register
	// Position of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Pos = 0x0
	// Bit mask of DMAREQ_ID field.
	DMAMUX_C6CR_DMAREQ_ID_Msk = 0x3f
	// Position of SOIE field.
	DMAMUX_C6CR_SOIE_Pos = 0x8
	// Bit mask of SOIE field.
	DMAMUX_C6CR_SOIE_Msk = 0x100
	// Bit SOIE.
	DMAMUX_C6CR_SOIE = 0x100
	// interrupt disabled
	DMAMUX_C6CR_SOIE_B_0x0 = 0x0
	// interrupt enabled
	DMAMUX_C6CR_SOIE_B_0x1 = 0x1
	// Position of EGE field.
	DMAMUX_C6CR_EGE_Pos = 0x9
	// Bit mask of EGE field.
	DMAMUX_C6CR_EGE_Msk = 0x200
	// Bit EGE.
	DMAMUX_C6CR_EGE = 0x200
	// event generation disabled
	DMAMUX_C6CR_EGE_B_0x0 = 0x0
	// event generation enabled
	DMAMUX_C6CR_EGE_B_0x1 = 0x1
	// Position of SE field.
	DMAMUX_C6CR_SE_Pos = 0x10
	// Bit mask of SE field.
	DMAMUX_C6CR_SE_Msk = 0x10000
	// Bit SE.
	DMAMUX_C6CR_SE = 0x10000
	// synchronization disabled
	DMAMUX_C6CR_SE_B_0x0 = 0x0
	// synchronization enabled
	DMAMUX_C6CR_SE_B_0x1 = 0x1
	// Position of SPOL field.
	DMAMUX_C6CR_SPOL_Pos = 0x11
	// Bit mask of SPOL field.
	DMAMUX_C6CR_SPOL_Msk = 0x60000
	// no event, i.e. no synchronization nor detection.
	DMAMUX_C6CR_SPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_C6CR_SPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_C6CR_SPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_C6CR_SPOL_B_0x3 = 0x3
	// Position of NBREQ field.
	DMAMUX_C6CR_NBREQ_Pos = 0x13
	// Bit mask of NBREQ field.
	DMAMUX_C6CR_NBREQ_Msk = 0xf80000
	// Position of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Pos = 0x18
	// Bit mask of SYNC_ID field.
	DMAMUX_C6CR_SYNC_ID_Msk = 0x1f000000

	// CSR: DMAMUX request line multiplexer interrupt channel status register
	// Position of SOF0 field.
	DMAMUX_CSR_SOF0_Pos = 0x0
	// Bit mask of SOF0 field.
	DMAMUX_CSR_SOF0_Msk = 0x1
	// Bit SOF0.
	DMAMUX_CSR_SOF0 = 0x1
	// Position of SOF1 field.
	DMAMUX_CSR_SOF1_Pos = 0x1
	// Bit mask of SOF1 field.
	DMAMUX_CSR_SOF1_Msk = 0x2
	// Bit SOF1.
	DMAMUX_CSR_SOF1 = 0x2
	// Position of SOF2 field.
	DMAMUX_CSR_SOF2_Pos = 0x2
	// Bit mask of SOF2 field.
	DMAMUX_CSR_SOF2_Msk = 0x4
	// Bit SOF2.
	DMAMUX_CSR_SOF2 = 0x4
	// Position of SOF3 field.
	DMAMUX_CSR_SOF3_Pos = 0x3
	// Bit mask of SOF3 field.
	DMAMUX_CSR_SOF3_Msk = 0x8
	// Bit SOF3.
	DMAMUX_CSR_SOF3 = 0x8
	// Position of SOF4 field.
	DMAMUX_CSR_SOF4_Pos = 0x4
	// Bit mask of SOF4 field.
	DMAMUX_CSR_SOF4_Msk = 0x10
	// Bit SOF4.
	DMAMUX_CSR_SOF4 = 0x10
	// Position of SOF5 field.
	DMAMUX_CSR_SOF5_Pos = 0x5
	// Bit mask of SOF5 field.
	DMAMUX_CSR_SOF5_Msk = 0x20
	// Bit SOF5.
	DMAMUX_CSR_SOF5 = 0x20
	// Position of SOF6 field.
	DMAMUX_CSR_SOF6_Pos = 0x6
	// Bit mask of SOF6 field.
	DMAMUX_CSR_SOF6_Msk = 0x40
	// Bit SOF6.
	DMAMUX_CSR_SOF6 = 0x40

	// CFR: DMAMUX request line multiplexer interrupt clear flag register
	// Position of CSOF0 field.
	DMAMUX_CFR_CSOF0_Pos = 0x0
	// Bit mask of CSOF0 field.
	DMAMUX_CFR_CSOF0_Msk = 0x1
	// Bit CSOF0.
	DMAMUX_CFR_CSOF0 = 0x1
	// Position of CSOF1 field.
	DMAMUX_CFR_CSOF1_Pos = 0x1
	// Bit mask of CSOF1 field.
	DMAMUX_CFR_CSOF1_Msk = 0x2
	// Bit CSOF1.
	DMAMUX_CFR_CSOF1 = 0x2
	// Position of CSOF2 field.
	DMAMUX_CFR_CSOF2_Pos = 0x2
	// Bit mask of CSOF2 field.
	DMAMUX_CFR_CSOF2_Msk = 0x4
	// Bit CSOF2.
	DMAMUX_CFR_CSOF2 = 0x4
	// Position of CSOF3 field.
	DMAMUX_CFR_CSOF3_Pos = 0x3
	// Bit mask of CSOF3 field.
	DMAMUX_CFR_CSOF3_Msk = 0x8
	// Bit CSOF3.
	DMAMUX_CFR_CSOF3 = 0x8
	// Position of CSOF4 field.
	DMAMUX_CFR_CSOF4_Pos = 0x4
	// Bit mask of CSOF4 field.
	DMAMUX_CFR_CSOF4_Msk = 0x10
	// Bit CSOF4.
	DMAMUX_CFR_CSOF4 = 0x10
	// Position of CSOF5 field.
	DMAMUX_CFR_CSOF5_Pos = 0x5
	// Bit mask of CSOF5 field.
	DMAMUX_CFR_CSOF5_Msk = 0x20
	// Bit CSOF5.
	DMAMUX_CFR_CSOF5 = 0x20
	// Position of CSOF6 field.
	DMAMUX_CFR_CSOF6_Pos = 0x6
	// Bit mask of CSOF6 field.
	DMAMUX_CFR_CSOF6_Msk = 0x40
	// Bit CSOF6.
	DMAMUX_CFR_CSOF6 = 0x40

	// RG0CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG0CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG0CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG0CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG0CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG0CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG0CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG0CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG0CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG0CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG0CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG0CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG0CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG0CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG0CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG0CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG0CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG0CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG0CR_GNBREQ_Msk = 0xf80000

	// RG1CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG1CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG1CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG1CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG1CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG1CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG1CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG1CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG1CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG1CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG1CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG1CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG1CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG1CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG1CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG1CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG1CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG1CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG1CR_GNBREQ_Msk = 0xf80000

	// RG2CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG2CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG2CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG2CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG2CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG2CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG2CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG2CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG2CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG2CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG2CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG2CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG2CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG2CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG2CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG2CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG2CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG2CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG2CR_GNBREQ_Msk = 0xf80000

	// RG3CR: DMAMUX request generator channel x configuration register
	// Position of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Pos = 0x0
	// Bit mask of SIG_ID field.
	DMAMUX_RG3CR_SIG_ID_Msk = 0x1f
	// Position of OIE field.
	DMAMUX_RG3CR_OIE_Pos = 0x8
	// Bit mask of OIE field.
	DMAMUX_RG3CR_OIE_Msk = 0x100
	// Bit OIE.
	DMAMUX_RG3CR_OIE = 0x100
	// interrupt on a trigger overrun event occurrence is disabled
	DMAMUX_RG3CR_OIE_B_0x0 = 0x0
	// interrupt on a trigger overrun event occurrence is enabled
	DMAMUX_RG3CR_OIE_B_0x1 = 0x1
	// Position of GE field.
	DMAMUX_RG3CR_GE_Pos = 0x10
	// Bit mask of GE field.
	DMAMUX_RG3CR_GE_Msk = 0x10000
	// Bit GE.
	DMAMUX_RG3CR_GE = 0x10000
	// DMA request generator channel x disabled
	DMAMUX_RG3CR_GE_B_0x0 = 0x0
	// DMA request generator channel x enabled
	DMAMUX_RG3CR_GE_B_0x1 = 0x1
	// Position of GPOL field.
	DMAMUX_RG3CR_GPOL_Pos = 0x11
	// Bit mask of GPOL field.
	DMAMUX_RG3CR_GPOL_Msk = 0x60000
	// no event. I.e. none trigger detection nor generation.
	DMAMUX_RG3CR_GPOL_B_0x0 = 0x0
	// rising edge
	DMAMUX_RG3CR_GPOL_B_0x1 = 0x1
	// falling edge
	DMAMUX_RG3CR_GPOL_B_0x2 = 0x2
	// rising and falling edge
	DMAMUX_RG3CR_GPOL_B_0x3 = 0x3
	// Position of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Pos = 0x13
	// Bit mask of GNBREQ field.
	DMAMUX_RG3CR_GNBREQ_Msk = 0xf80000

	// RGSR: DMAMUX request generator interrupt status register
	// Position of OF0 field.
	DMAMUX_RGSR_OF0_Pos = 0x0
	// Bit mask of OF0 field.
	DMAMUX_RGSR_OF0_Msk = 0x1
	// Bit OF0.
	DMAMUX_RGSR_OF0 = 0x1
	// Position of OF1 field.
	DMAMUX_RGSR_OF1_Pos = 0x1
	// Bit mask of OF1 field.
	DMAMUX_RGSR_OF1_Msk = 0x2
	// Bit OF1.
	DMAMUX_RGSR_OF1 = 0x2
	// Position of OF2 field.
	DMAMUX_RGSR_OF2_Pos = 0x2
	// Bit mask of OF2 field.
	DMAMUX_RGSR_OF2_Msk = 0x4
	// Bit OF2.
	DMAMUX_RGSR_OF2 = 0x4
	// Position of OF3 field.
	DMAMUX_RGSR_OF3_Pos = 0x3
	// Bit mask of OF3 field.
	DMAMUX_RGSR_OF3_Msk = 0x8
	// Bit OF3.
	DMAMUX_RGSR_OF3 = 0x8

	// RGCFR: DMAMUX request generator interrupt clear flag register
	// Position of COF0 field.
	DMAMUX_RGCFR_COF0_Pos = 0x0
	// Bit mask of COF0 field.
	DMAMUX_RGCFR_COF0_Msk = 0x1
	// Bit COF0.
	DMAMUX_RGCFR_COF0 = 0x1
	// Position of COF1 field.
	DMAMUX_RGCFR_COF1_Pos = 0x1
	// Bit mask of COF1 field.
	DMAMUX_RGCFR_COF1_Msk = 0x2
	// Bit COF1.
	DMAMUX_RGCFR_COF1 = 0x2
	// Position of COF2 field.
	DMAMUX_RGCFR_COF2_Pos = 0x2
	// Bit mask of COF2 field.
	DMAMUX_RGCFR_COF2_Msk = 0x4
	// Bit COF2.
	DMAMUX_RGCFR_COF2 = 0x4
	// Position of COF3 field.
	DMAMUX_RGCFR_COF3_Pos = 0x3
	// Bit mask of COF3 field.
	DMAMUX_RGCFR_COF3_Msk = 0x8
	// Bit COF3.
	DMAMUX_RGCFR_COF3 = 0x8
)

// Constants for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Pos = 0x1c
	// Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000
	// Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18
	// Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000
	// Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14
	// Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000
	// Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10
	// Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000
	// Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc
	// Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000
	// Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8
	// Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00
	// Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4
	// Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0
	// Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0
	// Bit mask of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Pos = 0x1c
	// Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000
	// Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18
	// Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000
	// Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14
	// Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000
	// Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10
	// Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000
	// Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc
	// Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000
	// Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8
	// Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00
	// Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Pos = 0x4
	// Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk = 0xf0
	// Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Pos = 0x0
	// Bit mask of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk = 0xf

	// BRR: port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Constants for I2C1: Inter-integrated circuit
const (
	// I2C_CR1: Control register 1
	// Position of PE field.
	I2C_I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_I2C_CR1_PE = 0x1
	// Peripheral disable
	I2C_I2C_CR1_PE_B_0x0 = 0x0
	// Peripheral enable
	I2C_I2C_CR1_PE_B_0x1 = 0x1
	// Position of TXIE field.
	I2C_I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_I2C_CR1_TXIE_B_0x0 = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_I2C_CR1_TXIE_B_0x1 = 0x1
	// Position of RXIE field.
	I2C_I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_I2C_CR1_RXIE_B_0x0 = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_I2C_CR1_RXIE_B_0x1 = 0x1
	// Position of ADDRIE field.
	I2C_I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_I2C_CR1_ADDRIE_B_0x0 = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_I2C_CR1_ADDRIE_B_0x1 = 0x1
	// Position of NACKIE field.
	I2C_I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_I2C_CR1_NACKIE_B_0x0 = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_I2C_CR1_NACKIE_B_0x1 = 0x1
	// Position of STOPIE field.
	I2C_I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_I2C_CR1_STOPIE_B_0x0 = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_I2C_CR1_STOPIE_B_0x1 = 0x1
	// Position of TCIE field.
	I2C_I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_I2C_CR1_TCIE_B_0x0 = 0x0
	// Transfer Complete interrupt enabled
	I2C_I2C_CR1_TCIE_B_0x1 = 0x1
	// Position of ERRIE field.
	I2C_I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_I2C_CR1_ERRIE_B_0x0 = 0x0
	// Error detection interrupts enabled
	I2C_I2C_CR1_ERRIE_B_0x1 = 0x1
	// Position of DNF field.
	I2C_I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_I2C_CR1_DNF_B_0x0 = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_I2C_CR1_DNF_B_0x1 = 0x1
	// digital filter enabled and filtering capability up to15 tI2CCLK
	I2C_I2C_CR1_DNF_B_0xF = 0xf
	// Position of ANFOFF field.
	I2C_I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_I2C_CR1_ANFOFF_B_0x0 = 0x0
	// Analog noise filter disabled
	I2C_I2C_CR1_ANFOFF_B_0x1 = 0x1
	// Position of TXDMAEN field.
	I2C_I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_I2C_CR1_TXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for transmission
	I2C_I2C_CR1_TXDMAEN_B_0x1 = 0x1
	// Position of RXDMAEN field.
	I2C_I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_I2C_CR1_RXDMAEN_B_0x0 = 0x0
	// DMA mode enabled for reception
	I2C_I2C_CR1_RXDMAEN_B_0x1 = 0x1
	// Position of SBC field.
	I2C_I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_I2C_CR1_SBC_B_0x0 = 0x0
	// Slave byte control enabled
	I2C_I2C_CR1_SBC_B_0x1 = 0x1
	// Position of NOSTRETCH field.
	I2C_I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_I2C_CR1_NOSTRETCH_B_0x0 = 0x0
	// Clock stretching disabled
	I2C_I2C_CR1_NOSTRETCH_B_0x1 = 0x1
	// Position of WUPEN field.
	I2C_I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disable.
	I2C_I2C_CR1_WUPEN_B_0x0 = 0x0
	// Wakeup from Stop mode enable.
	I2C_I2C_CR1_WUPEN_B_0x1 = 0x1
	// Position of GCEN field.
	I2C_I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed.
	I2C_I2C_CR1_GCEN_B_0x0 = 0x0
	// General call enabled. Address 0b00000000 is ACKed.
	I2C_I2C_CR1_GCEN_B_0x1 = 0x1
	// Position of SMBHEN field.
	I2C_I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_I2C_CR1_SMBHEN = 0x100000
	// Host Address disabled. Address 0b0001000x is NACKed.
	I2C_I2C_CR1_SMBHEN_B_0x0 = 0x0
	// Host Address enabled. Address 0b0001000x is ACKed.
	I2C_I2C_CR1_SMBHEN_B_0x1 = 0x1
	// Position of SMBDEN field.
	I2C_I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_I2C_CR1_SMBDEN = 0x200000
	// Device Default Address disabled. Address 0b1100001x is NACKed.
	I2C_I2C_CR1_SMBDEN_B_0x0 = 0x0
	// Device Default Address enabled. Address 0b1100001x is ACKed.
	I2C_I2C_CR1_SMBDEN_B_0x1 = 0x1
	// Position of ALERTEN field.
	I2C_I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_I2C_CR1_ALERTEN = 0x400000
	// The SMBus alert pin (SMBA) is not supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is released and the Alert Response Address header is disabled (0001100x followed by NACK).
	I2C_I2C_CR1_ALERTEN_B_0x0 = 0x0
	// The SMBus alert pin is supported in host mode (SMBHEN=1). In device mode (SMBHEN=0), the SMBA pin is driven low and the Alert Response Address header is enabled (0001100x followed by ACK).
	I2C_I2C_CR1_ALERTEN_B_0x1 = 0x1
	// Position of PECEN field.
	I2C_I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_I2C_CR1_PECEN_B_0x0 = 0x0
	// PEC calculation enabled
	I2C_I2C_CR1_PECEN_B_0x1 = 0x1

	// I2C_CR2: Control register 2
	// Position of SADD field.
	I2C_I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_I2C_CR2_SADD_Msk = 0x3ff
	// Position of RD_WRN field.
	I2C_I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer.
	I2C_I2C_CR2_RD_WRN_B_0x0 = 0x0
	// Master requests a read transfer.
	I2C_I2C_CR2_RD_WRN_B_0x1 = 0x1
	// Position of ADD10 field.
	I2C_I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode,
	I2C_I2C_CR2_ADD10_B_0x0 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_I2C_CR2_ADD10_B_0x1 = 0x1
	// Position of HEAD10R field.
	I2C_I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence: Start + 2 bytes 10bit address in write direction + Restart + 1st 7 bits of the 10 bit address in read direction.
	I2C_I2C_CR2_HEAD10R_B_0x0 = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction.
	I2C_I2C_CR2_HEAD10R_B_0x1 = 0x1
	// Position of START field.
	I2C_I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_I2C_CR2_START = 0x2000
	// No Start generation.
	I2C_I2C_CR2_START_B_0x0 = 0x0
	// Restart/Start generation:
	I2C_I2C_CR2_START_B_0x1 = 0x1
	// Position of STOP field.
	I2C_I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_I2C_CR2_STOP = 0x4000
	// No Stop generation.
	I2C_I2C_CR2_STOP_B_0x0 = 0x0
	// Stop generation after current byte transfer.
	I2C_I2C_CR2_STOP_B_0x1 = 0x1
	// Position of NACK field.
	I2C_I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte.
	I2C_I2C_CR2_NACK_B_0x0 = 0x0
	// a NACK is sent after current received byte.
	I2C_I2C_CR2_NACK_B_0x1 = 0x1
	// Position of NBYTES field.
	I2C_I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of RELOAD field.
	I2C_I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART follows).
	I2C_I2C_CR2_RELOAD_B_0x0 = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES is reloaded). TCR flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_I2C_CR2_RELOAD_B_0x1 = 0x1
	// Position of AUTOEND field.
	I2C_I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_I2C_CR2_AUTOEND = 0x2000000
	// software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low.
	I2C_I2C_CR2_AUTOEND_B_0x0 = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred.
	I2C_I2C_CR2_AUTOEND_B_0x1 = 0x1
	// Position of PECBYTE field.
	I2C_I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer.
	I2C_I2C_CR2_PECBYTE_B_0x0 = 0x0
	// PEC transmission/reception is requested
	I2C_I2C_CR2_PECBYTE_B_0x1 = 0x1

	// I2C_OAR1: Own address register 1
	// Position of OA1 field.
	I2C_I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address.
	I2C_I2C_OAR1_OA1MODE_B_0x0 = 0x0
	// Own address 1 is a 10-bit address.
	I2C_I2C_OAR1_OA1MODE_B_0x1 = 0x1
	// Position of OA1EN field.
	I2C_I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed.
	I2C_I2C_OAR1_OA1EN_B_0x0 = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed.
	I2C_I2C_OAR1_OA1EN_B_0x1 = 0x1

	// I2C_OAR2: Own address register 2
	// Position of OA2 field.
	I2C_I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_I2C_OAR2_OA2MSK_B_0x0 = 0x0
	// OA2[1] is masked and donât care. Only OA2[7:2] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x1 = 0x1
	// OA2[2:1] are masked and donât care. Only OA2[7:3] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x2 = 0x2
	// OA2[3:1] are masked and donât care. Only OA2[7:4] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x3 = 0x3
	// OA2[4:1] are masked and donât care. Only OA2[7:5] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x4 = 0x4
	// OA2[5:1] are masked and donât care. Only OA2[7:6] are compared.
	I2C_I2C_OAR2_OA2MSK_B_0x5 = 0x5
	// OA2[6:1] are masked and donât care. Only OA2[7] is compared.
	I2C_I2C_OAR2_OA2MSK_B_0x6 = 0x6
	// OA2[7:1] are masked and donât care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged.
	I2C_I2C_OAR2_OA2MSK_B_0x7 = 0x7
	// Position of OA2EN field.
	I2C_I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed.
	I2C_I2C_OAR2_OA2EN_B_0x0 = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed.
	I2C_I2C_OAR2_OA2EN_B_0x1 = 0x1

	// I2C_TIMINGR: Timing register
	// Position of SCLL field.
	I2C_I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// I2C_TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_I2C_TIMEOUTR_TIDLE_B_0x0 = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_I2C_TIMEOUTR_TIDLE_B_0x1 = 0x1
	// Position of TIMOUTEN field.
	I2C_I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_I2C_TIMEOUTR_TIMOUTEN_B_0x0 = 0x0
	// SCL timeout detection is enabled: when SCL is low for more than tTIMEOUT (TIDLE=0) or high for more than tIDLE (TIDLE=1), a timeout error is detected (TIMEOUT=1).
	I2C_I2C_TIMEOUTR_TIMOUTEN_B_0x1 = 0x1
	// Position of TIMEOUTB field.
	I2C_I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_I2C_TIMEOUTR_TEXTEN_B_0x0 = 0x0
	// Extended clock timeout detection is enabled. When a cumulative SCL stretch for more than tLOW:EXT is done by the I2C interface, a timeout error is detected (TIMEOUT=1).
	I2C_I2C_TIMEOUTR_TEXTEN_B_0x1 = 0x1

	// I2C_ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode.
	I2C_I2C_ISR_DIR_B_0x0 = 0x0
	// Read transfer, slave enters transmitter mode.
	I2C_I2C_ISR_DIR_B_0x1 = 0x1
	// Position of BUSY field.
	I2C_I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_I2C_ISR_BUSY = 0x8000
	// Position of ALERT field.
	I2C_I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_I2C_ISR_ALERT = 0x2000
	// Position of TIMEOUT field.
	I2C_I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_I2C_ISR_TIMEOUT = 0x1000
	// Position of PECERR field.
	I2C_I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_I2C_ISR_PECERR = 0x800
	// Position of OVR field.
	I2C_I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_I2C_ISR_OVR = 0x400
	// Position of ARLO field.
	I2C_I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_I2C_ISR_ARLO = 0x200
	// Position of BERR field.
	I2C_I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_I2C_ISR_BERR = 0x100
	// Position of TCR field.
	I2C_I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_I2C_ISR_TCR = 0x80
	// Position of TC field.
	I2C_I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_I2C_ISR_TC = 0x40
	// Position of STOPF field.
	I2C_I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_I2C_ISR_STOPF = 0x20
	// Position of NACKF field.
	I2C_I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_I2C_ISR_NACKF = 0x10
	// Position of ADDR field.
	I2C_I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_I2C_ISR_ADDR = 0x8
	// Position of RXNE field.
	I2C_I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_I2C_ISR_RXNE = 0x4
	// Position of TXIS field.
	I2C_I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_I2C_ISR_TXIS = 0x2
	// Position of TXE field.
	I2C_I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_I2C_ISR_TXE = 0x1

	// I2C_ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_I2C_ICR_ALERTCF = 0x2000
	// Position of TIMOUTCF field.
	I2C_I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_I2C_ICR_TIMOUTCF = 0x1000
	// Position of PECCF field.
	I2C_I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_I2C_ICR_PECCF = 0x800
	// Position of OVRCF field.
	I2C_I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_I2C_ICR_OVRCF = 0x400
	// Position of ARLOCF field.
	I2C_I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_I2C_ICR_ARLOCF = 0x200
	// Position of BERRCF field.
	I2C_I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_I2C_ICR_BERRCF = 0x100
	// Position of STOPCF field.
	I2C_I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_I2C_ICR_STOPCF = 0x20
	// Position of NACKCF field.
	I2C_I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_I2C_ICR_NACKCF = 0x10
	// Position of ADDRCF field.
	I2C_I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_I2C_ICR_ADDRCF = 0x8

	// I2C_PECR: PEC register
	// Position of PEC field.
	I2C_I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_I2C_PECR_PEC_Msk = 0xff

	// I2C_RXDR: Receive data register
	// Position of RXDATA field.
	I2C_I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_I2C_RXDR_RXDATA_Msk = 0xff

	// I2C_TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_I2C_TXDR_TXDATA_Msk = 0xff
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// divider /4
	IWDG_PR_PR_B_0x0 = 0x0
	// divider /8
	IWDG_PR_PR_B_0x1 = 0x1
	// divider /16
	IWDG_PR_PR_B_0x2 = 0x2
	// divider /32
	IWDG_PR_PR_B_0x3 = 0x3
	// divider /64
	IWDG_PR_PR_B_0x4 = 0x4
	// divider /128
	IWDG_PR_PR_B_0x5 = 0x5
	// divider /256
	IWDG_PR_PR_B_0x6 = 0x6
	// divider /256
	IWDG_PR_PR_B_0x7 = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Constants for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_B_0x0 = 0x0
	// Counter enabled
	TIM_CR1_CEN_B_0x1 = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// UEV enabled. The Update (UEV) event is generated by one of the following events:
	TIM_CR1_UDIS_B_0x0 = 0x0
	// UEV disabled. The Update event is not generated, shadow registers keep their value (ARR, PSC, CCRx). However the counter and the prescaler are reinitialized if the UG bit is set or if a hardware reset is received from the slave mode controller.
	TIM_CR1_UDIS_B_0x1 = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of the following events generate an update interrupt or DMA request if enabled. These events can be:
	TIM_CR1_URS_B_0x0 = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request if enabled.
	TIM_CR1_URS_B_0x1 = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_B_0x0 = 0x0
	// Counter stops counting at the next update event (clearing the bit CEN)
	TIM_CR1_OPM_B_0x1 = 0x1
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_B_0x0 = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_B_0x1 = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// Edge-aligned mode. The counter counts up or down depending on the direction bit (DIR).
	TIM_CR1_CMS_B_0x0 = 0x0
	// Center-aligned mode 1. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set only when the counter is counting down.
	TIM_CR1_CMS_B_0x1 = 0x1
	// Center-aligned mode 2. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set only when the counter is counting up.
	TIM_CR1_CMS_B_0x2 = 0x2
	// Center-aligned mode 3. The counter counts up and down alternatively. Output compare interrupt flags of channels configured in output (CCxS=00 in TIMx_CCMRx register) are set both when the counter is counting up or down.
	TIM_CR1_CMS_B_0x3 = 0x3
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_ARR register is not buffered
	TIM_CR1_ARPE_B_0x0 = 0x0
	// TIMx_ARR register is buffered
	TIM_CR1_ARPE_B_0x1 = 0x1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// tDTS=tCK_INT
	TIM_CR1_CKD_B_0x0 = 0x0
	// tDTS=2*tCK_INT
	TIM_CR1_CKD_B_0x1 = 0x1
	// tDTS=4*tCK_INT
	TIM_CR1_CKD_B_0x2 = 0x2
	// Reserved, do not program this value
	TIM_CR1_CKD_B_0x3 = 0x3
	// Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIM_CR1_UIFREMAP = 0x800
	// No remapping. UIF status bit is not copied to TIMx_CNT register bit 31.
	TIM_CR1_UIFREMAP_B_0x0 = 0x0
	// Remapping enabled. UIF status bit is copied to TIMx_CNT register bit 31.
	TIM_CR1_UIFREMAP_B_0x1 = 0x1

	// CR2: control register 2
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1
	// CCxE, CCxNE and OCxM bits are not preloaded
	TIM_CR2_CCPC_B_0x0 = 0x0
	// CCxE, CCxNE and OCxM bits are preloaded, after having been written, they are updated only when a commutation event (COM) occurs (COMG bit set or rising edge detected on TRGI, depending on the CCUS bit).
	TIM_CR2_CCPC_B_0x1 = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// When capture/compare control bits are preloaded (CCPC=1), they are updated by setting the COMG bit only
	TIM_CR2_CCUS_B_0x0 = 0x0
	// When capture/compare control bits are preloaded (CCPC=1), they are updated by setting the COMG bit or when an rising edge occurs on TRGI
	TIM_CR2_CCUS_B_0x1 = 0x1
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_B_0x0 = 0x0
	// CCx DMA requests sent when update event occurs
	TIM_CR2_CCDS_B_0x1 = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// Reset - the UG bit from the TIMx_EGR register is used as trigger output (TRGO). If the reset is generated by the trigger input (slave mode controller configured in reset mode) then the signal on TRGO is delayed compared to the actual reset.
	TIM_CR2_MMS_B_0x0 = 0x0
	// Enable - the Counter Enable signal CNT_EN is used as trigger output (TRGO). It is useful to start several timers at the same time or to control a window in which a slave timer is enable. The Counter Enable signal is generated by a logic AND between CEN control bit and the trigger input when configured in gated mode. When the Counter Enable signal is controlled by the trigger input, there is a delay on TRGO, except if the master/slave mode is selected (see the MSM bit description in TIMx_SMCR register).
	TIM_CR2_MMS_B_0x1 = 0x1
	// Update - The update event is selected as trigger output (TRGO). For instance a master timer can then be used as a prescaler for a slave timer.
	TIM_CR2_MMS_B_0x2 = 0x2
	// Compare Pulse - The trigger output send a positive pulse when the CC1IF flag is to be set (even if it was already high), as soon as a capture or a compare match occurred. (TRGO).
	TIM_CR2_MMS_B_0x3 = 0x3
	// Compare - OC1REFC signal is used as trigger output (TRGO)
	TIM_CR2_MMS_B_0x4 = 0x4
	// Compare - OC2REFC signal is used as trigger output (TRGO)
	TIM_CR2_MMS_B_0x5 = 0x5
	// Compare - OC3REFC signal is used as trigger output (TRGO)
	TIM_CR2_MMS_B_0x6 = 0x6
	// Compare - OC4REFC signal is used as trigger output (TRGO)
	TIM_CR2_MMS_B_0x7 = 0x7
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_B_0x0 = 0x0
	// The TIMx_CH1, CH2 and CH3 pins are connected to the TI1 input (XOR combination)
	TIM_CR2_TI1S_B_0x1 = 0x1
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// OC1=0 (after a dead-time if OC1N is implemented) when MOE=0
	TIM_CR2_OIS1_B_0x0 = 0x0
	// OC1=1 (after a dead-time if OC1N is implemented) when MOE=0
	TIM_CR2_OIS1_B_0x1 = 0x1
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// OC1N=0 after a dead-time when MOE=0
	TIM_CR2_OIS1N_B_0x0 = 0x0
	// OC1N=1 after a dead-time when MOE=0
	TIM_CR2_OIS1N_B_0x1 = 0x1
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS5 field.
	TIM_CR2_OIS5_Pos = 0x10
	// Bit mask of OIS5 field.
	TIM_CR2_OIS5_Msk = 0x10000
	// Bit OIS5.
	TIM_CR2_OIS5 = 0x10000
	// Position of OIS6 field.
	TIM_CR2_OIS6_Pos = 0x12
	// Bit mask of OIS6 field.
	TIM_CR2_OIS6_Msk = 0x40000
	// Bit OIS6.
	TIM_CR2_OIS6 = 0x40000
	// Position of MMS2 field.
	TIM_CR2_MMS2_Pos = 0x14
	// Bit mask of MMS2 field.
	TIM_CR2_MMS2_Msk = 0xf00000
	// Reset - the UG bit from the TIMx_EGR register is used as trigger output (TRGO2). If the reset is generated by the trigger input (slave mode controller configured in reset mode), the signal on TRGO2 is delayed compared to the actual reset.
	TIM_CR2_MMS2_B_0x0 = 0x0
	// Enable - the Counter Enable signal CNT_EN is used as trigger output (TRGO2). It is useful to start several timers at the same time or to control a window in which a slave timer is enabled. The Counter Enable signal is generated by a logic AND between the CEN control bit and the trigger input when configured in Gated mode. When the Counter Enable signal is controlled by the trigger input, there is a delay on TRGO2, except if the Master/Slave mode is selected (see the MSM bit description in TIMx_SMCR register).
	TIM_CR2_MMS2_B_0x1 = 0x1
	// Update - the update event is selected as trigger output (TRGO2). For instance, a master timer can then be used as a prescaler for a slave timer.
	TIM_CR2_MMS2_B_0x2 = 0x2
	// Compare pulse - the trigger output sends a positive pulse when the CC1IF flag is to be set (even if it was already high), as soon as a capture or compare match occurs (TRGO2).
	TIM_CR2_MMS2_B_0x3 = 0x3
	// Compare - OC1REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x4 = 0x4
	// Compare - OC2REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x5 = 0x5
	// Compare - OC3REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x6 = 0x6
	// Compare - OC4REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x7 = 0x7
	// Compare - OC5REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x8 = 0x8
	// Compare - OC6REFC signal is used as trigger output (TRGO2)
	TIM_CR2_MMS2_B_0x9 = 0x9
	// Compare Pulse - OC4REFC rising or falling edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xA = 0xa
	// Compare Pulse - OC6REFC rising or falling edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xB = 0xb
	// Compare Pulse - OC4REFC or OC6REFC rising edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xC = 0xc
	// Compare Pulse - OC4REFC rising or OC6REFC falling edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xD = 0xd
	// Compare Pulse - OC5REFC or OC6REFC rising edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xE = 0xe
	// Compare Pulse - OC5REFC rising or OC6REFC falling edges generate pulses on TRGO2
	TIM_CR2_MMS2_B_0xF = 0xf

	// SMCR: slave mode control register
	// Position of SMS1 field.
	TIM_SMCR_SMS1_Pos = 0x0
	// Bit mask of SMS1 field.
	TIM_SMCR_SMS1_Msk = 0x7
	// Position of OCCS field.
	TIM_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	TIM_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	TIM_SMCR_OCCS = 0x8
	// OCREF_CLR_INT is connected to COMP1 or COMP2 output depending on TIM1_OR1.OCREF_CLR
	TIM_SMCR_OCCS_B_0x0 = 0x0
	// OCREF_CLR_INT is connected to ETRF
	TIM_SMCR_OCCS_B_0x1 = 0x1
	// Position of TS1 field.
	TIM_SMCR_TS1_Pos = 0x4
	// Bit mask of TS1 field.
	TIM_SMCR_TS1_Msk = 0x70
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_B_0x0 = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_B_0x1 = 0x1
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_B_0xF = 0xf
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_B_0x0 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_B_0x1 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_B_0x2 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_B_0x3 = 0x3
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_B_0x0 = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_B_0x1 = 0x1
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is non-inverted, active at high level or rising edge.
	TIM_SMCR_ETP_B_0x0 = 0x0
	// ETR is inverted, active at low level or falling edge.
	TIM_SMCR_ETP_B_0x1 = 0x1
	// Position of SMS2 field.
	TIM_SMCR_SMS2_Pos = 0x10
	// Bit mask of SMS2 field.
	TIM_SMCR_SMS2_Msk = 0x10000
	// Bit SMS2.
	TIM_SMCR_SMS2 = 0x10000
	// Position of TS2 field.
	TIM_SMCR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	TIM_SMCR_TS2_Msk = 0x300000

	// DIER: DMA/Interrupt enable register
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_B_0x0 = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_B_0x1 = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CC1 interrupt disabled
	TIM_DIER_CC1IE_B_0x0 = 0x0
	// CC1 interrupt enabled
	TIM_DIER_CC1IE_B_0x1 = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CC2 interrupt disabled
	TIM_DIER_CC2IE_B_0x0 = 0x0
	// CC2 interrupt enabled
	TIM_DIER_CC2IE_B_0x1 = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CC3 interrupt disabled
	TIM_DIER_CC3IE_B_0x0 = 0x0
	// CC3 interrupt enabled
	TIM_DIER_CC3IE_B_0x1 = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CC4 interrupt disabled
	TIM_DIER_CC4IE_B_0x0 = 0x0
	// CC4 interrupt enabled
	TIM_DIER_CC4IE_B_0x1 = 0x1
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// COM interrupt disabled
	TIM_DIER_COMIE_B_0x0 = 0x0
	// COM interrupt enabled
	TIM_DIER_COMIE_B_0x1 = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_B_0x0 = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_B_0x1 = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Break interrupt disabled
	TIM_DIER_BIE_B_0x0 = 0x0
	// Break interrupt enabled
	TIM_DIER_BIE_B_0x1 = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_B_0x0 = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_B_0x1 = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CC1 DMA request disabled
	TIM_DIER_CC1DE_B_0x0 = 0x0
	// CC1 DMA request enabled
	TIM_DIER_CC1DE_B_0x1 = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CC2 DMA request disabled
	TIM_DIER_CC2DE_B_0x0 = 0x0
	// CC2 DMA request enabled
	TIM_DIER_CC2DE_B_0x1 = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CC3 DMA request disabled
	TIM_DIER_CC3DE_B_0x0 = 0x0
	// CC3 DMA request enabled
	TIM_DIER_CC3DE_B_0x1 = 0x1
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CC4 DMA request disabled
	TIM_DIER_CC4DE_B_0x0 = 0x0
	// CC4 DMA request enabled
	TIM_DIER_CC4DE_B_0x1 = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// COM DMA request disabled
	TIM_DIER_COMDE_B_0x0 = 0x0
	// COM DMA request enabled
	TIM_DIER_COMDE_B_0x1 = 0x1
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_B_0x0 = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_B_0x1 = 0x1

	// SR: status register
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred.
	TIM_SR_UIF_B_0x0 = 0x0
	// Update interrupt pending. This bit is set by hardware when the registers are updated:
	TIM_SR_UIF_B_0x1 = 0x1
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// No compare match / No input capture occurred
	TIM_SR_CC1IF_B_0x0 = 0x0
	// A compare match or an input capture occurred.
	TIM_SR_CC1IF_B_0x1 = 0x1
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// No COM event occurred.
	TIM_SR_COMIF_B_0x0 = 0x0
	// COM interrupt pending.
	TIM_SR_COMIF_B_0x1 = 0x1
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred.
	TIM_SR_TIF_B_0x0 = 0x0
	// Trigger interrupt pending.
	TIM_SR_TIF_B_0x1 = 0x1
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// No break event occurred.
	TIM_SR_BIF_B_0x0 = 0x0
	// An active level has been detected on the break input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_SR_BIF_B_0x1 = 0x1
	// Position of B2IF field.
	TIM_SR_B2IF_Pos = 0x8
	// Bit mask of B2IF field.
	TIM_SR_B2IF_Msk = 0x100
	// Bit B2IF.
	TIM_SR_B2IF = 0x100
	// No break event occurred.
	TIM_SR_B2IF_B_0x0 = 0x0
	// An active level has been detected on the break 2 input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_SR_B2IF_B_0x1 = 0x1
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// No overcapture has been detected.
	TIM_SR_CC1OF_B_0x0 = 0x0
	// The counter value has been captured in TIMx_CCR1 register while CC1IF flag was already set
	TIM_SR_CC1OF_B_0x1 = 0x1
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// Position of SBIF field.
	TIM_SR_SBIF_Pos = 0xd
	// Bit mask of SBIF field.
	TIM_SR_SBIF_Msk = 0x2000
	// Bit SBIF.
	TIM_SR_SBIF = 0x2000
	// No break event occurred.
	TIM_SR_SBIF_B_0x0 = 0x0
	// An active level has been detected on the system break input. An interrupt is generated if BIE=1 in the TIMx_DIER register.
	TIM_SR_SBIF_B_0x1 = 0x1
	// Position of CC5IF field.
	TIM_SR_CC5IF_Pos = 0x10
	// Bit mask of CC5IF field.
	TIM_SR_CC5IF_Msk = 0x10000
	// Bit CC5IF.
	TIM_SR_CC5IF = 0x10000
	// Position of CC6IF field.
	TIM_SR_CC6IF_Pos = 0x11
	// Bit mask of CC6IF field.
	TIM_SR_CC6IF_Msk = 0x20000
	// Bit CC6IF.
	TIM_SR_CC6IF = 0x20000

	// EGR: event generation register
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// No action
	TIM_EGR_UG_B_0x0 = 0x0
	// Reinitialize the counter and generates an update of the registers. The prescaler internal counter is also cleared (the prescaler ratio is not affected). The counter is cleared if the center-aligned mode is selected or if DIR=0 (upcounting), else it takes the auto-reload value (TIMx_ARR) if DIR=1 (downcounting).
	TIM_EGR_UG_B_0x1 = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// No action
	TIM_EGR_CC1G_B_0x0 = 0x0
	// A capture/compare event is generated on channel 1:
	TIM_EGR_CC1G_B_0x1 = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// No action
	TIM_EGR_COMG_B_0x0 = 0x0
	// When CCPC bit is set, it allows CCxE, CCxNE and OCxM bits to be updated.
	TIM_EGR_COMG_B_0x1 = 0x1
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// No action
	TIM_EGR_TG_B_0x0 = 0x0
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_B_0x1 = 0x1
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// No action
	TIM_EGR_BG_B_0x0 = 0x0
	// A break event is generated. MOE bit is cleared and BIF flag is set. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_BG_B_0x1 = 0x1
	// Position of B2G field.
	TIM_EGR_B2G_Pos = 0x8
	// Bit mask of B2G field.
	TIM_EGR_B2G_Msk = 0x100
	// Bit B2G.
	TIM_EGR_B2G = 0x100
	// No action
	TIM_EGR_B2G_B_0x0 = 0x0
	// A break 2 event is generated. MOE bit is cleared and B2IF flag is set. Related interrupt can occur if enabled.
	TIM_EGR_B2G_B_0x1 = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_B_0x0 = 0x0
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Output_CC1S_B_0x1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Output_CC1S_B_0x2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Output_CC1S_B_0x3 = 0x3
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// CC1 behaves normally depending on counter and CCR1 values even when the trigger is ON. The minimum delay to activate CC1 output when an edge occurs on the trigger input is 5 clock cycles.
	TIM_CCMR1_Output_OC1FE_B_0x0 = 0x0
	// An active edge on the trigger input acts like a compare match on CC1 output. Then, OC is set to the compare level independently from the result of the comparison. Delay to sample the trigger input and to activate CC1 output is reduced to 3 clock cycles. OCFE acts only if the channel is configured in PWM1 or PWM2 mode.
	TIM_CCMR1_Output_OC1FE_B_0x1 = 0x1
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on TIMx_CCR1 disabled. TIMx_CCR1 can be written at anytime, the new value is taken in account immediately.
	TIM_CCMR1_Output_OC1PE_B_0x0 = 0x0
	// Preload register on TIMx_CCR1 enabled. Read/Write operations access the preload register. TIMx_CCR1 preload value is loaded in the active register at each update event.
	TIM_CCMR1_Output_OC1PE_B_0x1 = 0x1
	// Position of OC1M1 field.
	TIM_CCMR1_Output_OC1M1_Pos = 0x4
	// Bit mask of OC1M1 field.
	TIM_CCMR1_Output_OC1M1_Msk = 0x70
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// OC1Ref is not affected by the ocref_clr_int signal
	TIM_CCMR1_Output_OC1CE_B_0x0 = 0x0
	// OC1Ref is cleared as soon as a High level is detected on ocref_clr_int signal (OCREF_CLR input or ETRF input)
	TIM_CCMR1_Output_OC1CE_B_0x1 = 0x1
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_B_0x0 = 0x0
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Output_CC2S_B_0x1 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Output_CC2S_B_0x2 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC. This mode is working only if an internal trigger input is selected through the TS bit (TIMx_SMCR register)
	TIM_CCMR1_Output_CC2S_B_0x3 = 0x3
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC1M2 field.
	TIM_CCMR1_Output_OC1M2_Pos = 0x10
	// Bit mask of OC1M2 field.
	TIM_CCMR1_Output_OC1M2_Msk = 0x10000
	// Bit OC1M2.
	TIM_CCMR1_Output_OC1M2 = 0x10000
	// Position of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	TIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR1_Output_OC2M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR1_Output_OC2M_3_Extended = 0x1

	// CCMR1_Input: capture/compare mode register 1 (output mode)
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Input_CC1S_B_0x0 = 0x0
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_B_0x1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_B_0x2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Input_CC1S_B_0x3 = 0x3
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// no prescaler, capture is done each time an edge is detected on the capture input
	TIM_CCMR1_Input_IC1PSC_B_0x0 = 0x0
	// capture is done once every 2 events
	TIM_CCMR1_Input_IC1PSC_B_0x1 = 0x1
	// capture is done once every 4 events
	TIM_CCMR1_Input_IC1PSC_B_0x2 = 0x2
	// capture is done once every 8 events
	TIM_CCMR1_Input_IC1PSC_B_0x3 = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_B_0xF = 0xf
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Input_CC2S_B_0x0 = 0x0
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_B_0x1 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_B_0x2 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR1_Input_CC2S_B_0x3 = 0x3
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_B_0x0 = 0x0
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Output_CC3S_B_0x1 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Output_CC3S_B_0x2 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Output_CC3S_B_0x3 = 0x3
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_B_0x0 = 0x0
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Output_CC4S_B_0x1 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Output_CC4S_B_0x2 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Output_CC4S_B_0x3 = 0x3
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	TIM_CCMR2_Output_OC3M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC3M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC3M_3_Extended = 0x1
	// Position of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	TIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC4M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC4M_3_Extended = 0x1

	// CCMR2_Input: capture/compare mode register 2 (output mode)
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Input_CC3S_B_0x0 = 0x0
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_B_0x1 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_B_0x2 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Input_CC3S_B_0x3 = 0x3
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Input_CC4S_B_0x0 = 0x0
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_B_0x1 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_B_0x2 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC. This mode is working only if an internal trigger input is selected through TS bit (TIMx_SMCR register)
	TIM_CCMR2_Input_CC4S_B_0x3 = 0x3
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000

	// CCER: capture/compare enable register
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1
	// Capture mode disabled / OC1 is not active (see below)
	TIM_CCER_CC1E_B_0x0 = 0x0
	// Capture mode enabled / OC1 signal is output on the corresponding output pin
	TIM_CCER_CC1E_B_0x1 = 0x1
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// OC1 active high (output mode) / Edge sensitivity selection (input mode, see below)
	TIM_CCER_CC1P_B_0x0 = 0x0
	// OC1 active low (output mode) / Edge sensitivity selection (input mode, see below)
	TIM_CCER_CC1P_B_0x1 = 0x1
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Off - OC1N is not active. OC1N level is then function of MOE, OSSI, OSSR, OIS1, OIS1N and CC1E bits.
	TIM_CCER_CC1NE_B_0x0 = 0x0
	// On - OC1N signal is output on the corresponding output pin depending on MOE, OSSI, OSSR, OIS1, OIS1N and CC1E bits.
	TIM_CCER_CC1NE_B_0x1 = 0x1
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// OC1N active high.
	TIM_CCER_CC1NP_B_0x0 = 0x0
	// OC1N active low.
	TIM_CCER_CC1NP_B_0x1 = 0x1
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000
	// Position of CC5E field.
	TIM_CCER_CC5E_Pos = 0x10
	// Bit mask of CC5E field.
	TIM_CCER_CC5E_Msk = 0x10000
	// Bit CC5E.
	TIM_CCER_CC5E = 0x10000
	// Position of CC5P field.
	TIM_CCER_CC5P_Pos = 0x11
	// Bit mask of CC5P field.
	TIM_CCER_CC5P_Msk = 0x20000
	// Bit CC5P.
	TIM_CCER_CC5P = 0x20000
	// Position of CC6E field.
	TIM_CCER_CC6E_Pos = 0x14
	// Bit mask of CC6E field.
	TIM_CCER_CC6E_Msk = 0x100000
	// Bit CC6E.
	TIM_CCER_CC6E = 0x100000
	// Position of CC6P field.
	TIM_CCER_CC6P_Pos = 0x15
	// Bit mask of CC6P field.
	TIM_CCER_CC6P_Msk = 0x200000
	// Bit CC6P.
	TIM_CCER_CC6P = 0x200000

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff
	// Position of UIFCPY field.
	TIM_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	TIM_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	TIM_CNT_UIFCPY = 0x80000000

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xffff

	// CCR1: capture/compare register 1
	// Position of CCR1 field.
	TIM_CCR1_CCR1_Pos = 0x0
	// Bit mask of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff

	// CCR2: capture/compare register 2
	// Position of CCR2 field.
	TIM_CCR2_CCR2_Pos = 0x0
	// Bit mask of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff

	// CCR3: capture/compare register 3
	// Position of CCR3 field.
	TIM_CCR3_CCR3_Pos = 0x0
	// Bit mask of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff

	// CCR4: capture/compare register 4
	// Position of CCR4 field.
	TIM_CCR4_CCR4_Pos = 0x0
	// Bit mask of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// LOCK OFF - No bit is write protected.
	TIM_BDTR_LOCK_B_0x0 = 0x0
	// LOCK Level 1 = DTG bits in TIMx_BDTR register, OISx and OISxN bits in TIMx_CR2 register and BK2BID, BKBID, BK2DSRM, BKDSRM, BK2P, BK2E, BK2F[3:0], BKF[3:0], AOE, BKP, BKE, OSSI, OSSR and DTG[7:0] bits in TIMx_BDTR register can no longer be written.
	TIM_BDTR_LOCK_B_0x1 = 0x1
	// LOCK Level 2 = LOCK Level 1 + CC Polarity bits (CCxP/CCxNP bits in TIMx_CCER register, as long as the related channel is configured in output through the CCxS bits) as well as OSSR and OSSI bits can no longer be written.
	TIM_BDTR_LOCK_B_0x2 = 0x2
	// LOCK Level 3 = LOCK Level 2 + CC Control bits (OCxM and OCxPE bits in TIMx_CCMRx registers, as long as the related channel is configured in output through the CCxS bits) can no longer be written.
	TIM_BDTR_LOCK_B_0x3 = 0x3
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled (the timer releases the output control which is taken over by the GPIO logic and which imposes a Hi-Z state).
	TIM_BDTR_OSSI_B_0x0 = 0x0
	// When inactive, OC/OCN outputs are first forced with their inactive level then forced to their idle level after the deadtime. The timer maintains its control over the output.
	TIM_BDTR_OSSI_B_0x1 = 0x1
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled (the timer releases the output control which is taken over by the GPIO logic, which forces a Hi-Z state).
	TIM_BDTR_OSSR_B_0x0 = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level as soon as CCxE=1 or CCxNE=1 (the output is still controlled by the timer).
	TIM_BDTR_OSSR_B_0x1 = 0x1
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Break function disabled
	TIM_BDTR_BKE_B_0x0 = 0x0
	// Break function enabled
	TIM_BDTR_BKE_B_0x1 = 0x1
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Break input BRK is active low
	TIM_BDTR_BKP_B_0x0 = 0x0
	// Break input BRK is active high
	TIM_BDTR_BKP_B_0x1 = 0x1
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// MOE can be set only by software
	TIM_BDTR_AOE_B_0x0 = 0x0
	// MOE can be set by software or automatically at the next update event (if none of the break inputs BRK and BRK2 is active)
	TIM_BDTR_AOE_B_0x1 = 0x1
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// In response to a break 2 event. OC and OCN outputs are disabled
	TIM_BDTR_MOE_B_0x0 = 0x0
	// OC and OCN outputs are enabled if their respective enable bits are set (CCxE, CCxNE in TIMx_CCER register).
	TIM_BDTR_MOE_B_0x1 = 0x1
	// Position of BKF field.
	TIM_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	TIM_BDTR_BKF_Msk = 0xf0000
	// No filter, BRK acts asynchronously
	TIM_BDTR_BKF_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_BDTR_BKF_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_BDTR_BKF_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_BDTR_BKF_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_BDTR_BKF_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_BDTR_BKF_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_BDTR_BKF_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_BDTR_BKF_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_BDTR_BKF_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_BDTR_BKF_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_BDTR_BKF_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_BDTR_BKF_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_BDTR_BKF_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_BDTR_BKF_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_BDTR_BKF_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_BDTR_BKF_B_0xF = 0xf
	// Position of BK2F field.
	TIM_BDTR_BK2F_Pos = 0x14
	// Bit mask of BK2F field.
	TIM_BDTR_BK2F_Msk = 0xf00000
	// No filter, BRK2 acts asynchronously
	TIM_BDTR_BK2F_B_0x0 = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_BDTR_BK2F_B_0x1 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_BDTR_BK2F_B_0x2 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_BDTR_BK2F_B_0x3 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_BDTR_BK2F_B_0x4 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_BDTR_BK2F_B_0x5 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_BDTR_BK2F_B_0x6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_BDTR_BK2F_B_0x7 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_BDTR_BK2F_B_0x8 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_BDTR_BK2F_B_0x9 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_BDTR_BK2F_B_0xA = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_BDTR_BK2F_B_0xB = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_BDTR_BK2F_B_0xC = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_BDTR_BK2F_B_0xD = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_BDTR_BK2F_B_0xE = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_BDTR_BK2F_B_0xF = 0xf
	// Position of BK2E field.
	TIM_BDTR_BK2E_Pos = 0x18
	// Bit mask of BK2E field.
	TIM_BDTR_BK2E_Msk = 0x1000000
	// Bit BK2E.
	TIM_BDTR_BK2E = 0x1000000
	// Break input BRK2 disabled
	TIM_BDTR_BK2E_B_0x0 = 0x0
	// Break input BRK2 enabled
	TIM_BDTR_BK2E_B_0x1 = 0x1
	// Position of BK2P field.
	TIM_BDTR_BK2P_Pos = 0x19
	// Bit mask of BK2P field.
	TIM_BDTR_BK2P_Msk = 0x2000000
	// Bit BK2P.
	TIM_BDTR_BK2P = 0x2000000
	// Break input BRK2 is active low
	TIM_BDTR_BK2P_B_0x0 = 0x0
	// Break input BRK2 is active high
	TIM_BDTR_BK2P_B_0x1 = 0x1
	// Position of BKDSRM field.
	TIM_BDTR_BKDSRM_Pos = 0x1a
	// Bit mask of BKDSRM field.
	TIM_BDTR_BKDSRM_Msk = 0x4000000
	// Bit BKDSRM.
	TIM_BDTR_BKDSRM = 0x4000000
	// Break input BRK is armed
	TIM_BDTR_BKDSRM_B_0x0 = 0x0
	// Break input BRK is disarmed
	TIM_BDTR_BKDSRM_B_0x1 = 0x1
	// Position of BK2DSRM field.
	TIM_BDTR_BK2DSRM_Pos = 0x1b
	// Bit mask of BK2DSRM field.
	TIM_BDTR_BK2DSRM_Msk = 0x8000000
	// Bit BK2DSRM.
	TIM_BDTR_BK2DSRM = 0x8000000
	// Position of BKBID field.
	TIM_BDTR_BKBID_Pos = 0x1c
	// Bit mask of BKBID field.
	TIM_BDTR_BKBID_Msk = 0x10000000
	// Bit BKBID.
	TIM_BDTR_BKBID = 0x10000000
	// Break input BRK in input mode
	TIM_BDTR_BKBID_B_0x0 = 0x0
	// Break input BRK in bidirectional mode
	TIM_BDTR_BKBID_B_0x1 = 0x1
	// Position of BK2BID field.
	TIM_BDTR_BK2BID_Pos = 0x1d
	// Bit mask of BK2BID field.
	TIM_BDTR_BK2BID_Msk = 0x20000000
	// Bit BK2BID.
	TIM_BDTR_BK2BID = 0x20000000

	// DCR: DMA control register
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f
	// TIMx_CR1,
	TIM_DCR_DBA_B_0x0 = 0x0
	// TIMx_CR2,
	TIM_DCR_DBA_B_0x1 = 0x1
	// TIMx_SMCR,
	TIM_DCR_DBA_B_0x2 = 0x2
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// 1 transfer
	TIM_DCR_DBL_B_0x0 = 0x0
	// 2 transfers
	TIM_DCR_DBL_B_0x1 = 0x1
	// 3 transfers
	TIM_DCR_DBL_B_0x2 = 0x2
	// 18 transfers
	TIM_DCR_DBL_B_0x11 = 0x11

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffffffff

	// OR1: option register 1
	// Position of OCREF_CLR field.
	TIM_OR1_OCREF_CLR_Pos = 0x0
	// Bit mask of OCREF_CLR field.
	TIM_OR1_OCREF_CLR_Msk = 0x1
	// Bit OCREF_CLR.
	TIM_OR1_OCREF_CLR = 0x1
	// COMP1 output is connected to the OCREF_CLR input
	TIM_OR1_OCREF_CLR_B_0x0 = 0x0
	// COMP2 output is connected to the OCREF_CLR input
	TIM_OR1_OCREF_CLR_B_0x1 = 0x1

	// CCMR3_Output: capture/compare mode register 2 (output mode)
	// Position of OC6M_3 field.
	TIM_CCMR3_Output_OC6M_3_Pos = 0x18
	// Bit mask of OC6M_3 field.
	TIM_CCMR3_Output_OC6M_3_Msk = 0x1000000
	// Bit OC6M_3.
	TIM_CCMR3_Output_OC6M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR3_Output_OC6M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR3_Output_OC6M_3_Extended = 0x1
	// Position of OC5M_3 field.
	TIM_CCMR3_Output_OC5M_3_Pos = 0x10
	// Bit mask of OC5M_3 field.
	TIM_CCMR3_Output_OC5M_3_Msk = 0x10000
	// Bit OC5M_3.
	TIM_CCMR3_Output_OC5M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR3_Output_OC5M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR3_Output_OC5M_3_Extended = 0x1
	// Position of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Pos = 0xf
	// Bit mask of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Msk = 0x8000
	// Bit OC6CE.
	TIM_CCMR3_Output_OC6CE = 0x8000
	// Position of OC6M field.
	TIM_CCMR3_Output_OC6M_Pos = 0xc
	// Bit mask of OC6M field.
	TIM_CCMR3_Output_OC6M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR3_Output_OC6M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR3_Output_OC6M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR3_Output_OC6M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR3_Output_OC6M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR3_Output_OC6M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR3_Output_OC6M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR3_Output_OC6M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR3_Output_OC6M_PwmMode2 = 0x7
	// Position of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Pos = 0xb
	// Bit mask of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Msk = 0x800
	// Bit OC6PE.
	TIM_CCMR3_Output_OC6PE = 0x800
	// Position of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Pos = 0xa
	// Bit mask of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Msk = 0x400
	// Bit OC6FE.
	TIM_CCMR3_Output_OC6FE = 0x400
	// Position of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Pos = 0x7
	// Bit mask of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Msk = 0x80
	// Bit OC5CE.
	TIM_CCMR3_Output_OC5CE = 0x80
	// Position of OC5M field.
	TIM_CCMR3_Output_OC5M_Pos = 0x4
	// Bit mask of OC5M field.
	TIM_CCMR3_Output_OC5M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR3_Output_OC5M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR3_Output_OC5M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR3_Output_OC5M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR3_Output_OC5M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR3_Output_OC5M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR3_Output_OC5M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR3_Output_OC5M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR3_Output_OC5M_PwmMode2 = 0x7
	// Position of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Pos = 0x3
	// Bit mask of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Msk = 0x8
	// Bit OC5PE.
	TIM_CCMR3_Output_OC5PE = 0x8
	// Position of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Pos = 0x2
	// Bit mask of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Msk = 0x4
	// Bit OC5FE.
	TIM_CCMR3_Output_OC5FE = 0x4

	// CCR5: capture/compare register 4
	// Position of CCR5 field.
	TIM_CCR5_CCR5_Pos = 0x0
	// Bit mask of CCR5 field.
	TIM_CCR5_CCR5_Msk = 0xffff
	// Position of GC5C1 field.
	TIM_CCR5_GC5C1_Pos = 0x1d
	// Bit mask of GC5C1 field.
	TIM_CCR5_GC5C1_Msk = 0x20000000
	// Bit GC5C1.
	TIM_CCR5_GC5C1 = 0x20000000
	// No effect of OC5REF on OC1REFC5
	TIM_CCR5_GC5C1_B_0x0 = 0x0
	// OC1REFC is the logical AND of OC1REFC and OC5REF
	TIM_CCR5_GC5C1_B_0x1 = 0x1
	// Position of GC5C2 field.
	TIM_CCR5_GC5C2_Pos = 0x1e
	// Bit mask of GC5C2 field.
	TIM_CCR5_GC5C2_Msk = 0x40000000
	// Bit GC5C2.
	TIM_CCR5_GC5C2 = 0x40000000
	// No effect of OC5REF on OC2REFC
	TIM_CCR5_GC5C2_B_0x0 = 0x0
	// OC2REFC is the logical AND of OC2REFC and OC5REF
	TIM_CCR5_GC5C2_B_0x1 = 0x1
	// Position of GC5C3 field.
	TIM_CCR5_GC5C3_Pos = 0x1f
	// Bit mask of GC5C3 field.
	TIM_CCR5_GC5C3_Msk = 0x80000000
	// Bit GC5C3.
	TIM_CCR5_GC5C3 = 0x80000000
	// No effect of OC5REF on OC3REFC
	TIM_CCR5_GC5C3_B_0x0 = 0x0
	// OC3REFC is the logical AND of OC3REFC and OC5REF
	TIM_CCR5_GC5C3_B_0x1 = 0x1

	// CCR6: capture/compare register 4
	// Position of CCR6 field.
	TIM_CCR6_CCR6_Pos = 0x0
	// Bit mask of CCR6 field.
	TIM_CCR6_CCR6_Msk = 0xffff

	// AF1: DMA address for full transfer
	// Position of BKINE field.
	TIM_AF1_BKINE_Pos = 0x0
	// Bit mask of BKINE field.
	TIM_AF1_BKINE_Msk = 0x1
	// Bit BKINE.
	TIM_AF1_BKINE = 0x1
	// BKIN input disabled
	TIM_AF1_BKINE_B_0x0 = 0x0
	// BKIN input enabled
	TIM_AF1_BKINE_B_0x1 = 0x1
	// Position of BKCMP1E field.
	TIM_AF1_BKCMP1E_Pos = 0x1
	// Bit mask of BKCMP1E field.
	TIM_AF1_BKCMP1E_Msk = 0x2
	// Bit BKCMP1E.
	TIM_AF1_BKCMP1E = 0x2
	// COMP1 input disabled
	TIM_AF1_BKCMP1E_B_0x0 = 0x0
	// COMP1 input enabled
	TIM_AF1_BKCMP1E_B_0x1 = 0x1
	// Position of BKCMP2E field.
	TIM_AF1_BKCMP2E_Pos = 0x2
	// Bit mask of BKCMP2E field.
	TIM_AF1_BKCMP2E_Msk = 0x4
	// Bit BKCMP2E.
	TIM_AF1_BKCMP2E = 0x4
	// COMP2 input disabled
	TIM_AF1_BKCMP2E_B_0x0 = 0x0
	// COMP2 input enabled
	TIM_AF1_BKCMP2E_B_0x1 = 0x1
	// Position of BKINP field.
	TIM_AF1_BKINP_Pos = 0x9
	// Bit mask of BKINP field.
	TIM_AF1_BKINP_Msk = 0x200
	// Bit BKINP.
	TIM_AF1_BKINP = 0x200
	// BKIN input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_AF1_BKINP_B_0x0 = 0x0
	// BKIN input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_AF1_BKINP_B_0x1 = 0x1
	// Position of BKCMP1P field.
	TIM_AF1_BKCMP1P_Pos = 0xa
	// Bit mask of BKCMP1P field.
	TIM_AF1_BKCMP1P_Msk = 0x400
	// Bit BKCMP1P.
	TIM_AF1_BKCMP1P = 0x400
	// COMP1 input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_AF1_BKCMP1P_B_0x0 = 0x0
	// COMP1 input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_AF1_BKCMP1P_B_0x1 = 0x1
	// Position of BKCMP2P field.
	TIM_AF1_BKCMP2P_Pos = 0xb
	// Bit mask of BKCMP2P field.
	TIM_AF1_BKCMP2P_Msk = 0x800
	// Bit BKCMP2P.
	TIM_AF1_BKCMP2P = 0x800
	// COMP2 input polarity is not inverted (active low if BKP=0, active high if BKP=1)
	TIM_AF1_BKCMP2P_B_0x0 = 0x0
	// COMP2 input polarity is inverted (active high if BKP=0, active low if BKP=1)
	TIM_AF1_BKCMP2P_B_0x1 = 0x1
	// Position of ETRSEL field.
	TIM_AF1_ETRSEL_Pos = 0xe
	// Bit mask of ETRSEL field.
	TIM_AF1_ETRSEL_Msk = 0x3c000
	// ETR legacy mode
	TIM_AF1_ETRSEL_B_0x0 = 0x0
	// COMP1 output
	TIM_AF1_ETRSEL_B_0x1 = 0x1
	// COMP2 output
	TIM_AF1_ETRSEL_B_0x2 = 0x2
	// ADC1 AWD1
	TIM_AF1_ETRSEL_B_0x3 = 0x3
	// ADC1 AWD2
	TIM_AF1_ETRSEL_B_0x4 = 0x4
	// ADC1 AWD3
	TIM_AF1_ETRSEL_B_0x5 = 0x5

	// AF2: DMA address for full transfer
	// Position of BK2INE field.
	TIM_AF2_BK2INE_Pos = 0x0
	// Bit mask of BK2INE field.
	TIM_AF2_BK2INE_Msk = 0x1
	// Bit BK2INE.
	TIM_AF2_BK2INE = 0x1
	// BKIN2 input disabled
	TIM_AF2_BK2INE_B_0x0 = 0x0
	// BKIN2 input enabled
	TIM_AF2_BK2INE_B_0x1 = 0x1
	// Position of BK2CMP1E field.
	TIM_AF2_BK2CMP1E_Pos = 0x1
	// Bit mask of BK2CMP1E field.
	TIM_AF2_BK2CMP1E_Msk = 0x2
	// Bit BK2CMP1E.
	TIM_AF2_BK2CMP1E = 0x2
	// COMP1 input disabled
	TIM_AF2_BK2CMP1E_B_0x0 = 0x0
	// COMP1 input enabled
	TIM_AF2_BK2CMP1E_B_0x1 = 0x1
	// Position of BK2CMP2E field.
	TIM_AF2_BK2CMP2E_Pos = 0x2
	// Bit mask of BK2CMP2E field.
	TIM_AF2_BK2CMP2E_Msk = 0x4
	// Bit BK2CMP2E.
	TIM_AF2_BK2CMP2E = 0x4
	// COMP2 input disabled
	TIM_AF2_BK2CMP2E_B_0x0 = 0x0
	// COMP2 input enabled
	TIM_AF2_BK2CMP2E_B_0x1 = 0x1
	// Position of BK2INP field.
	TIM_AF2_BK2INP_Pos = 0x9
	// Bit mask of BK2INP field.
	TIM_AF2_BK2INP_Msk = 0x200
	// Bit BK2INP.
	TIM_AF2_BK2INP = 0x200
	// BKIN2 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_AF2_BK2INP_B_0x0 = 0x0
	// BKIN2 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_AF2_BK2INP_B_0x1 = 0x1
	// Position of BK2CMP1P field.
	TIM_AF2_BK2CMP1P_Pos = 0xa
	// Bit mask of BK2CMP1P field.
	TIM_AF2_BK2CMP1P_Msk = 0x400
	// Bit BK2CMP1P.
	TIM_AF2_BK2CMP1P = 0x400
	// COMP1 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_AF2_BK2CMP1P_B_0x0 = 0x0
	// COMP1 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_AF2_BK2CMP1P_B_0x1 = 0x1
	// Position of BK2CMP2P field.
	TIM_AF2_BK2CMP2P_Pos = 0xb
	// Bit mask of BK2CMP2P field.
	TIM_AF2_BK2CMP2P_Msk = 0x800
	// Bit BK2CMP2P.
	TIM_AF2_BK2CMP2P = 0x800
	// COMP2 input polarity is not inverted (active low if BK2P=0, active high if BK2P=1)
	TIM_AF2_BK2CMP2P_B_0x0 = 0x0
	// COMP2 input polarity is inverted (active high if BK2P=0, active low if BK2P=1)
	TIM_AF2_BK2CMP2P_B_0x1 = 0x1

	// TISEL: TIM1 timer input selection register
	// Position of TI1SEL field.
	TIM_TISEL_TI1SEL_Pos = 0x0
	// Bit mask of TI1SEL field.
	TIM_TISEL_TI1SEL_Msk = 0xf
	// TIM1_CH1 input
	TIM_TISEL_TI1SEL_B_0x0 = 0x0
	// COMP1 output
	TIM_TISEL_TI1SEL_B_0x1 = 0x1
	// Position of TI2SEL field.
	TIM_TISEL_TI2SEL_Pos = 0x8
	// Bit mask of TI2SEL field.
	TIM_TISEL_TI2SEL_Msk = 0xf00
	// TIM1_CH2 input
	TIM_TISEL_TI2SEL_B_0x0 = 0x0
	// COMP2 output
	TIM_TISEL_TI2SEL_B_0x1 = 0x1
	// Position of TI3SEL field.
	TIM_TISEL_TI3SEL_Pos = 0x10
	// Bit mask of TI3SEL field.
	TIM_TISEL_TI3SEL_Msk = 0xf0000
	// TIM1_CH3 input
	TIM_TISEL_TI3SEL_B_0x0 = 0x0
	// Position of TI4SEL field.
	TIM_TISEL_TI4SEL_Pos = 0x18
	// Bit mask of TI4SEL field.
	TIM_TISEL_TI4SEL_Msk = 0xf000000
	// TIM1_CH4 input
	TIM_TISEL_TI4SEL_B_0x0 = 0x0
)

// Constants for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1_FIFO_ENABLED: Control register 1
	// Position of UE field.
	USART_CR1_FIFO_ENABLED_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_FIFO_ENABLED_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_FIFO_ENABLED_UE = 0x1
	// USART prescaler and outputs disabled, low-power mode
	USART_CR1_FIFO_ENABLED_UE_B_0x0 = 0x0
	// USART enabled
	USART_CR1_FIFO_ENABLED_UE_B_0x1 = 0x1
	// Position of UESM field.
	USART_CR1_FIFO_ENABLED_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_FIFO_ENABLED_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_FIFO_ENABLED_UESM = 0x2
	// USART not able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_ENABLED_UESM_B_0x0 = 0x0
	// USART able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_ENABLED_UESM_B_0x1 = 0x1
	// Position of RE field.
	USART_CR1_FIFO_ENABLED_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_FIFO_ENABLED_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_FIFO_ENABLED_RE = 0x4
	// Receiver is disabled
	USART_CR1_FIFO_ENABLED_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	USART_CR1_FIFO_ENABLED_RE_B_0x1 = 0x1
	// Position of TE field.
	USART_CR1_FIFO_ENABLED_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_FIFO_ENABLED_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_FIFO_ENABLED_TE = 0x8
	// Transmitter is disabled
	USART_CR1_FIFO_ENABLED_TE_B_0x0 = 0x0
	// Transmitter is enabled
	USART_CR1_FIFO_ENABLED_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	USART_CR1_FIFO_ENABLED_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_FIFO_ENABLED_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_FIFO_ENABLED_IDLEIE = 0x10
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_IDLEIE_B_0x0 = 0x0
	// USART interrupt generated whenever IDLE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_IDLEIE_B_0x1 = 0x1
	// Position of RXFNEIE field.
	USART_CR1_FIFO_ENABLED_RXFNEIE_Pos = 0x5
	// Bit mask of RXFNEIE field.
	USART_CR1_FIFO_ENABLED_RXFNEIE_Msk = 0x20
	// Bit RXFNEIE.
	USART_CR1_FIFO_ENABLED_RXFNEIE = 0x20
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RXFNEIE_B_0x0 = 0x0
	// USART interrupt generated whenever ORE = 1 or RXFNE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_RXFNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	USART_CR1_FIFO_ENABLED_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_FIFO_ENABLED_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_FIFO_ENABLED_TCIE = 0x40
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TCIE_B_0x0 = 0x0
	// USART interrupt generated whenever TC = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TCIE_B_0x1 = 0x1
	// Position of TXFNFIE field.
	USART_CR1_FIFO_ENABLED_TXFNFIE_Pos = 0x7
	// Bit mask of TXFNFIE field.
	USART_CR1_FIFO_ENABLED_TXFNFIE_Msk = 0x80
	// Bit TXFNFIE.
	USART_CR1_FIFO_ENABLED_TXFNFIE = 0x80
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TXFNFIE_B_0x0 = 0x0
	// USART interrupt generated whenever TXFNF =1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TXFNFIE_B_0x1 = 0x1
	// Position of PEIE field.
	USART_CR1_FIFO_ENABLED_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_FIFO_ENABLED_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_FIFO_ENABLED_PEIE = 0x100
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_PEIE_B_0x0 = 0x0
	// USART interrupt generated whenever PE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_PEIE_B_0x1 = 0x1
	// Position of PS field.
	USART_CR1_FIFO_ENABLED_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_FIFO_ENABLED_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_FIFO_ENABLED_PS = 0x200
	// Even parity
	USART_CR1_FIFO_ENABLED_PS_B_0x0 = 0x0
	// Odd parity
	USART_CR1_FIFO_ENABLED_PS_B_0x1 = 0x1
	// Position of PCE field.
	USART_CR1_FIFO_ENABLED_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_FIFO_ENABLED_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_FIFO_ENABLED_PCE = 0x400
	// Parity control disabled
	USART_CR1_FIFO_ENABLED_PCE_B_0x0 = 0x0
	// Parity control enabled
	USART_CR1_FIFO_ENABLED_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	USART_CR1_FIFO_ENABLED_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_FIFO_ENABLED_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_FIFO_ENABLED_WAKE = 0x800
	// Idle line
	USART_CR1_FIFO_ENABLED_WAKE_B_0x0 = 0x0
	// Address mark
	USART_CR1_FIFO_ENABLED_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	USART_CR1_FIFO_ENABLED_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_FIFO_ENABLED_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_FIFO_ENABLED_M0 = 0x1000
	// Position of MME field.
	USART_CR1_FIFO_ENABLED_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_FIFO_ENABLED_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_FIFO_ENABLED_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_FIFO_ENABLED_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	USART_CR1_FIFO_ENABLED_MME_B_0x1 = 0x1
	// Position of CMIE field.
	USART_CR1_FIFO_ENABLED_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_FIFO_ENABLED_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_FIFO_ENABLED_CMIE = 0x4000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_CMIE_B_0x0 = 0x0
	// USART interrupt generated when the CMF bit is set in the USART_ISR register.
	USART_CR1_FIFO_ENABLED_CMIE_B_0x1 = 0x1
	// Position of OVER8 field.
	USART_CR1_FIFO_ENABLED_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_FIFO_ENABLED_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_FIFO_ENABLED_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_FIFO_ENABLED_OVER8_B_0x0 = 0x0
	// Oversampling by 8
	USART_CR1_FIFO_ENABLED_OVER8_B_0x1 = 0x1
	// Position of DEDT field.
	USART_CR1_FIFO_ENABLED_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_FIFO_ENABLED_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	USART_CR1_FIFO_ENABLED_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_FIFO_ENABLED_DEAT_Msk = 0x3e00000
	// Position of RTOIE field.
	USART_CR1_FIFO_ENABLED_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_FIFO_ENABLED_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_FIFO_ENABLED_RTOIE = 0x4000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RTOIE_B_0x0 = 0x0
	// USART interrupt generated when the RTOF bit is set in the USART_ISR register.
	USART_CR1_FIFO_ENABLED_RTOIE_B_0x1 = 0x1
	// Position of EOBIE field.
	USART_CR1_FIFO_ENABLED_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_FIFO_ENABLED_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_FIFO_ENABLED_EOBIE = 0x8000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_EOBIE_B_0x0 = 0x0
	// USART interrupt generated when the EOBF flag is set in the USART_ISR register
	USART_CR1_FIFO_ENABLED_EOBIE_B_0x1 = 0x1
	// Position of M1 field.
	USART_CR1_FIFO_ENABLED_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_FIFO_ENABLED_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_FIFO_ENABLED_M1 = 0x10000000
	// Position of FIFOEN field.
	USART_CR1_FIFO_ENABLED_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFO_ENABLED_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFO_ENABLED_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	USART_CR1_FIFO_ENABLED_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	USART_CR1_FIFO_ENABLED_FIFOEN_B_0x1 = 0x1
	// Position of TXFEIE field.
	USART_CR1_FIFO_ENABLED_TXFEIE_Pos = 0x1e
	// Bit mask of TXFEIE field.
	USART_CR1_FIFO_ENABLED_TXFEIE_Msk = 0x40000000
	// Bit TXFEIE.
	USART_CR1_FIFO_ENABLED_TXFEIE = 0x40000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_TXFEIE_B_0x0 = 0x0
	// USART interrupt generated when TXFE = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_TXFEIE_B_0x1 = 0x1
	// Position of RXFFIE field.
	USART_CR1_FIFO_ENABLED_RXFFIE_Pos = 0x1f
	// Bit mask of RXFFIE field.
	USART_CR1_FIFO_ENABLED_RXFFIE_Msk = 0x80000000
	// Bit RXFFIE.
	USART_CR1_FIFO_ENABLED_RXFFIE = 0x80000000
	// Interrupt inhibited
	USART_CR1_FIFO_ENABLED_RXFFIE_B_0x0 = 0x0
	// USART interrupt generated when RXFF = 1 in the USART_ISR register
	USART_CR1_FIFO_ENABLED_RXFFIE_B_0x1 = 0x1

	// CR1_FIFO_DISABLED: Control register 1
	// Position of UE field.
	USART_CR1_FIFO_DISABLED_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_FIFO_DISABLED_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_FIFO_DISABLED_UE = 0x1
	// USART prescaler and outputs disabled, low-power mode
	USART_CR1_FIFO_DISABLED_UE_B_0x0 = 0x0
	// USART enabled
	USART_CR1_FIFO_DISABLED_UE_B_0x1 = 0x1
	// Position of UESM field.
	USART_CR1_FIFO_DISABLED_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_FIFO_DISABLED_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_FIFO_DISABLED_UESM = 0x2
	// USART not able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_DISABLED_UESM_B_0x0 = 0x0
	// USART able to wake up the MCU from low-power mode.
	USART_CR1_FIFO_DISABLED_UESM_B_0x1 = 0x1
	// Position of RE field.
	USART_CR1_FIFO_DISABLED_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_FIFO_DISABLED_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_FIFO_DISABLED_RE = 0x4
	// Receiver is disabled
	USART_CR1_FIFO_DISABLED_RE_B_0x0 = 0x0
	// Receiver is enabled and begins searching for a start bit
	USART_CR1_FIFO_DISABLED_RE_B_0x1 = 0x1
	// Position of TE field.
	USART_CR1_FIFO_DISABLED_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_FIFO_DISABLED_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_FIFO_DISABLED_TE = 0x8
	// Transmitter is disabled
	USART_CR1_FIFO_DISABLED_TE_B_0x0 = 0x0
	// Transmitter is enabled
	USART_CR1_FIFO_DISABLED_TE_B_0x1 = 0x1
	// Position of IDLEIE field.
	USART_CR1_FIFO_DISABLED_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_FIFO_DISABLED_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_FIFO_DISABLED_IDLEIE = 0x10
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_IDLEIE_B_0x0 = 0x0
	// USART interrupt generated whenever IDLE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_IDLEIE_B_0x1 = 0x1
	// Position of RXNEIE field.
	USART_CR1_FIFO_DISABLED_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_FIFO_DISABLED_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_FIFO_DISABLED_RXNEIE = 0x20
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_RXNEIE_B_0x0 = 0x0
	// USART interrupt generated whenever ORE = 1 or RXNE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_RXNEIE_B_0x1 = 0x1
	// Position of TCIE field.
	USART_CR1_FIFO_DISABLED_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_FIFO_DISABLED_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_FIFO_DISABLED_TCIE = 0x40
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_TCIE_B_0x0 = 0x0
	// USART interrupt generated whenever TC = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_TCIE_B_0x1 = 0x1
	// Position of TXEIE field.
	USART_CR1_FIFO_DISABLED_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_FIFO_DISABLED_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_FIFO_DISABLED_TXEIE = 0x80
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_TXEIE_B_0x0 = 0x0
	// USART interrupt generated whenever TXE =1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_TXEIE_B_0x1 = 0x1
	// Position of PEIE field.
	USART_CR1_FIFO_DISABLED_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_FIFO_DISABLED_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_FIFO_DISABLED_PEIE = 0x100
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_PEIE_B_0x0 = 0x0
	// USART interrupt generated whenever PE = 1 in the USART_ISR register
	USART_CR1_FIFO_DISABLED_PEIE_B_0x1 = 0x1
	// Position of PS field.
	USART_CR1_FIFO_DISABLED_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_FIFO_DISABLED_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_FIFO_DISABLED_PS = 0x200
	// Even parity
	USART_CR1_FIFO_DISABLED_PS_B_0x0 = 0x0
	// Odd parity
	USART_CR1_FIFO_DISABLED_PS_B_0x1 = 0x1
	// Position of PCE field.
	USART_CR1_FIFO_DISABLED_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_FIFO_DISABLED_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_FIFO_DISABLED_PCE = 0x400
	// Parity control disabled
	USART_CR1_FIFO_DISABLED_PCE_B_0x0 = 0x0
	// Parity control enabled
	USART_CR1_FIFO_DISABLED_PCE_B_0x1 = 0x1
	// Position of WAKE field.
	USART_CR1_FIFO_DISABLED_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_FIFO_DISABLED_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_FIFO_DISABLED_WAKE = 0x800
	// Idle line
	USART_CR1_FIFO_DISABLED_WAKE_B_0x0 = 0x0
	// Address mark
	USART_CR1_FIFO_DISABLED_WAKE_B_0x1 = 0x1
	// Position of M0 field.
	USART_CR1_FIFO_DISABLED_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_FIFO_DISABLED_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_FIFO_DISABLED_M0 = 0x1000
	// Position of MME field.
	USART_CR1_FIFO_DISABLED_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_FIFO_DISABLED_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_FIFO_DISABLED_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_FIFO_DISABLED_MME_B_0x0 = 0x0
	// Receiver can switch between Mute mode and active mode.
	USART_CR1_FIFO_DISABLED_MME_B_0x1 = 0x1
	// Position of CMIE field.
	USART_CR1_FIFO_DISABLED_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_FIFO_DISABLED_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_FIFO_DISABLED_CMIE = 0x4000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_CMIE_B_0x0 = 0x0
	// USART interrupt generated when the CMF bit is set in the USART_ISR register.
	USART_CR1_FIFO_DISABLED_CMIE_B_0x1 = 0x1
	// Position of OVER8 field.
	USART_CR1_FIFO_DISABLED_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_FIFO_DISABLED_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_FIFO_DISABLED_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_FIFO_DISABLED_OVER8_B_0x0 = 0x0
	// Oversampling by 8
	USART_CR1_FIFO_DISABLED_OVER8_B_0x1 = 0x1
	// Position of DEDT field.
	USART_CR1_FIFO_DISABLED_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_FIFO_DISABLED_DEDT_Msk = 0x1f0000
	// Position of DEAT field.
	USART_CR1_FIFO_DISABLED_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_FIFO_DISABLED_DEAT_Msk = 0x3e00000
	// Position of RTOIE field.
	USART_CR1_FIFO_DISABLED_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_FIFO_DISABLED_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_FIFO_DISABLED_RTOIE = 0x4000000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_RTOIE_B_0x0 = 0x0
	// USART interrupt generated when the RTOF bit is set in the USART_ISR register.
	USART_CR1_FIFO_DISABLED_RTOIE_B_0x1 = 0x1
	// Position of EOBIE field.
	USART_CR1_FIFO_DISABLED_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_FIFO_DISABLED_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_FIFO_DISABLED_EOBIE = 0x8000000
	// Interrupt inhibited
	USART_CR1_FIFO_DISABLED_EOBIE_B_0x0 = 0x0
	// USART interrupt generated when the EOBF flag is set in the USART_ISR register
	USART_CR1_FIFO_DISABLED_EOBIE_B_0x1 = 0x1
	// Position of M1 field.
	USART_CR1_FIFO_DISABLED_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_FIFO_DISABLED_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_FIFO_DISABLED_M1 = 0x10000000
	// Position of FIFOEN field.
	USART_CR1_FIFO_DISABLED_FIFOEN_Pos = 0x1d
	// Bit mask of FIFOEN field.
	USART_CR1_FIFO_DISABLED_FIFOEN_Msk = 0x20000000
	// Bit FIFOEN.
	USART_CR1_FIFO_DISABLED_FIFOEN = 0x20000000
	// FIFO mode is disabled.
	USART_CR1_FIFO_DISABLED_FIFOEN_B_0x0 = 0x0
	// FIFO mode is enabled.
	USART_CR1_FIFO_DISABLED_FIFOEN_B_0x1 = 0x1

	// CR2: Control register 2
	// Position of SLVEN field.
	USART_CR2_SLVEN_Pos = 0x0
	// Bit mask of SLVEN field.
	USART_CR2_SLVEN_Msk = 0x1
	// Bit SLVEN.
	USART_CR2_SLVEN = 0x1
	// Slave mode disabled.
	USART_CR2_SLVEN_B_0x0 = 0x0
	// Slave mode enabled.
	USART_CR2_SLVEN_B_0x1 = 0x1
	// Position of DIS_NSS field.
	USART_CR2_DIS_NSS_Pos = 0x3
	// Bit mask of DIS_NSS field.
	USART_CR2_DIS_NSS_Msk = 0x8
	// Bit DIS_NSS.
	USART_CR2_DIS_NSS = 0x8
	// SPI slave selection depends on NSS input pin.
	USART_CR2_DIS_NSS_B_0x0 = 0x0
	// SPI slave is always selected and NSS input pin is ignored.
	USART_CR2_DIS_NSS_B_0x1 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_B_0x0 = 0x0
	// 7-bit address detection (in 8-bit data mode)
	USART_CR2_ADDM7_B_0x1 = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_B_0x0 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_B_0x1 = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_B_0x0 = 0x0
	// An interrupt is generated whenever LBDF = 1 in the USART_ISR register
	USART_CR2_LBDIE_B_0x1 = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the SCLK pin
	USART_CR2_LBCL_B_0x0 = 0x0
	// The clock pulse of the last data bit is output to the SCLK pin
	USART_CR2_LBCL_B_0x1 = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_B_0x0 = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_B_0x1 = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on SCLK pin outside transmission window
	USART_CR2_CPOL_B_0x0 = 0x0
	// Steady high value on SCLK pin outside transmission window
	USART_CR2_CPOL_B_0x1 = 0x1
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// SCLK pin disabled
	USART_CR2_CLKEN_B_0x0 = 0x0
	// SCLK pin enabled
	USART_CR2_CLKEN_B_0x1 = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_B_0x0 = 0x0
	// 0.5 stop bit.
	USART_CR2_STOP_B_0x1 = 0x1
	// 2 stop bits
	USART_CR2_STOP_B_0x2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_B_0x3 = 0x3
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_B_0x0 = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_B_0x1 = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_B_0x0 = 0x0
	// The TX and RX pins functions are swapped. This enables to work in the case of a cross-wired connection to another UART.
	USART_CR2_SWAP_B_0x1 = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels (VDD =1/idle, Gnd = 0/mark)
	USART_CR2_RXINV_B_0x0 = 0x0
	// RX pin signal values are inverted (VDD =0/mark, Gnd = 1/idle).
	USART_CR2_RXINV_B_0x1 = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels (VDD =1/idle, Gnd = 0/mark)
	USART_CR2_TXINV_B_0x0 = 0x0
	// TX pin signal values are inverted (VDD =0/mark, Gnd = 1/idle).
	USART_CR2_TXINV_B_0x1 = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic. (1 = H, 0 = L)
	USART_CR2_DATAINV_B_0x0 = 0x0
	// Logical data from the data register are send/received in negative/inverse logic. (1 = L, 0 = H). The parity bit is also inverted.
	USART_CR2_DATAINV_B_0x1 = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit.
	USART_CR2_MSBFIRST_B_0x0 = 0x0
	// data is transmitted/received with the MSB (bit 7/8) first, following the start bit.
	USART_CR2_MSBFIRST_B_0x1 = 0x1
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled.
	USART_CR2_ABREN_B_0x0 = 0x0
	// Auto baud rate detection is enabled.
	USART_CR2_ABREN_B_0x1 = 0x1
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate.
	USART_CR2_ABRMOD_B_0x0 = 0x0
	// Falling edge to falling edge measurement (the received frame must start with a single bit = 1 and Frame = Start10xxxxxx)
	USART_CR2_ABRMOD_B_0x1 = 0x1
	// 0x7F frame detection.
	USART_CR2_ABRMOD_B_0x2 = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_B_0x3 = 0x3
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled.
	USART_CR2_RTOEN_B_0x0 = 0x0
	// Receiver timeout feature enabled.
	USART_CR2_RTOEN_B_0x1 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000

	// CR3: Control register 3
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt inhibited
	USART_CR3_EIE_B_0x0 = 0x0
	// interrupt generated when FE = 1 or ORE = 1 or NE = 1 or UDR = 1 (in SPI slave mode) in the USART_ISR register.
	USART_CR3_EIE_B_0x1 = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_B_0x0 = 0x0
	// IrDA enabled
	USART_CR3_IREN_B_0x1 = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_B_0x0 = 0x0
	// Low-power mode
	USART_CR3_IRLP_B_0x1 = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_B_0x0 = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_B_0x1 = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_B_0x0 = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_B_0x1 = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_B_0x0 = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_B_0x1 = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is enabled for reception
	USART_CR3_DMAR_B_0x1 = 0x1
	// DMA mode is disabled for reception
	USART_CR3_DMAR_B_0x0 = 0x0
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_B_0x1 = 0x1
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_B_0x0 = 0x0
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_B_0x0 = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer. The transmission of data is expected to cease after the current character has been transmitted. The nRTS output is asserted (pulled to 0) when data can be received.
	USART_CR3_RTSE_B_0x1 = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_B_0x0 = 0x0
	// CTS mode enabled, data is only transmitted when the nCTS input is asserted (tied to 0). If the nCTS input is deasserted while data is being transmitted, then the transmission is completed before stopping. If data is written into the data register while nCTS is asserted, the transmission is postponed until nCTS is asserted.
	USART_CR3_CTSE_B_0x1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_B_0x0 = 0x0
	// An interrupt is generated whenever CTSIF = 1 in the USART_ISR register
	USART_CR3_CTSIE_B_0x1 = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_B_0x0 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_B_0x1 = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data.
	USART_CR3_OVRDIS_B_0x0 = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set
	USART_CR3_OVRDIS_B_0x1 = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error. The corresponding error flag is set but RXNE is kept 0 preventing from overrun. As a consequence, the DMA request is not asserted, so the erroneous data is not transferred (no DMA request), but next correct received data is transferred (used for Smartcard mode).
	USART_CR3_DDRE_B_0x0 = 0x0
	// DMA is disabled following a reception error. The corresponding error flag is set, as well as RXNE. The DMA request is masked until the error flag is cleared. This means that the software must first disable the DMA request (DMAR = 0) or clear RXNE/RXFNE is case FIFO mode is enabled) before clearing the error flag.
	USART_CR3_DDRE_B_0x1 = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled.
	USART_CR3_DEM_B_0x0 = 0x0
	// DE function is enabled. The DE signal is output on the RTS pin.
	USART_CR3_DEM_B_0x1 = 0x1
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high.
	USART_CR3_DEP_B_0x0 = 0x0
	// DE signal is active low.
	USART_CR3_DEP_B_0x1 = 0x1
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// retransmission disabled - No automatic retransmission in transmit mode.
	USART_CR3_SCARCNT_B_0x0 = 0x0
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x1 = 0x1
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x2 = 0x2
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x3 = 0x3
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x4 = 0x4
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x5 = 0x5
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x6 = 0x6
	// number of automatic retransmission attempts (before signaling error)
	USART_CR3_SCARCNT_B_0x7 = 0x7
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match (as defined by ADD[7:0] and ADDM7)
	USART_CR3_WUS_B_0x0 = 0x0
	// WUF active on start bit detection
	USART_CR3_WUS_B_0x2 = 0x2
	// WUF active on RXNE/RXFNE.
	USART_CR3_WUS_B_0x3 = 0x3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt inhibited
	USART_CR3_WUFIE_B_0x0 = 0x0
	// USART interrupt generated whenever WUF = 1 in the USART_ISR register
	USART_CR3_WUFIE_B_0x1 = 0x1
	// Position of TXFTIE field.
	USART_CR3_TXFTIE_Pos = 0x17
	// Bit mask of TXFTIE field.
	USART_CR3_TXFTIE_Msk = 0x800000
	// Bit TXFTIE.
	USART_CR3_TXFTIE = 0x800000
	// Interrupt inhibited
	USART_CR3_TXFTIE_B_0x0 = 0x0
	// USART interrupt generated when TXFIFO reaches the threshold programmed in TXFTCFG.
	USART_CR3_TXFTIE_B_0x1 = 0x1
	// Position of TCBGTIE field.
	USART_CR3_TCBGTIE_Pos = 0x18
	// Bit mask of TCBGTIE field.
	USART_CR3_TCBGTIE_Msk = 0x1000000
	// Bit TCBGTIE.
	USART_CR3_TCBGTIE = 0x1000000
	// Interrupt inhibited
	USART_CR3_TCBGTIE_B_0x0 = 0x0
	// USART interrupt generated whenever TCBGT=1 in the USART_ISR register
	USART_CR3_TCBGTIE_B_0x1 = 0x1
	// Position of RXFTCFG field.
	USART_CR3_RXFTCFG_Pos = 0x19
	// Bit mask of RXFTCFG field.
	USART_CR3_RXFTCFG_Msk = 0xe000000
	// Receive FIFO reaches 1/8 of its depth
	USART_CR3_RXFTCFG_B_0x0 = 0x0
	// Receive FIFO reaches 1/4 of its depth
	USART_CR3_RXFTCFG_B_0x1 = 0x1
	// Receive FIFO reaches 1/2 of its depth
	USART_CR3_RXFTCFG_B_0x2 = 0x2
	// Receive FIFO reaches 3/4 of its depth
	USART_CR3_RXFTCFG_B_0x3 = 0x3
	// Receive FIFO reaches 7/8 of its depth
	USART_CR3_RXFTCFG_B_0x4 = 0x4
	// Receive FIFO becomes full
	USART_CR3_RXFTCFG_B_0x5 = 0x5
	// Position of RXFTIE field.
	USART_CR3_RXFTIE_Pos = 0x1c
	// Bit mask of RXFTIE field.
	USART_CR3_RXFTIE_Msk = 0x10000000
	// Bit RXFTIE.
	USART_CR3_RXFTIE = 0x10000000
	// Interrupt inhibited
	USART_CR3_RXFTIE_B_0x0 = 0x0
	// USART interrupt generated when Receive FIFO reaches the threshold programmed in RXFTCFG.
	USART_CR3_RXFTIE_B_0x1 = 0x1
	// Position of TXFTCFG field.
	USART_CR3_TXFTCFG_Pos = 0x1d
	// Bit mask of TXFTCFG field.
	USART_CR3_TXFTCFG_Msk = 0xe0000000
	// TXFIFO reaches 1/8 of its depth
	USART_CR3_TXFTCFG_B_0x0 = 0x0
	// TXFIFO reaches 1/4 of its depth
	USART_CR3_TXFTCFG_B_0x1 = 0x1
	// TXFIFO reaches 1/2 of its depth
	USART_CR3_TXFTCFG_B_0x2 = 0x2
	// TXFIFO reaches 3/4 of its depth
	USART_CR3_TXFTCFG_B_0x3 = 0x3
	// TXFIFO reaches 7/8 of its depth
	USART_CR3_TXFTCFG_B_0x4 = 0x4
	// TXFIFO becomes empty
	USART_CR3_TXFTCFG_B_0x5 = 0x5

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
	// Reserved - do not program this value
	USART_GTPR_PSC_B_0x0 = 0x0
	// Divides the source clock by 1 (IrDA mode) / by 2 (Smarcard mode)
	USART_GTPR_PSC_B_0x1 = 0x1
	// Divides the source clock by 2 (IrDA mode) / by 4 (Smartcard mode)
	USART_GTPR_PSC_B_0x2 = 0x2
	// Divides the source clock by 3 (IrDA mode) / by 6 (Smartcard mode)
	USART_GTPR_PSC_B_0x3 = 0x3
	// Divides the source clock by 31 (IrDA mode) / by 62 (Smartcard mode)
	USART_GTPR_PSC_B_0x1F = 0x1f
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00

	// RTOR: Receiver timeout register
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000

	// RQR: Request register
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10

	// ISR_FIFO_ENABLED: Interrupt & status register
	// Position of PE field.
	USART_ISR_FIFO_ENABLED_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_FIFO_ENABLED_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_FIFO_ENABLED_PE = 0x1
	// No parity error
	USART_ISR_FIFO_ENABLED_PE_B_0x0 = 0x0
	// Parity error
	USART_ISR_FIFO_ENABLED_PE_B_0x1 = 0x1
	// Position of FE field.
	USART_ISR_FIFO_ENABLED_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FIFO_ENABLED_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FIFO_ENABLED_FE = 0x2
	// No Framing error is detected
	USART_ISR_FIFO_ENABLED_FE_B_0x0 = 0x0
	// Framing error or break character is detected
	USART_ISR_FIFO_ENABLED_FE_B_0x1 = 0x1
	// Position of NE field.
	USART_ISR_FIFO_ENABLED_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_FIFO_ENABLED_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_FIFO_ENABLED_NE = 0x4
	// No noise is detected
	USART_ISR_FIFO_ENABLED_NE_B_0x0 = 0x0
	// Noise is detected
	USART_ISR_FIFO_ENABLED_NE_B_0x1 = 0x1
	// Position of ORE field.
	USART_ISR_FIFO_ENABLED_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_FIFO_ENABLED_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_FIFO_ENABLED_ORE = 0x8
	// No overrun error
	USART_ISR_FIFO_ENABLED_ORE_B_0x0 = 0x0
	// Overrun error is detected
	USART_ISR_FIFO_ENABLED_ORE_B_0x1 = 0x1
	// Position of IDLE field.
	USART_ISR_FIFO_ENABLED_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_FIFO_ENABLED_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_FIFO_ENABLED_IDLE = 0x10
	// No Idle line is detected
	USART_ISR_FIFO_ENABLED_IDLE_B_0x0 = 0x0
	// Idle line is detected
	USART_ISR_FIFO_ENABLED_IDLE_B_0x1 = 0x1
	// Position of RXFNE field.
	USART_ISR_FIFO_ENABLED_RXFNE_Pos = 0x5
	// Bit mask of RXFNE field.
	USART_ISR_FIFO_ENABLED_RXFNE_Msk = 0x20
	// Bit RXFNE.
	USART_ISR_FIFO_ENABLED_RXFNE = 0x20
	// Data is not received
	USART_ISR_FIFO_ENABLED_RXFNE_B_0x0 = 0x0
	// Received data is ready to be read.
	USART_ISR_FIFO_ENABLED_RXFNE_B_0x1 = 0x1
	// Position of TC field.
	USART_ISR_FIFO_ENABLED_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_FIFO_ENABLED_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_FIFO_ENABLED_TC = 0x40
	// Transmission is not complete
	USART_ISR_FIFO_ENABLED_TC_B_0x0 = 0x0
	// Transmission is complete
	USART_ISR_FIFO_ENABLED_TC_B_0x1 = 0x1
	// Position of TXFNF field.
	USART_ISR_FIFO_ENABLED_TXFNF_Pos = 0x7
	// Bit mask of TXFNF field.
	USART_ISR_FIFO_ENABLED_TXFNF_Msk = 0x80
	// Bit TXFNF.
	USART_ISR_FIFO_ENABLED_TXFNF = 0x80
	// Transmit FIFO is full
	USART_ISR_FIFO_ENABLED_TXFNF_B_0x0 = 0x0
	// Transmit FIFO is not full
	USART_ISR_FIFO_ENABLED_TXFNF_B_0x1 = 0x1
	// Position of LBDF field.
	USART_ISR_FIFO_ENABLED_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_FIFO_ENABLED_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_FIFO_ENABLED_LBDF = 0x100
	// LIN Break not detected
	USART_ISR_FIFO_ENABLED_LBDF_B_0x0 = 0x0
	// LIN break detected
	USART_ISR_FIFO_ENABLED_LBDF_B_0x1 = 0x1
	// Position of CTSIF field.
	USART_ISR_FIFO_ENABLED_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_FIFO_ENABLED_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_FIFO_ENABLED_CTSIF = 0x200
	// No change occurred on the nCTS status line
	USART_ISR_FIFO_ENABLED_CTSIF_B_0x0 = 0x0
	// A change occurred on the nCTS status line
	USART_ISR_FIFO_ENABLED_CTSIF_B_0x1 = 0x1
	// Position of CTS field.
	USART_ISR_FIFO_ENABLED_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_FIFO_ENABLED_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_FIFO_ENABLED_CTS = 0x400
	// nCTS line set
	USART_ISR_FIFO_ENABLED_CTS_B_0x0 = 0x0
	// nCTS line reset
	USART_ISR_FIFO_ENABLED_CTS_B_0x1 = 0x1
	// Position of RTOF field.
	USART_ISR_FIFO_ENABLED_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_FIFO_ENABLED_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_FIFO_ENABLED_RTOF = 0x800
	// Timeout value not reached
	USART_ISR_FIFO_ENABLED_RTOF_B_0x0 = 0x0
	// Timeout value reached without any data reception
	USART_ISR_FIFO_ENABLED_RTOF_B_0x1 = 0x1
	// Position of EOBF field.
	USART_ISR_FIFO_ENABLED_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_FIFO_ENABLED_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_FIFO_ENABLED_EOBF = 0x1000
	// End of Block not reached
	USART_ISR_FIFO_ENABLED_EOBF_B_0x0 = 0x0
	// End of Block (number of characters) reached
	USART_ISR_FIFO_ENABLED_EOBF_B_0x1 = 0x1
	// Position of UDR field.
	USART_ISR_FIFO_ENABLED_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_FIFO_ENABLED_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_FIFO_ENABLED_UDR = 0x2000
	// No underrun error
	USART_ISR_FIFO_ENABLED_UDR_B_0x0 = 0x0
	// underrun error
	USART_ISR_FIFO_ENABLED_UDR_B_0x1 = 0x1
	// Position of ABRE field.
	USART_ISR_FIFO_ENABLED_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_FIFO_ENABLED_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_FIFO_ENABLED_ABRE = 0x4000
	// Position of ABRF field.
	USART_ISR_FIFO_ENABLED_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_FIFO_ENABLED_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_FIFO_ENABLED_ABRF = 0x8000
	// Position of BUSY field.
	USART_ISR_FIFO_ENABLED_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_FIFO_ENABLED_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_FIFO_ENABLED_BUSY = 0x10000
	// USART is idle (no reception)
	USART_ISR_FIFO_ENABLED_BUSY_B_0x0 = 0x0
	// Reception on going
	USART_ISR_FIFO_ENABLED_BUSY_B_0x1 = 0x1
	// Position of CMF field.
	USART_ISR_FIFO_ENABLED_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_FIFO_ENABLED_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_FIFO_ENABLED_CMF = 0x20000
	// No Character match detected
	USART_ISR_FIFO_ENABLED_CMF_B_0x0 = 0x0
	// Character Match detected
	USART_ISR_FIFO_ENABLED_CMF_B_0x1 = 0x1
	// Position of SBKF field.
	USART_ISR_FIFO_ENABLED_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_FIFO_ENABLED_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_FIFO_ENABLED_SBKF = 0x40000
	// Break character transmitted
	USART_ISR_FIFO_ENABLED_SBKF_B_0x0 = 0x0
	// Break character requested by setting SBKRQ bit in USART_RQR register
	USART_ISR_FIFO_ENABLED_SBKF_B_0x1 = 0x1
	// Position of RWU field.
	USART_ISR_FIFO_ENABLED_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_FIFO_ENABLED_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_FIFO_ENABLED_RWU = 0x80000
	// Receiver in active mode
	USART_ISR_FIFO_ENABLED_RWU_B_0x0 = 0x0
	// Receiver in Mute mode
	USART_ISR_FIFO_ENABLED_RWU_B_0x1 = 0x1
	// Position of WUF field.
	USART_ISR_FIFO_ENABLED_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_FIFO_ENABLED_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_FIFO_ENABLED_WUF = 0x100000
	// Position of TEACK field.
	USART_ISR_FIFO_ENABLED_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_FIFO_ENABLED_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_FIFO_ENABLED_TEACK = 0x200000
	// Position of REACK field.
	USART_ISR_FIFO_ENABLED_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_FIFO_ENABLED_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_FIFO_ENABLED_REACK = 0x400000
	// Position of TXFE field.
	USART_ISR_FIFO_ENABLED_TXFE_Pos = 0x17
	// Bit mask of TXFE field.
	USART_ISR_FIFO_ENABLED_TXFE_Msk = 0x800000
	// Bit TXFE.
	USART_ISR_FIFO_ENABLED_TXFE = 0x800000
	// TXFIFO not empty.
	USART_ISR_FIFO_ENABLED_TXFE_B_0x0 = 0x0
	// TXFIFO empty.
	USART_ISR_FIFO_ENABLED_TXFE_B_0x1 = 0x1
	// Position of RXFF field.
	USART_ISR_FIFO_ENABLED_RXFF_Pos = 0x18
	// Bit mask of RXFF field.
	USART_ISR_FIFO_ENABLED_RXFF_Msk = 0x1000000
	// Bit RXFF.
	USART_ISR_FIFO_ENABLED_RXFF = 0x1000000
	// RXFIFO not full.
	USART_ISR_FIFO_ENABLED_RXFF_B_0x0 = 0x0
	// RXFIFO Full.
	USART_ISR_FIFO_ENABLED_RXFF_B_0x1 = 0x1
	// Position of TCBGT field.
	USART_ISR_FIFO_ENABLED_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_FIFO_ENABLED_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_FIFO_ENABLED_TCBGT = 0x2000000
	// Transmission is not complete or transmission is complete unsuccessfully (i.e. a NACK is received from the card)
	USART_ISR_FIFO_ENABLED_TCBGT_B_0x0 = 0x0
	// Transmission is complete successfully (before Guard time completion and there is no NACK from the smart card).
	USART_ISR_FIFO_ENABLED_TCBGT_B_0x1 = 0x1
	// Position of RXFT field.
	USART_ISR_FIFO_ENABLED_RXFT_Pos = 0x1a
	// Bit mask of RXFT field.
	USART_ISR_FIFO_ENABLED_RXFT_Msk = 0x4000000
	// Bit RXFT.
	USART_ISR_FIFO_ENABLED_RXFT = 0x4000000
	// Receive FIFO does not reach the programmed threshold.
	USART_ISR_FIFO_ENABLED_RXFT_B_0x0 = 0x0
	// Receive FIFO reached the programmed threshold.
	USART_ISR_FIFO_ENABLED_RXFT_B_0x1 = 0x1
	// Position of TXFT field.
	USART_ISR_FIFO_ENABLED_TXFT_Pos = 0x1b
	// Bit mask of TXFT field.
	USART_ISR_FIFO_ENABLED_TXFT_Msk = 0x8000000
	// Bit TXFT.
	USART_ISR_FIFO_ENABLED_TXFT = 0x8000000
	// TXFIFO does not reach the programmed threshold.
	USART_ISR_FIFO_ENABLED_TXFT_B_0x0 = 0x0
	// TXFIFO reached the programmed threshold.
	USART_ISR_FIFO_ENABLED_TXFT_B_0x1 = 0x1

	// ISR_FIFO_DISABLED: Interrupt & status register
	// Position of PE field.
	USART_ISR_FIFO_DISABLED_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_FIFO_DISABLED_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_FIFO_DISABLED_PE = 0x1
	// No parity error
	USART_ISR_FIFO_DISABLED_PE_B_0x0 = 0x0
	// Parity error
	USART_ISR_FIFO_DISABLED_PE_B_0x1 = 0x1
	// Position of FE field.
	USART_ISR_FIFO_DISABLED_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FIFO_DISABLED_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FIFO_DISABLED_FE = 0x2
	// No Framing error is detected
	USART_ISR_FIFO_DISABLED_FE_B_0x0 = 0x0
	// Framing error or break character is detected
	USART_ISR_FIFO_DISABLED_FE_B_0x1 = 0x1
	// Position of NE field.
	USART_ISR_FIFO_DISABLED_NE_Pos = 0x2
	// Bit mask of NE field.
	USART_ISR_FIFO_DISABLED_NE_Msk = 0x4
	// Bit NE.
	USART_ISR_FIFO_DISABLED_NE = 0x4
	// No noise is detected
	USART_ISR_FIFO_DISABLED_NE_B_0x0 = 0x0
	// Noise is detected
	USART_ISR_FIFO_DISABLED_NE_B_0x1 = 0x1
	// Position of ORE field.
	USART_ISR_FIFO_DISABLED_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_FIFO_DISABLED_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_FIFO_DISABLED_ORE = 0x8
	// No overrun error
	USART_ISR_FIFO_DISABLED_ORE_B_0x0 = 0x0
	// Overrun error is detected
	USART_ISR_FIFO_DISABLED_ORE_B_0x1 = 0x1
	// Position of IDLE field.
	USART_ISR_FIFO_DISABLED_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_FIFO_DISABLED_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_FIFO_DISABLED_IDLE = 0x10
	// No Idle line is detected
	USART_ISR_FIFO_DISABLED_IDLE_B_0x0 = 0x0
	// Idle line is detected
	USART_ISR_FIFO_DISABLED_IDLE_B_0x1 = 0x1
	// Position of RXNE field.
	USART_ISR_FIFO_DISABLED_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_FIFO_DISABLED_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_FIFO_DISABLED_RXNE = 0x20
	// Data is not received
	USART_ISR_FIFO_DISABLED_RXNE_B_0x0 = 0x0
	// Received data is ready to be read.
	USART_ISR_FIFO_DISABLED_RXNE_B_0x1 = 0x1
	// Position of TC field.
	USART_ISR_FIFO_DISABLED_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_FIFO_DISABLED_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_FIFO_DISABLED_TC = 0x40
	// Transmission is not complete
	USART_ISR_FIFO_DISABLED_TC_B_0x0 = 0x0
	// Transmission is complete
	USART_ISR_FIFO_DISABLED_TC_B_0x1 = 0x1
	// Position of TXE field.
	USART_ISR_FIFO_DISABLED_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_FIFO_DISABLED_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_FIFO_DISABLED_TXE = 0x80
	// Data register full
	USART_ISR_FIFO_DISABLED_TXE_B_0x0 = 0x0
	// Data register not full
	USART_ISR_FIFO_DISABLED_TXE_B_0x1 = 0x1
	// Position of LBDF field.
	USART_ISR_FIFO_DISABLED_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_FIFO_DISABLED_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_FIFO_DISABLED_LBDF = 0x100
	// LIN Break not detected
	USART_ISR_FIFO_DISABLED_LBDF_B_0x0 = 0x0
	// LIN break detected
	USART_ISR_FIFO_DISABLED_LBDF_B_0x1 = 0x1
	// Position of CTSIF field.
	USART_ISR_FIFO_DISABLED_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_FIFO_DISABLED_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_FIFO_DISABLED_CTSIF = 0x200
	// No change occurred on the nCTS status line
	USART_ISR_FIFO_DISABLED_CTSIF_B_0x0 = 0x0
	// A change occurred on the nCTS status line
	USART_ISR_FIFO_DISABLED_CTSIF_B_0x1 = 0x1
	// Position of CTS field.
	USART_ISR_FIFO_DISABLED_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_FIFO_DISABLED_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_FIFO_DISABLED_CTS = 0x400
	// nCTS line set
	USART_ISR_FIFO_DISABLED_CTS_B_0x0 = 0x0
	// nCTS line reset
	USART_ISR_FIFO_DISABLED_CTS_B_0x1 = 0x1
	// Position of RTOF field.
	USART_ISR_FIFO_DISABLED_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_FIFO_DISABLED_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_FIFO_DISABLED_RTOF = 0x800
	// Timeout value not reached
	USART_ISR_FIFO_DISABLED_RTOF_B_0x0 = 0x0
	// Timeout value reached without any data reception
	USART_ISR_FIFO_DISABLED_RTOF_B_0x1 = 0x1
	// Position of EOBF field.
	USART_ISR_FIFO_DISABLED_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_FIFO_DISABLED_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_FIFO_DISABLED_EOBF = 0x1000
	// End of Block not reached
	USART_ISR_FIFO_DISABLED_EOBF_B_0x0 = 0x0
	// End of Block (number of characters) reached
	USART_ISR_FIFO_DISABLED_EOBF_B_0x1 = 0x1
	// Position of UDR field.
	USART_ISR_FIFO_DISABLED_UDR_Pos = 0xd
	// Bit mask of UDR field.
	USART_ISR_FIFO_DISABLED_UDR_Msk = 0x2000
	// Bit UDR.
	USART_ISR_FIFO_DISABLED_UDR = 0x2000
	// No underrun error
	USART_ISR_FIFO_DISABLED_UDR_B_0x0 = 0x0
	// underrun error
	USART_ISR_FIFO_DISABLED_UDR_B_0x1 = 0x1
	// Position of ABRE field.
	USART_ISR_FIFO_DISABLED_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_FIFO_DISABLED_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_FIFO_DISABLED_ABRE = 0x4000
	// Position of ABRF field.
	USART_ISR_FIFO_DISABLED_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_FIFO_DISABLED_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_FIFO_DISABLED_ABRF = 0x8000
	// Position of BUSY field.
	USART_ISR_FIFO_DISABLED_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_FIFO_DISABLED_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_FIFO_DISABLED_BUSY = 0x10000
	// USART is idle (no reception)
	USART_ISR_FIFO_DISABLED_BUSY_B_0x0 = 0x0
	// Reception on going
	USART_ISR_FIFO_DISABLED_BUSY_B_0x1 = 0x1
	// Position of CMF field.
	USART_ISR_FIFO_DISABLED_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_FIFO_DISABLED_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_FIFO_DISABLED_CMF = 0x20000
	// No Character match detected
	USART_ISR_FIFO_DISABLED_CMF_B_0x0 = 0x0
	// Character Match detected
	USART_ISR_FIFO_DISABLED_CMF_B_0x1 = 0x1
	// Position of SBKF field.
	USART_ISR_FIFO_DISABLED_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_FIFO_DISABLED_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_FIFO_DISABLED_SBKF = 0x40000
	// Break character transmitted
	USART_ISR_FIFO_DISABLED_SBKF_B_0x0 = 0x0
	// Break character requested by setting SBKRQ bit in USART_RQR register
	USART_ISR_FIFO_DISABLED_SBKF_B_0x1 = 0x1
	// Position of RWU field.
	USART_ISR_FIFO_DISABLED_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_FIFO_DISABLED_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_FIFO_DISABLED_RWU = 0x80000
	// Receiver in active mode
	USART_ISR_FIFO_DISABLED_RWU_B_0x0 = 0x0
	// Receiver in Mute mode
	USART_ISR_FIFO_DISABLED_RWU_B_0x1 = 0x1
	// Position of WUF field.
	USART_ISR_FIFO_DISABLED_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_FIFO_DISABLED_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_FIFO_DISABLED_WUF = 0x100000
	// Position of TEACK field.
	USART_ISR_FIFO_DISABLED_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_FIFO_DISABLED_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_FIFO_DISABLED_TEACK = 0x200000
	// Position of REACK field.
	USART_ISR_FIFO_DISABLED_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_FIFO_DISABLED_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_FIFO_DISABLED_REACK = 0x400000
	// Position of TCBGT field.
	USART_ISR_FIFO_DISABLED_TCBGT_Pos = 0x19
	// Bit mask of TCBGT field.
	USART_ISR_FIFO_DISABLED_TCBGT_Msk = 0x2000000
	// Bit TCBGT.
	USART_ISR_FIFO_DISABLED_TCBGT = 0x2000000
	// Transmission is not complete or transmission is complete unsuccessfully (i.e. a NACK is received from the card)
	USART_ISR_FIFO_DISABLED_TCBGT_B_0x0 = 0x0
	// Transmission is complete successfully (before Guard time completion and there is no NACK from the smart card).
	USART_ISR_FIFO_DISABLED_TCBGT_B_0x1 = 0x1

	// ICR: Interrupt flag clear register
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Position of NECF field.
	USART_ICR_NECF_Pos = 0x2
	// Bit mask of NECF field.
	USART_ICR_NECF_Msk = 0x4
	// Bit NECF.
	USART_ICR_NECF = 0x4
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Position of TXFECF field.
	USART_ICR_TXFECF_Pos = 0x5
	// Bit mask of TXFECF field.
	USART_ICR_TXFECF_Msk = 0x20
	// Bit TXFECF.
	USART_ICR_TXFECF = 0x20
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Position of TCBGTCF field.
	USART_ICR_TCBGTCF_Pos = 0x7
	// Bit mask of TCBGTCF field.
	USART_ICR_TCBGTCF_Msk = 0x80
	// Bit TCBGTCF.
	USART_ICR_TCBGTCF = 0x80
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Position of UDRCF field.
	USART_ICR_UDRCF_Pos = 0xd
	// Bit mask of UDRCF field.
	USART_ICR_UDRCF_Msk = 0x2000
	// Bit UDRCF.
	USART_ICR_UDRCF = 0x2000
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff

	// PRESC: Prescaler register
	// Position of PRESCALER field.
	USART_PRESC_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	USART_PRESC_PRESCALER_Msk = 0xf
	// input clock not divided
	USART_PRESC_PRESCALER_B_0x0 = 0x0
	// input clock divided by 2
	USART_PRESC_PRESCALER_B_0x1 = 0x1
	// input clock divided by 4
	USART_PRESC_PRESCALER_B_0x2 = 0x2
	// input clock divided by 6
	USART_PRESC_PRESCALER_B_0x3 = 0x3
	// input clock divided by 8
	USART_PRESC_PRESCALER_B_0x4 = 0x4
	// input clock divided by 10
	USART_PRESC_PRESCALER_B_0x5 = 0x5
	// input clock divided by 12
	USART_PRESC_PRESCALER_B_0x6 = 0x6
	// input clock divided by 16
	USART_PRESC_PRESCALER_B_0x7 = 0x7
	// input clock divided by 32
	USART_PRESC_PRESCALER_B_0x8 = 0x8
	// input clock divided by 64
	USART_PRESC_PRESCALER_B_0x9 = 0x9
	// input clock divided by 128
	USART_PRESC_PRESCALER_B_0xA = 0xa
	// input clock divided by 256
	USART_PRESC_PRESCALER_B_0xB = 0xb
)

// Constants for VREFBUF: System configuration controller
const (
	// CSR: VREFBUF control and status register
	// Position of ENVR field.
	VREFBUF_CSR_ENVR_Pos = 0x0
	// Bit mask of ENVR field.
	VREFBUF_CSR_ENVR_Msk = 0x1
	// Bit ENVR.
	VREFBUF_CSR_ENVR = 0x1
	// Internal voltage reference mode disable (external voltage reference mode).
	VREFBUF_CSR_ENVR_B_0x0 = 0x0
	// Internal voltage reference mode (reference buffer enable or hold mode) enable.
	VREFBUF_CSR_ENVR_B_0x1 = 0x1
	// Position of HIZ field.
	VREFBUF_CSR_HIZ_Pos = 0x1
	// Bit mask of HIZ field.
	VREFBUF_CSR_HIZ_Msk = 0x2
	// Bit HIZ.
	VREFBUF_CSR_HIZ = 0x2
	// VREF+ pin is internally connected to the voltage reference buffer output.
	VREFBUF_CSR_HIZ_B_0x0 = 0x0
	// VREF+ pin is high impedance.
	VREFBUF_CSR_HIZ_B_0x1 = 0x1
	// Position of VRS field.
	VREFBUF_CSR_VRS_Pos = 0x2
	// Bit mask of VRS field.
	VREFBUF_CSR_VRS_Msk = 0x4
	// Bit VRS.
	VREFBUF_CSR_VRS = 0x4
	// Voltage reference set to VREF_OUT1 (around 2.048 V).
	VREFBUF_CSR_VRS_B_0x0 = 0x0
	// Voltage reference set to VREF_OUT2 (around 2.5 V).
	VREFBUF_CSR_VRS_B_0x1 = 0x1
	// Position of VRR field.
	VREFBUF_CSR_VRR_Pos = 0x3
	// Bit mask of VRR field.
	VREFBUF_CSR_VRR_Msk = 0x8
	// Bit VRR.
	VREFBUF_CSR_VRR = 0x8
	// the voltage reference buffer output is not ready.
	VREFBUF_CSR_VRR_B_0x0 = 0x0
	// the voltage reference buffer output reached the requested level.
	VREFBUF_CSR_VRR_B_0x1 = 0x1

	// CCR: VREFBUF calibration control register
	// Position of TRIM field.
	VREFBUF_CCR_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	VREFBUF_CCR_TRIM_Msk = 0x3f
)

// Constants for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_B_0x0 = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_B_0x1 = 0x1

	// CFR: Configuration register
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0xb
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x3800
	// CK Counter Clock (PCLK div 4096) div 1
	WWDG_CFR_WDGTB_B_0x0 = 0x0
	// CK Counter Clock (PCLK div 4096) div 2
	WWDG_CFR_WDGTB_B_0x1 = 0x1
	// CK Counter Clock (PCLK div 4096) div 4
	WWDG_CFR_WDGTB_B_0x2 = 0x2
	// CK Counter Clock (PCLK div 4096) div 8
	WWDG_CFR_WDGTB_B_0x3 = 0x3
	// CK Counter Clock (PCLK div 4096) div 16
	WWDG_CFR_WDGTB_B_0x4 = 0x4
	// CK Counter Clock (PCLK div 4096) div 32
	WWDG_CFR_WDGTB_B_0x5 = 0x5
	// CK Counter Clock (PCLK div 4096) div 64
	WWDG_CFR_WDGTB_B_0x6 = 0x6
	// CK Counter Clock (PCLK div 4096) div 128
	WWDG_CFR_WDGTB_B_0x7 = 0x7

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
)

// Constants for DMA1: DMA controller
const (
	// ISR: low interrupt status register
	// Position of GIF1 field.
	DMA1_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA1_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA1_ISR_GIF1 = 0x1
	// Position of TCIF1 field.
	DMA1_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA1_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA1_ISR_TCIF1 = 0x2
	// Position of HTIF1 field.
	DMA1_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA1_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA1_ISR_HTIF1 = 0x4
	// Position of TEIF1 field.
	DMA1_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA1_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA1_ISR_TEIF1 = 0x8
	// Position of GIF2 field.
	DMA1_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA1_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA1_ISR_GIF2 = 0x10
	// Position of TCIF2 field.
	DMA1_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA1_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA1_ISR_TCIF2 = 0x20
	// Position of HTIF2 field.
	DMA1_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA1_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA1_ISR_HTIF2 = 0x40
	// Position of TEIF2 field.
	DMA1_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA1_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA1_ISR_TEIF2 = 0x80
	// Position of GIF3 field.
	DMA1_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA1_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA1_ISR_GIF3 = 0x100
	// Position of TCIF3 field.
	DMA1_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA1_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA1_ISR_TCIF3 = 0x200
	// Position of HTIF3 field.
	DMA1_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA1_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA1_ISR_HTIF3 = 0x400
	// Position of TEIF3 field.
	DMA1_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA1_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA1_ISR_TEIF3 = 0x800
	// Position of GIF4 field.
	DMA1_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA1_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA1_ISR_GIF4 = 0x1000
	// Position of TCIF4 field.
	DMA1_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA1_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA1_ISR_TCIF4 = 0x2000
	// Position of HTIF4 field.
	DMA1_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA1_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA1_ISR_HTIF4 = 0x4000
	// Position of TEIF4 field.
	DMA1_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA1_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA1_ISR_TEIF4 = 0x8000
	// Position of GIF5 field.
	DMA1_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA1_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA1_ISR_GIF5 = 0x10000
	// Position of TCIF5 field.
	DMA1_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA1_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA1_ISR_TCIF5 = 0x20000
	// Position of HTIF5 field.
	DMA1_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA1_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA1_ISR_HTIF5 = 0x40000
	// Position of TEIF5 field.
	DMA1_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA1_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA1_ISR_TEIF5 = 0x80000
	// Position of GIF6 field.
	DMA1_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA1_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA1_ISR_GIF6 = 0x100000
	// Position of TCIF6 field.
	DMA1_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA1_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA1_ISR_TCIF6 = 0x200000
	// Position of HTIF6 field.
	DMA1_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA1_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA1_ISR_HTIF6 = 0x400000
	// Position of TEIF6 field.
	DMA1_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA1_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA1_ISR_TEIF6 = 0x800000
	// Position of GIF7 field.
	DMA1_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA1_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA1_ISR_GIF7 = 0x1000000
	// Position of TCIF7 field.
	DMA1_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA1_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA1_ISR_TCIF7 = 0x2000000
	// Position of HTIF7 field.
	DMA1_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA1_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA1_ISR_HTIF7 = 0x4000000
	// Position of TEIF7 field.
	DMA1_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA1_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA1_ISR_TEIF7 = 0x8000000

	// IFCR: high interrupt status register
	// Position of CGIF1 field.
	DMA1_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA1_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA1_IFCR_CGIF1 = 0x1
	// Position of CTCIF1 field.
	DMA1_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA1_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA1_IFCR_CTCIF1 = 0x2
	// Position of CHTIF1 field.
	DMA1_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA1_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA1_IFCR_CHTIF1 = 0x4
	// Position of CTEIF1 field.
	DMA1_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA1_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA1_IFCR_CTEIF1 = 0x8
	// Position of CGIF2 field.
	DMA1_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA1_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA1_IFCR_CGIF2 = 0x10
	// Position of CTCIF2 field.
	DMA1_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA1_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA1_IFCR_CTCIF2 = 0x20
	// Position of CHTIF2 field.
	DMA1_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA1_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA1_IFCR_CHTIF2 = 0x40
	// Position of CTEIF2 field.
	DMA1_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA1_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA1_IFCR_CTEIF2 = 0x80
	// Position of CGIF3 field.
	DMA1_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA1_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA1_IFCR_CGIF3 = 0x100
	// Position of CTCIF3 field.
	DMA1_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA1_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA1_IFCR_CTCIF3 = 0x200
	// Position of CHTIF3 field.
	DMA1_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA1_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA1_IFCR_CHTIF3 = 0x400
	// Position of CTEIF3 field.
	DMA1_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA1_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA1_IFCR_CTEIF3 = 0x800
	// Position of CGIF4 field.
	DMA1_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA1_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA1_IFCR_CGIF4 = 0x1000
	// Position of CTCIF4 field.
	DMA1_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA1_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA1_IFCR_CTCIF4 = 0x2000
	// Position of CHTIF4 field.
	DMA1_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA1_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA1_IFCR_CHTIF4 = 0x4000
	// Position of CTEIF15 field.
	DMA1_IFCR_CTEIF15_Pos = 0xf
	// Bit mask of CTEIF15 field.
	DMA1_IFCR_CTEIF15_Msk = 0x8000
	// Bit CTEIF15.
	DMA1_IFCR_CTEIF15 = 0x8000
	// Position of CGIF5 field.
	DMA1_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA1_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA1_IFCR_CGIF5 = 0x10000
	// Position of CTCIF5 field.
	DMA1_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA1_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA1_IFCR_CTCIF5 = 0x20000
	// Position of CHTIF5 field.
	DMA1_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA1_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA1_IFCR_CHTIF5 = 0x40000
	// Position of CTEIF5 field.
	DMA1_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA1_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA1_IFCR_CTEIF5 = 0x80000
	// Position of CGIF6 field.
	DMA1_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA1_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA1_IFCR_CGIF6 = 0x100000
	// Position of CTCIF6 field.
	DMA1_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA1_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA1_IFCR_CTCIF6 = 0x200000
	// Position of CHTIF6 field.
	DMA1_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA1_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA1_IFCR_CHTIF6 = 0x400000
	// Position of CTEIF6 field.
	DMA1_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA1_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA1_IFCR_CTEIF6 = 0x800000
	// Position of CGIF7 field.
	DMA1_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA1_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA1_IFCR_CGIF7 = 0x1000000
	// Position of CTCIF7 field.
	DMA1_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA1_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA1_IFCR_CTCIF7 = 0x2000000
	// Position of CHTIF7 field.
	DMA1_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA1_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA1_IFCR_CHTIF7 = 0x4000000
	// Position of CTEIF7 field.
	DMA1_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA1_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA1_IFCR_CTEIF7 = 0x8000000

	// CH.CR: DMA channel 1 configuration register
	// Position of EN field.
	DMA1_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA1_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA1_CH_CR_EN = 0x1
	// Position of TCIE field.
	DMA1_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA1_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA1_CH_CR_TCIE = 0x2
	// Position of HTIE field.
	DMA1_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA1_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA1_CH_CR_HTIE = 0x4
	// Position of TEIE field.
	DMA1_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA1_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA1_CH_CR_TEIE = 0x8
	// Position of DIR field.
	DMA1_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA1_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA1_CH_CR_DIR = 0x10
	// Position of CIRC field.
	DMA1_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA1_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA1_CH_CR_CIRC = 0x20
	// Position of PINC field.
	DMA1_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA1_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA1_CH_CR_PINC = 0x40
	// Position of MINC field.
	DMA1_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA1_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA1_CH_CR_MINC = 0x80
	// Position of PSIZE field.
	DMA1_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA1_CH_CR_PSIZE_Msk = 0x300
	// Position of MSIZE field.
	DMA1_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA1_CH_CR_MSIZE_Msk = 0xc00
	// Position of PL field.
	DMA1_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA1_CH_CR_PL_Msk = 0x3000
	// Position of MEM2MEM field.
	DMA1_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA1_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA1_CH_CR_MEM2MEM = 0x4000

	// CH.NDTR: DMA channel 1 number of data tegister
	// Position of NDT field.
	DMA1_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA1_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel 1 peripheral address
	// Position of PA field.
	DMA1_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA1_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel 1 memory address
	// Position of MA field.
	DMA1_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA1_CH_MAR_MA_Msk = 0xffffffff
)

// Constants for DMA2: DMA controller
const (
	// ISR: low interrupt status register
	// Position of GIF1 field.
	DMA2_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA2_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA2_ISR_GIF1 = 0x1
	// Position of TCIF1 field.
	DMA2_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA2_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA2_ISR_TCIF1 = 0x2
	// Position of HTIF1 field.
	DMA2_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA2_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA2_ISR_HTIF1 = 0x4
	// Position of TEIF1 field.
	DMA2_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA2_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA2_ISR_TEIF1 = 0x8
	// Position of GIF2 field.
	DMA2_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA2_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA2_ISR_GIF2 = 0x10
	// Position of TCIF2 field.
	DMA2_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA2_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA2_ISR_TCIF2 = 0x20
	// Position of HTIF2 field.
	DMA2_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA2_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA2_ISR_HTIF2 = 0x40
	// Position of TEIF2 field.
	DMA2_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA2_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA2_ISR_TEIF2 = 0x80
	// Position of GIF3 field.
	DMA2_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA2_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA2_ISR_GIF3 = 0x100
	// Position of TCIF3 field.
	DMA2_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA2_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA2_ISR_TCIF3 = 0x200
	// Position of HTIF3 field.
	DMA2_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA2_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA2_ISR_HTIF3 = 0x400
	// Position of TEIF3 field.
	DMA2_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA2_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA2_ISR_TEIF3 = 0x800
	// Position of GIF4 field.
	DMA2_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA2_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA2_ISR_GIF4 = 0x1000
	// Position of TCIF4 field.
	DMA2_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA2_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA2_ISR_TCIF4 = 0x2000
	// Position of HTIF4 field.
	DMA2_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA2_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA2_ISR_HTIF4 = 0x4000
	// Position of TEIF4 field.
	DMA2_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA2_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA2_ISR_TEIF4 = 0x8000
	// Position of GIF5 field.
	DMA2_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA2_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA2_ISR_GIF5 = 0x10000
	// Position of TCIF5 field.
	DMA2_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA2_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA2_ISR_TCIF5 = 0x20000
	// Position of HTIF5 field.
	DMA2_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA2_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA2_ISR_HTIF5 = 0x40000
	// Position of TEIF5 field.
	DMA2_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA2_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA2_ISR_TEIF5 = 0x80000

	// IFCR: high interrupt status register
	// Position of CGIF1 field.
	DMA2_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA2_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA2_IFCR_CGIF1 = 0x1
	// Position of CTCIF1 field.
	DMA2_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA2_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA2_IFCR_CTCIF1 = 0x2
	// Position of CHTIF1 field.
	DMA2_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA2_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA2_IFCR_CHTIF1 = 0x4
	// Position of CTEIF1 field.
	DMA2_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA2_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA2_IFCR_CTEIF1 = 0x8
	// Position of CGIF2 field.
	DMA2_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA2_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA2_IFCR_CGIF2 = 0x10
	// Position of CTCIF2 field.
	DMA2_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA2_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA2_IFCR_CTCIF2 = 0x20
	// Position of CHTIF2 field.
	DMA2_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA2_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA2_IFCR_CHTIF2 = 0x40
	// Position of CTEIF2 field.
	DMA2_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA2_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA2_IFCR_CTEIF2 = 0x80
	// Position of CGIF3 field.
	DMA2_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA2_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA2_IFCR_CGIF3 = 0x100
	// Position of CTCIF3 field.
	DMA2_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA2_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA2_IFCR_CTCIF3 = 0x200
	// Position of CHTIF3 field.
	DMA2_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA2_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA2_IFCR_CHTIF3 = 0x400
	// Position of CTEIF3 field.
	DMA2_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA2_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA2_IFCR_CTEIF3 = 0x800
	// Position of CGIF4 field.
	DMA2_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA2_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA2_IFCR_CGIF4 = 0x1000
	// Position of CTCIF4 field.
	DMA2_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA2_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA2_IFCR_CTCIF4 = 0x2000
	// Position of CHTIF4 field.
	DMA2_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA2_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA2_IFCR_CHTIF4 = 0x4000
	// Position of CTEIF15 field.
	DMA2_IFCR_CTEIF15_Pos = 0xf
	// Bit mask of CTEIF15 field.
	DMA2_IFCR_CTEIF15_Msk = 0x8000
	// Bit CTEIF15.
	DMA2_IFCR_CTEIF15 = 0x8000
	// Position of CGIF5 field.
	DMA2_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA2_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA2_IFCR_CGIF5 = 0x10000
	// Position of CTCIF5 field.
	DMA2_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA2_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA2_IFCR_CTCIF5 = 0x20000
	// Position of CHTIF5 field.
	DMA2_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA2_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA2_IFCR_CHTIF5 = 0x40000
	// Position of CTEIF5 field.
	DMA2_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA2_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA2_IFCR_CTEIF5 = 0x80000

	// CH.CR: DMA channel 1 configuration register
	// Position of EN field.
	DMA2_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA2_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA2_CH_CR_EN = 0x1
	// Position of TCIE field.
	DMA2_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA2_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA2_CH_CR_TCIE = 0x2
	// Position of HTIE field.
	DMA2_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA2_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA2_CH_CR_HTIE = 0x4
	// Position of TEIE field.
	DMA2_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA2_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA2_CH_CR_TEIE = 0x8
	// Position of DIR field.
	DMA2_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA2_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA2_CH_CR_DIR = 0x10
	// Position of CIRC field.
	DMA2_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA2_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA2_CH_CR_CIRC = 0x20
	// Position of PINC field.
	DMA2_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA2_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA2_CH_CR_PINC = 0x40
	// Position of MINC field.
	DMA2_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA2_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA2_CH_CR_MINC = 0x80
	// Position of PSIZE field.
	DMA2_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA2_CH_CR_PSIZE_Msk = 0x300
	// Position of MSIZE field.
	DMA2_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA2_CH_CR_MSIZE_Msk = 0xc00
	// Position of PL field.
	DMA2_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA2_CH_CR_PL_Msk = 0x3000
	// Position of MEM2MEM field.
	DMA2_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA2_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA2_CH_CR_MEM2MEM = 0x4000

	// CH.NDTR: DMA channel 1 number of data tegister
	// Position of NDT field.
	DMA2_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA2_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel 1 peripheral address
	// Position of PA field.
	DMA2_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA2_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel 1 memory address
	// Position of MA field.
	DMA2_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2_CH_MAR_MA_Msk = 0xffffffff
)
