/* bookmarks-view.c generated by valac 0.56.3, the Vala compiler
 * generated from bookmarks-view.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;
typedef struct _BaseViewPrivate BaseViewPrivate;

#define TYPE_BROWSER_VIEW (browser_view_get_type ())
#define BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_VIEW, BrowserView))
#define BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_VIEW, BrowserViewClass))
#define IS_BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_VIEW))
#define IS_BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_VIEW))
#define BROWSER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_VIEW, BrowserViewClass))

typedef struct _BrowserView BrowserView;
typedef struct _BrowserViewClass BrowserViewClass;
typedef struct _BrowserViewPrivate BrowserViewPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BROWSER_INFO_BAR (browser_info_bar_get_type ())
#define BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBar))
#define BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))
#define IS_BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_INFO_BAR))
#define IS_BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_INFO_BAR))
#define BROWSER_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))

typedef struct _BrowserInfoBar BrowserInfoBar;
typedef struct _BrowserInfoBarClass BrowserInfoBarClass;

#define TYPE_SORTING_OPTIONS (sorting_options_get_type ())
#define SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTING_OPTIONS, SortingOptions))
#define SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTING_OPTIONS, SortingOptionsClass))
#define IS_SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTING_OPTIONS))
#define IS_SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTING_OPTIONS))
#define SORTING_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTING_OPTIONS, SortingOptionsClass))

typedef struct _SortingOptions SortingOptions;
typedef struct _SortingOptionsClass SortingOptionsClass;

#define TYPE_BOOKMARKS_VIEW (bookmarks_view_get_type ())
#define BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_VIEW, BookmarksView))
#define BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))
#define IS_BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_VIEW))
#define IS_BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_VIEW))
#define BOOKMARKS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))

typedef struct _BookmarksView BookmarksView;
typedef struct _BookmarksViewClass BookmarksViewClass;
typedef struct _BookmarksViewPrivate BookmarksViewPrivate;

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;

#define TYPE_BOOKMARKS_LIST (bookmarks_list_get_type ())
#define BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_LIST, BookmarksList))
#define BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_LIST, BookmarksListClass))
#define IS_BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_LIST))
#define IS_BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_LIST))
#define BOOKMARKS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_LIST, BookmarksListClass))

typedef struct _BookmarksList BookmarksList;
typedef struct _BookmarksListClass BookmarksListClass;
enum  {
	BOOKMARKS_VIEW_0_PROPERTY,
	BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_PROPERTY,
	BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_EDIT_MODE_PROPERTY,
	BOOKMARKS_VIEW_NUM_PROPERTIES
};
static GParamSpec* bookmarks_view_properties[BOOKMARKS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	BOOKMARK_ICON_VALID_FOLDER,
	BOOKMARK_ICON_SEARCH,
	BOOKMARK_ICON_DCONF_OBJECT,
	BOOKMARK_ICON_KEY_DEFAULTS,
	BOOKMARK_ICON_EDITED_VALUE,
	BOOKMARK_ICON_EMPTY_FOLDER,
	BOOKMARK_ICON_EMPTY_OBJECT
} BookmarkIcon;

#define TYPE_BOOKMARK_ICON (bookmark_icon_get_type ())
typedef enum  {
	OVERLAYED_LIST_SELECTION_STATE_EMPTY,
	OVERLAYED_LIST_SELECTION_STATE_UNIQUE,
	OVERLAYED_LIST_SELECTION_STATE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_MIDDLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_ALL
} OverlayedListSelectionState;

#define OVERLAYED_LIST_TYPE_SELECTION_STATE (overlayed_list_selection_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BOOKMARKS_VIEW_BOOKMARKS_SELECTION_CHANGED_SIGNAL,
	BOOKMARKS_VIEW_UPDATE_BOOKMARKS_ICONS_SIGNAL,
	BOOKMARKS_VIEW_NUM_SIGNALS
};
static guint bookmarks_view_signals[BOOKMARKS_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseView {
	GtkStack parent_instance;
	BaseViewPrivate * priv;
	GtkGrid* main_grid;
};

struct _BaseViewClass {
	GtkStackClass parent_class;
	gboolean (*handle_copy_text) (BaseView* self, gchar** copy_text);
	void (*close_popovers) (BaseView* self);
	void (*set_window_size) (BaseView* self, AdaptativeWidgetWindowSize new_size);
	void (*show_default_view) (BaseView* self);
	gboolean (*is_in_in_window_mode) (BaseView* self);
};

struct _BrowserView {
	BaseView parent_instance;
	BrowserViewPrivate * priv;
	BrowserInfoBar* info_bar;
	SortingOptions* sorting_options;
};

struct _BrowserViewClass {
	BaseViewClass parent_class;
	void (*set_path) (BrowserView* self, ViewType type, const gchar* path);
	gboolean (*next_match) (BrowserView* self);
	gboolean (*previous_match) (BrowserView* self);
	gboolean (*toggle_row_popover) (BrowserView* self);
};

struct _BookmarksView {
	BrowserView parent_instance;
	BookmarksViewPrivate * priv;
};

struct _BookmarksViewClass {
	BrowserViewClass parent_class;
};

struct _BookmarksViewPrivate {
	gboolean _in_window_bookmarks;
	gboolean _in_window_bookmarks_edit_mode;
	BookmarksList* bookmarks_list;
	gchar** old_bookmarks;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
};

static gint BookmarksView_private_offset;
static gpointer bookmarks_view_parent_class = NULL;
static AdaptativeWidgetIface * bookmarks_view_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType browser_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserView, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType browser_info_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserInfoBar, g_object_unref)
VALA_EXTERN GType sorting_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortingOptions, g_object_unref)
VALA_EXTERN GType bookmarks_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksView, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType bookmarks_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksList, g_object_unref)
VALA_EXTERN void base_view_set_window_size (BaseView* self,
                                AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
VALA_EXTERN void base_view_show_default_view (BaseView* self);
VALA_EXTERN gboolean browser_view_next_match (BrowserView* self);
VALA_EXTERN gboolean browser_view_previous_match (BrowserView* self);
VALA_EXTERN gboolean base_view_handle_copy_text (BaseView* self,
                                     gchar** copy_text);
VALA_EXTERN gboolean browser_view_toggle_row_popover (BrowserView* self);
static void bookmarks_view_real_set_window_size (AdaptativeWidget* base,
                                          AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static gboolean bookmarks_view_real_is_in_in_window_mode (BaseView* base);
VALA_EXTERN gboolean bookmarks_view_get_in_window_bookmarks (BookmarksView* self);
static void bookmarks_view_real_show_default_view (BaseView* base);
VALA_EXTERN gboolean bookmarks_view_get_in_window_bookmarks_edit_mode (BookmarksView* self);
VALA_EXTERN gboolean bookmarks_view_leave_bookmarks_edit_mode (BookmarksView* self);
static void bookmarks_view_set_in_window_bookmarks (BookmarksView* self,
                                             gboolean value);
static void bookmarks_view_create_bookmarks_list (BookmarksView* self);
VALA_EXTERN BookmarksList* bookmarks_list_new (gboolean needs_shadows,
                                   gboolean big_placeholder,
                                   const gchar* edit_mode_action_prefix,
                                   const gchar* schema_path);
VALA_EXTERN BookmarksList* bookmarks_list_construct (GType object_type,
                                         gboolean needs_shadows,
                                         gboolean big_placeholder,
                                         const gchar* edit_mode_action_prefix,
                                         const gchar* schema_path);
static void bookmarks_view_on_bookmarks_selection_changed (BookmarksView* self);
static void _bookmarks_view_on_bookmarks_selection_changed_overlayed_list_selection_changed (OverlayedList* _sender,
                                                                                      gpointer self);
static void bookmarks_view_on_update_bookmarks_icons (BookmarksView* self,
                                               GVariant* bookmarks_variant);
static void _bookmarks_view_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons (BookmarksList* _sender,
                                                                                      GVariant* bookmarks_variant,
                                                                                      gpointer self);
VALA_EXTERN void bookmarks_view_show_bookmarks_view (BookmarksView* self,
                                         gchar** bookmarks,
                                         gint bookmarks_length1);
VALA_EXTERN void overlayed_list_reset (OverlayedList* self);
VALA_EXTERN gboolean bookmarks_list_create_bookmark_rows (BookmarksList* self,
                                              GVariant* bookmarks_variant);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
VALA_EXTERN GType bookmark_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bookmarks_view_update_bookmark_icon (BookmarksView* self,
                                          const gchar* bookmark,
                                          BookmarkIcon icon);
VALA_EXTERN void bookmarks_list_update_bookmark_icon (BookmarksList* self,
                                          const gchar* bookmark,
                                          BookmarkIcon icon);
VALA_EXTERN void bookmarks_view_enter_bookmarks_edit_mode (BookmarksView* self);
VALA_EXTERN void bookmarks_list_enter_edit_mode (BookmarksList* self);
static void bookmarks_view_set_in_window_bookmarks_edit_mode (BookmarksView* self,
                                                       gboolean value);
VALA_EXTERN gboolean bookmarks_list_leave_edit_mode (BookmarksList* self);
VALA_EXTERN GType overlayed_list_selection_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN OverlayedListSelectionState bookmarks_view_get_bookmarks_selection_state (BookmarksView* self);
VALA_EXTERN OverlayedListSelectionState overlayed_list_get_selection_state (OverlayedList* self);
VALA_EXTERN void bookmarks_view_trash_bookmark (BookmarksView* self);
VALA_EXTERN void bookmarks_list_trash_bookmark (BookmarksList* self);
VALA_EXTERN void bookmarks_view_move_top (BookmarksView* self);
VALA_EXTERN void bookmarks_list_move_top (BookmarksList* self);
VALA_EXTERN void bookmarks_view_move_up (BookmarksView* self);
VALA_EXTERN void bookmarks_list_move_up (BookmarksList* self);
VALA_EXTERN void bookmarks_view_move_down (BookmarksView* self);
VALA_EXTERN void bookmarks_list_move_down (BookmarksList* self);
VALA_EXTERN void bookmarks_view_move_bottom (BookmarksView* self);
VALA_EXTERN void bookmarks_list_move_bottom (BookmarksList* self);
static gboolean bookmarks_view_real_next_match (BrowserView* base);
VALA_EXTERN gboolean overlayed_list_next_match (OverlayedList* self);
static gboolean bookmarks_view_real_previous_match (BrowserView* base);
VALA_EXTERN gboolean overlayed_list_previous_match (OverlayedList* self);
static gboolean bookmarks_view_real_handle_copy_text (BaseView* base,
                                               gchar** copy_text);
VALA_EXTERN gboolean overlayed_list_handle_copy_text (OverlayedList* self,
                                          gchar** copy_text);
static gboolean bookmarks_view_real_toggle_row_popover (BrowserView* base);
VALA_EXTERN BookmarksView* bookmarks_view_new (void);
VALA_EXTERN BookmarksView* bookmarks_view_construct (GType object_type);
VALA_EXTERN BrowserView* browser_view_new (void);
VALA_EXTERN BrowserView* browser_view_construct (GType object_type);
static GObject * bookmarks_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void bookmarks_view_finalize (GObject * obj);
static GType bookmarks_view_get_type_once (void);
static void _vala_bookmarks_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_bookmarks_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
bookmarks_view_get_instance_private (BookmarksView* self)
{
	return G_STRUCT_MEMBER_P (self, BookmarksView_private_offset);
}

static void
bookmarks_view_real_set_window_size (AdaptativeWidget* base,
                                     AdaptativeWidgetWindowSize new_size)
{
	BookmarksView * self;
	BookmarksList* _tmp0_;
	self = (BookmarksView*) base;
	BASE_VIEW_CLASS (bookmarks_view_parent_class)->set_window_size ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView), new_size);
	_tmp0_ = self->priv->bookmarks_list;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
}

static gboolean
bookmarks_view_real_is_in_in_window_mode (BaseView* base)
{
	BookmarksView * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	self = (BookmarksView*) base;
	_tmp1_ = self->priv->_in_window_bookmarks;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = BASE_VIEW_CLASS (bookmarks_view_parent_class)->is_in_in_window_mode ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView));
	}
	result = _tmp0_;
	return result;
}

static void
bookmarks_view_real_show_default_view (BaseView* base)
{
	BookmarksView * self;
	gboolean _tmp0_;
	self = (BookmarksView*) base;
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_in_window_bookmarks_edit_mode;
		if (_tmp1_) {
			bookmarks_view_leave_bookmarks_edit_mode (self);
		}
		bookmarks_view_set_in_window_bookmarks (self, FALSE);
		gtk_stack_set_visible_child_name ((GtkStack*) self, "main-view");
	} else {
		BASE_VIEW_CLASS (bookmarks_view_parent_class)->show_default_view ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView));
	}
}

static void
_bookmarks_view_on_bookmarks_selection_changed_overlayed_list_selection_changed (OverlayedList* _sender,
                                                                                 gpointer self)
{
	bookmarks_view_on_bookmarks_selection_changed ((BookmarksView*) self);
}

static void
_bookmarks_view_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons (BookmarksList* _sender,
                                                                                 GVariant* bookmarks_variant,
                                                                                 gpointer self)
{
	bookmarks_view_on_update_bookmarks_icons ((BookmarksView*) self, bookmarks_variant);
}

static void
bookmarks_view_create_bookmarks_list (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	BookmarksList* _tmp1_;
	BookmarksList* _tmp2_;
	BookmarksList* _tmp3_;
	BookmarksList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bookmarks_list_new (FALSE, TRUE, "bmk", "/ca/desrt/dconf-editor/");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bookmarks_list);
	self->priv->bookmarks_list = _tmp0_;
	_tmp1_ = self->priv->bookmarks_list;
	g_signal_connect_object ((OverlayedList*) _tmp1_, "selection-changed", (GCallback) _bookmarks_view_on_bookmarks_selection_changed_overlayed_list_selection_changed, self, 0);
	_tmp2_ = self->priv->bookmarks_list;
	g_signal_connect_object (_tmp2_, "update-bookmarks-icons", (GCallback) _bookmarks_view_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons, self, 0);
	_tmp3_ = self->priv->bookmarks_list;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->bookmarks_list;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
bookmarks_view_show_bookmarks_view (BookmarksView* self,
                                    gchar** bookmarks,
                                    gint bookmarks_length1)
{
	BookmarksList* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	BookmarksList* _tmp6_;
	g_return_if_fail (self != NULL);
	if (base_view_is_in_in_window_mode ((BaseView*) self)) {
		base_view_show_default_view ((BaseView*) self);
	}
	_tmp0_ = self->priv->bookmarks_list;
	overlayed_list_reset ((OverlayedList*) _tmp0_);
	_tmp1_ = self->priv->old_bookmarks;
	_tmp1__length1 = self->priv->old_bookmarks_length1;
	if (bookmarks != _tmp1_) {
		GVariant* variant = NULL;
		GVariant* _tmp2_;
		BookmarksList* _tmp3_;
		GVariant* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp2_ = g_variant_new_strv (bookmarks, bookmarks_length1);
		g_variant_ref_sink (_tmp2_);
		variant = _tmp2_;
		_tmp3_ = self->priv->bookmarks_list;
		_tmp4_ = variant;
		bookmarks_list_create_bookmark_rows (_tmp3_, _tmp4_);
		_tmp5_ = (bookmarks != NULL) ? _vala_array_dup5 (bookmarks, bookmarks_length1) : bookmarks;
		_tmp5__length1 = bookmarks_length1;
		self->priv->old_bookmarks = (_vala_array_free (self->priv->old_bookmarks, self->priv->old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
		self->priv->old_bookmarks = _tmp5_;
		self->priv->old_bookmarks_length1 = _tmp5__length1;
		self->priv->_old_bookmarks_size_ = self->priv->old_bookmarks_length1;
		_g_variant_unref0 (variant);
	}
	_tmp6_ = self->priv->bookmarks_list;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp6_);
	bookmarks_view_set_in_window_bookmarks (self, TRUE);
}

void
bookmarks_view_update_bookmark_icon (BookmarksView* self,
                                     const gchar* bookmark,
                                     BookmarkIcon icon)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_update_bookmark_icon (_tmp0_, bookmark, icon);
}

void
bookmarks_view_enter_bookmarks_edit_mode (BookmarksView* self)
{
	gboolean _tmp0_;
	BookmarksList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_in_window_bookmarks;
	_vala_return_if_fail (_tmp0_ == TRUE, "in_window_bookmarks == true");
	_tmp1_ = self->priv->bookmarks_list;
	bookmarks_list_enter_edit_mode (_tmp1_);
	bookmarks_view_set_in_window_bookmarks_edit_mode (self, TRUE);
}

gboolean
bookmarks_view_leave_bookmarks_edit_mode (BookmarksView* self)
{
	gboolean _tmp0_;
	BookmarksList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_in_window_bookmarks;
	_vala_return_val_if_fail (_tmp0_ == TRUE, "in_window_bookmarks == true", FALSE);
	bookmarks_view_set_in_window_bookmarks_edit_mode (self, FALSE);
	_tmp1_ = self->priv->bookmarks_list;
	result = bookmarks_list_leave_edit_mode (_tmp1_);
	return result;
}

OverlayedListSelectionState
bookmarks_view_get_bookmarks_selection_state (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	OverlayedListSelectionState result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->bookmarks_list;
	result = overlayed_list_get_selection_state ((OverlayedList*) _tmp0_);
	return result;
}

void
bookmarks_view_trash_bookmark (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_trash_bookmark (_tmp0_);
}

void
bookmarks_view_move_top (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_top (_tmp0_);
}

void
bookmarks_view_move_up (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_up (_tmp0_);
}

void
bookmarks_view_move_down (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_down (_tmp0_);
}

void
bookmarks_view_move_bottom (BookmarksView* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_bottom (_tmp0_);
}

static void
bookmarks_view_on_bookmarks_selection_changed (BookmarksView* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (!_tmp0_) {
		return;
	}
	g_signal_emit (self, bookmarks_view_signals[BOOKMARKS_VIEW_BOOKMARKS_SELECTION_CHANGED_SIGNAL], 0);
}

static void
bookmarks_view_on_update_bookmarks_icons (BookmarksView* self,
                                          GVariant* bookmarks_variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmarks_variant != NULL);
	g_signal_emit (self, bookmarks_view_signals[BOOKMARKS_VIEW_UPDATE_BOOKMARKS_ICONS_SIGNAL], 0, bookmarks_variant);
}

static gboolean
bookmarks_view_real_next_match (BrowserView* base)
{
	BookmarksView * self;
	gboolean _tmp0_;
	gboolean result;
	self = (BookmarksView*) base;
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (_tmp0_) {
		BookmarksList* _tmp1_;
		_tmp1_ = self->priv->bookmarks_list;
		result = overlayed_list_next_match ((OverlayedList*) _tmp1_);
		return result;
	}
	result = BROWSER_VIEW_CLASS (bookmarks_view_parent_class)->next_match (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView));
	return result;
}

static gboolean
bookmarks_view_real_previous_match (BrowserView* base)
{
	BookmarksView * self;
	gboolean _tmp0_;
	gboolean result;
	self = (BookmarksView*) base;
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (_tmp0_) {
		BookmarksList* _tmp1_;
		_tmp1_ = self->priv->bookmarks_list;
		result = overlayed_list_previous_match ((OverlayedList*) _tmp1_);
		return result;
	}
	result = BROWSER_VIEW_CLASS (bookmarks_view_parent_class)->previous_match (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView));
	return result;
}

static gboolean
bookmarks_view_real_handle_copy_text (BaseView* base,
                                      gchar** copy_text)
{
	BookmarksView * self;
	gchar* _vala_copy_text = NULL;
	gboolean _tmp0_;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	gboolean result;
	self = (BookmarksView*) base;
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (_tmp0_) {
		BookmarksList* _tmp1_;
		gchar* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp1_ = self->priv->bookmarks_list;
		_tmp3_ = overlayed_list_handle_copy_text ((OverlayedList*) _tmp1_, &_tmp2_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp2_;
		result = _tmp3_;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp5_ = BASE_VIEW_CLASS (bookmarks_view_parent_class)->handle_copy_text ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView), &_tmp4_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp4_;
	result = _tmp5_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static gboolean
bookmarks_view_real_toggle_row_popover (BrowserView* base)
{
	BookmarksView * self;
	gboolean _tmp0_;
	gboolean result;
	self = (BookmarksView*) base;
	_tmp0_ = self->priv->_in_window_bookmarks;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = BROWSER_VIEW_CLASS (bookmarks_view_parent_class)->toggle_row_popover (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_VIEW, BrowserView));
	return result;
}

BookmarksView*
bookmarks_view_construct (GType object_type)
{
	BookmarksView * self = NULL;
	self = (BookmarksView*) browser_view_construct (object_type);
	return self;
}

BookmarksView*
bookmarks_view_new (void)
{
	return bookmarks_view_construct (TYPE_BOOKMARKS_VIEW);
}

gboolean
bookmarks_view_get_in_window_bookmarks (BookmarksView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_window_bookmarks;
	return result;
}

static void
bookmarks_view_set_in_window_bookmarks (BookmarksView* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_in_window_bookmarks = value;
}

gboolean
bookmarks_view_get_in_window_bookmarks_edit_mode (BookmarksView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_window_bookmarks_edit_mode;
	return result;
}

static void
bookmarks_view_set_in_window_bookmarks_edit_mode (BookmarksView* self,
                                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_in_window_bookmarks_edit_mode = value;
}

static GObject *
bookmarks_view_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BookmarksView * self;
	parent_class = G_OBJECT_CLASS (bookmarks_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_VIEW, BookmarksView);
	bookmarks_view_create_bookmarks_list (self);
	return obj;
}

static void
bookmarks_view_class_init (BookmarksViewClass * klass,
                           gpointer klass_data)
{
	bookmarks_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookmarksView_private_offset);
	((BaseViewClass *) klass)->set_window_size = (void (*) (BaseView*, AdaptativeWidgetWindowSize)) bookmarks_view_real_set_window_size;
	((BaseViewClass *) klass)->is_in_in_window_mode = (gboolean (*) (BaseView*)) bookmarks_view_real_is_in_in_window_mode;
	((BaseViewClass *) klass)->show_default_view = (void (*) (BaseView*)) bookmarks_view_real_show_default_view;
	((BrowserViewClass *) klass)->next_match = (gboolean (*) (BrowserView*)) bookmarks_view_real_next_match;
	((BrowserViewClass *) klass)->previous_match = (gboolean (*) (BrowserView*)) bookmarks_view_real_previous_match;
	((BaseViewClass *) klass)->handle_copy_text = (gboolean (*) (BaseView*, gchar**)) bookmarks_view_real_handle_copy_text;
	((BrowserViewClass *) klass)->toggle_row_popover = (gboolean (*) (BrowserView*)) bookmarks_view_real_toggle_row_popover;
	G_OBJECT_CLASS (klass)->get_property = _vala_bookmarks_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmarks_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = bookmarks_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmarks_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_PROPERTY, bookmarks_view_properties[BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_PROPERTY] = g_param_spec_boolean ("in-window-bookmarks", "in-window-bookmarks", "in-window-bookmarks", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_EDIT_MODE_PROPERTY, bookmarks_view_properties[BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_EDIT_MODE_PROPERTY] = g_param_spec_boolean ("in-window-bookmarks-edit-mode", "in-window-bookmarks-edit-mode", "in-window-bookmarks-edit-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	bookmarks_view_signals[BOOKMARKS_VIEW_BOOKMARKS_SELECTION_CHANGED_SIGNAL] = g_signal_new ("bookmarks-selection-changed", TYPE_BOOKMARKS_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	bookmarks_view_signals[BOOKMARKS_VIEW_UPDATE_BOOKMARKS_ICONS_SIGNAL] = g_signal_new ("update-bookmarks-icons", TYPE_BOOKMARKS_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
}

static void
bookmarks_view_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                 gpointer iface_data)
{
	bookmarks_view_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) bookmarks_view_real_set_window_size;
}

static void
bookmarks_view_instance_init (BookmarksView * self,
                              gpointer klass)
{
	gchar** _tmp0_;
	self->priv = bookmarks_view_get_instance_private (self);
	self->priv->_in_window_bookmarks = FALSE;
	self->priv->_in_window_bookmarks_edit_mode = FALSE;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->old_bookmarks = _tmp0_;
	self->priv->old_bookmarks_length1 = 0;
	self->priv->_old_bookmarks_size_ = self->priv->old_bookmarks_length1;
}

static void
bookmarks_view_finalize (GObject * obj)
{
	BookmarksView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_VIEW, BookmarksView);
	_g_object_unref0 (self->priv->bookmarks_list);
	self->priv->old_bookmarks = (_vala_array_free (self->priv->old_bookmarks, self->priv->old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (bookmarks_view_parent_class)->finalize (obj);
}

static GType
bookmarks_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarksViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookmarksView), 0, (GInstanceInitFunc) bookmarks_view_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) bookmarks_view_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType bookmarks_view_type_id;
	bookmarks_view_type_id = g_type_register_static (TYPE_BROWSER_VIEW, "BookmarksView", &g_define_type_info, 0);
	g_type_add_interface_static (bookmarks_view_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BookmarksView_private_offset = g_type_add_instance_private (bookmarks_view_type_id, sizeof (BookmarksViewPrivate));
	return bookmarks_view_type_id;
}

GType
bookmarks_view_get_type (void)
{
	static volatile gsize bookmarks_view_type_id__once = 0;
	if (g_once_init_enter (&bookmarks_view_type_id__once)) {
		GType bookmarks_view_type_id;
		bookmarks_view_type_id = bookmarks_view_get_type_once ();
		g_once_init_leave (&bookmarks_view_type_id__once, bookmarks_view_type_id);
	}
	return bookmarks_view_type_id__once;
}

static void
_vala_bookmarks_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BookmarksView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS_VIEW, BookmarksView);
	switch (property_id) {
		case BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_PROPERTY:
		g_value_set_boolean (value, bookmarks_view_get_in_window_bookmarks (self));
		break;
		case BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_EDIT_MODE_PROPERTY:
		g_value_set_boolean (value, bookmarks_view_get_in_window_bookmarks_edit_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bookmarks_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BookmarksView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS_VIEW, BookmarksView);
	switch (property_id) {
		case BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_PROPERTY:
		bookmarks_view_set_in_window_bookmarks (self, g_value_get_boolean (value));
		break;
		case BOOKMARKS_VIEW_IN_WINDOW_BOOKMARKS_EDIT_MODE_PROPERTY:
		bookmarks_view_set_in_window_bookmarks_edit_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

