/* registry-search.c generated by valac 0.56.3, the Vala compiler
 * generated from registry-search.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#define MODEL_UTILS_folder_context_id ((guint16) 1)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BROWSABLE_VIEW (browsable_view_get_type ())
#define BROWSABLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSABLE_VIEW, BrowsableView))
#define IS_BROWSABLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSABLE_VIEW))
#define BROWSABLE_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BROWSABLE_VIEW, BrowsableViewIface))

typedef struct _BrowsableView BrowsableView;
typedef struct _BrowsableViewIface BrowsableViewIface;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_REGISTRY_LIST (registry_list_get_type ())
#define REGISTRY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_LIST, RegistryList))
#define REGISTRY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_LIST, RegistryListClass))
#define IS_REGISTRY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_LIST))
#define IS_REGISTRY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_LIST))
#define REGISTRY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_LIST, RegistryListClass))

typedef struct _RegistryList RegistryList;
typedef struct _RegistryListClass RegistryListClass;
typedef struct _RegistryListPrivate RegistryListPrivate;

#define TYPE_REGISTRY_SEARCH (registry_search_get_type ())
#define REGISTRY_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_SEARCH, RegistrySearch))
#define REGISTRY_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_SEARCH, RegistrySearchClass))
#define IS_REGISTRY_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_SEARCH))
#define IS_REGISTRY_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_SEARCH))
#define REGISTRY_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_SEARCH, RegistrySearchClass))

typedef struct _RegistrySearch RegistrySearch;
typedef struct _RegistrySearchClass RegistrySearchClass;
typedef struct _RegistrySearchPrivate RegistrySearchPrivate;

#define TYPE_SORTING_OPTIONS (sorting_options_get_type ())
#define SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTING_OPTIONS, SortingOptions))
#define SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTING_OPTIONS, SortingOptionsClass))
#define IS_SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTING_OPTIONS))
#define IS_SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTING_OPTIONS))
#define SORTING_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTING_OPTIONS, SortingOptionsClass))

typedef struct _SortingOptions SortingOptions;
typedef struct _SortingOptionsClass SortingOptionsClass;
enum  {
	REGISTRY_SEARCH_0_PROPERTY,
	REGISTRY_SEARCH_PLACEHOLDER_LABEL_PROPERTY,
	REGISTRY_SEARCH_NUM_PROPERTIES
};
static GParamSpec* registry_search_properties[REGISTRY_SEARCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CLICKABLE_LIST_BOX_ROW (clickable_list_box_row_get_type ())
#define CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow))
#define CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))
#define IS_CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLICKABLE_LIST_BOX_ROW))
#define IS_CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLICKABLE_LIST_BOX_ROW))
#define CLICKABLE_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))

typedef struct _ClickableListBoxRow ClickableListBoxRow;
typedef struct _ClickableListBoxRowClass ClickableListBoxRowClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;

#define TYPE_MODIFICATIONS_HANDLER (modifications_handler_get_type ())
#define MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandler))
#define MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))
#define IS_MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_HANDLER))
#define IS_MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_HANDLER))
#define MODIFICATIONS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))

typedef struct _ModificationsHandler ModificationsHandler;
typedef struct _ModificationsHandlerClass ModificationsHandlerClass;

#define TYPE_SIMPLE_SETTING_OBJECT (simple_setting_object_get_type ())
#define SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject))
#define SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))
#define IS_SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SETTING_OBJECT))
#define IS_SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SETTING_OBJECT))
#define SIMPLE_SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))

typedef struct _SimpleSettingObject SimpleSettingObject;
typedef struct _SimpleSettingObjectClass SimpleSettingObjectClass;

#define TYPE_SETTING_COMPARATOR (setting_comparator_get_type ())
#define SETTING_COMPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_COMPARATOR, SettingComparator))
#define SETTING_COMPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_COMPARATOR, SettingComparatorClass))
#define IS_SETTING_COMPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_COMPARATOR))
#define IS_SETTING_COMPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_COMPARATOR))
#define SETTING_COMPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_COMPARATOR, SettingComparatorClass))

typedef struct _SettingComparator SettingComparator;
typedef struct _SettingComparatorClass SettingComparatorClass;
typedef struct _Block41Data Block41Data;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _Block42Data Block42Data;

#define TYPE_LIST_BOX_ROW_HEADER (list_box_row_header_get_type ())
#define LIST_BOX_ROW_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_BOX_ROW_HEADER, ListBoxRowHeader))
#define LIST_BOX_ROW_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_BOX_ROW_HEADER, ListBoxRowHeaderClass))
#define IS_LIST_BOX_ROW_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_BOX_ROW_HEADER))
#define IS_LIST_BOX_ROW_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_BOX_ROW_HEADER))
#define LIST_BOX_ROW_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_BOX_ROW_HEADER, ListBoxRowHeaderClass))

typedef struct _ListBoxRowHeader ListBoxRowHeader;
typedef struct _ListBoxRowHeaderClass ListBoxRowHeaderClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BrowsableViewIface {
	GTypeInterface parent_iface;
	gboolean (*handle_copy_text) (BrowsableView* self, gchar** copy_text);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _RegistryList {
	GtkGrid parent_instance;
	RegistryListPrivate * priv;
	GtkListBox* key_list_box;
	gchar* current_path_if_search_mode;
	gboolean search_is_path_search;
	GListStore* list_model;
};

struct _RegistryListClass {
	GtkGridClass parent_class;
	void (*select_first_row) (RegistryList* self);
	const gchar* (*get_placeholder_label) (RegistryList* self);
};

struct _RegistrySearch {
	RegistryList parent_instance;
	RegistrySearchPrivate * priv;
};

struct _RegistrySearchClass {
	RegistryListClass parent_class;
};

struct _RegistrySearchPrivate {
	gchar** bookmarks;
	gint bookmarks_length1;
	gint _bookmarks_size_;
	SortingOptions* sorting_options;
	gboolean is_local;
	guint16 fallback_context_id;
	gchar* old_term;
	gint post_local;
	gint post_bookmarks;
	gint post_folders;
	guint* search_source;
	GQueue* search_nodes;
};

struct _Block41Data {
	int _ref_count_;
	SettingComparator* comparator;
};

struct _Block42Data {
	int _ref_count_;
	RegistrySearch* self;
	gchar* current_path;
	gchar* term;
};

static gint RegistrySearch_private_offset;
static gpointer registry_search_parent_class = NULL;

VALA_EXTERN GType browsable_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType registry_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryList, g_object_unref)
VALA_EXTERN GType registry_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistrySearch, g_object_unref)
VALA_EXTERN GType sorting_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortingOptions, g_object_unref)
VALA_EXTERN void registry_list_select_first_row (RegistryList* self);
VALA_EXTERN const gchar* registry_list_get_placeholder_label (RegistryList* self);
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
static void registry_search_real_select_first_row (RegistryList* base);
static void _registry_search_select_first_row (GtkListBox* key_list_box,
                                        const gchar* _term);
VALA_EXTERN gboolean registry_search_return_pressed (RegistrySearch* self);
static gboolean _registry_search_return_pressed (GtkListBox* key_list_box);
VALA_EXTERN gboolean registry_search_handle_alt_copy_text (RegistrySearch* self,
                                               gchar** copy_text);
static gboolean _registry_search_handle_alt_copy_text (gchar** copy_text,
                                                GtkListBox* key_list_box);
VALA_EXTERN void registry_search_clean (RegistrySearch* self);
static void registry_search_stop_global_search (RegistrySearch* self);
VALA_EXTERN void registry_search_set_search_parameters (RegistrySearch* self,
                                            gboolean local_search,
                                            const gchar* current_path,
                                            guint16 current_context_id,
                                            gchar** _bookmarks,
                                            gint _bookmarks_length1,
                                            SortingOptions* _sorting_options);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static void registry_search_ensure_selection (GtkListBox* key_list_box,
                                       const gchar* full_name);
static GtkListBoxRow* _registry_search_get_first_row (GtkListBox** key_list_box);
VALA_EXTERN GType clickable_list_box_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClickableListBoxRow, g_object_unref)
VALA_EXTERN const gchar* clickable_list_box_row_get_full_name (ClickableListBoxRow* self);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
static void _registry_search_get_action_target (GtkListBoxRow* selected_row,
                                         gchar** action_target);
VALA_EXTERN void registry_search_start_search (RegistrySearch* self,
                                   const gchar* _term);
VALA_EXTERN gboolean browser_window_is_path_invalid (const gchar* path);
VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
VALA_EXTERN GType modifications_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsHandler, g_object_unref)
VALA_EXTERN ModificationsHandler* registry_list_get_modifications_handler (RegistryList* self);
VALA_EXTERN SettingsModel* modifications_handler_get_model (ModificationsHandler* self);
static void registry_search_refine_paths_results (const gchar* term,
                                           GListStore** list_model,
                                           gint* post_local);
VALA_EXTERN void settings_model_clean_watched_keys (SettingsModel* self);
VALA_EXTERN gchar* model_utils_get_base_path (const gchar* path);
static void registry_search_insert_first_row (const gchar* current_path,
                                       guint16 _fallback_context_id,
                                       GListStore** list_model);
static void registry_search_local_search (SettingsModel* model,
                                   SortingOptions* sorting_options,
                                   const gchar* current_path,
                                   const gchar* term,
                                   GListStore** list_model);
VALA_EXTERN gchar* model_utils_get_name_or_empty (const gchar* path);
VALA_EXTERN GtkWidget* registry_list_new_list_box_row (RegistryList* self,
                                           GObject* item);
static GtkWidget* _registry_list_new_list_box_row_gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self);
VALA_EXTERN void settings_model_keys_value_push (SettingsModel* self);
static void registry_search_pause_global_search (guint** search_source);
static void registry_search_refine_local_results (const gchar* term,
                                           GListStore** list_model,
                                           gint* post_local,
                                           gint* post_bookmarks,
                                           gint* post_folders);
static void registry_search_refine_bookmarks_results (const gchar* term,
                                               gint post_local,
                                               GListStore** list_model,
                                               gint* post_bookmarks,
                                               gint* post_folders);
static void registry_search_start_global_search (RegistrySearch* self,
                                          const gchar* current_path,
                                          const gchar* term);
static void registry_search_refine_global_results (const gchar* term,
                                            gint post_bookmarks,
                                            gboolean is_local,
                                            GListStore** list_model,
                                            gint* post_folders);
static void registry_search_resume_global_search (RegistrySearch* self,
                                           const gchar* current_path,
                                           const gchar* term);
static void registry_search_bookmark_search (SettingsModel* model,
                                      const gchar* current_path,
                                      const gchar* term,
                                      gchar** bookmarks,
                                      gint bookmarks_length1,
                                      gboolean is_local,
                                      GListStore** list_model,
                                      gint* post_bookmarks);
static void registry_search_insert_global_search_row (const gchar* current_path,
                                               guint16 _fallback_context_id,
                                               GListStore** list_model);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN gchar* model_utils_get_name (const gchar* path);
VALA_EXTERN GType simple_setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleSettingObject, g_object_unref)
VALA_EXTERN SimpleSettingObject* simple_setting_object_new_from_full_name (guint16 _context_id,
                                                               const gchar* _name,
                                                               const gchar* _full_name,
                                                               gboolean _is_search,
                                                               gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct_from_full_name (GType object_type,
                                                                     guint16 _context_id,
                                                                     const gchar* _name,
                                                                     const gchar* _full_name,
                                                                     gboolean _is_search,
                                                                     gboolean _is_pinned);
VALA_EXTERN const gchar* simple_setting_object_get_full_name (SimpleSettingObject* self);
VALA_EXTERN const gchar* simple_setting_object_get_casefolded_name (SimpleSettingObject* self);
VALA_EXTERN gboolean simple_setting_object_get_is_search (SimpleSettingObject* self);
VALA_EXTERN GType setting_comparator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingComparator, g_object_unref)
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
VALA_EXTERN GVariant* settings_model_get_children (SettingsModel* self,
                                       const gchar* folder_path,
                                       gboolean watch,
                                       gboolean clean_watched);
VALA_EXTERN SettingComparator* sorting_options_get_comparator (SortingOptions* self);
static gint __lambda85_ (Block41Data* _data41_,
                  gconstpointer a,
                  gconstpointer b);
VALA_EXTERN gint setting_comparator_compare (SettingComparator* self,
                                 SimpleSettingObject* a,
                                 SimpleSettingObject* b);
static gint ___lambda85__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN SimpleSettingObject* simple_setting_object_new_from_base_path (guint16 _context_id,
                                                               const gchar* _name,
                                                               const gchar* _base_path,
                                                               gboolean _is_search,
                                                               gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct_from_base_path (GType object_type,
                                                                     guint16 _context_id,
                                                                     const gchar* _name,
                                                                     const gchar* _base_path,
                                                                     gboolean _is_search,
                                                                     gboolean _is_pinned);
VALA_EXTERN gchar* model_utils_get_parent_path (const gchar* path);
VALA_EXTERN gboolean settings_model_get_object (SettingsModel* self,
                                    const gchar* path,
                                    guint16* context_id,
                                    gchar** name,
                                    gboolean watch);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static gboolean __lambda86_ (Block42Data* _data42_);
static void registry_search_global_search_step (RegistrySearch* self,
                                         const gchar* current_path,
                                         const gchar* term);
static gboolean ___lambda86__gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN gchar* model_utils_recreate_full_name (const gchar* base_path,
                                       const gchar* name,
                                       gboolean is_folder);
VALA_EXTERN void settings_model_key_value_push (SettingsModel* self,
                                    const gchar* key_path,
                                    guint16 key_context_id);
static void registry_search_update_row_header (RegistrySearch* self,
                                        GtkListBoxRow* row,
                                        GtkListBoxRow* before);
VALA_EXTERN gboolean registry_list_is_first_row (gint row_index,
                                     GtkListBoxRow* before);
VALA_EXTERN void registry_list_update_row_header_with_context (GtkListBoxRow* row,
                                                   GtkListBoxRow* before,
                                                   SettingsModel* model,
                                                   gboolean local_search_header);
static gchar* registry_search_get_header_text (gint row_index,
                                        gint post_local,
                                        gint post_bookmarks,
                                        gint post_folders);
VALA_EXTERN ListBoxRowHeader* list_box_row_header_new (gboolean is_first_row,
                                           const gchar* header_text);
VALA_EXTERN ListBoxRowHeader* list_box_row_header_construct (GType object_type,
                                                 gboolean is_first_row,
                                                 const gchar* header_text);
VALA_EXTERN GType list_box_row_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ListBoxRowHeader, g_object_unref)
VALA_EXTERN RegistrySearch* registry_search_new (void);
VALA_EXTERN RegistrySearch* registry_search_construct (GType object_type);
VALA_EXTERN RegistryList* registry_list_construct (GType object_type);
static GObject * registry_search_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN void registry_list_set_search_mode (RegistryList* self,
                                    gboolean value);
static void _registry_search_update_row_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self);
static void registry_search_finalize (GObject * obj);
static GType registry_search_get_type_once (void);
static void _vala_registry_search_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
registry_search_get_instance_private (RegistrySearch* self)
{
	return G_STRUCT_MEMBER_P (self, RegistrySearch_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
registry_search_real_select_first_row (RegistryList* base)
{
	RegistrySearch * self;
	const gchar* _tmp0_;
	self = (RegistrySearch*) base;
	_tmp0_ = self->priv->old_term;
	if (_tmp0_ != NULL) {
		GtkListBox* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((RegistryList*) self)->key_list_box;
		_tmp2_ = self->priv->old_term;
		_registry_search_select_first_row (_tmp1_, (const gchar*) _tmp2_);
	}
}

gboolean
registry_search_return_pressed (RegistrySearch* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RegistryList*) self)->key_list_box;
	result = _registry_search_return_pressed (_tmp0_);
	return result;
}

gboolean
registry_search_handle_alt_copy_text (RegistrySearch* self,
                                      gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	GtkListBox* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RegistryList*) self)->key_list_box;
	_tmp2_ = _registry_search_handle_alt_copy_text (&_tmp1_, _tmp0_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = _tmp2_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

void
registry_search_clean (RegistrySearch* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((RegistryList*) self)->key_list_box;
	gtk_list_box_bind_model (_tmp0_, NULL, NULL, NULL, NULL);
	registry_search_stop_global_search (self);
	self->priv->post_local = -1;
	self->priv->post_bookmarks = -1;
	self->priv->post_folders = -1;
	_g_free0 (self->priv->old_term);
	self->priv->old_term = NULL;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
registry_search_set_search_parameters (RegistrySearch* self,
                                       gboolean local_search,
                                       const gchar* current_path,
                                       guint16 current_context_id,
                                       gchar** _bookmarks,
                                       gint _bookmarks_length1,
                                       SortingOptions* _sorting_options)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	SortingOptions* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (_sorting_options != NULL);
	registry_search_clean (self);
	self->priv->is_local = local_search;
	_tmp0_ = g_strdup (current_path);
	_g_free0 (((RegistryList*) self)->current_path_if_search_mode);
	((RegistryList*) self)->current_path_if_search_mode = _tmp0_;
	self->priv->fallback_context_id = current_context_id;
	_tmp1_ = (_bookmarks != NULL) ? _vala_array_dup13 (_bookmarks, _bookmarks_length1) : _bookmarks;
	_tmp1__length1 = _bookmarks_length1;
	self->priv->bookmarks = (_vala_array_free (self->priv->bookmarks, self->priv->bookmarks_length1, (GDestroyNotify) g_free), NULL);
	self->priv->bookmarks = _tmp1_;
	self->priv->bookmarks_length1 = _tmp1__length1;
	self->priv->_bookmarks_size_ = self->priv->bookmarks_length1;
	_tmp2_ = _g_object_ref0 (_sorting_options);
	_g_object_unref0 (self->priv->sorting_options);
	self->priv->sorting_options = _tmp2_;
}

static void
registry_search_ensure_selection (GtkListBox* key_list_box,
                                  const gchar* full_name)
{
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (full_name != NULL);
	if (key_list_box == NULL) {
		return;
	}
	_tmp0_ = gtk_list_box_get_selected_row (G_TYPE_CHECK_INSTANCE_CAST (key_list_box, gtk_list_box_get_type (), GtkListBox));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ == NULL) {
		_registry_search_select_first_row (G_TYPE_CHECK_INSTANCE_CAST (key_list_box, gtk_list_box_get_type (), GtkListBox), full_name);
	}
	_g_object_unref0 (selected_row);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_registry_search_select_first_row (GtkListBox* key_list_box,
                                   const gchar* _term)
{
	gchar* term = NULL;
	gchar* _tmp0_;
	GtkListBoxRow* row = NULL;
	const gchar* _tmp1_;
	GtkListBoxRow* _tmp24_;
	GtkAdjustment* _tmp25_;
	g_return_if_fail (key_list_box != NULL);
	g_return_if_fail (_term != NULL);
	_tmp0_ = string_strip (_term);
	term = _tmp0_;
	_tmp1_ = term;
	if (g_str_has_prefix (_tmp1_, "/")) {
		GtkListBoxRow* _tmp2_;
		ClickableListBoxRow* row_child = NULL;
		GtkListBoxRow* _tmp3_;
		GtkWidget* _tmp4_;
		ClickableListBoxRow* _tmp5_;
		ClickableListBoxRow* _tmp6_;
		_tmp2_ = _registry_search_get_first_row (&key_list_box);
		_g_object_unref0 (row);
		row = _tmp2_;
		_tmp3_ = row;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_row_get_type (), GtkListBoxRow));
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		row_child = _tmp5_;
		_tmp6_ = row_child;
		if (_tmp6_ != NULL) {
			ClickableListBoxRow* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = row_child;
			_tmp8_ = clickable_list_box_row_get_full_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
			_tmp9_ = _tmp8_;
			_tmp10_ = term;
			if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
				GtkListBoxRow* second_row = NULL;
				GtkListBoxRow* _tmp11_;
				GtkListBoxRow* _tmp12_;
				GtkListBoxRow* _tmp13_;
				_tmp11_ = gtk_list_box_get_row_at_index (key_list_box, 1);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				second_row = _tmp12_;
				_tmp13_ = second_row;
				if (_tmp13_ != NULL) {
					GtkListBoxRow* _tmp14_;
					GtkListBoxRow* _tmp15_;
					_tmp14_ = second_row;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					_g_object_unref0 (row);
					row = _tmp15_;
				}
				_g_object_unref0 (second_row);
			}
		}
		_g_object_unref0 (row_child);
	} else {
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = term;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == 0) {
			GtkListBoxRow* _tmp19_;
			_tmp19_ = _registry_search_get_first_row (&key_list_box);
			_g_object_unref0 (row);
			row = _tmp19_;
		} else {
			GtkListBoxRow* _tmp20_;
			GtkListBoxRow* _tmp21_;
			GtkListBoxRow* _tmp22_;
			_tmp20_ = gtk_list_box_get_row_at_index (key_list_box, 1);
			_tmp21_ = _g_object_ref0 (_tmp20_);
			_g_object_unref0 (row);
			row = _tmp21_;
			_tmp22_ = row;
			if (_tmp22_ == NULL) {
				GtkListBoxRow* _tmp23_;
				_tmp23_ = _registry_search_get_first_row (&key_list_box);
				_g_object_unref0 (row);
				row = _tmp23_;
			}
		}
	}
	_tmp24_ = row;
	gtk_list_box_select_row (key_list_box, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp25_ = gtk_list_box_get_adjustment (key_list_box);
	gtk_adjustment_set_value (_tmp25_, (gdouble) 0);
	_g_object_unref0 (row);
	_g_free0 (term);
}

static GtkListBoxRow*
_registry_search_get_first_row (GtkListBox** key_list_box)
{
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* result;
	g_return_val_if_fail (*key_list_box != NULL, NULL);
	_tmp0_ = gtk_list_box_get_row_at_index (*key_list_box, 0);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	if (row == NULL) {
		g_assert_not_reached ();
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow));
	result = _tmp2_;
	_g_object_unref0 (row);
	return result;
}

static gboolean
_registry_search_return_pressed (GtkListBox* key_list_box)
{
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	gboolean result;
	g_return_val_if_fail (key_list_box != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row (key_list_box);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_list_box_row_get_type (), GtkListBoxRow));
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selected_row);
		return result;
	}
	_tmp3_ = selected_row;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_row_get_type (), GtkListBoxRow), "activate");
	result = TRUE;
	_g_object_unref0 (selected_row);
	return result;
}

static gboolean
_registry_search_handle_alt_copy_text (gchar** copy_text,
                                       GtkListBox* key_list_box)
{
	gchar* _vala_copy_text = NULL;
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp5_;
	gchar* _tmp6_ = NULL;
	gboolean result;
	g_return_val_if_fail (key_list_box != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row (key_list_box);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp4_ = base_window_no_copy_text (&_tmp3_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp3_;
		result = _tmp4_;
		_g_object_unref0 (selected_row);
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp5_ = selected_row;
	_registry_search_get_action_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow), &_tmp6_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp6_;
	result = TRUE;
	_g_object_unref0 (selected_row);
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
_registry_search_get_action_target (GtkListBoxRow* selected_row,
                                    gchar** action_target)
{
	gchar* _vala_action_target = NULL;
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (selected_row != NULL);
	_tmp0_ = gtk_actionable_get_action_target_value ((GtkActionable*) selected_row);
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	variant = _tmp1_;
	if (variant == NULL) {
		g_assert_not_reached ();
	}
	_tmp2_ = g_variant_get_type_string ((GVariant*) variant);
	if (g_strcmp0 (_tmp2_, "s") == 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_variant_get_string ((GVariant*) variant, NULL);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (_vala_action_target);
		_vala_action_target = _tmp4_;
	} else {
		guint16 unused = 0U;
		gchar* _tmp5_ = NULL;
		guint16 _tmp6_ = 0U;
		g_variant_get ((GVariant*) variant, "(sq)", &_tmp5_, &_tmp6_, NULL);
		_g_free0 (_vala_action_target);
		_vala_action_target = _tmp5_;
		unused = _tmp6_;
	}
	_g_variant_unref0 (variant);
	if (action_target) {
		*action_target = _vala_action_target;
	} else {
		_g_free0 (_vala_action_target);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GtkWidget*
_registry_list_new_list_box_row_gtk_list_box_create_widget_func (GObject* item,
                                                                 gpointer self)
{
	GtkWidget* result;
	result = registry_list_new_list_box_row ((RegistryList*) self, item);
	return result;
}

void
registry_search_start_search (RegistrySearch* self,
                              const gchar* _term)
{
	const gchar* _tmp0_;
	gchar* term = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean old_term_is_term_prefix = FALSE;
	SettingsModel* model = NULL;
	ModificationsHandler* _tmp16_;
	ModificationsHandler* _tmp17_;
	SettingsModel* _tmp18_;
	SettingsModel* _tmp19_;
	SettingsModel* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_term != NULL);
	_tmp0_ = ((RegistryList*) self)->current_path_if_search_mode;
	_vala_return_if_fail (_tmp0_ != NULL, "current_path_if_search_mode != null");
	_tmp1_ = string_strip (_term);
	term = _tmp1_;
	_tmp2_ = term;
	if (browser_window_is_path_invalid (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->old_term;
		if (_tmp3_ != NULL) {
			GtkListBox* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = ((RegistryList*) self)->key_list_box;
			_tmp5_ = self->priv->old_term;
			registry_search_ensure_selection (_tmp4_, (const gchar*) _tmp5_);
		}
		_g_free0 (term);
		return;
	}
	_tmp7_ = self->priv->old_term;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = term;
		_tmp9_ = self->priv->old_term;
		_tmp6_ = g_strcmp0 (_tmp8_, (const gchar*) _tmp9_) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkListBox* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = ((RegistryList*) self)->key_list_box;
		_tmp11_ = self->priv->old_term;
		registry_search_ensure_selection (_tmp10_, (const gchar*) _tmp11_);
		_g_free0 (term);
		return;
	}
	_tmp13_ = self->priv->old_term;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = term;
		_tmp15_ = self->priv->old_term;
		_tmp12_ = g_str_has_prefix (_tmp14_, (const gchar*) _tmp15_);
	} else {
		_tmp12_ = FALSE;
	}
	old_term_is_term_prefix = _tmp12_;
	_tmp16_ = registry_list_get_modifications_handler ((RegistryList*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = modifications_handler_get_model (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	model = _tmp20_;
	_tmp21_ = term;
	if (g_str_has_prefix (_tmp21_, "/")) {
		gboolean _tmp22_ = FALSE;
		SettingsModel* _tmp50_;
		self->priv->is_local = FALSE;
		if (old_term_is_term_prefix) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp23_ = term;
			_tmp24_ = self->priv->old_term;
			_tmp25_ = strlen ((const gchar*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = term;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) _tmp26_, (glong) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp22_ = !string_contains (_tmp31_, "/");
			_g_free0 (_tmp31_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			const gchar* _tmp32_;
			GtkListBox* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = term;
			registry_search_refine_paths_results (_tmp32_, &((RegistryList*) self)->list_model, &self->priv->post_local);
			_tmp33_ = ((RegistryList*) self)->key_list_box;
			_tmp34_ = term;
			registry_search_ensure_selection (_tmp33_, _tmp34_);
		} else {
			SettingsModel* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			const gchar* _tmp38_;
			SettingsModel* _tmp39_;
			SortingOptions* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			GListStore* _tmp45_;
			GtkListBox* _tmp46_;
			GListStore* _tmp47_;
			GtkListBox* _tmp48_;
			const gchar* _tmp49_;
			((RegistryList*) self)->search_is_path_search = TRUE;
			_tmp35_ = model;
			settings_model_clean_watched_keys (_tmp35_);
			registry_search_stop_global_search (self);
			_tmp36_ = term;
			_tmp37_ = model_utils_get_base_path (_tmp36_);
			_g_free0 (((RegistryList*) self)->current_path_if_search_mode);
			((RegistryList*) self)->current_path_if_search_mode = _tmp37_;
			_tmp38_ = ((RegistryList*) self)->current_path_if_search_mode;
			registry_search_insert_first_row ((const gchar*) _tmp38_, self->priv->fallback_context_id, &((RegistryList*) self)->list_model);
			_tmp39_ = model;
			_tmp40_ = self->priv->sorting_options;
			_tmp41_ = ((RegistryList*) self)->current_path_if_search_mode;
			_tmp42_ = term;
			_tmp43_ = model_utils_get_name_or_empty (_tmp42_);
			_tmp44_ = _tmp43_;
			registry_search_local_search (_tmp39_, _tmp40_, (const gchar*) _tmp41_, _tmp44_, &((RegistryList*) self)->list_model);
			_g_free0 (_tmp44_);
			_tmp45_ = ((RegistryList*) self)->list_model;
			self->priv->post_local = (gint) g_list_model_get_n_items ((GListModel*) _tmp45_);
			_tmp46_ = ((RegistryList*) self)->key_list_box;
			_tmp47_ = ((RegistryList*) self)->list_model;
			gtk_list_box_bind_model (_tmp46_, (GListModel*) _tmp47_, _registry_list_new_list_box_row_gtk_list_box_create_widget_func, g_object_ref ((RegistryList*) self), g_object_unref);
			_tmp48_ = ((RegistryList*) self)->key_list_box;
			_tmp49_ = term;
			_registry_search_select_first_row (_tmp48_, _tmp49_);
		}
		_tmp50_ = model;
		settings_model_keys_value_push (_tmp50_);
	} else {
		if (old_term_is_term_prefix) {
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			GtkListBox* _tmp59_;
			const gchar* _tmp60_;
			SettingsModel* _tmp61_;
			registry_search_pause_global_search (&self->priv->search_source);
			_tmp51_ = term;
			registry_search_refine_local_results (_tmp51_, &((RegistryList*) self)->list_model, &self->priv->post_local, &self->priv->post_bookmarks, &self->priv->post_folders);
			_tmp52_ = term;
			registry_search_refine_bookmarks_results (_tmp52_, self->priv->post_local, &((RegistryList*) self)->list_model, &self->priv->post_bookmarks, &self->priv->post_folders);
			_tmp53_ = self->priv->old_term;
			if (g_strcmp0 ((const gchar*) _tmp53_, "") == 0) {
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp54_ = ((RegistryList*) self)->current_path_if_search_mode;
				_tmp55_ = term;
				registry_search_start_global_search (self, (const gchar*) _tmp54_, _tmp55_);
			} else {
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				_tmp56_ = term;
				registry_search_refine_global_results (_tmp56_, self->priv->post_bookmarks, self->priv->is_local, &((RegistryList*) self)->list_model, &self->priv->post_folders);
				_tmp57_ = ((RegistryList*) self)->current_path_if_search_mode;
				_tmp58_ = term;
				registry_search_resume_global_search (self, (const gchar*) _tmp57_, _tmp58_);
			}
			_tmp59_ = ((RegistryList*) self)->key_list_box;
			_tmp60_ = term;
			registry_search_ensure_selection (_tmp59_, _tmp60_);
			_tmp61_ = model;
			settings_model_keys_value_push (_tmp61_);
		} else {
			SettingsModel* _tmp62_;
			const gchar* _tmp63_;
			SettingsModel* _tmp64_;
			SortingOptions* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			const gchar* _tmp69_;
			GListStore* _tmp70_;
			SettingsModel* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gchar** _tmp74_;
			gint _tmp74__length1;
			GtkListBox* _tmp75_;
			GListStore* _tmp76_;
			GtkListBox* _tmp77_;
			const gchar* _tmp78_;
			SettingsModel* _tmp79_;
			const gchar* _tmp80_;
			((RegistryList*) self)->search_is_path_search = FALSE;
			_tmp62_ = model;
			settings_model_clean_watched_keys (_tmp62_);
			registry_search_stop_global_search (self);
			_tmp63_ = ((RegistryList*) self)->current_path_if_search_mode;
			registry_search_insert_first_row ((const gchar*) _tmp63_, self->priv->fallback_context_id, &((RegistryList*) self)->list_model);
			_tmp64_ = model;
			_tmp65_ = self->priv->sorting_options;
			_tmp66_ = ((RegistryList*) self)->current_path_if_search_mode;
			_tmp67_ = model_utils_get_base_path ((const gchar*) _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = term;
			registry_search_local_search (_tmp64_, _tmp65_, _tmp68_, _tmp69_, &((RegistryList*) self)->list_model);
			_g_free0 (_tmp68_);
			_tmp70_ = ((RegistryList*) self)->list_model;
			self->priv->post_local = (gint) g_list_model_get_n_items ((GListModel*) _tmp70_);
			self->priv->post_bookmarks = self->priv->post_local;
			_tmp71_ = model;
			_tmp72_ = ((RegistryList*) self)->current_path_if_search_mode;
			_tmp73_ = term;
			_tmp74_ = self->priv->bookmarks;
			_tmp74__length1 = self->priv->bookmarks_length1;
			registry_search_bookmark_search (_tmp71_, (const gchar*) _tmp72_, _tmp73_, _tmp74_, (gint) _tmp74__length1, self->priv->is_local, &((RegistryList*) self)->list_model, &self->priv->post_bookmarks);
			self->priv->post_folders = self->priv->post_bookmarks;
			_tmp75_ = ((RegistryList*) self)->key_list_box;
			_tmp76_ = ((RegistryList*) self)->list_model;
			gtk_list_box_bind_model (_tmp75_, (GListModel*) _tmp76_, _registry_list_new_list_box_row_gtk_list_box_create_widget_func, g_object_ref ((RegistryList*) self), g_object_unref);
			_tmp77_ = ((RegistryList*) self)->key_list_box;
			_tmp78_ = term;
			_registry_search_select_first_row (_tmp77_, _tmp78_);
			_tmp79_ = model;
			settings_model_keys_value_push (_tmp79_);
			_tmp80_ = term;
			if (g_strcmp0 (_tmp80_, "") != 0) {
				const gchar* _tmp81_;
				const gchar* _tmp82_;
				_tmp81_ = ((RegistryList*) self)->current_path_if_search_mode;
				_tmp82_ = term;
				registry_search_start_global_search (self, (const gchar*) _tmp81_, _tmp82_);
			}
			if (self->priv->is_local) {
				const gchar* _tmp83_;
				_tmp83_ = ((RegistryList*) self)->current_path_if_search_mode;
				registry_search_insert_global_search_row ((const gchar*) _tmp83_, self->priv->fallback_context_id, &((RegistryList*) self)->list_model);
			}
		}
	}
	_tmp84_ = term;
	_tmp85_ = g_strdup (_tmp84_);
	_g_free0 (self->priv->old_term);
	self->priv->old_term = _tmp85_;
	_g_object_unref0 (model);
	_g_free0 (term);
}

static void
registry_search_insert_first_row (const gchar* current_path,
                                  guint16 _fallback_context_id,
                                  GListStore** list_model)
{
	guint16 _tmp0_ = 0U;
	guint16 fallback_context_id = 0U;
	gchar* name = NULL;
	gchar* _tmp1_;
	SimpleSettingObject* sso = NULL;
	SimpleSettingObject* _tmp2_;
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (*list_model != NULL);
	if (model_utils_is_folder_path (current_path)) {
		_tmp0_ = MODEL_UTILS_folder_context_id;
	} else {
		_tmp0_ = _fallback_context_id;
	}
	fallback_context_id = _tmp0_;
	_tmp1_ = model_utils_get_name (current_path);
	name = _tmp1_;
	_tmp2_ = simple_setting_object_new_from_full_name (fallback_context_id, name, current_path, FALSE, TRUE);
	sso = _tmp2_;
	g_list_store_insert (*list_model, (guint) 0, (GObject*) sso);
	_g_object_unref0 (sso);
	_g_free0 (name);
}

static void
registry_search_insert_global_search_row (const gchar* current_path,
                                          guint16 _fallback_context_id,
                                          GListStore** list_model)
{
	guint16 _tmp0_ = 0U;
	guint16 fallback_context_id = 0U;
	SimpleSettingObject* sso = NULL;
	SimpleSettingObject* _tmp1_;
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (*list_model != NULL);
	if (model_utils_is_folder_path (current_path)) {
		_tmp0_ = MODEL_UTILS_folder_context_id;
	} else {
		_tmp0_ = _fallback_context_id;
	}
	fallback_context_id = _tmp0_;
	_tmp1_ = simple_setting_object_new_from_full_name (fallback_context_id, "", current_path, TRUE, FALSE);
	sso = _tmp1_;
	g_list_store_insert (*list_model, g_list_model_get_n_items ((GListModel*) (*list_model)), (GObject*) sso);
	_g_object_unref0 (sso);
}

static void
registry_search_refine_paths_results (const gchar* term,
                                      GListStore** list_model,
                                      gint* post_local)
{
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	if ((*post_local) < 1) {
		g_assert_not_reached ();
	}
	if ((*post_local) == 1) {
		return;
	}
	{
		gint i = 0;
		i = (*post_local) - 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp2_;
				SimpleSettingObject* _tmp3_;
				SimpleSettingObject* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 1)) {
					break;
				}
				_tmp2_ = g_list_model_get_item ((GListModel*) (*list_model), (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp3_ = item;
				if (_tmp3_ == NULL) {
					g_assert_not_reached ();
				}
				_tmp4_ = item;
				_tmp5_ = simple_setting_object_get_full_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
				_tmp6_ = _tmp5_;
				if (!string_contains (_tmp6_, term)) {
					gint _tmp7_;
					_tmp7_ = *post_local;
					*post_local = _tmp7_ - 1;
					g_list_store_remove (*list_model, (guint) i);
				}
				_g_object_unref0 (item);
			}
		}
	}
}

static void
registry_search_refine_local_results (const gchar* term,
                                      GListStore** list_model,
                                      gint* post_local,
                                      gint* post_bookmarks,
                                      gint* post_folders)
{
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	if ((*post_local) < 1) {
		g_assert_not_reached ();
	}
	if ((*post_local) == 1) {
		return;
	}
	{
		gint i = 0;
		i = (*post_local) - 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp2_;
				SimpleSettingObject* _tmp3_;
				SimpleSettingObject* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 1)) {
					break;
				}
				_tmp2_ = g_list_model_get_item ((GListModel*) (*list_model), (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp3_ = item;
				if (_tmp3_ == NULL) {
					g_assert_not_reached ();
				}
				_tmp4_ = item;
				_tmp5_ = simple_setting_object_get_casefolded_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_casefold (term, (gssize) -1);
				_tmp8_ = _tmp7_;
				_tmp9_ = !string_contains (_tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = *post_local;
					*post_local = _tmp10_ - 1;
					_tmp11_ = *post_bookmarks;
					*post_bookmarks = _tmp11_ - 1;
					_tmp12_ = *post_folders;
					*post_folders = _tmp12_ - 1;
					g_list_store_remove (*list_model, (guint) i);
				}
				_g_object_unref0 (item);
			}
		}
	}
}

static void
registry_search_refine_bookmarks_results (const gchar* term,
                                          gint post_local,
                                          GListStore** list_model,
                                          gint* post_bookmarks,
                                          gint* post_folders)
{
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	if ((*post_bookmarks) < post_local) {
		g_assert_not_reached ();
	}
	if ((*post_bookmarks) == post_local) {
		return;
	}
	{
		gint i = 0;
		i = (*post_bookmarks) - 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp2_;
				SimpleSettingObject* _tmp3_;
				gchar* name = NULL;
				SimpleSettingObject* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= post_local)) {
					break;
				}
				_tmp2_ = g_list_model_get_item ((GListModel*) (*list_model), (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp3_ = item;
				if (_tmp3_ == NULL) {
					g_assert_not_reached ();
				}
				_tmp4_ = item;
				_tmp5_ = simple_setting_object_get_casefolded_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				name = _tmp7_;
				_tmp9_ = name;
				_tmp10_ = g_utf8_casefold (term, (gssize) -1);
				_tmp11_ = _tmp10_;
				_tmp12_ = !string_contains (_tmp9_, _tmp11_);
				_g_free0 (_tmp11_);
				if (_tmp12_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp13_ = FALSE;
					SimpleSettingObject* _tmp14_;
					gboolean _tmp15_;
					gboolean _tmp16_;
					_tmp14_ = item;
					_tmp15_ = simple_setting_object_get_is_search (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
					_tmp16_ = _tmp15_;
					if (_tmp16_) {
						const gchar* _tmp17_;
						_tmp17_ = name;
						_tmp13_ = g_strcmp0 (term, _tmp17_) == 0;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp8_ = _tmp13_;
				}
				if (_tmp8_) {
					gint _tmp18_;
					gint _tmp19_;
					_tmp18_ = *post_bookmarks;
					*post_bookmarks = _tmp18_ - 1;
					_tmp19_ = *post_folders;
					*post_folders = _tmp19_ - 1;
					g_list_store_remove (*list_model, (guint) i);
				}
				_g_free0 (name);
				_g_object_unref0 (item);
			}
		}
	}
}

static void
registry_search_refine_global_results (const gchar* term,
                                       gint post_bookmarks,
                                       gboolean is_local,
                                       GListStore** list_model,
                                       gint* post_folders)
{
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	{
		gint _tmp0_ = 0;
		gint i = 0;
		if (is_local) {
			_tmp0_ = 2;
		} else {
			_tmp0_ = 1;
		}
		i = ((gint) g_list_model_get_n_items ((GListModel*) (*list_model))) - _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp3_;
				SimpleSettingObject* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= (*post_folders))) {
					break;
				}
				_tmp3_ = g_list_model_get_item ((GListModel*) (*list_model), (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp4_ = item;
				_tmp5_ = simple_setting_object_get_casefolded_name (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_casefold (term, (gssize) -1);
				_tmp8_ = _tmp7_;
				_tmp9_ = !string_contains (_tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					g_list_store_remove (*list_model, (guint) i);
				}
				_g_object_unref0 (item);
			}
		}
	}
	{
		gint i = 0;
		i = (*post_folders) - 1;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				SimpleSettingObject* item = NULL;
				GObject* _tmp12_;
				SimpleSettingObject* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ - 1;
				}
				_tmp10_ = FALSE;
				if (!(i >= post_bookmarks)) {
					break;
				}
				_tmp12_ = g_list_model_get_item ((GListModel*) (*list_model), (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject);
				_tmp13_ = item;
				_tmp14_ = simple_setting_object_get_casefolded_name (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_utf8_casefold (term, (gssize) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = !string_contains (_tmp15_, _tmp17_);
				_g_free0 (_tmp17_);
				if (_tmp18_) {
					gint _tmp19_;
					_tmp19_ = *post_folders;
					*post_folders = _tmp19_ - 1;
					g_list_store_remove (*list_model, (guint) i);
				}
				_g_object_unref0 (item);
			}
		}
	}
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		_g_object_unref0 (_data41_->comparator);
		g_slice_free (Block41Data, _data41_);
	}
}

static gint
__lambda85_ (Block41Data* _data41_,
             gconstpointer a,
             gconstpointer b)
{
	SettingComparator* _tmp0_;
	gint result;
	_tmp0_ = _data41_->comparator;
	result = setting_comparator_compare (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject), G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
	return result;
}

static gint
___lambda85__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda85_ (self, a, b);
	return result;
}

static void
registry_search_local_search (SettingsModel* model,
                              SortingOptions* sorting_options,
                              const gchar* current_path,
                              const gchar* term,
                              GListStore** list_model)
{
	Block41Data* _data41_;
	GVariant* key_model = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	SettingComparator* _tmp2_;
	GCompareDataFunc compare = NULL;
	gpointer compare_target;
	GDestroyNotify compare_target_destroy_notify;
	GVariantIter* iter = NULL;
	GVariant* _tmp3_;
	GVariantIter* _tmp4_;
	guint16 context_id = 0U;
	gchar* name = NULL;
	g_return_if_fail (model != NULL);
	g_return_if_fail (sorting_options != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	_vala_return_if_fail (model_utils_is_folder_path (current_path), "ModelUtils.is_folder_path (current_path)");
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_tmp0_ = settings_model_get_children (model, current_path, TRUE, FALSE);
	key_model = _tmp0_;
	_tmp1_ = key_model;
	if (_tmp1_ == NULL) {
		_g_variant_unref0 (key_model);
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return;
	}
	_tmp2_ = sorting_options_get_comparator (sorting_options);
	_data41_->comparator = _tmp2_;
	compare = ___lambda85__gcompare_data_func;
	compare_target = block41_data_ref (_data41_);
	compare_target_destroy_notify = block41_data_unref;
	_tmp3_ = key_model;
	_tmp4_ = g_variant_iter_new ((GVariant*) _tmp3_);
	iter = _tmp4_;
	while (TRUE) {
		GVariantIter* _tmp5_;
		guint16 _tmp6_ = 0U;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp5_ = iter;
		_tmp8_ = g_variant_iter_next (_tmp5_, "(qs)", &_tmp6_, &_tmp7_, NULL);
		context_id = _tmp6_;
		_g_free0 (name);
		name = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = name;
		_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) -1);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_utf8_casefold (term, (gssize) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_contains (_tmp11_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		if (_tmp14_) {
			SimpleSettingObject* sso = NULL;
			const gchar* _tmp15_;
			SimpleSettingObject* _tmp16_;
			SimpleSettingObject* _tmp17_;
			GCompareDataFunc _tmp18_;
			gpointer _tmp18__target;
			_tmp15_ = name;
			_tmp16_ = simple_setting_object_new_from_base_path (context_id, _tmp15_, current_path, FALSE, FALSE);
			sso = _tmp16_;
			_tmp17_ = sso;
			_tmp18_ = compare;
			_tmp18__target = compare_target;
			g_list_store_insert_sorted (*list_model, (GObject*) _tmp17_, _tmp18_, _tmp18__target);
			_g_object_unref0 (sso);
		}
	}
	_g_free0 (name);
	_g_variant_iter_free0 (iter);
	(compare_target_destroy_notify == NULL) ? NULL : (compare_target_destroy_notify (compare_target), NULL);
	compare = NULL;
	compare_target = NULL;
	compare_target_destroy_notify = NULL;
	_g_variant_unref0 (key_model);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
registry_search_bookmark_search (SettingsModel* model,
                                 const gchar* current_path,
                                 const gchar* term,
                                 gchar** bookmarks,
                                 gint bookmarks_length1,
                                 gboolean is_local,
                                 GListStore** list_model,
                                 gint* post_bookmarks)
{
	g_return_if_fail (model != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (term != NULL);
	g_return_if_fail (*list_model != NULL);
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = bookmarks;
		bookmark_collection_length1 = bookmarks_length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp0_;
			gchar* bookmark = NULL;
			_tmp0_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp0_;
			{
				const gchar* _tmp1_;
				gchar* bookmark_parent_path = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_ = FALSE;
				guint16 context_id = 0U;
				gchar* name = NULL;
				gboolean is_search = FALSE;
				const gchar* _tmp16_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp1_ = bookmark;
				if (g_strcmp0 (_tmp1_, current_path) == 0) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp2_ = bookmark;
				_tmp3_ = model_utils_get_parent_path (_tmp2_);
				bookmark_parent_path = _tmp3_;
				_tmp4_ = bookmark_parent_path;
				_tmp5_ = model_utils_get_base_path (current_path);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					_g_free0 (bookmark_parent_path);
					_g_free0 (bookmark);
					continue;
				}
				_tmp8_ = bookmark;
				_tmp9_ = g_strconcat ("?", term, NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 (_tmp8_, _tmp10_) == 0;
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					_g_free0 (bookmark_parent_path);
					_g_free0 (bookmark);
					continue;
				}
				if (is_local) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = bookmark_parent_path;
					_tmp14_ = model_utils_get_base_path (current_path);
					_tmp15_ = _tmp14_;
					_tmp12_ = !g_str_has_prefix (_tmp13_, _tmp15_);
					_g_free0 (_tmp15_);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_g_free0 (bookmark_parent_path);
					_g_free0 (bookmark);
					continue;
				}
				_tmp16_ = bookmark;
				is_search = g_str_has_prefix (_tmp16_, "?");
				if (is_search) {
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					context_id = MODEL_UTILS_undefined_context_id;
					_tmp17_ = bookmark;
					_tmp18_ = bookmark;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = string_slice (_tmp17_, (glong) 1, (glong) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = model_utils_get_name (_tmp22_);
					_g_free0 (name);
					name = _tmp23_;
					_g_free0 (_tmp22_);
				} else {
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					guint16 _tmp26_ = 0U;
					gchar* _tmp27_ = NULL;
					gboolean _tmp28_;
					_tmp24_ = bookmark;
					_tmp25_ = bookmark_parent_path;
					_tmp28_ = settings_model_get_object (model, _tmp24_, &_tmp26_, &_tmp27_, !_vala_string_array_contains (bookmarks, bookmarks_length1, _tmp25_));
					context_id = _tmp26_;
					_g_free0 (name);
					name = _tmp27_;
					if (!_tmp28_) {
						_g_free0 (name);
						_g_free0 (bookmark_parent_path);
						_g_free0 (bookmark);
						continue;
					}
				}
				_tmp29_ = name;
				_tmp30_ = g_utf8_casefold (_tmp29_, (gssize) -1);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_utf8_casefold (term, (gssize) -1);
				_tmp33_ = _tmp32_;
				_tmp34_ = string_contains (_tmp31_, _tmp33_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp31_);
				if (_tmp34_) {
					SimpleSettingObject* sso = NULL;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					SimpleSettingObject* _tmp37_;
					SimpleSettingObject* _tmp38_;
					gint _tmp39_;
					_tmp35_ = name;
					_tmp36_ = bookmark;
					_tmp37_ = simple_setting_object_new_from_full_name (context_id, _tmp35_, _tmp36_, is_search, FALSE);
					sso = _tmp37_;
					_tmp38_ = sso;
					g_list_store_insert (*list_model, (guint) (*post_bookmarks), (GObject*) _tmp38_);
					_tmp39_ = *post_bookmarks;
					*post_bookmarks = _tmp39_ + 1;
					_g_object_unref0 (sso);
				}
				_g_free0 (name);
				_g_free0 (bookmark_parent_path);
				_g_free0 (bookmark);
			}
		}
	}
}

static void
registry_search_stop_global_search (RegistrySearch* self)
{
	GQueue* _tmp0_;
	GListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	registry_search_pause_global_search (&self->priv->search_source);
	_tmp0_ = self->priv->search_nodes;
	g_queue_clear (_tmp0_);
	_tmp1_ = ((RegistryList*) self)->list_model;
	g_list_store_remove_all (_tmp1_);
}

static void
registry_search_start_global_search (RegistrySearch* self,
                                     const gchar* current_path,
                                     const gchar* term)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (term != NULL);
	if (self->priv->is_local) {
		GQueue* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->search_nodes;
		_tmp1_ = model_utils_get_base_path (current_path);
		g_queue_push_head (_tmp0_, _tmp1_);
	} else {
		GQueue* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->search_nodes;
		_tmp3_ = g_strdup ("/");
		g_queue_push_head (_tmp2_, _tmp3_);
	}
	registry_search_resume_global_search (self, current_path, term);
}

static void
registry_search_pause_global_search (guint** search_source)
{
	if ((*search_source) == NULL) {
		return;
	}
	g_source_remove ((guint) (*(*search_source)));
	_g_free0 (*search_source);
	*search_source = NULL;
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		RegistrySearch* self;
		self = _data42_->self;
		_g_free0 (_data42_->current_path);
		_g_free0 (_data42_->term);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static gboolean
__lambda86_ (Block42Data* _data42_)
{
	RegistrySearch* self;
	GQueue* _tmp0_;
	gboolean result;
	self = _data42_->self;
	_tmp0_ = self->priv->search_nodes;
	if (g_queue_is_empty (_tmp0_)) {
		_g_free0 (self->priv->search_source);
		self->priv->search_source = NULL;
		result = FALSE;
		return result;
	}
	registry_search_global_search_step (self, _data42_->current_path, _data42_->term);
	result = TRUE;
	return result;
}

static gboolean
___lambda86__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda86_ (self);
	return result;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static void
registry_search_resume_global_search (RegistrySearch* self,
                                      const gchar* current_path,
                                      const gchar* term)
{
	Block42Data* _data42_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (term != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = g_strdup (current_path);
	_g_free0 (_data42_->current_path);
	_data42_->current_path = _tmp0_;
	_tmp1_ = g_strdup (term);
	_g_free0 (_data42_->term);
	_data42_->term = _tmp1_;
	_tmp2_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda86__gsource_func, block42_data_ref (_data42_), block42_data_unref);
	_tmp3_ = __uint_dup0 (&_tmp2_);
	_g_free0 (self->priv->search_source);
	self->priv->search_source = _tmp3_;
	block42_data_unref (_data42_);
	_data42_ = NULL;
}

static void
registry_search_global_search_step (RegistrySearch* self,
                                    const gchar* current_path,
                                    const gchar* term)
{
	SettingsModel* model = NULL;
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	SettingsModel* _tmp2_;
	SettingsModel* _tmp3_;
	SettingsModel* _tmp4_;
	gchar* next = NULL;
	GQueue* _tmp5_;
	gpointer _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean local_again = FALSE;
	GVariant* next_key_model = NULL;
	SettingsModel* _tmp12_;
	const gchar* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariantIter* iter = NULL;
	GVariant* _tmp16_;
	GVariantIter* _tmp17_;
	guint16 context_id = 0U;
	gchar* name = NULL;
	GtkListBox* _tmp68_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	g_return_if_fail (term != NULL);
	_tmp0_ = registry_list_get_modifications_handler ((RegistryList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	_tmp5_ = self->priv->search_nodes;
	_tmp6_ = g_queue_pop_head (_tmp5_);
	next = (gchar*) ((gchar*) _tmp6_);
	_tmp8_ = next;
	if (g_strcmp0 (_tmp8_, current_path) == 0) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = next;
		_tmp10_ = model_utils_get_base_path (current_path);
		_tmp11_ = _tmp10_;
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp11_) == 0;
		_g_free0 (_tmp11_);
	}
	local_again = _tmp7_;
	_tmp12_ = model;
	_tmp13_ = next;
	_tmp14_ = settings_model_get_children (_tmp12_, _tmp13_, TRUE, FALSE);
	next_key_model = _tmp14_;
	_tmp15_ = next_key_model;
	if (_tmp15_ == NULL) {
		_g_variant_unref0 (next_key_model);
		_g_free0 (next);
		_g_object_unref0 (model);
		return;
	}
	_tmp16_ = next_key_model;
	_tmp17_ = g_variant_iter_new ((GVariant*) _tmp16_);
	iter = _tmp17_;
	while (TRUE) {
		GVariantIter* _tmp18_;
		guint16 _tmp19_ = 0U;
		gchar* _tmp20_ = NULL;
		gboolean _tmp21_;
		_tmp18_ = iter;
		_tmp21_ = g_variant_iter_next (_tmp18_, "(qs)", &_tmp19_, &_tmp20_, NULL);
		context_id = _tmp19_;
		_g_free0 (name);
		name = _tmp20_;
		if (!_tmp21_) {
			break;
		}
		if (model_utils_is_folder_context_id (context_id)) {
			gchar* full_name = NULL;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			GQueue* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp22_ = next;
			_tmp23_ = name;
			_tmp24_ = model_utils_recreate_full_name (_tmp22_, _tmp23_, TRUE);
			full_name = _tmp24_;
			if (!local_again) {
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				_tmp27_ = full_name;
				_tmp28_ = self->priv->bookmarks;
				_tmp28__length1 = self->priv->bookmarks_length1;
				_tmp26_ = !_vala_string_array_contains (_tmp28_, _tmp28__length1, _tmp27_);
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp29_ = name;
				_tmp30_ = g_utf8_casefold (_tmp29_, (gssize) -1);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_utf8_casefold (term, (gssize) -1);
				_tmp33_ = _tmp32_;
				_tmp25_ = string_contains (_tmp31_, _tmp33_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp31_);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				SimpleSettingObject* sso = NULL;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				SimpleSettingObject* _tmp36_;
				GListStore* _tmp37_;
				gint _tmp38_;
				SimpleSettingObject* _tmp39_;
				_tmp34_ = name;
				_tmp35_ = full_name;
				_tmp36_ = simple_setting_object_new_from_full_name (context_id, _tmp34_, _tmp35_, FALSE, FALSE);
				sso = _tmp36_;
				_tmp37_ = ((RegistryList*) self)->list_model;
				_tmp38_ = self->priv->post_folders;
				self->priv->post_folders = _tmp38_ + 1;
				_tmp39_ = sso;
				g_list_store_insert (_tmp37_, (guint) _tmp38_, (GObject*) _tmp39_);
				_g_object_unref0 (sso);
			}
			_tmp40_ = self->priv->search_nodes;
			_tmp41_ = full_name;
			_tmp42_ = g_strdup (_tmp41_);
			g_queue_push_tail (_tmp40_, _tmp42_);
			_g_free0 (full_name);
		} else {
			gchar* full_name = NULL;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			gboolean _tmp46_ = FALSE;
			gboolean _tmp47_ = FALSE;
			_tmp43_ = next;
			_tmp44_ = name;
			_tmp45_ = model_utils_recreate_full_name (_tmp43_, _tmp44_, FALSE);
			full_name = _tmp45_;
			if (!local_again) {
				const gchar* _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				_tmp48_ = full_name;
				_tmp49_ = self->priv->bookmarks;
				_tmp49__length1 = self->priv->bookmarks_length1;
				_tmp47_ = !_vala_string_array_contains (_tmp49_, _tmp49__length1, _tmp48_);
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp50_ = name;
				_tmp51_ = g_utf8_casefold (_tmp50_, (gssize) -1);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_utf8_casefold (term, (gssize) -1);
				_tmp54_ = _tmp53_;
				_tmp46_ = string_contains (_tmp52_, _tmp54_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				SimpleSettingObject* sso = NULL;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				SimpleSettingObject* _tmp57_;
				guint _tmp58_ = 0U;
				GListStore* _tmp61_;
				SimpleSettingObject* _tmp62_;
				SettingsModel* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp55_ = name;
				_tmp56_ = next;
				_tmp57_ = simple_setting_object_new_from_base_path (context_id, _tmp55_, _tmp56_, FALSE, FALSE);
				sso = _tmp57_;
				if (self->priv->is_local) {
					GListStore* _tmp59_;
					_tmp59_ = ((RegistryList*) self)->list_model;
					_tmp58_ = g_list_model_get_n_items ((GListModel*) _tmp59_) - 1;
				} else {
					GListStore* _tmp60_;
					_tmp60_ = ((RegistryList*) self)->list_model;
					_tmp58_ = g_list_model_get_n_items ((GListModel*) _tmp60_);
				}
				_tmp61_ = ((RegistryList*) self)->list_model;
				_tmp62_ = sso;
				g_list_store_insert (_tmp61_, _tmp58_, (GObject*) _tmp62_);
				_tmp63_ = model;
				_tmp64_ = next;
				_tmp65_ = name;
				_tmp66_ = g_strconcat (_tmp64_, _tmp65_, NULL);
				_tmp67_ = _tmp66_;
				settings_model_key_value_push (_tmp63_, _tmp67_, context_id);
				_g_free0 (_tmp67_);
				_g_object_unref0 (sso);
			}
			_g_free0 (full_name);
		}
	}
	_tmp68_ = ((RegistryList*) self)->key_list_box;
	registry_search_ensure_selection (_tmp68_, term);
	_g_free0 (name);
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (next_key_model);
	_g_free0 (next);
	_g_object_unref0 (model);
}

static void
registry_search_update_row_header (RegistrySearch* self,
                                   GtkListBoxRow* row,
                                   GtkListBoxRow* before)
{
	gint row_index = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar* label_text = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	ListBoxRowHeader* _tmp16_;
	ListBoxRowHeader* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	row_index = gtk_list_box_row_get_index (row);
	if (registry_list_is_first_row (row_index, before)) {
		return;
	}
	if (((RegistryList*) self)->search_is_path_search) {
		ModificationsHandler* _tmp0_;
		ModificationsHandler* _tmp1_;
		SettingsModel* _tmp2_;
		SettingsModel* _tmp3_;
		_tmp0_ = registry_list_get_modifications_handler ((RegistryList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = modifications_handler_get_model (_tmp1_);
		_tmp3_ = _tmp2_;
		registry_list_update_row_header_with_context (row, G_TYPE_CHECK_INSTANCE_CAST (before, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp3_, FALSE);
		return;
	}
	if (row_index >= 1) {
		_tmp5_ = self->priv->post_local > 1;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = row_index < self->priv->post_local;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ModificationsHandler* _tmp6_;
		ModificationsHandler* _tmp7_;
		SettingsModel* _tmp8_;
		SettingsModel* _tmp9_;
		_tmp6_ = registry_list_get_modifications_handler ((RegistryList*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = modifications_handler_get_model (_tmp7_);
		_tmp9_ = _tmp8_;
		registry_list_update_row_header_with_context (row, G_TYPE_CHECK_INSTANCE_CAST (before, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp9_, TRUE);
		return;
	}
	if (row_index >= self->priv->post_folders) {
		ModificationsHandler* _tmp10_;
		ModificationsHandler* _tmp11_;
		SettingsModel* _tmp12_;
		SettingsModel* _tmp13_;
		_tmp10_ = registry_list_get_modifications_handler ((RegistryList*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = modifications_handler_get_model (_tmp11_);
		_tmp13_ = _tmp12_;
		registry_list_update_row_header_with_context (row, G_TYPE_CHECK_INSTANCE_CAST (before, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp13_, FALSE);
		return;
	}
	_tmp14_ = registry_search_get_header_text (row_index, self->priv->post_local, self->priv->post_bookmarks, self->priv->post_folders);
	label_text = _tmp14_;
	_tmp15_ = label_text;
	_tmp16_ = list_box_row_header_new (FALSE, _tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_g_free0 (label_text);
}

static gchar*
registry_search_get_header_text (gint row_index,
                                 gint post_local,
                                 gint post_bookmarks,
                                 gint post_folders)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* result;
	if (row_index == post_local) {
		_tmp0_ = post_local != post_bookmarks;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("Bookmarks"));
		result = _tmp1_;
		return result;
	}
	if (row_index == post_bookmarks) {
		_tmp2_ = post_bookmarks != post_folders;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Folders"));
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

RegistrySearch*
registry_search_construct (GType object_type)
{
	RegistrySearch * self = NULL;
	self = (RegistrySearch*) registry_list_construct (object_type);
	return self;
}

RegistrySearch*
registry_search_new (void)
{
	return registry_search_construct (TYPE_REGISTRY_SEARCH);
}

static const gchar*
registry_search_real_get_placeholder_label (RegistryList* base)
{
	const gchar* result;
	RegistrySearch* self;
	self = (RegistrySearch*) base;
	result = _ ("No matches");
	return result;
}

static void
_registry_search_update_row_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                    GtkListBoxRow* before,
                                                                    gpointer self)
{
	registry_search_update_row_header ((RegistrySearch*) self, row, before);
}

static GObject *
registry_search_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RegistrySearch * self;
	GtkListBox* _tmp0_;
	parent_class = G_OBJECT_CLASS (registry_search_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_SEARCH, RegistrySearch);
	registry_list_set_search_mode ((RegistryList*) self, TRUE);
	_tmp0_ = ((RegistryList*) self)->key_list_box;
	gtk_list_box_set_header_func (_tmp0_, _registry_search_update_row_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
registry_search_class_init (RegistrySearchClass * klass,
                            gpointer klass_data)
{
	registry_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RegistrySearch_private_offset);
	((RegistryListClass *) klass)->select_first_row = (void (*) (RegistryList*)) registry_search_real_select_first_row;
	REGISTRY_LIST_CLASS (klass)->get_placeholder_label = registry_search_real_get_placeholder_label;
	G_OBJECT_CLASS (klass)->get_property = _vala_registry_search_get_property;
	G_OBJECT_CLASS (klass)->constructor = registry_search_constructor;
	G_OBJECT_CLASS (klass)->finalize = registry_search_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_SEARCH_PLACEHOLDER_LABEL_PROPERTY, registry_search_properties[REGISTRY_SEARCH_PLACEHOLDER_LABEL_PROPERTY] = g_param_spec_string ("placeholder-label", "placeholder-label", "placeholder-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
registry_search_instance_init (RegistrySearch * self,
                               gpointer klass)
{
	GQueue* _tmp0_;
	self->priv = registry_search_get_instance_private (self);
	self->priv->is_local = FALSE;
	self->priv->fallback_context_id = MODEL_UTILS_undefined_context_id;
	self->priv->search_source = NULL;
	_tmp0_ = g_queue_new ();
	self->priv->search_nodes = _tmp0_;
}

static void
registry_search_finalize (GObject * obj)
{
	RegistrySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_SEARCH, RegistrySearch);
	self->priv->bookmarks = (_vala_array_free (self->priv->bookmarks, self->priv->bookmarks_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->sorting_options);
	_g_free0 (self->priv->old_term);
	_g_free0 (self->priv->search_source);
	(self->priv->search_nodes == NULL) ? NULL : (self->priv->search_nodes = (_g_queue_free__g_free0_ (self->priv->search_nodes), NULL));
	G_OBJECT_CLASS (registry_search_parent_class)->finalize (obj);
}

static GType
registry_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RegistrySearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) registry_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RegistrySearch), 0, (GInstanceInitFunc) registry_search_instance_init, NULL };
	GType registry_search_type_id;
	registry_search_type_id = g_type_register_static (TYPE_REGISTRY_LIST, "RegistrySearch", &g_define_type_info, 0);
	RegistrySearch_private_offset = g_type_add_instance_private (registry_search_type_id, sizeof (RegistrySearchPrivate));
	return registry_search_type_id;
}

GType
registry_search_get_type (void)
{
	static volatile gsize registry_search_type_id__once = 0;
	if (g_once_init_enter (&registry_search_type_id__once)) {
		GType registry_search_type_id;
		registry_search_type_id = registry_search_get_type_once ();
		g_once_init_leave (&registry_search_type_id__once, registry_search_type_id);
	}
	return registry_search_type_id__once;
}

static void
_vala_registry_search_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	RegistrySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REGISTRY_SEARCH, RegistrySearch);
	switch (property_id) {
		case REGISTRY_SEARCH_PLACEHOLDER_LABEL_PROPERTY:
		g_value_set_string (value, registry_list_get_placeholder_label ((RegistryList*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

