/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class GuardedPattern
extends Pattern {
    public Pattern primaryPattern;
    public Expression condition;
    BranchLabel thenTarget;

    public GuardedPattern(Pattern pattern, Expression expression) {
        this.primaryPattern = pattern;
        this.condition = expression;
        this.sourceStart = pattern.sourceStart;
        this.sourceEnd = expression.sourceEnd;
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        this.primaryPattern.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
        this.addPatternVariablesWhenTrue(this.primaryPattern.getPatternVariablesWhenTrue());
        this.condition.collectPatternVariablesToScope(this.getPatternVariablesWhenTrue(), blockScope);
        this.addPatternVariablesWhenTrue(this.condition.getPatternVariablesWhenTrue());
    }

    @Override
    public LocalDeclaration getPatternVariableIntroduced() {
        return this.primaryPattern.getPatternVariableIntroduced();
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.primaryPattern.analyseCode(blockScope, flowContext, flowInfo);
        return this.condition.analyseCode(blockScope, flowContext, flowInfo);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        this.primaryPattern.generateCode(blockScope, codeStream);
        Constant constant = this.condition.optimizedBooleanConstant();
        this.thenTarget = new BranchLabel(codeStream);
        this.condition.generateOptimizedBoolean(blockScope, codeStream, this.thenTarget, null, constant == Constant.NotAConstant);
    }

    @Override
    public boolean isTotalForType(TypeBinding typeBinding) {
        Constant constant = this.condition.optimizedBooleanConstant();
        return this.primaryPattern.isTotalForType(typeBinding) && constant != Constant.NotAConstant && constant.booleanValue();
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.resolveType(blockScope);
    }

    @Override
    public boolean dominates(Pattern pattern) {
        return false;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.resolvedType != null || this.primaryPattern == null) {
            return this.resolvedType;
        }
        this.resolvedType = this.primaryPattern.resolveType(blockScope);
        this.condition.resolveType(blockScope);
        this.condition.traverse(new ASTVisitor(){

            @Override
            public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
                LocalVariableBinding localVariableBinding = singleNameReference.localVariableBinding();
                if (localVariableBinding != null) {
                    singleNameReference.bits |= 0x40;
                }
                return false;
            }
        }, blockScope);
        this.resolvedType = this.primaryPattern.resolvedType;
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveAtType(BlockScope blockScope, TypeBinding typeBinding) {
        if (this.resolvedType == null || this.primaryPattern == null) {
            return null;
        }
        if (this.primaryPattern.isTotalForType(typeBinding)) {
            return this.primaryPattern.resolveAtType(blockScope, typeBinding);
        }
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        this.primaryPattern.print(n, stringBuffer).append(" && ");
        return this.condition.print(n, stringBuffer);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.primaryPattern != null) {
                this.primaryPattern.traverse(aSTVisitor, blockScope);
            }
            if (this.condition != null) {
                this.condition.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

