/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QPERSIANCALENDAR_DATA_P_H
#define QPERSIANCALENDAR_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>
#include <QtCore/private/qcalendarbackend_p.h>

QT_BEGIN_NAMESPACE

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2021-04-26 from the
    Common Locale Data Repository v39

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

static const QCalendarLocale locale_data[] = {
   //  lang   script terr   sShort  sLong   sNarrow short   long    narrow
      {     1,     0,     0,{ 0,48 },{ 48,84 },{ 132,24 },{ 0,48 },{ 48,84 },{ 156,29 }}, // C/AnyScript/AnyCountry
      {     3,     7,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Oromo/Latin/Ethiopia
      {     3,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Oromo/Latin/Kenya
      {     4,     7,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Afar/Latin/Ethiopia
      {     5,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Afrikaans/Latin/South Africa
      {     5,     7,   148,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Afrikaans/Latin/Namibia
      {     6,     7,     2,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Albanian/Latin/Albania
      {     6,     7,   127,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Albanian/Latin/Macedonia
      {     6,     7,   257,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Albanian/Latin/Kosovo
      {     7,    14,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Amharic/Ethiopic/Ethiopia
      {     8,     1,    64,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Egypt
      {     8,     1,     3,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Algeria
      {     8,     1,    17,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Bahrain
      {     8,     1,    42,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Chad
      {     8,     1,    48,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Comoros
      {     8,     1,    59,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Djibouti
      {     8,     1,    67,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Eritrea
      {     8,     1,   103,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Iraq
      {     8,     1,   105,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Israel
      {     8,     1,   109,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Jordan
      {     8,     1,   115,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Kuwait
      {     8,     1,   119,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Lebanon
      {     8,     1,   122,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Libya
      {     8,     1,   136,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Mauritania
      {     8,     1,   145,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Morocco
      {     8,     1,   162,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Oman
      {     8,     1,   165,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Palestinian Territories
      {     8,     1,   175,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Qatar
      {     8,     1,   186,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Saudi Arabia
      {     8,     1,   194,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Somalia
      {     8,     1,   201,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Sudan
      {     8,     1,   207,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Syria
      {     8,     1,   216,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Tunisia
      {     8,     1,   223,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/United Arab Emirates
      {     8,     1,   236,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Western Sahara
      {     8,     1,   237,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/Yemen
      {     8,     1,   254,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/South Sudan
      {     8,     1,   260,{ 212,68 },{ 212,68 },{ 185,27 },{ 212,68 },{ 212,68 },{ 185,27 }}, // Arabic/Arabic/World
      {     9,    10,    11,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Armenian/Armenian/Armenia
      {    10,    11,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Assamese/Bengali/India
      {    12,     7,    15,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Azerbaijani/Latin/Azerbaijan
      {    12,     1,   102,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Azerbaijani/Arabic/Iran
      {    12,     2,    15,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Azerbaijani/Cyrillic/Azerbaijan
      {    13,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bashkir/Cyrillic/Russia
      {    14,     7,   197,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Basque/Latin/Spain
      {    15,    11,    18,{ 280,88 },{ 368,89 },{ 457,27 },{ 280,88 },{ 368,89 },{ 457,27 }}, // Bengali/Bengali/Bangladesh
      {    15,    11,   100,{ 280,88 },{ 368,89 },{ 457,27 },{ 280,88 },{ 368,89 },{ 457,27 }}, // Bengali/Bengali/India
      {    16,    31,    25,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dzongkha/Tibetan/Bhutan
      {    19,     7,    74,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Breton/Latin/France
      {    20,     2,    33,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bulgarian/Cyrillic/Bulgaria
      {    21,    25,   147,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Burmese/Myanmar/Myanmar
      {    22,     2,    20,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Belarusian/Cyrillic/Belarus
      {    23,    20,    36,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Khmer/Khmer/Cambodia
      {    24,     7,   197,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Catalan/Latin/Spain
      {    24,     7,     5,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Catalan/Latin/Andorra
      {    24,     7,    74,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Catalan/Latin/France
      {    24,     7,   106,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Catalan/Latin/Italy
      {    25,     5,    44,{ 484,39 },{ 523,38 },{ 185,27 },{ 484,39 },{ 523,38 },{ 185,27 }}, // Chinese/Simplified Han/China
      {    25,     5,    97,{ 484,39 },{ 523,38 },{ 185,27 },{ 484,39 },{ 523,38 },{ 185,27 }}, // Chinese/Simplified Han/Hong Kong
      {    25,     5,   126,{ 484,39 },{ 523,38 },{ 185,27 },{ 484,39 },{ 523,38 },{ 185,27 }}, // Chinese/Simplified Han/Macau
      {    25,     5,   190,{ 484,39 },{ 523,38 },{ 185,27 },{ 484,39 },{ 523,38 },{ 185,27 }}, // Chinese/Simplified Han/Singapore
      {    25,     6,    97,{ 484,39 },{ 484,39 },{ 185,27 },{ 484,39 },{ 484,39 },{ 185,27 }}, // Chinese/Traditional Han/Hong Kong
      {    25,     6,   126,{ 484,39 },{ 484,39 },{ 185,27 },{ 484,39 },{ 484,39 },{ 185,27 }}, // Chinese/Traditional Han/Macau
      {    25,     6,   208,{ 484,39 },{ 484,39 },{ 185,27 },{ 484,39 },{ 484,39 },{ 185,27 }}, // Chinese/Traditional Han/Taiwan
      {    26,     7,    74,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Corsican/Latin/France
      {    27,     7,    54,{ 48,84 },{ 48,84 },{ 561,39 },{ 48,84 },{ 48,84 },{ 561,39 }}, // Croatian/Latin/Croatia
      {    27,     7,    27,{ 48,84 },{ 48,84 },{ 561,39 },{ 48,84 },{ 48,84 },{ 561,39 }}, // Croatian/Latin/Bosnia And Herzegowina
      {    28,     7,    57,{ 600,82 },{ 600,82 },{ 185,27 },{ 600,82 },{ 600,82 },{ 185,27 }}, // Czech/Latin/Czech Republic
      {    29,     7,    58,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Danish/Latin/Denmark
      {    29,     7,    86,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Danish/Latin/Greenland
      {    30,     7,   151,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Netherlands
      {    30,     7,    12,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Aruba
      {    30,     7,    21,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Belgium
      {    30,     7,   152,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Cura Sao
      {    30,     7,   202,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Suriname
      {    30,     7,   255,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Bonaire
      {    30,     7,   256,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dutch/Latin/Sint Maarten
      {    31,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/United States
      {    31,     3,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Deseret/United States
      {    31,     7,     4,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/American Samoa
      {    31,     7,     7,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Anguilla
      {    31,     7,     9,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Antigua And Barbuda
      {    31,     7,    13,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Australia
      {    31,     7,    14,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Austria
      {    31,     7,    16,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Bahamas
      {    31,     7,    19,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Barbados
      {    31,     7,    21,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Belgium
      {    31,     7,    22,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Belize
      {    31,     7,    24,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Bermuda
      {    31,     7,    28,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Botswana
      {    31,     7,    31,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/British Indian Ocean Territory
      {    31,     7,    35,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Burundi
      {    31,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Cameroon
      {    31,     7,    38,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Canada
      {    31,     7,    40,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Cayman Islands
      {    31,     7,    45,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Christmas Island
      {    31,     7,    46,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Cocos Islands
      {    31,     7,    51,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Cook Islands
      {    31,     7,    56,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Cyprus
      {    31,     7,    58,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Denmark
      {    31,     7,    60,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Dominica
      {    31,     7,    67,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Eritrea
      {    31,     7,    70,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Falkland Islands
      {    31,     7,    72,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Fiji
      {    31,     7,    73,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Finland
      {    31,     7,    75,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Guernsey
      {    31,     7,    80,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Gambia
      {    31,     7,    82,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Germany
      {    31,     7,    83,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Ghana
      {    31,     7,    84,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Gibraltar
      {    31,     7,    87,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Grenada
      {    31,     7,    89,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Guam
      {    31,     7,    93,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Guyana
      {    31,     7,    97,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Hong Kong
      {    31,     7,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/India
      {    31,     7,   104,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Ireland
      {    31,     7,   105,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Israel
      {    31,     7,   107,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Jamaica
      {    31,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Kenya
      {    31,     7,   112,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Kiribati
      {    31,     7,   120,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Lesotho
      {    31,     7,   121,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Liberia
      {    31,     7,   126,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Macau
      {    31,     7,   128,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Madagascar
      {    31,     7,   129,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Malawi
      {    31,     7,   130,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Malaysia
      {    31,     7,   133,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Malta
      {    31,     7,   134,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Marshall Islands
      {    31,     7,   137,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Mauritius
      {    31,     7,   140,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Micronesia
      {    31,     7,   144,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Montserrat
      {    31,     7,   148,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Namibia
      {    31,     7,   149,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Nauru
      {    31,     7,   151,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Netherlands
      {    31,     7,   154,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/New Zealand
      {    31,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Nigeria
      {    31,     7,   158,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Niue
      {    31,     7,   159,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Norfolk Island
      {    31,     7,   160,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Northern Mariana Islands
      {    31,     7,   163,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Pakistan
      {    31,     7,   164,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Palau
      {    31,     7,   167,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Papua New Guinea
      {    31,     7,   170,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Philippines
      {    31,     7,   171,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Pitcairn
      {    31,     7,   174,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Puerto Rico
      {    31,     7,   179,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Rwanda
      {    31,     7,   180,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Saint Kitts And Nevis
      {    31,     7,   181,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Saint Lucia
      {    31,     7,   182,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Saint Vincent And The Grenadines
      {    31,     7,   183,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Samoa
      {    31,     7,   188,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Seychelles
      {    31,     7,   189,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Sierra Leone
      {    31,     7,   190,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Singapore
      {    31,     7,   192,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Slovenia
      {    31,     7,   193,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Solomon Islands
      {    31,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/South Africa
      {    31,     7,   199,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Saint Helena
      {    31,     7,   201,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Sudan
      {    31,     7,   204,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Swaziland
      {    31,     7,   205,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Sweden
      {    31,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Switzerland
      {    31,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Tanzania
      {    31,     7,   213,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Tokelau
      {    31,     7,   214,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Tonga
      {    31,     7,   215,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Trinidad And Tobago
      {    31,     7,   219,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Turks And Caicos Islands
      {    31,     7,   220,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Tuvalu
      {    31,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Uganda
      {    31,     7,   223,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/United Arab Emirates
      {    31,     7,   224,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/United Kingdom
      {    31,     7,   226,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/United States Minor Outlying Islands
      {    31,     7,   229,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Vanuatu
      {    31,     7,   233,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/British Virgin Islands
      {    31,     7,   234,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/United States Virgin Islands
      {    31,     7,   239,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Zambia
      {    31,     7,   240,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Zimbabwe
      {    31,     7,   249,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Diego Garcia
      {    31,     7,   251,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Isle Of Man
      {    31,     7,   252,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Jersey
      {    31,     7,   254,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/South Sudan
      {    31,     7,   256,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Sint Maarten
      {    31,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/World
      {    31,     7,   261,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // English/Latin/Europe
      {    32,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Esperanto/Latin/World
      {    33,     7,    68,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Estonian/Latin/Estonia
      {    34,     7,    71,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Faroese/Latin/Faroe Islands
      {    34,     7,    58,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Faroese/Latin/Denmark
      {    36,     7,    73,{ 766,82 },{ 848,118 },{ 185,27 },{ 966,142 },{ 966,142 },{ 185,27 }}, // Finnish/Latin/Finland
      {    37,     7,    74,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/France
      {    37,     7,     3,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Algeria
      {    37,     7,    21,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Belgium
      {    37,     7,    23,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Benin
      {    37,     7,    34,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Burkina Faso
      {    37,     7,    35,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Burundi
      {    37,     7,    37,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Cameroon
      {    37,     7,    38,{ 1248,58 },{ 1306,82 },{ 185,27 },{ 1248,58 },{ 1306,82 },{ 185,27 }}, // French/Latin/Canada
      {    37,     7,    41,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Central African Republic
      {    37,     7,    42,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Chad
      {    37,     7,    48,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Comoros
      {    37,     7,    49,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Congo Kinshasa
      {    37,     7,    50,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Congo Brazzaville
      {    37,     7,    53,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Ivory Coast
      {    37,     7,    59,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Djibouti
      {    37,     7,    66,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Equatorial Guinea
      {    37,     7,    76,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/French Guiana
      {    37,     7,    77,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/French Polynesia
      {    37,     7,    79,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Gabon
      {    37,     7,    88,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Guadeloupe
      {    37,     7,    91,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Guinea
      {    37,     7,    94,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Haiti
      {    37,     7,   125,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Luxembourg
      {    37,     7,   128,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Madagascar
      {    37,     7,   132,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Mali
      {    37,     7,   135,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Martinique
      {    37,     7,   136,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Mauritania
      {    37,     7,   137,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Mauritius
      {    37,     7,   138,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Mayotte
      {    37,     7,   142,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Monaco
      {    37,     7,   145,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Morocco
      {    37,     7,   153,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/New Caledonia
      {    37,     7,   156,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Niger
      {    37,     7,   176,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Reunion
      {    37,     7,   179,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Rwanda
      {    37,     7,   187,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Senegal
      {    37,     7,   188,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Seychelles
      {    37,     7,   200,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Saint Pierre And Miquelon
      {    37,     7,   206,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Switzerland
      {    37,     7,   207,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Syria
      {    37,     7,   212,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Togo
      {    37,     7,   216,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Tunisia
      {    37,     7,   229,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Vanuatu
      {    37,     7,   235,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Wallis And Futuna Islands
      {    37,     7,   244,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Saint Barthelemy
      {    37,     7,   245,{ 1108,58 },{ 1166,82 },{ 185,27 },{ 1108,58 },{ 1166,82 },{ 185,27 }}, // French/Latin/Saint Martin
      {    38,     7,   151,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Western Frisian/Latin/Netherlands
      {    39,     7,   224,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Gaelic/Latin/United Kingdom
      {    40,     7,   197,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Galician/Latin/Spain
      {    41,    15,    81,{ 1388,92 },{ 1388,92 },{ 185,27 },{ 1388,92 },{ 1388,92 },{ 185,27 }}, // Georgian/Georgian/Georgia
      {    42,     7,    82,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Germany
      {    42,     7,    14,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Austria
      {    42,     7,    21,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Belgium
      {    42,     7,   106,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Italy
      {    42,     7,   123,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Liechtenstein
      {    42,     7,   125,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Luxembourg
      {    42,     7,   206,{ 1480,87 },{ 1480,87 },{ 185,27 },{ 1480,87 },{ 1480,87 },{ 185,27 }}, // German/Latin/Switzerland
      {    43,    16,    85,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Greek/Greek/Greece
      {    43,    16,    56,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Greek/Greek/Cyprus
      {    44,     7,    86,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Greenlandic/Latin/Greenland
      {    45,     7,   168,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Guarani/Latin/Paraguay
      {    46,    17,   100,{ 1567,86 },{ 1567,86 },{ 185,27 },{ 1567,86 },{ 1567,86 },{ 185,27 }}, // Gujarati/Gujarati/India
      {    47,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hausa/Latin/Nigeria
      {    47,     1,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hausa/Arabic/Nigeria
      {    47,     7,    83,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hausa/Latin/Ghana
      {    47,     7,   156,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hausa/Latin/Niger
      {    48,    18,   105,{ 1653,69 },{ 1653,69 },{ 185,27 },{ 1653,69 },{ 1653,69 },{ 185,27 }}, // Hebrew/Hebrew/Israel
      {    49,    13,   100,{ 1722,82 },{ 1722,82 },{ 185,27 },{ 1722,82 },{ 1722,82 },{ 185,27 }}, // Hindi/Devanagari/India
      {    49,     7,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hindi/Latin/India
      {    50,     7,    98,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Hungarian/Latin/Hungary
      {    51,     7,    99,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Icelandic/Latin/Iceland
      {    52,     7,   101,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Indonesian/Latin/Indonesia
      {    53,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Interlingua/Latin/World
      {    55,    44,    38,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Inuktitut/Canadian Aboriginal/Canada
      {    55,     7,    38,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Inuktitut/Latin/Canada
      {    57,     7,   104,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Irish/Latin/Ireland
      {    57,     7,   224,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Irish/Latin/United Kingdom
      {    58,     7,   106,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Italian/Latin/Italy
      {    58,     7,   184,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Italian/Latin/San Marino
      {    58,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Italian/Latin/Switzerland
      {    58,     7,   230,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Italian/Latin/Vatican City State
      {    59,    19,   108,{ 1804,78 },{ 1804,78 },{ 185,27 },{ 1804,78 },{ 1804,78 },{ 185,27 }}, // Japanese/Japanese/Japan
      {    60,     7,   101,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Javanese/Latin/Indonesia
      {    61,    21,   100,{ 1882,93 },{ 1882,93 },{ 185,27 },{ 1882,93 },{ 1882,93 },{ 185,27 }}, // Kannada/Kannada/India
      {    62,     1,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kashmiri/Arabic/India
      {    62,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kashmiri/Devanagari/India
      {    63,     2,   110,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kazakh/Cyrillic/Kazakhstan
      {    64,     7,   179,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kinyarwanda/Latin/Rwanda
      {    65,     2,   116,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kirghiz/Cyrillic/Kyrgyzstan
      {    66,    22,   114,{ 1975,55 },{ 1975,55 },{ 185,27 },{ 1975,55 },{ 1975,55 },{ 185,27 }}, // Korean/Korean/South Korea
      {    66,    22,   113,{ 1975,55 },{ 1975,55 },{ 185,27 },{ 1975,55 },{ 1975,55 },{ 185,27 }}, // Korean/Korean/North Korea
      {    67,     7,   217,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kurdish/Latin/Turkey
      {    68,     7,    35,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Rundi/Latin/Burundi
      {    69,    23,   117,{ 2030,80 },{ 2110,81 },{ 185,27 },{ 2191,80 },{ 2110,81 },{ 185,27 }}, // Lao/Lao/Laos
      {    70,     7,   230,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Latin/Latin/Vatican City State
      {    71,     7,   118,{ 2271,93 },{ 2271,93 },{ 185,27 },{ 2271,93 },{ 2271,93 },{ 185,27 }}, // Latvian/Latin/Latvia
      {    72,     7,    49,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lingala/Latin/Congo Kinshasa
      {    72,     7,     6,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lingala/Latin/Angola
      {    72,     7,    41,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lingala/Latin/Central African Republic
      {    72,     7,    50,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lingala/Latin/Congo Brazzaville
      {    73,     7,   124,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lithuanian/Latin/Lithuania
      {    74,     2,   127,{ 2364,80 },{ 2364,80 },{ 185,27 },{ 2364,80 },{ 2364,80 },{ 185,27 }}, // Macedonian/Cyrillic/Macedonia
      {    75,     7,   128,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malagasy/Latin/Madagascar
      {    76,     7,   130,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malay/Latin/Malaysia
      {    76,     1,   130,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malay/Arabic/Malaysia
      {    76,     7,    32,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malay/Latin/Brunei
      {    76,     7,   101,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malay/Latin/Indonesia
      {    76,     7,   190,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Malay/Latin/Singapore
      {    77,    24,   100,{ 2444,92 },{ 2444,92 },{ 2536,40 },{ 2444,92 },{ 2444,92 },{ 2536,40 }}, // Malayalam/Malayalam/India
      {    78,     7,   133,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Maltese/Latin/Malta
      {    79,     7,   154,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Maori/Latin/New Zealand
      {    80,    13,   100,{ 2576,81 },{ 2576,81 },{ 2657,27 },{ 2576,81 },{ 2576,81 },{ 2657,27 }}, // Marathi/Devanagari/India
      {    82,     2,   143,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mongolian/Cyrillic/Mongolia
      {    82,     8,    44,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mongolian/Mongolian/China
      {    84,    13,   150,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nepali/Devanagari/Nepal
      {    84,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nepali/Devanagari/India
      {    85,     7,   161,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Norwegian Bokmal/Latin/Norway
      {    85,     7,   203,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Norwegian Bokmal/Latin/Svalbard And Jan Mayen Islands
      {    86,     7,    74,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Occitan/Latin/France
      {    87,    26,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Oriya/Oriya/India
      {    88,     1,     1,{ 2684,63 },{ 2684,63 },{ 2747,27 },{ 2684,63 },{ 2684,63 },{ 2747,27 }}, // Pashto/Arabic/Afghanistan
      {    88,     1,   163,{ 2684,63 },{ 2684,63 },{ 2747,27 },{ 2684,63 },{ 2684,63 },{ 2747,27 }}, // Pashto/Arabic/Pakistan
      {    89,     1,   102,{ 2774,67 },{ 2774,67 },{ 2841,24 },{ 2774,67 },{ 2774,67 },{ 2841,24 }}, // Persian/Arabic/Iran
      {    89,     1,     1,{ 2774,67 },{ 2774,67 },{ 2865,24 },{ 2774,67 },{ 2889,57 },{ 2841,24 }}, // Persian/Arabic/Afghanistan
      {    90,     7,   172,{ 2946,84 },{ 2946,84 },{ 185,27 },{ 2946,84 },{ 2946,84 },{ 185,27 }}, // Polish/Latin/Poland
      {    91,     7,    30,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Brazil
      {    91,     7,     6,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Angola
      {    91,     7,    39,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Cape Verde
      {    91,     7,    62,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/East Timor
      {    91,     7,    66,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Equatorial Guinea
      {    91,     7,    92,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Guinea Bissau
      {    91,     7,   125,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Luxembourg
      {    91,     7,   126,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Macau
      {    91,     7,   146,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Mozambique
      {    91,     7,   173,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Portugal
      {    91,     7,   185,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Sao Tome And Principe
      {    91,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Portuguese/Latin/Switzerland
      {    92,     4,   100,{ 3030,78 },{ 3030,78 },{ 185,27 },{ 3030,78 },{ 3030,78 },{ 185,27 }}, // Punjabi/Gurmukhi/India
      {    92,     1,   163,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Punjabi/Arabic/Pakistan
      {    93,     7,   169,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Quechua/Latin/Peru
      {    93,     7,    26,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Quechua/Latin/Bolivia
      {    93,     7,    63,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Quechua/Latin/Ecuador
      {    94,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Romansh/Latin/Switzerland
      {    95,     7,   177,{ 3108,86 },{ 3108,86 },{ 185,27 },{ 3108,86 },{ 3108,86 },{ 185,27 }}, // Romanian/Latin/Romania
      {    95,     7,   141,{ 3108,86 },{ 3108,86 },{ 185,27 },{ 3108,86 },{ 3108,86 },{ 185,27 }}, // Romanian/Latin/Moldova
      {    96,     2,   178,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Russia
      {    96,     2,    20,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Belarus
      {    96,     2,   110,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Kazakhstan
      {    96,     2,   116,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Kyrgyzstan
      {    96,     2,   141,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Moldova
      {    96,     2,   222,{ 3194,81 },{ 3194,81 },{ 185,27 },{ 3194,81 },{ 3194,81 },{ 185,27 }}, // Russian/Cyrillic/Ukraine
      {    98,     7,    41,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sango/Latin/Central African Republic
      {    99,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sanskrit/Devanagari/India
      {   100,     2,   243,{ 3275,81 },{ 3275,81 },{ 185,27 },{ 3275,81 },{ 3275,81 },{ 185,27 }}, // Serbian/Cyrillic/Serbia
      {   100,     7,    27,{ 3356,81 },{ 3356,81 },{ 185,27 },{ 3356,81 },{ 3356,81 },{ 185,27 }}, // Serbian/Latin/Bosnia And Herzegowina
      {   100,     7,   242,{ 3356,81 },{ 3356,81 },{ 185,27 },{ 3356,81 },{ 3356,81 },{ 185,27 }}, // Serbian/Latin/Montenegro
      {   100,     7,   243,{ 3356,81 },{ 3356,81 },{ 185,27 },{ 3356,81 },{ 3356,81 },{ 185,27 }}, // Serbian/Latin/Serbia
      {   100,     2,    27,{ 3275,81 },{ 3275,81 },{ 185,27 },{ 3275,81 },{ 3275,81 },{ 185,27 }}, // Serbian/Cyrillic/Bosnia And Herzegowina
      {   100,     2,   242,{ 3275,81 },{ 3275,81 },{ 185,27 },{ 3275,81 },{ 3275,81 },{ 185,27 }}, // Serbian/Cyrillic/Montenegro
      {   100,     2,   257,{ 3275,81 },{ 3275,81 },{ 185,27 },{ 3275,81 },{ 3275,81 },{ 185,27 }}, // Serbian/Cyrillic/Kosovo
      {   100,     7,   257,{ 3356,81 },{ 3356,81 },{ 185,27 },{ 3356,81 },{ 3356,81 },{ 185,27 }}, // Serbian/Latin/Kosovo
      {   101,     2,    81,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ossetic/Cyrillic/Georgia
      {   101,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ossetic/Cyrillic/Russia
      {   102,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Southern Sotho/Latin/South Africa
      {   103,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tswana/Latin/South Africa
      {   104,     7,   240,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Shona/Latin/Zimbabwe
      {   105,     1,   163,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sindhi/Arabic/Pakistan
      {   105,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sindhi/Devanagari/India
      {   106,    32,   198,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sinhala/Sinhala/Sri Lanka
      {   107,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swati/Latin/South Africa
      {   108,     7,   191,{ 600,82 },{ 600,82 },{ 185,27 },{ 600,82 },{ 600,82 },{ 185,27 }}, // Slovak/Latin/Slovakia
      {   109,     7,   192,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Slovenian/Latin/Slovenia
      {   110,     7,   194,{ 3437,100 },{ 3437,100 },{ 185,27 },{ 3437,100 },{ 3437,100 },{ 185,27 }}, // Somali/Latin/Somalia
      {   110,     7,    59,{ 3437,100 },{ 3437,100 },{ 185,27 },{ 3437,100 },{ 3437,100 },{ 185,27 }}, // Somali/Latin/Djibouti
      {   110,     7,    69,{ 3437,100 },{ 3437,100 },{ 185,27 },{ 3437,100 },{ 3437,100 },{ 185,27 }}, // Somali/Latin/Ethiopia
      {   110,     7,   111,{ 3437,100 },{ 3437,100 },{ 185,27 },{ 3437,100 },{ 3437,100 },{ 185,27 }}, // Somali/Latin/Kenya
      {   111,     7,   197,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Spain
      {   111,     7,    10,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Argentina
      {   111,     7,    22,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Belize
      {   111,     7,    26,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Bolivia
      {   111,     7,    30,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Brazil
      {   111,     7,    43,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Chile
      {   111,     7,    47,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Colombia
      {   111,     7,    52,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Costa Rica
      {   111,     7,    55,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Cuba
      {   111,     7,    61,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Dominican Republic
      {   111,     7,    63,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Ecuador
      {   111,     7,    65,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/El Salvador
      {   111,     7,    66,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Equatorial Guinea
      {   111,     7,    90,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Guatemala
      {   111,     7,    96,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Honduras
      {   111,     7,   139,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Mexico
      {   111,     7,   155,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Nicaragua
      {   111,     7,   166,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Panama
      {   111,     7,   168,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Paraguay
      {   111,     7,   169,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Peru
      {   111,     7,   170,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Philippines
      {   111,     7,   174,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Puerto Rico
      {   111,     7,   225,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/United States
      {   111,     7,   227,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Uruguay
      {   111,     7,   231,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Venezuela
      {   111,     7,   238,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Canary Islands
      {   111,     7,   246,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Latin America
      {   111,     7,   250,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Spanish/Latin/Ceuta And Melilla
      {   112,     7,   101,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sundanese/Latin/Indonesia
      {   113,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swahili/Latin/Tanzania
      {   113,     7,    49,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swahili/Latin/Congo Kinshasa
      {   113,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swahili/Latin/Kenya
      {   113,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swahili/Latin/Uganda
      {   114,     7,   205,{ 3537,84 },{ 3537,84 },{ 185,27 },{ 3621,84 },{ 3621,84 },{ 185,27 }}, // Swedish/Latin/Sweden
      {   114,     7,    73,{ 3537,84 },{ 3537,84 },{ 185,27 },{ 3621,84 },{ 3621,84 },{ 185,27 }}, // Swedish/Latin/Finland
      {   114,     7,   248,{ 3537,84 },{ 3537,84 },{ 185,27 },{ 3621,84 },{ 3621,84 },{ 185,27 }}, // Swedish/Latin/Aland Islands
      {   115,     7,   106,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sardinian/Latin/Italy
      {   116,     2,   209,{ 3705,81 },{ 3705,81 },{ 185,27 },{ 3705,81 },{ 3705,81 },{ 185,27 }}, // Tajik/Cyrillic/Tajikistan
      {   117,    27,   100,{ 3786,64 },{ 3850,94 },{ 185,27 },{ 3786,64 },{ 3850,94 },{ 185,27 }}, // Tamil/Tamil/India
      {   117,    27,   130,{ 3786,64 },{ 3850,94 },{ 185,27 },{ 3786,64 },{ 3850,94 },{ 185,27 }}, // Tamil/Tamil/Malaysia
      {   117,    27,   190,{ 3786,64 },{ 3850,94 },{ 185,27 },{ 3786,64 },{ 3850,94 },{ 185,27 }}, // Tamil/Tamil/Singapore
      {   117,    27,   198,{ 3786,64 },{ 3850,94 },{ 185,27 },{ 3786,64 },{ 3850,94 },{ 185,27 }}, // Tamil/Tamil/Sri Lanka
      {   118,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tatar/Cyrillic/Russia
      {   119,    28,   100,{ 3944,89 },{ 3944,89 },{ 185,27 },{ 3944,89 },{ 3944,89 },{ 185,27 }}, // Telugu/Telugu/India
      {   120,    30,   211,{ 4033,99 },{ 4033,99 },{ 185,27 },{ 4033,99 },{ 4033,99 },{ 185,27 }}, // Thai/Thai/Thailand
      {   121,    31,    44,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tibetan/Tibetan/China
      {   121,    31,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tibetan/Tibetan/India
      {   122,    14,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tigrinya/Ethiopic/Ethiopia
      {   122,    14,    67,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tigrinya/Ethiopic/Eritrea
      {   123,     7,   214,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tongan/Latin/Tonga
      {   124,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tsonga/Latin/South Africa
      {   125,     7,   217,{ 4132,81 },{ 4132,81 },{ 185,27 },{ 4132,81 },{ 4132,81 },{ 185,27 }}, // Turkish/Latin/Turkey
      {   125,     7,    56,{ 4132,81 },{ 4132,81 },{ 185,27 },{ 4132,81 },{ 4132,81 },{ 185,27 }}, // Turkish/Latin/Cyprus
      {   126,     7,   218,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Turkmen/Latin/Turkmenistan
      {   128,     1,    44,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Uighur/Arabic/China
      {   129,     2,   222,{ 4213,50 },{ 4263,81 },{ 185,27 },{ 4344,58 },{ 4263,81 },{ 185,27 }}, // Ukrainian/Cyrillic/Ukraine
      {   130,     1,   163,{ 4402,67 },{ 4402,67 },{ 185,27 },{ 4402,67 },{ 4402,67 },{ 185,27 }}, // Urdu/Arabic/Pakistan
      {   130,     1,   100,{ 4402,67 },{ 4402,67 },{ 185,27 },{ 4402,67 },{ 4402,67 },{ 185,27 }}, // Urdu/Arabic/India
      {   131,     7,   228,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Uzbek/Latin/Uzbekistan
      {   131,     1,     1,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Uzbek/Arabic/Afghanistan
      {   131,     2,   228,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Uzbek/Cyrillic/Uzbekistan
      {   132,     7,   232,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Vietnamese/Latin/Vietnam
      {   133,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Volapuk/Latin/World
      {   134,     7,   224,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Welsh/Latin/United Kingdom
      {   135,     7,   187,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Wolof/Latin/Senegal
      {   136,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Xhosa/Latin/South Africa
      {   137,    18,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Yiddish/Hebrew/World
      {   138,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Yoruba/Latin/Nigeria
      {   138,     7,    23,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Yoruba/Latin/Benin
      {   140,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Zulu/Latin/South Africa
      {   141,     7,   161,{ 682,84 },{ 682,84 },{ 185,27 },{ 682,84 },{ 682,84 },{ 185,27 }}, // Norwegian Nynorsk/Latin/Norway
      {   142,     7,    27,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bosnian/Latin/Bosnia And Herzegowina
      {   142,     2,    27,{ 3275,81 },{ 3275,81 },{ 185,27 },{ 3275,81 },{ 3275,81 },{ 185,27 }}, // Bosnian/Cyrillic/Bosnia And Herzegowina
      {   143,    29,   131,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Divehi/Thaana/Maldives
      {   144,     7,   251,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Manx/Latin/Isle Of Man
      {   145,     7,   224,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Cornish/Latin/United Kingdom
      {   146,     7,    83,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Akan/Latin/Ghana
      {   147,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Konkani/Devanagari/India
      {   148,     7,    83,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ga/Latin/Ghana
      {   149,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Igbo/Latin/Nigeria
      {   150,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kamba/Latin/Kenya
      {   151,    33,   103,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Syriac/Syriac/Iraq
      {   152,    14,    67,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Blin/Ethiopic/Eritrea
      {   153,    14,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Geez/Ethiopic/Ethiopia
      {   155,     7,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sidamo/Latin/Ethiopia
      {   156,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Atsam/Latin/Nigeria
      {   157,    14,    67,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tigre/Ethiopic/Eritrea
      {   158,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Jju/Latin/Nigeria
      {   159,     7,   106,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Friulian/Latin/Italy
      {   160,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Venda/Latin/South Africa
      {   161,     7,    83,{ 4469,48 },{ 4517,87 },{ 185,27 },{ 4469,48 },{ 4517,87 },{ 185,27 }}, // Ewe/Latin/Ghana
      {   161,     7,   212,{ 4469,48 },{ 4517,87 },{ 185,27 },{ 4469,48 },{ 4517,87 },{ 185,27 }}, // Ewe/Latin/Togo
      {   162,    14,    69,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Walamo/Ethiopic/Ethiopia
      {   163,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Hawaiian/Latin/United States
      {   164,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tyap/Latin/Nigeria
      {   165,     7,   129,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nyanja/Latin/Malawi
      {   166,     7,   170,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Filipino/Latin/Philippines
      {   167,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swiss German/Latin/Switzerland
      {   167,     7,    74,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swiss German/Latin/France
      {   167,     7,   123,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Swiss German/Latin/Liechtenstein
      {   168,    34,    44,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sichuan Yi/Yi/China
      {   169,     7,   121,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kpelle/Latin/Liberia
      {   170,     7,    82,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Low German/Latin/Germany
      {   170,     7,   151,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Low German/Latin/Netherlands
      {   171,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // South Ndebele/Latin/South Africa
      {   172,     7,   195,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Sotho/Latin/South Africa
      {   173,     7,   161,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Sami/Latin/Norway
      {   173,     7,    73,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Sami/Latin/Finland
      {   173,     7,   205,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Sami/Latin/Sweden
      {   174,     7,   208,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Taroko/Latin/Taiwan
      {   175,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Gusii/Latin/Kenya
      {   176,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Taita/Latin/Kenya
      {   177,     7,   187,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Senegal
      {   177,     7,    34,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Burkina Faso
      {   177,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Cameroon
      {   177,     7,    80,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Gambia
      {   177,     7,    83,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Ghana
      {   177,     7,    91,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Guinea
      {   177,     7,    92,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Guinea Bissau
      {   177,     7,   121,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Liberia
      {   177,     7,   136,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Mauritania
      {   177,     7,   156,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Niger
      {   177,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Nigeria
      {   177,     7,   189,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Fulah/Latin/Sierra Leone
      {   178,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kikuyu/Latin/Kenya
      {   179,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Samburu/Latin/Kenya
      {   180,     7,   146,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sena/Latin/Mozambique
      {   181,     7,   240,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // North Ndebele/Latin/Zimbabwe
      {   182,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Rombo/Latin/Tanzania
      {   183,     9,   145,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tachelhit/Tifinagh/Morocco
      {   183,     7,   145,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tachelhit/Latin/Morocco
      {   184,     7,     3,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kabyle/Latin/Algeria
      {   185,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nyankole/Latin/Uganda
      {   186,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bena/Latin/Tanzania
      {   187,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Vunjo/Latin/Tanzania
      {   188,     7,   132,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bambara/Latin/Mali
      {   188,    75,   132,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bambara/Nko/Mali
      {   189,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Embu/Latin/Kenya
      {   190,    12,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Cherokee/Cherokee/United States
      {   191,     7,   137,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Morisyen/Latin/Mauritius
      {   192,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Makonde/Latin/Tanzania
      {   193,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Langi/Latin/Tanzania
      {   194,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ganda/Latin/Uganda
      {   195,     7,   239,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bemba/Latin/Zambia
      {   196,     7,    39,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kabuverdianu/Latin/Cape Verde
      {   197,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Meru/Latin/Kenya
      {   198,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kalenjin/Latin/Kenya
      {   199,     7,   148,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nama/Latin/Namibia
      {   200,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Machame/Latin/Tanzania
      {   201,     7,    82,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Colognian/Latin/Germany
      {   202,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Masai/Latin/Kenya
      {   202,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Masai/Latin/Tanzania
      {   203,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Soga/Latin/Uganda
      {   204,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Luyia/Latin/Kenya
      {   205,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Asu/Latin/Tanzania
      {   206,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Teso/Latin/Uganda
      {   206,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Teso/Latin/Kenya
      {   207,     7,    67,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Saho/Latin/Eritrea
      {   208,     7,   132,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Koyra Chiini/Latin/Mali
      {   209,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Rwa/Latin/Tanzania
      {   210,     7,   111,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Luo/Latin/Kenya
      {   211,     7,   221,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Chiga/Latin/Uganda
      {   212,     7,   145,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Central Morocco Tamazight/Latin/Morocco
      {   213,     7,   132,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Koyraboro Senni/Latin/Mali
      {   214,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Shambala/Latin/Tanzania
      {   215,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bodo/Devanagari/India
      {   218,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Chechen/Cyrillic/Russia
      {   219,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Church/Cyrillic/Russia
      {   220,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Chuvash/Cyrillic/Russia
      {   230,     7,    49,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Luba Katanga/Latin/Congo Kinshasa
      {   231,     7,   125,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Luxembourgish/Latin/Luxembourg
      {   232,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Navaho/Latin/United States
      {   236,     7,    21,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Walloon/Latin/Belgium
      {   237,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Aghem/Latin/Cameroon
      {   238,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Basaa/Latin/Cameroon
      {   239,     7,   156,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Zarma/Latin/Niger
      {   240,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Duala/Latin/Cameroon
      {   241,     7,   187,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Jola Fonyi/Latin/Senegal
      {   242,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ewondo/Latin/Cameroon
      {   243,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Bafia/Latin/Cameroon
      {   244,     7,   146,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Makhuwa Meetto/Latin/Mozambique
      {   245,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mundang/Latin/Cameroon
      {   246,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kwasio/Latin/Cameroon
      {   247,     7,   254,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nuer/Latin/South Sudan
      {   248,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sakha/Cyrillic/Russia
      {   249,     7,   210,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sangu/Latin/Tanzania
      {   251,     7,   156,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tasawaq/Latin/Niger
      {   252,    35,   121,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Vai/Vai/Liberia
      {   252,     7,   121,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Vai/Latin/Liberia
      {   253,     7,   206,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Walser/Latin/Switzerland
      {   254,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Yangben/Latin/Cameroon
      {   256,     7,   197,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Asturian/Latin/Spain
      {   257,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ngomba/Latin/Cameroon
      {   258,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kako/Latin/Cameroon
      {   259,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Meta/Latin/Cameroon
      {   260,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ngiemboon/Latin/Cameroon
      {   261,     7,   197,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Aragonese/Latin/Spain
      {   275,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Dogri/Devanagari/India
      {   290,    11,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Manipuri/Bengali/India
      {   290,    72,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Manipuri/Meitei Mayek/India
      {   304,    78,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Santali/Ol Chiki/India
      {   304,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Santali/Devanagari/India
      {   309,   100,   232,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Tai Dam/Tai Viet/Vietnam
      {   312,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Akoose/Latin/Cameroon
      {   313,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lakota/Latin/United States
      {   314,     9,   145,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Standard Moroccan Tamazight/Tifinagh/Morocco
      {   315,     7,    43,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mapuche/Latin/Chile
      {   316,     1,   103,{ 4604,102 },{ 4604,102 },{ 185,27 },{ 4604,102 },{ 4604,102 },{ 185,27 }}, // Central Kurdish/Arabic/Iraq
      {   316,     1,   102,{ 4604,102 },{ 4604,102 },{ 185,27 },{ 4604,102 },{ 4604,102 },{ 185,27 }}, // Central Kurdish/Arabic/Iran
      {   317,     7,    82,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lower Sorbian/Latin/Germany
      {   318,     7,    82,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Upper Sorbian/Latin/Germany
      {   319,     7,    37,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kenyang/Latin/Cameroon
      {   320,     7,    38,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mohawk/Latin/Canada
      {   321,    75,    91,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nko/Nko/Guinea
      {   322,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Prussian/Latin/World
      {   323,     7,    90,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Kiche/Latin/Guatemala
      {   324,     7,   205,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Southern Sami/Latin/Sweden
      {   325,     7,   205,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lule Sami/Latin/Sweden
      {   326,     7,    73,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Inari Sami/Latin/Finland
      {   327,     7,    73,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Skolt Sami/Latin/Finland
      {   328,     7,    13,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Warlpiri/Latin/Australia
      {   339,    13,   100,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Maithili/Devanagari/India
      {   346,     1,   102,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Mazanderani/Arabic/Iran
      {   349,     1,   102,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Luri/Arabic/Iran
      {   349,     1,   103,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Northern Luri/Arabic/Iraq
      {   357,     6,    97,{ 484,39 },{ 484,39 },{ 185,27 },{ 484,39 },{ 484,39 },{ 185,27 }}, // Cantonese/Traditional Han/Hong Kong
      {   357,     5,    44,{ 484,39 },{ 484,39 },{ 185,27 },{ 484,39 },{ 484,39 },{ 185,27 }}, // Cantonese/Simplified Han/China
      {   358,   138,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Osage/Osage/United States
      {   360,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Ido/Latin/World
      {   361,     7,   260,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Lojban/Latin/World
      {   362,     7,   106,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Sicilian/Latin/Italy
      {   363,     1,   102,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Southern Kurdish/Arabic/Iran
      {   364,     1,   163,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Western Balochi/Arabic/Pakistan
      {   365,     7,   170,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Cebuano/Latin/Philippines
      {   366,     2,   178,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Erzya/Cyrillic/Russia
      {   367,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Chickasaw/Latin/United States
      {   368,     7,   225,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Muscogee/Latin/United States
      {   369,     7,   172,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Silesian/Latin/Poland
      {   370,     7,   157,{ 48,84 },{ 48,84 },{ 185,27 },{ 48,84 },{ 48,84 },{ 185,27 }}, // Nigerian Pidgin/Latin/Nigeria
      {     0,     0,     0,{  0,0},{  0,0},{  0,0},{  0,0},{  0,0},{  0,0}}, // trailing zeros
};

static const ushort months_data[] = {
0x46, 0x61, 0x72, 0x3b, 0x4f, 0x72, 0x64, 0x3b, 0x4b, 0x68, 0x6f, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x3b,
0x53, 0x68, 0x61, 0x3b, 0x4d, 0x65, 0x68, 0x3b, 0x41, 0x62, 0x61, 0x3b, 0x41, 0x7a, 0x61, 0x3b, 0x44, 0x65, 0x79, 0x3b,
0x42, 0x61, 0x68, 0x3b, 0x45, 0x73, 0x66, 0x3b, 0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72,
0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x54, 0x69,
0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x4d,
0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x61,
0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x46, 0x3b, 0x4f, 0x3b, 0x4b, 0x3b, 0x54, 0x3b,
0x4d, 0x3b, 0x53, 0x3b, 0x4d, 0x3b, 0x41, 0x3b, 0x41, 0x3b, 0x44, 0x3b, 0x42, 0x3b, 0x45, 0x3b, 0x31, 0x3b, 0x32, 0x3b,
0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b,
0x31, 0x32, 0x3b, 0x31, 0x33, 0x31, 0x3b, 0x32, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38,
0x3b, 0x39, 0x3b, 0x31, 0x30, 0x3b, 0x31, 0x31, 0x3b, 0x31, 0x32, 0x3b, 0x641, 0x631, 0x641, 0x631, 0x62f, 0x646, 0x3b, 0x623,
0x630, 0x631, 0x628, 0x64a, 0x647, 0x634, 0x62a, 0x3b, 0x62e, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x62a, 0x627, 0x631, 0x3b, 0x645, 0x631,
0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x647, 0x631, 0x641, 0x627, 0x631, 0x3b, 0x645, 0x647, 0x631, 0x3b, 0x622, 0x64a, 0x627, 0x646, 0x3b,
0x622, 0x630, 0x631, 0x3b, 0x62f, 0x64a, 0x3b, 0x628, 0x647, 0x645, 0x646, 0x3b, 0x627, 0x633, 0x641, 0x646, 0x62f, 0x627, 0x631, 0x3b,
0x9ab, 0x9cd, 0x9af, 0x9be, 0x9ad, 0x9be, 0x9b0, 0x9cd, 0x9a1, 0x9bf, 0x9a8, 0x3b, 0x985, 0x9b0, 0x9a1, 0x9bf, 0x9ac, 0x9c7, 0x9b9, 0x9c7,
0x9b6, 0x9cd, 0x9a4, 0x3b, 0x996, 0x9cb, 0x9b0, 0x9cd, 0x9a6, 0x9cd, 0x9a6, 0x3b, 0x9a4, 0x9c0, 0x9b0, 0x3b, 0x9ae, 0x9b0, 0x9cd, 0x9af,
0x9be, 0x9a6, 0x3b, 0x9b6, 0x9be, 0x9b9, 0x9b0, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b, 0x9ae, 0x9c7, 0x9b9, 0x9c7, 0x9b0, 0x3b, 0x986, 0x9ac,
0x9be, 0x9a8, 0x3b, 0x986, 0x99c, 0x9be, 0x9b0, 0x3b, 0x9a6, 0x9c7, 0x3b, 0x9ac, 0x9be, 0x9b9, 0x9ae, 0x9be, 0x9a8, 0x3b, 0x98f, 0x9b8,
0x9ab, 0x9cd, 0x9af, 0x9be, 0x9a8, 0x9cd, 0x9a1, 0x3b, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9ad, 0x9be, 0x9b0, 0x9cd, 0x9a1, 0x9bf, 0x9a8, 0x3b,
0x985, 0x9b0, 0x9a1, 0x9bf, 0x9ac, 0x9c7, 0x9b9, 0x9c7, 0x9b6, 0x9cd, 0x9a4, 0x3b, 0x996, 0x9cb, 0x9b0, 0x9cd, 0x9a6, 0x9cd, 0x9a6, 0x3b,
0x9a4, 0x9c0, 0x9b0, 0x3b, 0x9ae, 0x9b0, 0x9cd, 0x9af, 0x9be, 0x9a6, 0x3b, 0x9b6, 0x9be, 0x9b9, 0x9b0, 0x9bf, 0x9ac, 0x9be, 0x9b0, 0x3b,
0x9ae, 0x9c7, 0x9b9, 0x9c7, 0x9b0, 0x3b, 0x986, 0x9ac, 0x9be, 0x9a8, 0x3b, 0x9ac, 0x9be, 0x99c, 0x9be, 0x9b0, 0x3b, 0x9a6, 0x9c7, 0x3b,
0x9ac, 0x9be, 0x9b9, 0x9ae, 0x9be, 0x9a8, 0x3b, 0x98f, 0x9b8, 0x9ab, 0x9cd, 0x9af, 0x9be, 0x9a8, 0x9cd, 0x9a1, 0x3b, 0x9e7, 0x3b, 0x9e8,
0x3b, 0x9e9, 0x3b, 0x9ea, 0x3b, 0x9eb, 0x3b, 0x9ec, 0x3b, 0x9ed, 0x3b, 0x9ee, 0x3b, 0x9ef, 0x3b, 0x9e7, 0x9e6, 0x3b, 0x9e7, 0x9e7,
0x3b, 0x9e7, 0x9e8, 0x3b, 0x31, 0x6708, 0x3b, 0x32, 0x6708, 0x3b, 0x33, 0x6708, 0x3b, 0x34, 0x6708, 0x3b, 0x35, 0x6708, 0x3b, 0x36,
0x6708, 0x3b, 0x37, 0x6708, 0x3b, 0x38, 0x6708, 0x3b, 0x39, 0x6708, 0x3b, 0x31, 0x30, 0x6708, 0x3b, 0x31, 0x31, 0x6708, 0x3b, 0x31,
0x32, 0x6708, 0x3b, 0x4e00, 0x6708, 0x3b, 0x4e8c, 0x6708, 0x3b, 0x4e09, 0x6708, 0x3b, 0x56db, 0x6708, 0x3b, 0x4e94, 0x6708, 0x3b, 0x516d, 0x6708,
0x3b, 0x4e03, 0x6708, 0x3b, 0x516b, 0x6708, 0x3b, 0x4e5d, 0x6708, 0x3b, 0x5341, 0x6708, 0x3b, 0x5341, 0x4e00, 0x6708, 0x3b, 0x5341, 0x4e8c, 0x6708,
0x3b, 0x31, 0x2e, 0x3b, 0x32, 0x2e, 0x3b, 0x33, 0x2e, 0x3b, 0x34, 0x2e, 0x3b, 0x35, 0x2e, 0x3b, 0x36, 0x2e, 0x3b, 0x37,
0x2e, 0x3b, 0x38, 0x2e, 0x3b, 0x39, 0x2e, 0x3b, 0x31, 0x30, 0x2e, 0x3b, 0x31, 0x31, 0x2e, 0x3b, 0x31, 0x32, 0x2e, 0x3b,
0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74,
0x3b, 0x63, 0x68, 0x6f, 0x72, 0x64, 0xe1, 0x64, 0x3b, 0x74, 0xed, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0xe1, 0x64, 0x3b,
0x161, 0x61, 0x68, 0x72, 0xed, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0xe1, 0x62, 0xe1, 0x6e, 0x3b, 0xe1,
0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x69, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e,
0x64, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65,
0x73, 0x68, 0x74, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64,
0x61, 0x64, 0x3b, 0x73, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0x61, 0x62,
0x61, 0x6e, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65,
0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69,
0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d,
0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b,
0x61, 0x62, 0x61, 0x6e, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e,
0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x6b, 0x75, 0x75,
0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x6b, 0x75, 0x75, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64,
0x61, 0x64, 0x6b, 0x75, 0x75, 0x3b, 0x74, 0x69, 0x72, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b,
0x75, 0x75, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x6b, 0x75, 0x75, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x6b,
0x75, 0x75, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x6b, 0x75, 0x75, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6b, 0x75, 0x75, 0x3b, 0x64,
0x65, 0x79, 0x6b, 0x75, 0x75, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x6b, 0x75, 0x75, 0x3b, 0x65, 0x73, 0x66, 0x61,
0x6e, 0x64, 0x6b, 0x75, 0x75, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x6b, 0x75, 0x75, 0x74, 0x61,
0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6b, 0x68, 0x6f,
0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x74, 0x69, 0x72, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d,
0x6f, 0x72, 0x64, 0x61, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x6b,
0x75, 0x75, 0x74, 0x61, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x6b,
0x75, 0x75, 0x74, 0x61, 0x3b, 0x61, 0x7a, 0x61, 0x72, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x64, 0x65, 0x79, 0x6b, 0x75,
0x75, 0x74, 0x61, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x65, 0x73, 0x66, 0x61,
0x6e, 0x64, 0x6b, 0x75, 0x75, 0x74, 0x61, 0x3b, 0x66, 0x61, 0x72, 0x2e, 0x3b, 0x6f, 0x72, 0x64, 0x2e, 0x3b, 0x6b, 0x68,
0x6f, 0x2e, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x2e, 0x3b, 0x161, 0x61, 0x68, 0x2e, 0x3b, 0x6d, 0x65, 0x68,
0x72, 0x3b, 0xe2, 0x62, 0xe2, 0x6e, 0x3b, 0xe2, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x2e,
0x3b, 0x65, 0x73, 0x66, 0x2e, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69,
0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d,
0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b,
0xe2, 0x62, 0xe2, 0x6e, 0x3b, 0xe2, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e,
0x3b, 0x65, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x46, 0x61, 0x72, 0x2e, 0x3b, 0x4f, 0x72, 0x64, 0x2e, 0x3b, 0x4b, 0x68,
0x6f, 0x2e, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x2e, 0x3b, 0x160, 0x61, 0x68, 0x2e, 0x3b, 0x4d, 0x65, 0x68,
0x72, 0x3b, 0xc2, 0x62, 0xe2, 0x2e, 0x3b, 0xc2, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x2e,
0x3b, 0x45, 0x73, 0x66, 0x2e, 0x3b, 0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69,
0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d,
0x6f, 0x72, 0x64, 0xe2, 0x64, 0x3b, 0x160, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b,
0xc2, 0x62, 0xe2, 0x6e, 0x3b, 0xc2, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e,
0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x10e4, 0x10d0, 0x10e0, 0x10d5, 0x10d0, 0x10e0, 0x10d3, 0x10d8, 0x10dc, 0x10d8, 0x3b, 0x10dd,
0x10e0, 0x10d3, 0x10d8, 0x10d1, 0x10d4, 0x10f0, 0x10d4, 0x10e8, 0x10d7, 0x10d8, 0x3b, 0x10ee, 0x10dd, 0x10e0, 0x10d3, 0x10d0, 0x10d3, 0x10d8, 0x3b, 0x10d7,
0x10d8, 0x10e0, 0x10d8, 0x3b, 0x10db, 0x10dd, 0x10e0, 0x10d3, 0x10d0, 0x10d3, 0x10d8, 0x3b, 0x10e8, 0x10d0, 0x10f0, 0x10e0, 0x10d8, 0x10d5, 0x10d0, 0x10e0,
0x10d8, 0x3b, 0x10db, 0x10d4, 0x10f0, 0x10e0, 0x10d8, 0x3b, 0x10d0, 0x10d1, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10d0, 0x10d6, 0x10d0, 0x10e0, 0x10d8, 0x3b,
0x10d3, 0x10d4, 0x10d8, 0x3b, 0x10d1, 0x10d0, 0x10f0, 0x10db, 0x10d0, 0x10dc, 0x10d8, 0x3b, 0x10d4, 0x10e1, 0x10e4, 0x10d0, 0x10dc, 0x10d3, 0x10d8, 0x3b,
0x46, 0x61, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x63,
0x68, 0x74, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x101,
0x64, 0x3b, 0x53, 0x63, 0x68, 0x61, 0x68, 0x72, 0x69, 0x77, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x100, 0x62,
0x101, 0x6e, 0x3b, 0x100, 0x73, 0x61, 0x72, 0x3b, 0x44, 0xe9, 0x69, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45,
0x73, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0xaab, 0xabe, 0xab0, 0xacd, 0xab5, 0xabe, 0xab0, 0xacd, 0xaa6, 0xabf, 0xaa8, 0x3b, 0xa93,
0xab0, 0xaa1, 0xac0, 0xaac, 0xac7, 0xab9, 0xac7, 0xab6, 0xacd, 0xa9f, 0x3b, 0xa96, 0xacb, 0xab0, 0xaa6, 0xabe, 0xaa6, 0x3b, 0xaa4, 0xabf,
0xab0, 0x3b, 0xaae, 0xacb, 0xab0, 0xacd, 0xaa6, 0xabe, 0xaa6, 0x3b, 0xab6, 0xabe, 0xab9, 0xab0, 0xabf, 0xab5, 0xab0, 0x3b, 0xaae, 0xac7,
0xab9, 0xab0, 0x3b, 0xa85, 0xaac, 0xabe, 0xaa8, 0x3b, 0xa85, 0xa9d, 0xabe, 0xab0, 0x3b, 0xaa1, 0xac7, 0xaaf, 0x3b, 0xaac, 0xabe, 0xab9,
0xaae, 0xac7, 0xaa8, 0x3b, 0xa8f, 0xab8, 0xacd, 0xaab, 0xabe, 0xaa8, 0xacd, 0xaa1, 0x3b, 0x5e4, 0x5e8, 0x5d5, 0x5e8, 0x5d3, 0x5d9, 0x5df,
0x3b, 0x5d0, 0x5e8, 0x5d3, 0x5d9, 0x5d1, 0x5d4, 0x5e9, 0x5ea, 0x3b, 0x5d7, 0x5f3, 0x5e8, 0x5d3, 0x5d0, 0x5d3, 0x3b, 0x5ea, 0x5d9, 0x5e8,
0x3b, 0x5de, 0x5e8, 0x5d3, 0x5d0, 0x5d3, 0x3b, 0x5e9, 0x5d4, 0x5e8, 0x5d9, 0x5d5, 0x5e8, 0x3b, 0x5de, 0x5d4, 0x5e8, 0x3b, 0x5d0, 0x5d1,
0x5d0, 0x5df, 0x3b, 0x5d0, 0x5d3, 0x5f3, 0x5e8, 0x3b, 0x5d3, 0x5d9, 0x3b, 0x5d1, 0x5d4, 0x5de, 0x5df, 0x3b, 0x5d0, 0x5e1, 0x5e4, 0x5e0,
0x5d3, 0x3b, 0x92b, 0x930, 0x94d, 0x935, 0x93e, 0x926, 0x93f, 0x928, 0x3b, 0x913, 0x930, 0x94d, 0x926, 0x93f, 0x935, 0x947, 0x939, 0x947,
0x938, 0x94d, 0x91f, 0x3b, 0x916, 0x94b, 0x930, 0x930, 0x94d, 0x926, 0x93e, 0x926, 0x3b, 0x91f, 0x93f, 0x930, 0x3b, 0x92e, 0x94b, 0x930,
0x926, 0x93e, 0x926, 0x3b, 0x936, 0x93e, 0x939, 0x930, 0x940, 0x935, 0x930, 0x94d, 0x3b, 0x92e, 0x947, 0x939, 0x930, 0x3b, 0x905, 0x935,
0x928, 0x3b, 0x905, 0x91c, 0x93c, 0x930, 0x3b, 0x921, 0x947, 0x3b, 0x92c, 0x939, 0x92e, 0x928, 0x3b, 0x908, 0x938, 0x94d, 0x92b, 0x928,
0x94d, 0x926, 0x94d, 0x3b, 0x30d5, 0x30a1, 0x30eb, 0x30f4, 0x30a1, 0x30eb, 0x30c7, 0x30a3, 0x30fc, 0x30f3, 0x3b, 0x30aa, 0x30eb, 0x30c7, 0x30a3, 0x30fc,
0x30d9, 0x30d8, 0x30b7, 0x30e5, 0x30c8, 0x3b, 0x30db, 0x30eb, 0x30c0, 0x30fc, 0x30c9, 0x3b, 0x30c6, 0x30a3, 0x30fc, 0x30eb, 0x3b, 0x30e2, 0x30eb, 0x30c0,
0x30fc, 0x30c9, 0x3b, 0x30b7, 0x30e3, 0x30cf, 0x30ea, 0x30fc, 0x30f4, 0x30a1, 0x30eb, 0x3b, 0x30e1, 0x30d5, 0x30eb, 0x3b, 0x30a2, 0x30fc, 0x30d0, 0x30fc,
0x30f3, 0x3b, 0x30a2, 0x30fc, 0x30b6, 0x30eb, 0x3b, 0x30c7, 0x30a4, 0x3b, 0x30d0, 0x30d5, 0x30de, 0x30f3, 0x3b, 0x30a8, 0x30b9, 0x30d5, 0x30a1, 0x30f3,
0x30c9, 0x3b, 0xcab, 0xcb0, 0xccd, 0xcb5, 0xcb0, 0xccd, 0xca6, 0xcbf, 0xca8, 0xccd, 0x3b, 0xc93, 0xcb0, 0xccd, 0xca6, 0xcbf, 0xcac, 0xcc6,
0xcb9, 0xcc6, 0xcb6, 0xccd, 0xc9f, 0xccd, 0x3b, 0xc96, 0xccb, 0xcb0, 0xccd, 0xca1, 0xcbe, 0xca6, 0xccd, 0x3b, 0xc9f, 0xcbf, 0xcb0, 0xccd,
0x3b, 0xcae, 0xcca, 0xcb0, 0xccd, 0xca6, 0xcbe, 0xca6, 0xccd, 0x3b, 0xcb6, 0xcb9, 0xcb0, 0xcbf, 0xcb5, 0xcbe, 0xcb0, 0xccd, 0x3b, 0xcae,
0xcc6, 0xcb9, 0xccd, 0xcb0, 0xccd, 0x3b, 0xc85, 0xcac, 0xca8, 0xccd, 0x3b, 0xc85, 0xc9d, 0xcb0, 0xccd, 0x3b, 0xca1, 0xcc7, 0x3b, 0xcac,
0xcb9, 0xccd, 0xcae, 0xca8, 0xccd, 0x3b, 0xc8e, 0xcb8, 0xccd, 0xcab, 0xcbe, 0xc82, 0xca1, 0xccd, 0x3b, 0xd654, 0xb974, 0xbc14, 0xb518, 0x3b,
0xc624, 0xb974, 0xb514, 0xbca0, 0xd5e4, 0xc26c, 0xd2b8, 0x3b, 0xd638, 0xb974, 0xb2e4, 0xb4dc, 0x3b, 0xd2f0, 0xb974, 0x3b, 0xbaa8, 0xb974, 0xb2e4, 0xb4dc,
0x3b, 0xc0e4, 0xd750, 0xb9ac, 0xbc14, 0xb974, 0x3b, 0xba54, 0xd750, 0xb974, 0x3b, 0xc544, 0xbc18, 0x3b, 0xc544, 0xc790, 0xb974, 0x3b, 0xb2e4, 0xc774,
0x3b, 0xbc14, 0xd750, 0xb9cc, 0x3b, 0xc5d0, 0xc2a4, 0xd310, 0xb4dc, 0x3b, 0xe9f, 0xea3, 0xeb2, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b, 0xead,
0xecd, 0xea3, 0xe94, 0xeb5, 0xe9a, 0xeb5, 0xec0, 0xeab, 0xeae, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1, 0xe95,
0xea3, 0x3b, 0xea1, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xea5, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeb5,
0x3b, 0xead, 0xeb2, 0xe9a, 0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2, 0xea1,
0xeb2, 0xe99, 0x3b, 0xec0, 0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0x3b, 0xe9f, 0xea3, 0xeb2, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b, 0xead,
0xecd, 0xea3, 0xe94, 0xeb5, 0xe9a, 0xeb5, 0xec0, 0xeab, 0xea3, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1, 0xe95,
0xea3, 0x3b, 0xea1, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xeab, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1, 0xeb5,
0x3b, 0xead, 0xeb2, 0xe9a, 0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0xea3, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2,
0xec1, 0xea1, 0xe99, 0x3b, 0xec0, 0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0x3b, 0xe9f, 0xeb2, 0xea3, 0xea7, 0xeb2, 0xe94, 0xeb4, 0xe99, 0x3b,
0xead, 0xecd, 0xea3, 0xe94, 0xeb5, 0xe9a, 0xeb5, 0xec0, 0xeab, 0xea3, 0xe94, 0x3b, 0xe84, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xec1,
0xe95, 0xea3, 0x3b, 0xea1, 0xecd, 0xea3, 0xec0, 0xe94, 0xe94, 0x3b, 0xe8a, 0xeb2, 0xea3, 0xeab, 0xeb4, 0xea7, 0xeb2, 0x3b, 0xec0, 0xea1,
0xeb5, 0x3b, 0xead, 0xeb2, 0xe9a, 0xeb2, 0xe99, 0x3b, 0xead, 0xeb2, 0xe8a, 0xeb2, 0x3b, 0xe94, 0xeb5, 0xea3, 0x3b, 0xe9a, 0xea3, 0xeb2,
0xea1, 0xeb2, 0xe99, 0x3b, 0xec0, 0xead, 0xeaa, 0xe9f, 0xeb2, 0xe99, 0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x12b, 0x6e,
0x73, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x73, 0x3b, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64,
0x73, 0x3b, 0x74, 0x12b, 0x72, 0x73, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x73, 0x3b, 0x161, 0x61, 0x68, 0x72, 0x69,
0x76, 0x113, 0x72, 0x73, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x73, 0x3b, 0x61, 0x62, 0x61, 0x6e, 0x73, 0x3b, 0x61, 0x7a, 0x65,
0x72, 0x73, 0x3b, 0x64, 0x65, 0x6a, 0x73, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x73, 0x3b, 0x65, 0x73, 0x66, 0x61,
0x6e, 0x64, 0x73, 0x3b, 0x444, 0x430, 0x440, 0x432, 0x430, 0x440, 0x434, 0x438, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x438, 0x431, 0x435,
0x445, 0x435, 0x448, 0x442, 0x3b, 0x43a, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434,
0x430, 0x434, 0x3b, 0x448, 0x430, 0x445, 0x440, 0x438, 0x432, 0x430, 0x440, 0x3b, 0x43c, 0x435, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d,
0x3b, 0x430, 0x437, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x458, 0x3b, 0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x435, 0x441, 0x444,
0x430, 0x43d, 0x434, 0x3b, 0xd2b, 0xd7c, 0xd35, 0xd3e, 0xd7c, 0xd26, 0xd3f, 0xd7b, 0x3b, 0xd13, 0xd7c, 0xd21, 0xd3f, 0xd2c, 0xd46, 0xd39,
0xd46, 0xd37, 0xd4d, 0x200c, 0xd31, 0xd4d, 0xd31, 0xd4d, 0x3b, 0xd16, 0xd4b, 0xd7c, 0xd26, 0xd3e, 0xd26, 0xd4d, 0x3b, 0xd1f, 0xd3f, 0xd7c,
0x3b, 0xd2e, 0xd4b, 0xd7c, 0xd26, 0xd3e, 0xd26, 0xd4d, 0x3b, 0xd37, 0xd39, 0xd4d, 0x200c, 0xd30, 0xd3f, 0xd35, 0xd3e, 0xd7c, 0x3b, 0xd2e,
0xd46, 0xd39, 0xd7c, 0x3b, 0xd05, 0xd2c, 0xd3e, 0xd7b, 0x3b, 0xd05, 0xd38, 0xd7c, 0x3b, 0xd21, 0xd46, 0xd2f, 0xd4d, 0x3b, 0xd2c, 0xd39,
0xd4d, 0x200c, 0xd2e, 0xd3e, 0xd7b, 0x3b, 0xd0e, 0xd38, 0xd4d, 0x200c, 0xd2b, 0xd3e, 0xd7b, 0xd21, 0xd4d, 0x3b, 0xd2b, 0x2e, 0x3b, 0xd13,
0x2e, 0x3b, 0xd16, 0xd4b, 0x3b, 0xd1f, 0xd3f, 0x2e, 0x3b, 0xd2e, 0xd4b, 0x2e, 0x3b, 0xd37, 0x2e, 0x3b, 0xd2e, 0xd46, 0x2e, 0x3b,
0xd05, 0x2e, 0x3b, 0xd05, 0x2e, 0x3b, 0xd21, 0xd46, 0x2e, 0x3b, 0xd2c, 0x2e, 0x3b, 0xd0e, 0x2e, 0x3b, 0x92b, 0x930, 0x935, 0x930,
0x926, 0x93f, 0x928, 0x3b, 0x913, 0x930, 0x94d, 0x926, 0x93f, 0x92c, 0x947, 0x939, 0x947, 0x936, 0x94d, 0x924, 0x3b, 0x916, 0x94b, 0x930,
0x926, 0x93e, 0x926, 0x3b, 0x924, 0x93f, 0x930, 0x3b, 0x92e, 0x94b, 0x930, 0x926, 0x93e, 0x926, 0x3b, 0x936, 0x93e, 0x939, 0x930, 0x940,
0x935, 0x93e, 0x930, 0x3b, 0x92e, 0x947, 0x939, 0x947, 0x930, 0x3b, 0x905, 0x92c, 0x93e, 0x928, 0x3b, 0x905, 0x91d, 0x93e, 0x930, 0x3b,
0x926, 0x947, 0x3b, 0x92c, 0x93e, 0x939, 0x92e, 0x93e, 0x928, 0x3b, 0x90f, 0x938, 0x92b, 0x93e, 0x902, 0x926, 0x3b, 0x967, 0x3b, 0x968,
0x3b, 0x969, 0x3b, 0x96a, 0x3b, 0x96b, 0x3b, 0x96c, 0x3b, 0x96d, 0x3b, 0x96e, 0x3b, 0x96f, 0x3b, 0x967, 0x966, 0x3b, 0x967, 0x967,
0x3b, 0x967, 0x968, 0x3b, 0x648, 0x631, 0x6cc, 0x3b, 0x63a, 0x648, 0x6cc, 0x6cc, 0x3b, 0x63a, 0x628, 0x631, 0x6af, 0x648, 0x644, 0x6cc,
0x3b, 0x686, 0x646, 0x6af, 0x627, 0x69a, 0x3b, 0x632, 0x645, 0x631, 0x6cc, 0x3b, 0x648, 0x696, 0x6cc, 0x3b, 0x62a, 0x644, 0x647, 0x3b,
0x644, 0x693, 0x645, 0x3b, 0x644, 0x6cc, 0x646, 0x62f, 0x6cd, 0x3b, 0x645, 0x631, 0x63a, 0x648, 0x645, 0x6cc, 0x3b, 0x633, 0x644, 0x648,
0x627, 0x63a, 0x647, 0x3b, 0x6a9, 0x628, 0x3b, 0x6f1, 0x3b, 0x6f2, 0x3b, 0x6f3, 0x3b, 0x6f4, 0x3b, 0x6f5, 0x3b, 0x6f6, 0x3b, 0x6f7,
0x3b, 0x6f8, 0x3b, 0x6f9, 0x3b, 0x6f1, 0x6f0, 0x3b, 0x6f1, 0x6f1, 0x3b, 0x6f1, 0x6f2, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x62f, 0x6cc,
0x646, 0x3b, 0x627, 0x631, 0x62f, 0x6cc, 0x628, 0x647, 0x634, 0x62a, 0x3b, 0x62e, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x62a, 0x6cc, 0x631,
0x3b, 0x645, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x647, 0x631, 0x6cc, 0x648, 0x631, 0x3b, 0x645, 0x647, 0x631, 0x3b, 0x622, 0x628,
0x627, 0x646, 0x3b, 0x622, 0x630, 0x631, 0x3b, 0x62f, 0x6cc, 0x3b, 0x628, 0x647, 0x645, 0x646, 0x3b, 0x627, 0x633, 0x641, 0x646, 0x62f,
0x3b, 0x641, 0x3b, 0x627, 0x3b, 0x62e, 0x3b, 0x62a, 0x3b, 0x645, 0x3b, 0x634, 0x3b, 0x645, 0x3b, 0x622, 0x3b, 0x622, 0x3b, 0x62f,
0x3b, 0x628, 0x3b, 0x627, 0x3b, 0x62d, 0x3b, 0x62b, 0x3b, 0x62c, 0x3b, 0x633, 0x3b, 0x627, 0x3b, 0x633, 0x3b, 0x645, 0x3b, 0x639,
0x3b, 0x642, 0x3b, 0x62c, 0x3b, 0x62f, 0x3b, 0x62d, 0x3b, 0x62d, 0x645, 0x644, 0x3b, 0x62b, 0x648, 0x631, 0x3b, 0x62c, 0x648, 0x632,
0x627, 0x3b, 0x633, 0x631, 0x637, 0x627, 0x646, 0x3b, 0x627, 0x633, 0x62f, 0x3b, 0x633, 0x646, 0x628, 0x644, 0x647, 0x654, 0x3b, 0x645,
0x6cc, 0x632, 0x627, 0x646, 0x3b, 0x639, 0x642, 0x631, 0x628, 0x3b, 0x642, 0x648, 0x633, 0x3b, 0x62c, 0x62f, 0x6cc, 0x3b, 0x62f, 0x644,
0x648, 0x3b, 0x62d, 0x648, 0x62a, 0x3b, 0x46, 0x61, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69,
0x62, 0x65, 0x68, 0x65, 0x73, 0x7a, 0x74, 0x3b, 0x43, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b,
0x4d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x53, 0x7a, 0x61, 0x68, 0x72, 0x69, 0x77, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68,
0x72, 0x3b, 0x100, 0x62, 0x101, 0x6e, 0x3b, 0x100, 0x73, 0x61, 0x72, 0x3b, 0x44, 0xe9, 0x69, 0x3b, 0x42, 0x61, 0x68, 0x6d,
0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0xa2b, 0xa3e, 0xa30, 0xa35, 0xa30, 0xa21, 0xa40, 0xa28, 0x3b, 0xa14,
0xa30, 0xa21, 0xa3e, 0xa08, 0xa2c, 0xa39, 0xa48, 0xa38, 0xa3c, 0xa1f, 0x3b, 0xa16, 0xa4b, 0xa21, 0xa30, 0xa21, 0x3b, 0xa1f, 0xa3f, 0xa30,
0x3b, 0xa2e, 0xa4b, 0xa30, 0xa21, 0xa3e, 0xa26, 0x3b, 0xa38, 0xa3c, 0xa30, 0xa3e, 0xa07, 0xa35, 0xa30, 0x3b, 0xa2e, 0xa47, 0xa39, 0xa30,
0x3b, 0xa05, 0xa2c, 0xa3e, 0xa28, 0x3b, 0xa05, 0xa1c, 0xa3c, 0xa3e, 0xa30, 0x3b, 0xa21, 0xa47, 0xa05, 0x3b, 0xa2c, 0xa3e, 0xa39, 0xa2e,
0xa28, 0x3b, 0xa10, 0xa38, 0xa2b, 0xa70, 0xa21, 0x3b, 0x46, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72,
0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x4b, 0x68, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x54, 0x69,
0x72, 0x3b, 0x41, 0x2d, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x53, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72,
0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b,
0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x444, 0x430, 0x440, 0x432, 0x430, 0x440,
0x434, 0x438, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x438, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442, 0x3b, 0x445, 0x43e, 0x440, 0x434, 0x430,
0x434, 0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x448, 0x430, 0x445, 0x440, 0x438, 0x432, 0x435,
0x440, 0x3b, 0x43c, 0x435, 0x445, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439,
0x3b, 0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x44d, 0x441, 0x444, 0x430, 0x43d, 0x434, 0x3b, 0x424, 0x430, 0x440, 0x430, 0x432,
0x430, 0x434, 0x438, 0x43d, 0x3b, 0x41e, 0x440, 0x434, 0x438, 0x431, 0x435, 0x445, 0x435, 0x448, 0x442, 0x3b, 0x41a, 0x43e, 0x440, 0x434,
0x430, 0x434, 0x3b, 0x422, 0x438, 0x440, 0x3b, 0x41c, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x428, 0x430, 0x445, 0x440, 0x438, 0x432,
0x430, 0x440, 0x3b, 0x41c, 0x435, 0x445, 0x440, 0x3b, 0x410, 0x431, 0x430, 0x43d, 0x3b, 0x410, 0x437, 0x430, 0x440, 0x3b, 0x414, 0x435,
0x458, 0x3b, 0x411, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x415, 0x441, 0x444, 0x430, 0x43d, 0x434, 0x3b, 0x46, 0x61, 0x72, 0x61,
0x76, 0x61, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x161, 0x74, 0x3b, 0x4b, 0x6f, 0x72,
0x64, 0x61, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x160, 0x61, 0x68, 0x72, 0x69,
0x76, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x61, 0x72, 0x3b, 0x44,
0x65, 0x6a, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64, 0x3b, 0x4a, 0x61, 0x6e,
0x61, 0x61, 0x79, 0x6f, 0x3b, 0x46, 0x65, 0x65, 0x62, 0x72, 0x61, 0x61, 0x79, 0x6f, 0x3b, 0x4d, 0x61, 0x61, 0x72, 0x73,
0x6f, 0x3b, 0x41, 0x62, 0x72, 0x69, 0x6c, 0x3b, 0x4d, 0x61, 0x61, 0x79, 0x6f, 0x3b, 0x4a, 0x75, 0x75, 0x6e, 0x3b, 0x4c,
0x75, 0x75, 0x6c, 0x69, 0x79, 0x6f, 0x3b, 0x41, 0x67, 0x6f, 0x6f, 0x73, 0x74, 0x6f, 0x3b, 0x53, 0x61, 0x62, 0x74, 0x65,
0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x4f, 0x6b, 0x74, 0x6f, 0x6f, 0x62, 0x61, 0x72, 0x3b, 0x4e, 0x6f, 0x6f, 0x66, 0x65,
0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x44, 0x69, 0x69, 0x73, 0x65, 0x65, 0x6d, 0x62, 0x61, 0x72, 0x3b, 0x46, 0x61, 0x72,
0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73, 0x68, 0x74, 0x3b, 0x4b,
0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x53, 0x68,
0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x4d, 0x65, 0x68, 0x72, 0x3b, 0x100, 0x62, 0x101, 0x6e, 0x3b, 0x100, 0x7a,
0x61, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x61, 0x6e, 0x64,
0x3b, 0x66, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x3b, 0x6f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x73,
0x68, 0x74, 0x3b, 0x6b, 0x68, 0x6f, 0x72, 0x64, 0x101, 0x64, 0x3b, 0x74, 0x69, 0x72, 0x3b, 0x6d, 0x6f, 0x72, 0x64, 0x101,
0x64, 0x3b, 0x73, 0x68, 0x61, 0x68, 0x72, 0x69, 0x76, 0x61, 0x72, 0x3b, 0x6d, 0x65, 0x68, 0x72, 0x3b, 0x101, 0x62, 0x101,
0x6e, 0x3b, 0x101, 0x7a, 0x61, 0x72, 0x3b, 0x64, 0x65, 0x79, 0x3b, 0x62, 0x61, 0x68, 0x6d, 0x61, 0x6e, 0x3b, 0x65, 0x73,
0x66, 0x61, 0x6e, 0x64, 0x3b, 0x444, 0x430, 0x440, 0x432, 0x430, 0x440, 0x434, 0x438, 0x43d, 0x3b, 0x443, 0x440, 0x434, 0x438, 0x431,
0x438, 0x4b3, 0x438, 0x448, 0x442, 0x3b, 0x445, 0x443, 0x440, 0x434, 0x43e, 0x434, 0x3b, 0x442, 0x438, 0x440, 0x3b, 0x43c, 0x443, 0x440,
0x434, 0x43e, 0x434, 0x3b, 0x448, 0x430, 0x4b3, 0x440, 0x438, 0x432, 0x430, 0x440, 0x3b, 0x43c, 0x435, 0x4b3, 0x440, 0x3b, 0x43e, 0x431,
0x43e, 0x43d, 0x3b, 0x43e, 0x437, 0x430, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x4b3, 0x43c, 0x430, 0x43d, 0x3b, 0x438,
0x441, 0x444, 0x430, 0x43d, 0x434, 0x3b, 0xb83, 0xbaa, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xb86, 0xbb0, 0xbcd, 0xb9f, 0xbbf, 0x2e, 0x3b, 0xb95,
0xbca, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xba4, 0xbbf, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbca, 0xbb0, 0xbcd, 0x2e, 0x3b, 0xbb7, 0xbbe, 0xbb0, 0xbbf,
0x2e, 0x3b, 0xbae, 0xbc6, 0xbb9, 0xbcd, 0x2e, 0x3b, 0xb85, 0xbaa, 0xbbe, 0x2e, 0x3b, 0xb85, 0xb9a, 0xbbe, 0x2e, 0x3b, 0xba4, 0xbc7,
0x3b, 0xbaa, 0xbb9, 0xbcd, 0x2e, 0x3b, 0xb8e, 0xb83, 0x2e, 0x3b, 0xb83, 0xbaa, 0xbb0, 0xbcd, 0xbb5, 0xbbe, 0xba4, 0xbbf, 0xba9, 0xbcd,
0x3b, 0xb86, 0xbb0, 0xbcd, 0xb9f, 0xbbf, 0xbaa, 0xbc6, 0xbb9, 0xbc6, 0xbb7, 0xbcd, 0xba4, 0xbcd, 0x3b, 0xb95, 0xbca, 0xbb0, 0xbcd, 0xba4,
0xbbe, 0xba4, 0xbcd, 0x3b, 0xba4, 0xbbf, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbca, 0xbb0, 0xbcd, 0xba4, 0xbbe, 0xba4, 0xbcd, 0x3b, 0xbb7, 0xbbe,
0xbb0, 0xbbf, 0xbb5, 0xbbe, 0xbb0, 0xbcd, 0x3b, 0xbae, 0xbc6, 0xbb9, 0xbcd, 0xbb0, 0xbcd, 0x3b, 0xb85, 0xbaa, 0xbbe, 0xba9, 0xbcd, 0x3b,
0xb85, 0xb9a, 0xbbe, 0xbb0, 0xbcd, 0x3b, 0xba4, 0xbc7, 0x3b, 0xbaa, 0xbb9, 0xbcd, 0xbae, 0xbbe, 0xba9, 0xbcd, 0x3b, 0xb8e, 0xb83, 0xbaa,
0xbbe, 0xba9, 0xbcd, 0x3b, 0xc2b, 0xc3e, 0xc35, 0xc30, 0xc4d, 0xc21, 0xc3f, 0xc28, 0xc4d, 0x3b, 0xc0a, 0xc21, 0xc3e, 0xc2c, 0xc39, 0xc37,
0xc4d, 0xc1f, 0xc4d, 0x3b, 0xc16, 0xc4b, 0xc30, 0xc4d, 0xc21, 0xc3e, 0xc21, 0xc4d, 0x3b, 0xc1f, 0xc3f, 0xc30, 0xc4d, 0x3b, 0xc2e, 0xc46,
0xc30, 0xc4d, 0xc21, 0xc3e, 0xc21, 0xc4d, 0x3b, 0xc36, 0xc36, 0xc3f, 0xc35, 0xc30, 0xc4d, 0x3b, 0xc2e, 0xc46, 0xc39, 0xc30, 0xc4d, 0x3b,
0xc05, 0xc2c, 0xc28, 0xc4d, 0x3b, 0xc05, 0xc1c, 0xc30, 0xc4d, 0x3b, 0xc21, 0xc47, 0x3b, 0xc2c, 0xc3e, 0xc39, 0xc4d, 0x200c, 0xc2e, 0xc3e,
0xc28, 0xc4d, 0x3b, 0xc0e, 0xc38, 0xc4d, 0x200c, 0xc2b, 0xc3e, 0xc02, 0xc21, 0xc4d, 0x3b, 0xe1f, 0xe32, 0xe23, 0xe4c, 0xe27, 0xe32, 0xe23,
0xe4c, 0xe14, 0xe34, 0xe19, 0x3b, 0xe2d, 0xe2d, 0xe23, 0xe4c, 0xe14, 0xe34, 0xe40, 0xe1a, 0xe40, 0xe2e, 0xe0a, 0xe15, 0xe4c, 0x3b, 0xe04,
0xe2d, 0xe23, 0xe4c, 0xe41, 0xe14, 0xe14, 0x3b, 0xe40, 0xe15, 0xe2d, 0xe23, 0xe4c, 0x3b, 0xe21, 0xe2d, 0xe23, 0xe4c, 0xe41, 0xe14, 0xe14,
0x3b, 0xe0a, 0xe32, 0xe2b, 0xe23, 0xe34, 0xe27, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe40, 0xe21, 0xe2e, 0xe23, 0xe4c, 0x3b, 0xe2d, 0xe30, 0xe1a,
0xe32, 0xe19, 0x3b, 0xe2d, 0xe30, 0xe0b, 0xe32, 0xe23, 0xe4c, 0x3b, 0xe40, 0xe14, 0xe22, 0xe4c, 0x3b, 0xe1a, 0xe32, 0xe2e, 0xe4c, 0xe21,
0xe32, 0xe19, 0x3b, 0xe40, 0xe2d, 0xe2a, 0xe1f, 0xe32, 0xe19, 0xe14, 0xe4c, 0x3b, 0x46, 0x65, 0x72, 0x76, 0x65, 0x72, 0x64, 0x69,
0x6e, 0x3b, 0x4f, 0x72, 0x64, 0x69, 0x62, 0x65, 0x68, 0x65, 0x15f, 0x74, 0x3b, 0x48, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b,
0x54, 0x69, 0x72, 0x3b, 0x4d, 0x6f, 0x72, 0x64, 0x61, 0x64, 0x3b, 0x15e, 0x65, 0x68, 0x72, 0x69, 0x76, 0x65, 0x72, 0x3b,
0x4d, 0x65, 0x68, 0x72, 0x3b, 0x41, 0x62, 0x61, 0x6e, 0x3b, 0x41, 0x7a, 0x65, 0x72, 0x3b, 0x44, 0x65, 0x79, 0x3b, 0x42,
0x65, 0x68, 0x6d, 0x65, 0x6e, 0x3b, 0x45, 0x73, 0x66, 0x65, 0x6e, 0x64, 0x3b, 0x444, 0x430, 0x440, 0x3b, 0x43e, 0x440, 0x434,
0x3b, 0x445, 0x43e, 0x440, 0x3b, 0x442, 0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x3b, 0x448, 0x430, 0x445, 0x3b, 0x43c, 0x435, 0x445,
0x3b, 0x430, 0x431, 0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x445, 0x3b, 0x435,
0x441, 0x444, 0x3b, 0x444, 0x430, 0x440, 0x432, 0x430, 0x440, 0x434, 0x456, 0x43d, 0x3b, 0x43e, 0x440, 0x434, 0x456, 0x431, 0x435, 0x445,
0x435, 0x448, 0x442, 0x3b, 0x445, 0x43e, 0x440, 0x434, 0x430, 0x434, 0x3b, 0x442, 0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x434, 0x430,
0x434, 0x3b, 0x448, 0x430, 0x445, 0x440, 0x456, 0x432, 0x435, 0x440, 0x3b, 0x43c, 0x435, 0x445, 0x440, 0x3b, 0x430, 0x431, 0x430, 0x43d,
0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x445, 0x43c, 0x430, 0x43d, 0x3b, 0x435, 0x441, 0x444,
0x430, 0x43d, 0x434, 0x3b, 0x444, 0x430, 0x440, 0x2e, 0x3b, 0x43e, 0x440, 0x434, 0x2e, 0x3b, 0x445, 0x43e, 0x440, 0x2e, 0x3b, 0x442,
0x456, 0x440, 0x3b, 0x43c, 0x43e, 0x440, 0x2e, 0x3b, 0x448, 0x430, 0x445, 0x2e, 0x3b, 0x43c, 0x435, 0x445, 0x2e, 0x3b, 0x430, 0x431,
0x430, 0x43d, 0x3b, 0x430, 0x437, 0x435, 0x440, 0x3b, 0x434, 0x435, 0x439, 0x3b, 0x431, 0x430, 0x445, 0x2e, 0x3b, 0x435, 0x441, 0x444,
0x2e, 0x3b, 0x641, 0x631, 0x648, 0x631, 0x62f, 0x646, 0x3b, 0x622, 0x631, 0x688, 0x628, 0x627, 0x626, 0x634, 0x3b, 0x62e, 0x62f, 0x627,
0x62f, 0x627, 0x62f, 0x3b, 0x62a, 0x6cc, 0x631, 0x3b, 0x645, 0x631, 0x62f, 0x627, 0x62f, 0x3b, 0x634, 0x6c1, 0x631, 0x6cc, 0x648, 0x627,
0x631, 0x3b, 0x645, 0x6c1, 0x631, 0x3b, 0x627, 0x628, 0x627, 0x646, 0x3b, 0x622, 0x632, 0x631, 0x3b, 0x688, 0x6d2, 0x3b, 0x628, 0x6c1,
0x645, 0x646, 0x3b, 0x627, 0x633, 0x641, 0x646, 0x62f, 0x3b, 0x64, 0x7a, 0x76, 0x3b, 0x64, 0x7a, 0x64, 0x3b, 0x74, 0x65, 0x64,
0x3b, 0x61, 0x66, 0x254, 0x3b, 0x64, 0x61, 0x6d, 0x3b, 0x6d, 0x61, 0x73, 0x3b, 0x73, 0x69, 0x61, 0x3b, 0x64, 0x65, 0x61,
0x3b, 0x61, 0x6e, 0x79, 0x3b, 0x6b, 0x65, 0x6c, 0x3b, 0x61, 0x64, 0x65, 0x3b, 0x64, 0x7a, 0x6d, 0x3b, 0x64, 0x7a, 0x6f,
0x76, 0x65, 0x3b, 0x64, 0x7a, 0x6f, 0x64, 0x7a, 0x65, 0x3b, 0x74, 0x65, 0x64, 0x6f, 0x78, 0x65, 0x3b, 0x61, 0x66, 0x254,
0x66, 0x69, 0x1ebd, 0x3b, 0x64, 0x61, 0x6d, 0x25b, 0x3b, 0x6d, 0x61, 0x73, 0x61, 0x3b, 0x73, 0x69, 0x61, 0x6d, 0x6c, 0x254,
0x6d, 0x3b, 0x64, 0x65, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x69, 0x6d, 0x65, 0x3b, 0x61, 0x6e, 0x79, 0x254, 0x6e, 0x79, 0x254,
0x3b, 0x6b, 0x65, 0x6c, 0x65, 0x3b, 0x61, 0x64, 0x65, 0x25b, 0x6d, 0x65, 0x6b, 0x70, 0x254, 0x78, 0x65, 0x3b, 0x64, 0x7a,
0x6f, 0x6d, 0x65, 0x3b, 0x62e, 0x627, 0x6a9, 0x6d5, 0x644, 0x6ce, 0x648, 0x6d5, 0x3b, 0x628, 0x627, 0x646, 0x6d5, 0x645, 0x6d5, 0x695,
0x3b, 0x62c, 0x6c6, 0x632, 0x6d5, 0x631, 0x62f, 0x627, 0x646, 0x3b, 0x67e, 0x648, 0x648, 0x634, 0x67e, 0x6d5, 0x695, 0x3b, 0x6af, 0x6d5,
0x644, 0x627, 0x648, 0x6ce, 0x698, 0x3b, 0x62e, 0x6d5, 0x631, 0x645, 0x627, 0x646, 0x627, 0x646, 0x3b, 0x695, 0x6d5, 0x632, 0x628, 0x6d5,
0x631, 0x3b, 0x62e, 0x6d5, 0x632, 0x6d5, 0x6b5, 0x648, 0x6d5, 0x631, 0x3b, 0x633, 0x6d5, 0x631, 0x645, 0x627, 0x648, 0x6d5, 0x632, 0x3b,
0x628, 0x6d5, 0x641, 0x631, 0x627, 0x646, 0x628, 0x627, 0x631, 0x3b, 0x695, 0x6ce, 0x628, 0x6d5, 0x646, 0x62f, 0x627, 0x646, 0x3b, 0x631,
0x6d5, 0x634, 0x6d5, 0x645, 0x6ce, 0x3b
};
// GENERATED PART ENDS HERE

QT_END_NAMESPACE

#endif
