/*
 * Decompiled with CFR 0.152.
 */
package processing.app.linux;

import java.awt.Font;
import java.io.File;
import javax.swing.UIManager;
import processing.app.PreferencesData;
import processing.app.legacy.PConstants;
import processing.app.linux.GTKLookAndFeelFixer;

public class Platform
extends processing.app.Platform {
    private int detectedDpi = -1;

    @Override
    public void setLookAndFeel() throws Exception {
        System.setProperty("sun.desktop", "gnome");
        super.setLookAndFeel();
        GTKLookAndFeelFixer.installGtkPopupBugWorkaround();
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        File home = new File(System.getProperty("user.home"));
        return new File(home, "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        String launcher;
        if (this.openFolderAvailable() && (launcher = PreferencesData.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (PreferencesData.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            PreferencesData.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception p) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p2.waitFor();
                PreferencesData.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception p2) {
                try {
                    Process p3 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p3.waitFor();
                    PreferencesData.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String launcher = PreferencesData.get("launcher");
            try {
                String[] params = new String[]{launcher, file.getAbsolutePath()};
                Runtime.getRuntime().exec(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }

    @Override
    public String getName() {
        return PConstants.platformNames[3];
    }

    @Override
    public int getSystemDPI() {
        if (this.detectedDpi != -1) {
            return this.detectedDpi;
        }
        Font menuFont = UIManager.getFont("Menu.font");
        this.detectedDpi = menuFont.getSize() * 96 / 12;
        return this.detectedDpi;
    }
}

