/* application-account-interface.c generated by valac 0.56.3, the Vala compiler
 * generated from application-account-interface.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "geary-engine.h"
#include "geary-client-43.0.h"
#include <gee.h>
#include <glib.h>

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;
enum  {
	APPLICATION_ACCOUNT_INTERFACE_ACCOUNT_AVAILABLE_SIGNAL,
	APPLICATION_ACCOUNT_INTERFACE_ACCOUNT_UNAVAILABLE_SIGNAL,
	APPLICATION_ACCOUNT_INTERFACE_NUM_SIGNALS
};
static guint application_account_interface_signals[APPLICATION_ACCOUNT_INTERFACE_NUM_SIGNALS] = {0};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
VALA_EXTERN ApplicationAccountContext* application_account_interface_get_context_for_account (ApplicationAccountInterface* self,
                                                                                  GearyAccountInformation* account);
VALA_EXTERN GeeCollection* application_account_interface_get_account_contexts (ApplicationAccountInterface* self);
static GType application_account_interface_get_type_once (void);

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

/** Returns a context for an account, if any. */
ApplicationAccountContext*
application_account_interface_get_context_for_account (ApplicationAccountInterface* self,
                                                       GearyAccountInformation* account)
{
	ApplicationAccountInterfaceIface* _iface_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_INTERFACE (self), NULL);
	_iface_ = APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_context_for_account) {
		return _iface_->get_context_for_account (self, account);
	}
	return NULL;
}

/** Returns a read-only collection of contexts each active account. */
GeeCollection*
application_account_interface_get_account_contexts (ApplicationAccountInterface* self)
{
	ApplicationAccountInterfaceIface* _iface_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_INTERFACE (self), NULL);
	_iface_ = APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_account_contexts) {
		return _iface_->get_account_contexts (self);
	}
	return NULL;
}

static void
application_account_interface_default_init (ApplicationAccountInterfaceIface * iface,
                                            gpointer iface_data)
{
	/**
	     * Emitted when an account is added or is enabled.
	     *
	     * This will be emitted after an account is opened and added to
	     * the controller.
	     *
	     * The `is_startup` argument will be true if the application is in
	     * the middle of starting up, otherwise if the account was newly
	     * added when the application was already running then it will be
	     * false.
	     */
	application_account_interface_signals[APPLICATION_ACCOUNT_INTERFACE_ACCOUNT_AVAILABLE_SIGNAL] = g_signal_new ("account-available", APPLICATION_TYPE_ACCOUNT_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, APPLICATION_TYPE_ACCOUNT_CONTEXT, G_TYPE_BOOLEAN);
	/**
	     * Emitted when an account is removed or is disabled.
	     *
	     * This will be emitted after the account is removed from the
	     * controller's collection of accounts, but before the {@link
	     * AccountContext.cancellable} is cancelled and before the account
	     * itself is closed.
	     *
	     * The `is_shutdown` argument will be true if the application is
	     * in the middle of quitting, otherwise if the account was simply
	     * removed but the application will keep running, then it will be
	     * false.
	     */
	application_account_interface_signals[APPLICATION_ACCOUNT_INTERFACE_ACCOUNT_UNAVAILABLE_SIGNAL] = g_signal_new ("account-unavailable", APPLICATION_TYPE_ACCOUNT_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, APPLICATION_TYPE_ACCOUNT_CONTEXT, G_TYPE_BOOLEAN);
}

/**
 * Application interface for objects that manage accounts.
 *
 * This interface allows non-core application components to access the
 * application's account context objects. Typically this is
 * implemented by {@link Controller}.
 *
 * It also supports unit testing these components without having to
 * load the complete application by providing mock instances of this
 * interface instead of a fully initialised controller.
 */
static GType
application_account_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationAccountInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_account_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType application_account_interface_type_id;
	application_account_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "ApplicationAccountInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (application_account_interface_type_id, G_TYPE_OBJECT);
	return application_account_interface_type_id;
}

GType
application_account_interface_get_type (void)
{
	static volatile gsize application_account_interface_type_id__once = 0;
	if (g_once_init_enter (&application_account_interface_type_id__once)) {
		GType application_account_interface_type_id;
		application_account_interface_type_id = application_account_interface_get_type_once ();
		g_once_init_leave (&application_account_interface_type_id__once, application_account_interface_type_id);
	}
	return application_account_interface_type_id__once;
}

