/* plugin-folder.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-folder.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>

static GType plugin_folder_get_type_once (void);

const gchar*
plugin_folder_get_persistent_id (PluginFolder* self)
{
	PluginFolderIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER (self), NULL);
	_iface_ = PLUGIN_FOLDER_GET_INTERFACE (self);
	if (_iface_->get_persistent_id) {
		return _iface_->get_persistent_id (self);
	}
	return NULL;
}

const gchar*
plugin_folder_get_display_name (PluginFolder* self)
{
	PluginFolderIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER (self), NULL);
	_iface_ = PLUGIN_FOLDER_GET_INTERFACE (self);
	if (_iface_->get_display_name) {
		return _iface_->get_display_name (self);
	}
	return NULL;
}

GearyFolderSpecialUse
plugin_folder_get_used_as (PluginFolder* self)
{
	PluginFolderIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER (self), 0);
	_iface_ = PLUGIN_FOLDER_GET_INTERFACE (self);
	if (_iface_->get_used_as) {
		return _iface_->get_used_as (self);
	}
	return 0;
}

PluginAccount*
plugin_folder_get_account (PluginFolder* self)
{
	PluginFolderIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER (self), NULL);
	_iface_ = PLUGIN_FOLDER_GET_INTERFACE (self);
	if (_iface_->get_account) {
		return _iface_->get_account (self);
	}
	return NULL;
}

/**
     * Returns a variant identifying this account and folder.
     *
     * This value can be used to obtain folders from {@link
     * FolderStore}, and is suitable to be used as the `show-folder`
     * application action parameter.
     *
     * @see FolderStore.get_folder_for_variant
     * @see FolderStore.folder_variant_type
     */
GVariant*
plugin_folder_to_variant (PluginFolder* self)
{
	PluginFolderIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER (self), NULL);
	_iface_ = PLUGIN_FOLDER_GET_INTERFACE (self);
	if (_iface_->to_variant) {
		return _iface_->to_variant (self);
	}
	return NULL;
}

static void
plugin_folder_default_init (PluginFolderIface * iface,
                            gpointer iface_data)
{
	/**
	     * Returns a unique identifier for this account and folder.
	     *
	     * The value returned is persistent across application restarts.
	     */
	g_object_interface_install_property (iface, g_param_spec_string ("persistent-id", "persistent-id", "persistent-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the human-readable name of this folder. */
	g_object_interface_install_property (iface, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the type of this folder. */
	g_object_interface_install_property (iface, g_param_spec_enum ("used-as", "used-as", "used-as", GEARY_FOLDER_TYPE_SPECIAL_USE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the account the folder belongs to, if any. */
	g_object_interface_install_property (iface, g_param_spec_object ("account", "account", "account", PLUGIN_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * An object representing a folder for use by plugins.
 *
 * Instances of these may be obtained from {@link FolderStore}.
 */
static GType
plugin_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginFolderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_folder_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_folder_type_id;
	plugin_folder_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginFolder", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_folder_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_folder_type_id;
}

GType
plugin_folder_get_type (void)
{
	static volatile gsize plugin_folder_type_id__once = 0;
	if (g_once_init_enter (&plugin_folder_type_id__once)) {
		GType plugin_folder_type_id;
		plugin_folder_type_id = plugin_folder_get_type_once ();
		g_once_init_leave (&plugin_folder_type_id__once, plugin_folder_type_id);
	}
	return plugin_folder_type_id__once;
}

